/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDivElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDivElement.h"
#include "KURL.h"

#include <kjs/JSNumberCell.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDivElement)

/* Hash table */

static const HashTableValue JSHTMLDivElementTableValues[3] =
{
    { "align", DontDelete, (intptr_t)jsHTMLDivElementAlign, (intptr_t)setJSHTMLDivElementAlign },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDivElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDivElementTable = { 7, JSHTMLDivElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLDivElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDivElementConstructorTable = { 0, JSHTMLDivElementConstructorTableValues, 0 };

class JSHTMLDivElementConstructor : public DOMObject {
public:
    JSHTMLDivElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLDivElementConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDivElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLDivElementConstructor::s_info = { "HTMLDivElementConstructor", 0, &JSHTMLDivElementConstructorTable, 0 };

bool JSHTMLDivElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDivElementConstructor, DOMObject>(exec, &JSHTMLDivElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDivElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDivElementPrototypeTable = { 0, JSHTMLDivElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLDivElementPrototype::s_info = { "HTMLDivElementPrototype", 0, &JSHTMLDivElementPrototypeTable, 0 };

JSObject* JSHTMLDivElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLDivElement>(exec);
}

const ClassInfo JSHTMLDivElement::s_info = { "HTMLDivElement", &JSHTMLElement::s_info, &JSHTMLDivElementTable , 0 };

JSHTMLDivElement::JSHTMLDivElement(PassRefPtr<StructureID> structure, PassRefPtr<HTMLDivElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLDivElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLDivElementPrototype(JSHTMLDivElementPrototype::createStructureID(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLDivElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDivElement, Base>(exec, &JSHTMLDivElementTable, this, propertyName, slot);
}

JSValue* jsHTMLDivElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDivElement* imp = static_cast<HTMLDivElement*>(static_cast<JSHTMLDivElement*>(slot.slotBase())->impl());
    return jsString(exec, imp->align());
}

JSValue* jsHTMLDivElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDivElement*>(slot.slotBase())->getConstructor(exec);
}
void JSHTMLDivElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDivElement, Base>(exec, propertyName, value, &JSHTMLDivElementTable, this, slot);
}

void setJSHTMLDivElementAlign(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLDivElement* imp = static_cast<HTMLDivElement*>(static_cast<JSHTMLDivElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

JSValue* JSHTMLDivElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLDivElementConstructor>(exec);
}


}
