/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSFileList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "ExceptionCode.h"
#include "File.h"
#include "FileList.h"
#include "JSFile.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFileList)

/* Hash table */

static const HashTableValue JSFileListTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsFileListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsFileListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSFileListTable = { 15, JSFileListTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSFileListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSFileListConstructorTable = { 0, JSFileListConstructorTableValues, 0 };

class JSFileListConstructor : public DOMObject {
public:
    JSFileListConstructor(ExecState* exec)
        : DOMObject(JSFileListConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSFileListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSFileListConstructor::s_info = { "FileListConstructor", 0, &JSFileListConstructorTable, 0 };

bool JSFileListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileListConstructor, DOMObject>(exec, &JSFileListConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSFileListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)jsFileListPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSFileListPrototypeTable = { 0, JSFileListPrototypeTableValues, 0 };

const ClassInfo JSFileListPrototype::s_info = { "FileListPrototype", 0, &JSFileListPrototypeTable, 0 };

JSObject* JSFileListPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSFileList>(exec);
}

bool JSFileListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSFileListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSFileList::s_info = { "FileList", 0, &JSFileListTable , 0 };

JSFileList::JSFileList(PassRefPtr<StructureID> structure, PassRefPtr<FileList> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSFileList::~JSFileList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSFileList::createPrototype(ExecState* exec)
{
    return new (exec) JSFileListPrototype(JSFileListPrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSFileList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSFileListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<FileList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSFileList, Base>(exec, &JSFileListTable, this, propertyName, slot);
}

bool JSFileList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<FileList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* jsFileListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    FileList* imp = static_cast<FileList*>(static_cast<JSFileList*>(slot.slotBase())->impl());
    return jsNumber(exec, imp->length());
}

JSValue* jsFileListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSFileList*>(slot.slotBase())->getConstructor(exec);
}
void JSFileList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<FileList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSFileList::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSFileListConstructor>(exec);
}

JSValue* jsFileListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSFileList::s_info))
        return throwError(exec, TypeError);
    JSFileList* castedThisObj = static_cast<JSFileList*>(thisValue);
    FileList* imp = static_cast<FileList*>(castedThisObj->impl());
    int index = args.at(exec, 0)->toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return jsUndefined();
    }


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSFileList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSFileList* thisObj = static_cast<JSFileList*>(slot.slotBase());
    return toJS(exec, static_cast<FileList*>(thisObj->impl())->item(slot.index()));
}
JSC::JSValue* toJS(JSC::ExecState* exec, FileList* object)
{
    return getDOMObjectWrapper<JSFileList>(exec, object);
}
FileList* toFileList(JSC::JSValue* val)
{
    return val->isObject(&JSFileList::s_info) ? static_cast<JSFileList*>(val)->impl() : 0;
}

}
