/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDatabase.h"

#include <wtf/GetPtr.h>

#include "Database.h"
#include "KURL.h"

#include <kjs/Error.h>
#include <kjs/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDatabase)

/* Hash table */

static const HashTableValue JSDatabaseTableValues[2] =
{
    { "version", DontDelete|ReadOnly, (intptr_t)jsDatabaseVersion, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDatabaseTable = { 0, JSDatabaseTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSDatabasePrototypeTableValues[3] =
{
    { "changeVersion", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionChangeVersion, (intptr_t)5 },
    { "transaction", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionTransaction, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDatabasePrototypeTable = { 1, JSDatabasePrototypeTableValues, 0 };

const ClassInfo JSDatabasePrototype::s_info = { "DatabasePrototype", 0, &JSDatabasePrototypeTable, 0 };

JSObject* JSDatabasePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDatabase>(exec);
}

bool JSDatabasePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDatabasePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDatabase::s_info = { "Database", 0, &JSDatabaseTable , 0 };

JSDatabase::JSDatabase(PassRefPtr<StructureID> structure, PassRefPtr<Database> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDatabase::~JSDatabase()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDatabase::createPrototype(ExecState* exec)
{
    return new (exec) JSDatabasePrototype(JSDatabasePrototype::createStructureID(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDatabase::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDatabase, Base>(exec, &JSDatabaseTable, this, propertyName, slot);
}

JSValue* jsDatabaseVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Database* imp = static_cast<Database*>(static_cast<JSDatabase*>(slot.slotBase())->impl());
    return jsString(exec, imp->version());
}

JSValue* jsDatabasePrototypeFunctionChangeVersion(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(thisValue);
    return castedThisObj->changeVersion(exec, args);
}

JSValue* jsDatabasePrototypeFunctionTransaction(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(thisValue);
    return castedThisObj->transaction(exec, args);
}

JSC::JSValue* toJS(JSC::ExecState* exec, Database* object)
{
    return getDOMObjectWrapper<JSDatabase>(exec, object);
}
Database* toDatabase(JSC::JSValue* val)
{
    return val->isObject(&JSDatabase::s_info) ? static_cast<JSDatabase*>(val)->impl() : 0;
}

}
