/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSVariablesRule.h"

#include <wtf/GetPtr.h>

#include "CSSVariablesDeclaration.h"
#include "CSSVariablesRule.h"
#include "JSCSSVariablesDeclaration.h"
#include "JSMediaList.h"
#include "MediaList.h"

#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSVariablesRule)

/* Hash table */

static const HashTableValue JSCSSVariablesRuleTableValues[4] =
{
    { "media", DontDelete|ReadOnly, (intptr_t)jsCSSVariablesRuleMedia, (intptr_t)0 },
    { "variables", DontDelete|ReadOnly, (intptr_t)jsCSSVariablesRuleVariables, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSVariablesRuleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRuleTable = { 15, JSCSSVariablesRuleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSVariablesRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRuleConstructorTable = { 0, JSCSSVariablesRuleConstructorTableValues, 0 };

class JSCSSVariablesRuleConstructor : public DOMObject {
public:
    JSCSSVariablesRuleConstructor(ExecState* exec)
        : DOMObject(JSCSSVariablesRuleConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSVariablesRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSVariablesRuleConstructor::s_info = { "CSSVariablesRuleConstructor", 0, &JSCSSVariablesRuleConstructorTable, 0 };

bool JSCSSVariablesRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRuleConstructor, DOMObject>(exec, &JSCSSVariablesRuleConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSVariablesRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSVariablesRulePrototypeTable = { 0, JSCSSVariablesRulePrototypeTableValues, 0 };

const ClassInfo JSCSSVariablesRulePrototype::s_info = { "CSSVariablesRulePrototype", 0, &JSCSSVariablesRulePrototypeTable, 0 };

JSObject* JSCSSVariablesRulePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSVariablesRule>(exec);
}

const ClassInfo JSCSSVariablesRule::s_info = { "CSSVariablesRule", &JSCSSRule::s_info, &JSCSSVariablesRuleTable , 0 };

JSCSSVariablesRule::JSCSSVariablesRule(PassRefPtr<StructureID> structure, PassRefPtr<CSSVariablesRule> impl)
    : JSCSSRule(structure, impl)
{
}

JSObject* JSCSSVariablesRule::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSVariablesRulePrototype(JSCSSVariablesRulePrototype::createStructureID(JSCSSRulePrototype::self(exec)));
}

bool JSCSSVariablesRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSVariablesRule, Base>(exec, &JSCSSVariablesRuleTable, this, propertyName, slot);
}

JSValue* jsCSSVariablesRuleMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(static_cast<JSCSSVariablesRule*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->media()));
}

JSValue* jsCSSVariablesRuleVariables(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSVariablesRule* imp = static_cast<CSSVariablesRule*>(static_cast<JSCSSVariablesRule*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->variables()));
}

JSValue* jsCSSVariablesRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSVariablesRule*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSCSSVariablesRule::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSVariablesRuleConstructor>(exec);
}


}
