/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSMediaRule.h"

#include <wtf/GetPtr.h>

#include "CSSMediaRule.h"
#include "CSSRuleList.h"
#include "JSCSSRuleList.h"
#include "JSMediaList.h"
#include "MediaList.h"

#include <kjs/Error.h>
#include <kjs/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSMediaRule)

/* Hash table */

static const HashTableValue JSCSSMediaRuleTableValues[4] =
{
    { "media", DontDelete|ReadOnly, (intptr_t)jsCSSMediaRuleMedia, (intptr_t)0 },
    { "cssRules", DontDelete|ReadOnly, (intptr_t)jsCSSMediaRuleCssRules, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSMediaRuleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRuleTable = { 7, JSCSSMediaRuleTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSCSSMediaRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRuleConstructorTable = { 0, JSCSSMediaRuleConstructorTableValues, 0 };

class JSCSSMediaRuleConstructor : public DOMObject {
public:
    JSCSSMediaRuleConstructor(ExecState* exec)
        : DOMObject(JSCSSMediaRuleConstructor::createStructureID(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSMediaRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<StructureID> createStructureID(JSValue* proto) 
    { 
        return StructureID::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSMediaRuleConstructor::s_info = { "CSSMediaRuleConstructor", 0, &JSCSSMediaRuleConstructorTable, 0 };

bool JSCSSMediaRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRuleConstructor, DOMObject>(exec, &JSCSSMediaRuleConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSMediaRulePrototypeTableValues[3] =
{
    { "insertRule", DontDelete|Function, (intptr_t)jsCSSMediaRulePrototypeFunctionInsertRule, (intptr_t)2 },
    { "deleteRule", DontDelete|Function, (intptr_t)jsCSSMediaRulePrototypeFunctionDeleteRule, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSMediaRulePrototypeTable = { 1, JSCSSMediaRulePrototypeTableValues, 0 };

const ClassInfo JSCSSMediaRulePrototype::s_info = { "CSSMediaRulePrototype", 0, &JSCSSMediaRulePrototypeTable, 0 };

JSObject* JSCSSMediaRulePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSMediaRule>(exec);
}

bool JSCSSMediaRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSMediaRulePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSMediaRule::s_info = { "CSSMediaRule", &JSCSSRule::s_info, &JSCSSMediaRuleTable , 0 };

JSCSSMediaRule::JSCSSMediaRule(PassRefPtr<StructureID> structure, PassRefPtr<CSSMediaRule> impl)
    : JSCSSRule(structure, impl)
{
}

JSObject* JSCSSMediaRule::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSMediaRulePrototype(JSCSSMediaRulePrototype::createStructureID(JSCSSRulePrototype::self(exec)));
}

bool JSCSSMediaRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSMediaRule, Base>(exec, &JSCSSMediaRuleTable, this, propertyName, slot);
}

JSValue* jsCSSMediaRuleMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(static_cast<JSCSSMediaRule*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->media()));
}

JSValue* jsCSSMediaRuleCssRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(static_cast<JSCSSMediaRule*>(slot.slotBase())->impl());
    return toJS(exec, WTF::getPtr(imp->cssRules()));
}

JSValue* jsCSSMediaRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSMediaRule*>(slot.slotBase())->getConstructor(exec);
}
JSValue* JSCSSMediaRule::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSMediaRuleConstructor>(exec);
}

JSValue* jsCSSMediaRulePrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisValue);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args.at(exec, 0)->toString(exec);
    unsigned index = args.at(exec, 1)->toInt32(exec);


    JSC::JSValue* result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsCSSMediaRulePrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSMediaRule::s_info))
        return throwError(exec, TypeError);
    JSCSSMediaRule* castedThisObj = static_cast<JSCSSMediaRule*>(thisValue);
    CSSMediaRule* imp = static_cast<CSSMediaRule*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
