/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the plugins of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef LINUXISKBDHANDLER_H
#define LINUXISKBDHANDLER_H

#include <QObject>
#include <QWSKeyboardHandler>

class QSocketNotifier;
class LinuxInputSubsystemKbdHandler : public QObject, public QWSKeyboardHandler {
    Q_OBJECT
public:
    LinuxInputSubsystemKbdHandler(const QString &device = QString("/dev/input/event0"));
    ~LinuxInputSubsystemKbdHandler();

    struct keytable_s {
	int code;
	int unicode;
	int keycode;
    };

    struct keymap_s {
	int unicode;
	int keycode;
    };

private:
    void initmap();

    QSocketNotifier *m_notify;
    int  kbdFD;
    bool shift;

    static struct keytable_s keytable[];
    static struct keymap_s keymap[];

private Q_SLOTS:
    void readKbdData();
};

#endif // LINUXISKBDHANDLER_H
