/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMSelection.h"

#include <wtf/GetPtr.h>

#include "DOMSelection.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMSelection)

/* Hash table */

static const HashTableValue JSDOMSelectionTableValues[12] =
{
    { "anchorNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionAnchorNode, (intptr_t)0 },
    { "anchorOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionAnchorOffset, (intptr_t)0 },
    { "focusNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionFocusNode, (intptr_t)0 },
    { "focusOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionFocusOffset, (intptr_t)0 },
    { "baseNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionBaseNode, (intptr_t)0 },
    { "baseOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionBaseOffset, (intptr_t)0 },
    { "extentNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionExtentNode, (intptr_t)0 },
    { "extentOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionExtentOffset, (intptr_t)0 },
    { "isCollapsed", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionIsCollapsed, (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionType, (intptr_t)0 },
    { "rangeCount", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionRangeCount, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMSelectionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSDOMSelectionTableValues, 0 };
#else
    { 34, 31, JSDOMSelectionTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDOMSelectionPrototypeTableValues[16] =
{
    { "collapse", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapse, (intptr_t)2 },
    { "collapseToEnd", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapseToEnd, (intptr_t)0 },
    { "collapseToStart", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapseToStart, (intptr_t)0 },
    { "deleteFromDocument", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionDeleteFromDocument, (intptr_t)0 },
    { "containsNode", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionContainsNode, (intptr_t)2 },
    { "selectAllChildren", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSelectAllChildren, (intptr_t)1 },
    { "empty", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionEmpty, (intptr_t)0 },
    { "setBaseAndExtent", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSetBaseAndExtent, (intptr_t)4 },
    { "setPosition", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSetPosition, (intptr_t)2 },
    { "modify", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionModify, (intptr_t)3 },
    { "extend", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionExtend, (intptr_t)2 },
    { "getRangeAt", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionGetRangeAt, (intptr_t)1 },
    { "removeAllRanges", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionRemoveAllRanges, (intptr_t)0 },
    { "addRange", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionAddRange, (intptr_t)1 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsDOMSelectionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMSelectionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSDOMSelectionPrototypeTableValues, 0 };
#else
    { 34, 31, JSDOMSelectionPrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMSelectionPrototype::s_info = { "DOMSelectionPrototype", 0, &JSDOMSelectionPrototypeTable, 0 };

JSObject* JSDOMSelectionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDOMSelection>(exec);
}

bool JSDOMSelectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMSelectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMSelection::s_info = { "DOMSelection", 0, &JSDOMSelectionTable, 0 };

JSDOMSelection::JSDOMSelection(PassRefPtr<Structure> structure, PassRefPtr<DOMSelection> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDOMSelection::~JSDOMSelection()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDOMSelection::createPrototype(ExecState* exec)
{
    return new (exec) JSDOMSelectionPrototype(JSDOMSelectionPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDOMSelection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSelection, Base>(exec, &JSDOMSelectionTable, this, propertyName, slot);
}

JSValuePtr jsDOMSelectionAnchorNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->anchorNode()));
}

JSValuePtr jsDOMSelectionAnchorOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->anchorOffset());
}

JSValuePtr jsDOMSelectionFocusNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->focusNode()));
}

JSValuePtr jsDOMSelectionFocusOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->focusOffset());
}

JSValuePtr jsDOMSelectionBaseNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->baseNode()));
}

JSValuePtr jsDOMSelectionBaseOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->baseOffset());
}

JSValuePtr jsDOMSelectionExtentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->extentNode()));
}

JSValuePtr jsDOMSelectionExtentOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->extentOffset());
}

JSValuePtr jsDOMSelectionIsCollapsed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->isCollapsed());
}

JSValuePtr jsDOMSelectionType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsDOMSelectionRangeCount(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->rangeCount());
}

JSValuePtr jsDOMSelectionPrototypeFunctionCollapse(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int index = args.at(exec, 1)->toInt32(exec);

    imp->collapse(node, index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionCollapseToEnd(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->collapseToEnd();
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionCollapseToStart(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->collapseToStart();
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionDeleteFromDocument(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->deleteFromDocument();
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionContainsNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    Node* node = toNode(args.at(exec, 0));
    bool allowPartial = args.at(exec, 1)->toBoolean(exec);


    JSC::JSValuePtr result = jsBoolean(imp->containsNode(node, allowPartial));
    return result;
}

JSValuePtr jsDOMSelectionPrototypeFunctionSelectAllChildren(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));

    imp->selectAllChildren(node, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionEmpty(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->empty();
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionSetBaseAndExtent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* baseNode = toNode(args.at(exec, 0));
    int baseOffset = args.at(exec, 1)->toInt32(exec);
    Node* extentNode = toNode(args.at(exec, 2));
    int extentOffset = args.at(exec, 3)->toInt32(exec);

    imp->setBaseAndExtent(baseNode, baseOffset, extentNode, extentOffset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionSetPosition(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int offset = args.at(exec, 1)->toInt32(exec);

    imp->setPosition(node, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionModify(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    const UString& alter = args.at(exec, 0)->toString(exec);
    const UString& direction = args.at(exec, 1)->toString(exec);
    const UString& granularity = args.at(exec, 2)->toString(exec);

    imp->modify(alter, direction, granularity);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionExtend(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int offset = args.at(exec, 1)->toInt32(exec);

    imp->extend(node, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionGetRangeAt(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getRangeAt(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDOMSelectionPrototypeFunctionRemoveAllRanges(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->removeAllRanges();
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionAddRange(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    Range* range = toRange(args.at(exec, 0));

    imp->addRange(range);
    return jsUndefined();
}

JSValuePtr jsDOMSelectionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsString(exec, imp->toString());
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, DOMSelection* object)
{
    return getDOMObjectWrapper<JSDOMSelection>(exec, object);
}
DOMSelection* toDOMSelection(JSC::JSValuePtr value)
{
    return value->isObject(&JSDOMSelection::s_info) ? static_cast<JSDOMSelection*>(asObject(value))->impl() : 0;
}

}
