/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the example classes of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#ifndef FILTEREXAMPLE_H
#define FILTEREXAMPLE_H

#include <QPainter>
#include <QPixmapFilter>
#include <QWidget>

#include "ui_valuecontrols.h"

QT_BEGIN_NAMESPACE
class QComboBox;
class QLabel;
QT_END_NAMESPACE

class FilterWidget: public QWidget
{
    Q_OBJECT
public:
    FilterWidget(const QPixmap &background, const QPixmap &icon, const Ui::ValueControls &control);
    void paintEvent (QPaintEvent * event);
    void setType(QPixmapFilter::FilterType filterType);

public slots:
    void setType(int filterType);

//![0]
private:
    QPixmap sourcePixmap;
    QPixmap backgroundPixmap;
    QPixmapFilter *setupFilter(QPixmapFilter::FilterType type);

    Ui::ValueControls controls;
    QPixmapFilter::FilterType type;
//![0]
};


class FilterExample : public QWidget
{
    Q_OBJECT

public:
    FilterExample();

private:
    QLabel *sourceLabel;
    QComboBox *filterComboBox;
    FilterWidget *resultWidget;
    QWidget *controlWidget;

    QPixmap sourcePixmap;
    QPixmap backgroundPixmap;

    Ui::ValueControls controls;
};

#endif
