/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the example classes of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include <QtGui>
#include <QtSvg>
#include "mimedata.h"
#include "sourcewidget.h"

SourceWidget::SourceWidget(QWidget *parent)
    : QWidget(parent)
{
    QFile imageFile(":/images/example.svg");
    imageFile.open(QIODevice::ReadOnly);
    imageData = imageFile.readAll();
    imageFile.close();

    QScrollArea *imageArea = new QScrollArea;
    imageLabel = new QSvgWidget;
    imageLabel->renderer()->load(imageData);
    imageArea->setWidget(imageLabel);
    //imageLabel->setMinimumSize(imageLabel->renderer()->viewBox().size());

    QLabel *instructTopLabel = new QLabel(tr("This is an SVG drawing:"));
    QLabel *instructBottomLabel = new QLabel(
        tr("Drag the icon to copy the drawing as a PNG file:"));
    QPushButton *dragIcon = new QPushButton(tr("Export"));
    dragIcon->setIcon(QIcon(":/images/drag.png"));

    connect(dragIcon, SIGNAL(pressed()), this, SLOT(startDrag()));

    QGridLayout *layout = new QGridLayout;
    layout->addWidget(instructTopLabel, 0, 0, 1, 2);
    layout->addWidget(imageArea, 1, 0, 2, 2);
    layout->addWidget(instructBottomLabel, 3, 0);
    layout->addWidget(dragIcon, 3, 1);
    setLayout(layout);
    setWindowTitle(tr("Delayed Encoding"));
}

//![1]
void SourceWidget::createData(const QString &mimeType)
{
    if (mimeType != "image/png")
        return;

    QImage image(imageLabel->size(), QImage::Format_RGB32);
    QPainter painter;
    painter.begin(&image);
    imageLabel->renderer()->render(&painter);
    painter.end();

    QByteArray data;
    QBuffer buffer(&data);
    buffer.open(QIODevice::WriteOnly);
    image.save(&buffer, "PNG");
    buffer.close();

    mimeData->setData("image/png", data);
}
//![1]

//![0]
void SourceWidget::startDrag()
{
    mimeData = new MimeData;

    connect(mimeData, SIGNAL(dataRequested(const QString &)),
            this, SLOT(createData(const QString &)), Qt::DirectConnection);

    QDrag *drag = new QDrag(this);
    drag->setMimeData(mimeData);
    drag->setPixmap(QPixmap(":/images/drag.png"));

    drag->exec(Qt::CopyAction);
}
//![0]

