/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSXMLHttpRequest_h
#define JSXMLHttpRequest_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class XMLHttpRequest;

class JSXMLHttpRequest : public DOMObject {
    typedef DOMObject Base;
public:
    JSXMLHttpRequest(PassRefPtr<JSC::Structure>, PassRefPtr<XMLHttpRequest>);
    virtual ~JSXMLHttpRequest();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }

    virtual void mark();


    // Custom attributes
    JSC::JSValue* responseText(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue* open(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* setRequestHeader(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* send(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* getResponseHeader(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* overrideMimeType(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue* removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    XMLHttpRequest* impl() const { return m_impl.get(); }

private:
    RefPtr<XMLHttpRequest> m_impl;
};

JSC::JSValue* toJS(JSC::ExecState*, XMLHttpRequest*);
XMLHttpRequest* toXMLHttpRequest(JSC::JSValue*);

class JSXMLHttpRequestPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSXMLHttpRequestPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsXMLHttpRequestPrototypeFunctionOpen(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionSetRequestHeader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionSend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionAbort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionGetResponseHeader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionOverrideMimeType(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsXMLHttpRequestPrototypeFunctionDispatchEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attributes

JSC::JSValue* jsXMLHttpRequestOnabort(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestOnerror(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestOnload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestOnloadstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestOnprogress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnprogress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestOnreadystatechange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSXMLHttpRequestOnreadystatechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsXMLHttpRequestReadyState(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestUpload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestResponseText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestResponseXML(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestStatusText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
// Constants

JSC::JSValue* jsXMLHttpRequestUNSENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestOPENED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestHEADERS_RECEIVED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestLOADING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsXMLHttpRequestDONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
