/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSUIEvent.h"

#include <wtf/GetPtr.h>

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "UIEvent.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSUIEvent)

/* Hash table */

static const HashTableValue JSUIEventTableValues[11] =
{
    { "view", DontDelete|ReadOnly, (intptr_t)jsUIEventView, (intptr_t)0 },
    { "detail", DontDelete|ReadOnly, (intptr_t)jsUIEventDetail, (intptr_t)0 },
    { "keyCode", DontDelete|ReadOnly, (intptr_t)jsUIEventKeyCode, (intptr_t)0 },
    { "charCode", DontDelete|ReadOnly, (intptr_t)jsUIEventCharCode, (intptr_t)0 },
    { "layerX", DontDelete|ReadOnly, (intptr_t)jsUIEventLayerX, (intptr_t)0 },
    { "layerY", DontDelete|ReadOnly, (intptr_t)jsUIEventLayerY, (intptr_t)0 },
    { "pageX", DontDelete|ReadOnly, (intptr_t)jsUIEventPageX, (intptr_t)0 },
    { "pageY", DontDelete|ReadOnly, (intptr_t)jsUIEventPageY, (intptr_t)0 },
    { "which", DontDelete|ReadOnly, (intptr_t)jsUIEventWhich, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsUIEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSUIEventTableValues, 0 };
#else
    { 34, 31, JSUIEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSUIEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSUIEventConstructorTableValues, 0 };
#else
    { 1, 0, JSUIEventConstructorTableValues, 0 };
#endif

class JSUIEventConstructor : public DOMObject {
public:
    JSUIEventConstructor(ExecState* exec)
        : DOMObject(JSUIEventConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSUIEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSUIEventConstructor::s_info = { "UIEventConstructor", 0, &JSUIEventConstructorTable, 0 };

bool JSUIEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEventConstructor, DOMObject>(exec, &JSUIEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSUIEventPrototypeTableValues[2] =
{
    { "initUIEvent", DontDelete|Function, (intptr_t)jsUIEventPrototypeFunctionInitUIEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSUIEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSUIEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSUIEventPrototype::s_info = { "UIEventPrototype", 0, &JSUIEventPrototypeTable, 0 };

JSObject* JSUIEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSUIEvent>(exec);
}

bool JSUIEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSUIEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSUIEvent::s_info = { "UIEvent", &JSEvent::s_info, &JSUIEventTable, 0 };

JSUIEvent::JSUIEvent(PassRefPtr<Structure> structure, PassRefPtr<UIEvent> impl)
    : JSEvent(structure, impl)
{
}

JSObject* JSUIEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSUIEventPrototype(JSUIEventPrototype::createStructure(JSEventPrototype::self(exec)));
}

bool JSUIEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEvent, Base>(exec, &JSUIEventTable, this, propertyName, slot);
}

JSValue* jsUIEventView(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->view()));
}

JSValue* jsUIEventDetail(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->detail());
}

JSValue* jsUIEventKeyCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->keyCode());
}

JSValue* jsUIEventCharCode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->charCode());
}

JSValue* jsUIEventLayerX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->layerX());
}

JSValue* jsUIEventLayerY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->layerY());
}

JSValue* jsUIEventPageX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pageX());
}

JSValue* jsUIEventPageY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->pageY());
}

JSValue* jsUIEventWhich(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    UIEvent* imp = static_cast<UIEvent*>(static_cast<JSUIEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->which());
}

JSValue* jsUIEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSUIEvent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValue* JSUIEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSUIEventConstructor>(exec);
}

JSValue* jsUIEventPrototypeFunctionInitUIEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSUIEvent::s_info))
        return throwError(exec, TypeError);
    JSUIEvent* castedThisObj = static_cast<JSUIEvent*>(asObject(thisValue));
    UIEvent* imp = static_cast<UIEvent*>(castedThisObj->impl());
    const UString& type = args.at(exec, 0)->toString(exec);
    bool canBubble = args.at(exec, 1)->toBoolean(exec);
    bool cancelable = args.at(exec, 2)->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args.at(exec, 3));
    int detail = args.at(exec, 4)->toInt32(exec);

    imp->initUIEvent(type, canBubble, cancelable, view, detail);
    return jsUndefined();
}


}
