/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGMarkerElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGMarkerElement.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGMarkerElement)

/* Hash table */

static const HashTableValue JSSVGMarkerElementTableValues[16] =
{
    { "refX", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementRefX, (intptr_t)0 },
    { "refY", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementRefY, (intptr_t)0 },
    { "markerUnits", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementMarkerUnits, (intptr_t)0 },
    { "markerWidth", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementMarkerWidth, (intptr_t)0 },
    { "markerHeight", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementMarkerHeight, (intptr_t)0 },
    { "orientType", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementOrientType, (intptr_t)0 },
    { "orientAngle", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementOrientAngle, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGMarkerElementXmllang, (intptr_t)setJSSVGMarkerElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGMarkerElementXmlspace, (intptr_t)setJSSVGMarkerElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementStyle, (intptr_t)0 },
    { "viewBox", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementViewBox, (intptr_t)0 },
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementPreserveAspectRatio, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGMarkerElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGMarkerElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGMarkerElementTableValues, 0 };
#else
    { 33, 31, JSSVGMarkerElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGMarkerElementConstructorTableValues[7] =
{
    { "SVG_MARKERUNITS_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_UNKNOWN, (intptr_t)0 },
    { "SVG_MARKERUNITS_USERSPACEONUSE", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_USERSPACEONUSE, (intptr_t)0 },
    { "SVG_MARKERUNITS_STROKEWIDTH", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_STROKEWIDTH, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_UNKNOWN, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_AUTO", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_AUTO, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_ANGLE", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_ANGLE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGMarkerElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGMarkerElementConstructorTableValues, 0 };
#else
    { 16, 15, JSSVGMarkerElementConstructorTableValues, 0 };
#endif

class JSSVGMarkerElementConstructor : public DOMObject {
public:
    JSSVGMarkerElementConstructor(ExecState* exec)
        : DOMObject(JSSVGMarkerElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGMarkerElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGMarkerElementConstructor::s_info = { "SVGMarkerElementConstructor", 0, &JSSVGMarkerElementConstructorTable, 0 };

bool JSSVGMarkerElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMarkerElementConstructor, DOMObject>(exec, &JSSVGMarkerElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGMarkerElementPrototypeTableValues[10] =
{
    { "SVG_MARKERUNITS_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_UNKNOWN, (intptr_t)0 },
    { "SVG_MARKERUNITS_USERSPACEONUSE", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_USERSPACEONUSE, (intptr_t)0 },
    { "SVG_MARKERUNITS_STROKEWIDTH", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKERUNITS_STROKEWIDTH, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_UNKNOWN, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_AUTO", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_AUTO, (intptr_t)0 },
    { "SVG_MARKER_ORIENT_ANGLE", DontDelete|ReadOnly, (intptr_t)jsSVGMarkerElementSVG_MARKER_ORIENT_ANGLE, (intptr_t)0 },
    { "setOrientToAuto", DontDelete|Function, (intptr_t)jsSVGMarkerElementPrototypeFunctionSetOrientToAuto, (intptr_t)0 },
    { "setOrientToAngle", DontDelete|Function, (intptr_t)jsSVGMarkerElementPrototypeFunctionSetOrientToAngle, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGMarkerElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGMarkerElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGMarkerElementPrototypeTableValues, 0 };
#else
    { 32, 31, JSSVGMarkerElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGMarkerElementPrototype::s_info = { "SVGMarkerElementPrototype", 0, &JSSVGMarkerElementPrototypeTable, 0 };

JSObject* JSSVGMarkerElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGMarkerElement>(exec);
}

bool JSSVGMarkerElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGMarkerElementPrototype, JSObject>(exec, &JSSVGMarkerElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGMarkerElement::s_info = { "SVGMarkerElement", &JSSVGElement::s_info, &JSSVGMarkerElementTable, 0 };

JSSVGMarkerElement::JSSVGMarkerElement(PassRefPtr<Structure> structure, PassRefPtr<SVGMarkerElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGMarkerElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGMarkerElementPrototype(JSSVGMarkerElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGMarkerElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMarkerElement, Base>(exec, &JSSVGMarkerElementTable, this, propertyName, slot);
}

JSValue* jsSVGMarkerElementRefX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->refXAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementRefY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->refYAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementMarkerUnits(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->markerUnitsAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementMarkerWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->markerWidthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementMarkerHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->markerHeightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementOrientType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->orientTypeAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementOrientAngle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedAngle> obj = imp->orientAngleAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValue* jsSVGMarkerElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue* jsSVGMarkerElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValue* jsSVGMarkerElementViewBox(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedRect> obj = imp->viewBoxAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementPreserveAspectRatio(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValue* jsSVGMarkerElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGMarkerElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSSVGMarkerElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSSVGMarkerElement, Base>(exec, propertyName, value, &JSSVGMarkerElementTable, this, slot);
}

void setJSSVGMarkerElementXmllang(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGMarkerElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(static_cast<JSSVGMarkerElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValue* JSSVGMarkerElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGMarkerElementConstructor>(exec);
}

JSValue* jsSVGMarkerElementPrototypeFunctionSetOrientToAuto(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMarkerElement::s_info))
        return throwError(exec, TypeError);
    JSSVGMarkerElement* castedThisObj = static_cast<JSSVGMarkerElement*>(asObject(thisValue));
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(castedThisObj->impl());

    imp->setOrientToAuto();
    return jsUndefined();
}

JSValue* jsSVGMarkerElementPrototypeFunctionSetOrientToAngle(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMarkerElement::s_info))
        return throwError(exec, TypeError);
    JSSVGMarkerElement* castedThisObj = static_cast<JSSVGMarkerElement*>(asObject(thisValue));
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(castedThisObj->impl());
    SVGAngle* angle = toSVGAngle(args.at(exec, 0));

    imp->setOrientToAngle(angle);
    return jsUndefined();
}

JSValue* jsSVGMarkerElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGMarkerElement::s_info))
        return throwError(exec, TypeError);
    JSSVGMarkerElement* castedThisObj = static_cast<JSSVGMarkerElement*>(asObject(thisValue));
    SVGMarkerElement* imp = static_cast<SVGMarkerElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue* jsSVGMarkerElementSVG_MARKERUNITS_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGMarkerElementSVG_MARKERUNITS_USERSPACEONUSE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGMarkerElementSVG_MARKERUNITS_STROKEWIDTH(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsSVGMarkerElementSVG_MARKER_ORIENT_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsSVGMarkerElementSVG_MARKER_ORIENT_AUTO(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsSVGMarkerElementSVG_MARKER_ORIENT_ANGLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}


}

#endif // ENABLE(SVG)
