/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeList.h"

#include <wtf/GetPtr.h>

#include <runtime/PropertyNameArray.h>
#include "AtomicString.h"
#include "ExceptionCode.h"
#include "JSNode.h"
#include "Node.h"
#include "NodeList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNodeList)

/* Hash table */

static const HashTableValue JSNodeListTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsNodeListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsNodeListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSNodeListTableValues, 0 };
#else
    { 5, 3, JSNodeListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSNodeListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSNodeListConstructorTableValues, 0 };
#else
    { 1, 0, JSNodeListConstructorTableValues, 0 };
#endif

class JSNodeListConstructor : public DOMObject {
public:
    JSNodeListConstructor(ExecState* exec)
        : DOMObject(JSNodeListConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSNodeListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSNodeListConstructor::s_info = { "NodeListConstructor", 0, &JSNodeListConstructorTable, 0 };

bool JSNodeListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeListConstructor, DOMObject>(exec, &JSNodeListConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSNodeListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)jsNodeListPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSNodeListPrototypeTableValues, 0 };
#else
    { 2, 1, JSNodeListPrototypeTableValues, 0 };
#endif

const ClassInfo JSNodeListPrototype::s_info = { "NodeListPrototype", 0, &JSNodeListPrototypeTable, 0 };

JSObject* JSNodeListPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSNodeList>(exec);
}

bool JSNodeListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNodeListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeList::s_info = { "NodeList", 0, &JSNodeListTable, 0 };

JSNodeList::JSNodeList(PassRefPtr<Structure> structure, PassRefPtr<NodeList> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSNodeList::~JSNodeList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSNodeList::createPrototype(ExecState* exec)
{
    return new (exec) JSNodeListPrototype(JSNodeListPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSNodeList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSNodeListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<NodeList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NodeList*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSNodeList, Base>(exec, &JSNodeListTable, this, propertyName, slot);
}

bool JSNodeList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<NodeList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* jsNodeListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    NodeList* imp = static_cast<NodeList*>(static_cast<JSNodeList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValue* jsNodeListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSNodeList*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSNodeList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<NodeList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSNodeList::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSNodeListConstructor>(exec);
}

JSValue* jsNodeListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeList::s_info))
        return throwError(exec, TypeError);
    JSNodeList* castedThisObj = static_cast<JSNodeList*>(asObject(thisValue));
    NodeList* imp = static_cast<NodeList*>(castedThisObj->impl());
    int index = args.at(exec, 0)->toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return jsUndefined();
    }


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSNodeList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSNodeList* thisObj = static_cast<JSNodeList*>(asObject(slot.slotBase()));
    return toJS(exec, static_cast<NodeList*>(thisObj->impl())->item(slot.index()));
}
JSC::JSValue* toJS(JSC::ExecState* exec, NodeList* object)
{
    return getDOMObjectWrapper<JSNodeList>(exec, object);
}
NodeList* toNodeList(JSC::JSValue* value)
{
    return value->isObject(&JSNodeList::s_info) ? static_cast<JSNodeList*>(asObject(value))->impl() : 0;
}

}
