/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMediaElement.h"
#include "JSMediaError.h"
#include "JSTimeRanges.h"
#include "KURL.h"
#include "MediaError.h"
#include "TimeRanges.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLMediaElement)

/* Hash table */

static const HashTableValue JSHTMLMediaElementTableValues[28] =
{
    { "error", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementError, (intptr_t)0 },
    { "src", DontDelete, (intptr_t)jsHTMLMediaElementSrc, (intptr_t)setJSHTMLMediaElementSrc },
    { "currentSrc", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCurrentSrc, (intptr_t)0 },
    { "networkState", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementNetworkState, (intptr_t)0 },
    { "bufferingRate", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementBufferingRate, (intptr_t)0 },
    { "buffered", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementBuffered, (intptr_t)0 },
    { "readyState", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementReadyState, (intptr_t)0 },
    { "seeking", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementSeeking, (intptr_t)0 },
    { "currentTime", DontDelete, (intptr_t)jsHTMLMediaElementCurrentTime, (intptr_t)setJSHTMLMediaElementCurrentTime },
    { "duration", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementDuration, (intptr_t)0 },
    { "paused", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementPaused, (intptr_t)0 },
    { "defaultPlaybackRate", DontDelete, (intptr_t)jsHTMLMediaElementDefaultPlaybackRate, (intptr_t)setJSHTMLMediaElementDefaultPlaybackRate },
    { "playbackRate", DontDelete, (intptr_t)jsHTMLMediaElementPlaybackRate, (intptr_t)setJSHTMLMediaElementPlaybackRate },
    { "played", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementPlayed, (intptr_t)0 },
    { "seekable", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementSeekable, (intptr_t)0 },
    { "ended", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementEnded, (intptr_t)0 },
    { "autoplay", DontDelete, (intptr_t)jsHTMLMediaElementAutoplay, (intptr_t)setJSHTMLMediaElementAutoplay },
    { "start", DontDelete, (intptr_t)jsHTMLMediaElementStart, (intptr_t)setJSHTMLMediaElementStart },
    { "end", DontDelete, (intptr_t)jsHTMLMediaElementEnd, (intptr_t)setJSHTMLMediaElementEnd },
    { "loopStart", DontDelete, (intptr_t)jsHTMLMediaElementLoopStart, (intptr_t)setJSHTMLMediaElementLoopStart },
    { "loopEnd", DontDelete, (intptr_t)jsHTMLMediaElementLoopEnd, (intptr_t)setJSHTMLMediaElementLoopEnd },
    { "playCount", DontDelete, (intptr_t)jsHTMLMediaElementPlayCount, (intptr_t)setJSHTMLMediaElementPlayCount },
    { "currentLoop", DontDelete, (intptr_t)jsHTMLMediaElementCurrentLoop, (intptr_t)setJSHTMLMediaElementCurrentLoop },
    { "controls", DontDelete, (intptr_t)jsHTMLMediaElementControls, (intptr_t)setJSHTMLMediaElementControls },
    { "volume", DontDelete, (intptr_t)jsHTMLMediaElementVolume, (intptr_t)setJSHTMLMediaElementVolume },
    { "muted", DontDelete, (intptr_t)jsHTMLMediaElementMuted, (intptr_t)setJSHTMLMediaElementMuted },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLMediaElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLMediaElementTableValues, 0 };
#else
    { 67, 63, JSHTMLMediaElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[10] =
{
    { "EMPTY", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementEMPTY, (intptr_t)0 },
    { "LOADING", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADING, (intptr_t)0 },
    { "LOADED_METADATA", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED_METADATA, (intptr_t)0 },
    { "LOADED_FIRST_FRAME", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED_FIRST_FRAME, (intptr_t)0 },
    { "LOADED", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED, (intptr_t)0 },
    { "DATA_UNAVAILABLE", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementDATA_UNAVAILABLE, (intptr_t)0 },
    { "CAN_SHOW_CURRENT_FRAME", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_SHOW_CURRENT_FRAME, (intptr_t)0 },
    { "CAN_PLAY", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_PLAY, (intptr_t)0 },
    { "CAN_PLAY_THROUGH", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_PLAY_THROUGH, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSHTMLMediaElementConstructorTableValues, 0 };
#else
    { 33, 31, JSHTMLMediaElementConstructorTableValues, 0 };
#endif

class JSHTMLMediaElementConstructor : public DOMObject {
public:
    JSHTMLMediaElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLMediaElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMediaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue* proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLMediaElementConstructor::s_info = { "HTMLMediaElementConstructor", 0, &JSHTMLMediaElementConstructorTable, 0 };

bool JSHTMLMediaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMediaElementConstructor, DOMObject>(exec, &JSHTMLMediaElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[13] =
{
    { "EMPTY", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementEMPTY, (intptr_t)0 },
    { "LOADING", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADING, (intptr_t)0 },
    { "LOADED_METADATA", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED_METADATA, (intptr_t)0 },
    { "LOADED_FIRST_FRAME", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED_FIRST_FRAME, (intptr_t)0 },
    { "LOADED", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementLOADED, (intptr_t)0 },
    { "DATA_UNAVAILABLE", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementDATA_UNAVAILABLE, (intptr_t)0 },
    { "CAN_SHOW_CURRENT_FRAME", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_SHOW_CURRENT_FRAME, (intptr_t)0 },
    { "CAN_PLAY", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_PLAY, (intptr_t)0 },
    { "CAN_PLAY_THROUGH", DontDelete|ReadOnly, (intptr_t)jsHTMLMediaElementCAN_PLAY_THROUGH, (intptr_t)0 },
    { "load", DontDelete|Function, (intptr_t)jsHTMLMediaElementPrototypeFunctionLoad, (intptr_t)0 },
    { "play", DontDelete|Function, (intptr_t)jsHTMLMediaElementPrototypeFunctionPlay, (intptr_t)0 },
    { "pause", DontDelete|Function, (intptr_t)jsHTMLMediaElementPrototypeFunctionPause, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLMediaElementPrototypeTableValues, 0 };
#else
    { 34, 31, JSHTMLMediaElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElementPrototype", 0, &JSHTMLMediaElementPrototypeTable, 0 };

JSObject* JSHTMLMediaElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLMediaElement>(exec);
}

bool JSHTMLMediaElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSHTMLMediaElementPrototype, JSObject>(exec, &JSHTMLMediaElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement", &JSHTMLElement::s_info, &JSHTMLMediaElementTable, 0 };

JSHTMLMediaElement::JSHTMLMediaElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLMediaElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLMediaElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLMediaElementPrototype(JSHTMLMediaElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLMediaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMediaElement, Base>(exec, &JSHTMLMediaElementTable, this, propertyName, slot);
}

JSValue* jsHTMLMediaElementError(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->error()));
}

JSValue* jsHTMLMediaElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->src());
}

JSValue* jsHTMLMediaElementCurrentSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->currentSrc());
}

JSValue* jsHTMLMediaElementNetworkState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->networkState());
}

JSValue* jsHTMLMediaElementBufferingRate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->bufferingRate());
}

JSValue* jsHTMLMediaElementBuffered(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->buffered()));
}

JSValue* jsHTMLMediaElementReadyState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->readyState());
}

JSValue* jsHTMLMediaElementSeeking(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->seeking());
}

JSValue* jsHTMLMediaElementCurrentTime(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->currentTime());
}

JSValue* jsHTMLMediaElementDuration(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->duration());
}

JSValue* jsHTMLMediaElementPaused(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->paused());
}

JSValue* jsHTMLMediaElementDefaultPlaybackRate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->defaultPlaybackRate());
}

JSValue* jsHTMLMediaElementPlaybackRate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->playbackRate());
}

JSValue* jsHTMLMediaElementPlayed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->played()));
}

JSValue* jsHTMLMediaElementSeekable(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->seekable()));
}

JSValue* jsHTMLMediaElementEnded(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->ended());
}

JSValue* jsHTMLMediaElementAutoplay(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->autoplay());
}

JSValue* jsHTMLMediaElementStart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->start());
}

JSValue* jsHTMLMediaElementEnd(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->end());
}

JSValue* jsHTMLMediaElementLoopStart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->loopStart());
}

JSValue* jsHTMLMediaElementLoopEnd(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->loopEnd());
}

JSValue* jsHTMLMediaElementPlayCount(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->playCount());
}

JSValue* jsHTMLMediaElementCurrentLoop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->currentLoop());
}

JSValue* jsHTMLMediaElementControls(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->controls());
}

JSValue* jsHTMLMediaElementVolume(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->volume());
}

JSValue* jsHTMLMediaElementMuted(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->muted());
}

JSValue* jsHTMLMediaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLMediaElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLMediaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLMediaElement, Base>(exec, propertyName, value, &JSHTMLMediaElementTable, this, slot);
}

void setJSHTMLMediaElementSrc(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setSrc(value->toString(exec));
}

void setJSHTMLMediaElementCurrentTime(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setCurrentTime(value->toFloat(exec), ec);
    setDOMException(exec, ec);
}

void setJSHTMLMediaElementDefaultPlaybackRate(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setDefaultPlaybackRate(value->toFloat(exec), ec);
    setDOMException(exec, ec);
}

void setJSHTMLMediaElementPlaybackRate(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setPlaybackRate(value->toFloat(exec), ec);
    setDOMException(exec, ec);
}

void setJSHTMLMediaElementAutoplay(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setAutoplay(value->toBoolean(exec));
}

void setJSHTMLMediaElementStart(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setStart(value->toFloat(exec));
}

void setJSHTMLMediaElementEnd(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setEnd(value->toFloat(exec));
}

void setJSHTMLMediaElementLoopStart(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setLoopStart(value->toFloat(exec));
}

void setJSHTMLMediaElementLoopEnd(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setLoopEnd(value->toFloat(exec));
}

void setJSHTMLMediaElementPlayCount(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setPlayCount(value->toInt32(exec), ec);
    setDOMException(exec, ec);
}

void setJSHTMLMediaElementCurrentLoop(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setCurrentLoop(value->toInt32(exec));
}

void setJSHTMLMediaElementControls(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setControls(value->toBoolean(exec));
}

void setJSHTMLMediaElementVolume(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setVolume(value->toFloat(exec), ec);
    setDOMException(exec, ec);
}

void setJSHTMLMediaElementMuted(ExecState* exec, JSObject* thisObject, JSValue* value)
{
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(static_cast<JSHTMLMediaElement*>(thisObject)->impl());
    imp->setMuted(value->toBoolean(exec));
}

JSValue* JSHTMLMediaElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLMediaElementConstructor>(exec);
}

JSValue* jsHTMLMediaElementPrototypeFunctionLoad(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(asObject(thisValue));
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->load(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsHTMLMediaElementPrototypeFunctionPlay(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(asObject(thisValue));
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->play(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsHTMLMediaElementPrototypeFunctionPause(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(asObject(thisValue));
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->pause(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

// Constant getters

JSValue* jsHTMLMediaElementEMPTY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsHTMLMediaElementLOADING(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsHTMLMediaElementLOADED_METADATA(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsHTMLMediaElementLOADED_FIRST_FRAME(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue* jsHTMLMediaElementLOADED(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue* jsHTMLMediaElementDATA_UNAVAILABLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue* jsHTMLMediaElementCAN_SHOW_CURRENT_FRAME(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue* jsHTMLMediaElementCAN_PLAY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue* jsHTMLMediaElementCAN_PLAY_THROUGH(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}


}

#endif // ENABLE(VIDEO)
