/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSHTMLElement_h
#define JSHTMLElement_h

#include "JSElement.h"
#include "HTMLElement.h"
namespace WebCore {

class HTMLElement;

class JSHTMLElement : public JSElement {
    typedef JSElement Base;
public:
    JSHTMLElement(PassRefPtr<JSC::Structure>, PassRefPtr<HTMLElement>);
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue*, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }

    virtual void pushEventHandlerScope(JSC::ExecState*, JSC::ScopeChain&) const;

    static JSC::JSValue* getConstructor(JSC::ExecState*);
    HTMLElement* impl() const
    {
        return static_cast<HTMLElement*>(Base::impl());
    }
};

HTMLElement* toHTMLElement(JSC::JSValue*);

class JSHTMLElementPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue* prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSHTMLElementPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValue* jsHTMLElementPrototypeFunctionBlur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsHTMLElementPrototypeFunctionFocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsHTMLElementPrototypeFunctionInsertAdjacentElement(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsHTMLElementPrototypeFunctionInsertAdjacentHTML(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
JSC::JSValue* jsHTMLElementPrototypeFunctionInsertAdjacentText(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*, const JSC::ArgList&);
// Attributes

JSC::JSValue* jsHTMLElementId(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementId(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementTitle(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementTitle(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementLang(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementLang(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementDir(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementDir(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementClassName(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementClassName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementTabIndex(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementTabIndex(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementInnerHTML(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementInnerHTML(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementInnerText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementInnerText(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementOuterHTML(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementOuterHTML(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementOuterText(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementOuterText(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementChildren(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsHTMLElementContentEditable(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSHTMLElementContentEditable(JSC::ExecState*, JSC::JSObject*, JSC::JSValue*);
JSC::JSValue* jsHTMLElementIsContentEditable(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue* jsHTMLElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
