/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDOMSelection.h"

#include <wtf/GetPtr.h>

#include "DOMSelection.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMSelection)

/* Hash table */

static const HashTableValue JSDOMSelectionTableValues[12] =
{
    { "anchorNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionAnchorNode, (intptr_t)0 },
    { "anchorOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionAnchorOffset, (intptr_t)0 },
    { "focusNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionFocusNode, (intptr_t)0 },
    { "focusOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionFocusOffset, (intptr_t)0 },
    { "baseNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionBaseNode, (intptr_t)0 },
    { "baseOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionBaseOffset, (intptr_t)0 },
    { "extentNode", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionExtentNode, (intptr_t)0 },
    { "extentOffset", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionExtentOffset, (intptr_t)0 },
    { "isCollapsed", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionIsCollapsed, (intptr_t)0 },
    { "type", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionType, (intptr_t)0 },
    { "rangeCount", DontDelete|ReadOnly, (intptr_t)jsDOMSelectionRangeCount, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMSelectionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSDOMSelectionTableValues, 0 };
#else
    { 34, 31, JSDOMSelectionTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDOMSelectionPrototypeTableValues[16] =
{
    { "collapse", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapse, (intptr_t)2 },
    { "collapseToEnd", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapseToEnd, (intptr_t)0 },
    { "collapseToStart", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionCollapseToStart, (intptr_t)0 },
    { "deleteFromDocument", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionDeleteFromDocument, (intptr_t)0 },
    { "containsNode", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionContainsNode, (intptr_t)2 },
    { "selectAllChildren", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSelectAllChildren, (intptr_t)1 },
    { "empty", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionEmpty, (intptr_t)0 },
    { "setBaseAndExtent", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSetBaseAndExtent, (intptr_t)4 },
    { "setPosition", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionSetPosition, (intptr_t)2 },
    { "modify", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionModify, (intptr_t)3 },
    { "extend", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionExtend, (intptr_t)2 },
    { "getRangeAt", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionGetRangeAt, (intptr_t)1 },
    { "removeAllRanges", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionRemoveAllRanges, (intptr_t)0 },
    { "addRange", DontDelete|Function, (intptr_t)jsDOMSelectionPrototypeFunctionAddRange, (intptr_t)1 },
    { "toString", DontDelete|DontEnum|Function, (intptr_t)jsDOMSelectionPrototypeFunctionToString, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDOMSelectionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSDOMSelectionPrototypeTableValues, 0 };
#else
    { 34, 31, JSDOMSelectionPrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMSelectionPrototype::s_info = { "DOMSelectionPrototype", 0, &JSDOMSelectionPrototypeTable, 0 };

JSObject* JSDOMSelectionPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSDOMSelection>(exec);
}

bool JSDOMSelectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMSelectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDOMSelection::s_info = { "DOMSelection", 0, &JSDOMSelectionTable, 0 };

JSDOMSelection::JSDOMSelection(PassRefPtr<Structure> structure, PassRefPtr<DOMSelection> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSDOMSelection::~JSDOMSelection()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSDOMSelection::createPrototype(ExecState* exec)
{
    return new (exec) JSDOMSelectionPrototype(JSDOMSelectionPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSDOMSelection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSelection, Base>(exec, &JSDOMSelectionTable, this, propertyName, slot);
}

JSValue* jsDOMSelectionAnchorNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->anchorNode()));
}

JSValue* jsDOMSelectionAnchorOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->anchorOffset());
}

JSValue* jsDOMSelectionFocusNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->focusNode()));
}

JSValue* jsDOMSelectionFocusOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->focusOffset());
}

JSValue* jsDOMSelectionBaseNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->baseNode()));
}

JSValue* jsDOMSelectionBaseOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->baseOffset());
}

JSValue* jsDOMSelectionExtentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->extentNode()));
}

JSValue* jsDOMSelectionExtentOffset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->extentOffset());
}

JSValue* jsDOMSelectionIsCollapsed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->isCollapsed());
}

JSValue* jsDOMSelectionType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValue* jsDOMSelectionRangeCount(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    DOMSelection* imp = static_cast<DOMSelection*>(static_cast<JSDOMSelection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->rangeCount());
}

JSValue* jsDOMSelectionPrototypeFunctionCollapse(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int index = args.at(exec, 1)->toInt32(exec);

    imp->collapse(node, index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionCollapseToEnd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->collapseToEnd();
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionCollapseToStart(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->collapseToStart();
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionDeleteFromDocument(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->deleteFromDocument();
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionContainsNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    Node* node = toNode(args.at(exec, 0));
    bool allowPartial = args.at(exec, 1)->toBoolean(exec);


    JSC::JSValue* result = jsBoolean(imp->containsNode(node, allowPartial));
    return result;
}

JSValue* jsDOMSelectionPrototypeFunctionSelectAllChildren(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));

    imp->selectAllChildren(node, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionEmpty(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->empty();
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionSetBaseAndExtent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* baseNode = toNode(args.at(exec, 0));
    int baseOffset = args.at(exec, 1)->toInt32(exec);
    Node* extentNode = toNode(args.at(exec, 2));
    int extentOffset = args.at(exec, 3)->toInt32(exec);

    imp->setBaseAndExtent(baseNode, baseOffset, extentNode, extentOffset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionSetPosition(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int offset = args.at(exec, 1)->toInt32(exec);

    imp->setPosition(node, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionModify(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    const UString& alter = args.at(exec, 0)->toString(exec);
    const UString& direction = args.at(exec, 1)->toString(exec);
    const UString& granularity = args.at(exec, 2)->toString(exec);

    imp->modify(alter, direction, granularity);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionExtend(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args.at(exec, 0));
    int offset = args.at(exec, 1)->toInt32(exec);

    imp->extend(node, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionGetRangeAt(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValue* result = toJS(exec, WTF::getPtr(imp->getRangeAt(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsDOMSelectionPrototypeFunctionRemoveAllRanges(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());

    imp->removeAllRanges();
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionAddRange(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());
    Range* range = toRange(args.at(exec, 0));

    imp->addRange(range);
    return jsUndefined();
}

JSValue* jsDOMSelectionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDOMSelection::s_info))
        return throwError(exec, TypeError);
    JSDOMSelection* castedThisObj = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThisObj->impl());


    JSC::JSValue* result = jsString(exec, imp->toString());
    return result;
}

JSC::JSValue* toJS(JSC::ExecState* exec, DOMSelection* object)
{
    return getDOMObjectWrapper<JSDOMSelection>(exec, object);
}
DOMSelection* toDOMSelection(JSC::JSValue* value)
{
    return value->isObject(&JSDOMSelection::s_info) ? static_cast<JSDOMSelection*>(asObject(value))->impl() : 0;
}

}
