/****************************************************************************
**
** Copyright (C) 2008 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the either Technology Preview License Agreement or the
** Beta Release License Agreement.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file.  Please review the following information
** to ensure GNU General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.  In addition, as a special
** exception, Nokia gives you certain additional rights. These rights
** are described in the Nokia Qt GPL Exception version 1.3, included in
** the file GPL_EXCEPTION.txt in this package.
**
** Qt for Windows(R) Licensees
** As a special exception, Nokia, as the sole copyright holder for Qt
** Designer, grants users of the Qt/Eclipse Integration plug-in the
** right for the Qt/Eclipse Integration to link to functionality
** provided by Qt Designer and its related libraries.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
****************************************************************************/

#include "imageitem.h"
#include "colors.h"

ImageItem::ImageItem(const QImage &image, int maxWidth, int maxHeight, QGraphicsScene *scene,
        QGraphicsItem *parent, bool adjustSize, float scale) : DemoItem(scene, parent)
{
    this->image = image;
    this->maxWidth = maxWidth;
    this->maxHeight = maxHeight;
    this->adjustSize = adjustSize;
    this->scale = scale;
}

QImage *ImageItem::createImage(const QMatrix &matrix) const
{
    QImage *original = new QImage(image);
    if (original->isNull()){
        return original; // nothing we can do about it...
    }

    QPoint size = matrix.map(QPoint(this->maxWidth, this->maxHeight));
    float w = size.x(); // x, y is the used as width, height
    float h = size.y();

    // Optimization: if image is smaller than maximum allowed size, just return the loaded image
    if (original->size().height() <= h && original->size().width() <= w && !this->adjustSize && this->scale == 1)
        return original;

    // Calculate what the size of the final image will be:
    w = qMin(w, float(original->size().width()) * this->scale);
    h = qMin(h, float(original->size().height()) * this->scale);

    float adjustx = 1.0f;
    float adjusty = 1.0f;
    if (this->adjustSize){
        adjustx = qMin(matrix.m11(), matrix.m22());
        adjusty = matrix.m22() < adjustx ? adjustx : matrix.m22();
        w *= adjustx;
        h *= adjusty;
    }

    // Create a new image with correct size, and draw original on it
    QImage *image = new QImage(int(w+2), int(h+2), QImage::Format_ARGB32_Premultiplied);
    image->fill(QColor(0, 0, 0, 0).rgba());
    QPainter painter(image);
    painter.setRenderHints(QPainter::Antialiasing | QPainter::SmoothPixmapTransform);
    if (this->adjustSize)
        painter.scale(adjustx, adjusty);
    if (this->scale != 1)
       painter.scale(this->scale, this->scale);
    painter.drawImage(0, 0, *original);

    if (!this->adjustSize){
       // Blur out edges
       int blur = 30;
       if (h < original->height()){
           QLinearGradient brush1(0, h - blur, 0, h);
           brush1.setSpread(QGradient::PadSpread);
           brush1.setColorAt(0.0, QColor(0, 0, 0, 0));
           brush1.setColorAt(1.0, Colors::sceneBg1);
           painter.fillRect(0, int(h) - blur, original->width(), int(h), brush1);
       }
       if (w < original->width()){
           QLinearGradient brush2(w - blur, 0, w, 0);
           brush2.setSpread(QGradient::PadSpread);
           brush2.setColorAt(0.0, QColor(0, 0, 0, 0));
           brush2.setColorAt(1.0, Colors::sceneBg1);
           painter.fillRect(int(w) - blur, 0, int(w), original->height(), brush2);
       }
    }
    delete original;
    return image;
}
