/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "toolbarsearch.h"
#include "autosave.h"

#include <QtCore/QUrl>
#include <QtCore/QSettings>

#include <QtGui/QMenu>
#include <QtGui/QCompleter>
#include <QtGui/QStringListModel>

/*
    ToolbarSearch is a very basic search widget that also contains a small history.
    Searches are turned into urls that use Google to perform search
 */
ToolbarSearch::ToolbarSearch(QWidget *parent) : SearchLineEdit(parent),
    m_autosave(new AutoSave(this))
{
    QMenu *m = menu();
    connect(m, SIGNAL(aboutToShow()), this, SLOT(aboutToShowMenu()));
    connect(m, SIGNAL(triggered(QAction*)), this, SLOT(triggeredMenuAction(QAction*)));

    stringListModel = new QStringListModel(this);
    QCompleter *completer = new QCompleter(stringListModel, this);
    completer->setCompletionMode(QCompleter::InlineCompletion);
    setCompleter(completer);

    connect(this, SIGNAL(returnPressed()), SLOT(searchNow()));
    setInactiveText(tr("Google"));
    load();
}

ToolbarSearch::~ToolbarSearch()
{
    m_autosave->saveNow();
}

void ToolbarSearch::save()
{
    QSettings settings;
    settings.beginGroup("toolbarsearch");
    settings.setValue("recentSearches", stringListModel->stringList());
    settings.setValue("maximumSaved", m_maxSavedSearches);
}

void ToolbarSearch::load()
{
    QSettings settings;
    settings.beginGroup("toolbarsearch");
    QStringList list = settings.value("recentSearches").toStringList();
    m_maxSavedSearches = settings.value("maximumSaved", 10).toInt();
    stringListModel->setStringList(list);
}

void ToolbarSearch::searchNow()
{
    QString searchText = text();
    QStringList list = stringListModel->stringList();
    if (list.contains(searchText))
        list.removeAt(list.indexOf(searchText));
    list.prepend(searchText);
    if (list.size() >= m_maxSavedSearches)
        list.removeLast();
    stringListModel->setStringList(list);
    m_autosave->changed();

    QUrl url("http://www.google.com/search");
    url.addQueryItem("q", searchText);
    url.addQueryItem("ie", "UTF-8");
    url.addQueryItem("oe", "UTF-8");
    emit search(url);
}

void ToolbarSearch::aboutToShowMenu()
{
    selectAll();
    QMenu *m = menu();
    m->clear();
    QStringList list = stringListModel->stringList();
    if (list.isEmpty()) {
        m->addAction(tr("No Recent Searches"));
        return;
    }

    QAction *recent = m->addAction(tr("Recent Searches"));
    recent->setEnabled(false);
    for (int i = 0; i < list.count(); ++i)
        m->addAction(list.at(i))->setData(list.at(i));
    m->addSeparator();
    m->addAction(tr("Clear Recent Searches"), this, SLOT(clear()));
}

void ToolbarSearch::triggeredMenuAction(QAction *action)
{
    QVariant v = action->data();
    if (v.canConvert<QString>()) {
        QString text = v.toString();
        setText(text);
        searchNow();
    }
}

void ToolbarSearch::clear()
{
    stringListModel->setStringList(QStringList());
    m_autosave->changed();
}

