/****************************************************************************
**
** Copyright (C) 2007-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "settings.h"
#include "cookiejar.h"
#include "browsermainwindow.h"

#include <QtWebKit/QtWebKit>
#include <QtCore/QSettings>
#include <QtGui/QtGui>

SettingsDialog::SettingsDialog(CookieJar *cookieJar, QWidget *parent)
    : QDialog(parent)
    , m_jar(cookieJar)
{
    setupUi(this);
    connect(exceptionsButton, SIGNAL(clicked()), this, SLOT(showExceptions()));
    connect(setHomeToCurrentPageButton, SIGNAL(clicked()), this, SLOT(setHomeToCurrentPage()));
    connect(cookiesButton, SIGNAL(clicked()), this, SLOT(showCookies()));

    QSettings settings;
    settings.beginGroup("MainWindow");
    homeLineEdit->setText(settings.value("home", "http://www.trolltech.com").toString());
    settings.endGroup();

    settings.beginGroup("cookies");
    acceptCombo->setCurrentIndex(settings.value("acceptCookies").toInt());
    keepUntilCombo->setCurrentIndex(settings.value("keepCookiesUntil").toInt());
    settings.endGroup();
    
    settings.beginGroup("history");
    int historyExpire = settings.value("historyExpire").toInt();
    int idx = 0;
    switch (historyExpire) {
    case 1: idx = 0; break;
    case 7: idx = 1; break;
    case 14: idx = 2; break;
    case 30: idx = 3; break;
    case 365: idx = 4; break;
    case -1: idx = 5; break;
    default:
        idx = 5;
    }
    expireHistory->setCurrentIndex(idx);
    settings.endGroup();
    
    /*
    QWebSettings *defaultSettings = QWebSettings::defaultSettings();
    QString standardFontFamily = defaultSettings->fontFamily(QWebSettings::StandardFont);
    int standardFontSize = defaultSettings->fontSize(QWebSettings::DefaultFontSize);
    QString fixedFontFamily = defaultSettings->fontFamily(QWebSettings::FixedFont);
    int fixedFontSize = defaultSettings->fontSize(QWebSettings::DefaultFixedFontSize);
    */
}

void SettingsDialog::accept()
{
    QSettings settings;
    settings.beginGroup("MainWindow");
    settings.setValue("home", homeLineEdit->text());
    settings.endGroup();

    settings.beginGroup("cookies");
    settings.setValue("acceptCookies", acceptCombo->currentIndex());
    settings.setValue("keepCookiesUntil", keepUntilCombo->currentIndex());
    settings.endGroup();

    settings.beginGroup("history");
    int historyExpire = keepUntilCombo->currentIndex();
    int idx = -1;
    switch (historyExpire) {
    case 0: idx = 1; break;
    case 1: idx = 7; break;
    case 2: idx = 14; break;
    case 3: idx = 30; break;
    case 4: idx = 365; break;
    case 5: idx = -1; break;
    }
    settings.setValue("historyExpire", idx);
    QDialog::accept();
}

void SettingsDialog::showCookies()
{
    CookiesDialog *dialog = new CookiesDialog(m_jar, this);
    dialog->setWindowFlags(Qt::Sheet);
    dialog->exec();
}

void SettingsDialog::showExceptions()
{
    CookiesExceptionsDialog *dialog = new CookiesExceptionsDialog(m_jar, this);
    dialog->setWindowFlags(Qt::Sheet);
    dialog->exec();
}

void SettingsDialog::chooseFont()
{
    bool ok;
    QFont font = QFontDialog::getFont(&ok, QFont( "Helvetica [Cronyx]", 10 ), this);
    if ( ok ) {
        // font is set to the font the user selected
    } else {
        // the user canceled the dialog; font is set to the initial
        // value, in this case Helvetica [Cronyx], 10
    }
}

void SettingsDialog::chooseFixedFont()
{
    //QFontDialog dialog;
    //dialog.exec();
}

void SettingsDialog::setHomeToCurrentPage()
{
    BrowserMainWindow *mw = static_cast<BrowserMainWindow*>(parent());
    homeLineEdit->setText(mw->currentPage());
}

