/****************************************************************************
**
** Copyright (C) 1992-$THISYEAR$ Trolltech AS. All rights reserved.
**
** This file is part of the $MODULE$ of the Qt Toolkit.
**
** $LICENSE$
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "conf.h"
#include <qapplication.h>
#include <qfont.h>
#include <qcolor.h>
#include <qsettings.h>

QMap<QString, ConfigStyle> Config::defaultStyles()
{
    ConfigStyle s;
    QMap<QString, ConfigStyle> styles;
    int normalSize =  qApp->font().pointSize();
    QString normalFamily = qApp->font().family();
    QString commentFamily = QString::fromLatin1("times");
    int normalWeight = qApp->font().weight();

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::black;
    styles.insert( QString::fromLatin1("Standard"), s );

    s.font = QFont( commentFamily, normalSize, normalWeight, true );
    s.color = Qt::red;
    styles.insert( QString::fromLatin1("Comment"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::blue;
    styles.insert( QString::fromLatin1("Number"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::darkGreen;
    styles.insert( QString::fromLatin1("String"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::darkMagenta;
    styles.insert( QString::fromLatin1("Type"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::darkYellow;
    styles.insert( QString::fromLatin1("Keyword"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::darkBlue;
    styles.insert( QString::fromLatin1("Preprocessor"), s );

    s.font = QFont( normalFamily, normalSize, normalWeight );
    s.color = Qt::darkRed;
    styles.insert( QString::fromLatin1("Label"), s );

    return styles;
}

QMap<QString, ConfigStyle> Config::readStyles( const QString &path )
{
    QMap<QString, ConfigStyle> styles;
    styles = defaultStyles();

    QString family;
    int size = 10;
    bool bold = false, italic = false, underline = false;
    int red = 0, green = 0, blue = 0;

    QString elements[] = {
	QString::fromLatin1("Comment"),
	QString::fromLatin1("Number"),
	QString::fromLatin1("String"),
	QString::fromLatin1("Type"),
	QString::fromLatin1("Keyword"),
	QString::fromLatin1("Preprocessor"),
	QString::fromLatin1("Label"),
	QString::fromLatin1("Standard"),
	QString::null
    };

    for ( int i = 0; elements[ i ] != QString::null; ++i ) {
	QSettings settings("Trolltech", "QSA");
        settings.beginGroup(path);
	bool ok = true;
	for (;;) {
            settings.beginGroup(elements[i]);
	    family = settings.readEntry("family", QString::null, &ok );
	    if ( !ok )
		break;
	    size = settings.readNumEntry("size", 10, &ok );
	    if ( !ok )
		break;
	    bold = settings.readBoolEntry("bold", false, &ok );
	    if ( !ok )
		break;
	    italic = settings.readBoolEntry("italic", false, &ok );
	    if ( !ok )
		break;
	    underline = settings.readBoolEntry("underline", false, &ok );
	    if ( !ok )
		break;
	    red = settings.readNumEntry("red", 0, &ok );
	    if ( !ok )
		break;
	    green = settings.readNumEntry("green", 0, &ok );
	    if ( !ok )
		break;
	    blue = settings.readNumEntry("blue", 0, &ok );
	    if ( !ok )
		break;
	    break;
            settings.endGroup();
	}
	if ( !ok )
	    continue;
	QFont f( family );
	f.setPointSize( size );
	f.setBold( bold );
	f.setItalic( italic );
	f.setUnderline( underline );
	QColor c( Qt::red, Qt::green, Qt::blue );
	ConfigStyle s;
	s.font = f;
	s.color = c;
	styles.remove( elements[ i ] );
	styles.insert( elements[ i ], s );

    }
    return styles;
}

void Config::saveStyles( const QMap<QString, ConfigStyle> &styles, const QString &path )
{
    QString elements[] = {
	QString::fromLatin1("Comment"),
	QString::fromLatin1("Number"),
	QString::fromLatin1("String"),
	QString::fromLatin1("Type"),
	QString::fromLatin1("Keyword"),
	QString::fromLatin1("Preprocessor"),
	QString::fromLatin1("Label"),
	QString::fromLatin1("Standard"),
	QString::null
    };

    QSettings settings("Trolltech", "QSA");
    settings.beginGroup(path);

    for ( int i = 0; elements[ i ] != QString::null; ++i ) {
        settings.beginGroup();
	settings.writeEntry("family", styles[ elements[ i ] ].font.family() );
	settings.writeEntry("size", styles[ elements[ i ] ].font.pointSize() );
	settings.writeEntry("bold", styles[ elements[ i ] ].font.bold() );
	settings.writeEntry("italic", styles[ elements[ i ] ].font.italic() );
	settings.writeEntry("underline", styles[ elements[ i ] ].font.underline() );
	settings.writeEntry("red", styles[ elements[ i ] ].color.red() );
	settings.writeEntry("green", styles[ elements[ i ] ].color.green() );
	settings.writeEntry("blue", styles[ elements[ i ] ].color.blue() );
        settings.endGroup();
    }

    settings.endGroup();
}

bool Config::completion( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    bool ret = settings.readBoolEntry( path + QString::fromLatin1("/completion"), true );
    return ret;
}

bool Config::wordWrap( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    bool ret = settings.readBoolEntry( path + QString::fromLatin1("/wordWrap"), true );
    return ret;
}

bool Config::parenMatching( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    bool ret = settings.readBoolEntry( path + QString::fromLatin1("/parenMatching"), true );
    return ret;
}

int Config::indentTabSize( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    int ret = settings.readNumEntry( path + QString::fromLatin1("/indentTabSize"), 8 );
    return ret;
}

int Config::indentIndentSize( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    int ret = settings.readNumEntry( path + QString::fromLatin1("/indentIndentSize"), 4 );
    return ret;
}

bool Config::indentKeepTabs( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    bool ret = settings.readBoolEntry( path + QString::fromLatin1("/indentKeepTabs"), true );
    return ret;
}

bool Config::indentAutoIndent( const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    bool ret = settings.readBoolEntry( path + QString::fromLatin1("/indentAutoIndent"), true );
    return ret;
}

void Config::setCompletion( bool b, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/completion"), b );
}

void Config::setWordWrap( bool b, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/wordWrap"), b );
}

void Config::setParenMatching( bool b,const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/parenMatching"), b );
}

void Config::setIndentTabSize( int s, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/indentTabSize"), s );
}

void Config::setIndentIndentSize( int s, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/indentIndentSize"), s );
}

void Config::setIndentKeepTabs( bool b, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/indentKeepTabs"), b );
}

void Config::setIndentAutoIndent( bool b, const QString &path )
{
    QSettings settings("Trolltech", "QSA");
    settings.writeEntry( path + QString::fromLatin1("/indentAutoIndent"), b );
}
