/****************************************************************************
**
** Copyright (C) 1992-2005 Trolltech AS. All rights reserved.
**
** This file is part of the QSA of the Qt Toolkit.
**
** For QSA Commercial License Holders (non-open source):
** 
** Licensees holding a valid Qt Script for Applications (QSA) License Agreement
** may use this file in accordance with the rights, responsibilities and
** obligations contained therein.  Please consult your licensing agreement or
** contact sales@trolltech.com if any conditions of the Licensing Agreement are
** not clear to you.
** 
** Further information about QSA licensing is available at:
** http://www.trolltech.com/products/qsa/licensing.html or by contacting
** info@trolltech.com.
** 
** 
** For Open Source Edition:  
** 
** This file may be used under the terms of the GNU General Public License
** version 2 as published by the Free Software Foundation and appearing in the
** file LICENSE.GPL included in the packaging of this file.  Please review the
** following information to ensure GNU General Public Licensing requirements
** will be met:  http://www.trolltech.com/products/qt/opensource.html 
** 
** If you are unsure which license is appropriate for your use, please review
** the following information:
** http://www.trolltech.com/products/qsa/licensing.html or contact the 
** sales department at sales@trolltech.com.

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "sheetinterface.h"
#include "spreadsheet.h"

#include <QTableWidget>
#include <QTableWidgetItem>

SheetInterface::SheetInterface( QTableWidget *t, SpreadSheet *s, const char *name )
	: QObject(t), sheet(t), spreadSheet(s)
{
    setObjectName(name);
    connect(t, SIGNAL(itemChanged(QTableWidgetItem *)),
	        this, SLOT(itemChanged(QTableWidgetItem *)));
}

void SheetInterface::itemChanged(QTableWidgetItem *w)
{
    if (w != 0 && sheet != 0)
        emit currentChanged(sheet->row(w), sheet->column(w));
}

int SheetInterface::numSelections() const
{
    return sheet->selectedRanges().count();
}

void SheetInterface::setText( int row, int col, const QString &val )
{
    if (sheet->item(row, col))
        sheet->item(row, col)->setText(val);
}

QString SheetInterface::text( int row, int col ) const
{
    if (sheet->item(row, col))
        return sheet->item(row, col)->text();
    else
        return QString();
}

QRect SheetInterface::selection( int num ) const
{
    QTableWidgetSelectionRange selectedRange = sheet->selectedRanges().at(num);

    QRect r(QPoint(selectedRange.leftColumn(), selectedRange.topRow()),
            QPoint(selectedRange.rightColumn(), selectedRange.bottomRow()));

    return r;
}

void SheetInterface::setCurrentRow( int r )
{
    sheet->setCurrentItem(sheet->item(r, currentColumn()));
}

void SheetInterface::setCurrentColumn( int c )
{
    sheet->setCurrentItem(sheet->item(currentRow(), c));
}

int SheetInterface::currentRow() const
{
    return sheet->currentRow();
}

int SheetInterface::currentColumn() const
{
    return sheet->currentColumn();
}

int SheetInterface::numRows() const
{
    return sheet->rowCount();
}

int SheetInterface::numCols() const
{
    return sheet->columnCount();
}
