/****************************************************************************
**
** Copyright (C) 1992-$THISYEAR$ Trolltech AS. All rights reserved.
**
** This file is part of the $MODULE$ of the Qt Toolkit.
**
** $LICENSE$
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "configutils.h"

#include <qfile.h>
#include <q3process.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qapplication.h>
#include <stdlib.h>
#ifdef Q_WS_WIN
#include <windows.h>
#endif

static const char *app = 0;

static void dumpMessages()
{
    qWarning( messages().join( "\n" ) );
}


int main( int argc, char **argv )
{
#ifndef QT_VERSION
#  define QT_VERSION 0x01
#endif
#if QT_VERSION < 0x040001
    printf("\nThis version of QSA requires Qt 4.0.1 or later, using: %x.%x.%x\n\n",
           (QT_VERSION>>16) & 0xff,
           (QT_VERSION>>8) & 0xff,
           QT_VERSION & 0xff);
    return 100;
#endif

    app = argv[0];
    QApplication qapp( argc, argv, false );

    QStringList configs;
    QString prefix;
    bool buildIde = true;
    bool buildEditor = true;
    bool buildNewEditor = false;
    for ( int i = 1; i < qapp.argc(); i++ ) {
        QString arg = qapp.argv()[i];
        if ( arg.startsWith( "--" ) )
            arg = arg.mid( 1 );
        if ( arg == "-help"  ) {
            ; // handled by the configure script
        } else if ( arg == "-thread" ) {
            configs << "thread";
        } else if ( arg == "-prefix" ) {
            if ( i + 1 < qapp.argc() ) {
                prefix = qapp.argv()[++i];
            } else {
                qWarning( "-prefix option requires path argument" );
                exit( 2 );
            }
        } else if ( arg == "-no-ide" ) {
            buildIde = false;
            configs << "noide";
        } else if (arg == "-no-editor") {
            buildEditor = false;
            configs << "noeditor";
        } else if (arg == "-new-editor") {
            configs << "neweditor";
            buildNewEditor = true;
        } else {
            qWarning( "Unknown option: %s", qapp.argv()[i] );
            exit( 1 );
        }
    }

    // these are here in case .qmake.cache is missing
#if defined(QT_MODULE_XML)
    configs.append( "xml" );
#endif
#if defined(QT_MODULE_TABLE)
    configs.append( "table" );
#endif
#if defined(QT_MODULE_SQL)
    configs.append( "sql" );
#endif
#if defined(QT_MODULE_NETWORK)
    configs.append( "network" );
#endif

    qtDir = new QString( getenv( "QTDIR" ) );
    if ( qtDir->isEmpty() ) {
        qWarning( "%s: QTDIR not set", app );
        dumpMessages();
        return 1;
    }
    *qtDir += "/";

    if ( !checkLicense() ) {
        dumpMessages();
        return 1;
    }

    if( !writeQSConfig( buildIde, buildEditor, buildNewEditor ) ) {
        dumpMessages();
        return 1;
    }

    if ( prefix.isEmpty() )
        copyQSAHeaders();

    installDocs();

    runQMake( configs, prefix );

    int retVal = processes > 0 ? qapp.exec() : 0;
    if( retVal || errors ) {
        message( "\nThere were errors during configure!" );
    } else if( warnings ) {
        if (qdoc_warning) {
            message("\nFailed to install documentation");
        }
        if (qmake_warning) {
            message("\nFailed to run qmake on top level .pro file\n");
        }

        message( "\nThere were errors during configure, but these"
            "\ndo not appear to be fatal, so you should still be"
            "\nable to build QSA."
            "\nRun your make tool to build QSA." );
    } else {
        message( "\n"
            "Configuration completed successfully\n"
            "Run your make tool to build QSA" );
    }

    dumpMessages();
    return retVal || errors;
}
