/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Atom;
import com.jcraft.weirdx.Client;
import com.jcraft.weirdx.IO;
import com.jcraft.weirdx.Window;
import java.io.IOException;

final class Selection {
    int selection;
    int lastTimeChanged;
    int wid;
    Window window;
    Client client;
    static Selection[] currentSelection = new Selection[10];

    Selection(int n, int n2, Window window, Client client) {
        this.selection = n;
        this.lastTimeChanged = n2;
        this.window = window;
        this.wid = window != null ? window.id : 0;
        this.client = client;
    }

    static synchronized Selection getSelection(int n) {
        Selection selection = null;
        int n2 = currentSelection.length;
        int n3 = 0;
        while (n3 < n2 && currentSelection[n3] != null) {
            if (Selection.currentSelection[n3].selection == n) {
                selection = currentSelection[n3];
                break;
            }
            ++n3;
        }
        return selection;
    }

    static synchronized void addSelection(int n, int n2, Window window, Client client) {
        Selection selection = new Selection(n, n2, window, window != null ? client : null);
        if (currentSelection[currentSelection.length - 1] != null) {
            Selection[] selectionArray = new Selection[currentSelection.length * 2];
            System.arraycopy(currentSelection, 0, selectionArray, 0, currentSelection.length);
            currentSelection = selectionArray;
        }
        int n3 = 0;
        while (currentSelection[n3] != null) {
            ++n3;
        }
        Selection.currentSelection[n3] = selection;
    }

    static void reqConvertSelection(Client client) throws IOException {
        boolean bl = true;
        IO iO = client.client;
        int n = iO.readInt();
        Window window = client.lookupWindow(n);
        if (window == null) {
            client.errorValue = n;
            client.errorReason = 3;
        }
        int n2 = iO.readInt();
        bl = Atom.valid(n2);
        int n3 = iO.readInt();
        bl &= Atom.valid(n3);
        int n4 = iO.readInt();
        if (n4 != 0) {
            bl &= Atom.valid(n4);
        }
        int n5 = iO.readInt();
        client.length -= 6;
        if (client.errorReason != 0) {
            return;
        }
        if (bl) {
            Selection selection = Selection.getSelection(n2);
            if (selection != null && selection.client != null) {
                client.cevent.mkSelectionRequest(n5, selection.wid, n, n2, n3, n4);
                if (selection.client.sendEvent(client.cevent, 1, 0, 0, null) != 0) {
                    return;
                }
            }
            client.cevent.mkSelectionNotify(n5, n, n2, n3, 0);
            client.sendEvent(client.cevent, 1, 0, 0, null);
            return;
        }
        client.errorValue = n4;
        client.errorReason = 5;
    }

    static void reqSetSelectionOwner(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        Window window = null;
        if (n != 0 && (window = client.lookupWindow(n)) == null) {
            client.errorValue = n;
            client.errorReason = 3;
            return;
        }
        int n2 = iO.readInt();
        n = iO.readInt();
        client.length -= 2;
        int n3 = 0;
        n3 = (int)System.currentTimeMillis();
        n3 = n;
        if (Atom.valid(n2)) {
            boolean bl = false;
            Selection selection = Selection.getSelection(n2);
            if (selection != null) {
                if (selection.client != null && (window == null || selection.client != client) && selection.client != null) {
                    client.cevent.mkSelectionClear(n3, selection.wid, selection.selection);
                    selection.client.sendEvent(client.cevent, 1, 0, 0, null);
                }
                selection.window = window;
                selection.wid = window != null ? window.id : 0;
                selection.lastTimeChanged = n3;
                selection.client = window != null ? client : null;
            } else {
                Selection.addSelection(n2, n3, window, client);
            }
            return;
        }
        client.errorValue = n2;
        client.errorReason = 5;
    }

    static void reqGetSelectionOwner(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        if (!Atom.valid(n)) {
            client.errorValue = n;
            client.errorReason = 5;
            return;
        }
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte(1);
            Selection selection = Selection.getSelection(n);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(0);
            if (selection != null) {
                iO.writeInt(selection.wid);
            } else {
                iO.writeInt(0);
            }
            iO.writePad(20);
            iO.flush();
        }
    }

    static synchronized void delete(Client client) {
        Selection selection;
        int n = currentSelection.length;
        int n2 = 0;
        while (n2 < n && (selection = currentSelection[n2]) != null) {
            if (selection.client == client) {
                if (n2 + 1 == n) {
                    Selection.currentSelection[n2] = null;
                } else {
                    int n3 = n2 + 1;
                    while (n3 < n) {
                        Selection.currentSelection[n3 - 1] = currentSelection[n3];
                        if (currentSelection[n3] == null) break;
                        ++n3;
                    }
                }
                selection.window = null;
                selection.client = null;
            }
            ++n2;
        }
    }

    static synchronized void delete(Window window) {
        Selection selection;
        int n = currentSelection.length;
        int n2 = 0;
        while (n2 < n && (selection = currentSelection[n2]) != null) {
            if (selection.window == window) {
                if (n2 + 1 == n) {
                    Selection.currentSelection[n2] = null;
                } else {
                    int n3 = n2 + 1;
                    while (n3 < n) {
                        Selection.currentSelection[n3 - 1] = currentSelection[n3];
                        if (currentSelection[n3] == null) break;
                        ++n3;
                    }
                }
                selection.window = null;
                selection.client = null;
            }
            ++n2;
        }
    }
}

