#define LS_VERSION "0.2"
/*
 * This is a very simple version of ls.exe for the Umsdos File System.
 * It allow consultation of the information that are inside the
 * "--linux-.---" file in a known form.
 * This program have few fonctionality of the original ls and may be buggy,
 *  but seems to work for me...
 *
 * For the moment, it only display content of current directory.
 *
 * If it detect no "--linux-.---" or find wildcard or argument that he can't
 *  handel, it passe the command line to the internal Msdos dir.
 * So you can use ls.exe every time (at a low cost), even when you are not in
 *  an Umsdos part of your file system.
 *
 * Please report any Bug to: GLAUDE DAVID (dglaude@is1.ulb.ac.be) [Glu]
 *
 * I have a todo list for this program, but it is so long I can't write it !
 * Please send me a short email with comments if you use it often.
 * Please e-mail me for "I really want to pay this men even if it's free.".
 */

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <string.h>

#define VERSION_MSDOS
#include "dosumsfs.h"
#include "msmangle.h"
#include "dirent.h"
#include "group.h"
#include "getopt.h"
#include "linux/stat.h"

struct ffblk ffblk;

/* Constantes utilisee pour les flags */
#define MTIME 0				/* Last modification time */
#define ATIME 1				/* Access time */
#define CTIME 2				/* Creation time */

#define NSIZE 0				/* Do not Print size       */
#define PSIZE 1				/* Print size in  512 byte */
#define KSIZE 2				/* Print size in 1024 byte */

#define ZEROSORT  0 			/* Zero Sort */
#define NAMESORT  1			/* Sort on filename */
#define EXTSORT   2			/* Sort on extention */
#define MSDOSSORT 3			/* Sort on msdos filename */
#define SIZESORT  4			/* Sort on filesize */
#define TIMESORT  5			/* Sort on time (default MTIME) */
#define MTIMESORT (MTIME+TIMESORT)	/* Sort on Last modification time */
#define ATIMESORT (ATIME+TIMESORT)	/* Sort on Access time */
#define CTIMESORT (ATIME+TIMESORT)	/* Sort on Creation time */
/* Fin des constantes utilisees pour les flags */

/* Flag pour les options de ls.exe */
int msdos=0;	   	/* If 1 then execute the MsDos internal DIR	*/
int forcedos=0;    	/* If 1 then -D option should be remove	     	*/
int timetype=MTIME;    	/* Option -c & -u Type de temps a afficher      */
int verbose=0;     	/* Option -l      (not in long format if 0)     */
int listcolumns=1; 	/* Use columns 1=1 2=multiple		     	*/
int classify=0;    	/* Option -F & -p (append type if 1)            */
int Backup=0;	   	/* Option -B      (ignore Backup if 1)          */
int all=0;	   	/* Option -a      (do not list . & .. if 0)     */
int almost=0;	   	/* Option -A & -a (do not list .xxx if 0)       */
int posixify=0;	   	/* Flag to one is Posix compilence is needded   */
int sizeformat=NSIZE;  	/* Option -k & -s (way of printing size)        */
int numeric=0;     	/* Option -n      (print symbolic owner if 0)   */
int help=0;	   	/* Ask for help...				*/
int manglename=0;  	/* Show mangled name                            */
int horizontal=0;  	/* Way of sorting in column		   	*/
int sort=NAMESORT;   	/* Kind of sort to do on dirent                 */
int rev=0;		/* Reverse sort if set to 1 			*/
int directory=1;   	/* List Directory as normal file if 1           *//* Sould be 0 */
/* Fin des flag pour les options de ls.exe */

#define OK      "1acghklnprstuABDFMNOX"
#define DEFAULT	"d"
#define NOTYET  "mwxCILRST"

int optin(int argc, char **argv)
{
 int c;		 /* char *self; */ /* self=argv[0]; */

 opterr=0;

 while ((c = getopt(argc, argv, OK DEFAULT NOTYET )) != -1){
       switch (c){
       case 'c':
	       timetype=CTIME;
	       if(sort==TIMESORT)sort=CTIMESORT;
	       break;
       case 'u':
	       timetype=ATIME;
	       if(sort==TIMESORT)sort=ATIMESORT;
	       break;
       case 'l':
	       verbose=1;
	       listcolumns=0;
	       break;
       case '1':
	       verbose=0;
	       listcolumns=1;
	       break;
       case 'F':
       case 'p':
	       classify=1;
	       break;
       case 'B':
	       Backup=1;
	       break;
       case 'a':
	       all=1;
	       almost=1;
	       break;
       case 'A':
	       almost=1;
	       break;
       case 'k':
	       posixify=1;
	       if(sizeformat==1)sizeformat=2;
	       break;
       case 's':
	       if(posixify==1)
		    sizeformat=2;
	       else sizeformat=1;
	       break;
       case 'n':
	       numeric=1;
	       break;
       case 'h':
	       help=1;
	       break;
       case 'M':
	       manglename=1;
	       break;
       case 'N':
	       sort=ZEROSORT;
	       break;
       case 'O':
	       sort=MSDOSSORT;
	       break;
       case 't':
	       sort=TIMESORT+timetype;
	       break;
       case 'r':	/* Sort in reverse order */
	       rev=1;
	       break;
       case 'X':
	       sort=EXTSORT;
	       break;
       case 'g':
	       break;
       case 'D':
	       forcedos=1;
       case '?':
	       msdos=1;
	       break;
       case 'd':
	       directory=1;
	       goto IsDefault;
      IsDefault:
	       printf("Option -%c have no effect: default value.\n");
	       break;
       case 'C':	/* List file in columns, sorted veticaly */
	       verbose=0;
	       listcolumns=2;
	       horizontal=0;
	       goto NotYet;
       case 'x':	/* List file in columns, sorted horizontaly */
	       verbose=0;
	       listcolumns=2;
	       horizontal=1;
	       goto NotYet;
       case 'S':
	       sort=SIZESORT;
	       goto NotYet;
       case 'R':	/* Recursively */
       case 'L':	/* List file linked to */
       case 'I':	/* Do not list file that mach patern */
       case 'm':        /* List file separated by commas */
       case 'w':	/* Assume screen is x columns wide */
       case 'T':	/* Assume tabstop is x columns wide */
       default :
	 NotYet:
	       printf("Option -%c have no effect: not yet implemented.\n");
	       break;
       }
 if(msdos)break;
 }
/*		if (optind != argc - 1) { };     	*/
/*		name = argv[optind];		 	*/
 return 0;
}

/* Effectue un dir MsDos */
int msdosdir(char *argument)
{
 char cmd[256];

 sprintf(cmd, "dir %s", argument);
/*printf("Command issued: '%s'\n", cmd);*/
 return system(cmd);
}

/* Verifie la presence d'un fichier sous MsDos */
struct ffblk *infomsdos(char *msdosname)
{
return (findfirst(msdosname,&ffblk,
	FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH)==0)?&ffblk:NULL;
}
int display_linux_info(struct ffblk *ffblk,
		       struct dirent *entry)
{
#define permmask 07
 char  *perm[]={"---","--x","-w-","-wx","r--","r-x","rw-","rwx"};
 char *month[]={"---","Jan","Feb","Mar","Apr","May","Jun","Jul",
		"Aug","Sep","Oct","Nov","Dec"};

 struct date today,dt;
 struct time tm;
 char date[25];      /* String indiquant la date */
 char permstr[12];   /* String de type et permition format long */
 char *append;       /* Carctere a rajouter, indique le type de fichier */
 char size[20];      /* La taille du fichier */
 char bsize[20];     /* La taille du fichier en block */
 char *uid;	     /* Owner user */
 char *gid;          /* Owner group */
 char struid[10];    /* Buffer for numeric user  id. */
 char strgid[10];    /* Buffer for numeric group id. */
 char msdosname[20]; /* Store the MsDos name */
 char nlink[10];     /* Buffer for number of link */

 /* Creation des caracteres des permitions (drwxrw-r--) */
 sprintf(permstr,"?%s%s%s ",
	 perm[(entry->entry.mode>>6)&permmask],
	 perm[(entry->entry.mode>>3)&permmask],
	 perm[(entry->entry.mode)&permmask]);

 append="";
 if(S_ISLNK(entry->entry.mode))  {permstr[0]='l'; append="@";  }
 if(S_ISREG(entry->entry.mode))  {permstr[0]='-'; append="";   }
 if(S_ISDIR(entry->entry.mode))  {permstr[0]='d'; append="\\"; }
 if(S_ISCHR(entry->entry.mode))  {permstr[0]='c'; append="";   }
 if(S_ISBLK(entry->entry.mode))  {permstr[0]='b'; append="";   }
 if(S_ISFIFO(entry->entry.mode)) {permstr[0]='p'; append="|";  }

 if(S_ISSUID(entry->entry.mode)) permstr[3]='s';
 if(S_ISSGID(entry->entry.mode)) permstr[6]='s';
 if(S_ISSVTX(entry->entry.mode)) permstr[9]='t';

 if(((((entry->entry.mode>>6)&permmask)|
      ((entry->entry.mode>>3)&permmask)|
      ((entry->entry.mode)&permmask))&01)&&
      (append[0]=='\0')&&
      (((entry->entry.flags)&UMSDOS_HLINK)!=0)) append="*";

 if(!classify) append="";

 switch(sizeformat){
  case NSIZE: bsize[0]='\0'; break;
  case KSIZE: sprintf(bsize,"%4lu ",(ffblk->ff_fsize)/1024); break;
  case PSIZE: sprintf(bsize,"%4lu ",(ffblk->ff_fsize)/512);  break;
  default   : printf("Bug !\n");
 }

 if(manglename)
      sprintf(msdosname,"[%-12.12s] ",ffblk->ff_name);
 else msdosname[0]='\0';

 if(verbose)
 {
 /* Creation des caracteres de la date (Jan 22 23:30) */
 getdate(&today);

 switch(timetype){
  case MTIME: unixtodos(entry->entry.mtime, &dt, &tm); break;
  case CTIME: unixtodos(entry->entry.ctime, &dt, &tm); break;
  case ATIME: unixtodos(entry->entry.atime, &dt, &tm); break;
  default   : printf("Bug !\n");
 }

 /* Not the right test ! if not same year, print year instead of time. */
 if(dt.da_year==today.da_year){
 sprintf(date,"%s %2d %02d:%02d ", month[dt.da_mon],
				   dt.da_day,
				   tm.ti_hour,
				   tm.ti_min
				   );
 }else{
 sprintf(date,"%s %2d  %4d ", month[dt.da_mon],
			      dt.da_day,
			      dt.da_year);
 }

 /* Facon d'indiquer un Hard Link ... les infos sont a prendre entre "" */
 if((entry->entry.flags)&UMSDOS_HLINK) permstr[0]='~';

 /* Gestion diferente des devices */
  if((S_ISCHR(entry->entry.mode))||(S_ISBLK(entry->entry.mode))){
   sprintf(size,"%3u,%3u ",entry->entry.rdev>>8,entry->entry.rdev&0xff);
  }else{
   sprintf(size,"%8lu ",ffblk->ff_fsize);
  }

 if(numeric){
  sprintf(struid,"%-5u ", entry->entry.uid);
  sprintf(strgid,"%-5u ", entry->entry.gid);
 }else{
  uid=getuser(entry->entry.uid);
  if(uid==NULL){
   sprintf(struid,"%-8u ", entry->entry.uid);
  }else{
   sprintf(struid,"%-8.8s ", uid);
  }
  gid=getgroup(entry->entry.gid);
  if(gid==NULL){
   sprintf(strgid,"%-8u ", entry->entry.gid);
  }else{
   sprintf(strgid,"%-8.8s ", gid);
  }
 }
 uid=struid;
 gid=strgid;

 sprintf(nlink,"%3u ",entry->entry.nlink);

 }else{
 nlink[0]=date[0]=size[0]=permstr[0]='\0';
 gid=uid="";
 }

 /* Impression definitive des informations */
 printf("%s%s%s%s%s%s%s%s%s%s\n",
	 bsize,
	   permstr,
	     nlink,
	       uid,
		 gid,
		   size,
		     date,
		       msdosname,
			 entry->entry.name,
			   append);
 return 0;
}



#pragma argsused
int NotImplementedSort(struct dirent **a ,struct dirent **b){
	static i=1;
	if(i){
		printf("Sorry this sort is not yet implemented.\n");
		i=0;
	}
	return 0;
}

int msdossort(struct dirent **a ,struct dirent **b){
	return strcmp ((*a)->fake.fname, (*b)->fake.fname);
}

#define sign(x,y) x>=y?x>y:-1

int mtimesort(struct dirent **a ,struct dirent **b){
	return sign((*a)->entry.mtime,(*b)->entry.mtime);
}

int ctimesort(struct dirent **a ,struct dirent **b){
	return sign((*a)->entry.ctime,(*b)->entry.ctime);
}

int atimesort(struct dirent **a ,struct dirent **b){
	return sign((*a)->entry.atime,(*b)->entry.atime);
}

/* Compare file extensions.  Files with no extension are `smallest'.
   If extensions are the same, compare by filenames instead. */

int compare_extension(struct dirent **a ,struct dirent **b)
{
  char *base1, *base2;
  register int cmp;

  base1 = strrchr ((*a)->entry.name, '.');
  base2 = strrchr ((*b)->entry.name, '.');
  if (base1 == 0 && base2 == 0)
    return strcmp ((*a)->entry.name, (*b)->entry.name);
  if (base1 == 0)
    return -1;
  if (base2 == 0)
    return 1;
  cmp = strcmp (base1, base2);
  if (cmp == 0)
    return strcmp ((*a)->entry.name, (*b)->entry.name);
  return cmp;
}

__dir_compar_fn_t sortfnct[]={
	NULL,				/* ZEROSORT         */
	alphasort,			/* NAMESORT        */
	compare_extension,		/* EXTSORT        */
	msdossort,			/* MSDOSSORT     */
	NotImplementedSort,		/* SIZESORT     */
	mtimesort,			/* MTIMESORT   */
	atimesort,			/* ATIMESORT  */
	ctimesort			/* CTIMESORT */
	};

int rev_alphasort(struct dirent **a ,struct dirent **b)
{
  return strcmp ((*b)->entry.name, (*a)->entry.name);
}

int rev_compare_extension(struct dirent **a ,struct dirent **b)
{
  char *base1, *base2;
  register int cmp;

  base1 = strrchr ((*a)->entry.name, '.');
  base2 = strrchr ((*b)->entry.name, '.');
  if (base1 == 0 && base2 == 0)
    return strcmp ((*a)->entry.name, (*b)->entry.name);
  if (base1 == 0)
    return -1;
  if (base2 == 0)
    return 1;
  cmp = strcmp (base1, base2);
  if (cmp == 0)
    return strcmp ((*a)->entry.name, (*b)->entry.name);
  return cmp;
}

int rev_msdossort(struct dirent **a ,struct dirent **b){
	return strcmp ((*b)->fake.fname, (*a)->fake.fname);
}

int rev_mtimesort(struct dirent **a ,struct dirent **b){
	return sign((*b)->entry.mtime,(*a)->entry.mtime);
}

int rev_ctimesort(struct dirent **a ,struct dirent **b){
	return sign((*b)->entry.ctime,(*a)->entry.ctime);
}

int rev_atimesort(struct dirent **a ,struct dirent **b){
	return sign((*b)->entry.atime,(*a)->entry.atime);
}

__dir_compar_fn_t rev_sortfnct[]={
	NULL,				/* ZEROSORT         */
	rev_alphasort,			/* NAMESORT        */
	rev_compare_extension,		/* EXTSORT        */
	rev_msdossort,			/* MSDOSSORT     */
	NotImplementedSort,		/* SIZESORT     */
	rev_mtimesort,			/* MTIMESORT   */
	rev_atimesort,			/* ATIMESORT  */
	rev_ctimesort			/* CTIMESORT */
	};

int select(struct dirent *entry)
{
if((entry->entry.flags)&UMSDOS_HIDDEN) 				return 0;
if((!almost)&&entry->entry.name[0]=='.')      			return 0;
if(Backup&&entry->entry.name[entry->entry.name_len-1]=='~')	return 0;
return 1;
}

int linuxdir(char *dirfile)
{
struct ffblk *ffblk;
struct dirent ***namelist;
int nbr,i;

/* Scan the directory DIR, calling SELECT on each directory entry.
   Entries for which SELECT returns nonzero are individually malloc'd,
   sorted using qsort with CMP, and collected in a malloc'd array in
   *NAMELIST.  Returns the number of entries selected, or -1 on error.  */

 nbr=scandir(dirfile,namelist,select,rev?sortfnct[sort]:sortfnct[sort]);

/*printf("0........1.........2.........3.........4.........5.........6.........7\n");*/
/*printf("1234567890123456789012345678901234567890123456789012345678901234567890\n");*/

 if (nbr>=0){
	for(i=0;i<nbr;i++){
		if((ffblk=infomsdos(namelist[0][i]->fake.fname))!=NULL){
			display_linux_info(ffblk, namelist[0][i]);
		}
		free(namelist[0][i]);
	}
	free(namelist);
 }

 return nbr;
}

/* Mets a la queue leu-leu les arguments 1 a N */
int mergearg (char *res ,int argc, char *argv[])
{
 int i;

 for (i=1;i<argc;i++)
  {
  strcat(res, argv[i]);
  strcat(res, " ");
  }
 return 0;
}

int main (int argc, char *argv[])
{
 char *dosarg;
 char argument[256];

 argument[0]='\0';
 mergearg (argument , argc, argv);
 dosarg=argument;

 optin(argc,argv);

 if(forcedos){
  for(;;){
  if(dosarg[0]=='-'){dosarg++;dosarg++;break;}
  dosarg++;
  }
 }

 if(help)
  {
  printf("LS.EXE to display Linux information of UMSDOS File Systeme.\n"
	 "Made by Glaude David (dglaude@is1.ulb.ac.be) [Glu]\n"
	 "A lot of code taken from UMSDOS FS made by Jacques Gelinas\n"
	 "Some code hacked from The GNU C Library\n"
	 "This is ls Version " LS_VERSION "\n"
	 "Made for UMSDOS Version %d.%d\n"
	 "\n"
	 "Option implemented     -" OK	"\n"
	 "       by default      -" DEFAULT "\n"
	 "       not implemented -" NOTYET  " see doc for description.\n",
	 UMSDOS_VERSION,UMSDOS_RELEASE);
  return 0;
  }

 if(!msdos){
  if(linuxdir(UMSDOS_EMD_FILE)==-1){
  msdos=1;
  }
 }

 if (msdos)msdosdir(dosarg);
 return 0;
}

