/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_wi4.c non ansi c per windows*/

#include "clos.h"
#pragma hdrstop

#include <commdlg.h>
#include <dir.h>


BOOL CMUFont( HWND hWnd , LPLOGFONT lfFont )
{
 /* ritorna il nuovo font nella lfFont */
 CHOOSEFONT cfTemp;

 cfTemp.lStructSize = sizeof( CHOOSEFONT );
 cfTemp.hwndOwner = hWnd;
 cfTemp.hDC = 0;
 cfTemp.lpLogFont = lfFont;	// Store the result here
 cfTemp.Flags =
   CF_INITTOLOGFONTSTRUCT |
   CF_FORCEFONTEXIST 	| CF_SCREENFONTS	 |
   CF_FIXEDPITCHONLY 	| CF_ENABLETEMPLATE;
 cfTemp.rgbColors = RGB(0,0,0);     
 cfTemp.lCustData = 0L;
 cfTemp.lpfnHook = NULL;
 cfTemp.lpTemplateName = NULL;
 cfTemp.hInstance = hInst;
 cfTemp.lpszStyle = NULL;
 cfTemp.nFontType = SCREEN_FONTTYPE;
 cfTemp.nSizeMin = 0;
 cfTemp.nSizeMax = 0;
 cfTemp.lpTemplateName="FontDlg";
 return ChooseFont( &cfTemp );
}

DWORD CMUFileOpen( HWND hWnd,char* szName,int lenght )
{
 OPENFILENAME ofnTemp;
 char szTemp[] = "Lisp Files (*.lsp)\0*.lsp\0All Files (*.*)\0*.*\0";
// char curdir[MAXDIR];
/*
Note the initialization method of the above string.  The GetOpenFileName()
function expects to find a string in the OPENFILENAME structure that has
a '\0' terminator between strings and an extra '\0' that terminates the
entire filter data set.  Using the technique shown below will fail because
"X" is really 'X' '\0' '\0' '\0' in memory.  When the GetOpenFileName()
function scans szTemp it will stop after finding the extra trailing '\0'
characters.

	char szTemp[][4] = { "X", "*.*", "ABC", "*.*", "" };

The string should be "X\0*.*\0ABC\0*.*\0".

Remember that in C or C++ a quoted string is automatically terminated with
a '\0' character so   char "X\0";   would result in 'X' '\0' '\0' which
provides the extra '\0' that GetOpenFileName() needs to see in order to
terminate the scan of the string.  Just 'char ch "X";' would result in 'X'
'\0' and GetOpenFileName() would wander off in memory until it lucked into
a '\0' '\0' character sequence.
*/

/*
Some Windows structures require the size of themselves in an effort to
provide backward compatibility with future versions of Windows.  If the
lStructSize member is not set the call to GetOpenFileName() will fail.
*/
// getcurdir(0,(char*)curdir);

 ofnTemp.lStructSize = sizeof( OPENFILENAME );
 ofnTemp.hwndOwner = hWnd;	// An invalid hWnd causes non-modality
 ofnTemp.hInstance = hInst;
 ofnTemp.lpstrFilter = (LPSTR)szTemp;	// See previous note concerning string
 ofnTemp.lpstrCustomFilter = NULL;
 ofnTemp.nMaxCustFilter = 0;
 ofnTemp.nFilterIndex = 1;
 ofnTemp.lpstrFile = (LPSTR)szName;	// Stores the result in this variable
 ofnTemp.nMaxFile = lenght;
 ofnTemp.lpstrFileTitle = NULL;
 ofnTemp.nMaxFileTitle = 0;
 ofnTemp.lpstrInitialDir = NULL;
 ofnTemp.lpstrTitle = "Load LISP File";	// Title for dialog
 ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST |OFN_ENABLETEMPLATE;
 ofnTemp.nFileOffset = 0;
 ofnTemp.nFileExtension = 0;
 ofnTemp.lpstrDefExt = "lsp";
 ofnTemp.lCustData = NULL;
 ofnTemp.lpfnHook = NULL;
 ofnTemp.lpTemplateName = "DIALOG_1";
/*
If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
to retrieve the type of error that occured.
*/
 if(GetOpenFileName( &ofnTemp ) != TRUE){
//   chdir("\\");
//   chdir(curdir);
   return CommDlgExtendedError();
 }
// chdir("\\");
// chdir(curdir);
 return 0L;
}


