; Graphic Lisp
; dama By Zoia Andrea
; generazione della lista delle mosse possibili 
; Funzione ''esportata,, NEW-crea-lista-mosse
;    genera la lista delle mosse possibili per un colore.


(setf *debug_lm* nil)



(defun NEW-trova-mosse-normali (pezzo posizione &aux retlist)
 ; ritorna una lista ( (posiz posiz) (posiz posiz) .. )
  
  (dolist (offset (elt *mosse_pezzi* pezzo) retlist)  
    (when 
      (=0 (elt *scacchiera* (+ posizione offset)))
      (if
        (or
          (and 
            (= pezzo *pedina_bianca*)
            (> (+ posizione offset) 80)  
          )
          (and
            (= pezzo *pedina_nera*)
            (< (+ posizione offset) 20)
          )
        )
        (setf retlist (append retlist (list(list posizione (+ posizione offset 1000)))))
        (setf retlist (append retlist (list(list posizione (+ posizione offset)))))
      )
    )
  )  
)

(defun NEW-aggancia-mosse (posizione mosse &aux retlist)
  (if mosse
    (dolist (mossa mosse retlist)
      (setf retlist (append retlist (list (cons posizione mossa))))
    )
    ( list(list posizione))  
  )
)


(defun NEW-trova-mosse-mangianti (pezzo posizione &aux retlist)
  (if (setf retlist (NEW-mosse-mangianti pezzo posizione))
    (NEW-aggancia-mosse posizione retlist)
    nil
  )
)


(defun NEW-mosse-mangianti(pezzo posizione &aux retlist d-offset s-offset pezzo-mangiato)
;ritorna una lista  ( (posiz_mangiante1 posiz_mangiante2 .. ) .. )
 
(cond
  ((= *pedina_bianca* pezzo)
    (dolist (offset '(9 11) retlist)
     (setf s-offset (+ offset posizione))
     (setf d-offset (+ posizione (* 2 offset)))
     (when
       (and  
         (= *pedina_nera* (elt *scacchiera* s-offset))
         (=0 (elt *scacchiera* d-offset))   
       )
       ; mangia
       (setf (elt *scacchiera* posizione) 0)
       (setf (elt *scacchiera* s-offset ) 0)
       (if  (> d-offset 80)
         ; diventando damone 
         (progn
           (setf (elt *scacchiera* d-offset) *damone_bianco*)
           (setf retlist 
             (append 
               retlist
               (NEW-aggancia-mosse 
                 (+ 1000 d-offset )
                 (NEW-mosse-mangianti *damone_bianco* d-offset )
               )
             )
          )
        )
        ;resta pedina
        (progn
          (setf (elt *scacchiera* d-offset) *pedina_bianca*)
          (setf retlist 
            (append 
              retlist
              (NEW-aggancia-mosse 
                d-offset
                (NEW-mosse-mangianti *pedina_bianca* d-offset)
              )
            )
          )
        )
      ); end if
      (setf (elt *scacchiera* posizione) pezzo)
      (setf (elt *scacchiera* s-offset) *pedina_nera*)
      (setf (elt *scacchiera* d-offset) 0)
    ); end when
  ); end dolist
  ); end cond pedina bianca   

  ((= *pedina_nera* pezzo)
    (dolist (offset '(-9 -11) retlist)
     (setf s-offset (+ offset posizione))
     (setf d-offset (+ posizione (* 2 offset)))
     (when
       (and  
         (= *pedina_bianca* (elt *scacchiera* s-offset))
         (=0 (elt *scacchiera* d-offset))   
       )
       ; mangia
       (setf (elt *scacchiera* posizione) 0)
       (setf (elt *scacchiera* s-offset ) 0)
       (if  (< d-offset 20)
         ; diventando damone 
         (progn
           (setf (elt *scacchiera* d-offset) *damone_nero*)
           (setf retlist 
             (append 
               retlist
               (NEW-aggancia-mosse 
                 (+ 1000 d-offset )
                 (NEW-mosse-mangianti *damone_nero* d-offset )
               )
             )
          )
        )
        ;resta pedina
        (progn
          (setf (elt *scacchiera* d-offset) *pedina_nera*)
          (setf retlist 
            (append 
              retlist
              (NEW-aggancia-mosse 
                d-offset
                (NEW-mosse-mangianti *pedina_nera* d-offset)
              )
            )
          )
        )
      ); end if
      (setf (elt *scacchiera* posizione) pezzo)
      (setf (elt *scacchiera* s-offset) *pedina_bianca*)
      (setf (elt *scacchiera* d-offset) 0)
    ); end when
  ); end dolist
  ); end cond pedina nera   

  ((= *damone_bianco* pezzo)
    (dolist (offset '(9 11 -9 -11) retlist)
     (setf s-offset (+ offset posizione))
     (setf d-offset (+ posizione (* 2 offset)))
     (when
       (and  
         (or 
           (= *pedina_nera* (elt *scacchiera* s-offset))
           (= *damone_nero* (elt *scacchiera* s-offset))
         )
         (=0 (elt *scacchiera* d-offset))   
       )
       (setf pezzo-mangiato (elt *scacchiera* s-offset))
       ; mangia
       (setf (elt *scacchiera* posizione) 0)
       (setf (elt *scacchiera* s-offset ) 0)
       (setf (elt *scacchiera* d-offset) *damone_bianco*)
       (setf retlist 
         (append 
           retlist
           (NEW-aggancia-mosse 
            d-offset
             (NEW-mosse-mangianti *damone_bianco* d-offset)
           )
         )
       )
      (setf (elt *scacchiera* posizione) pezzo)
      (setf (elt *scacchiera* s-offset) pezzo-mangiato)
      (setf (elt *scacchiera* d-offset) 0)
    ); end when
  ); end dolist
  ); end cond damone bianco

  ((= *damone_nero* pezzo)
    (dolist (offset '(9 11 -9 -11) retlist)
     (setf s-offset (+ offset posizione))
     (setf d-offset (+ posizione (* 2 offset)))
     (when
       (and  
         (or 
           (= *pedina_bianca* (elt *scacchiera* s-offset))
           (= *damone_bianco* (elt *scacchiera* s-offset))
         )
         (=0 (elt *scacchiera* d-offset))   
       )
       (setf pezzo-mangiato (elt *scacchiera* s-offset))
       ; mangia
       (setf (elt *scacchiera* posizione) 0)
       (setf (elt *scacchiera* s-offset ) 0)
       (setf (elt *scacchiera* d-offset) *damone_nero*)
       (setf retlist 
         (append 
           retlist
           (NEW-aggancia-mosse 
            d-offset
             (NEW-mosse-mangianti *damone_nero* d-offset)
           )
         )
       )
      (setf (elt *scacchiera* posizione) pezzo)
      (setf (elt *scacchiera* s-offset) pezzo-mangiato)
      (setf (elt *scacchiera* d-offset) 0)
    ); end when
  ); end dolist
  ); end cond damone nero
))

(defun NEW-crea-lista-mosse (colore &aux normal-retlist mangia-retlist pezzo)
  (do (( i 11 (1+ i))) ( (= i 91) (if mangia-retlist mangia-retlist normal-retlist) )
    (setf pezzo (elt *scacchiera* i))
    (when 
      (or
        (and
          (= colore *bianco*)
          (or
            ( = pezzo *pedina_bianca*) 
            ( = pezzo *damone_bianco*)
          )           
        )
       (and
          (= colore *nero*)
          (or
            ( = pezzo *pedina_nera*) 
            ( = pezzo *damone_nero*)
          )           
       )
     )
     (unless (setf mangia-retlist (append mangia-retlist (NEW-trova-mosse-mangianti pezzo i)))
       (setf normal-retlist (append normal-retlist (NEW-trova-mosse-normali pezzo i)))
     )
   )
 )
)

      
         
(when *debug_lm*

(setf *bianco* 1)
(setf *nero* 2)
(setf *pedina_bianca* 1)
(setf *pedina_nera* 2)
(setf *damone_bianco* 3)
(setf *damone_nero* 4)

(setf *mosse_pezzi* '(
  (+9 +11 )	 	;pedina bianca
  (-9 -11 )		;pedina nera
  (+9 +11 -9 -11)	;damone bianco
  (+9 +11 -9 -11)	;damone nero
))

(setf *scacchiera* '(
100 100 100 100 100 100 100 100 100 100
100  1   0   0   0   1   0   0   0  100
100  0   1   0   1   0   1   0   1  100
100  0   0   1   0   0   0   0   0  100
100  0   0   0   1   0   0   0   0  100
100  0   0   2   0   0   0   0   0  100
100  0   1   0   2   0   2   0   2  100
100  2	 0   2	 0   2	 0   2	 0  100
100  0	 2   0	 0   0	 0   0	 2  100
100 100 100 100 100 100 100 100 100 100))
)


