/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closnans.h */
/*                  DEFINIZIONI NON STANDARD ANSI-C             	*/
/*     OVVERO FUNZIONI NON COMPATIBILI TRA LE VARIE VERSIONI DEGLI	*/
/*     AMBIENTI E DEI COMPILATORI					*/



#define KEY_ESC	27

int 	clos_non_ansi_init();
void 	clos_non_ansi_exit();

int	cl_beep();
int  	cl_getch();
long 	na_millitime();

void 	stack_backtrace();


/* FILE *f, legge un carattere dal file f, la lettura di stdin  bufferizzata */
/* cio si legge tutta una linea e poi la si spedisce. */
/* ritorna il carattere oppure EOF se c' qualche errore */
/* ritorna anche il newline finale */
/* NB: se si legge EOF(-1) da uno stream verr ritornato EOF(-1) */
int     lisp_get_char();

/* char *s, int len,FILE *f leggi la stringa s dal file f, al massimo */
/* lunga len caratteri senza lo zero finale. la stringa non conterr l'eventuale newline finale. */
/* ritorna len oppure EOF se c' qualche errore */
/* se si legge da stdin il cursore verr messo alla fine della stringa */
/* dopo l'ultimo carattere,inoltre la stringa verr inizializzata con s */
int	lisp_get_string();

/* int c, FILE *f stampa il carattere c sul file f, ritorna c oppure EOF se c'e' qualche errore */
/* se si stampa su stdout o stderr si stampa anche su dribble file */
/* NB: si pu anche stampare EOF (-1) sul file ed il valore ritornato sar*/
/* comunque EOF */
int	lisp_put_char();

/* char *s, FILE *f stampa la stringa sul file f, ritorna l'ultimo carattere */
/* EOF se c' qualche errore. se si stampa su stdout o stderr si stampa anche sul dribble file */
int	lisp_print_string();

/* setta la posizione del cursore */
int	lisp_curpos();

int	lisp_charcolor();

/* cancella lo schermo di testo */
int	lisp_cls();


void lg_opengraph();
int  lg_graphopen();
void lg_cleargraph();
void lg_pencolor();
void lg_pentick();
void lg_pentype();
void lg_brushcolor();
void lg_brushtype();
void lg_putpixel();
long lg_getpixel();
void lg_moveto();
void lg_lineto();
void lg_fillpoly();
void lg_fillellipse();
void lg_fillsector();
void lg_graphtext();
