/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* File closerr.h */

/*  unsigned err_type     xxxx MMMM PPPP TTTT  */
/* P=tipo del puntatore */
/* T=tipo dell' errore  */
/* M=tipo del messaggio */

#define ERR_TMASK		0xf
#define ERR_TNORM		0x0	/* la funzione ritorna ERROR */
#define ERR_TCRIT		0x1	/* la funzione fa un longjump */
					/* verso il main-loop */
#define ERR_TBLVL		0x2	/* come sopra ma si ritorna */
					/* al break-level corrente */

#define ERR_PMASK		0xf0
#define ERR_PVOID		0x00	/* il puntatore e' NULL */
#define ERR_PSTRING		0x10	/* il puntatore e' char */
#define ERR_PNODE		0x20	/* il puntatore e' un nodo */	
#define ERR_PNINT		0x30	/* il puntatore e' un n_int */

#define ERR_MMASK		0xf00
#define ERR_MERROR		0x100	/* ERROR: */
#define ERR_MWARN		0x200	/* WARNING: */
#define ERR_MINTERNAL		0x300	/* INTERNAL: */
#define ERR_MNONE		0x400	/* non si stampa nulla e si salta */
					/* al punto specificato da ERR_TXXXX */
#define ERR_MERRORMSGBOX	0x500
#define ERR_MINTERNALMSGBOX	0x600
#define ERR_MWARNMSGBOX		0x700

#define LONGJMP_SET		0	
#define LONGJMP_CRITICAL	1	/* errore critico ad.es quando e' */
					/* finita la memoria */
					/* questo errore non e'recuperabile */
#define LONGJMP_STACK		2	/* stack overflow */
#define LONGJMP_CONTROLC	3	/* control-c schiacciato */
#define LONGJMP_ERROR		4	/* errore recuperabile */
#define LONGJMP_CONTINUE	5	/* usato dalla funzione CONTINUE */
					/* per uscire dal break-loop */
#define LONGJMP_ASYNCLOAD	6	/* Per caricare un file*/


#define E_ZERO                  0
#define E_SUPERDUP              1
#define E_CMDLINE               2
#define E_CTRLC                 3
#define E_STACK                 4
#define E_CNFFILE               5
#define E_PRINT_BAD1            6
#define E_PRINT_BAD2            7
#define E_HASHFULL              8
#define E_UNMATCHCLASS          9 

#define E_AMBIGUOUSMETHOD       10 
#define E_UNMATCHEDMETHOD       11 
#define E_INITARGREDEF          12 
#define E_INVALIDSQB            13
#define E_IDLONG                14
#define E_STRLONG               15
#define E_BADCH			16
#define E_PAGES			17
#define E_NOMEMNODES		18
#define E_BAD_TYPE_GC		19

#define E_NOMEMSTRINGS		20
#define E_GCS1			21
#define E_GCS2			22
#define E_GCS3			23
#define E_EOF			24
#define E_YACCSTACK		25
#define E_SYNTAX		26
#define E_BADSTRING		27
#define E_DIVBYZERO		28
#define E_BADIL			29

#define E_NODEINIT		30
#define E_HASHINIT              31
#define E_STRINGINIT            32
#define E_UNBOUND		33
#define E_BADFUNC		34
#define E_FEWARGS		35
#define E_BADARGS		36
#define E_BADLIST		37
#define E_BADSETF		38
#define E_TOOMANYARGS		39

#define E_LAMBDASYNTAX		40
#define E_SLAMBDA		41
#define E_BADPOINTER		42
#define E_BADFILE		43
#define E_BADSL			44
#define E_UNBOUNDFUNC		45
#define E_CHEKZ			46
#define E_INVALIDCFGFILE	47
#define E_BADLABEL		48
#define E_BADRETURN		49

#define E_BADCONTINUE		50
#define E_ACCESSORREDEF		51
#define E_DEFCLASSYNTAX		52
#define E_CLASSREDEF		53
#define E_UNBOUNDCLASS		54
#define E_BAD3DP		55
#define E_TEXTMODE              56
#define E_TOOMANYPOINTS         57
#define E_OVERFLOW		58
#define E_MATH			59
#define E_NULLGC		60

#define E_STRTOOLONG		61
#define E_BADNCCOUNT		62
#define E_BADGO			63
#define E_NOMEMPOINTS		64
#define E_CLOSSTR2ERR		65

#define E_LAST                  66


int error();






