/**********************************************************************
 *
 *    FILE:            TextureCubeMap.cpp
 *
 *    DESCRIPTION:    Read/Write osg::TextureCubeMap in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "TextureCubeMap.h"
#include "Texture.h"
#include "Image.h"

using namespace ive;

void TextureCubeMap::write(DataOutputStream* out){
    // Write TextureCubeMap's identification.
    out->writeInt(IVETEXTURECUBEMAP);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Texture*  tex = dynamic_cast<osg::Texture*>(this);
    if(tex){
        ((ive::Texture*)(tex))->write(out);
    }
    else
        throw Exception("TextureCubeMap::write(): Could not cast this osg::TextureCubeMap to an osg::Texture.");
    // Write TextureCubeMap's properties.

    // Write texture size
    out->writeInt(getTextureWidth());
    out->writeInt(getTextureHeight());

    // Write number of mipmap levels
    out->writeInt(getNumMipmapLevels());

    if (out->getVersion() >= VERSION_0029)
    {
        out->writeImage(getImage(osg::TextureCubeMap::POSITIVE_X));
        out->writeImage(getImage(osg::TextureCubeMap::NEGATIVE_X));
        out->writeImage(getImage(osg::TextureCubeMap::POSITIVE_Y));
        out->writeImage(getImage(osg::TextureCubeMap::NEGATIVE_Y));
        out->writeImage(getImage(osg::TextureCubeMap::POSITIVE_Z));
        out->writeImage(getImage(osg::TextureCubeMap::NEGATIVE_Z));
    }
    else
    {
        // Should we include images date in stream
        IncludeImageMode includeImg = out->getIncludeImageMode(getImage(osg::TextureCubeMap::POSITIVE_X));
        out->writeChar(includeImg);

        out->writeImage(includeImg,getImage(osg::TextureCubeMap::POSITIVE_X));
        out->writeImage(includeImg,getImage(osg::TextureCubeMap::NEGATIVE_X));
        out->writeImage(includeImg,getImage(osg::TextureCubeMap::POSITIVE_Y));
        out->writeImage(includeImg,getImage(osg::TextureCubeMap::NEGATIVE_Y));
        out->writeImage(includeImg,getImage(osg::TextureCubeMap::POSITIVE_Z));
        out->writeImage(includeImg,getImage(osg::TextureCubeMap::NEGATIVE_Z));
    }
}

void TextureCubeMap::read(DataInputStream* in)
{
    // Peek on TextureCubeMap's identification.
    int id = in->peekInt();
    if(id == IVETEXTURECUBEMAP){
        // Read TextureCubeMap's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Texture* tex = dynamic_cast<osg::Texture*>(this);
        if(tex){
            ((ive::Texture*)(tex))->read(in);
        }
        else
            throw Exception("TextureCubeMap::read(): Could not cast this osg::TextureCubeMap to an osg::Texture.");
        // Read TextureCubeMap's properties

        // Read texture size
        int width = in->readInt();
        int height = in->readInt();
        setTextureSize(width, height);

        // Read number of mipmap levels
        setNumMipmapLevels((unsigned int)in->readInt());

        if (in->getVersion() >= VERSION_0029)
        {
            setImage(osg::TextureCubeMap::POSITIVE_X,in->readImage());
            setImage(osg::TextureCubeMap::NEGATIVE_X,in->readImage());
            setImage(osg::TextureCubeMap::POSITIVE_Y,in->readImage());
            setImage(osg::TextureCubeMap::NEGATIVE_Y,in->readImage());
            setImage(osg::TextureCubeMap::POSITIVE_Z,in->readImage());
            setImage(osg::TextureCubeMap::NEGATIVE_Z,in->readImage());
        }
        else
        {
            // Should we read image data from stream
            IncludeImageMode includeImg = (IncludeImageMode)in->readChar();

            setImage(osg::TextureCubeMap::POSITIVE_X,in->readImage(includeImg));
            setImage(osg::TextureCubeMap::NEGATIVE_X,in->readImage(includeImg));
            setImage(osg::TextureCubeMap::POSITIVE_Y,in->readImage(includeImg));
            setImage(osg::TextureCubeMap::NEGATIVE_Y,in->readImage(includeImg));
            setImage(osg::TextureCubeMap::POSITIVE_Z,in->readImage(includeImg));
            setImage(osg::TextureCubeMap::NEGATIVE_Z,in->readImage(includeImg));
        }
        
    }
    else{
        throw Exception("TextureCubeMap::read(): Expected TextureCubeMap identification.");
    }
}

