#ifdef WIN32

typedef long long int s64;

int win32_open(const char* name, int mode);
s64 win32_bias(const int fd);
long win32_signature(const int fd);
int win32_drivenumber(const int fd);
int win32_partnumber(const int fd);
char* win32_device(const int fd);
s64 win32_filepos(const int fd);
s64 win32_lseek(const int fd, s64 pos, int mode);
s64 win32_read(const int fd, const void* buffer, s64 count);
s64 win32_write(const int fd, const void* buffer, s64 count);
int win32_close(const int fd);

#define open win32_open
#define lseek win32_lseek
#define close win32_close
#define read win32_read
#define off_t s64

extern int win32_fd;
extern int win32_quiet;

#endif
