/*
 * win32.c: a stdio-like disk I/O implementation for low-level disk access on Win32
 *          can access an NTFS-volume while mounted!
 */

#include <windows.h>
#include <winioctl.h>

#include <stdio.h>
#include <ctype.h>

#include "win32.h"
//#define DEBUG 
//#define FORCE_ALIGNED_READ
#define SUPPORT_DOS_NAMES
#define SUPPORT_LINUX_NAMES
#define SUPPORT_GRUB_NAMES

typedef struct {
  HANDLE handle;
  LARGE_INTEGER part_start;
  LARGE_INTEGER part_end;
  LARGE_INTEGER current_pos;
} win32_fd_t;

main() {

  char filename[256];
  sprintf(filename, "\\\\.\\A:");
  HANDLE handle = CreateFile(filename,
							 GENERIC_READ, 
							 FILE_SHARE_READ, 
							 NULL, 
							 OPEN_EXISTING, 
							 FILE_ATTRIBUTE_SYSTEM,
							 NULL);
  if (handle == INVALID_HANDLE_VALUE) {
	char msg[1024];
	sprintf(msg,"CreateFile(%s) failed", filename);
	perror(msg);
	return -1;
  }
  
  char b[1024];
  int count = 512;
  DWORD numread;
  
  BOOL rvl = ReadFile(handle, (LPVOID)b, 
				 count, &numread, (LPOVERLAPPED)NULL);

  {
	int i;
	for(i=0; i<count; i++) {
	  unsigned char c = ((unsigned char*)b)[i];
	  printf("%02x ",c);
	}
	for(i=0; i<count; i++) {
	  unsigned char c = ((unsigned char*)b)[i];
	  printf("%c",isprint(c)?c:'.');
	}
	printf("\n");
  }

  CloseHandle(handle); 
}
