#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define FSYS_NTFS
#define WITHOUT_LIBC_STUBS 1

#define GRUB_UTIL
#include "../grub/stage2/shared.h"
#include "../grub/stage2/fsys_ntfs.c"

#include "win32.h"
#include "blocklist.h"


#include <windows.h>

char*
ntfs_blocklist(char* device, char* path) {
  char* rvl = NULL;

  errnum = 0;

  if (path[1] == ':') { path += 2; };

  grub_scratch_mem = VirtualAlloc(NULL, 0x100000, MEM_COMMIT, PAGE_READWRITE);
  if (grub_scratch_mem == NULL) {
	printf("VirtualAlloc failed\n");
	return NULL;
  }
  win32_fd = win32_open(device, 0);
  if (win32_fd <0) {
	return NULL;
  }
  filepos = win32_filepos(win32_fd);
  if (!ntfs_mount()) {
	if (!win32_quiet) {
	  printf("NTFS mount failed\n");
	}
  } else {
	if (!win32_quiet) {
	  printf("NTFS mount succeeded\n");
	}
	// some function needs the path to be writable...
	char writable_path[1024];
	sprintf(writable_path, path);
	if (!ntfs_dir(writable_path)) {
	  if (!win32_quiet) {
		printf("NTFS dir failed for %s\n", path);
	  }
	} else {
	  //printf("filemax=%d\n", filemax);
	  disk_read_func = disk_read_hook = blocklist_func;
	  int filesize = 0;
	  char buffer[512];
	  blocklist_init(win32_bias(win32_fd)/SECTOR_SIZE);
	  for(filesize=filemax; filesize>0; filesize-=sizeof(buffer)) {
		ntfs_read(buffer, sizeof(buffer));
	  }
	  disk_read_hook = NULL;
	  rvl = blocklist();
	}
  }
  win32_close(win32_fd);

  VirtualFree(grub_scratch_mem, 0, MEM_RELEASE);
  return rvl;
}
