#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>

#include "win32.h"

const long DISKID = 0x01B8;

char opts[]="av";

int
main(int argc, char* argv[]) 
{
  char* device = "C:";
  char devicename[256];

  int verbose=0;
  int alternate=0;
  int c;
  do {
	c = getopt(argc, argv, opts);
	switch (c) {
	case 'v':
	  verbose=1;
	  break;
	case 'a':
	  alternate=1;
	  break;
	case EOF:
	  device = argv[optind];
	  break;
	}
  } while (c>0);

  sprintf(devicename, "\\DosDevices\\%s", device);
  char* keyname = "SYSTEM\\MountedDevices";
  HKEY hKey;
  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, keyname, 0, KEY_ALL_ACCESS, &hKey) != ERROR_SUCCESS) {
	if (verbose)
	  printf("cannot open registry key %s\n", keyname);
	return -1;
  }
  BYTE deviceid[1024];
  DWORD dwType;
  DWORD dwSize;
  dwSize = sizeof(deviceid);
  if (RegQueryValueEx(hKey, devicename, 0, &dwType, deviceid, &dwSize)!=ERROR_SUCCESS) {
	if (verbose)
	  printf("cannot query registry value %s\\%s (%ld)\n", keyname, devicename, GetLastError());
	RegCloseKey(hKey);
	return -1;
  }
  RegCloseKey(hKey);

  char target_diskid[64];
  char target_partid[64];
  sprintf(target_diskid, "%02x %02x %02x %02x", 
		  deviceid[0], deviceid[1], deviceid[2], deviceid[3]);
  sprintf(target_partid, "%02x %02x %02x %02x %02x %02x %02x %02x", 
		  deviceid[4], deviceid[5], deviceid[6], deviceid[7],
		  deviceid[8], deviceid[9], deviceid[10], deviceid[11]);
  if (verbose)
	printf("%s = %s %s\n", devicename, target_diskid, target_partid);


  char dev[10];
  char scan_diskid[64]; int disk;
  char scan_partid[64]; int part;
  win32_quiet=1;
  for (disk=0; disk<32; disk++) {
	for (part=0; part<32; part++) {
	  sprintf(dev, "(hd%d,%d)",disk,part);
	  int fd = win32_open(dev, 0);
	  if (fd<0) continue;
	  long long int offset = win32_bias(fd);
	  long signature = win32_signature(fd);
	  int partnumber = win32_partnumber(fd);
	  win32_close(fd);
	  if (offset <= 0) continue;

	  if (alternate) {
		sprintf(dev, "(hd%d,%d)", disk, partnumber-1);
	  }
	  unsigned char* sig=(unsigned char*)&signature;
	  sprintf(scan_diskid, "%02x %02x %02x %02x", sig[0],sig[1],sig[2],sig[3]);
	  unsigned char* ofs=(unsigned char*)&offset;
	  sprintf(scan_partid, "%02x %02x %02x %02x %02x %02x %02x %02x",
			  ofs[0],ofs[1],ofs[2],ofs[3],
			  ofs[4],ofs[5],ofs[6],ofs[7]
			  );
	  if (verbose) {
		printf("partition %-9.9s = partition %d = %s %s\n", dev, partnumber ,scan_diskid, scan_partid);
	  }
	  if (strcmp(target_diskid, scan_diskid)==0 && strcmp(target_partid, scan_partid)==0) {
		printf("%s\n", dev);
	  }
	}
  }

  return 0;
}
