#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>

int win32_fd;
char* boot_blocklist(char* device, char* path);
char* ntfs_blocklist(char* device, char* path);
char* fat_blocklist(char* device, char* path);
int stage1(char* filename, long sector, unsigned char lba, unsigned char drive);
int stage2(char* filename, char* blocklist, char* menu);
char* win32_device(const int fd);
int win32_partnumber(const int fd);
int win32_drivenumber(const int fd);

char* opts = "d:1:2:m:bi:lhvsaB";
char* version = 
"grubinstall v1.0\n";
char* usage = 
"   grubinstall [-d device] [-1 stage1] [-2 stage2] [-m menu] [-l] [-a] [-B]\n"
"   grubinstall [-s] [-1 stage1] [-2 stage2] [-m menu] [-l] [-a]\n"
"   grubinstall [-b] [-1 stage1] [-2 stage2]\n"
"   grubinstall [-i file] [-1 stage1] [-2 stage2]\n"
"       -d C:                  : partition where the files are\n"
"       -d (hd0,0)             : partition where the files are\n"
"       -1 C:\\boot\\stage1      : boot sector\n"
"       -2 C:\\boot\\stage2      : secondary boot loader\n"
"       -m /boot/menu.lst      : grub boot menu\n"
"       -l                     : force LBA mode\n"
"       -b                     : make boot floppy\n"
"       -B                     : store boot disk\n"
"       -i boot.img            : make boot disk image\n"
"       -s                     : scan partitions\n"
"       -a                     : alternate grub partition name for menu\n";
extern int win32_quiet;


char* strip(char* in) {
  char* out = malloc(strlen(in)+1);
  strcpy(out,in);
  char* p = out;
  if ((*out == '\'') || (*out == '\"')) {
	p = out + strlen(out) - 1;
	if (*p == *out) {
	  out++;
	  *p = '\0';
	}
  }
  p = out;
  while (*p != '\0') {
	if (*p == '\\') { *p = '/'; }
	p++;
  }
  //printf("strip(%s)->(%s)\n", in, out);
  return out;
}

int 
grubinstall_main(int argc, char* argv[]) {
  char* floppy = "(fd0)";
  char* device = "C:";
  char default_image1[] = "C:/boot/stage1";
  char default_image2[] = "C:/boot/stage2";
  char* image1 = default_image1;
  char* image2 = default_image2;
  char* menu = "/boot/menu.lst";
  int lba = 0;
  extern int mkbootdisk;
  extern char* bootdevice;
  int scanpart=0;
  int alternate=0;
  int bootdisk=0;

  int c;
  do {
	c = getopt(argc, argv, opts);
	switch (c) {
	case 'v':
	  printf(version);
	  return 0;
	  break;
	case 'd': 
	  device = strip(optarg);
	  if (strlen(device)==2 && device[1]==':' && 
              image1 == default_image1 && image2 == default_image2) {
		image1[0] = device[0];
		image2[0] = device[0];
	  }
	  break;
	case '1':
	  image1 = strip(optarg);
	  break;
	case '2':
	  image2 = strip(optarg);
	  break;
	case 'm':
	  menu = strip(optarg);
	  if (menu[0]=='\0') {
		menu=NULL;
	  }
	  break;
	case 'l':
	  lba = 1;
	  break;
	case 'b':
	  mkbootdisk = 1;
	  bootdevice = floppy;
	  menu = NULL;
	  break;
	case 'i':
	  mkbootdisk = 1;
	  bootdevice = strip(optarg);
	  menu = NULL;
	  break;
	default:
	  printf("unknown option '%c'\n", (char)c);
	case 'h':
	  printf(usage);
	  return 0;
	  break;
	case 's':
	  scanpart=1;
	  break;
	case 'a':
	  alternate=1;
	  break;
	case 'B':
	  bootdisk=1;
	  break;
	case -1:
	  break;
	}
  } while (c>0);

  char* blocklist = NULL;
  char probe[20];
  if (scanpart) {
	win32_quiet=1;
	int j=0,d=0,p=0;
	for(;;) {
	  sprintf(probe,"(hd%d,%d)", d, p);
	  printf("probing %s\n", probe);
	  blocklist = ntfs_blocklist(probe, image2);
	  if (blocklist) break;
	  blocklist = fat_blocklist(probe, image2);
	  if (blocklist) break;
	  do {
		d--;p++;
		if (d<0) {
		  j++;
		  d=j;
		  p=0;
		}
		if (d>16 && p>16) {
		  break;
		}
	  } while (d>16 || p>16);
	  if (d>16 && p>16) {
		break;
	  }
	}
	if (blocklist) {
	  device = probe;
	  printf("probe successful on %s\n", device);
	} else {
	  printf("file %s not found on probed partitions\n", image2);
	  return 0;
	}
  }
  if ((!blocklist) && (mkbootdisk)) {
    blocklist = boot_blocklist(device, image2);
  }
  if (!blocklist && win32_fd>-2) {
     blocklist = ntfs_blocklist(device, image2);
  }
  if (!blocklist && win32_fd>-2) {
    blocklist = fat_blocklist(device, image2);
  }
 
  if (blocklist == NULL) {
	char* p;
	for(p=image2; *p != '\0'; p++) {
	  if (*p == '/') { *p = '\\'; }
	}
	printf("The file %s could not be found on volume %s\n", image2, device);
	return 0;
  }

  int sector = 0;
  if (sscanf(blocklist, "%d", &sector)==0) {
	printf("Cannot parse blocklist\n");
	sector = 0;
  }

  if (bootdisk != 0) {
     bootdisk = 0x80 + win32_drivenumber(win32_fd);
  } else {
     bootdisk = 0xff; 
  }
  if ( stage1(image1, sector, lba, bootdisk) < 0 ) {
	printf("Configuring stage1 failed\n");
	return 0;
  }
  
  if ((menu != NULL) && (menu[1] == ':')) { 
	menu += 2; 
  }

  char altname[10];
  sprintf(altname, "(hd%d,%d)",win32_drivenumber(win32_fd),win32_partnumber(win32_fd));
  if (alternate) {
	device = altname;
  } else {
	device = win32_device(win32_fd);
  }
  if (mkbootdisk) {
	device = bootdevice;
  }

  if ((menu != NULL) && (*menu != '(')){
	char* tmp = malloc(strlen(device) + strlen(menu)+1);
	sprintf(tmp,"%s%s", device, menu);
	menu = tmp;
  }

  if (stage2(image2, blocklist, menu) < 0) {
	printf("Configuring stage2 failed\n");
	return 0;
  }

  printf("stage2 configured on %s.\n", device);

  if (!mkbootdisk)
  if (strcmp(win32_device(win32_fd),altname) != 0 && !alternate) {
	printf("\nThe GRUB partition name might actually be %s\n", altname);
	printf("If you don't get the menu, you might try again with the -a switch\n");
  }
  return 1;
}
