#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define FSYS_FAT
#define WITHOUT_LIBC_STUBS 1

#define GRUB_UTIL
#include "../stage2/shared.h"
#include "../stage2/fsys_fat.c"

#include "win32.h"
#include "blocklist.h"

#include <windows.h>

/* from GRUB/stage2/char_io.c */
int substring (const char *s1, const char *s2)
{
  while (*s1 == *s2)
    {
      /* The strings match exactly. */
      if (! *(s1++))
        return 0;
      s2 ++;
    }

  /* S1 is a substring of S2. */
  if (*s1 == 0)
    return -1;

  /* S1 isn't a substring. */
  return 1;
}

char*
fat_blocklist(char* device, char* path) {
  char* rvl = NULL;

  if (path[1] == ':') { path += 2; };

  errnum = 0;

  grub_scratch_mem = VirtualAlloc(NULL, 0x100000, MEM_COMMIT, PAGE_READWRITE);
  if (grub_scratch_mem == NULL) {
	printf("VirtualAlloc failed\n");
	OutputDebugString("[Bazooka] VirtualAlloc failed\n");
	return NULL;
  }
  win32_fd = win32_open(device, 0);
  if (win32_fd <0) {
    OutputDebugString("[Bazooka] win32_fd <0 \n");
	return NULL;
  }
  filepos = win32_filepos(win32_fd);
  if (!fat_mount()) {
	if (!win32_quiet) {
	  printf("FAT mount failed\n");
	  OutputDebugString("[Bazooka] FAT mount failed \n");
	}
  } else {
	if (!win32_quiet) {
	  printf("FAT mount succeeded\n");
 	  OutputDebugString("[Bazooka] FAT mount succeeded\n");
	}
	// some function needs the path to be writable...
	char writable_path[1024];
	sprintf(writable_path, path);
	if (!fat_dir(writable_path)) {
	  if (!win32_quiet) {
		printf("FAT dir failed for %s\n", path);
		OutputDebugString("[Bazooka] FAT dir failed\n");
	  }
	} else {
	  //printf("filemax=%d\n", filemax);
	  disk_read_func = disk_read_hook = blocklist_func;
	  int filesize = 0;
	  char buffer[512];
	  blocklist_init(win32_bias(win32_fd)/SECTOR_SIZE);
	  for(filesize=filemax; filesize>0; filesize-=sizeof(buffer)) {
		fat_read(buffer, sizeof(buffer));
	  }
	  disk_read_hook = NULL;
	  rvl = blocklist();
	}
  }
  win32_close(win32_fd);

  VirtualFree(grub_scratch_mem, 0, MEM_RELEASE);
  OutputDebugString("[Bazooka] fat_blocklist normal return ! \n");
  return rvl;
}
