#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>

#include "win32.h"

const long DISKID = 0x01B8;

int
main(int argc, char* argv[]) 
{
  char dev[10];
  char diskid[64]; int disk;
  char partid[64]; int part;
  unsigned char buffer[512];
  win32_quiet=1;
  for (disk=0; disk<32; disk++) {

	for (part=0; part<32; part++) {
	  sprintf(dev, "(hd%d,%d)",disk,part);
	  int fd = win32_open(dev, 0);
	  if (fd<0) continue;
	  long long int offset = win32_bias(fd);
	  long signature = win32_signature(fd);
	  win32_close(fd);
	  if (offset <= 0) continue;

	  unsigned char* sig=&signature;
	  sprintf(diskid, "%02x %02x %02x %02x", sig[0],sig[1],sig[2],sig[3]);
	  unsigned char* ofs=&offset;
	  sprintf(partid, "%02x %02x %02x %02x %02x %02x %02x %02x",
			  ofs[0],ofs[1],ofs[2],ofs[3],
			  ofs[4],ofs[5],ofs[6],ofs[7]
			  );
	  printf("partition %-9.9s = %s %s\n", dev, diskid, partid);
	}
  }
  return 0;
}
