#include <stdio.h>
#define GRUB_UTIL
#define WITHOUT_LIBC_STUBS 1
#include "../stage2/shared.h"

char* grub_scratch_mem;

/* these are needed to link the fsys_*.c files */
void print_a_completion(char* p) {
}
int filemax = 1000000;
unsigned long current_drive;
int current_slice;
int print_possibilities = 0;
grub_error_t errnum;

/* GRUB physical device IO routine */

#include "win32.h"
int win32_fd;
int filepos;

void (*disk_read_hook) (int, int, int) = NULL;
void (*disk_read_func) (int, int, int) = NULL;

int devread(int sector, int byte_offset, int byte_len, char* buf) {
  s64 offset;
  offset = ((s64)sector) * SECTOR_SIZE + byte_offset;
  if (win32_fd < 0) return -1;
  offset = win32_lseek(win32_fd, offset, SEEK_SET);
  if (offset == -1) {
	printf("lseek failed?\n");
  }
  int rvl = 0;
  if (buf != NULL) {
	rvl = win32_read(win32_fd, buf, byte_len);
  }
  if (disk_read_hook && disk_read_func) {
	//printf("devread(%d,%d,%d)\n", sector, byte_offset, byte_len);

	int size = byte_len;
	int sector_num = sector;
	while (byte_offset >= SECTOR_SIZE) {
	  sector_num++;
	  byte_offset -= SECTOR_SIZE;	  
	}
	int length = SECTOR_SIZE - byte_offset;
	if (length > size)
	  length = size;
	(*disk_read_hook) (sector_num, byte_offset, length);
	sector_num++;
	length = size - length;
	if (length > 0)
	  {
		while (length > SECTOR_SIZE)
		  {
			(*disk_read_hook) (sector_num++, 0, SECTOR_SIZE);
			length -= SECTOR_SIZE;
		  }
		(*disk_read_hook) (sector_num, 0, length);
	  }
  }
  //filepos = win32_filepos(win32_fd);
  return rvl;
}

