#include <stdio.h>
#define WITHOUT_LIBC_STUBS 1

#define GRUB_UTIL
#include "../stage2/shared.h"

#include "blocklist.h"

char* boot_blocklist(char* device, char* image2) {
  // determine file size
  FILE* fp = fopen(image2, "r");
  if (fseek(fp, 0, SEEK_END)<0) {
	return NULL;
  }
  size_t size = ftell(fp);
  fclose(fp);
  
  blocklist_init(0);
  // we'll write stage2 contiguously, starting at sector number 1
  int i;
  for(i=0; i<(size+SECTOR_SIZE-1)/SECTOR_SIZE; i++) {
	blocklist_func(1+i,0,SECTOR_SIZE);
  }
  return blocklist();
}
