#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define WITHOUT_LIBC_STUBS 1

//#define STAGE2
#define GRUB_UTIL
#include "../stage2/shared.h"


static char global_blocklist[10240] = "";
static char* blocklist_ptr = NULL;
static int last_count;
static int last_sector = -1;
static int sect_before_part;

char* blocklist() {
  //printf("blocklist=%s\n", global_blocklist);
  return global_blocklist;
}

void blocklist_init(int start) {
  //printf("partition starts at sector %d\n", start);
  sect_before_part = start;
  blocklist_ptr = global_blocklist;
  last_sector = -1;
  last_count = 1;
}


// run-length compress the used sectors in GRUB string format
void blocklist_func (int sector, int offset, int length) {
  //fprintf(stderr, "bl(%d,%d,%d)=%s\n", sector, offset, length, global_blocklist);

  if (last_sector < 0) {
	last_count = 1;
	blocklist_ptr += sprintf(blocklist_ptr, "%d+",sector+sect_before_part); 
	sprintf(blocklist_ptr, "%d",last_count); 
  } else if (last_sector != sector-1) {
	blocklist_ptr += sprintf(blocklist_ptr, "%d",last_count); 
	last_count = 1;
	blocklist_ptr += sprintf(blocklist_ptr, ",%d+",sector+sect_before_part); 
	sprintf(blocklist_ptr, "%d",last_count); 
  } else {
	last_count++;
	sprintf(blocklist_ptr, "%d",last_count); 
  }
  last_sector = sector;
}

