# --
# Copyright (C) 2001-2015 OTRS AG, http://otrs.com/
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

use strict;
use warnings;
use utf8;

use vars (qw($Self));

our $ObjectManagerDisabled = 1;

# get needed objects
my $ConfigObject = $Kernel::OM->Get('Kernel::Config');
my $TicketObject = $Kernel::OM->Get('Kernel::System::Ticket');
my $Selenium     = $Kernel::OM->Get('Kernel::System::UnitTest::Selenium');

$Selenium->RunTest(
    sub {

        my $Helper = $Kernel::OM->Get('Kernel::System::UnitTest::Helper');

        my $TestUserLogin = $Helper->TestUserCreate(
            Groups => ['admin'],
        ) || die "Did not get test user";

        $Selenium->Login(
            Type     => 'Agent',
            User     => $TestUserLogin,
            Password => $TestUserLogin,
        );

        my $ScriptAlias = $ConfigObject->Get('ScriptAlias');

        # Create Ticket to test AdminGenericAgent frontend
        my $TicketID = $TicketObject->TicketCreate(
            Title        => 'Testticket for Untittest of the Generic Agent',
            Queue        => 'Raw',
            Lock         => 'unlock',
            PriorityID   => 1,
            StateID      => 1,
            CustomerNo   => '123465',
            CustomerUser => 'customerUnitTest@example.com',
            OwnerID      => 1,
            UserID       => 1,
        );

        my $ArticleID = $TicketObject->ArticleCreate(
            TicketID       => $TicketID,
            ArticleType    => 'note-internal',
            SenderType     => 'agent',
            From           => 'Some Agent <email@example.com>',
            To             => 'Customer A <customer-a@example.com>',
            Cc             => 'Customer B <customer-b@example.com>',
            ReplyTo        => 'Customer B <customer-b@example.com>',
            Subject        => 'some short description',
            Body           => 'the message text Perl modules provide a range of',
            ContentType    => 'text/plain; charset=ISO-8859-15',
            HistoryType    => 'OwnerUpdate',
            HistoryComment => 'Some free text!',
            UserID         => 1,
            NoAgentNotify  => 1,
        );

        my $TicketNumber = $TicketObject->TicketNumberLookup(
            TicketID => $TicketID,
            UserID   => 1,
        );

        $Selenium->get("${ScriptAlias}index.pl?Action=AdminGenericAgent");

        my $RandomID = "GenericAgent" . $Helper->GetRandomID();

        # check overview AdminGenericAgent
        $Selenium->find_element( "table",             'css' );
        $Selenium->find_element( "table thead tr th", 'css' );
        $Selenium->find_element( "table tbody tr td", 'css' );

        # check add job page
        $Selenium->find_element("//a[contains(\@href, \'Subaction=Update' )]")->click();

        my $Element = $Selenium->find_element( "#Profile", 'css' );
        $Element->is_displayed();
        $Element->is_enabled();

        # toggle Automatic execution (multiple tickets) widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_0')]")->click();

        # toggle Even based execution widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_1')]")->click();

        # toggle Select Tickets widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_2')]")->click();

        # toggle Update/Add Ticket Attribued widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_3')]")->click();

        # toggle Add Note widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_4')]")->click();

        # toggle Execute Ticket Commands widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_5')]")->click();

        # toggle Execude Custome Module widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_6')]")->click();

        # create test job
        $Selenium->find_element( "#Profile",      'css' )->send_keys($RandomID);
        $Selenium->find_element( "#TicketNumber", 'css' )->send_keys($TicketNumber);
        $Selenium->find_element( "#Profile",      'css' )->submit();

        # check if test job show on AdminGenericAgent
        $Self->True(
            index( $Selenium->get_page_source(), $RandomID ) > -1,
            "$RandomID job found on page",
        );

        # edit test job to delete test ticket
        $Selenium->find_element( $RandomID, 'link_text' )->click();

        # toggle Execute Ticket Commands widget
        $Selenium->find_element("//a[contains(\@aria-controls, \'Core_UI_AutogeneratedID_5')]")->click();
        $Selenium->find_element( "#NewDelete option[value='1']", 'css' )->click();
        $Selenium->find_element( "#Profile",                     'css' )->submit();

        # run test job
        $Selenium->find_element("//a[contains(\@href, \'Subaction=Run;Profile=$RandomID\' )]")->click();

        # check if test job show expected result
        $Self->True(
            index( $Selenium->get_page_source(), $TicketNumber ) > -1,
            "$TicketNumber found on page",
        );

        # execute test job
        $Selenium->find_element("//a[contains(\@href, \'Subaction=RunNow' )]")->click();

        # set test job to invalid
        $Selenium->find_element( $RandomID,                  'link_text' )->click();
        $Selenium->find_element( "#Valid option[value='0']", 'css' )->click();
        $Selenium->find_element( "#Profile",                 'css' )->submit();

        # check class of invalid generic job in the overview table
        $Self->True(
            $Selenium->execute_script(
                "return \$('tr.Invalid td:contains($RandomID)').length"
            ),
            "There is a class 'Invalid' for test generic job",
        );

        # delete test job
        $Selenium->find_element("//a[contains(\@href, \'Subaction=Delete;Profile=$RandomID\' )]")->click();

    }

);

1;
