# --
# Kernel/Language/ja.pm - provides Japanese language translation
# Copyright (C) 2001-2011 OTRS AG, http://otrs.org/
# Copyright (C) 2010-2011 Kaz Kamimura <kamypus at yahoo.co.jp>
# --
# $Id: ja.pm,v 1.9.2.3 2011/05/19 13:25:03 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --
package Kernel::Language::ja;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.9.2.3 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$

    # possible charsets
    $Self->{Charset} = ['utf-8', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y/%M/%D %T';
    $Self->{DateFormatLong}      = '%Y/%M/%D - %T';
    $Self->{DateFormatShort}     = '%Y/%M/%D';
    $Self->{DateInputFormat}     = '%Y/%M/%D';
    $Self->{DateInputFormatLong} = '%Y/%M/%D - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'はい',
        'No' => 'いいえ',
        'yes' => 'はい',
        'no' => 'いいえ',
        'Off' => 'オフ',
        'off' => 'オフ',
        'On' => 'オン',
        'on' => 'オン',
        'top' => '先頭',
        'end' => '最後',
        'Done' => '完了',
        'Cancel' => '取消',
        'Reset' => 'リセット',
        'last' => '以内',
        'before' => '以前',
        'd' => '日',
        'day' => '日',
        'days' => '日',
        'day(s)' => '日',
        'h' => '時間',
        'hour' => '時間',
        'hours' => '時間',
        'hour(s)' => '時間',
        'Hours' => '時間',
        'm' => '分',
        'minute' => '分',
        'minutes' => '分',
        'minute(s)' => '分',
        'Minutes' => '分',
        'month' => '月',
        'months' => '月',
        'month(s)' => '月',
        'w' => '週',
        'week' => '週',
        'week(s)' => '週',
        'y' => '年',
        'year' => '年',
        'years' => '年',
        'year(s)' => '年',
        'second(s)' => '秒',
        'seconds' => '秒',
        'second' => '秒',
        'wrote' => '',
        'Message' => 'メッセージ',
        'Error' => 'エラー',
        'Bug Report' => 'バグ報告',
        'Attention' => '注意',
        'Warning' => '警告',
        'Module' => 'モジュール',
        'Modulefile' => 'モジュールファイル',
        'Subfunction' => 'サブファンクション',
        'Line' => '行',
        'Setting' => '設定',
        'Settings' => '設定',
        'Example' => '例',
        'Examples' => '例',
        'valid' => '有効',
        'invalid' => '無効',
        '* invalid' => '* は無効です',
        'invalid-temporarily' => '無効-暫定',
        ' 2 minutes' => ' 2 分',
        ' 5 minutes' => ' 5 分',
        ' 7 minutes' => ' 7 分',
        '10 minutes' => '10 分',
        '15 minutes' => '15 分',
        'Mr.' => '',
        'Mrs.' => '',
        'Next' => '次へ',
        'Back' => '戻る',
        'Next...' => '次へ...',
        '...Back' => '...戻る',
        '-none-' => '-なし-',
        'none' => 'なし',
        'none!' => 'ありません！',
        'none - answered' => 'なし - 回答済',
        'please do not edit!' => '編集しないでください！',
        'Need Action' => '操作が必要',
        'AddLink' => '連結を追加',
        'Link' => '連結',
        'Unlink' => '連結解除',
        'Linked' => '連結済',
        'Link (Normal)' => '連結 (標準)',
        'Link (Parent)' => '連結 (親)',
        'Link (Child)' => '連結 (子)',
        'Normal' => '標準',
        'Parent' => '親',
        'Child' => '子',
        'Hit' => 'ヒット',
        'Hits' => '件',
        'Text' => '本文',
        'Standard' => 'スタンダード',
        'Lite' => 'ライト',
        'User' => 'ユーザー',
        'Username' => 'ユーザー名',
        'Language' => '言語',
        'Languages' => '言語',
        'Password' => 'パスワード',
        'Preferences' => '個人設定',
        'Salutation' => '挨拶文',
        'Salutations' => '挨拶文',
        'Signature' => '署名',
        'Signatures' => '署名',
        'Customer' => '顧客',
        'CustomerID' => '顧客ID',
        'CustomerIDs' => '顧客ID',
        'customer' => '顧客',
        'agent' => '担当者',
        'system' => 'システム',
        'Customer Info' => '顧客情報',
        'Customer Information' => '顧客情報',
        'Customer Company' => '顧客企業',
        'Customer Companies' => '顧客企業',
        'Company' => '企業名',
        'go!' => '実行！',
        'go' => '実行',
        'All' => '全て',
        'all' => '全て',
        'Sorry' => '申し訳ありません',
        'update!' => '更新！',
        'update' => '更新',
        'Update' => '更新',
        'Updated!' => '更新しました！',
        'submit!' => '送信！',
        'submit' => '送信',
        'Submit' => '送信',
        'change!' => '変更！',
        'Change' => '変更',
        'change' => '変更',
        'click here' => 'ここをクリック',
        'Comment' => 'コメント',
        'Valid' => '有効',
        'Invalid Option!' => '無効なオプションです！',
        'Invalid time!' => '無効な時間です！',
        'Invalid date!' => '無効な日付です！',
        'Name' => '名前',
        'Group' => 'グループ',
        'Description' => '説明',
        'description' => '説明',
        'Theme' => 'テーマ',
        'Created' => '作成日',
        'Created by' => '作成者',
        'Changed' => '変更日',
        'Changed by' => '変更者',
        'Search' => '検索',
        'and' => '〜',
        'between' => 'この間',
        'Fulltext Search' => '全文検索',
        'Data' => 'データ',
        'Options' => 'オプション',
        'Title' => 'タイトル',
        'Item' => 'アイテム',
        'Delete' => '削除',
        'Edit' => '編集',
        'View' => '一覧',
        'Number' => '番号',
        'System' => 'システム',
        'Contact' => '連絡',
        'Contacts' => '連絡',
        'Export' => 'エクスポート',
        'Up' => '昇順',
        'Down' => '降順',
        'Add' => '追加',
        'Added!' => '追加しました！',
        'Category' => '区分',
        'Viewer' => '閲覧者',
        'Expand' => '展開',
        'Small' => '小',
        'Medium' => '中',
        'Large' => '大',
        'Date picker' => '日付抽出',
        'New message' => '新規メッセージ',
        'New message!' => '新規メッセージ！',
        'Please answer this ticket(s) to get back to the normal queue view!' => '通常のキュー画面に戻るにはこのチケットに回答してください！',
        'You have %s new message(s)!' => '%s件の新規メッセージがあります！',
        'You have %s reminder ticket(s)!' => '%s件の保留期限チケットがあります',
        'The recommended charset for your language is %s!' => '選択した言語の文字コードは %s を推奨します',
        'Change your password.' => 'パスワードを変更',
        'Please activate %s first!' => '最初に %s を有効にしてください！',
        'No suggestions' => '候補なし',
        'Word' => '単語',
        'Ignore' => '無視',
        'replace with' => '置換',
        'There is no account with that login name.' => 'ログイン名に一致するアカウントはありません',
        'Login failed! Your user name or password was entered incorrectly.' => 'ログインできません。ユーザー名またはパスワードを確認してください。',
        'There is no acount with that user name.' => '該当ユーザー名のアカウントはありません。',
        'Please contact your administrator' => '管理者に連絡してください',
        'Logout' => 'ログアウト',
        'Logout successful. Thank you for using OTRS!' => 'ログアウトしました。OTRSのご利用ありがとうございます！',
        'Invalid SessionID!' => 'セッションIDが無効です！',
        'Feature not active!' => '機能が有効になっていません！',
        'Agent updated!' => '担当者更新！',
        'Create Database' => 'データベース作成',
        'System Settings' => 'システム設定',
        'Mail Configuration' => 'メール設定',
        'Finished' => '終了しました',
        'Login is needed!' => 'ログインしてください！',
        'Password is needed!' => 'パスワードを入力してください！',
        'License' => 'ライセンス',
        'Take this Customer' => 'この顧客を選択',
        'Take this User' => 'このユーザーを選択',
        'possible' => '可能',
        'reject' => '拒否',
        'reverse' => '反転',
        'Facility' => 'ファシリティ',
        'Time Zone' => 'タイムゾーン（時間帯）',
        'Pending till' => '保留時間',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'ユーザーID 1 (システムアカウント) では作業しないでください。新規ユーザーを作成してください！',
        'Dispatching by email To: field.' => 'メールの宛先で振り分け',
        'Dispatching by selected Queue.' => '選択したキューで振り分け',
        'No entry found!' => '登録がありません！',
        'Session has timed out. Please log in again.' => '接続が時間切れです。再ログインしてください。',
        'No Permission!' => '権限がありません！',
        'To: (%s) replaced with database email!' => 'To: (%s) をデータベースEmailに合わせて置き換えました',
        'Cc: (%s) added database email!' => 'Cc: (%s) をデータベースemailに追加しました！',
        '(Click here to add)' => '(クリックして追加)',
        'Preview' => 'プレビュー',
        'Package not correctly deployed! You should reinstall the Package again!' => 'パッケージが正しく展開されていません。パッケージを再インストールしてください！',
        'Cannot create %s!' => '%s が作成できません！',
        'Customer %s added' => '顧客 %s を追加しました',
        'Role added!' => '役割を追加しました！',
        'Role updated!' => '役割を更新しました！',
        'Attachment added!' => '添付ファイルを追加しました！',
        'Attachment updated!' => '添付ファイルを更新しました！',
        'Response added!' => '返答を追加しました！',
        'Response updated!' => '返答を更新しました！',
        'Group updated!' => 'グループを更新しました！',
        'Queue added!' => 'キューを追加しました！',
        'Queue updated!' => 'キューを更新しました！',
        'State added!' => '状態を追加しました！',
        'State updated!' => '状態を更新しました！',
        'Type added!' => '種別を追加しました！',
        'Type updated!' => '種別を更新しました！',
        'Customer updated!' => '顧客を更新しました！',
        'Contract' => '契約',
        'Online Customer: %s' => 'オンラインの顧客: %s',
        'Online Agent: %s' => 'オンラインの担当者: %s',
        'Calendar' => 'カレンダー',
        'File' => 'ファイル',
        'Filename' => 'ファイル名',
        'Type' => '種別',
        'Size' => 'サイズ',
        'Upload' => 'アップロード',
        'Directory' => 'ディレクトリ',
        'Signed' => '署名済',
        'Sign' => '署名',
        'Crypted' => '暗号化済',
        'Crypt' => '暗号化',
        'PGP' => 'PGP',
        'PGP Key' => 'PGP鍵',
        'PGP Keys' => 'PGP鍵',
        'S/MIME' => 'S/MIME',
        'S/MIME Certificate' => 'S/MIME証明書',
        'S/MIME Certificates' => 'S/MIME証明書',
        'Office' => '事務所',
        'Phone' => '電話番号',
        'Fax' => 'Fax',
        'Mobile' => '携帯電話',
        'Zip' => '〒',
        'City' => '住所',
        'Street' => '建物名',
        'Country' => '国',
        'Location' => '所在地',
        'installed' => 'インストール済',
        'uninstalled' => '未インストール',
        'Security Note: You should activate %s because application is already running!' => 'セキュリティメモ： %sを有効にしてください！アプリケーションが既に実行中です！',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'printed at' => '印刷する',
        'Loading...' => '読み込み中...',
        'Dear Mr. %s,' => '%s 様',
        'Dear Mrs. %s,' => '%s 様',
        'Dear %s,' => '%s 様',
        'Hello %s,' => '%s さん',
        'This email address already exists. Please log in or reset your password.' => 'このemailアドレスは既に存在します。ログインするかパスワードを初期化してください。',
        'New account created. Sent login information to %s. Please check your email.' => '新規アカウントを作成しました。ログイン情報を %s に送信しました。メールを確認してください。',
        'Please press Back and try again.' => '[戻る]ボタンを押してやり直してください。',
        'Sent password reset instructions to %s. Please check your email.' => 'パスワード初期化の説明を %s に送信しました。メールを確認してください。',
        'Sent new password to %s. Please check your email.' => '新しいパスワードを %s に送信しました。メールを確認してください。',
        'Upcoming Events' => '直近のイベント',
        'Event' => 'イベント',
        'Events' => 'イベント',
        'Invalid Token!' => '無効なトークンです',
        'more' => '続き',
        'For more info see:' => '詳細情報：',
        'Package verification failed!' => 'パッケージの検証に失敗しました',
        'Collapse' => '',
        'Shown' => '表示',
        'News' => 'ニュース',
        'Product News' => '製品ニュース',
        'OTRS News' => 'OTRSニュース',
        '7 Day Stats' => '週間統計',
        'Bold' => '太字',
        'Italic' => '斜体',
        'Underline' => '下線',
        'Font Color' => '文字色',
        'Background Color' => '背景色',
        'Remove Formatting' => '書式を削除',
        'Show/Hide Hidden Elements' => '要素を表示／非表示',
        'Align Left' => '左寄せ',
        'Align Center' => '中央揃え',
        'Align Right' => '右寄せ',
        'Justify' => '両端揃え',
        'Header' => 'ヘッダー',
        'Indent' => '字下げ',
        'Outdent' => '字下げ解除',
        'Create an Unordered List' => '番号なしリストの作成',
        'Create an Ordered List' => '番号付きリストの作成',
        'HTML Link' => 'HTMLリンク',
        'Insert Image' => '画像の挿入',
        'CTRL' => '',
        'SHIFT' => '',
        'Undo' => '元に戻す',
        'Redo' => 'やり直し',

        # Template: AAAMonth
        'Jan' => '1月',
        'Feb' => '2月',
        'Mar' => '3月',
        'Apr' => '4月',
        'May' => '5月',
        'Jun' => '6月',
        'Jul' => '7月',
        'Aug' => '8月',
        'Sep' => '9月',
        'Oct' => '10月',
        'Nov' => '11月',
        'Dec' => '12月',
        'January' => '1月',
        'February' => '2月',
        'March' => '3月',
        'April' => '4月',
        'May_long' => '5月',
        'June' => '6月',
        'July' => '7月',
        'August' => '8月',
        'September' => '9月',
        'October' => '10月',
        'November' => '11月',
        'December' => '12月',

        # Template: AAAPreferences
        'Preferences updated successfully!' => '個人設定を更新しました',
        'User Profile' => 'ユーザーのプロファイル',
        'Email Settings' => 'メール設定',
        'Other Settings' => 'その他の設定',
        'Change Password' => 'パスワード変更',
        'Current Password' => '現在のパスワード',
        'New password' => '新規パスワード',
        'Verify password' => '確認パスワード',
        'Spelling Dictionary' => 'スペルチェック辞書',
        'Default spelling dictionary' => '既定のスペルチェック辞書',
        'Max. shown Tickets a page in Overview.' => '一覧時のチケット表示最大数',
        'The current password is not correct. Please try again!' => 'パスワードが正しくありません。再入力してください！',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'パスワードが更新できませんでした。新しいパスワードが一致しません。再入力してください！',
        'Can\'t update password, it contains invalid characters!' => 'パスワードが更新できませんでした。無効な文字が含まれています！',
        'Can\'t update password, it must be at least %s characters long!' => 'パスワードが更新できませんでした。%s は長すぎます！',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'パスワードが更新できませんでした。英語の大文字小文字が2文字ずつ以上必要です！',
        'Can\'t update password, it must contain at least 1 digit!' => 'パスワードが更新できませんでした。数字が1文字以上必要です！',
        'Can\'t update password, it must contain at least 2 characters!' => 'パスワードが更新できませんでした。2文字以上必要です！',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'パスワードが更新できませんでした。このパスワードは既に使用されています。新しいものを入力してください！',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => 'CSVファイル（統計と検索）で使用される区切り文字を選択します。ここで区切り文字を選択しない場合、あなたの言語のデフォルトの区切り文字が使用されます。',
        'CSV Separator' => 'CSV区切り文字',

        # Template: AAAStats
        'Stat' => '状態',
        'Please fill out the required fields!' => '必須項目を入力してください！',
        'Please select a file!' => 'ファイルを選択してください！',
        'Please select an object!' => '対象を選択してください！',
        'Please select a graph size!' => 'グラフサイズを選択してください！',
        'Please select one element for the X-axis!' => 'X軸の要素を一つ選択してください！',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => '要素を一つだけ選択するかオフにしてください！',
        'If you use a checkbox you have to select some attributes of the select field!' => 'チェックボックスの要素を選択してください！',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '選択項目に値が入力されていません！',
        'The selected end time is before the start time!' => '開始時間を終了時間より前にしてください！',
        'You have to select one or more attributes from the select field!' => '項目を1つ以上を選択してください！',
        'The selected Date isn\'t valid!' => '選択された日時が無効です',
        'Please select only one or two elements via the checkbox!' => '1つまたは2つのチェックボックスを選択してください！',
        'If you use a time scale element you can only select one element!' => 'タイムスケールは1つだけ選択してください！',
        'You have an error in your time selection!' => 'その時間の選択はエラーです！',
        'Your reporting time interval is too small, please use a larger time scale!' => 'レポートする感覚が小さすぎます。間隔をあけてください！',
        'The selected start time is before the allowed start time!' => '選択された開始時刻は許可されている時間の前です！',
        'The selected end time is after the allowed end time!' => '選択された終了時間は許可されている時間の後です！',
        'The selected time period is larger than the allowed time period!' => '選択された期間は許可されている周期よりも大きいです！',
        'Common Specification' => '共通仕様',
        'X-axis' => 'X軸',
        'Value Series' => '値系列',
        'Restrictions' => '制限',
        'graph-lines' => '線グラフ',
        'graph-bars' => '棒グラフ',
        'graph-hbars' => '横棒グラフ',
        'graph-points' => '散布図',
        'graph-lines-points' => '点線グラフ',
        'graph-area' => '面積図',
        'graph-pie' => '円グラフ',
        'extended' => '拡張',
        'Agent/Owner' => '担当者／所有者',
        'Created by Agent/Owner' => '作成した担当者／所有者',
        'Created Priority' => '作成時の優先度',
        'Created State' => '作成時の状態',
        'Create Time' => '作成日時',
        'CustomerUserLogin' => '顧客ユーザーログイン',
        'Close Time' => '完了時間',
        'TicketAccumulation' => '蓄積チケット',
        'Attributes to be printed' => '印刷する属性',
        'Sort sequence' => '並べ替え順序',
        'Order by' => '順序',
        'Limit' => '制限',
        'Ticketlist' => 'チケットリスト',
        'ascending' => '昇順',
        'descending' => '降順',
        'First Lock' => '初回ロック',
        'Evaluation by' => '評価',
        'Total Time' => '合計時間',
        'Ticket Average' => 'チケット平均',
        'Ticket Min Time' => 'チケット最少時間',
        'Ticket Max Time' => 'チケット最大時間',
        'Number of Tickets' => 'チケットの数',
        'Article Average' => '記事平均',
        'Article Min Time' => '記事最少時間',
        'Article Max Time' => '記事最大時間',
        'Number of Articles' => '記事の数',
        'Accounted time by Agent' => '担当者の作業時間',
        'Ticket/Article Accounted Time' => 'チケット／記事の作業時間',
        'TicketAccountedTime' => 'チケット作業時間',
        'Ticket Create Time' => 'チケット作成時間',
        'Ticket Close Time' => 'チケット完了時間',

        # Template: AAATicket
        'Status View' => '状態一覧',
        'Bulk' => '一括',
        'Lock' => 'ロック',
        'Unlock' => 'ロック解除',
        'History' => '履歴',
        'Zoom' => '拡大',
        'Age' => '経過時間',
        'Bounce' => 'バウンス',
        'Forward' => '転送',
        'From' => '差出人',
        'To' => '宛先',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => '表題',
        'Move' => '移転',
        'Queue' => 'キュー',
        'Queues' => 'キュー',
        'Priority' => '優先度',
        'Priorities' => '優先度',
        'Priority Update' => '優先度更新',
        'SLA' => 'SLA',
        'Service Level Agreement' => '品質保証合意',
        'Service Level Agreements' => '品質保証合意',
        'Service' => 'サービス',
        'Services' => 'サービス',
        'State' => '状態',
        'States' => '状態',
        'Status' => '状態',
        'Statuses' => '状態',
        'Ticket Type' => 'チケット種別',
        'Ticket Types' => 'チケット種別',
        'Compose' => '作成',
        'Pending' => '保留',
        'Owner' => '所有者',
        'Owner Update' => '所有者更新',
        'Responsible' => '応答',
        'Responsible Update' => '応答更新',
        'Sender' => '送信者',
        'Article' => '記事',
        'Ticket' => 'チケット',
        'Createtime' => '作成日時',
        'plain' => '書式なし',
        'Email' => 'メール',
        'email' => 'メール',
        'Close' => '完了',
        'Action' => '操作',
        'Attachment' => '添付ファイル',
        'Attachments' => '添付ファイル',
        'This message was written in a character set other than your own.' => 'このメッセージは現在使用中の文字コードではないもので書かれています。',
        'If it is not displayed correctly,' => '正しく表示されない場合、',
        'This is a' => 'これは',
        'to open it in a new window.' => '新規ウィンドウを開く',
        'This is a HTML email. Click here to show it.' => 'これはHTMLメールです。クリックで見れます。',
        'Free Fields' => '自由領域',
        'Merge' => '結合',
        'merged' => '結合済',
        'closed successful' => '完了 (成功)',
        'closed unsuccessful' => '完了 (不成功)',
        'Locked Tickets Total' => 'ロック済チケット合計',
        'Locked Tickets Reminder Reached' => 'ロック済チケット時間切れ',
        'Locked Tickets New' => 'ロック済チケット新規',
        'Responsible Tickets Total' => '応答チケット合計',
        'Responsible Tickets New' => '応答チケット新規',
        'Responsible Tickets Reminder Reached' => '応答チケット時間切れ',
        'Watched Tickets Total' => '監視チケット合計',
        'Watched Tickets New' => '監視チケット新規',
        'Watched Tickets Reminder Reached' => '監視チケット時間切れ',
        'new' => '新規',
        'open' => '対応中',
        'Open' => '対応中',
        'closed' => '完了',
        'Closed' => '完了',
        'removed' => '削除',
        'pending reminder' => '保留 (期限付)',
        'pending auto' => '保留 (自動)',
        'pending auto close+' => '保留 (自動完了＋)',
        'pending auto close-' => '保留 (自動完了－)',
        'email-external' => 'メール-外部',
        'email-internal' => 'メール-内部',
        'note-external' => '注釈-外部',
        'note-internal' => '注釈-内部',
        'note-report' => '注釈-報告',
        'phone' => '電話',
        'sms' => 'SMS',
        'webrequest' => 'WEB要求',
        'lock' => 'ロック',
        'unlock' => 'ロック解除',
        'very low' => '最低',
        'low' => '低',
        'normal' => '中',
        'high' => '高',
        'very high' => '最高',
        '1 very low' => '1 最低',
        '2 low' => '2 低',
        '3 normal' => '3 中',
        '4 high' => '4 高',
        '5 very high' => '5 最高',
        'Ticket "%s" created!' => 'チケット "%s" を作成しました！',
        'Ticket Number' => 'チケット番号',
        'Ticket Object' => 'チケット対象',
        'No such Ticket Number "%s"! Can\'t link it!' => 'チケット番号 "%s" がありません！連結できませんでした！',
        'Don\'t show closed Tickets' => '完了チケットを非表示',
        'Show closed Tickets' => '完了チケットを表示',
        'New Article' => '新規記事',
        'Unread article(s) available' => '未読の記事があります',
        'Remove from list of watched tickets' => '監視チケットリストから削除しました',
        'Add to list of watched tickets' => '監視チケットリストに追加しました',
        'Email-Ticket' => 'メールチケット',
        'Create new Email Ticket' => '新規メールチケット作成',
        'Phone-Ticket' => '電話チケット',
        'Search Tickets' => 'チケット検索',
        'Edit Customer Users' => '顧客ユーザー編集',
        'Edit Customer Company' => '顧客企業編集',
        'Bulk Action' => '一括処理',
        'Bulk Actions on Tickets' => 'チケットへの一括処理',
        'Send Email and create a new Ticket' => 'メール送信と新規チケット作成',
        'Create new Email Ticket and send this out (Outbound)' => '新規メールチケットを作成し送信（外部）',
        'Create new Phone Ticket (Inbound)' => '新規電話チケット作成（受信）',
        'Overview of all open Tickets' => '全対応中チケット一覧',
        'Locked Tickets' => 'ロック済チケット',
        'My Locked Tickets' => '担当のロック済チケット',
        'My Watched Tickets' => '担当の監視チケット',
        'My Responsible Tickets' => '担当の応答チケット',
        'Watched Tickets' => '監視チケット',
        'Watched' => '監視中',
        'Watch' => '監視',
        'Unwatch' => '監視解除',
        'Lock it to work on it!' => 'チケットをロックし作業開始',
        'Unlock to give it back to the queue!' => 'チケットのロックを解除しキューに戻す',
        'Shows the ticket history!' => 'チケットの履歴を閲覧する',
        'Print this ticket!' => 'このチケットを印刷する',
        'Change the ticket priority!' => 'チケット優先度を変更する',
        'Change the ticket free fields!' => 'チケットの自由入力領域を変更する',
        'Link this ticket to an other objects!' => 'このチケットを他の対象と結合する',
        'Change the ticket owner!' => 'チケットの所有者を変更する',
        'Change the ticket customer!' => 'チケットの顧客を変更する',
        'Add a note to this ticket!' => 'このチケットに注釈を追加する',
        'Merge this ticket!' => 'このチケットを結合する',
        'Set this ticket to pending!' => 'このチケットを保留する',
        'Close this ticket!' => 'このチケットを完了する',
        'Look into a ticket!' => 'チケットを閲覧する',
        'Delete this ticket!' => 'このチケットを削除する',
        'Mark as Spam!' => '迷惑メールにする',
        'My Queues' => '担当キュー',
        'Shown Tickets' => 'チケットを表示',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'メールのチケット番号 "<OTRS_TICKET>" を "<OTRS_MERGE_TO_TICKET>" と結合しました！',
        'Ticket %s: first response time is over (%s)!' => 'チケット %s: 初回応答期限切れです(%s)！',
        'Ticket %s: first response time will be over in %s!' => 'チケット %s: 初回応答期限を超えそうです %s！',
        'Ticket %s: update time is over (%s)!' => 'チケット %s: 更新期限切れです (%s)！',
        'Ticket %s: update time will be over in %s!' => 'チケット %s: 更新期限を超えそうです %s！',
        'Ticket %s: solution time is over (%s)!' => 'チケット %s: 解決期限切れです (%s)！',
        'Ticket %s: solution time will be over in %s!' => 'チケット %s: 解決期限を超えそうです %s！',
        'There are more escalated tickets!' => '更にエスカレーションされたチケットがあります！',
        'Plain Format' => '書式なし',
        'Reply All' => '全員に返信',
        'Direction' => '方向',
        'New ticket notification' => '新規チケット通知',
        'Send me a notification if there is a new ticket in "My Queues".' => '新規チケットが担当キューに入ったら通知を送信',
        'Send new ticket notifications' => '新規チケット通知を送信',
        'Ticket follow up notification' => '追跡チケット通知',
        'Ticket lock timeout notification' => 'ロック期限切れチケット通知',
        'Send me a notification if a ticket is unlocked by the system.' => 'チケットがシステムにロック解除されたら通知を送信',
        'Send ticket lock timeout notifications' => 'ロック期限切れ通知を送信',
        'Ticket move notification' => '移転チケット通知',
        'Send me a notification if a ticket is moved into one of "My Queues".' => '移転チケットが担当キューに入ったら通知を送信',
        'Send ticket move notifications' => '移転チケット通知を送信',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'お気に入りのキューを選択。有効にした場合、これらのキューについてメール通知を受信します',
        'Custom Queue' => 'カスタムキュー',
        'QueueView refresh time' => 'キュー一覧自動更新間隔',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '有効にした場合、キュー一覧は自動で指定時間後に更新されます',
        'Refresh QueueView after' => 'この時間が経過後、キュー一覧を更新',
        'Screen after new ticket' => '新規チケット作成後の画面',
        'Show this screen after I created a new ticket' => '新規チケット作成後に表示する画面',
        'Closed Tickets' => '完了チケット',
        'Show closed tickets.' => '完了チケットを見る',
        'Max. shown Tickets a page in QueueView.' => '',
        'Ticket Overview "Small" Limit' => 'チケット一覧制限"小"',
        'Ticket limit per page for Ticket Overview "Small"' => 'チケット一覧"小"時の表示数制限',
        'Ticket Overview "Medium" Limit' => 'チケット一覧一覧制限"中"',
        'Ticket limit per page for Ticket Overview "Medium"' => 'チケット一覧概要"中"時の表示数制限',
        'Ticket Overview "Preview" Limit' => 'チケット一覧制限"プレビュー"',
        'Ticket limit per page for Ticket Overview "Preview"' => 'チケット一覧"プレビュー"時の表示数制限',
        'Ticket watch notification' => '監視チケット通知',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => 'チケット所有者が受け取る通知と同じものを監視チケットにも送信',
        'Send ticket watch notifications' => '監視チケット通知を送信',
        'Out Of Office Time' => '勤務時間外',
        'New Ticket' => '新規チケット',
        'Create new Ticket' => '新規チケット作成',
        'Customer called' => '顧客が電話をかけてきた',
        'phone call' => '電話応答',
        'Phone Call Outbound' => '電話応答発信',
        'Reminder Reached' => '保留期限切れ',
        'Reminder Tickets' => '保留期限切れチケット',
        'Escalated Tickets' => 'エスカレーションチケット',
        'New Tickets' => '新規チケット',
        'Open Tickets / Need to be answered' => '対応中チケット／要対応',
        'All open tickets, these tickets have already been worked on, but need a response' => '全対応中チケット。着手済みだが応答が必要です',
        'All new tickets, these tickets have not been worked on yet' => '全新規チケット。まだ着手されていません',
        'All escalated tickets' => '全エスカレーションチケット',
        'All tickets with a reminder set where the reminder date has been reached' => '全保留チケット中、期限切れのもの',

        'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'AutoReject sent to "%s".',
        'History::SendAutoReply' => 'AutoReply sent to "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email sent to "%s".',
        'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
        'History::SendCustomerNotification' => 'Notification sent to "%s".',
        'History::EmailAgent' => 'Email sent to customer.',
        'History::EmailCustomer' => 'Added email. %s',
        'History::PhoneCallAgent' => 'Agent called customer.',
        'History::PhoneCallCustomer' => 'Customer called us.',
        'History::AddNote' => 'Added note (%s)',
        'History::Lock' => 'Locked ticket.',
        'History::Unlock' => 'Unlocked ticket.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Updated: %s',
        'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::ResponsibleUpdate' => 'New responsible is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Updated: %s',
        'History::StateUpdate' => 'Old: "%s" New: "%s"',
        'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => 'System Request (%s).',

        # Template: AAAWeekDay
        'Sun' => '日',
        'Mon' => '月',
        'Tue' => '火',
        'Wed' => '水',
        'Thu' => '木',
        'Fri' => '金',
        'Sat' => '土',

        # Template: AdminAttachment
        'Attachment Management' => '添付ファイル管理',
        'Actions' => '操作',
        'Go to overview' => '一覧へ移動',
        'Add attachment' => '添付ファイルを追加',
        'List' => 'リスト',
        'No data found.' => 'データがありません',
        'Download file' => 'ダウンロードファイル',
        'Delete this attachment' => 'この添付ファイルを削除',
        'Add Attachment' => '添付ファイルを追加',
        'Edit Attachment' => '添付ファイルを編集',
        'This field is required.' => 'この領域は必須です',
        'or' => 'または',

        # Template: AdminAutoResponse
        'Auto Response Management' => '自動応答管理',
        'Add auto response' => '自動応答追加',
        'Add Auto Response' => '自動応答追加',
        'Edit Auto Response' => '自動応答編集',
        'Response' => '応答',
        'Auto response from' => '自動応答差出人',
        'Reference' => '用例',
        'You can use the following tags' => '次のタグを使用できます',
        'To get the first 20 character of the subject.' => '表題の最初の20文字を取得',
        'To get the first 5 lines of the email.' => 'メールの最初の5行を取得',
        'To get the realname of the sender (if given).' => '送信者の実名を取得(可能な場合)',
        'To get the article attribute' => '記事の属性を取得',
        ' e. g.' => '例',
        'Options of the current customer user data' => '現在の顧客ユーザーデータのオプション',
        'Ticket owner options' => 'チケット所有者オプション',
        'Ticket responsible options' => 'チケット応答オプション',
        'Options of the current user who requested this action' => '操作を要求された現在のユーザーのオプション',
        'Options of the ticket data' => 'チケットデータのオプション',
        'Config options' => '設定オプション',
        'Example response' => '応答例',

        # Template: AdminCustomerCompany
        'Customer Company Management' => '顧客企業管理',
        'Wildcards are allowed.' => 'ワイルドカードが使用できます',
        'Add customer company' => '顧客企業を追加',
        'Please enter a search term to look for customer companies.' => '顧客企業の検索文字を入力してください',
        'Add Customer Company' => '顧客企業を追加',

        # Template: AdminCustomerUser
        'Customer Management' => '顧客管理',
        'Add customer' => '顧客を追加',
        'Select' => '選択',
        'Hint' => 'ヒント',
        'Customer will be needed to have a customer history and to login via customer panel.' => '顧客は顧客履歴の使用と顧客パネルからログインするために必要です。',
        'Please enter a search term to look for customers.' => '顧客の検索文字列を入力してください',
        'Last Login' => '最終ログイン',
        'Add Customer' => '顧客を追加',
        'Edit Customer' => '顧客を編集',
        'This field is required and needs to be a valid email address.' => 'ここは必須領域で、有効なメールアドレスである必要があります。',
        'This email address is not allowed due to the system configuration.' => 'このメールアドレスはシステム設定により許可されていません。',
        'This email address failed MX check.' => 'このメールアドレスのMXレコード検査に失敗しました',
        'The syntax of this email address is incorrect.' => 'このメールアドレスは正しい形式ではありません',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '顧客－グループ関連性管理',
        'Notice' => '通知',
        'This feature is disabled!' => 'この機能は無効化されています！',
        'Just use this feature if you want to define group permissions for customers.' => '顧客のグループ権限を設定する場合のみこの機能を使用できます。',
        'Enable it here!' => '有効化する！',
        'Search for customers (wildcards are allowed).' => '顧客の検索 (ワイルドカードは許可されています)',
        'Edit Customer Default Groups' => '顧客の規定グループの編集',
        'These groups are automatically assigned to all customers.' => 'このグループは自動的にすべての顧客に割り当てられます。',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => 'フィルタのグループ',
        'Select the customer:group permissions.' => '顧客：グループ権限を選択',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '何も選択しない場合、このグループは権限がありません (チケットは顧客が使用できません)',
        'Search Result:' => '検索結果:',
        'Customers' => '顧客',
        'Groups' => 'グループ',
        'No matches found.' => '一致しませんでした。',
        'Change Group Relations for Customer' => '顧客とグループの関連性を変更',
        'Change Customer Relations for Group' => 'グループと顧客の関連性を変更',
        'Toggle %s Permission for all' => '%s の全権限を切り替え',
        'Toggle %s permission for %s' => '%s の %s 権限を切り替え',
        'Customer Default Groups:' => '顧客の規定グループ:',
        'No changes can be made to these groups.' => '変更はこれらのグループに行うことができます。',
        'ro' => '読取り',
        'Read only access to the ticket in this group/queue.' => 'このグループ／キューのチケットを読み取り専用にします。',
        'rw' => '読書き',
        'Full read and write access to the tickets in this group/queue.' => 'このグループ／キューのチケットに読み書きを含めた全権限を付与します。',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '顧客－サービス関連性管理',
        'Edit default services' => '既定のサービス編集',
        'Filter for Services' => 'サービスのフィルタ',
        'Allocate Services to Customer' => 'サービスを顧客に割り当て',
        'Allocate Customers to Service' => '顧客をサービスに割り当て',
        'Toggle active state for all' => 'すべての有効な状態を切り替え',
        'Active' => '有効',
        'Toggle active state for %s' => '有効な状態 %s を切り替え',

        # Template: AdminEmail
        'Admin Notification' => '管理者通知',
        'Send Administrative Message to Agents' => '管理メッセージを担当者へ送信',
        'Your message was sent to' => '送信されたメッセージ',
        'Send message to users' => 'ユーザーにメッセージを送信',
        'Send message to group members' => 'グループのメンバーにメッセージを送信',
        'Group members need to have permission' => 'グループのメンバーは権限を持っている必要があります',
        'Send message to role members' => '役割のメンバーにメッセージを送信',
        'Also send to customers in groups' => 'さらにグループの顧客にも送信',
        'Please enter subject.' => '表題を入力してください。',
        'Body' => '本文',
        'Send' => '送信',

        # Template: AdminGenericAgent
        'Generic Agent' => '管理用ジョブ',
        'Add job' => 'ジョブ追加',
        'Last run' => '最終実行',
        'Run Now!' => '今すぐ実行！',
        'Delete this task' => 'このタスクを削除',
        'Run this task' => 'このタスクを実行',
        'Job Settings' => 'ジョブ設定',
        'Job name' => 'ジョブ名',
        'Please provide a name.' => '',
        'Schedule minutes' => 'スケジュール 分',
        'Schedule hours' => 'スケジュール 時',
        'Schedule days' => 'スケジュール 日',
        'Currently this generic agent job will not run automatically.' => '現在この一般担当者のジョブは自動実行されません。',
        'To enable automatic execution select at least one value from minutes, hours and days!' => '',
        'Toggle this widget' => 'このウィジェットを切り替え',
        'Ticket Filter' => 'チケットフィルタ',
        '(e. g. 10*5155 or 105658*)' => '(例 10*5144 または 105658*)',
        '(e. g. 234321)' => '(例 234321)',
        'Customer login' => '顧客ログイン名',
        '(e. g. U5150)' => '(例 U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '記事内全文検索 (例 "Mar*in" または "Baue*")',
        'Agent' => '担当者',
        'Ticket lock' => 'チケットロック',
        'TicketFreeFields' => 'チケット自由領域',
        'Create times' => '作成時間',
        'No create time settings.' => '作成時間を設定しない',
        'Ticket created' => 'チケットを作成したのが',
        'Ticket created between' => 'チケットを作成したのがこの期間内',
        'Close times' => '完了時間',
        'No close time settings.' => '完了時間を設定しない',
        'Ticket closed' => 'チケットを完了したのが',
        'Ticket closed between' => 'チケットを完了したのがこの期間内',
        'Pending times' => '保留時間',
        'No pending time settings.' => '保留時間を設定しない',
        'Ticket pending time reached' => '保留期限切れが',
        'Ticket pending time reached between' => '保留期限切れがこの期間内',
        'Escalation times' => 'エスカレーション時間',
        'No escalation time settings.' => 'エスカレーション時間を設定しない',
        'Ticket escalation time reached' => 'エスカレーション時間到達が',
        'Ticket escalation time reached between' => 'エスカレーション時間がこの期間内',
        'Escalation - first response time' => 'エスカレーション - 初回応答期限',
        'Ticket first response time reached' => 'チケット初回応答期限が',
        'Ticket first response time reached between' => 'チケット初回応答期限がこの期間内',
        'Escalation - update time' => 'エスカレーション - 更新期限',
        'Ticket update time reached' => 'チケット更新期限が',
        'Ticket update time reached between' => 'チケット更新期限がこの期間内',
        'Escalation - solution time' => 'エスカレーション - 解決期限',
        'Ticket solution time reached' => 'チケット解決期限が',
        'Ticket solution time reached between' => 'チケット解決期限がこの期間内',
        'Archive search option' => '書庫検索オプション',
        'Ticket Action' => 'チケットの操作',
        'Set new service' => '新規サービスを設定',
        'Set new Service Level Agreement' => '新規の品質保証合意を設定',
        'Set new priority' => '新規優先度を設定',
        'Set new queue' => '新規キューを設定',
        'Set new state' => '新規に状態を設定',
        'Set new agent' => '新規担当者を設定',
        'new owner' => '新規所有者',
        'Set new ticket lock' => '新規チケットロックを設定',
        'New customer' => '新規顧客',
        'New customer ID' => '新規顧客ID',
        'New title' => '新規タイトル',
        'New type' => '新規種別',
        'New TicketFreeFields' => '新規チケット自由領域',
        'Add Note' => '新規注釈',
        'Time units' => '時間単位',
        ' (work units)' => ' (稼働時間)',
        'Archive selected tickets' => '書庫の選択済みチケット',
        'Ticket Commands' => 'チケットコマンド',
        'Send agent/customer notifications on changes' => '変更を担当者／顧客に通知する',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'このコマンドが実行されます。チケット番号は ARG[0] 、チケットIDは ARG[1] です。',
        'Delete tickets' => 'チケット削除',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '警告: 影響を受ける全てのつけっとがデータベースから削除されます。復元することはできません！',
        'Execute Custom Module' => 'カスタムモジュールを実行',
        'Param %s key' => 'パラメータキー %s',
        'Param %s value' => 'パラメータ値 %s',
        'Save Changes' => '変更を保存',
        'Save' => '保存',
        'Results' => '検索結果',
        '%s Tickets affected! What do you want to do?' => '%s チケットは影響を受けます。どうしますか？',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '警告: 削除オプションを使用します。削除された全てのチケットは消失します！',
        'Edit job' => 'ジョブ編集',
        'Run job' => 'ジョブ実行',
        'Affected Tickets' => '影響を受けるチケット',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '警告: あなたの名前を変更するグループの管理者はsysconfigの中で適切な変更を行う前にあなたの管理者パネルはロックアウトされます。この問題が発生した場合、管理するSQLステートメントごとにグループを元に戻してください',
        'Group Management' => 'グループ管理',
        'Add group' => 'グループ追加',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '管理グループは管理エリアで取得します。統計グループは統計エリアを取得します',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => 'ASPソリューションが便利です',
        'Add Group' => 'グループ追加',
        'Edit Group' => 'グループ編集',

        # Template: AdminLog
        'System Log' => 'システムログ',
        'Here you will find log information about your system.' => 'ここではシステムに関するログ情報が表示されます。',
        'Time' => '時間',

        # Template: AdminMailAccount
        'Mail Account Management' => 'メールアカウント管理',
        'Add mail account' => 'メールアカウント追加',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'アカウントで受信された全てのメールが選択したキューに振り分けられます。',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '信頼されたアカウントの場合、受信時には既存のX-OTRSヘッダ(優先度など)が使用されます。PostMasterフィルタは常に使用されます。',
        'Host' => 'ホスト',
        'Delete account' => 'アカウント削除',
        'Fetch mail' => 'メールを取得',
        'Add Mail Account' => 'メールアカウント追加',
        'Example: mail.example.com' => '例: mail.example.com',
        'Trusted' => '信頼済',
        'Dispatching' => '振り分け処理',
        'Edit Mail Account' => 'メールアカウント編集',

        # Template: AdminNavigationBar
        'Admin' => '管理',
        'Agent Management' => '担当者管理',
        'Queue Settings' => 'キュー設定',
        'Ticket Settings' => 'チケット設定',
        'System Administration' => 'システム管理',

        # Template: AdminNotification
        'Notification Management' => '通知管理',
        'Filter for Language' => '言語フィルタ',
        'Filter for Notification' => '通知フィルタ',
        'Notifications are sent to an agent or a customer.' => '通知は担当者、顧客に送信されます。',
        'Notification' => '通知',
        'Edit Notification' => '通知の編集',
        'e. g.' => '例',
        'Options of the current customer data' => 'この顧客データのオプション',

        # Template: AdminNotificationEvent
        'Add notification' => '通知の追加',
        'Delete this notification' => 'この通知を削除',
        'Add Notification' => '通知の追加',
        'Recipient groups' => '受信グループ',
        'Recipient agents' => '受信担当者',
        'Recipient roles' => '受信役割',
        'Recipient email addresses' => '受信 メールアドレス',
        'Article type' => '記事種別',
        'Only for ArticleCreate event' => '記事作成イベントのみ',
        'Subject match' => '表題が一致',
        'Body match' => '本文が一致',
        'Include attachments to notification' => '通知が添付ファイルを含む',
        'Notification article type' => '記事種別の通知',
        'Only for notifications to specified email addresses' => '指定メールアドレスへの通知のみ',
        'To get the first 20 character of the subject (of the latest agent article).' => '表題の最初の20文字を取得 (最新の担当者記事)',
        'To get the first 5 lines of the body (of the latest agent article).' => '本文から最初の5行を取得 (最新の担当者記事)',
        'To get the first 20 character of the subject (of the latest customer article).' => '表題の最初の20文字を取得 (最新の顧客記事)',
        'To get the first 5 lines of the body (of the latest customer article).' => '本文から最初の5行を取得 (最新の顧客記事)',

        # Template: AdminPGP
        'PGP Management' => 'PGP管理',
        'Add PGP key' => 'PGP鍵追加',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'この方法で直接SysConfigからキーリング設定を編集できます。',
        'Introduction to PGP' => 'PGPの導入',
        'Result' => '結果',
        'Identifier' => '識別子',
        'Bit' => 'ビット',
        'Key' => '鍵',
        'Fingerprint' => 'フィンガープリント',
        'Expires' => '期限切れ',
        'Delete this key' => 'この鍵を削除',
        'Add PGP Key' => 'PGP鍵を追加',

        # Template: AdminPackageManager
        'Package Manager' => 'パッケージ管理',
        'Uninstall package' => 'パッケージをアンインストール',
        'Version' => 'バージョン',
        'Do you really want to uninstall this package?' => 'このパッケージをアンインストールしますか？',
        'Reinstall package' => 'パッケージを再インストール',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => 'このパッケージを再インストールしますか？ 全ての手動変更点は失われます。',
        'Continue' => '続ける',
        'Install' => 'インストール',
        'Install Package' => 'パッケージをインストール',
        'Update repository information' => 'リポジトリ情報を更新',
        'Online Repository' => 'オンラインリポジトリ',
        'Vendor' => 'ベンダー',
        'Module documentation' => 'モジュールの書類',
        'Upgrade' => 'アップグレード',
        'Local Repository' => 'ローカルリポジトリ',
        'Uninstall' => 'アンインストール',
        'Package not correctly deployed! You should reinstall the package again!' => 'パッケージが正しく展開されませんでした！ パッケージを再インストールしてください！',
        'Reinstall' => '再インストール',
        'Download package' => 'パッケージをダウンロード',
        'Rebuild package' => 'パッケージを再構成',
        'Metadata' => 'メタデータ',
        'Change Log' => '変更履歴',
        'Date' => '日付',
        'List of Files' => '領域のリスト',
        'Permission' => '権限',
        'Download' => 'ダウンロード',
        'Download file from package!' => 'パッケージからファイルをダウンロードしてください！',
        'Required' => '必要項目',
        'PrimaryKey' => 'プライマリキー',
        'AutoIncrement' => '自動増加',
        'SQL' => 'SQL',
        'File differences for file %s' => '%s ファイルが違います',

        # Template: AdminPerformanceLog
        'Performance Log' => 'パフォーマンスログ',
        'This feature is enabled!' => 'この機能を有効にする！',
        'Just use this feature if you want to log each request.' => 'この機能は各要求をログに記録したい場合のみ利用してください。',
        'Activating this feature might affect your system performance!' => 'この機能を有効にするとシステムのパフォーマンスに影響が出る可能性があります。',
        'Disable it here!' => '無効にする！',
        'Logfile too large!' => 'ログファイルが大きすぎます',
        'The logfile is too large, you need to reset it' => 'ログファイルが大きすぎます。初期化してください。',
        'Overview' => '一覧',
        'Range' => '範囲',
        'Interface' => 'インターフェイス',
        'Requests' => '要求',
        'Min Response' => '最少応答',
        'Max Response' => '最大応答',
        'Average Response' => '平均応答',
        'Period' => '期間',
        'Min' => '最少',
        'Max' => '最大',
        'Average' => '平均',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'PostMasterフィルタ管理',
        'Add filter' => 'フィルタの追加',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '振り分けやメールヘッダを元に受信メールをフィルタします。正規表現を使用できます。',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'メールアドレスのみを一致させたい場合、EMAILADDRESS:info@example.comを差出人、宛先、Ccに使用してください。',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '正規表現を使う場合、設定で一致する値を[***]として使用できます。',
        'Delete this filter' => 'このフィルタを削除',
        'Add PostMaster Filter' => 'PostMasterフィルタを追加',
        'Edit PostMaster Filter' => 'PostMasterフィルタを削除',
        'Filter name' => 'フィルタ名',
        'Stop after match' => '一致後に停止',
        'Filter Condition' => 'フィルタ条件',
        'Value' => '値',
        'Set Email Headers' => 'メールヘッダを設定',

        # Template: AdminPriority
        'Priority Management' => '優先度管理',
        'Add priority' => '優先度を追加',
        'Add Priority' => '優先度を追加',
        'Edit Priority' => '優先度を編集',

        # Template: AdminQueue
        'Manage Queues' => 'キュー管理',
        'Add queue' => 'キューを追加',
        'Add Queue' => 'キューを追加',
        'Edit Queue' => 'キューを編集',
        'Sub-queue of' => 'このサブキュー',
        'Unlock timeout' => 'ロックの解除期限',
        '0 = no unlock' => '0 = ロック解除しない',
        'Only business hours are counted.' => '勤務時間のみ計算されます',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '担当者がチケットロック後、ロック期限切れ前に完了していない場合、ロックは解除され、他の担当者がチケットを担当できるようになります。',
        'Notify by' => '通知する時間',
        '0 = no escalation' => '0 = エスカレーションしない',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => 'ここで定義された時間の前に、新規チケットに顧客連絡先が追加されていないか、メール送信、電話などの連絡を取っていない場合、チケットがエスカレーションされます。',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => 'メールでの追跡やカスタマーポータルに追加された記事があれば、エスカレーション更新期限はリセットされます。ここで定義された時間内に顧客からの外部メールや電話の記録が追加されない場合、チケットがエスカレーションされます。',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => 'ここで定義された時間の前にチケットが完了しない場合、チケットがエスカレーションされます。',
        'Follow up Option' => '追跡オプション',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '完了したチケットを追跡したい場合、チケットを再度対応中にするか、拒否して新規チケットにするかを指定します。',
        'Ticket lock after a follow up' => 'チケットロック後に追跡',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => 'チケットが完了後に顧客がチケットを追跡する場合、旧所有者にロックされます。',
        'System address' => 'システムアドレス',
        'Will be the sender address of this queue for email answers.' => 'このキューでのメール回答はこの送信者アドレスになります。',
        'Default sign key' => '既定のサインキー',
        'The salutation for email answers.' => 'メール回答の挨拶文',
        'The signature for email answers.' => 'メール回答の署名',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => 'キュー - 自動応答の関連性の管理',
        'Filter for Queues' => 'キューフィルタ',
        'Filter for Auto Responses' => '自動応答フィルタ',
        'Auto Responses' => '自動応答',
        'Change Auto Response Relations for Queue' => 'キューと自動応答の関連性を変更',
        'settings' => '設定',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '応答 - キューの関連性の管理',
        'Filter' => 'フィルタ',
        'Filter for Responses' => '応答フィルタ',
        'Responses' => '応答',
        'Change Queue Relations for Response' => '応答とキューの関連性を変更',
        'Change Response Relations for Queue' => 'キューと応答の関連性を変更',

        # Template: AdminResponse
        'Manage Responses' => '応答管理',
        'Add response' => '応答を追加',
        'A response is default text to write faster answer (with default text) to customers.' => '応答は顧客に迅速に回答するために書いておく規定の文章です。',
        'Don\'t forget to add a new response a queue!' => '新規応答をキューに追加してください',
        'Delete this entry' => 'この登録を削除',
        'Add Response' => '応答を登録',
        'Edit Response' => '応答を編集',
        'The current ticket state is' => '現在のチケットの状態は',
        'Your email address is' => 'あなたのメールアドレスは',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '応答 <-> 添付ファイルの関連性の管理',
        'Filter for Attachments' => '添付ファイルフィルタ',
        'Change Response Relations for Attachment' => '添付ファイルと応答の関連性を変更',
        'Change Attachment Relations for Response' => '応答と添付ファイルの関連性を変更',
        'Toggle active for all' => '全てを有効に切り替え',
        'Link %s to selected %s' => '%s と %s を連結',

        # Template: AdminRole
        'Role Management' => '役割管理',
        'Add role' => '役割を追加',
        'Create a role and put groups in it. Then add the role to the users.' => '役割を作成してグループを追加後、ユーザーに役割を追加してください。',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '未定義の役割があります。新しい役割を作成し、追加ボタンを押してください。',
        'Add Role' => '役割を追加',
        'Edit Role' => '役割を編集',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '役割 - グループの関連性管理',
        'Filter for Roles' => '役割のフィルタ',
        'Roles' => '役割',
        'Select the role:group permissions.' => '役割：グループ権限を選択',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => 'グループと役割の関連性を変更',
        'Change Group Relations for Role' => '役割とグループの関連性を変更',
        'Toggle %s permission for all' => '全ての %s の権限を切り替え',
        'move_into' => '移動',
        'Permissions to move tickets into this group/queue.' => 'このグループ／キューにチケットの移転権限を付与',
        'create' => '作成',
        'Permissions to create tickets in this group/queue.' => 'このグループ／キューにチケットの作成権限を付与',
        'priority' => '優先度',
        'Permissions to change the ticket priority in this group/queue.' => 'このグループ／キューにチケットの優先度変更権限を付与',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '担当者 - 役割の関連性管理',
        'Filter for Agents' => '担当者のフィルタ',
        'Agents' => '担当者',
        'Manage Role-Agent Relations' => '役割 - 担当者の関連性管理',
        'Change Role Relations for Agent' => '担当者と役割の関連性を変更',
        'Change Agent Relations for Role' => '役割用と担当者の関連性を変更',

        # Template: AdminSLA
        'SLA Management' => 'SLA管理',
        'Add SLA' => 'SLAを追加',
        'Edit SLA' => 'SLAを編集',
        'Please write only numbers!' => '数値しか入力できません！',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME管理',
        'Add private key' => '秘密鍵の追加',
        'Add certificate' => '証明書の追加',
        'In this way you can directly edit the certification and private keys in file system.' => 'この方法で直接認証と秘密鍵を編集できます。',
        'See also' => '参照',
        'Hash/Fingerprint' => 'ハッシュ／フィンガープリント',
        'Create/Expires' => '作成／期限',
        'Delete this certificate' => 'この証明書を削除',
        'Add Certificate' => '証明書を追加',
        'Add Private Key' => '秘密鍵を追加',
        'Secret' => '秘密',

        # Template: AdminSalutation
        'Salutation Management' => '挨拶文管理',
        'Add salutation' => '挨拶文を追加',
        'Add Salutation' => '挨拶文を追加',
        'Edit Salutation' => '挨拶文を編集',
        'Example salutation' => '挨拶文の例',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => 'セキュアモードを有効にしてください！',
        'Secure mode will (normally) be set after the initial installation is completed.' => '初回インストール完了後、セキュアモード (通常) に設定されます',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'セキュアモードで実行中のため、Webインストーラーで再インストールするには無効にする必要があります。',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => 'セキュアモードが無効の場合、アプリケーションが既に実行されているため、SysConfigを介して有効にします。',

        # Template: AdminSelectBox
        'SQL Box' => 'SQLボックス',
        'Here you can enter SQL to send it directly to the application database.' => 'データベースにSQLを直接送信できます。',
        'Result format' => '結果の書式',
        'Run Query' => 'クエリー実行',

        # Template: AdminService
        'Service Management' => 'サービス管理',
        'Add service' => 'サービスの追加',
        'Add Service' => 'サービスの追加',
        'Edit Service' => 'サービスの編集',
        'Sub-service of' => 'このサブサービス',

        # Template: AdminSession
        'Session Management' => 'セッション管理',
        'All sessions' => '全セッション',
        'Agent sessions' => '担当者セッション',
        'Customer sessions' => '顧客セッション',
        'Unique agents' => '一意の担当者',
        'Unique customers' => '一意の顧客',
        'Kill all sessions' => '全セッション切断',
        'Session' => 'セッション',
        'Kill' => '切断',
        'Kill this session' => 'このセッションを切断',
        'Detail View for SessionID' => 'セッションIDの詳細表示',

        # Template: AdminSignature
        'Signature Management' => '署名管理',
        'Add signature' => '署名を追加',
        'Add Signature' => '署名を追加',
        'Edit Signature' => '署名を編集',
        'Example signature' => '署名の例',

        # Template: AdminState
        'State Management' => '状態管理',
        'Add state' => '状態を追加',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Kernel/Config.pm内の規定の状態を更新するので注意してください！',
        'Add State' => '状態を追加',
        'Edit State' => '状態を編集',
        'State type' => '状態の種別',

        # Template: AdminSysConfig
        'SysConfig' => '',
        'Edit the system configuration settings.' => 'システム設定の編集',
        'Navigate by searching in %s settings' => '検索した %s の設定へ移動',
        'Select Group' => 'グループを選択',
        'Navigate by selecting config groups' => '選択した設定グループへ移動',
        'Select group' => 'グループを選択',
        'Download all system config changes' => '変更された全システム設定をダウンロード',
        'Export settings' => '設定のエクスポート',
        'Load SysConfig settings from file' => 'ファイルからSysConfig設定を読み込み',
        'Import settings' => '設定のインポート',
        'Import Settings' => '設定のインポート',
        'Import' => 'インポート',
        'Please enter a search term to look for settings.' => '検索設定を見て用語を入力してください。',
        'Subgroup' => 'サブグループ',
        'Elements' => '要素',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '設定を編集',
        'This config item is only available in a higher config level!' => 'この項目は高設定レベルで設定できます！',
        'Reset this setting' => 'この設定をリセット',
        'Default value' => '規定値',
        'Error: this file could not be found.' => 'エラー: ファイルが見つかりませんでした。',
        'Error: this directory could not be found.' => 'エラー: ディレクトリが見つかりませんでした。',
        'Error: an invalid value was entered.' => 'エラー: 無効な値が入力されました。',
        'Content' => '内容',
        'Remove this entry' => '登録を削除',
        'Add entry' => '登録を追加',
        'Remove entry' => '登録を削除',
        'Add new entry' => '新しい登録を追加',
        'Create new entry' => '新しい登録を作成',
        'New group' => '新規グループ',
        'Group ro' => 'グループ ro',
        'Readonly group' => '読み取りグループ',
        'New group ro' => '新規グループ ro',
        'Loader' => 'ローダー',
        'File to load for this frontend module' => 'このファイルからフロントエンドモジュールを読み込みます',
        'New Loader File' => '新規読み込みファイル',
        'NavBarName' => 'ナビゲーションバー名',
        'NavBar' => 'ナビゲーションバー',
        'LinkOption' => '連結オプション',
        'Block' => 'ブロック',
        'AccessKey' => 'アクセスキー',
        'Add NavBar entry' => 'ナビゲーションバーに追加',
        'Year' => '年',
        'Month' => '月',
        'Day' => '日',
        'Invalid year' => '無効な年',
        'Invalid month' => '無効な月',
        'Invalid day' => '無効な日',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'システムメールアドレスの管理',
        'Add system address' => 'システムアドレス追加',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '宛先かCcにこのアドレスを持つ全てのメールは選択されたキューに振り分けられます。',
        'Email address' => 'メールアドレス',
        'Display name' => '表示名',
        'Add System Email Address' => 'システムメールアドレスの追加',
        'Edit System Email Address' => 'システムメールアドレスの編集',
        'The display name and email address will be shown on mail you send.' => '表示名、メールアドレスは送信メールに表示されます。',

        # Template: AdminType
        'Type Management' => '種別管理',
        'Add ticket type' => 'チケット種別の追加',
        'Add Type' => '種別の追加',
        'Edit Type' => '種別の編集',

        # Template: AdminUser
        'Add agent' => '担当者の追加',
        'Agents will be needed to handle tickets.' => '担当者はチケットを処理するために必要です。',
        'Don\'t forget to add a new agent to groups and/or roles!' => '新規担当者をグループまたは役割に追加してください！',
        'Please enter a search term to look for agents.' => '担当者検索の用語を入力してください。',
        'Last login' => '最終ログイン',
        'Login as' => 'このアドレスとしてログイン',
        'Switch to agent' => '担当者を切り替え',
        'Add Agent' => '担当者の追加',
        'Edit Agent' => '担当者の編集',
        'Firstname' => '名',
        'Lastname' => '姓',
        'Start' => '開始',
        'End' => '終了',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '担当者 - グループの関連性の管理',
        'Change Group Relations for Agent' => '担当者とグループの関連性を変更',
        'Change Agent Relations for Group' => 'グループと担当者の関連性を変更',
        'note' => '注釈',
        'Permissions to add notes to tickets in this group/queue.' => 'このグループ／キューにチケットへ注釈追加権限を付与',
        'owner' => '所有者',
        'Permissions to change the owner of tickets in this group/queue.' => 'このグループ／キューにチケットへ所有者変更権限を付与',

        # Template: AgentBook
        'Address Book' => 'アドレス帳',
        'Search for a customer' => '顧客を検索',
        'Add email address %s to the To field' => '宛先にメールアドレス %s を追加',
        'Add email address %s to the Cc field' => 'Ccにメールアドレス %s を追加',
        'Add email address %s to the Bcc field' => 'Bccにメールアドレス %s を追加',
        'Apply' => '適用',

        # Template: AgentCustomerSearch
        'Search Customer' => '顧客検索',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'ダッシュボード',
        'Show or hide the content' => '内容の表示・非表示',

        # Template: AgentDashboardCalendarOverview
        'in' => '＞',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s が利用できます！',
        'Please update now.' => '更新してください',
        'Release Note' => 'リリースノート',
        'Level' => 'レベル',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '%s の前の投稿',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => 'チケットはロック済です',
        'Undo & close window' => '元に戻してウィンドウを閉じる',

        # Template: AgentInfo
        'Info' => '情報',
        'To accept some news, a license or some changes.' => 'ニュース、ライセンスなどの変更を受け付ける。',

        # Template: AgentLinkObject
        'Link Object: %s' => '連結対象: %s',
        'Close window' => 'ウィンドウを閉じる',
        'go to link delete screen' => '連結解除画面へ移動',
        'Select Target Object' => '対象を選択',
        'Link Object' => '連結対象',
        'with' => 'と',
        'Unlink Object: %s' => '連結解除対象: %s',
        'go to link add screen' => '連結画面へ移動',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '個人設定を編集',

        # Template: AgentSpelling
        'Spell Checker' => 'スペルチェック',
        'spelling error(s)' => 'つづり間違い',
        'Apply these changes' => 'この変更を適用',

        # Template: AgentStatsDelete
        'Delete stat' => '統計を削除',
        'Stat#' => '統計番号',
        'Do you really want to delete this stat?' => 'この統計を削除してよろしいですか？',

        # Template: AgentStatsEditRestrictions
        'Step %s' => 'ステップ %s',
        'General Specifications' => '共通仕様',
        'Select the element that will be used at the X-axis' => 'X軸で使用される要素の選択',
        'Select the elements for the value series' => '系列値の要素を選択',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => '統計の合計値を制限することができます',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '',
        'Fixed' => '固定',
        'Please select only one element or turn off the button \'Fixed\'.' => '',
        'Absolute Period' => '絶対値',
        'Between' => 'この間',
        'Relative Period' => '相対値',
        'The last' => '最終',
        'Finish' => '完了',

        # Template: AgentStatsEditSpecification
        'Permissions' => '権限',
        'Some result formats are disabled because at least one needed package is not installed.' => '必要なパッケージがインストールされていないため、一部の結果の形式が無効になっています。',
        'Please contact your administrator.' => 'システム管理者に連絡してください。',
        'Graph size' => 'グラフサイズ',
        'Sum rows' => '行の合計',
        'Sum columns' => '列の合計',
        'Use cache' => 'キャッシュの使用',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '統計情報はほとんどがキャッシュすることができます。この統計でのプレゼンテーションを高速化できます',
        'If set to invalid end users can not generate the stat.' => '無効なエンドユーザーに設定されている場合、統計を生成できません。',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => 'ここで値系列を定義できます',
        'You have the possibility to select one or two elements.' => '1つか2つの要素を選択可能です。',
        'Then you can select the attributes of elements.' => 'その後、要素の属性を選択できます。',
        'Each attribute will be shown as single value series.' => '各属性は単一の値の系列として表示されます。',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => '目盛',
        'minimal' => '最少',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '値系列の目盛はX軸の目盛より大きくする必要があります (例: X軸=>月、値系列=>年)',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => 'X軸が定義できます。ラジオボタンで1つの要素を選択してください。',
        'maximal period' => '最大単位',
        'minimal scale' => '最少目盛',

        # Template: AgentStatsImport
        'Import Stat' => '統計のインポート',
        'File is not a Stats config' => 'ファイルは統計の設定ではありません',
        'No File selected' => 'ファイルが選択されていません',

        # Template: AgentStatsOverview
        'Stats' => '統計',
        'Object' => '対象',

        # Template: AgentStatsPrint
        'Print' => '印刷',
        'No Element selected.' => '要素が選択されていません。',

        # Template: AgentStatsView
        'Export config' => '設定のエクスポート',
        'With the input and select fields you can influence the format and contents of the statistic.' => '選択した入力領域を使用すると、書式や統計内容に影響を与えます',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '統計の詳細',
        'Format' => '書式',
        'Graphsize' => 'グラフのサイズ',
        'Cache' => 'キャッシュ',
        'Exchange Axis' => '縦横軸の交換',
        'Configurable params of static stat' => '静的統計情報の設定可能パラメータ',
        'No element selected.' => '要素が選択されていません。',
        'maximal period from' => '最大期間から',
        'to' => '',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => 'チケットの自由入力を変更',
        'Change Owner of Ticket' => 'チケットの所有者を変更',
        'Close Ticket' => 'チケットを閉じる',
        'Add Note to Ticket' => 'チケットに注釈を追加',
        'Set Pending' => '保留に設定',
        'Change Priority of Ticket' => 'チケットの優先度を変更',
        'Change Responsible of Ticket' => 'チケットの応答者を変更',
        'Cancel & close window' => '取り消してウィンドウを閉じる',
        'Service invalid.' => '無効なサービスです',
        'New Owner' => '新規所有者',
        'Please set a new owner!' => '新規所有者を設定してください！',
        'Previous Owner' => '以前の所有者',
        'Inform Agent' => '担当者に知らせる',
        'Optional' => 'オプション',
        'Inform involved Agents' => '関係担当者に知らせる',
        'Spell check' => 'スペルチェック',
        'Note type' => '注釈種別',
        'Next state' => '次の状態',
        'Pending date' => '保留日時',
        'Date invalid!' => '日時が無効です！',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => 'バウンスチケット: ',
        'Bounce to' => 'バウンスto',
        'You need a email address.' => 'メールアドレスが必要です',
        'Need a valid email address or don\'t use a local email address.' => '有効なメールアドレスを使用するか、ローカルなメールアドレスを使用しないでください。',
        'Next ticket state' => 'チケットの次の状態',
        'Inform sender' => '送信者に知らせる',
        'Send mail!' => 'メール送信！',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'チケット一括処理',
        'Merge to' => 'これと結合',
        'Invalid ticket identifier!' => '無効なチケット識別子です！',
        'Merge to oldest' => '古いものへ結合',
        'Link together' => '一緒に連結',
        'Link to parent' => '親と連結',
        'Unlock tickets' => 'チケットのロック解除',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'チケットの回答を作成',
        'Need a valid email address.' => '有効なメールアドレスが必要です。',
        'Address book' => 'アドレス帳',
        'Pending Date' => '保留期間',
        'for pending* states' => '状態:保留にする',
        'Date Invalid!' => '日時が無効です！',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'チケットの顧客を変更',
        'Customer Data' => '顧客情報',
        'Customer user' => '顧客ユーザー',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '新規メールチケットを作成',
        'From queue' => 'キューから',
        'Get all' => '全てを取得',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '転送されたチケット:',
        'Need a valid email address or don\'t use a local email address' => '有効なメールアドレスを使用するか、ローカルなメールアドレスを使用しないでください。',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => '履歴: ',
        'History Content' => '履歴内容',
        'Zoom view' => '拡大表示',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'チケット結合',
        'The Ticket was locked' => 'このチケットはロックされています',
        'You need to use a ticket number!' => '使用するチケット番号が必要です。',
        'A valid ticket number is required.' => '有効なチケット番号が必要です。',

        # Template: AgentTicketMove
        'Move Ticket' => 'チケット移転',
        'New Queue' => '新規キュー',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '全選択',
        'No ticket data found.' => 'チケットデータがありません',
        'First Response Time' => '初回応答期限',
        'Service Time' => 'サービス時間',
        'Update Time' => '更新期限',
        'Solution Time' => '解決期限',
        'Move ticket to a different queue' => '別のキューへチケットを移転',
        'Change queue' => 'キュー変更',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => '検索オプション変更',
        'Max. shown Tickets a page' => '1ページに表示するチケットの最大数',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'エスカレーション: ',
        'Locked' => 'ロック状態',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '新規電話チケット作成',
        'From customer' => '顧客から',
        'To queue' => 'キューへ',
        'Create' => '作成',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => '電話応答',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'メールのテキスト書式表示',
        'Plain' => '書式なし',
        'Download this email' => 'このメールをダウンロード',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'チケット情報',
        'Accounted time' => '作業時間',
        'Linked-Object' => '連結対象',
        'by' => '',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => '検索テンプレート',
        'Create New' => '新規作成',
        'Create Template' => 'テンプレート作成',
        'Save changes in template' => '変更したテンプレートを保存',
        'Add another attribute' => '別属性を追加',
        'Output' => '出力',
        'Fulltext' => '全文',
        'Remove' => '削除',
        'Customer User Login' => '顧客ユーザーログイン',
        'Time1' => '時間1',
        'Time2' => '時間2',
        'Time3' => '時間3',
        'Time4' => '時間4',
        'Time5' => '時間5',
        'Time6' => '時間6',
        'Created in Queue' => 'キューで作成された',
        'Lock state' => 'ロックの状態',
        'Watcher' => '監視者',
        'Article Create Time (before/after)' => '記事作成時間 (前／後)',
        'Article Create Time (between)' => '記事作成時間 (期間中)',
        'Ticket Create Time (before/after)' => 'チケット作成時間 (前／後)',
        'Ticket Create Time (between)' => 'チケット作成時間 (期間中)',
        'Ticket Change Time (before/after)' => 'チケット変更時間 (前／後)',
        'Ticket Change Time (between)' => 'チケット変更時間 (期間中)',
        'Ticket Close Time (before/after)' => 'チケット完了時間 (前／後)',
        'Ticket Close Time (between)' => 'チケット完了時間 (期間中)',
        'Archive Search' => '書庫検索',
        'Run Search' => '検索実行',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '記事フィルタ',
        'Save filter settings as default' => '既定のフィルタ設定を保存',
        'Ticket Information' => 'チケット情報',
        'Linked Objects' => '連結済対象',
        'Article(s)' => '記事',
        'Change Queue' => 'キュー変更',
        'Article Filter' => '記事フィルタ',
        'Add Filter' => 'フィルタ追加',
        'Set' => '設定',
        'Reset Filter' => 'フィルタをリセット',
        'Show one article' => '一つの記事を閲覧',
        'Show all articles' => '全ての記事を閲覧',
        'Unread articles' => '未読記事',
        'No.' => '番号',
        'Unread Article!' => '未読記事があります！',
        'Incoming message' => '受信メッセージ',
        'Outgoing message' => '送信メッセージ',
        'Internal message' => '内部メッセージ',
        'Resize' => 'リサイズ',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => 'プライバシー保護のために有効な、またはリモートの内容がブロックされています。',
        'Load blocked content.' => 'ブロックされた内容を読み込み。',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'トレースバック',

        # Template: CustomerFooter
        'Powered by' => '',
        'One or more errors occurred!' => '一つ以上のエラーが発生しました。',
        'Close this dialog' => 'このダイアログを閉じる',
        'Could not open popup window. Please disable any popup blockers for this application.' => 'ポップアップウィンドウを開けませんでした。アプリケーションのポップアップブロッカーを無効にしてください。',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'ログイン',
        'User name' => 'ユーザー名',
        'Your user name' => 'ユーザー名',
        'Your password' => 'パスワード',
        'Forgot password?' => 'パスワードを忘れましたか？',
        'Log In' => 'ログイン',
        'Not yet registered?' => '未登録ですか？',
        'Sign up now' => '新規登録する',
        'Request new password' => '新規パスワードを申請',
        'Your User Name' => 'ユーザー名',
        'A new password will be sent to your email address.' => '登録されたメールアドレスに新しいパスワードを送信しました。',
        'Create Account' => 'アカウント作成',
        'Please fill out this form to recieve login credentials.' => 'ログイン情報を受信するには必要事項を記入してください。',
        'How we should address you' => '',
        'Your First Name' => 'あなたの名前',
        'Please supply a first name' => '名前を入力してください',
        'Your Last Name' => 'あなたの名字',
        'Please supply a last name' => '名字を入力してください。',
        'The User Name you wish to have' => '希望するユーザー名',
        'Please supply a' => '入力してください: ',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '個人設定の編集',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '品質保証合意 (SLA)',

        # Template: CustomerTicketOverview
        'You have not created a ticket yet.' => 'チケットが未作成です。',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you.' => '',
        'We stop eating if you wish us to do.' => '',
        'Your way to communicate with us is this thing called \'ticket\'.' => '',
        'Please command us.' => '',
        'Create your first Ticket' => '最初のチケットを作成します。',

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Profile' => 'プロファイル',
        'Search-Template' => '検索テンプレート',
        'e. g. 10*5155 or 105658*' => '例: 10*5155 または 105658*',
        'Customer ID' => '顧客ID',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => 'チケット内全文検索 (例 "Max*" または "Muster*")',
        'Recipient' => '宛先',
        'Carbon Copy' => 'Cc',
        'Time restrictions' => '時間制限',
        'Only tickets created' => '作成されたチケットのみ',
        'Only tickets created between' => 'この期間に作成されたチケットのみ',
        'Search-Profile as Template?' => '検索 - プロファイルのテンプレート',
        'Save as Template?' => 'テンプレートを保存しますか？',
        'Template Name' => 'テンプレート名',
        'Output to' => '出力: ',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => '',
        'Page' => 'ページ',
        'Search Results for' => '検索結果: ',

        # Template: CustomerTicketZoom
        'Loading' => '読み込み中...',
        'Reply' => '返信',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '無効な日付です！ (未来の日付が必要)',
        'Previous' => '過去',
        'Sunday' => '日曜日',
        'Monday' => '月曜日',
        'Tuesday' => '火曜日',
        'Wednesday' => '水曜日',
        'Thursday' => '木曜日',
        'Friday' => '金曜日',
        'Saturday' => '土曜日',
        'Su' => '日',
        'Mo' => '月',
        'Tu' => '火',
        'We' => '水',
        'Th' => '木',
        'Fr' => '金',
        'Sa' => '土',
        'Open date selection' => '対応開始日を選択',

        # Template: Error
        'Oops! An Error occurred.' => 'エラーが発生しました！',
        'Error Message' => 'エラーメッセージ',
        'You can' => '次のことができます: ',
        'Send a bugreport' => 'バグ報告を送信',
        'go back to the previous page' => '直前のページに戻る',
        'Error Details' => 'エラー詳細',

        # Template: Footer
        'Top of page' => 'ページトップへ',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => 'このページから移動します。全てのポップアップウィンドウを閉じてもよろしいですか？',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '既にポップアップウィンドウを開いています。開いているウィンドウを閉じて新しく開きますか？',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'ログイン中: ',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'JavaScriptが利用できません。',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'OTRSを利用するにはお使いのブラウザでJavaScriptを有効にする必要があります。',
        'Database Settings' => 'データベース設定',
        'General Specifications and Mail Settings' => '共通仕様とメール設定',
        'Welcome to %s' => 'ようこそ %s',
        'Web site' => 'Webサイト',
        'Database check successful.' => 'データベースチェックに成功しました。',
        'Mail check successful.' => 'メールチェックに成功しました。',
        'Error in the mail settings. Please correct and try again.' => 'メール設定中にエラーが発生しました。再設定してください。',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '送信メール設定',
        'Outbound mail type' => '送信メール種別',
        'Select outbound mail type.' => '送信メール種別を選択',
        'Outbound mail port' => '送信メールポート',
        'Select outbound mail port.' => '送信メールポートを選択',
        'SMTP host' => 'SMTPホスト',
        'SMTP host.' => 'SMTPホスト名',
        'SMTP authentication' => 'SMTP認証',
        'Does your SMTP host need authentication?' => 'SMTP認証の必要はありますか？',
        'SMTP auth user' => 'SMTP認証ユーザー',
        'Username for SMTP auth.' => 'SMTP認証で使用するユーザー名',
        'SMTP auth password' => 'SMTP認証パスワード',
        'Password for SMTP auth.' => 'SMTP認証で使用するパスワード',
        'Configure Inbound Mail' => '受信メール設定',
        'Inbound mail type' => '受信メール種別',
        'Select inbound mail type.' => '受信メール種別を選択',
        'Inbound mail host' => '受信メールホスト',
        'Inbound mail host.' => '受信メールホスト名',
        'Inbound mail user' => '受信メールユーザー',
        'User for inbound mail.' => 'メールを受信するユーザー',
        'Inbound mail password' => '受信メールパスワード',
        'Password for inbound mail.' => 'メールを受信するパスワード',
        'Result of mail configuration check' => 'メール設定チェックの結果',
        'Check mail configuration' => 'メール設定チェック',
        'Skip this step' => 'この手順を飛ばす',

        # Template: InstallerDBResult
        'False' => '失敗',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'データベースのrootパスワードが設定されている場合、ここに入力する必要があります。されていない場合は空白にしてください。セキュリティ上の理由から、私たちはrootのパスワードを設定することをお勧めしません。詳しくはデータベースのマニュアルを参照してください。',
        'Currently only MySQL is supported in the web installer.' => '現在のインストーラーはMySQLのみサポートしています。',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => 'もしOTRSに違うタイプのデータベースをインストールしたい場合、README.databaseファイルを参照してください。',
        'Database-User' => 'データベースユーザー',
        'New' => '新規',
        'A new database user with limited rights will be created for this OTRS system.' => 'このOTRSシステム用に限られた権限の新規データベースユーザーが作成されます。',
        'default \'hot\'' => '既定パスワード \'hot\'',
        'DB--- host' => 'データベース - ホスト',
        'Database' => 'データベース',
        'Check database settings' => 'データベース設定をチェック',
        'Result of database check' => 'データベースチェックの結果',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'OTRSを使用するには、rootでコマンドライン上 (ターミナル／シェル) から次の行を入力する必要があります。',
        'Restart your webserver' => 'Webサーバを再起動してください。',
        'After doing so your OTRS is up and running.' => 'その後、OTRSの起動を実行してください。',
        'Start page' => 'スタートページ',
        'Your OTRS Team' => '',

        # Template: InstallerLicense
        'Accept license' => 'ライセンスに同意する',
        'Don\'t accept license' => 'ライセンスに同意しない',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'システムID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => 'システムの識別子。各チケット番号とHTTPセッションIDはこの番号が含まれます。',
        'System FQDN' => 'システムのFQDN',
        'Fully qualified domain name of your system.' => 'システムのFQDN',
        'AdminEmail' => '管理者メール',
        'Email address of the system administrator.' => 'システム管理者のメールアドレス',
        'Organization' => '組織',
        'Log' => 'ログ',
        'LogModule' => 'ログモジュール',
        'Log backend to use.' => 'ログバックエンドを使用するには',
        'LogFile' => 'ログファイル',
        'Log file location is only needed for File-LogModule!' => 'File-LogModuleのためにログファイルの場所が必要です。',
        'Webfrontend' => 'Webフロントエンド',
        'Default language' => '既定の言語',
        'Default language.' => '既定の言語。',
        'CheckMXRecord' => 'MXレコードのチェック',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '入力されたメールアドレスがDNSのMXレコードと照合されます。利用しているDNSが遅い場合、または公開アドレスが解決できない場合はこのオプションを使用しないでください。',

        # Template: LinkObject
        'Object#' => '対象の番号',
        'Add links' => '連結を追加',
        'Delete links' => '連結を削除',

        # Template: Login
        'JavaScript Not Available' => 'JavaScriptが有効になっていません。',
        'Browser Warning' => 'ブラウザの警告',
        'The browser you are using is too old.' => 'ご利用のブラウザは古すぎます。',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => 'OTRSは次のいずれかのブラウザで実行してください。ブラウザ内で巨大なリストを使用します。',
        'Please see the documentation or ask your admin for further information.' => '詳細はマニュアルを参照するか、管理者にお問い合わせください。',
        'Lost your password?' => 'パスワードを忘れました',
        'Request New Password' => '新規パスワードを申請',
        'Back to login' => 'ログイン画面に戻る',

        # Template: Motd
        'Message of the Day' => '今日のメッセージ',

        # Template: NoPermission
        'Insufficient Rights' => '権限がありません',
        'Back to the previous page' => '前のページに戻る。',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '最初のページを表示',
        'Show previous pages' => '前のページを表示',
        'Show page %s' => '%s ページを表示',
        'Show next pages' => '次のページを表示',
        'Show last page' => '最後のページを表示',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => '',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS テストページ',
        'Welcome %s' => 'ようこそ %s',
        'Counter' => 'カウンター',

        # Template: Warning
        'Go back to the previous page' => '前のページへ戻る',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '担当者通知',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '担当者 <-> グループ',
        'Agents <-> Roles' => '担当者 <-> 役割',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => '添付ファイル <-> 応答',
        'Auto Responses <-> Queues' => '自動応答 <-> キュー',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => 'パスワード変更',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '企業',
        'Company Tickets' => '企業チケット',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => 'HTMLメールをテキストメッセージに変換',
        'Create and manage Service Level Agreements (SLAs).' => '品質保証合意 (SLA) の作成と管理',
        'Create and manage agents.' => '担当者の作成と管理',
        'Create and manage attachments.' => '添付ファイルの作成と管理',
        'Create and manage companies.' => '企業の作成と管理',
        'Create and manage customers.' => '顧客の作成と管理',
        'Create and manage event based notifications.' => 'イベント経由通知の作成と管理',
        'Create and manage groups.' => 'グループの作成と管理',
        'Create and manage notifications that are sent to agents.' => '担当者へ送信する通知の作成と管理',
        'Create and manage queues.' => 'キューの作成と管理',
        'Create and manage response templates.' => '応答テンプレートの作成と管理',
        'Create and manage responses that are automatically sent.' => '自動送信する応答の作成と管理',
        'Create and manage roles.' => '役割の作成と管理',
        'Create and manage salutations.' => '挨拶文の作成と管理',
        'Create and manage services.' => 'サービスの作成と管理',
        'Create and manage signatures.' => '署名の作成と管理',
        'Create and manage ticket priorities.' => 'チケット優先度の作成と管理',
        'Create and manage ticket states.' => 'チケット状態の作成と管理',
        'Create and manage ticket types.' => 'チケット種別の作成と管理',
        'Create new email ticket and send this out (outbound)' => '新規メールチケットと外部送信の作成',
        'Create new phone ticket (inbound)' => '新規受信電話チケットの作成',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '顧客 <-> グループ',
        'Customers <-> Services' => '顧客 <-> サービス',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repositoriy, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'メールアドレス',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => 'Aktiviert unterst?tzung f?r S/MIME.',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => 'エスカレーション一覧',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '自由入力の例',
        'Execute SQL statements.' => 'SQL文の実行',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '受信メールフィルタ',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => 'フロントエンドの言語',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => 'フロントエンドのテーマ',
        'GenericAgent' => '管理用ジョブ',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove tailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => 'インターフェイスの言語',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '担当者をグループへ連結',
        'Link agents to roles.' => '担当者を役割へ連結',
        'Link attachments to responses templates.' => '添付ファイルを応答テンプレートへ連結',
        'Link customers to groups.' => '顧客をグループへ連結',
        'Link customers to services.' => '顧客をサービスへ連結',
        'Link queues to auto responses.' => 'キューを自動応答へ連結',
        'Link responses to queues.' => '応答をキューへ連結',
        'Link roles to groups.' => '役割をグループへ連結',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => 'メール暗号用のPGP鍵管理',
        'Manage POP3 or IMAP accounts to fetch email from.' => 'メール受信用POP3/IMAPアカウント管理',
        'Manage S/MIME certificates for email encryption.' => 'メール暗号用のS/MIME証明書管理',
        'Manage existing sessions.' => '既存セッション管理',
        'Manage periodic tasks.' => '周期的なタスク管理',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => 'チケット表示最大数',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '担当チケット',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '新規メールチケット',
        'New phone ticket' => '新規電話チケット',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '通知 (イベント)',
        'Number of displayed tickets' => '表示チケット数',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => 'エスカレーション済チケット一覧',
        'Overview of all open Tickets.' => '全対応中チケット一覧',
        'PGP Key Upload' => 'PGP鍵アップロード',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => 'PostMasterフィルタ',
        'PostMaster Mail Accounts' => 'PostMasterメールアカウント',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => 'キュー一覧',
        'QueueView Refresh Time' => 'キュー一覧更新時間',
        'Refresh interval' => '更新間隔',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => '応答 <-> キュー',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => '役割 <-> グループ',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => 'S/MIME証明書アップロード',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Search Ticket' => 'チケット検索',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'フロントエンドのテーマを選択してください。',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '顧客が追跡し、かつ自分がチケット所有者になるか、チケットがロック解除されて自分が購読中のキューのいずれかになった場合通知を送信',
        'Send notifications to users.' => 'ユーザーに通知を送信',
        'Send ticket follow up notifications' => 'チケット追跡通知の送信',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => 'このシステムのメール送信者を設定',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Skin' => 'スキン',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '統計',
        'Status view' => '状態一覧',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => 'チケット一覧',
        'Tickets' => 'チケット',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '種別',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => 'このシステムのソフトウェアパッケージの更新と拡張',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => 'パフォーマンスベンチマーク結果を見る。',
        'View system log messages.' => 'システムログメッセージを見る。',
        'Wear this frontend skin' => 'このフロントエンドスキンに変更。',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '使用する言語',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s のチケットは影響を受けます！このジョブを実行しますか？',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(回答を作成するときにメールアドレスのMXレコードチェックを行います。あなたのOTRSシステムがダイヤルアップ回線の場合はCheckMXRecordを使用しないでください $!)',
        '(Email of the system admin)' => '(システム管理者のメール)',
        '(Full qualified domain name of your system)' => '(このシステムのFQDN)',
        '(Logfile just needed for File-LogModule!)' => '(ログファイルはFile-LogModuleを必要とします！)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        '(Note: Useful for big databases and low performance server)' => '(注: 大きいデータベースや低パフォーマンスのサーバに便利です。)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(システム識別子。各チケット番号はHTTPセッションidとこの番号で開始されます。)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(チケット識別子。一部の人はこれを設定します。例: \'Ticket#\'、\'Call#\'、\'MyTicket#\')',
        '(Used default language)' => '(使用中の既定の言語)',
        '(Used log backend)' => '(使用中のログバックエンド)',
        '(Used ticket number format)' => '(使用中のチケット番号の書式)',
        'A article should have a title!' => '記事にはタイトルが必要です。',
        'A message must be spell checked!' => 'メッセージはスペルチェックが必須です！',
        'A message should have a To: recipient!' => 'メッセージの宛先に受信者がありません！',
        'A message should have a body!' => 'メッセージに本文がありません！',
        'A message should have a customer!' => 'メッセージに顧客がありません！',
        'A message should have a subject!' => 'メッセージに表題がありません！',
        'A required field is:' => 'この領域が必要です: ',
        'A ticket should be associated with a queue!' => 'チケットがキューに関連付けられていません！',
        'A ticket should have a type!' => 'チケットに種別がありません！',
        'About OTRS' => 'OTRSとは',
        'Absolut Period' => '絶対的な期間',
        'Add Customer User' => '顧客ユーザー追加',
        'Add System Address' => 'システムアドレス追加',
        'Add User' => 'ユーザー追加',
        'Add a new Agent.' => '新規担当者を追加',
        'Add a new Customer Company.' => '新規顧客企業を追加',
        'Add a new Group.' => '新規グループを追加',
        'Add a new Notification.' => '新規通知を追加',
        'Add a new Priority.' => '新規優先度を追加',
        'Add a new Role.' => '新規役割を追加',
        'Add a new SLA.' => '新規SLAを追加',
        'Add a new Salutation.' => '新規挨拶文を追加',
        'Add a new Service.' => '新規サービスを追加',
        'Add a new Signature.' => '新規署名を追加',
        'Add a new State.' => '新規状態を追加',
        'Add a new System Address.' => '新規システムアドレスを追加',
        'Add a new Type.' => '新規種別を追加',
        'Add a new salutation' => '新規挨拶を追加',
        'Add new attachment' => '新規添付ファイル追加',
        'Add note to ticket' => '注釈をチケットへ追加',
        'Add to list of subscribed tickets' => '購読チケットをリストに追加',
        'Added User "%s"' => '"%s" ユーザーを追加しました',
        'Admin-Area' => '管理領域',
        'Admin-Password' => '管理者パスワード',
        'Admin-User' => '管理者',
        'Admin-password' => '管理者パスワード',
        'Agent Mailbox' => '担当者メールボックス',
        'Agent Preferences' => '担当者個人設定',
        'Agent based' => '担当者経由',
        'Agent-Area' => '担当者領域',
        'All Agent variables.' => '全ての担当者変数。',
        'All Agents' => '全ての担当者',
        'All Customer variables like defined in config option CustomerUser.' => '全ての顧客の変数が設定オプションCustomerUserで定義されます。',
        'All customer tickets.' => '全ての顧客チケット',
        'All email addresses get excluded on replaying on composing an email.' => '全てのメールアドレスがメール返信を作成するときに除外されます',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'この電子メール (To:) と全ての受信メールが、選択したキューに振り分けられます！',
        'All messages' => '全てのメッセージ',
        'All new tickets!' => '全ての新規チケット！',
        'All tickets' => '全てのチケット',
        'All tickets where the reminder date has reached!' => '全てのチケットが期限切れになりました！',
        'All tickets which are escalated!' => '全てのチケットがエスカレーションされました！',
        'Allocate CustomerUser to service' => '顧客ユーザーをサービスに割り当て',
        'Allocate services to CustomerUser' => 'サービスを顧客ユーザーに割り当て',
        'Answer' => '回答',
        'Article Create Times' => '記事作成時間',
        'Article Type' => '記事種別',
        'Article created' => '記事作成日',
        'Article created between' => '記事作成日がこの期間中',
        'Article filter settings' => '記事フィルタ設定',
        'Attach' => '添付ファイル',
        'Attribute' => '属性',
        'Auto Response From' => '自動返答: ',
        'Bounce ticket' => 'バウンスチケット: ',
        'CSV' => 'CSV',
        'Can not create link with %s!' => '%sと連結できませんでした！',
        'Can not delete link with %s!' => '%sと連結が解除できませんでした！',
        'Can\'t update password, invalid characters!' => 'パスワード更新ができません！ 無効な文字列あります。',
        'Can\'t update password, must be at least %s characters!' => 'パスワード更新ができません！ 最低 %s 文字以上必要です。',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'パスワード更新ができません！ 英語大文字小文字が2文字以上必要です。',
        'Can\'t update password, needs at least 1 digit!' => 'パスワードが更新できません！ 数字が1文字以上必要です。',
        'Can\'t update password, needs at least 2 characters!' => 'パスワードが更新できません！ 2文字以上必要です。',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'パスワードが更新できません！ パスワードが一致しません。',
        'Category Tree' => 'カテゴリツリー',
        'Change %s settings' => '%sの設定変更',
        'Change Time' => '時間を変更',
        'Change Times' => '時間を変更',
        'Change free text of ticket' => 'チケットの自由入力を変更',
        'Change owner of ticket' => 'チケットの所有者を変更',
        'Change priority of ticket' => 'チケットの優先度を変更',
        'Change responsible of ticket' => 'チケットの応答者を変更',
        'Change user <-> group settings' => 'ユーザー <-> グループ設定を変更',
        'ChangeLog' => 'ChangeLog',
        'Check Mail Configuration' => 'メール設定を変更',
        'Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behind a dial-up line!' => '',
        'Child-Object' => '子対象',
        'City{CustomerUser}' => 'City',
        'Classification' => '分類',
        'Clear From' => 'フォームリセット',
        'Clear To' => 'リセット: ',
        'Click here to report a bug!' => 'バグ報告を送信！',
        'Close Times' => '完了時間',
        'Close ticket' => '完了チケット',
        'Close type' => '完了種別',
        'Close!' => '完了！',
        'Collapse View' => '失敗一覧',
        'Comment (internal)' => 'コメント (内部向け)',
        'Comment{CustomerUser}' => 'Comment',
        'CompanyTickets' => '企業チケット',
        'Compose Answer' => '回答作成',
        'Compose Email' => 'メール作成',
        'Compose Follow up' => '追跡作成',
        'Config Options' => '設定オプション',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '設定オプション (例 &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => '設定オプション (例 <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '設定オプション (例 <OTRS_CONFIG_HttpType).',
        'Contact customer' => '顧客に連絡',
        'Country{CustomerUser}' => 'Country',
        'Create New Template' => '新規テンプレート作成',
        'Create Times' => '作成時間',
        'Create new Phone Ticket' => '新規電話チケット作成',
        'Create new database' => '新規データベース作成',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => '新規グループ作成は担当者ごとのアクセス許可を処理します (例 購買部、サポート部、営業部、その他)。',
        'CreateTicket' => 'チケット作成',
        'Current Impact Rating' => '現在の影響評価',
        'Customer Move Notify' => '顧客の移転通知',
        'Customer Owner Notify' => '顧客の所有者通知',
        'Customer State Notify' => '顧客の状態通知',
        'Customer User' => '顧客ユーザー',
        'Customer User Management' => '顧客ユーザー管理',
        'Customer Users' => '顧客ユーザー',
        'Customer Users <-> Groups' => '顧客ユーザー <-> グループ',
        'Customer Users <-> Groups Management' => '顧客ユーザー <-> グループ管理',
        'Customer Users <-> Services' => '顧客ユーザー <-> サービス',
        'Customer Users <-> Services Management' => '顧客ユーザー <-> サービス管理',
        'Customer history' => '顧客履歴',
        'Customer history search' => '顧客履歴検索',
        'Customer history search (e. g. "ID342425").' => '顧客履歴検索 (例 "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => '顧客ユーザーは顧客履歴と顧客パネルからログインするために必要です。',
        'CustomerID{CustomerUser}' => 'Customer ID',
        'CustomerUser' => '顧客ユーザー',
        'DB Admin Password' => 'DB 管理者パスワード',
        'DB Admin User' => 'DB 管理者ユーザー',
        'DB connect host' => 'DB接続先ホスト',
        'Default' => '既定',
        'Default Charset' => '既定の文字コード',
        'Default Language' => '既定の言語',
        'Delete old database' => '古いデータベースの削除',
        'Detail' => '詳細',
        'Diff' => '差分',
        'Discard all changes and return to the compose screen' => '全ての変更を取り消し、作成画面に戻る',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '受信メール経由ではX-Headerによって振り分けやフィルタがされます。正規表現が使えます。',
        'Do you really want to delete this Object?' => 'この対象を削除しますか？',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'このパッケージを再インストールしますか？ (全ての手動での変更点は失われます)',
        'Don\'t forget to add a new user to groups and/or roles!' => '新規ユーザーをグループや役割に追加してください！',
        'Don\'t forget to add a new user to groups!' => '新規ユーザーをグループに追加してください！',
        'Download Settings' => 'ダウンロード設定',
        'Download all system config changes.' => '全てのシステム設定の変更をダウンロード',
        'Drop Database' => 'Drop Database',
        'Dynamic-Object' => '動的な対象',
        'Edit Customers' => '顧客編集',
        'Edit default services.' => '既定のサービスの編集',
        'Email based' => 'メール経由',
        'Email of the system admin.' => 'システム管理者のメール',
        'Email{CustomerUser}' => 'E-mail address',
        'Escalation' => 'エスカレーション',
        'Escalation - First Response Time' => 'エスカレーション - 初回応答期限',
        'Escalation - Solution Time' => 'エスカレーション - 解決期限',
        'Escalation - Update Time' => 'エスカレーション - 更新期限',
        'Escalation Times' => 'エスカレーション時間',
        'Escalation time' => 'エスカレーション時間',
        'Event is required!' => 'イベントが必要です！',
        'Expand View' => '展開表示',
        'Explanation' => '説明',
        'Export Config' => '設定のエクスポート',
        'FAQ Search Result' => 'FAQ検索結果',
        'FAQ System History' => 'FAQシステム履歴',
        'Fax{CustomerUser}' => 'Fax',
        'File-Name' => 'ファイル名',
        'File-Path' => 'ファイルパス',
        'Filelist' => 'ファイルリスト',
        'Filtername' => 'フィルタ名',
        'Firstname{CustomerUser}' => 'First name',
        'Follow up' => '追跡',
        'Follow up notification' => '追跡の通知',
        'For very complex stats it is possible to include a hardcoded file.' => '非常に複雑な統計データについてはハードコーディングされたファイルをインクルードできます。',
        'Foward ticket: ' => '転送チケット: ',
        'Frontend' => 'フロントエンド',
        'Full qualified domain name of your system.' => 'このシステムのFQDN',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '記事の全文検索 (例 "Mar*in" や "Baue*")',
        'Go' => '実行',
        'Group Ro' => 'Roグループ',
        'Group based' => 'グループ経由',
        'Group selection' => 'グループ選択',
        'Hash' => 'ハッシュ',
        'Have a lot of fun!' => 'お楽しみください！',
        'Have you lost your password?' => 'パスワードを忘れましたか？',
        'Help' => 'ヘルプ',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ここでは値系列を定義することができます。各要素は単一の系列として表示されます。統計を生成する時に要素なにも選択しない場合、最後の新規要素が追加されます。',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ここではX軸を定義することができます。ラジオボタンで1つの要素を選択してください。統計を生成する時に要素なにも選択しない場合、最後の新規要素が追加されます。',
        'Here you can insert a description of the stat.' => 'ここでは統計の説明を挿入できます。',
        'Here you can select the dynamic object you want to use.' => 'ここでは必要なダイナミックオブジェクトを選択できます。',
        'Home' => 'ホーム',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => '',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => '',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => '',
        'If you need the sum of every column select yes.' => '全ての列の合計が必要な場合',
        'If you need the sum of every row select yes' => '全ての行の合計が必要な場合',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '正規表現を使う場合、()内に[****]として値を記入できます。',
        'If you use a graph as output format you have to select at least one graph size.' => '出力形式がグラフの場合、少なくともひとつのグラフのサイズを選択してください。',
        'If you want to install OTRS on other database systems, please refer to the file README.database.' => 'OTRSを違うデータベースシステムにインストールしたい場合は、README.databaseファイルを参照してください。',
        'Image' => '画像',
        'Important' => '重要',
        'Imported' => 'インポート済',
        'Imported by' => 'インポート済: ',
        'In order to experience OTRS, you\'ll need to enable Javascript in your browser.' => 'OTRSを体験するには、お使いのブラウザのJavascriptを有効にしてください。',
        'In this form you can select the basic specifications.' => 'このフォームで基本的な仕様を選択できます。',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'この方法で、直接Kernel/Config.pmにキーリング設定を編集できます。',
        'Inbound Mail Password' => '受信メールパスワード',
        'Inbound Mail Type' => '受信メール種別',
        'Inbound Mail User' => '受信メールユーザー',
        'Inbound Mail host' => '受信メールホスト',
        'Information about the Stat' => '状態の情報',
        'Insert of the common specifications' => '共通仕様の挿入',
        'Instance' => 'インスタンス',
        'Is Job Valid' => '有効なジョブ',
        'Is Job Valid?' => '有効なジョブ？',
        'It\'s useful for ASP solutions.' => 'これはASPソリューションが便利です。',
        'It\'s useful for a lot of users and groups.' => 'これにより多くのユーザーとグループに便利です。',
        'Job-List' => 'ジョブリスト',
        'Keyword' => 'キーワード',
        'Keywords' => 'キーワード',
        'Kill session' => 'セッション切断',
        'Last update' => '最終更新',
        'Lastname{CustomerUser}' => 'Last name',
        'Link Table' => '連結一覧表',
        'Link to Parent' => '親への連結',
        'LinkType' => '連結種別',
        'Linked as' => '連結されている: ',
        'Load' => '読み込み',
        'Load Settings' => '設定読み込み',
        'Logfile' => 'ログファイル',
        'Logfile just needed for File-LogModule!' => 'ログファイルはFile-LogModuleが必要です！',
        'Logfile too large, you need to reset it!' => 'ログファイルが大きすぎます。初期化してください。',
        'Login failed! Your username or password was entered incorrectly.' => 'ログイン失敗！ 入力されたユーザー名またはパスワードが違います。',
        'Lookup' => '',
        'Mail Management' => 'メール管理',
        'Mailbox' => 'メールボックス',
        'Match' => '一致',
        'Message for new Owner' => 'メッセージの新規所有者',
        'Message sent to' => 'メッセージを送信: ',
        'Misc' => 'その他',
        'Mobile{CustomerUser}' => 'Cellphone',
        'Modified' => '変更',
        'Modules' => 'モジュール',
        'Move notification' => '移転通知',
        'Multiple selection of the output format.' => '出力書式の複数選択',
        'My Queue' => '担当のキュー',
        'MyTickets' => '担当のチケット',
        'Name is required!' => '名前が必要です！',
        'Need a valid email address or don\'t use a local address!' => '有効なメールアドレスが必要です。ローカルアドレスは使わないでください。',
        'Need a valid mail address or don\'t use a local email address.' => '有効なメールアドレスが必要です。ローカルアドレスは使わないでください。',
        'New Agent' => '新規担当者',
        'New Customer' => '新規顧客',
        'New Group' => '新規グループ',
        'New Group Ro' => '新規ROグループ',
        'New Password' => '新規パスワード',
        'New Priority' => '新規優先度',
        'New SLA' => '新規SLA',
        'New Service' => '新規サービス',
        'New State' => '新規状態',
        'New Ticket Lock' => '新規チケットロック',
        'New Title' => '新規タイトル',
        'New Type' => '新規種別',
        'New account created. Sent Login-Account to %s.' => '新規アカウントを作成しました。ログインアカウントを %s に送信しました。',
        'New messages' => '新着メッセージ',
        'New password again' => '新規確認パスワード',
        'Next Week' => '次週',
        'No * possible!' => '"*" は使えません',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'このオンラインリポジトリ内に要求されたフレームワークのパッケージはありませんでした。しかし他のフレームワークにパッケージがあります。',
        'No Packages or no new Packages in selected Online Repository!' => 'パッケージがないか、新パッケージは選択されたオンラインリポジトリにありません。',
        'No Permission' => '権限がありません。',
        'No change time settings.' => '変更時間設定がありません。',
        'No matches found' => '一致しません。',
        'No time settings.' => '時間設定がありません。',
        'Node-Address' => 'ノードアドレス',
        'Node-Name' => 'ノード名',
        'Note' => '注釈',
        'Note Text' => '注釈文',
        'Notification (Customer)' => '通知 (顧客)',
        'Notifications' => '通知',
        'OTRS DB Password' => 'OTRS DBパスワード',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRSはチケットが移転されたことを顧客にメールで通知します。',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRSはチケット所有者が変更されたことを顧客にメールで通知します。',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRSはチケットの状態が変更されたことを顧客にメールで通知します。',
        'Object already linked as %s.' => 'オブジェクトは既に %s と連結されています。',
        'Of couse this feature will take some system performance it self!' => 'この機能はシステムのパフォーマンスに多少影響があります。',
        'One or more errors occured!' => '一つ以上のエラーが発生しました！',
        'Only for ArticleCreate Event.' => '記事作成イベントのみ',
        'Open Tickets' => '対応中チケット',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '現在の顧客ユーザーデータオプション (例 &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => '現在の顧客ユーザーデータオプション (例 <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => '現在の顧客ユーザーデータオプション (例 <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'この操作を要求した現在ユーザーオプション (例 &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'この操作を要求した現在ユーザーオプション (例 <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'この操作を要求した現在ユーザーオプション (例 <OTRS_CURRENT_UserFirstname).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'チケットデータオプション (例 &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'チケットデータオプション (例 <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'チケットデータオプション (例 <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'チケットデータオプション (例 <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => '順序',
        'Other Options' => '他のオプション',
        'Out Of Office' => '勤務時間外',
        'Outbound Mail Type' => '送信メール種別',
        'POP3 Account Management' => 'POP3アカウント管理',
        'Package' => 'パッケージ',
        'Param 1' => 'Param 1',
        'Param 2' => 'Param 2',
        'Param 3' => 'Param 3',
        'Param 4' => 'Param 4',
        'Param 5' => 'Param 5',
        'Param 6' => 'Param 6',
        'Parent-Object' => '親の対象',
        'Password for Inbound Mail' => '受信メールのパスワード',
        'Password for SMTP Auth' => 'SMTP Authのパスワード',
        'Password is already in use! Please use an other password!' => 'パスワードは既に使用されています！ 他のパスワードにしてください！',
        'Password is already used! Please use an other password!' => 'パスワードは既に使用されています！ 他のパスワードにしてください。',
        'Passwords doesn\'t match! Please try it again!' => 'パスワードが一致しません！ 再入力してください！',
        'Pending Times' => '保留時間',
        'Pending messages' => '保留メッセージ',
        'Pending type' => '保留種別',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '権限設定。設定済みの統計情報が別の担当者に見えるように1つ以上のグループを選択できます。',
        'Permissions to change the ticket owner in this group/queue.' => 'チケット所有者を変更する権限をグループ／キューに付与する。',
        'PhoneView' => '電話一覧',
        'Phone{CustomerUser}' => 'Phone',
        'Please contact your admin' => '管理者に連絡してください。',
        'Prio' => 'Prio',
        'Process-Path' => 'プロセスパス',
        'Product' => '製品',
        'Queue <-> Auto Responses Management' => 'キュー <-> 自動応答管理',
        'Queue Management' => 'キュー管理',
        'Queue is required.' => 'キューが必要です。',
        'QueueView' => 'キュー一覧',
        'Queues <-> Auto Responses' => 'キュー <-> 自動応答',
        'Realname' => '本名',
        'Rebuild' => '再構成',
        'Recipients' => '受信者',
        'Refresh' => '自動更新',
        'Reminder' => '応答期限',
        'Reminder messages' => '応答期限メッセージ',
        'Remove from list of subscribed tickets' => '購読チケットをリストから削除',
        'Reporter' => '報告者',
        'Required Field' => '必須領域',
        'Required!' => '必須です！',
        'Response Management' => '応答管理',
        'Responses <-> Attachments Management' => '応答 <-> 添付ファイル管理',
        'Responses <-> Queue Management' => '応答 <-> キュー管理',
        'Result Form' => '結果 from:',
        'Return to the compose screen' => '作成画面へ戻る',
        'Role' => '役割',
        'Roles <-> Agents' => '役割 <-> 担当者',
        'Roles <-> Groups Management' => '役割 <-> グループ管理',
        'Roles <-> Users' => '役割 <-> ユーザー',
        'Roles <-> Users Management' => '役割 <-> ユーザー管理',
        'SMTP Auth Password' => 'SMTP Auth パスワード',
        'SMTP Auth User' => 'SMTP Authユーザー',
        'SMTP Authentication' => 'SMTP認証',
        'Save Job as?' => 'ジョブを保存しますか？',
        'Save Search-Profile as Template?' => 'テンプレートを検索プロファイルに保存しますか？',
        'Schedule' => 'スケジュール',
        'Search Result' => '検索結果',
        'Search for' => '検索: ',
        'Secure Mode need to be enabled!' => '保護モードを有効にする必要があります！',
        'Select Box' => 'ボックス選択',
        'Select Box Result' => 'ボックス結果の選択？',
        'Select Source (for add)' => '先 (追加用)の選択',
        'Select inbound mail type' => '受信メール種別選択',
        'Select outbound mail type' => '送信メール種別選択',
        'Select the customeruser:service relations.' => '顧客ユーザー:サービス関連性の選択',
        'Select the element, which will be used at the X-axis' => 'X軸で使用される要素の選択',
        'Select the restrictions to characterise the stat' => '統計の特徴の制限を選択',
        'Select the role:user relations.' => '役割:ユーザーの関連性の選択',
        'Select the user:group permissions.' => 'ユーザー:グループ権限を選択',
        'Select your QueueView refresh time.' => 'キュー一覧の自動更新時間選択',
        'Select your default spelling dictionary.' => '既定のスペルチェック辞書',
        'Select your frontend Charset.' => 'フロントエンドの文字コード選択',
        'Select your frontend QueueView.' => 'フロントエンドのキュー一覧選択',
        'Select your frontend language.' => 'フロントエンドの言語選択',
        'Select your out of office time.' => '勤務時間外の選択',
        'Select your screen after creating a new ticket.' => '新規チケット作成後の画面の選択',
        'Selection needed' => '選択してください',
        'Send Notification' => '通知の送信',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'チケット所有者が自分で、かつ顧客が追跡した場合、自分に通知します。',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'チケット所有者と同様に監視チケットの通知を自分に通知します。',
        'Sent new password to: ' => '新規パスワードを送信: ',
        'Sent new password to: %s' => '新規パスワードを送信: %s',
        'Sent password token to: %s' => 'パスワードトークンを送信: %s',
        'Service-Name' => 'サービス名',
        'Sessions' => 'セッション',
        'Set customer user and customer id of a ticket' => '顧客ユーザーとチケットの顧客IDを設定',
        'Show' => '閲覧',
        'Site' => 'サイト',
        'Solution' => '解決',
        'Some result formats are disabled because at least one needed package is not installed. Please contact your administrator.' => '少なくとも一つの必要パッケージがインストールされていないため、一部の結果の書式が無効になっています。管理者に連絡してください。',
        'Sort by' => '順序',
        'Source' => '出典',
        'Spell Check' => 'スペルチェック',
        'Split' => '分割',
        'State Type' => '状態の種別',
        'Static-File' => '静的ファイル',
        'Stats-Area' => '統計領域',
        'Step %s of %s' => '手順 %s / %s',
        'Street{CustomerUser}' => 'Street',
        'Sub-Queue of' => 'このサブキュー',
        'Sub-Service of' => 'このサブサービス',
        'Subscribe' => '購読',
        'System State Management' => 'システムの状態管理',
        'System Status' => 'システムステータス',
        'Systemaddress' => 'システムアドレス',
        'Text is required!' => '本文が入力されていません！',
        'The customer id is required!' => '顧客IDが入力されていません！',
        'The customer is required!' => '顧客が入力されていません！',
        'The customer is required.' => '顧客が入力されていません。',
        'The field is required.' => '領域が入力されていません。',
        'The identify of the system. Each ticket number and each http session id starts with this number.' => 'システムを識別します。それぞれのチケット番号とHTTPセッションはこの番号で始まるIDです。',
        'The message being composed has been closed.  Exiting.' => '作成済みメッセージは完了しており、終了しています。',
        'The subject is required!' => '表題が入力されていません！',
        'The subject is required.' => '表題が入力されていません。',
        'The text is required!' => '本文が入力されていません！',
        'The text is required.' => '本文が入力されていません。',
        'These values are read-only.' => 'これらの値は読み取り専用です。',
        'These values are required.' => 'これらの値が入力されていません。',
        'This account exists.' => 'このアカウントは既に存在します。',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '設定できていないか、統計情報が欲しい場合に便利です。',
        'This window must be called from compose window' => 'このウィンドウは作成ウィンドウから呼び出される必要があります。',
        'Ticket Escalation View' => 'チケットエスカレーション一覧',
        'Ticket Lock' => 'チケットロック',
        'Ticket Number Generator' => 'チケット番号の自動生成',
        'Ticket Search' => 'チケット検索',
        'Ticket Status View' => 'チケット状態一覧',
        'Ticket Type is required!' => 'チケット種別が入力されていません！',
        'Ticket changed' => 'チケットを変更しました',
        'Ticket changed between' => 'チケットの変更がこの期間の間',
        'Ticket escalation!' => 'チケットのエスカレーション！',
        'Ticket locked!' => 'チケットをロックしました！',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'チケット所有者オプション (例 &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'チケット所有者オプション (例 <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'チケット所有者オプション (例 <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'チケット応答者オプション (例 <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => '選択済みチケットの一括処理',
        'Ticket type is required.' => 'チケット種別が入力されていません。',
        'Ticket unlock!' => 'チケットのロックを解除しました。',
        'Ticket#' => 'チケット番号',
        'Ticket-Area' => 'チケット領域',
        'TicketFreeText' => 'チケット自由入力',
        'TicketZoom' => 'チケット拡大',
        'Tickets available' => 'チケット利用可能',
        'Tickets shown' => 'チケットを見る',
        'Tickets which need to be answered!' => 'チケットは回答する必要があります！',
        'Time units is a required field!' => '時間の単位は必須入力です！',
        'Time units is a required field.' => '時間の単位は必須入力です！',
        'Time units is required field.' => '時間の単位は必須入力です！',
        'Timeover' => '時間切れ',
        'Times' => '時間？',
        'Title is required.' => 'タイトルが必要です',
        'Title of the stat.' => '統計のタイトル',
        'Title{CustomerUser}' => 'Title',
        'Title{user}' => 'user',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => '',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Today' => '今日',
        'Tomorrow' => '明日',
        'Top of Page' => 'ページトップ',
        'Total hits' => '総ヒット数',
        'U' => 'U',
        'Unable to parse Online Repository index document!' => 'オンラインリポジトリのインデックスが解析できません！',
        'Unlock Tickets' => 'チケットのロック解除',
        'Unsubscribe' => '購読停止',
        'Use utf-8 it your database supports it!' => 'データベースがutf-8の使用をサポートしています！',
        'Useable options' => '使用可能オプション',
        'Used default language.' => '使用している既定の言語',
        'Used log backend.' => '使用しているログバックエンド',
        'User Management' => 'ユーザー管理',
        'User for Inbound Mail' => '受信メールのユーザー',
        'User will be needed to handle tickets.' => 'ユーザーはチケットを操作するために必要です。',
        'User-Name' => 'ユーザー名',
        'User-Number' => 'ユーザー番号',
        'Username for SMTP Auth' => 'SMTP認証用ユーザー',
        'Username{CustomerUser}' => 'Username',
        'Users' => 'ユーザー',
        'Users <-> Groups' => 'ユーザー <-> グループ',
        'Users <-> Groups Management' => 'ユーザー <-> グループ管理',
        'Verify New Password' => '新規確認パスワード',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '警告: このチケットをデータベースから削除しようとしています。このチケットは失われます！',
        'Watch notification' => '監視通知',
        'Web-Installer' => 'Webインストーラー',
        'Welcome to OTRS' => 'ようこそ OTRS へ',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '無効な統計では統計情報を生成できません。',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '必要に応じて入力領域を選択し、統計情報を設定できます。統計情報は管理者が設定した範囲内でどの統計の要素も編集できます。',
        'Workflow Groups' => 'ワークフローグループ',
        'X-axis' => 'X軸',
        'Yes, save it with name' => 'はい。名前を付けて保存します。',
        'You got new message!' => '新規メッセージがあります！',
        'You need a email address (e. g. customer@example.com) in To:!' => '宛先にメールアドレスを入力してください！ (例 kunde@example.com)',
        'You need a to: recipient!.' => '宛先に受信者を入力してください！',
        'You need min. one selected Ticket!' => '分を入力してください！',
        'You need to account time!' => '作業時間を入力してください！',
        'You need to activate %s first to use it!' => '使用するには %s を有効にしてください！',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => '削除オプションを使います。全ての削除されたチケットは消失します！',
        'Your Password' => 'パスワード',
        'Your email address is new' => '新しいメールアドレスです',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'チケット番号 "<OTRS_TICKET>" のメールは "<OTRS_BOUNCE_TO>" へバウンスされます。詳細についてはこのアドレスにお問い合わせください。',
        'Your own Ticket' => '自分のチケット',
        'Zip{CustomerUser}' => 'ZIP',
        'customer realname' => '顧客名',
        'delete' => '削除',
        'delete links' => '連結を削除',
        'down' => '下',
        'false' => '偽',
        'for agent firstname' => '担当者の名前',
        'for agent lastname' => '担当者の名字',
        'for agent login' => '担当者のログイン',
        'for agent user id' => '担当者のユーザーID',
        'go back' => '戻る',
        'kill all sessions' => '全セッション切断',
        'modified' => '変更日時',
        'new ticket' => '新規チケット',
        'next step' => '次の手順',
        'not rated' => '評価しない',
        'not verified' => '検証しない',
        'read' => '読む',
        'send' => '送信',
        'sort downward' => '降順に並べ替え',
        'sort upward' => '昇順に並べ替え',
        'tmp_lock' => '一時的ロック',
        'to get the first 20 character of the subject' => '表題の最初の20文字を取得',
        'to get the first 5 lines of the email' => 'メールの最初の5行を取得',
        'to get the from line of the email' => 'メールの差出人を取得',
        'to get the realname of the sender (if given)' => '送信者名を取得 (存在する場合)',
        'unknown' => '不明',
        'unread' => '未読',
        'up' => '上',
        'utf8' => 'utf8',
        'verified' => '検証済',
        'x' => 'x',
   };
   # $$STOP$$
   return;
}

1;
