# --
# Kernel/Language/cs.pm - provides Czech language translation
# Copyright (C) 2001-2011 OTRS AG, http://otrs.org/
# Copyright (C) 2003 Lukas Vicanek alias networ <lulka at centrum dot cz>
# Copyright (C) 2004 BENETA.cz, s.r.o. (Marta Macalkova, Vadim Buzek, Petr Ocasek) <info at beneta dot cz>
# Copyright (C) 2010 O2BS.com, s r.o. Jakub Hanus
# Copyright (C) 2010 Pavel <pavel.vilim at kodys.cz>
# --
# $Id: cs.pm,v 1.2.2.2 2011/05/16 20:29:45 mp Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::cs;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.2.2.2 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2011-03-21 17:28:31

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D/%M/%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %Y %T';
    $Self->{DateFormatShort}     = '%D/%M/%Y';
    $Self->{DateInputFormat}     = '%D/%M/%Y';
    $Self->{DateInputFormatLong} = '%D/%M/%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Ano',
        'No' => 'Ne',
        'yes' => 'ano',
        'no' => 'ne',
        'Off' => 'Vypnuto',
        'off' => 'vypnuto',
        'On' => 'Zapnuto',
        'on' => 'zapnuto',
        'top' => 'nahoru',
        'end' => 'konec',
        'Done' => 'Hotovo',
        'Cancel' => 'Storno',
        'Reset' => '',
        'last' => 'posledn',
        'before' => 'ped',
        'Today' => '',
        'Tomorrow' => 'Ztra',
        'Next Week' => 'Dal Tden',
        'day' => 'den',
        'days' => 'dn(dny)',
        'day(s)' => 'den(dn)',
        'd' => '',
        'hour' => 'hodina',
        'hours' => 'hodin',
        'hour(s)' => 'hodina(y)',
        'Hours' => '',
        'h' => '',
        'minute' => 'minuta',
        'minutes' => 'minut',
        'minute(s)' => 'minuta(y)',
        'Minutes' => '',
        'm' => '',
        'month' => 'msc',
        'months' => 'msc',
        'month(s)' => 'msc(e)',
        'week' => 'tden',
        'week(s)' => 'tden(tdny)',
        'year' => 'rok',
        'years' => 'rok',
        'year(s)' => 'rok(y)',
        'second(s)' => 'vteina(y)',
        'seconds' => 'vtein',
        'second' => 'vteina',
        's' => '',
        'wrote' => 'napsal',
        'Message' => 'Zprva',
        'Error' => 'Chyba',
        'Bug Report' => 'Upozornn na chybu',
        'Attention' => 'Upozornn',
        'Warning' => 'Varovn',
        'Module' => 'Modul',
        'Modulefile' => 'Modulov soubor',
        'Subfunction' => 'Podfunkce',
        'Line' => 'dek',
        'Setting' => 'Nastaven',
        'Settings' => 'Nastaven',
        'Example' => 'Pklad',
        'Examples' => 'Pklady',
        'valid' => 'platn',
        'invalid' => 'neplatn',
        '* invalid' => '* neplatn',
        'invalid-temporarily' => 'neplatn-doasn',
        ' 2 minutes' => ' 2 minuty',
        ' 5 minutes' => ' 5 minut',
        ' 7 minutes' => ' 7 minut',
        '10 minutes' => '10 minut',
        '15 minutes' => '15 minut',
        'Mr.' => 'pan',
        'Mrs.' => 'pan',
        'Next' => 'Dal',
        'Back' => 'Zpt',
        'Next...' => 'Dal...',
        '...Back' => '...Zpt',
        '-none-' => '-dn-',
        'none' => 'dn',
        'none!' => 'dn!',
        'none - answered' => 'dn - odpovzeno',
        'please do not edit!' => 'prosme neupravovat!',
        'Need Action' => '',
        'AddLink' => 'Pidat Provn',
        'Link' => 'Sprovat',
        'Unlink' => 'Zruit Provn',
        'Linked' => 'Sprovno',
        'Link (Normal)' => 'Provat (Normln)',
        'Link (Parent)' => 'Provat (Nadazen)',
        'Link (Child)' => 'Provat (Podzen)',
        'Normal' => 'Normln',
        'Parent' => 'Nadazen',
        'Child' => 'Podzen',
        'Hit' => 'Pstup',
        'Hits' => 'Pstup',
        'Text' => 'Text',
        'Standard' => 'Standard',
        'Lite' => 'Omezen',
        'User' => 'Uivatel',
        'Username' => 'Uivatelsk jmno',
        'Language' => 'Jazyk',
        'Languages' => 'Jazyky',
        'Password' => 'Heslo',
        'Preferences' => 'Pedvolby',
        'Salutation' => 'Osloven',
        'Salutations' => 'Pozdrav',
        'Signature' => 'Podpis',
        'Signatures' => 'Podpisy',
        'Customer' => 'Klient',
        'CustomerID' => 'ID klienta',
        'CustomerIDs' => 'ID klienta',
        'customer' => 'klient',
        'agent' => 'eitel',
        'system' => 'systm',
        'Customer Info' => 'Informace o klientovi',
        'Customer Information' => 'Informace o klientovi',
        'Customer Company' => 'Spolenost klienta',
        'Customer Companies' => '',
        'Company' => 'Spolenost',
        'go!' => 'jdi!',
        'go' => 'jdi',
        'All' => 'Ve',
        'all' => 've',
        'Sorry' => 'Omluva',
        'update!' => 'aktualizovat!',
        'update' => 'aktualizovat',
        'Update' => 'Aktualizovat',
        'Updated!' => 'Aktualizovno',
        'submit!' => 'Odeslat!',
        'submit' => 'odeslat',
        'Submit' => 'Odeslat',
        'change!' => 'zmnit!',
        'Change' => 'Zmnit',
        'change' => 'zmnit',
        'click here' => 'kliknte zde',
        'Comment' => 'Koment',
        'Valid' => 'Platnost',
        'Invalid Option!' => 'Neplatn volba',
        'Invalid time!' => 'Neplatn as',
        'Invalid date!' => 'Neplatn datum',
        'Name' => 'Jmno',
        'Group' => 'Skupina',
        'Description' => 'Popis',
        'description' => 'popis',
        'Theme' => 'Motiv',
        'Created' => 'Vytvoeno',
        'Created by' => 'Vytvoeno km',
        'Changed' => 'Zmnno',
        'Changed by' => 'Zmnno km',
        'Search' => 'Vyhledat',
        'and' => 'a',
        'between' => 'mezi',
        'Fulltext Search' => 'Fulltextov vyhledvn',
        'Data' => '',
        'Options' => 'Monosti',
        'Title' => 'Nadpis',
        'Item' => 'Poloka',
        'Delete' => 'Vymazat',
        'Edit' => 'Editovat',
        'View' => 'Nhled',
        'Number' => 'slo',
        'System' => 'Systm',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakty',
        'Export' => 'Exportovat',
        'Up' => 'Nahoru',
        'Down' => 'Dolu',
        'Add' => 'Pidat',
        'Added!' => 'Pidno!',
        'Category' => 'Kategorie',
        'Viewer' => 'Prohle',
        'Expand' => 'Rozbalit',
        'Small' => 'Mal',
        'Medium' => 'Stedn',
        'Large' => 'Velk',
        'Date picker' => '',
        'New message' => 'Nov zprva',
        'New message!' => 'Nov zprva!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Prosm, odpovzte na tento (tyto) tiket(y) pro nvrat do normlnho nhledu fronty!',
        'You have %s new message(s)!' => 'Mte %s novou zprvu (novch zprv)!',
        'You have %s reminder ticket(s)!' => 'Mte %s upomnkov(ch) tiket()',
        'The recommended charset for your language is %s!' => 'Doporuen znakov sada pro V jazyk je %s!',
        'Change your password.' => 'Zmte si heslo.',
        'Please activate %s first!' => '',
        'No suggestions' => 'dn nvrhy',
        'Word' => 'Slovo',
        'Ignore' => 'Ignorovat',
        'replace with' => 'nahradit m',
        'There is no account with that login name.' => 'dn et s tmto pihlaovacm jmnem neexistuje.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => 'Odhlsit',
        'Logout successful. Thank you for using OTRS!' => 'Odhlen bylo spsn. Dkujeme Vm za pouvn OTRS!',
        'Invalid SessionID!' => 'Neplatn ID relace!',
        'Feature not active!' => 'Funkce je neaktivn!',
        'Agent updated!' => '',
        'Create Database' => 'Vytvoit Databazi',
        'System Settings' => 'Nastaven systmu',
        'Mail Configuration' => '',
        'Finished' => 'Dokoneno',
        'Login is needed!' => 'Vyadovno pihlen',
        'Password is needed!' => 'Vyadovno heslo',
        'License' => 'Licence',
        'Take this Customer' => 'Vybrat tohoto Zkaznka',
        'Take this User' => 'Vybrat tohoto uivatele',
        'possible' => 'mon',
        'reject' => 'zamtnout',
        'reverse' => 'reverzn',
        'Facility' => 'Vybaven',
        'Time Zone' => '',
        'Pending till' => 'ekn na vyzen do',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Z bezpenostnch dvod nepracujte se superuivatelskm tem - vytvote si novho uivatele!',
        'Dispatching by email To: field.' => 'Piadit podle emailu - pole KOMU:.',
        'Dispatching by selected Queue.' => 'Piadit do vybran fronty.',
        'No entry found!' => 'Nebyl nalezen dn zznam!',
        'Session has timed out. Please log in again.' => 'Relace vyprela. Prosm, pihlate se znovu.',
        'No Permission!' => 'Nemte oprvnn',
        'To: (%s) replaced with database email!' => 'Komu: (%s) nahrazeno emailem z databze!',
        'Cc: (%s) added database email!' => 'Kopie: (%s) doplnno emailem z databze',
        '(Click here to add)' => '(Pro pidn kliknte zde)',
        'Preview' => 'Zobrazit',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Rozbalen balku nespn! Reinstalujte balek znovu!',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
        'Customer %s added' => '',
        'Role added!' => 'Role pidna!',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Kontrakt',
        'Online Customer: %s' => 'Online Zkaznci',
        'Online Agent: %s' => 'Online eitel',
        'Calendar' => 'Kalend',
        'File' => 'Soubor',
        'Filename' => 'Nzev souboru',
        'Type' => 'Typ Tiketu',
        'Size' => 'Velikost',
        'Upload' => '',
        'Directory' => 'Adres',
        'Signed' => 'Podepsno',
        'Sign' => 'Podepsat',
        'Crypted' => 'ifrovno',
        'Crypt' => 'ifrovat',
        'PGP' => 'PGP',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => 'S/MIME',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => 'Kancel',
        'Phone' => 'Telefon',
        'Fax' => 'Fax',
        'Mobile' => 'Mobiln telefon',
        'Zip' => 'PS',
        'City' => 'Msto',
        'Street' => 'Ulice',
        'Country' => 'Zem',
        'Location' => 'Lokalita',
        'installed' => 'instalovno',
        'uninstalled' => 'odinstalovno',
        'Security Note: You should activate %s because application is already running!' => 'Bezpenostn poznmka: Aktivujte %s protoe aplikace stle b!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'vytitno na',
        'Loading...' => '',
        'Dear Mr. %s,' => 'Ven Pane %s,',
        'Dear Mrs. %s,' => 'Ven Pan %s,',
        'Dear %s,' => 'Ven() %s,',
        'Hello %s,' => 'Dobr den %s,',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Prosm kliknte na "Zpt" a opakujte pokus',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Aktuln udlosti',
        'Event' => 'Udlost',
        'Events' => 'Udlosti',
        'Invalid Token!' => 'Neplatn Token',
        'more' => 'dal',
        'For more info see:' => 'Pro dal informace viz:',
        'Package verification failed!' => 'Oven balku selhalo',
        'Collapse' => 'Zhroucen',
        'Shown' => 'Zobrazeno',
        'News' => 'Novinky',
        'Product News' => 'Novinky o Produktu',
        'OTRS News' => 'Novinky OTRS',
        '7 Day Stats' => 'Statistiky za 7 dn',
        'Bold' => 'Tun',
        'Italic' => 'Kurzva',
        'Underline' => 'Podtren',
        'Font Color' => 'Barva Psma',
        'Background Color' => 'Barva Pozad',
        'Remove Formatting' => 'Odstranit Formtovn',
        'Show/Hide Hidden Elements' => 'Zobrazit/Skrt schovan prvky',
        'Align Left' => 'Zarovnn Vlevo',
        'Align Center' => 'Zarovnn na Sted',
        'Align Right' => 'Zarovnn Vpravo',
        'Justify' => 'Formtovat',
        'Header' => 'Hlavika',
        'Indent' => 'Odsazen',
        'Outdent' => 'Zruit Odsazen',
        'Create an Unordered List' => 'Vytvoit nesetdn seznam',
        'Create an Ordered List' => 'Vytvoit setdn seznam',
        'HTML Link' => 'HTML odkaz',
        'Insert Image' => 'Vloit Obrzek',
        'CTRL' => 'Ctrl',
        'SHIFT' => 'Shift',
        'Undo' => 'Krok Zpt',
        'Redo' => 'Znovuobnovit',

        # Template: AAAMonth
        'Jan' => 'Led',
        'Feb' => 'no',
        'Mar' => 'Be',
        'Apr' => 'Dub',
        'May' => 'Kv',
        'Jun' => 'er',
        'Jul' => 'vc',
        'Aug' => 'Srp',
        'Sep' => 'Z',
        'Oct' => 'j',
        'Nov' => 'Lis',
        'Dec' => 'Pro',
        'January' => 'Leden',
        'February' => 'nor',
        'March' => 'Bezen',
        'April' => 'Duben',
        'May_long' => 'Kvten',
        'June' => 'erven',
        'July' => 'ervenec',
        'August' => 'Srpen',
        'September' => 'Z',
        'October' => 'jen',
        'November' => 'Listopad',
        'December' => 'Prosinec',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Nastaven spn aktualizovno!',
        'User Profile' => 'Uivatelsk profil',
        'Email Settings' => 'Nastaven emailu',
        'Other Settings' => 'Ostatn nastaven',
        'Change Password' => 'Zmna hesla',
        'Current Password' => 'Stvajc heslo',
        'New password' => 'Nov Heslo',
        'Verify password' => '',
        'Spelling Dictionary' => 'Slovnk pro kontrolu pravopisu',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'Max. zobrazench tiket v pehledu na strnku',
        'The current password is not correct. Please try again!' => 'Souasn heslo nesouhlas. Zkuste to prosm znovu!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Nelze zaktualizovat heslo, Vae nov hesla si neodpovdaj. Zkuste to prosm znovu!',
        'Can\'t update password, it contains invalid characters!' => 'Nelze zaktualizovat heslo, protoe obsahuje neplatn znaky. Zkuste to prosm znovu!',
        'Can\'t update password, it must be at least %s characters long!' => 'Nelze zaktualizovat heslo, protoe neobsahuje minimln %s znak. Zkuste to prosm znovu!',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Nelze zaktualizovat heslo, protoe neobsahuje alespo 2 mal a 2 velk psmena!',
        'Can\'t update password, it must contain at least 1 digit!' => 'Nelze zaktualizovat heslo, protoe neobsahuje alespo 1 slici!',
        'Can\'t update password, it must contain at least 2 characters!' => 'Nelze zaktualizovat heslo, protoe neobsahuje alespo 2 znaky!',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Nelze zaktualizovat heslo, protoe toto heslo bylo ji jednou pouito. Zvolte prosm nov!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'Statistika',
        'Sum' => '',
        'Please fill out the required fields!' => 'Prosm vyplte povinn pole!',
        'Please select a file!' => 'Prosm vyberte soubor!',
        'Please select an object!' => 'Prosm zvolte objekt!',
        'Please select a graph size!' => 'Prosm zvolte velikost grafu!',
        'Please select one element for the X-axis!' => 'Prosm vyberte jeden prvek pro osu X!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => '',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Je-li pouito zakrtvac polko, je nutno zvolit atribut zvolenho pole!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => 'Zvolen Konen datum je ped Potenm datem!',
        'You have to select one or more attributes from the select field!' => 'Mus bt zvolen jeden nebo vce atribut z vybranho pole!',
        'The selected Date isn\'t valid!' => '',
        'Please select only one or two elements via the checkbox!' => 'Prosm vyberte jeden nebo dva prvky pomoc zakrtvacho polka!',
        'If you use a time scale element you can only select one element!' => 'Pi pouit asovho mtka je mon vybrat pouze jeden prvek!',
        'You have an error in your time selection!' => 'Chyba ve zvolenm ase!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Pli mal asov interval pro report, prosm zvolte vt rozsah!',
        'The selected start time is before the allowed start time!' => 'Zvolen potek je ped povolenm potkem!',
        'The selected end time is after the allowed end time!' => 'Zvolen konec je po povolenm konci!',
        'The selected time period is larger than the allowed time period!' => 'Zvolen perioda je del, ne povolen!',
        'Common Specification' => 'Veobecn nastaven',
        'X-axis' => 'Osa X',
        'Value Series' => 'ada Hodnot',
        'Restrictions' => 'Omezen',
        'graph-lines' => 'graf-ry',
        'graph-bars' => 'graf-sloupec',
        'graph-hbars' => 'graf-hsloupec',
        'graph-points' => 'graf-body',
        'graph-lines-points' => 'graf-ry-body',
        'graph-area' => 'oblast grafu',
        'graph-pie' => 'vseov graf',
        'extended' => 'podrobn',
        'Agent/Owner' => 'eitel/Vlastnk',
        'Created by Agent/Owner' => 'Vytvoeno eitelem/Vlastnkem',
        'Created Priority' => 'Nastaven Priorita',
        'Created State' => 'Nastaven Stav',
        'Create Time' => 'Nastaven as',
        'CustomerUserLogin' => 'Pihlen Zkaznk/Uivatel',
        'Close Time' => 'as uzaven',
        'TicketAccumulation' => 'Sumarizace Tiketu',
        'Attributes to be printed' => 'Atributy k vytitn',
        'Sort sequence' => 'azen poad',
        'Order by' => 'adit dle',
        'Limit' => '',
        'Ticketlist' => 'seznam Tiket',
        'ascending' => 'vzestupn',
        'descending' => 'sestupn',
        'First Lock' => 'Prvn Zmek',
        'Evaluation by' => 'Vyhodnoceno dle',
        'Total Time' => 'Celkov as',
        'Ticket Average' => 'Prmr tiketu',
        'Ticket Min Time' => 'Min. as tiketu',
        'Ticket Max Time' => 'Max. as tiketu',
        'Number of Tickets' => 'Poet tiket',
        'Article Average' => 'prmr poloek',
        'Article Min Time' => 'Min. as poloky',
        'Article Max Time' => 'Max. as poloky',
        'Number of Articles' => 'Poet poloek',
        'Accounted time by Agent' => 'eitelem potan as',
        'Ticket/Article Accounted Time' => '',
        'TicketAccountedTime' => '',
        'Ticket Create Time' => 'as vytvoen tiketu',
        'Ticket Close Time' => 'as uzaven tiketu',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'Zamknout',
        'Unlock' => 'Odemknout',
        'History' => 'Historie',
        'Zoom' => 'Zobrazit',
        'Age' => 'St',
        'Bounce' => 'Odeslat zpt',
        'Forward' => 'Pedat',
        'From' => 'Od',
        'To' => 'Komu',
        'Cc' => 'Kopie',
        'Bcc' => 'Slep kopie',
        'Subject' => 'Pedmt',
        'Move' => 'Pesunout',
        'Queue' => 'Fronta',
        'Queues' => 'ady',
        'Priority' => 'Priorita',
        'Priorities' => '',
        'Priority Update' => 'Oprava Priority',
        'SLA' => '',
        'Service Level Agreement' => '',
        'Service Level Agreements' => '',
        'Service' => 'Sluba',
        'Services' => '',
        'State' => 'Stav',
        'States' => '',
        'Status' => 'Stav',
        'Statuses' => '',
        'Ticket Type' => '',
        'Ticket Types' => '',
        'Compose' => 'Sestavit',
        'Pending' => 'ek na vyzen',
        'Owner' => 'Vlastnk',
        'Owner Update' => 'Oprava Vlastnka',
        'Responsible' => 'Odpovdn',
        'Responsible Update' => 'Oprava Odpovdnosti',
        'Sender' => 'Odeslatel',
        'Article' => 'Poloka',
        'Ticket' => 'Tiket',
        'Createtime' => 'Doba vytvoen',
        'plain' => 'jednoduch',
        'Email' => '',
        'email' => '',
        'Close' => 'Zavt',
        'Action' => 'Akce',
        'Attachment' => 'Ploha',
        'Attachments' => 'Plohy',
        'This message was written in a character set other than your own.' => 'Tato zprva byla napsna v jin znakov sad ne Vae.',
        'If it is not displayed correctly,' => 'Pokud nen zobrazeno sprvn,',
        'This is a' => 'Toto je',
        'to open it in a new window.' => 'pro oteven v novm okn.',
        'This is a HTML email. Click here to show it.' => 'Toto je HTML email. Pro zobrazen kliknte zde.',
        'Free Fields' => 'Przdn pole',
        'Merge' => 'Slouit',
        'merged' => 'Sloueno',
        'closed successful' => 'uzaveno - vyeeno',
        'closed unsuccessful' => 'uzaveno - nevyeeno',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'Vechny tikety',
        'Tickets available' => 'Tiket k dispozici',
        'Escalation' => 'Eskalace',
        'last-search' => '',
        'QueueView' => 'Nhled fronty',
        'Ticket Escalation View' => '',
        'new' => 'nov',
        'open' => 'otevt',
        'Open' => 'Otevt',
        'closed' => 'uzaveno',
        'Closed' => 'Uzaveno',
        'removed' => 'odstranno',
        'pending reminder' => 'upomnka pi ekn na vyzen',
        'pending auto' => 'auto ekn na vyzen',
        'pending auto close+' => 'ek na vyzen - automaticky zavt+',
        'pending auto close-' => 'ek na vyzen - automaticky zavt-',
        'email-external' => 'extern email',
        'email-internal' => 'intern email',
        'note-external' => 'poznmka-extern',
        'note-internal' => 'poznmka-intern',
        'note-report' => 'poznmka-report',
        'phone' => 'telefon',
        'sms' => '',
        'webrequest' => 'poadavek pes web',
        'lock' => 'zameno',
        'unlock' => 'nezamen',
        'very low' => 'velmi nzk',
        'low' => 'nzk',
        'normal' => 'normln',
        'high' => 'vysok',
        'very high' => 'velmi vysok',
        '1 very low' => '1 velmi nzk',
        '2 low' => '2 nzk',
        '3 normal' => '3 normln',
        '4 high' => '4 vysok',
        '5 very high' => '5 velmi vysok',
        'Ticket "%s" created!' => 'Tiket "%s" vytvoen!',
        'Ticket Number' => 'slo tiketu',
        'Ticket Object' => 'Tiket Objekt',
        'No such Ticket Number "%s"! Can\'t link it!' => '',
        'Don\'t show closed Tickets' => 'Nezobrazovat uzaven tikety',
        'Show closed Tickets' => 'Zobrazit zaven tikety',
        'New Article' => 'Nov poloka',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'Email Tiket',
        'Create new Email Ticket' => 'Vytvoit nov Email Tiket',
        'Phone-Ticket' => 'Telefonn Tiket',
        'Search Tickets' => 'Vyhledvn Tiket',
        'Edit Customer Users' => 'Editace uivatel zkaznka',
        'Edit Customer Company' => 'Editace spolenosti zkaznka',
        'Bulk Action' => 'Hromadn akce',
        'Bulk Actions on Tickets' => 'Hromadn akce na tiketech',
        'Send Email and create a new Ticket' => 'Zaslat Email a vytvoit nov tiket',
        'Create new Email Ticket and send this out (Outbound)' => 'Vytvoit nov Email Tiket a odeslat jej (Odchoz)',
        'Create new Phone Ticket (Inbound)' => 'Vytvoit nov Telefonn Tiket (Pchoz)',
        'Overview of all open Tickets' => 'Pehled vech otevench tiket',
        'Locked Tickets' => 'Uzamen tikety',
        'My Locked Tickets' => '',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Zobrazen tikety',
        'Watched' => 'Zobrazen',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'Uzamknout pro prci',
        'Unlock to give it back to the queue!' => 'Odemknout zpt do Fronty',
        'Shows the ticket history!' => 'Uke historii tiketu!',
        'Print this ticket!' => 'Vytisknout tiket!',
        'Change the ticket priority!' => 'Zmna Priority tiketu',
        'Change the ticket free fields!' => 'Zmna volnch pol tiketu',
        'Link this ticket to an other objects!' => 'Sprovat Tiket s jinmi objekty!',
        'Change the ticket owner!' => 'Zmna vlastnka tiketu!',
        'Change the ticket customer!' => 'Zmna Zkaznka Tiketu',
        'Add a note to this ticket!' => 'Pidat poznmku do Tiketu',
        'Merge this ticket!' => 'Slouit Tiket',
        'Set this ticket to pending!' => 'Nastavit jako Nevyeen',
        'Close this ticket!' => 'Uzavt Tiket',
        'Look into a ticket!' => 'Nhled Tiketu',
        'Delete this ticket!' => 'Vmaz Tiketu',
        'Mark as Spam!' => 'Oznait jako SPAM',
        'My Queues' => 'Moje Fronty',
        'Shown Tickets' => 'Zobrazit Tikety',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'V email s slem Tiketu "<OTRS_TICKET>" je svzn s "<OTRS_MERGE_TO_TICKET>"',
        'Ticket %s: first response time is over (%s)!' => 'Tiket %s: Vyprel as Prvn Reakce (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Tiket %s: as Prvn Reakce vypr v %s!',
        'Ticket %s: update time is over (%s)!' => 'Tiket %s: Vyprel as Aktualizace (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Tiket %s: as Aktualizace vypr v %s!',
        'Ticket %s: solution time is over (%s)!' => 'Tiket %s: Vyprel as een (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Tiket %s: as een vypr v %s!',
        'There are more escalated tickets!' => 'Je zde vce Eskalovanch Tiket',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'New ticket notification' => 'Oznmen o Novm Tiketu',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Poli mi oznmen o novm Tiketu v mch Frontch.',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Oznmen o vypren asu uzamen tiketu',
        'Send me a notification if a ticket is unlocked by the system.' => 'Poli mi oznmen, pokud je tiket odemknut systmem.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Poli mi oznmen pokud je Tiket pesunut do mch Front.',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Selekce Front z Oblbench. Bude zaslno oznmen, je-li zapnuto.',
        'Custom Queue' => 'Vlastn fronta',
        'QueueView refresh time' => 'Doba obnoven nhledu fronty',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'Zobrazen po Novm Tiketu',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Uzaven Tikety',
        'Show closed tickets.' => 'Ukzat uzaven tikety.',
        'Max. shown Tickets a page in QueueView.' => 'Max. zobrazench tiket v nhledu fronty na strnku',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'nov Tiket',
        'Create new Ticket' => 'Vytvoit Nov Tiket',
        'Customer called' => 'Volal Zkaznk',
        'phone call' => 'Telefonn voln',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'Dosaena Upomnka',
        'Reminder Tickets' => 'Upozornn na Tikety',
        'Escalated Tickets' => 'Eskalovan Tikety',
        'New Tickets' => 'Nov Tikety',
        'Open Tickets / Need to be answered' => 'Oteven Tikety / Nutno Odpovdt',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Tiket pesunut do Fronty "%s" (%s) z Fronty "%s" (%s).',
        'History::TypeUpdate' => 'Typ Tiketu aktualizovn na %s (ID=%s).',
        'History::ServiceUpdate' => 'Sluba aktualizovna na %s (ID=%s).',
        'History::SLAUpdate' => 'SLA aktualizovno na %s (ID=%s).',
        'History::NewTicket' => 'Nov Tiket [%s] vytvoen (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Nsledovat pro [%s]. %s',
        'History::SendAutoReject' => 'Automatick odmtnut zaslno na "%s".',
        'History::SendAutoReply' => 'Automatick odpov zaslna na "%s".',
        'History::SendAutoFollowUp' => 'Automatick nsledovn zaslno na "%s".',
        'History::Forward' => 'Pedno dl "%s".',
        'History::Bounce' => 'Odraeno na "%s".',
        'History::SendAnswer' => 'Email odesln na "%s".',
        'History::SendAgentNotification' => '"%s"- upozornn odeslno na "%s".',
        'History::SendCustomerNotification' => 'Upozornn odeslno na "%s".',
        'History::EmailAgent' => 'Email odesln zkaznkovi.',
        'History::EmailCustomer' => 'Email pidn. %s',
        'History::PhoneCallAgent' => 'eitel kontaktoval Zkaznka.',
        'History::PhoneCallCustomer' => 'Zkaznk kontaktoval ns.',
        'History::AddNote' => 'Pidan poznmka (%s)',
        'History::Lock' => 'Zamknut Tiket.',
        'History::Unlock' => 'Odemknut Tiket.',
        'History::TimeAccounting' => '%s napotanch asovch jednotek. Souet vech je %s.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Aktualizovno: %s',
        'History::PriorityUpdate' => 'Priorita zmnna z "%s" (%s) na "%s" (%s).',
        'History::OwnerUpdate' => 'Nov vlastnk je "%s" (ID=%s).',
        'History::LoopProtection' => 'Peposln nepovoleno! Nebyla odeslna automatick odpov na "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Aktualizovno: %s',
        'History::StateUpdate' => 'Star: "%s" Nov: "%s"',
        'History::TicketFreeTextUpdate' => 'Aktualizovno: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Webov poadavek Zkaznka.',
        'History::TicketLinkAdd' => 'Sprovno s Tiketem "%s".',
        'History::TicketLinkDelete' => 'Provn s tiketem "%s" zrueno.',
        'History::Subscribe' => 'Pidna poznmka pro uivatele"%s".',
        'History::Unsubscribe' => 'Poznmka pro uivatele odebrna "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'Ne',
        'Mon' => 'Po',
        'Tue' => 't',
        'Wed' => 'St',
        'Thu' => 't',
        'Fri' => 'P',
        'Sat' => 'So',

        # Template: AdminAttachment
        'Attachment Management' => 'Sprva ploh',
        'Actions' => '',
        'Go to overview' => '',
        'Add attachment' => '',
        'List' => 'Poad',
        'No data found.' => '',
        'Download file' => '',
        'Delete this attachment' => '',
        'Add Attachment' => '',
        'Edit Attachment' => '',
        'This field is required.' => '',
        'or' => 'nebo',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Sprva automatickch odpovd',
        'Add auto response' => '',
        'Add Auto Response' => '',
        'Edit Auto Response' => '',
        'Response' => 'Odpov',
        'Auto response from' => '',
        'Reference' => '',
        'You can use the following tags' => '',
        'To get the first 20 character of the subject.' => 'pro zskni prvnch 20ti znak z pedmtu',
        'To get the first 5 lines of the email.' => 'pro zskni prvnch 5ti dk z emailu',
        'To get the realname of the sender (if given).' => 'Pro zskn Jmna Odeslatele (je-li dno)',
        'To get the article attribute' => '',
        ' e. g.' => '',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => '',
        'Example response' => '',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Sprva Spolenosti Zkaznka',
        'Wildcards are allowed.' => '',
        'Add customer company' => '',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'Pidat Spolenost Zkaznka',

        # Template: AdminCustomerUser
        'Customer Management' => '',
        'Add customer' => '',
        'Select' => 'Vybrat',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => '',
        'Add Customer' => '',
        'Edit Customer' => '',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'tato Funkce je Deaktivovan!',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => 'Aktivujte ji Zde!',
        'Search for customers (wildcards are allowed).' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => '',
        'Groups' => 'Skupiny',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'jen pro ten',
        'Read only access to the ticket in this group/queue.' => 'Pstup pouze pro ten tiketu v tto skupin/front.',
        'rw' => 'ten/psan',
        'Full read and write access to the tickets in this group/queue.' => 'Pln pstup pro ten a psan do tiket v tto skupin/front.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Aktivn',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Admin Notifikace',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => '',
        'Send message to users' => '',
        'Send message to group members' => '',
        'Group members need to have permission' => '',
        'Send message to role members' => '',
        'Also send to customers in groups' => '',
        'Body' => 'Tlo',
        'Send' => 'Odeslat',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => 'Naposledy Sputno',
        'Run Now!' => 'Spustit Te',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => 'Aktuln nebude loha Obecnho Prostedu spoutna automaticky',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Pro automatick sputn vyberte alespo jednu z hodnot: minuta, hodina a den!',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => '(nap. 10*5155 or 105658*)',
        '(e. g. 234321)' => '(nap. 234321)',
        'Customer login' => '',
        '(e. g. U5150)' => '(nap. U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'eitel',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Voln pole Tiketu',
        'Create times' => '',
        'No create time settings.' => 'dn nastaven asu Vytvoen.',
        'Ticket created' => 'Tiket vytvoen',
        'Ticket created between' => 'Tiket vytvoen mezi',
        'Close times' => '',
        'No close time settings.' => 'as Uzaven - bez nastaven',
        'Ticket closed' => 'Uzaven Tikety',
        'Ticket closed between' => 'Uzaven Tikety mezi',
        'Pending times' => '',
        'No pending time settings.' => 'Nevyeen asy - bez nastaven',
        'Ticket pending time reached' => 'Dosaen as een',
        'Ticket pending time reached between' => 'Dosaen as een mezi',
        'Escalation times' => '',
        'No escalation time settings.' => 'asy Eskalace - bez nastaven',
        'Ticket escalation time reached' => 'Dosaen as Eskalace',
        'Ticket escalation time reached between' => 'Dosaen as Eskalace mezi',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => 'Dosaen as Prvn Odpovdi',
        'Ticket first response time reached between' => 'Dosaen as Prvn Odpovdi mezi',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'Dosaen as Aktualizace',
        'Ticket update time reached between' => 'Dosaen as Aktualizace mezi',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => 'Dosaen as een',
        'Ticket solution time reached between' => 'Dosaen as een mezi',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'Nov Voln Pole Tiketu',
        'Archive selected tickets' => '',
        'Add Note' => 'Pidat poznmku',
        'Time units' => 'Jednotky asu',
        ' (work units)' => '(jednotky prce)',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Odeslat upozornn eiteli/Zkaznkovi pi zmn',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Pkaz bude proveden. ARG[0] bude slo Tiketu. ARG[1] ID Tiketu',
        'Delete tickets' => 'Vymazat Tikety',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Uloit',
        'Results' => 'Vsledky',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '',
        'Group Management' => 'Sprva skupiny',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Skupina administrtora m pstup do administran a statistick zny.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Pidat Skupinu',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'Log systmu',
        'Here you will find log information about your system.' => '',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'as',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Sprva Emailovch t',
        'Add mail account' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Vechny pchoz emaily z danho tu budou zaazeny do vybran fronty!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',
        'Host' => 'Hostitel',
        'Delete account' => '',
        'Fetch mail' => '',
        'Add Mail Account' => '',
        'Example: mail.example.com' => '',
        'Trusted' => 'Oveno',
        'Dispatching' => 'Zaazen',
        'Edit Mail Account' => '',

        # Template: AdminNavigationBar
        'Admin' => '',
        'Agent Management' => '',
        'Queue Settings' => '',
        'Ticket Settings' => '',
        'System Administration' => '',

        # Template: AdminNotification
        'Notification Management' => 'Sprva oznmen',
        'Select a different language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Oznmen jsou odeslna agentovi i klientovi',
        'Notification' => 'Upozornn',
        'Edit Notification' => '',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => 'Pidat oznmen',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Typ poloky',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'Shoda Pedmtu',
        'Body match' => 'Shoda Tla',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'pro zskni prvnch 20ti znak z pedmtu (z nejnovjho lnku eitele)',
        'To get the first 5 lines of the body (of the latest agent article).' => 'pro zskni prvnch 5ti dk z tla (z nejnovjho lnku eitele)',
        'To get the first 20 character of the subject (of the latest customer article).' => 'pro zskni prvnch 20ti znak z pedmtu (z nejnovjho lnku Zkaznka)',
        'To get the first 5 lines of the body (of the latest customer article).' => 'pro zskni prvnch 5ti dk z tla (z nejnovjho lnku Zkaznka)',

        # Template: AdminPGP
        'PGP Management' => 'Sprva PGP',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'V tomto zpsobu mete Keyring, konfigurovan v SysConfigu, editovat pmo',
        'Introduction to PGP' => '',
        'Result' => 'Vsledek',
        'Identifier' => 'Identifiktor',
        'Bit' => 'Kousek',
        'Key' => 'Kl',
        'Fingerprint' => 'Otisk',
        'Expires' => 'Propadv',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Sprva Balk',
        'Uninstall package' => '',
        'Version' => 'Verze',
        'Do you really want to uninstall this package?' => 'Opravdu chcete odinstalovat tento Balek?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Pokraovat',
        'Install' => 'Instalovat',
        'Install Package' => '',
        'Update repository information' => '',
        'Online Repository' => 'Online Schrnka',
        'Vendor' => 'Prodava',
        'Module documentation' => 'Dokumentace Modulu',
        'Upgrade' => 'Aktualizace',
        'Local Repository' => 'Lokln Schrnka',
        'Uninstall' => 'Odinstalovat',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Reinstalovat',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => 'Datum',
        'List of Files' => '',
        'Permission' => 'Prva',
        'Download' => '',
        'Download file from package!' => 'Download Souboru z Balku!',
        'Required' => 'Vyadovno',
        'PrimaryKey' => 'Primrn Kl',
        'AutoIncrement' => 'Automatick Prstek',
        'SQL' => '',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Log Vkonu',
        'This feature is enabled!' => 'Tato Funkce je Aktivovna!',
        'Just use this feature if you want to log each request.' => 'Pro logovn vech Poadavk sta zapnout tuto Funkci',
        'Activating this feature might affect your system performance!' => 'Aktivace tto Funkce me ovlivnit chod Systmu!',
        'Disable it here!' => 'Deaktivujte ji Zde!',
        'Logfile too large!' => 'Pli velk logfile',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'Pehled',
        'Range' => 'Oblast',
        'Interface' => 'Rozhran',
        'Requests' => 'Poadavky',
        'Min Response' => 'Minimln Odezva',
        'Max Response' => 'Maximln Odezva',
        'Average Response' => 'Prmrn Odezva',
        'Period' => 'Perioda',
        'Min' => '',
        'Max' => '',
        'Average' => 'Prmr',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Sprva Filtru PostMaster',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => '',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => 'Stop po shod',
        'Filter Condition' => '',
        'Value' => 'Hodnota',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => '',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Sprva priorit',
        'Add priority' => '',
        'Add Priority' => 'Pidat Prioritou',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'as do odemknut',
        '0 = no unlock' => '0 = dn odemknut',
        'Only business hours are counted.' => 'Potaj se pouze edn hodiny',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Upozornno km',
        '0 = no escalation' => '0 = dn stupovn',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Nsledujc volba',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Zamknout tiket po nsledujcm',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => 'Bude adresou odeslatele z tto fronty pro emailov odpovdi.',
        'Default sign key' => '',
        'The salutation for email answers.' => 'Osloven pro emailov odpovdi.',
        'The signature for email answers.' => 'Podpis pro emailov odpovdi.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Automatick Odpovdi',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'Nastaven',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Filtr',
        'Filter for Responses' => '',
        'Responses' => 'Odpovdi',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Odpov je obsahuje vchoz text slouc k rychlej reakci (spolu s vchozm textem) klientm.',
        'Don\'t forget to add a new response a queue!' => 'Nezapomete pidat novou reakci odpove do fronty!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'Aktuln stav tiketu je',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Sprva Rol',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Vytvoit Roli a vloit do n Skupiny. Nsledn piadit Roli Uivatelm.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Pidat Roli',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Role',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'pesunout do',
        'Permissions to move tickets into this group/queue.' => 'Prva pesunout tikety do tto skupiny/fronty',
        'create' => 'vytvoit',
        'Permissions to create tickets in this group/queue.' => 'Prva vytvoit tikety v tto skupin/front',
        'priority' => 'priorita',
        'Permissions to change the ticket priority in this group/queue.' => 'Prva zmnit prioritu tiketu v tto skupin/front',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'Sprva SLA',
        'Add SLA' => 'Pidat SLA',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'Sprva S/MIME',
        'Add certificate' => '',
        'Add private key' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'V tomto zpsobu mete editovat Certifikty a Privtn Kle pmo v Souborovm Systmu.',
        'See also' => 'Viz. tak',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'Pidat Certifikt',
        'Add Private Key' => 'Pidat Privtn Kl',
        'Secret' => 'Tajn',

        # Template: AdminSalutation
        'Salutation Management' => 'Sprva osloven',
        'Add salutation' => '',
        'Add Salutation' => 'Pidat Osloven',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Bezpenostn Md bude (normln) nastaven po dokonen inician instalace.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Bezpenostn Md mus bt deaktivovn za elem Reinstalu pomoc Web-Installeru.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => '',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Sprva Slueb',
        'Add service' => '',
        'Add Service' => 'Pidat Slubu',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Sprva relace',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'Ukonit vechny Relace',
        'Session' => 'Relace',
        'Kill' => '',
        'Kill this session' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Sprva podpis',
        'Add signature' => '',
        'Add Signature' => 'Pidat Podpis',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'Sprva Stavu',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Ujistte se, e jste aktualizovali tak vchoz hodnoty ve Vaem Kernel/Config.pm!',
        'Add State' => 'Pidat Stav',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => '',
        'Navigate by searching in %s settings' => '',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => '',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Podskupina',
        'Elements' => 'Prvky',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Obsah',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'Jmno Navigan Lity',
        'NavBar' => 'Navigan Lita',
        'LinkOption' => '',
        'Block' => 'Brzdov Destika',
        'AccessKey' => 'Pstupov Kl',
        'Add NavBar entry' => '',
        'Year' => '',
        'Month' => '',
        'Day' => '',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Sprva emailovch adres systmu',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Sprva Typ Tiketu',
        'Add ticket type' => '',
        'Add Type' => 'Pidat Typ Tiketu',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Pihlsit jako',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Kestn Jmno',
        'Lastname' => 'Pjmenn',
        'Password is required.' => '',
        'Start' => '',
        'End' => 'Konec',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'vlastnk',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Adres',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Vyhledat Zkaznka',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Nstnka',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => 'v',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s je dostupn!',
        'Please update now.' => 'Aktualizujte prosm nyn',
        'Release Note' => 'Vypustit Poznmku',
        'Level' => 'rove',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Odeslno ped %s',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => '',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Svzat Objekt: %s',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => 'Svzat Objekt',
        'with' => 's',
        'Unlink Object: %s' => 'Zruit Vazbu Objektu: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'Funkce na kontrolu pravopisu',
        'spelling error(s)' => 'chyba(y) v pravopisu',
        'Apply these changes' => 'Aplikovat tyto zmny',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => '',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Vybrat prvky pro adu hodnot',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'Zde je mon provst omezen Statistik',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '',
        'Fixed' => 'pevn stanoveno',
        'Please select only one element or turn off the button \'Fixed\'.' => '',
        'Absolute Period' => '',
        'Between' => 'Mezi',
        'Relative Period' => 'Relativn Interval',
        'The last' => 'Posledn',
        'Finish' => 'Ukonit',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Oprvnn',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'Pi pouit grafu jako vstupnho formtu, je nutno vybrat alespo jednu velikost grafu.',
        'Sum rows' => 'Souet dk',
        'Sum columns' => 'Souet Sloupc',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Vtina Report me bt uloena do mezipamti. Toto urychl jejich nslednou presentaci.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Mtko',
        'minimal' => 'minimln',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maximln interval',
        'minimal scale' => 'minimln mtko',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => 'Soubor nen nastavenm Reportu',
        'No File selected' => 'Nebyl vybrn soubor',

        # Template: AgentStatsOverview
        'Stats' => 'Reporty',
        'Object' => 'Objekt',

        # Template: AgentStatsPrint
        'Print' => 'Tisknout',
        'No Element selected.' => 'Nebyl vybrn prvek',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => '',
        'Graphsize' => 'Velikost Grafu',
        'Cache' => 'Vyrovnvac pam',
        'Exchange Axis' => 'Exchange osy',
        'Configurable params of static stat' => 'Konfigurovateln parametry Statickho Reportu',
        'No element selected.' => 'Nebyl vybrn prvek',
        'maximal period from' => 'maximln perioda z',
        'to' => 'komu',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => 'Nastavit - ek na vyzen',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'Nov vlastnk',
        'Please set a new owner!' => '',
        'Previous Owner' => 'Pedchoz vlastnk',
        'Inform Agent' => '',
        'Optional' => '',
        'Inform involved Agents' => '',
        'Spell check' => '',
        'Note type' => 'Typ poznmky',
        'Next state' => 'Nasledujc stav',
        'Pending date' => 'Datum ekn na vyzen',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'Odeslat zpt',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Nsledujc stav tiketu',
        'Inform sender' => 'Informovat odeslatele',
        'Send mail!' => 'Poslat mail!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Hromadn akce Tiketu',
        'Merge to' => 'Spojit s',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Spojit s nejstarm',
        'Link together' => 'sprovat dohlromady',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Sestavit odpov pro tiket',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'Oekvan as vyzen',
        'for pending* states' => 'pro stavy oekvn*',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Zmnit klienta tiketu',
        'Customer Data' => 'Data Zkaznka',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Historie',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Slouen Tiketu',
        'You need to use a ticket number!' => 'Notno pout slo Tiketu',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Pesunout tiket',
        'New Queue' => 'Nov fronta',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'as prvn reakce',
        'Service Time' => 'Servisn as',
        'Update Time' => 'as Aktualizace',
        'Solution Time' => 'as een',
        'Move ticket to a different queue' => '',
        'Change queue' => 'Zmnit frontu',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Zmnit monosti vyhledvn',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalace v',
        'Locked' => 'Uzameno',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',
        'Create' => 'Vytvoit',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefon hovor',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => 'Jednoduch',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Informace o Tiketu',
        'Accounted time' => 'tovan doba',
        'Linked-Object' => '',
        'by' => 'pes',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Forma vyhledvn',
        'Create New' => '',
        'Create Template' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'Forma vsledku',
        'Fulltext' => '',
        'Remove' => '',
        'Customer User Login' => 'Pihlen klienta',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Vytvoeno ve Front',
        'Lock state' => '',
        'Watcher' => '',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Article Type' => 'Typ lnku',
        'Sender Type' => '',
        'Save filter settings as default' => 'Uloit Filtr jako Implicitn',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => 'Nastavit',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Jt zpt',

        # Template: CustomerFooter
        'Powered by' => 'Vytvoeno',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Pihlen',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => 'Podat o nov heslo',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Vytvoit et',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'Pjemci',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Template Name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'z',
        'Page' => 'Strana',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Vtejte v %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Uivatel',
        'New' => 'Nov',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'vchoz \'hot\'',
        'DB--- host' => '',
        'Database' => 'Databze',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Abyste mohli pouvat OTRS, muste zadat nsledujc dek do Vaeho pkazovho dku (Terminal/Shell) jako root.',
        'Restart your webserver' => 'Restartujte V webserver',
        'After doing so your OTRS is up and running.' => 'Po dokonen nsledujcch operac je V OTRS sputn a pob',
        'Start page' => 'vodn strnka',
        'Your OTRS Team' => 'V OTRS tm',

        # Template: InstallerLicense
        'Accept license' => 'Pijmout licenci',
        'Don\'t accept license' => '',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'Systmov ID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'Systm FQDN',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'Email Administrtora',
        'Email address of the system administrator.' => '',
        'Organization' => 'Organizace',
        'Log' => '',
        'LogModule' => 'Log Modul',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Webove rozhran',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'Kontrola MX zznamu',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'Ztratil/a jste heslo?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => '',

        # Template: PrintHeader
        'printed by' => 'tisknuto',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'Testovac OTRS strnka',
        'Welcome %s' => 'Vtejte %s',
        'Counter' => 'Potadlo',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Plohy <-> Odpovdi',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Emailov Adresy',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Obecn Prostedek',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => '',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Role <-> Skupiny',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'Vbr motivu rozhran.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => 'Tikety',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',
        'New Year\'s Day' => '',
        'International Workers\' Day' => '',
        'Christmas Eve' => '',
        'First Christmas Day' => '',
        'Second Christmas Day' => '',
        'New Year\'s Eve' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => 'Ovlivnno %s Tiket! Opravdu spustit lohu?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontroluj MX zznamy pouitch emailovch adres pi sestavovn odpovdi. Nepouvejte pokud OTRS server pipojen pomoc vyten linky!)',
        '(Email of the system admin)' => '(Email administrtora systmu)',
        '(Full qualified domain name of your system)' => '(Platn nzev domny pro v systm (FQDN))',
        '(Logfile just needed for File-LogModule!)' => '(Pro logovn do souboru je nutn zadat nzev souboru logu!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Poznmka: poet monch pouitch Dynamickch Objekt je zvisl na typu Instalace)',
        '(Note: Useful for big databases and low performance server)' => '(Poznmka: vhodn pro obshl databze a mn vkon servery)',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Identita systmu. Kad slo tiketu a ID kad HTTP relace zan tmto slem)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiktor tiket. Nekte lid chtj nastavit nap. \'Tiket#\',  \'Hovor#\' nebo \'MujTiket#\')',
        '(Used default language)' => '(Pouit vchoz jazyk)',
        '(Used log backend)' => '(Pouit vstup do logu)',
        '(Used ticket number format)' => '(Pouit formt sel tiket)',
        'A article should have a title!' => 'lnek by ml mt nadpis!',
        'A message must be spell checked!' => 'Zprva mus bt pravopisn zkontrolovan!',
        'A message should have a To: recipient!' => 'Zprva by mla obsahovat Komu: pjemce!',
        'A message should have a body!' => 'Zprva by mla mt tlo!',
        'A message should have a subject!' => 'Zprva by mla mt pedmt!',
        'A web calendar' => 'WEB Kalend',
        'A web file manager' => 'Webov Sprvce Soubor',
        'A web mail client' => 'Web Email Klient',
        'Absolut Period' => 'Absolutn Interval',
        'Account Type' => 'Typ tu',
        'Add Customer User' => 'Pidat Uivatele Zkaznka',
        'Add System Address' => 'Pidat Systmovou Adresu',
        'Add User' => 'Pidat Uivatele',
        'Add a new Agent.' => 'Pidat eitele',
        'Add a new Customer Company.' => 'Pidat novou Spolenost Zkaznka',
        'Add a new Group.' => 'Pidat Novou Skupinu',
        'Add a new Notification.' => 'Pidat Nov Oznmen',
        'Add a new Priority.' => 'Pidat novou Prioritou',
        'Add a new Role.' => 'Pidat Novou Roli',
        'Add a new SLA.' => 'Pidat nov SLA',
        'Add a new Salutation.' => 'Pidat nov Osloven',
        'Add a new Service.' => 'Pidat novou Slubu',
        'Add a new Signature.' => 'Pidat nov Podpis',
        'Add a new State.' => 'Pidat nov Stav',
        'Add a new System Address.' => 'Pidat novou Systmovou Adresu',
        'Add a new Type.' => 'Pidat nov Typ Tiketu',
        'Add note to ticket' => 'Pidat poznmku k tiketu',
        'Added User "%s"' => 'Pidan Uivatel "%s"',
        'Admin-Area' => 'Oblast Admina',
        'Admin-Email' => 'Email administrtora',
        'Admin-Password' => 'Heslo Administrtora',
        'Admin-User' => 'Administrtor',
        'Advisory' => 'Poradenstv',
        'Agent Mailbox' => 'Mailbox eitele',
        'Agent Preferences' => 'Pedvolby eitele',
        'Agent based' => 'na zklad eitele',
        'Agent-Area' => 'Oblast eitele',
        'All Agent variables.' => 'Vechny Promnn eitele',
        'All Agents' => 'Vichni eitel',
        'All customer tickets.' => 'Vechny tikety Zkaznka',
        'All email addresses get excluded on replaying on composing an email.' => 'Vylouit vechny Emailov adresy v odpovdi novho mailu.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Vechny pchoz emaily obsahujc tohoto adresta (v poli KOMU) budou zaazeny to vybran fronty!',
        'All messages' => 'Vechny zprvy',
        'All new tickets!' => 'Vechny nov Tikety!',
        'All tickets where the reminder date has reached!' => 'Vechny Tikety u kterch byla dosaena upomnka!',
        'All tickets which are escalated!' => 'Vechny Tikety kter jsou Eskalovny!',
        'Allocate CustomerUser to service' => 'Pidlit Zkaznka/Uivatele ke Slub',
        'Allocate services to CustomerUser' => 'Pidlit Slubu Zkaznkovi/Uivateli',
        'Answer' => 'Odpov',
        'Article Create Times' => 'as vytvoen lnku',
        'Article created' => 'lnek vytvoen',
        'Article created between' => 'lnek vytvoen mezi',
        'Article filter settings' => 'Nastaven Filtru lnku',
        'ArticleID' => 'ID poloky',
        'Attach' => 'Pipojit',
        'Attribute' => 'Atribut',
        'Auto Response From' => 'Automatick odpov Od',
        'Bounce ticket' => 'Odeslat tiket zpt',
        'Can not create link with %s!' => 'Nen mon vytvoit vazbu s %s',
        'Can not delete link with %s!' => 'Nemon smazat sprovn s %s',
        'Category Tree' => 'Strom Kategori',
        'Change %s settings' => 'Zmnit nastaven %s',
        'Change Times' => 'Zmna as',
        'Change free text of ticket' => 'Zmnit pln text tiketu',
        'Change owner of ticket' => 'Zmnit vlastnka tiketu',
        'Change priority of ticket' => 'Zmnit dleitost tiketu',
        'Change responsible of ticket' => 'Zmna Odpovdnosti Tiketu',
        'Change roles <-> groups settings' => 'Zmna Rol <-> Nastaven Skupin',
        'Change user <-> group settings' => 'Zmnit uivatele <-> nastaven skupiny',
        'ChangeLog' => 'Log Zmn',
        'Child-Object' => 'Podzen Objekt',
        'Clear From' => 'Vymazat pole Od',
        'Clear To' => 'Vyistit',
        'Click here to report a bug!' => 'Kliknte zde pro nahlen chyby!',
        'Close Times' => 'asy Uzaven',
        'Close ticket' => 'Zavt tiket',
        'Close type' => 'Zavt typ',
        'Close!' => 'Zavt!',
        'Collapse View' => 'Zkrcen pohled',
        'Comment (internal)' => 'Koment (intern)',
        'CompanyTickets' => 'Firemn Tikety',
        'Compose Answer' => 'Odpovdt',
        'Compose Email' => 'Napsat Email',
        'Compose Follow up' => 'Sestavit nsledujc',
        'Config Options' => 'Sparva Nastaven',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Monosti Nastaven (pklad: &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Monosti Nastaven (pklad: <OTRS?CONFIG?HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Monosti Upesnn (pklad <OTRS_CONFIG_HttpType>).',
        'Contact customer' => 'Kontaktovat klienta',
        'Create Times' => 'asy Vytvoen',
        'Create new Phone Ticket' => 'Vytvoit nov Telefonn Tiket',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Vytvoit nov skupiny pro piazen prv pstup ruznm skupinm agent (nap. oddlen nkupu, oddlen podpory, oddlen prodeje...).',
        'CreateTicket' => 'Vytvoeno Tiketu',
        'Customer Move Notify' => 'Oznmen Klientovi o zmn fronty',
        'Customer Owner Notify' => 'Oznmen Klientovi o zmn vlastnka',
        'Customer State Notify' => 'Oznmen Klientovi o zmn stavu',
        'Customer User' => 'Uivatel Zkaznka',
        'Customer User Management' => 'Sprva Zkaznickch Uivatel',
        'Customer Users' => 'Uivatel Zkaznka',
        'Customer Users <-> Groups' => 'Uivatel Zkaznka <-> Skupiny',
        'Customer Users <-> Groups Management' => 'Uivatel Zkaznka <-> Sprva Skupin',
        'Customer Users <-> Services Management' => 'Uivatel Zkaznka <-> Sprva Slueb',
        'Customer history' => 'Historie Zkaznka',
        'Customer history search' => 'Vyhledvn historie klienta',
        'Customer history search (e. g. "ID342425").' => 'Vyhledvn historie klienta (nap. "ID342425")',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Uivatel Zkaznka bude potebovat zkaznickou historii a logovat se ze Zkaznickho Modulu',
        'CustomerUser' => 'Klient',
        'D' => 'A-Z',
        'DB Admin Password' => 'Heslo administrtora databze',
        'DB Admin User' => 'Administrtor databze',
        'DB Host' => 'Hostitel (server) databze',
        'DB Type' => 'Typ databze',
        'DB connect host' => 'Spojen s DB ztraceno',
        'Default' => 'Defaultn',
        'Default Charset' => 'Vchoz znakov sada',
        'Default Language' => 'Vchoz jazyk',
        'Delete old database' => 'Smazat starou databzi',
        'Diff' => 'Rozdl',
        'Discard all changes and return to the compose screen' => 'Zruit vechny zmny a vrtit se zpt do okna vytven',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Odeli nebo Filtruj pchoz meaily zaloen na X-Headers! Mon je tak RegExp.',
        'Do you really want to delete this Object?' => 'Opravdu smazat tento Objekt?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Opravdu chcete reinstalovat tento Balek (vechna manuln nastaven budou ztracena)?',
        'Don\'t forget to add a new user to groups!' => 'Nezapomete pidat novho uivatele do skupin!',
        'Download Settings' => 'Sthnout Nastaven',
        'Download all system config changes.' => 'Sthnout vechny Systmov Konfiguran zmny.',
        'Drop Database' => 'Odstranit databazi',
        'Dynamic-Object' => 'Dynamick Objekt',
        'Edit default services.' => 'Upravit Vchoz Slubu',
        'Email based' => 'na zklad Emailu',
        'Escaladed Tickets' => 'Eskalovan Tikety',
        'Escalation - First Response Time' => 'Eskalace - as Prvn Odpovdi!',
        'Escalation - Solution Time' => 'Eskalace - as een',
        'Escalation - Update Time' => 'Eskalace - as Aktualizace',
        'Escalation Times' => 'asy Eskalace',
        'Escalation time' => 'Doba Eskalace',
        'Event is required!' => 'Vyadovna Udlost!',
        'Expand View' => 'Rozen pohled',
        'Explanation' => 'Legenda',
        'Export Config' => 'Exportovat nastaven',
        'FileManager' => 'Sprvce Soubor',
        'Filelist' => 'Seznam Soubor',
        'Filtername' => 'Jmno Filtru',
        'Follow up' => 'Nsledujc',
        'Follow up notification' => 'Nsleduj Oznmen',
        'For very complex stats it is possible to include a hardcoded file.' => 'Do hodn komplexnch Report je mon zahrnout zakdovan soubory.',
        'Frontend' => 'Rozhran',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fulltextov vyhledvn v poloce (nap. "Mar*in" or "Baue*")',
        'Group Ro' => 'Skupina pouze pro ten',
        'Group based' => 'na zklad Skupiny',
        'Group selection' => 'Vbr Skupiny',
        'Hash' => 'Hash #',
        'Have a lot of fun!' => 'Pejeme hodn spch s OTRS!',
        'Here you can insert a description of the stat.' => 'Zde mete vloit popis Statistiky',
        'Here you can select the dynamic object you want to use.' => 'Zde mete vybrat Dinamick Objekt, kter chcete pout.',
        'Home' => 'Dom',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Pokud nen Bezpenostn Md aktivn, provete tak pomoc SysConfigu, protoe aplikace stle b.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'V ppad novho dostupnho Zakdovanho Souboru bude zobrazen pznak a bude mon jej vybrat.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Pokud je tiket uzaven a klient odele nsledujc, tiket bude pro starho vlastnka uzamknut.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Pokud na Tiket nebude reagovno v tomto ase, bude zobrazen poze tento.',
        'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Nebude-li tiket odpovzen v danm ase, bude zobrazen pouze tento Tiket.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Pokud eitel uzamkne tiket a neodele v tto dob odpov, tiket bude automaticky odemknut. Tak se stane tiket viditeln pro vechny ostatn eitele.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Pokud nebylo nic vybrno, nejsou v tto skupin dn prva (tikety nebudou pro uivatele dostupn).',
        'If you need the sum of every column select yes.' => 'Je-li vyadovn souet vech sloupc, vyberte ANO',
        'If you need the sum of every row select yes' => 'Je-li vyadovn souet vech dk, vyberte ANO',
        'If you want to account time, please provide Subject and Text!' => 'Jestli chcete potat as, poskytnte Pedmt a Text!',
        'Image' => 'Obrzek',
        'Important' => 'Dleit',
        'In this form you can select the basic specifications.' => 'V tomto Formuli mete vybrat zkladn specifikace.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'V tomto zsobu mete pmo editovat Keyring konfigurovan v Kernelu pm.',
        'Information about the Stat' => 'Informace o Reportu',
        'Insert of the common specifications' => 'Vloen spolench upesnn',
        'Is Job Valid' => 'Je loha platn',
        'Is Job Valid?' => 'Je loha platn?',
        'It\'s useful for ASP solutions.' => 'To je vhodn pro een ASP',
        'Job-List' => 'Seznam loh',
        'Keyword' => 'Klov slovo',
        'Keywords' => 'Klov slova',
        'Last update' => 'Posledn aktualizace',
        'Link to Parent' => 'Sprovat s mateskm',
        'Linked as' => 'Sprovno jako',
        'Load Settings' => 'Nahrt Nastaven',
        'Logfile' => 'Log soubor',
        'Logfile too large, you need to reset it!' => 'Pli velk logfile, provee jeho reset!',
        'Login failed! Your username or password was entered incorrectly.' => 'Pihlen nespn! Vae uivatelsk jmno i heslo bylo zadno nesprvn.',
        'Lookup' => 'Vyhledvn',
        'Mail Management' => 'Sprva e-mail',
        'Mailbox' => 'Potovn schrnka',
        'Match' => 'Obsahuje',
        'Message for new Owner' => 'Zprva pro novho vlastnka',
        'Message sent to' => 'Zprva odeslna',
        'Misc' => 'Rzn',
        'Modified' => 'Zmnno',
        'Modules' => 'Moduly',
        'Move notification' => 'Pesunout oznmen',
        'Multiple selection of the output format.' => 'Vbr ze Selekce vstupnho formtu.',
        'MyTickets' => 'moje Tikety',
        'Name is required!' => 'Vyadovno Jmno!',
        'New Agent' => 'Nov eitel',
        'New Customer' => 'Nov Zkaznk',
        'New Group' => 'Nov Skupina',
        'New Group Ro' => 'Nov Skupina pouze pro ten',
        'New Password' => 'Nov heslo',
        'New Priority' => 'Nov Priorita',
        'New SLA' => 'Nov SLA',
        'New Service' => 'Nov Sluba',
        'New State' => 'Nov Stav',
        'New Ticket Lock' => 'Nov Zmek Tiketu',
        'New Title' => 'Nov Nadpis',
        'New Type' => 'Nov Typ Tiketu',
        'New account created. Sent Login-Account to %s.' => 'Nov et vytvoen. Pihlaovac daje odeslny na %s.',
        'New messages' => 'Nov zprvy',
        'New password again' => 'Potvrdit Nov Heslo',
        'No * possible!' => 'dn * mon!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'dn balky pro poadovan rmec v tomto online loiti, ne pro jin rmce!',
        'No Packages or no new Packages in selected Online Repository!' => 'dn (nov) balky ve vybranm online loiti',
        'No Permission' => 'Nedostaten prva',
        'No change time settings.' => 'dn nastaven zmny asu',
        'No means, send agent and customer notifications on changes.' => 'Ne znamen: poslat eiteli i Zkaznkovi oznmen pi zmn',
        'No time settings.' => 'dn nastaven asu',
        'Note' => 'Poznmka',
        'Note Text' => 'Text poznmky',
        'Notification (Customer)' => 'Oznmen (Zkaznkovi)',
        'Notifications' => 'Notifikace',
        'OTRS DB Name' => 'Nzev OTRS databze',
        'OTRS DB Password' => 'Heslo OTRS databze',
        'OTRS DB User' => 'Uivatel OTRS databze',
        'OTRS DB connect host' => 'Hostitel OTRS databze (server)',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS pole klientovi emailem oznmen, pokud bude tiket pesunut.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn vlastnk tiketu.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS pole klientovi emailem oznmen, pokud se zmn stav tiketu.',
        'Object already linked as %s.' => 'Objekt je ji sprovn jako %s',
        'Of couse this feature will take some system performance it self!' => 'Pi nastn tohoto jevu dojde k poklesu vkonu',
        'Only for ArticleCreate Event.' => 'Pouze pro udlost vytvoen lnku',
        'Open Tickets' => 'Otevt Tikety',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Monosti informac o tomto Uivateli Zkaznka (pklad <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Monosti stvajcho Uivatele poadujcho tuto akci (pklad: <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Monosti tohoto Uivatele, kter poadoval tuto akci (pklad <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Monosti dat Tiketu (pklad: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Monosti dat Tiketu (pklad: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Monosti dat Tiketu (pklad <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Order' => 'Seadit',
        'Other Options' => 'Dal monosti',
        'Out Of Office' => 'Mimo Kancel',
        'POP3 Account Management' => 'Sprva POP3 t',
        'Package' => 'Balek',
        'Param 1' => 'Parametr 1',
        'Param 2' => 'Parametr 2',
        'Param 3' => 'Parametr 3',
        'Param 4' => 'Parametr 4',
        'Param 5' => 'Parametr 5',
        'Param 6' => 'Parametr 6',
        'Parent-Object' => 'Nadazen Objekt',
        'Password is already in use! Please use an other password!' => 'Heslo je pouvno! Pouijte prosm jin heslo!',
        'Password is already used! Please use an other password!' => 'Heslo je ji pouito! Pouijte prosm jin heslo!',
        'Pending Times' => 'Nevyeen asy',
        'Pending messages' => 'Zprvy ekajc na vyzen',
        'Pending type' => 'Typ ekn na vyzen',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Nastaven Oprvnn. Na zklad selekce Skupin mete report zviditelnit rznm eitelm.',
        'Permissions to change the ticket owner in this group/queue.' => 'Prva zmnit vlastnka tiketu v tto skupin/front',
        'PhoneView' => 'Nov tiket / hovor',
        'Please contact your admin' => 'Kontaktujte, prosm, Vaeho administrtora',
        'Prio' => 'Priorita',
        'Problem' => 'Problm',
        'Queue <-> Auto Responses Management' => 'Fronta <-> Sprva Automatickch Odpovd',
        'Queue ID' => 'ID fronty',
        'Queue Management' => 'Sprva front',
        'Realname' => 'Skuten jmno',
        'Rebuild' => 'Obnovit',
        'Recipients' => 'Adresti',
        'Refresh' => 'Obnovit',
        'Reminder' => 'Upomnka',
        'Reminder messages' => 'Upomnkov zprvy',
        'Required Field' => 'Povinn Pole',
        'Response Management' => 'Sprva Reakc',
        'Responses <-> Attachments Management' => 'Reakce <-> Sprva Ploh',
        'Responses <-> Queue Management' => 'Reakce <-> Sprva Front',
        'Return to the compose screen' => 'Zpt do okna vytven',
        'Roles <-> Groups Management' => 'Role <-> Sprva Skupin',
        'Roles <-> Users' => 'Role <-> Uivatel',
        'Roles <-> Users Management' => 'Role <-> Sprva Uivatel',
        'Save Job as?' => 'Uloit lohu jako?',
        'Save Search-Profile as Template?' => 'Uloit profil vyhledvn jako ablonu?',
        'Schedule' => 'Plnovn',
        'Search Result' => 'Vsledky vyhledvn',
        'Search for' => 'Vyhledvn',
        'Secure Mode need to be enabled!' => 'Bezpenostn Md mus bt aktivovn!',
        'Select Box' => 'Poadavek na SQL databzi',
        'Select Box Result' => 'Vsledek SQL dotazu',
        'Select Source (for add)' => 'Vybrat zdroj (pro pidn)',
        'Select the customeruser:service relations.' => 'Vybrat Uivatele Zkaznka: vazba ke slub',
        'Select the element, which will be used at the X-axis' => 'Vybrat prvek pro osu X',
        'Select the restrictions to characterise the stat' => 'Vyberte omezen pro charakteristiku Reportu',
        'Select the role:user relations.' => 'Vybrat Roli: vztahy Uivatele.',
        'Select the user:group permissions.' => 'Vybrat uivatele:prva skupiny',
        'Select your QueueView refresh time.' => 'Vyberte si dobu obnoven nhledu fronty.',
        'Select your default spelling dictionary.' => 'Vbr vchozho pravopisnho slovnku',
        'Select your frontend Charset.' => 'Vbr znakov sady rozhran.',
        'Select your frontend QueueView.' => 'Vbr nhledu fronty rozhran.',
        'Select your frontend language.' => 'Vbr jazyka rozhran.',
        'Select your out of office time.' => 'Nastaven asu Mimo Kancel',
        'Select your screen after creating a new ticket.' => 'Vyberte Zobrazen po vytvoen novho Tiketu.',
        'Selection needed' => 'Nutn Vbr',
        'Send Notification' => 'Odeslat Upozornn',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Poli mi oznmen, pokud klient pole nsledujc a jsem vlastnk tohoto tiketu.',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Poli mi oznmen o prohldnutch Tiketech, jako Vlastnkovi Tiket',
        'Send no notifications' => 'Neodeslat Notifikace',
        'Sent new password to: %s' => 'Nov heslo odeslno na: %s',
        'Sent password token to: %s' => 'Heslo Tokenu odeslno na: %s',
        'Sessions' => 'Relace',
        'Set customer user and customer id of a ticket' => 'Nastavit klienta a nastavit ID klienta tiketu',
        'Show' => 'Uka',
        'Site' => 'Umstn',
        'Solution' => 'een',
        'Sort by' => 'Tdit dle',
        'Source' => 'Zdroj',
        'Spell Check' => 'Kontrola pravopisu',
        'Split' => 'Rozdlit',
        'State Type' => 'Typ stavu',
        'Static-File' => 'Statick Soubor',
        'Stats-Area' => 'Oblast Report',
        'Sub-Queue of' => 'Podfronta ',
        'Sub-Service of' => 'Podsluba',
        'Subscribe' => 'Podepsat',
        'Symptom' => 'Pznak',
        'System History' => 'Historie Systmu',
        'System State Management' => 'Sprva stavu systmu',
        'System Status' => 'Status Systmu',
        'Systemaddress' => 'Systmov adresa',
        'The message being composed has been closed.  Exiting.' => 'Vytven zprva byla uzavena. Opoutm.',
        'This account exists.' => 'Tento et existuje',
        'This window must be called from compose window' => 'Toto okno mus bt vyvolno z okna vytven',
        'Ticket Hook' => 'Oznaen tiketu',
        'Ticket Lock' => 'Zmek Tiketu',
        'Ticket Number Generator' => 'Genertor sel tiket',
        'Ticket Search' => 'Hledn tiketu',
        'Ticket Status View' => 'Zobrazen Statutu Tiketu',
        'Ticket changed' => 'Tiket zmnn',
        'Ticket changed between' => 'Tiket zmnn mezi',
        'Ticket escalation!' => 'Eskalace tiket',
        'Ticket locked!' => 'Tiket zamknut!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Monosti Vlastnka Tiketu (pklad: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Monosti Vlastnka Tiketu (pklad: <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Monosti Vlastnka Tiketu (pklad <OTRS_OWNER_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Tiket vybrn pro Hromadnou Akci!',
        'Ticket unlock!' => 'Tiket odemknut!',
        'Ticket-Area' => 'Oblast Tiketu',
        'TicketFreeText' => 'Voln text tiketu',
        'TicketID' => 'ID tiketu',
        'TicketZoom' => 'Zobrazen tiketu',
        'Tickets shown' => 'Zobrazen tikety',
        'Tickets which need to be answered!' => 'Tikety na kter je teba odpovdt!',
        'Times' => 'Doba',
        'Title of the stat.' => 'Jmno Statistiky',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Pro zskn atribut lnku (pklad (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Pro zskn atributu lnku (pklad (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'Top of Page' => 'Nahoru',
        'Total hits' => 'Celkov poet zznam',
        'U' => 'Z-A',
        'Unable to parse Online Repository index document!' => 'Nepodailo se zpracovat Online Repository Index',
        'Uniq' => 'Poet',
        'Unlock Tickets' => 'Odemknout Tikety',
        'Unsubscribe' => 'Nepodepsat',
        'Use utf-8 it your database supports it!' => 'Pouijte utf-8 pokud to Vae databze podporuje',
        'Useable options' => 'Pouiteln monosti',
        'User Management' => 'Sprva uivatel',
        'User will be needed to handle tickets.' => 'Uivatel bude potebovat prva pro sprvu tiket.',
        'Users' => 'Uivatel',
        'Users <-> Groups' => 'Uivatel <-> Skupiny',
        'Users <-> Groups Management' => 'Uivatel <-> Sprva Skupin',
        'Verify New Password' => 'Potvrzen hesla',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Vstraha! Tyto Tikety budou vymazny z Databze a budou ztraceny!',
        'Watch notification' => 'Zobrazit Oznmen',
        'Web-Installer' => 'Web-instaltor',
        'WebMail' => 'Web Mail',
        'WebWatcher' => 'Webov Prohle',
        'Welcome to OTRS' => 'Vtejte v OTRS',
        'Yes means, send no agent and customer notifications on changes.' => 'Ne znamen: Neposlat eiteli a Zkaznkovi oznmen pi zmn',
        'Yes, save it with name' => 'Ano, uloit pod nzvem',
        'You got new message!' => 'Mte novou zprvu!',
        'You have to select two or more attributes from the select field!' => 'Nutno zvolit dva a vce atribut z vbrovho pole!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Muste mt  uvedenu emailovou adresu (nap. klient@priklad.cz) v poli Komu:!',
        'You need min. one selected Ticket!' => 'Nutno vybrat alespo jeden Tiket!',
        'You need to account time!' => 'Potebujete tovat dobu!',
        'You need to activate %s first to use it!' => '%s mus bt aktivovno!',
        'Your email address is new' => 'Vae Email adresa je nov',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'V email s slem ticketu "<OTRS_TICKET>" je odesln zpt na "<OTRS_BOUNCE_TO>". Kontaktujte tuto adresu pro dal infromace.',
        'Your own Ticket' => 'V vlastn tiket',
        'accept license' => 'souhlasm s licenc',
        'customer realname' => 'skuten jmno klienta',
        'don\'t accept license' => 'nesouhlasm s licenc',
        'down' => 'dol',
        'false' => 'Nepravda',
        'for agent firstname' => 'pro kestn jmno agenta',
        'for agent lastname' => 'pro pjmen agenta',
        'for agent login' => 'pro pihlen eitele',
        'for agent user id' => 'pro uivatelsk ID agenta',
        'kill all sessions' => 'Zruit vechny relace',
        'kill session' => 'Ukonit Relaci',
        'modified' => 'Upraveno',
        'new ticket' => 'nov tiket',
        'next step' => 'dal krok',
        'send' => 'poslat',
        'sort downward' => 'Tdit sestupn',
        'sort upward' => 'Tdit vzestupn',
        'to get the first 20 character of the subject' => 'pro zskni prvnch 20 znak z pedmtu',
        'to get the first 5 lines of the email' => 'pro zskn prvnch 5 dk z emailu',
        'to get the from line of the email' => 'pro zskan dku Od z emailu',
        'to get the realname of the sender (if given)' => 'pro zskan skutenho jmna odeslatele (pokud je zadno)',
        'up' => 'nahoru',
        'x' => 'Spustit',

    };
    # $$STOP$$
    return;
}

1;
