# --
# Kernel/Language/zh_TW.pm - provides Chinese Traditional language translation
# Copyright (C) 2009 Bin Du <bindu2008 at gmail.com>
# Copyright (C) 2009 Yiye Huang <yiyehuang at gmail.com>
# Copyright (C) 2009 Qingjiu Jia <jiaqj at yahoo.com>
# --
# $Id: zh_TW.pm,v 1.21 2011/01/20 14:59:05 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::zh_TW;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.21 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2010-11-25 14:51:49

    # possible charsets
    $Self->{Charset} = ['big5', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = ' %A %Y/%M/%D %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    # csv separator
    $Self->{Separator} = '';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'O',
        'No' => '_',
        'yes' => 'O',
        'no' => ']m',
        'Off' => '',
        'off' => '',
        'On' => '}',
        'on' => '}',
        'top' => '',
        'end' => '',
        'Done' => 'T{',
        'Cancel' => '',
        'Reset' => 'm',
        'last' => '̦Z',
        'before' => '',
        'day' => '',
        'days' => '',
        'day(s)' => '',
        'hour' => 'p',
        'hours' => 'p',
        'hour(s)' => 'p',
        'Hours' => '',
        'minute' => '',
        'minutes' => '',
        'minute(s)' => '',
        'Minutes' => '',
        'month' => '',
        'months' => '',
        'month(s)' => '',
        'week' => 'P',
        'week(s)' => 'P',
        'year' => '~',
        'years' => '~',
        'year(s)' => '~',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'gD',
        'Message' => '',
        'Error' => '~',
        'Bug Report' => 'Bug i',
        'Attention' => '`N',
        'Warning' => 'ĵi',
        'Module' => 'Ҷ',
        'Modulefile' => 'Ҷ',
        'Subfunction' => 'l\',
        'Line' => '',
        'Setting' => ']m',
        'Settings' => ']m',
        'Example' => 'ܨ',
        'Examples' => 'ܨ',
        'valid' => '',
        'invalid' => 'L',
        '* invalid' => '* L',
        'invalid-temporarily' => 'ȮɵL',
        ' 2 minutes' => ' 2 ',
        ' 5 minutes' => ' 5 ',
        ' 7 minutes' => ' 7 ',
        '10 minutes' => '10 ',
        '15 minutes' => '15 ',
        'Mr.' => '',
        'Mrs.' => 'ҤH',
        'Next' => 'U@',
        'Back' => 'Zh',
        'Next...' => 'U@...',
        '...Back' => '...Zh',
        '-none-' => '-L-',
        'none' => 'L',
        'none!' => 'L!',
        'none - answered' => 'L - w_',
        'please do not edit!' => 'ns!',
        'Need Action' => '',
        'AddLink' => 'W[챵',
        'Link' => '챵',
        'Unlink' => '챵',
        'Linked' => 'w챵',
        'Link (Normal)' => '챵 (`)',
        'Link (Parent)' => '챵 ()',
        'Link (Child)' => '챵 (l)',
        'Normal' => '`',
        'Parent' => '',
        'Child' => 'l',
        'Hit' => 'I',
        'Hits' => 'I',
        'Text' => '',
        'Standard' => '',
        'Lite' => '²',
        'User' => 'Τ',
        'Username' => 'ΤW',
        'Language' => 'y',
        'Languages' => 'y',
        'Password' => 'KX',
        'Preferences' => ']m',
        'Salutation' => 'ٿ',
        'Salutations' => 'ٿ',
        'Signature' => 'ñW',
        'Signatures' => 'ñW',
        'Customer' => 'Ȥ',
        'CustomerID' => 'Ȥs',
        'CustomerIDs' => 'Ȥs',
        'customer' => 'Ȥ',
        'agent' => '޳NH',
        'system' => 't',
        'Customer Info' => 'ȤH',
        'Customer Information' => '',
        'Customer Company' => 'Ȥ',
        'Customer Companies' => '',
        'Company' => '',
        'go!' => '}l!',
        'go' => '}l',
        'All' => '',
        'all' => '',
        'Sorry' => '藍_',
        'update!' => 's!',
        'update' => 's',
        'Update' => 's',
        'Updated!' => '',
        'submit!' => '!',
        'submit' => '',
        'Submit' => '',
        'change!' => 'ק!',
        'Change' => 'ק',
        'change' => 'ק',
        'click here' => 'Io',
        'Comment' => '`',
        'Valid' => '',
        'Invalid Option!' => 'LĿﶵ!',
        'Invalid time!' => 'LĮɶ!',
        'Invalid date!' => 'LĤ!',
        'Name' => 'W',
        'Group' => 'զW',
        'Description' => 'yz',
        'description' => 'yz',
        'Theme' => 'DD',
        'Created' => 'Ы',
        'Created by' => 'Ыإ',
        'Changed' => 'wק',
        'Changed by' => 'ק',
        'Search' => 'j',
        'and' => 'M',
        'between' => 'b',
        'Fulltext Search' => 'j',
        'Data' => '',
        'Options' => 'ﶵ',
        'Title' => 'D',
        'Item' => '',
        'Delete' => 'R',
        'Edit' => 's',
        'View' => 'd',
        'Number' => 's',
        'System' => 't',
        'Contact' => 'ptH',
        'Contacts' => 'ptH',
        'Export' => 'ɥX',
        'Up' => 'W',
        'Down' => 'U',
        'Add' => 'W[',
        'Added!' => '',
        'Category' => 'ؿ',
        'Viewer' => 'dݾ',
        'Expand' => 'Xi',
        'Small' => '',
        'Medium' => '',
        'Large' => '',
        'Date picker' => '',
        'New message' => 's',
        'New message!' => 's!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Х^_ TicketAMZ^쥿`C!',
        'You have %s new message(s)!' => 'z %s s!',
        'You have %s reminder ticket(s)!' => 'z %s Ӵ!',
        'The recommended charset for your language is %s!' => 'ĳzҥλyrŶ %s!',
        'Change your password.' => '',
        'Please activate %s first!' => '',
        'No suggestions' => 'Lĳ',
        'Word' => 'r',
        'Ignore' => '',
        'replace with' => '',
        'There is no account with that login name.' => 'ӥΤWSbH.',
        'Login failed! Your user name or password was entered incorrectly.' => '',
        'There is no acount with that user name.' => '',
        'Please contact your administrator' => '',
        'Logout' => '`P',
        'Logout successful. Thank you for using OTRS!' => '\`PA¨ϥ!',
        'Invalid SessionID!' => 'LĪ|ܼѲ!',
        'Feature not active!' => 'ӯSʩ|E!',
        'Agent updated!' => '',
        'Create Database' => 'Ыؼƾڮw',
        'System Settings' => 'ƾڮw]m ',
        'Mail Configuration' => '',
        'Finished' => '',
        'Login is needed!' => 'ݭnn!',
        'Password is needed!' => 'ݭnKX!',
        'License' => '\i',
        'Take this Customer' => 'ooӫȤ',
        'Take this User' => 'ooӥΤ',
        'possible' => 'i',
        'reject' => 'ڵ',
        'reverse' => 'Zh',
        'Facility' => 'O',
        'Time Zone' => '',
        'Pending till' => 'ݦ',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'nϥ UserID 1 (tν㸹)! гЫؤ@ӷsΤ!',
        'Dispatching by email To: field.' => 'l: .',
        'Dispatching by selected Queue.' => 'lҿﶤC.',
        'No entry found!' => 'Le!',
        'Session has timed out. Please log in again.' => '|ܶWɡAЭsn.',
        'No Permission!' => 'Lv!',
        'To: (%s) replaced with database email!' => 'To: (%s) Qƾڮwla}ҴN',
        'Cc: (%s) added database email!' => 'Cc: (%s) W[ƾڮwla}!',
        '(Click here to add)' => '(IBW[)',
        'Preview' => 'w',
        'Package not correctly deployed! You should reinstall the Package again!' => 'n]i}`! zݭnA@sw˳oӳn]',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
        'Customer %s added' => '',
        'Role added!' => '',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'XP',
        'Online Customer: %s' => 'buȤ: %s',
        'Online Agent: %s' => 'bu޳NHG%s',
        'Calendar' => '',
        'File' => '',
        'Filename' => 'W',
        'Type' => '',
        'Size' => 'jp',
        'Upload' => 'W',
        'Directory' => 'ؿ',
        'Signed' => 'wñW',
        'Sign' => 'ñp',
        'Crypted' => 'w[K',
        'Crypt' => '[K',
        'PGP' => '',
        'PGP Key' => '',
        'PGP Keys' => '',
        'S/MIME' => '',
        'S/MIME Certificate' => '',
        'S/MIME Certificates' => '',
        'Office' => '줽',
        'Phone' => 'q',
        'Fax' => 'ǯu',
        'Mobile' => '',
        'Zip' => 'ls',
        'City' => '',
        'Street' => 'D',
        'Country' => 'a',
        'Location' => '',
        'installed' => 'ww',
        'uninstalled' => 'w',
        'Security Note: You should activate %s because application is already running!' => 'w: zE %s, ]ΤwgbB!',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => '',
        'printed at' => 'L',
        'Loading...' => '',
        'Dear Mr. %s,' => 'Lq %s :',
        'Dear Mrs. %s,' => 'Lq %s kh:',
        'Dear %s,' => 'Lq %s:',
        'Hello %s,' => 'zn, %s:',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => '',
        'Please press Back and try again.' => 'Ъ^Aդ@.',
        'Sent password reset instructions. Please check your email.' => '',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'YNӪƥ',
        'Event' => 'ƥ',
        'Events' => 'ƥ',
        'Invalid Token!' => 'DkаO',
        'more' => 'h',
        'For more info see:' => 'hHЬ',
        'Package verification failed!' => 'n]',
        'Collapse' => '',
        'Shown' => '',
        'News' => 'sD',
        'Product News' => '~sD',
        'OTRS News' => '',
        '7 Day Stats' => '',
        'Bold' => '',
        'Italic' => '',
        'Underline' => 'u',
        'Font Color' => 'rC',
        'Background Color' => 'I',
        'Remove Formatting' => 'R榡',
        'Show/Hide Hidden Elements' => '/ ín',
        'Align Left' => '',
        'Align Center' => '~',
        'Align Right' => 'k',
        'Justify' => '',
        'Header' => 'HY',
        'Indent' => 'Y',
        'Outdent' => '~',
        'Create an Unordered List' => 'Ыؤ@ӵLǦC',
        'Create an Ordered List' => 'Ыؤ@ӦǦC',
        'HTML Link' => 'HTML챵',
        'Insert Image' => 'JϹ',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => '_',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => '@',
        'Feb' => 'G',
        'Mar' => 'T',
        'Apr' => '|',
        'May' => '',
        'Jun' => '',
        'Jul' => 'C',
        'Aug' => 'K',
        'Sep' => 'E',
        'Oct' => 'Q',
        'Nov' => 'Q@',
        'Dec' => 'QG',
        'January' => '@',
        'February' => 'G',
        'March' => 'T',
        'April' => '|',
        'May_long' => '',
        'June' => '',
        'July' => 'C',
        'August' => 'K',
        'September' => 'E',
        'October' => 'Q',
        'November' => 'Q@',
        'December' => 'QG',

        # Template: AAAPreferences
        'Preferences updated successfully!' => ']ms\!',
        'User Profile' => '',
        'Email Settings' => '',
        'Other Settings' => '',
        'Change Password' => 'קKX',
        'Current Password' => '',
        'New password' => 'sKX',
        'Verify password' => '',
        'Spelling Dictionary' => 'gˬdr',
        'Default spelling dictionary' => '',
        'Max. shown Tickets a page in Overview.' => 'C@ܪ̤j Tickets ƥ.',
        'The current password is not correct. Please try again!' => '',
        'Can\'t update password, your new passwords do not match. Please try again!' => '',
        'Can\'t update password, it contains invalid characters!' => '',
        'Can\'t update password, it must be at least %s characters long!' => '',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => '',
        'Can\'t update password, it must contain at least 1 digit!' => '',
        'Can\'t update password, it must contain at least 2 characters!' => '',
        'Can\'t update password, this password has already been used. Please choose a new one!' => '',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => '',
        'CSV Separator' => '',

        # Template: AAAStats
        'Stat' => 'έp',
        'Sum' => '',
        'Please fill out the required fields!' => 'жgrq',
        'Please select a file!' => 'пܤ@Ӥ!',
        'Please select an object!' => 'пܤ@ӹH!',
        'Please select a graph size!' => 'пܹϤؤo!',
        'Please select one element for the X-axis!' => 'пܤ@ӤX-b',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'аܤ@ӤQ쪺\'Fixed\'s',
        'If you use a checkbox you have to select some attributes of the select field!' => 'pGAϥδ_اAܳQ쪺@ݩ!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'bwJдJ@ӭȡA\'Fixed\'_ءI',
        'The selected end time is before the start time!' => 'wɶ}lɶI',
        'You have to select one or more attributes from the select field!' => 'qQ줤Aܤ@өΦhݩʡI',
        'The selected Date isn\'t valid!' => 'ҿ',
        'Please select only one or two elements via the checkbox!' => 'qL_ءAаܤ@өΨӭnI',
        'If you use a time scale element you can only select one element!' => 'pGzϥΪOɶث׭nAܨ䤤@Ӳզ',
        'You have an error in your time selection!' => 'A@ӿ~ɶܡI',
        'Your reporting time interval is too small, please use a larger time scale!' => 'ziɶjӤpAШϥΧjj',
        'The selected start time is before the allowed start time!' => 'w}lɶ󤹳\}lɶ',
        'The selected end time is after the allowed end time!' => 'wɶߩ󤹳\ɶ',
        'The selected time period is larger than the allowed time period!' => 'bwɶqj󤹳\ɶq',
        'Common Specification' => '@PWS',
        'X-axis' => 'Xb',
        'Value Series' => 'ȨtC',
        'Restrictions' => '',
        'graph-lines' => 'u',
        'graph-bars' => 'W',
        'graph-hbars' => 'HW',
        'graph-points' => 'I',
        'graph-lines-points' => 'ϽuI',
        'graph-area' => 'ϰ',
        'graph-pie' => '',
        'extended' => 'Xi',
        'Agent/Owner' => 'Ҧ',
        'Created by Agent/Owner' => '޳NHЫت',
        'Created Priority' => 'Ыتu',
        'Created State' => 'ЫتA',
        'Create Time' => 'Ыخɶ',
        'CustomerUserLogin' => 'Ȥn',
        'Close Time' => 'ɶ',
        'TicketAccumulation' => 'Ticketn',
        'Attributes to be printed' => 'nLݩ',
        'Sort sequence' => 'ƧǧǦC',
        'Order by' => 'Ǳ',
        'Limit' => '',
        'Ticketlist' => 'TicketM',
        'ascending' => 'ɧ',
        'descending' => '',
        'First Lock' => 'w',
        'Evaluation by' => 'H',
        'Total Time' => '`ɶ',
        'Ticket Average' => 'TicketBzɶ',
        'Ticket Min Time' => 'TicketBz̤pɶ',
        'Ticket Max Time' => 'TicketBz̤jɶ',
        'Number of Tickets' => 'Ticketƥ',
        'Article Average' => 'ArticleBzɶ',
        'Article Min Time' => 'ArticleBz̤pɶ',
        'Article Max Time' => 'ArticleBz̤jɶ',
        'Number of Articles' => 'Articleƶq',
        'Accounted time by Agent' => '޳NHBzTicketҥΪɶ',
        'Ticket/Article Accounted Time' => 'Ticket/ArticleҦΪɶ',
        'TicketAccountedTime' => 'TicketҦΪɶ',
        'Ticket Create Time' => 'TicketЫخɶ',
        'Ticket Close Time' => 'Ticketɶ',

        # Template: AAATicket
        'Status View' => '',
        'Bulk' => '',
        'Lock' => 'w',
        'Unlock' => '',
        'History' => 'v',
        'Zoom' => 'li}',
        'Age' => '`ɶ',
        'Bounce' => '^h',
        'Forward' => 'o',
        'From' => 'oH',
        'To' => 'H',
        'Cc' => '۰e',
        'Bcc' => 'te',
        'Subject' => 'D',
        'Move' => '',
        'Queue' => 'C',
        'Queues' => 'C',
        'Priority' => 'u',
        'Priorities' => '',
        'Priority Update' => 'su',
        'SLA' => 'AȯŧOĳ(SLA)',
        'Service Level Agreement' => '',
        'Service Level Agreements' => '',
        'Service' => 'A',
        'Services' => '',
        'State' => 'A',
        'States' => '',
        'Status' => 'A',
        'Statuses' => '',
        'Ticket Type' => '',
        'Ticket Types' => '',
        'Compose' => 'g',
        'Pending' => '',
        'Owner' => 'Ҧ',
        'Owner Update' => 'sҦ',
        'Responsible' => 'tdH',
        'Responsible Update' => 'stdH',
        'Sender' => 'oH',
        'Article' => 'H',
        'Ticket' => 'Ticket',
        'Createtime' => 'Ыخɶ',
        'plain' => '¤奻',
        'Email' => 'la}',
        'email' => 'E-Mail',
        'Close' => '',
        'Action' => 'ʧ@',
        'Attachment' => '',
        'Attachments' => '',
        'This message was written in a character set other than your own.' => 'oʶlҥΦrŶPtΦrŶ',
        'If it is not displayed correctly,' => 'pGܤT,',
        'This is a' => 'oO@',
        'to open it in a new window.' => 'bsf}',
        'This is a HTML email. Click here to show it.' => 'oO@HTML榡lAIo.',
        'Free Fields' => 'B~H',
        'Merge' => 'X',
        'merged' => 'wX',
        'closed successful' => '\',
        'closed unsuccessful' => '',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'new' => 's',
        'open' => '}',
        'Open' => '}',
        'closed' => '',
        'Closed' => '',
        'removed' => 'R',
        'pending reminder' => 'ݴ',
        'pending auto' => '۰ʵ',
        'pending auto close+' => 'ݦ۰+',
        'pending auto close-' => 'ݦ۰-',
        'email-external' => '~ E-Mail ',
        'email-internal' => ' E-Mail ',
        'note-external' => '~`',
        'note-internal' => '`',
        'note-report' => '`ѳi',
        'phone' => 'q',
        'sms' => 'uH',
        'webrequest' => 'WebШD',
        'lock' => 'w',
        'unlock' => 'w',
        'very low' => 'D`C',
        'low' => 'C',
        'normal' => '`',
        'high' => '',
        'very high' => 'D`',
        '1 very low' => '1 D`C',
        '2 low' => '2 C',
        '3 normal' => '3 `',
        '4 high' => '4 ',
        '5 very high' => '5 D`',
        'Ticket "%s" created!' => 'Ticket "%s" wЫ!',
        'Ticket Number' => 'Ticket s',
        'Ticket Object' => 'Ticket H',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ticket "%s" sbAЫب䪺챵!',
        'Don\'t show closed Tickets' => 'ܤw Tickets',
        'Show closed Tickets' => 'ܤw Tickets',
        'New Article' => 's峹',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'l Ticket',
        'Create new Email Ticket' => 'Ыطsl Ticket',
        'Phone-Ticket' => 'q Ticket',
        'Search Tickets' => 'j Tickets',
        'Edit Customer Users' => 'sȤb',
        'Edit Customer Company' => 'sȤ',
        'Bulk Action' => 'qBz',
        'Bulk Actions on Tickets' => 'qBz Tickets',
        'Send Email and create a new Ticket' => 'oe Email óЫؤ@ӷs Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Ыطs TicketõoeXh',
        'Create new Phone Ticket (Inbound)' => 'ЫطsqTicket]iӪTicket^',
        'Overview of all open Tickets' => 'Ҧ} Tickets p',
        'Locked Tickets' => 'ww Ticket',
        'My Locked Tickets' => '',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'q\ Tickets',
        'Watched' => 'q',
        'Watch' => '',
        'Unwatch' => '',
        'Lock it to work on it!' => 'wö}lu@ !',
        'Unlock to give it back to the queue!' => 'ðe^C!',
        'Shows the ticket history!' => ' Ticket vp!',
        'Print this ticket!' => 'L Ticket !',
        'Change the ticket priority!' => 'ק Ticket u',
        'Change the ticket free fields!' => 'ק Ticket B~H',
        'Link this ticket to an other objects!' => '챵 Ticket LH!',
        'Change the ticket owner!' => 'ק Ticket Ҧ!',
        'Change the ticket customer!' => 'ק Ticket ݫȤ!',
        'Add a note to this ticket!' => ' Ticket W[`!',
        'Merge this ticket!' => 'Xø Ticket!',
        'Set this ticket to pending!' => 'N Ticket JݪA',
        'Close this ticket!' => ' Ticket!',
        'Look into a ticket!' => 'd Ticket e',
        'Delete this ticket!' => 'R Ticket!',
        'Mark as Spam!' => 'аOU!',
        'My Queues' => 'ڪC',
        'Shown Tickets' => ' Tickets',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'zl "<OTRS_TICKET>" QXè "<OTRS_MERGE_TO_TICKET>" !',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: Ĥ@TɶwӮ(%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: Ĥ@TɶNӮ(%s)!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: sɶwӮ(%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: sɶNӮ(%s)!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: BzѨMwӮ(%s)!',
        'Ticket %s: solution time will be over in %s!' => 'BzѨMNӮ(%s)!',
        'There are more escalated tickets!' => 'hɯŪtickets',
        'Plain Format' => '',
        'Reply All' => '',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'New ticket notification' => 's Ticket q',
        'Send me a notification if there is a new ticket in "My Queues".' => 'pGڪCs TicketAгq.',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Ticket wWɳq ',
        'Send me a notification if a ticket is unlocked by the system.' => 'pG Ticket QtθAгq.',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => '',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'pG Ticket QJڪCAгq.',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'ẕ`ζCApGzl]mEAzN|oӶCAq.',
        'Custom Queue' => 'ȤᶤC',
        'QueueView refresh time' => 'CϨsɶ',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => '',
        'Screen after new ticket' => 'Ыطs Ticket Z',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => ' Tickets',
        'Show closed tickets.' => 'ܤw Tickets.',
        'Max. shown Tickets a page in QueueView.' => 'CϨC Ticket .',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 's Ticket',
        'Create new Ticket' => 'Ыطs Ticket',
        'Customer called' => 'ȤPq',
        'phone call' => 'qܩIs',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'wF',
        'Reminder Tickets' => ' Ticket',
        'Escalated Tickets' => 'ɯŪTicket',
        'New Tickets' => 'sTicket',
        'Open Tickets / Need to be answered' => '}Tickets/ݭn^',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'History::Move' => 'Ticket 춤C "%s" (%s) qC "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'sAȯŧOĳ to %s (ID=%s).',
        'History::NewTicket' => 'New ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => '۰ʩڵoe "%s".',
        'History::SendAutoReply' => '۰ʦ^_oe "%s".',
        'History::SendAutoFollowUp' => '۰ʸܵoe "%s".',
        'History::Forward' => 'o "%s".',
        'History::Bounce' => '^h "%s".',
        'History::SendAnswer' => 'Hoe "%s".',
        'History::SendAgentNotification' => '"%s"-Benachrichtigung versand an "%s".',
        'History::SendCustomerNotification' => 'qoe "%s".',
        'History::EmailAgent' => 'ol󵹫Ȥ.',
        'History::EmailCustomer' => 'Add mail. %s',
        'History::PhoneCallAgent' => 'Called customer',
        'History::PhoneCallCustomer' => 'ȤwLq',
        'History::AddNote' => '[` (%s)',
        'History::Lock' => 'Ticket w.',
        'History::Unlock' => 'Ticket .',
        'History::TimeAccounting' => '%s time unit(d) counted. Totaly %s time unit(s) counted.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Refreshed: %s',
        'History::PriorityUpdate' => 'uųQsAq  "%s" (%s)  "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop protection! sent no auto answer to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Refreshed: %s',
        'History::StateUpdate' => 'Before "%s" s: "%s"',
        'History::TicketFreeTextUpdate' => 'Refreshed: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'ȤiWШD.',
        'History::TicketLinkAdd' => 'Link to "%s" established.',
        'History::TicketLinkDelete' => 'Link to "%s" removed.',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'P',
        'Mon' => 'P@',
        'Tue' => 'PG',
        'Wed' => 'PT',
        'Thu' => 'P|',
        'Fri' => 'P',
        'Sat' => 'P',

        # Template: AdminAttachment
        'Attachment Management' => '޲z',
        'Actions' => '',
        'Go to overview' => '',
        'Add attachment' => '',
        'List' => 'C',
        'No data found.' => '',
        'Download file' => '',
        'Delete this attachment' => '',
        'Add Attachment' => '',
        'Edit Attachment' => '',
        'This field is required.' => '',
        'or' => 'Ϊ',

        # Template: AdminAutoResponse
        'Auto Response Management' => '۰ʦ^_޲z',
        'Add auto response' => '',
        'Add Auto Response' => '',
        'Edit Auto Response' => '',
        'Response' => '^_',
        'Auto response from' => '',
        'Reference' => '',
        'You can use the following tags' => '',
        'To get the first 20 character of the subject.' => 'ܼDe20Ӧr`',
        'To get the first 5 lines of the email.' => 'ܹqle',
        'To get the realname of the sender (if given).' => 'ܵoHuWr',
        'To get the article attribute' => '',
        ' e. g.' => '',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => '',
        'Example response' => '',

        # Template: AdminCustomerCompany
        'Customer Company Management' => '޲zȤH',
        'Wildcards are allowed.' => '',
        'Add customer company' => '',
        'Please enter a search term to look for customer companies.' => '',
        'Add Customer Company' => 'W[ȤH',

        # Template: AdminCustomerUser
        'Customer Management' => '',
        'Add customer' => '',
        'Select' => '',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => '',
        'Please enter a search term to look for customers.' => '',
        'Last Login' => '',
        'Add Customer' => '',
        'Edit Customer' => '',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => '',
        'Notice' => '',
        'This feature is disabled!' => 'ӥ\w',
        'Just use this feature if you want to define group permissions for customers.' => '',
        'Enable it here!' => '}ӥ\',
        'Search for customers (wildcards are allowed).' => '',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => '',
        'Customers' => '',
        'Groups' => '',
        'No matches found.' => '',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => '',
        'No changes can be made to these groups.' => '',
        'ro' => 'Ū',
        'Read only access to the ticket in this group/queue.' => 'C Ticket Ū.',
        'rw' => 'Ūg',
        'Full read and write access to the tickets in this group/queue.' => 'C Ticket Ū/g.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => '',
        'Filter for Services' => '',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'E',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => '޲zq',
        'Send Administrative Message to Agents' => '',
        'Your message was sent to' => '',
        'Send message to users' => '',
        'Send message to group members' => '',
        'Group members need to have permission' => '',
        'Send message to role members' => '',
        'Also send to customers in groups' => '',
        'Body' => 'e',
        'Send' => 'oe',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => '̦ZB',
        'Run Now!' => '{bB!',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Currently this generic agent job will not run automatically.' => 'ثeo@qAgent@~N|۰ʹB',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'ҥΦ۰ʰܤֿܤ@ӭȤAɶM',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => '  Ҧp: 10*5144 Ϊ 105658*',
        '(e. g. 234321)' => 'Ҧp: 234321',
        'Customer login' => '',
        '(e. g. U5150)' => 'Ҧp: U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => '޳NH',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Ticket ۥѰϰ',
        'Create times' => '',
        'No create time settings.' => 'SЫخɶ]m',
        'Ticket created' => 'Ыخɶ',
        'Ticket created between' => ' Ыخɶb',
        'Close times' => '',
        'No close time settings.' => '',
        'Ticket closed' => ' Ticket',
        'Ticket closed between' => '',
        'Pending times' => '',
        'No pending time settings.' => 'S]mݩwɶ',
        'Ticket pending time reached' => 'ݩwɶw쪺Ticket',
        'Ticket pending time reached between' => 'bݩwɶTicket ',
        'Escalation times' => '',
        'No escalation time settings.' => 'SɯŮɶ]m',
        'Ticket escalation time reached' => 'wɯŮɶTicket',
        'Ticket escalation time reached between' => 'bɯŮɶTicket',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => '^_ɶw쪺Ticket',
        'Ticket first response time reached between' => 'b^_ɶTicket',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'sɶw쪺Ticket',
        'Ticket update time reached between' => 'bsɶTicket',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => '׸ѨMɶw쪺Ticket',
        'Ticket solution time reached between' => 'b׸ѨMɶw쪺Ticket',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 's Ticket ۥѰϰ',
        'Archive selected tickets' => '',
        'Add Note' => 'W[`',
        'Time units' => 'ɶ椸',
        ' (work units)' => 'u@椸',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'oeNz/Ȥqܧ',
        'CMD' => 'RO',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'NoөRO, Ĥ@ӰѼƬO Ticket sAĤGӰѼƬO Ticket Ѳ.',
        'Delete tickets' => 'R Tickets',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Os',
        'Results' => 'G',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'ĵiGz\'޲z\'ժWٮɡAbSysConfig@XܤƤeAANQ޲zOIpGoͳoرpAХSQLyyզW^\'admin\'',
        'Group Management' => 'պ޲z',
        'Add group' => '',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin եiHiJtκ޲zϰ, Stats եiHiJέp޲z',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'W[s',
        'Edit Group' => '',

        # Template: AdminLog
        'System Log' => 'tΤ',
        'Here you will find log information about your system.' => '',
        'Time' => 'ɶ',

        # Template: AdminMailAccount
        'Mail Account Management' => 'lb޲z',
        'Add mail account' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'ҦӦۤ@Ӷl㸹lN|QoҿﶤC!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'pGzbOȱoH઺A{X-OTRSDFɶ]uA ... ^NQϥΡIlFLoNQϥ',
        'Host' => 'D',
        'Delete account' => '',
        'Fetch mail' => '',
        'Add Mail Account' => '',
        'Example: mail.example.com' => '',
        'Trusted' => 'O_H',
        'Dispatching' => '',
        'Edit Mail Account' => '',

        # Template: AdminNavigationBar
        'Admin' => '޲z',
        'Agent Management' => '',
        'Queue Settings' => '',
        'Ticket Settings' => '',
        'System Administration' => '',

        # Template: AdminNotification
        'Notification Management' => 'q޲z',
        'Filter for Language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'qQoe޳NHΪ̫Ȥ.',
        'Notification' => 'tγq',
        'Edit Notification' => '',
        'e. g.' => '',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => '',
        'Delete this notification' => '',
        'Add Notification' => 'W[q',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => '峹',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'Dǰt',
        'Body match' => 'eǰt',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => '',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => '',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminPGP
        'PGP Management' => 'PGP ޲z',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'oؤ覡AziHsbSysConfig]m',
        'Introduction to PGP' => '',
        'Result' => 'G',
        'Identifier' => 'Ѳ',
        'Bit' => '',
        'Key' => 'K',
        'Fingerprint' => 'L',
        'Expires' => 'L',
        'Delete this key' => '',
        'Add PGP Key' => '',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'n]޲z',
        'Uninstall package' => '',
        'Version' => '',
        'Do you really want to uninstall this package?' => 'O_T{ӳn]?',
        'Reinstall package' => '',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => '~',
        'Install' => 'w',
        'Install Package' => '',
        'Update repository information' => '',
        'Online Repository' => 'buѮw',
        'Vendor' => 'Ѫ',
        'Module documentation' => 'Ҷ',
        'Upgrade' => 'ɯ',
        'Local Repository' => 'aѮw',
        'Uninstall' => '',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'sw',
        'Download package' => '',
        'Rebuild package' => '',
        'Metadata' => '',
        'Change Log' => '',
        'Date' => '',
        'List of Files' => '',
        'Permission' => 'v',
        'Download' => 'U',
        'Download file from package!' => 'qn]UoӤ',
        'Required' => 'ݪ',
        'PrimaryKey' => '䪺Key',
        'AutoIncrement' => '۰ʻW',
        'SQL' => 'SQL',
        'File differences for file %s' => '',

        # Template: AdminPerformanceLog
        'Performance Log' => 'tκʵ',
        'This feature is enabled!' => 'ӥ\wҥ',
        'Just use this feature if you want to log each request.' => 'pGzQԲӰOCӽШD, ziHϥθӥ\.',
        'Activating this feature might affect your system performance!' => 'Ұʸӥ\ivTztΩʯ',
        'Disable it here!' => 'ӥ\',
        'Logfile too large!' => 'ӤLj',
        'The logfile is too large, you need to reset it' => '',
        'Overview' => 'p',
        'Range' => 'S',
        'Interface' => 'ɭ',
        'Requests' => 'ШD',
        'Min Response' => '̤p^',
        'Max Response' => '̤j^',
        'Average Response' => '^',
        'Period' => 'P',
        'Min' => '̤p',
        'Max' => '̤j',
        'Average' => '',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'lLo޲z',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'pGzQȤǰtemail a}A ШϥEMAILADDRESS:info@example.com in From, To or Cc.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => '',
        'Stop after match' => '',
        'Filter Condition' => '',
        'Value' => '',
        'Set Email Headers' => '',

        # Template: AdminPriority
        'Priority Management' => 'uv޲z',
        'Add priority' => '',
        'Add Priority' => 'K[uv',
        'Edit Priority' => '',

        # Template: AdminQueue
        'Manage Queues' => '',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => '۰ʸWɴ',
        '0 = no unlock' => '0 = ۰ʸ  ',
        'Only business hours are counted.' => 'ȥHWZɶp',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'i׳q',
        '0 = no escalation' => '0 = L  ',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'iﶵ',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'iT{HZATicket NQ۰ʤW',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => '^_lҥΪoe̦a}',
        'Default sign key' => '',
        'The salutation for email answers.' => '^_lҥκٿ.',
        'The signature for email answers.' => '^_lҥñW.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => '۰ʦ^_\',
        'Change Auto Response Relations for Queue' => '',
        'settings' => ']m',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Lo',
        'Filter for Responses' => '',
        'Responses' => '^_',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => 'Fֳt^_A^_ewqFCӦ^__e.',
        'Don\'t forget to add a new response a queue!' => 'nѰOW[@ӷs^_e춤C!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'e Ticket AO',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => '޲z',
        'Add role' => '',
        'Create a role and put groups in it. Then add the role to the users.' => 'Ыؤ@ӨñNե[J,MZNᵹΤ.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'W[',
        'Edit Role' => '',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => '',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'ʨ',
        'Permissions to move tickets into this group/queue.' => '\ Tickets Ӳ/C.',
        'create' => 'Ы',
        'Permissions to create tickets in this group/queue.' => 'bӲ/CЫ Tickets v.',
        'priority' => 'u',
        'Permissions to change the ticket priority in this group/queue.' => 'bӲ/Cק Tickets uŪv.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => '',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'AȯŧOĳ(SLA)޲z',
        'Add SLA' => 'W[AȯŧOĳ(SLA)',
        'Edit SLA' => '',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME ޲z',
        'Add certificate' => '',
        'Add private key' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'γoؤ覡ziHsѩMp',
        'See also' => 'Ѩ',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'K[',
        'Add Private Key' => 'K[p',
        'Secret' => 'KX',

        # Template: AdminSalutation
        'Salutation Management' => '٩Iy޲z',
        'Add salutation' => '',
        'Add Salutation' => 'W[٩Iy',
        'Edit Salutation' => '',
        'Example salutation' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'blw˵ZAwҦq`NQ]m',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'FsWeb ɭwˡAwҦdisabled',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'SQLdߵf',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'AȺ޲z',
        'Add service' => '',
        'Add Service' => 'W[A',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => '|ܺ޲z',
        'All sessions' => '',
        'Agent sessions' => '',
        'Customer sessions' => '',
        'Unique agents' => '',
        'Unique customers' => '',
        'Kill all sessions' => 'פҦ|',
        'Session' => '|',
        'Kill' => '',
        'Kill this session' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'ñW޲z',
        'Add signature' => '',
        'Add Signature' => 'W[ñW',
        'Edit Signature' => '',
        'Example signature' => '',

        # Template: AdminState
        'State Management' => 'A޲z',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'zPɧsF Kernel/Config.pm ʬ٪A!',
        'Add State' => 'W[A',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'tΰtm',
        'Navigate by searching in %s settings' => '',
        'Go to group %s' => '',
        'Group %s' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'ɤJ',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'l',
        'Elements' => '',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'e',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'ɯW',
        'NavBar' => 'ɯ',
        'LinkOption' => '',
        'Block' => '',
        'AccessKey' => 'i_',
        'Add NavBar entry' => '',
        'Year' => '',
        'Month' => '',
        'Day' => '',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'tζla}޲z',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => '޲z',
        'Add ticket type' => '',
        'Add Type' => 'W[',
        'Edit Type' => '',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'nW',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'W',
        'Lastname' => 'm',
        'Start' => '}l',
        'End' => '',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'Ҧ',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'a}ï',
        'Search for a customer' => '',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => '',

        # Template: AgentCustomerSearch
        'Search Customer' => 'jȤ',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',
        'Show or hide the content' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => 'Чs',
        'Release Note' => 'o`',
        'Level' => 'ŧO',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket was locked' => '',
        'Undo & close window' => '',

        # Template: AgentInfo
        'Info' => 'Ա',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'sH: %s',
        'Close window' => '',
        'go to link delete screen' => '',
        'Select Target Object' => '',
        'Link Object' => '챵H',
        'with' => 'M',
        'Unlink Object: %s' => 'sH %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => '',

        # Template: AgentSpelling
        'Spell Checker' => 'gˬd',
        'spelling error(s)' => 'g~',
        'Apply these changes' => 'γoǧ',

        # Template: AgentStatsDelete
        'Delete stat' => '',
        'Stat#' => '',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'ܻȨtCn',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => 'ziHzέpwѼ',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'pGzR_bTw_ءAͦӲέp޳NNiHܬnݩ',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => 'аܤ@ӤQ쪺\'Fixed\'s',
        'Absolute Period' => '',
        'Between' => '',
        'Relative Period' => '۹P',
        'The last' => '',
        'Finish' => '',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'i',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'If you use a graph as output format you have to select at least one graph size.' => 'pGzϥΪOϧΪX榡Aܤֿܤ@ӹϧΪjp',
        'Sum rows' => '`M',
        'Sum columns' => '`MC',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'jhƪέpƥiHws,oN[ֳo@έpi.',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'ث',
        'minimal' => '̤p',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'аOAoBȨtCnjXbثס]pX -b=>A ValueSeries =>~^ ',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => '̤jP',
        'minimal scale' => '̤pث',

        # Template: AgentStatsImport
        'Import Stat' => '',
        'File is not a Stats config' => '󤣬O@Ӳέptm',
        'No File selected' => 'SQ襤',

        # Template: AgentStatsOverview
        'Stats' => 'έp',
        'Object' => 'H',

        # Template: AgentStatsPrint
        'Print' => 'L',
        'No Element selected.' => 'SQ襤',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => '榡',
        'Graphsize' => 'ϧΤ',
        'Cache' => 'ws',
        'Exchange Axis' => 'ഫb',
        'Configurable params of static stat' => 'RAέptmѼ',
        'No element selected.' => 'SQѼ',
        'maximal period from' => '̤jP',
        'to' => '',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => '',
        'Change Owner of Ticket' => '',
        'Close Ticket' => '',
        'Add Note to Ticket' => '',
        'Set Pending' => ']mݳBzA',
        'Change Priority of Ticket' => '',
        'Change Responsible of Ticket' => '',
        'Cancel & close window' => '',
        'Service invalid.' => '',
        'New Owner' => 'sҦ',
        'Please set a new owner!' => '',
        'Previous Owner' => 'e@өҦ',
        'Inform Agent' => 'q޳NH',
        'Optional' => 'ﶵ',
        'Inform involved Agents' => 'q޳NH',
        'Spell check' => '',
        'Note type' => '`',
        'Next state' => 'Ticket A',
        'Pending date' => 'ݳBz',
        'Date invalid!' => '',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => '^h ',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Tickets A',
        'Inform sender' => 'qoe',
        'Send mail!' => 'oe!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Ticket qBz',
        'Merge to' => 'Xè',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Xè̦Ѫ',
        'Link together' => 'Xæb@_',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'g_,Ticket s',
        'Need a valid email address.' => '',
        'Address book' => '',
        'Pending Date' => 'iJݪA',
        'for pending* states' => 'wﵥݪA',
        'Date Invalid!' => '',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'ק Tickets ݫȤ',
        'Customer Data' => 'Ȥƾ',
        'Customer user' => '',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => '',
        'From queue' => '',
        'Get all' => '',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'v',
        'History Content' => '',
        'Zoom view' => '',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Ticket X',
        'The Ticket was locked' => '',
        'You need to use a ticket number!' => 'zݭnϥΤ@ Ticket s!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => ' Ticket',
        'New Queue' => 'sC',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => '',
        'No ticket data found.' => '',
        'First Response Time' => 'iɶ',
        'Service Time' => 'AȮɶ',
        'Update Time' => 'sɶ',
        'Solution Time' => 'ѨMɶ',
        'Move ticket to a different queue' => '',
        'Change queue' => 'ܶC',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'קjﶵ',
        'Max. shown Tickets a page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => '',
        'Locked' => 'wA',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => '',
        'From customer' => '',
        'To queue' => '',
        'Create' => 'Ы',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'q',

        # Template: AgentTicketPlain
        'Email Text Plain View' => '',
        'Plain' => '¤奻',
        'Download this email' => '',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'TicketH',
        'Accounted time' => 'ҥήɶ',
        'Linked-Object' => 'w챵H',
        'by' => '',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'jҪO',
        'Create New' => '',
        'Create Template' => '',
        'Save changes in template' => '',
        'Add another attribute' => '',
        'Output' => 'jGܬ',
        'Fulltext' => '',
        'Remove' => '',
        'Customer User Login' => 'ȤΤnH',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'bC̫إ',
        'Lock state' => '',
        'Watcher' => '',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => '',
        'Save filter settings as default' => 'OsLo]mʬ٭',
        'Ticket Information' => '',
        'Linked Objects' => '',
        'Article(s)' => '',
        'Change Queue' => '',
        'Article Filter' => '',
        'Add Filter' => '',
        'Set' => ']m',
        'Reset Filter' => '',
        'Show one article' => '',
        'Show all articles' => '',
        'Unread articles' => '',
        'No.' => '',
        'Unread Article!' => '',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'l',

        # Template: CustomerFooter
        'Powered by' => 'Xʤ',
        'One or more errors occurred!' => '',
        'Close this dialog' => '',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'n',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => '',
        'Log In' => '',
        'Not yet registered?' => '',
        'Sign up now' => '',
        'Request new password' => ']msKX',
        'Your User Name' => '',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Ыرb',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'You have not created a ticket yet.' => '',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you.' => '',
        'We stop eating if you wish us to do.' => '',
        'Your way to communicate with us is this thing called \'ticket\'.' => '',
        'Please command us.' => '',
        'Create your first Ticket' => '',

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Profile' => 'j',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => '',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'H',
        'Carbon Copy' => '',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Template Name' => '',
        'Output to' => '',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => '',
        'Page' => '',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Loading' => '',
        'Reply' => '',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => '',
        'Sunday' => '',
        'Monday' => '',
        'Tuesday' => '',
        'Wednesday' => '',
        'Thursday' => '',
        'Friday' => '',
        'Saturday' => '',
        'Su' => '',
        'Mo' => '',
        'Tu' => '',
        'We' => '',
        'Th' => '',
        'Fr' => '',
        'Sa' => '',
        'Open date selection' => '',

        # Template: Error
        'Oops! An Error occurred.' => '',
        'Error Message' => '',
        'You can' => '',
        'Send a bugreport' => '',
        'go back to the previous page' => '',
        'Error Details' => '',

        # Template: Footer
        'Top of page' => '',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => '',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => '',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => '',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => '',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'wϥ %s',
        'Web site' => '',
        'Database check successful.' => '',
        'Mail check successful.' => '',
        'Error in the mail settings. Please correct and try again.' => '',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => '',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => '',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => '',
        'Check mail configuration' => '',
        'Skip this step' => '',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'pGzƾڮw]m root KX, Цbo̿J, _h, ЫOdť. XwҼ{, ڭ̫ĳz root ]m@ӱKX, hHаѦҼƾڮwU.',
        'Currently only MySQL is supported in the web installer.' => '',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'ƾڮwΤW',
        'New' => 's',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'q{KX \'hot\'',
        'DB--- host' => '',
        'Database' => 'ƾڮw',
        'Check database settings' => '',
        'Result of database check' => '',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'FϥOTRS, zHrootJHUbRO椤(Terminal/Shell).',
        'Restart your webserver' => 'ЭsҰʱz webserver.',
        'After doing so your OTRS is up and running.' => 'ZAziHҰ OTRS tΤF.',
        'Start page' => '}l',
        'Your OTRS Team' => 'z OTRS p.',

        # Template: InstallerLicense
        'Accept license' => 'PN\i',
        'Don\'t accept license' => 'PN',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'tID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'tΰW',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => '޲za}',
        'Email address of the system administrator.' => '',
        'Organization' => '´',
        'Log' => '',
        'LogModule' => 'ӼҶ',
        'Log backend to use.' => '',
        'LogFile' => '',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Web e',
        'Default language' => '',
        'Default language.' => '',
        'CheckMXRecord' => 'ˬd MX O',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => '',

        # Template: Login
        'JavaScript Not Available' => '',
        'Browser Warning' => '',
        'The browser you are using is too old.' => '',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '',
        'Please see the documentation or ask your admin for further information.' => '',
        'Lost your password?' => 'ѰOKX?',
        'Request New Password' => '',
        'Back to login' => '',

        # Template: Motd
        'Message of the Day' => '',

        # Template: NoPermission
        'Insufficient Rights' => '',
        'Back to the previous page' => '',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => '}',

        # Template: PrintHeader
        'printed by' => 'L',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS խ',
        'Welcome %s' => 'w %s',
        'Counter' => 'pƾ',

        # Template: Warning
        'Go back to the previous page' => '',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attribrutes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => ' <-> ^_',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repositoriy, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Email a}',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'p',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => '',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => ' <-> ',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Search Ticket' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'ɭDD.',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'pGȤoeF Ticket ^_AåBڬO Ticket Ҧ.',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => '',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets vT! zTwnϥγoӭp?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'qLgרˬdιLqlla}MXOCzOTRSbJCt̡AФnϥCheckMXRecord!',
        '(Email of the system admin)' => '(tκ޲zla})',
        '(Full qualified domain name of your system)' => '(tΰW)',
        '(Logfile just needed for File-LogModule!)' => '(E File-LogModule ɤ~ݭn Logfile!)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '`GoMzw˦hְʺAHiHϥ',
        '(Note: Useful for big databases and low performance server)' => '`GAΩjƾڮwMCʯ઺AȾ',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(tμѲ. Ticket sM http |ܳHoӼѲŶ}Y)',
        '(Used default language)' => '(ϥίʬٻy)',
        '(Used log backend)' => 'ϥΤӦZ',
        '(Used ticket number format)' => '(ϥ Ticket s榡)',
        'A article should have a title!' => '峹D!',
        'A message must be spell checked!' => 'gLgˬd!',
        'A message should have a To: recipient!' => 'l󥲶H!',
        'A message should have a body!' => 'l󥲶]te!',
        'A message should have a subject!' => 'l󥲶D!',
        'A required field is:' => 'rqO',
        'A web calendar' => 'Web ',
        'A web file manager' => 'Web ޲z',
        'A web mail client' => 'WebMail Ȥ',
        'Absolut Period' => 'P',
        'Add Customer User' => 'W[ȤH',
        'Add System Address' => 'W[tζla}',
        'Add User' => 'W[H',
        'Add a new Agent.' => 'W[@ӷsH',
        'Add a new Customer Company.' => 'W[ȤH',
        'Add a new Group.' => 'W[@ӷs',
        'Add a new Priority.' => 'W[@ӷsuv',
        'Add a new Role.' => 'sW@Ө',
        'Add a new SLA.' => 'sW@ӪAȯŧOĳ(SLA).',
        'Add a new Salutation.' => 'W[@ӷs٩Iy',
        'Add a new Service.' => 'sW@ӪA',
        'Add a new Signature.' => 'sW@ñW',
        'Add a new State.' => 'W[@ӷsA',
        'Add a new System Address.' => 'W[@ӷstζla}.',
        'Add a new Type.' => 'W[@ӷs',
        'Add note to ticket' => 'W[`Ѩ Ticket',
        'Added User "%s"' => 'W[Τ "%s".',
        'Admin-Area' => '޲zϰ',
        'Admin-Password' => '޲zKX',
        'Admin-User' => '޲z',
        'Agent Mailbox' => '޳NHlc',
        'Agent Preferences' => 'ӤH]m',
        'Agent based' => '޳NN',
        'Agent-Area' => '޳NH',
        'All Agent variables.' => 'Ҧ޳NHܶq',
        'All Agents' => 'Ҧ޳NH',
        'All Customer variables like defined in config option CustomerUser.' => 'ҦȤܶqiHbtmﶵCustomerUserwq',
        'All customer tickets.' => 'ӫȤҦ Tickets O.',
        'All email addresses get excluded on replaying on composing and email.' => 'ҦQgl\઺la}',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'ҦoeӦHNQҿܪC',
        'All messages' => 'Ҧ',
        'All new tickets!' => 'Ҧstickets',
        'All tickets' => 'ҦTicket',
        'All tickets where the reminder date has reached!' => 'Ҧw촣Ticket',
        'All tickets which are escalated!' => 'ҦɯŪtickets',
        'Allocate CustomerUser to service' => 'ȤA',
        'Allocate services to CustomerUser' => 'tAȵȤ',
        'Answer' => '^_',
        'Article Type' => 'ArticleO ',
        'Article filter settings' => 'Article Lo]m',
        'Attach' => '',
        'Attribute' => 'ݩ',
        'Auto Response From' => '۰ʦ^_Ӧ',
        'Auto Responses <-> Queue' => '۰ʦ^_ <-> C',
        'Bounce ticket' => '^h Ticket ',
        'Can not create link with %s!' => 'ର %s Ыسs',
        'Can not delete link with %s!' => 'R %s s',
        'Can\'t update password, invalid characters!' => 'LksKXA]tLĦr.',
        'Can\'t update password, must be at least %s characters!' => 'LksKXAKXצܤ%s.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'LksKXAܤ֥]t2ӤjgrũM2Ӥpgr.',
        'Can\'t update password, needs at least 1 digit!' => 'LksKXAܤ֥]t1Ʀr',
        'Can\'t update password, needs at least 2 characters!' => 'LksKXAܤ֥]t2Ӧr!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'KX⦸šALksAЭsJ',
        'Category Tree' => 'ؿ',
        'Change %s settings' => 'ק %s ]m',
        'Change Times' => 'ܮɶ',
        'Change free text of ticket' => 'ק Ticket B~H',
        'Change owner of ticket' => 'ק Ticket Ҧ',
        'Change priority of ticket' => 'վ Ticket u',
        'Change responsible of ticket' => ' Ticket tdH',
        'Change user <-> group settings' => 'ק Τ <->  ]m',
        'ChangeLog' => 'ܰO',
        'Child-Object' => 'lH',
        'Clear From' => 'm',
        'Clear To' => 'M',
        'Click here to report a bug!' => 'Io̳i@ Bug!',
        'Close Times' => 'ɶ',
        'Close ticket' => ' Ticket',
        'Close type' => '',
        'Close!' => '!',
        'Collapse View' => '|',
        'Comment (internal)' => '` ()',
        'CompanyTickets' => 'qTickets',
        'Compose Answer' => 'g_',
        'Compose Email' => 'g Email',
        'Compose Follow up' => 'gܵ_',
        'Config Options' => 'tmﶵ',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'tmﶵ (Ҧp: <OTRS_CONFIG_HttpType>)',
        'Contact customer' => 'ptȤ',
        'Create Times' => 'Ыخɶ',
        'Create new Phone Ticket' => 'Ыطsq Ticket',
        'Create new database' => 'Ыطsƾڮw',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'ЫطsըӱPsv',
        'CreateTicket' => 'Ы Ticket',
        'Customer Move Notify' => 'Ticket ʫȤq',
        'Customer Owner Notify' => 'ȤҦ̳qi',
        'Customer State Notify' => 'Ticket AȤq',
        'Customer User' => 'ȤΤ',
        'Customer User Management' => 'ȤΤ޲z',
        'Customer Users' => 'ȤΤ',
        'Customer Users <-> Groups' => 'ȤΤ <-> ',
        'Customer Users <-> Groups Management' => 'ȤΤ <->  ޲z',
        'Customer Users <-> Services' => 'Ȥb <-> AȺ޲z',
        'Customer Users <-> Services Management' => 'Ȥb <-> AȺ޲z',
        'Customer history' => 'Ȥvp',
        'Customer history search' => 'Ȥvj',
        'Customer history search (e. g. "ID342425").' => 'jȤv (ҦpG "ID342425").',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'ȤΤᥲ@ӽ㸹qȤnnt.',
        'CustomerUser' => 'ȤΤ',
        'D' => '',
        'DB Admin Password' => 'ƾڨtκ޲zKX',
        'DB Admin User' => 'ƾڮw޲zΤW',
        'DB Host' => 'ƾڮwD',
        'DB Type' => 'ƾڮw',
        'DB connect host' => 'ƾڳsD',
        'Days' => '',
        'Default' => 'ʬ',
        'Default Charset' => 'ʬ٦rŶ',
        'Default Language' => 'ʬٻy',
        'Delete old database' => 'R¼ƾڮw',
        'Detail' => 'Ӹ`',
        'Diff' => '',
        'Discard all changes and return to the compose screen' => 'Ҧק,^켶g',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'pGzQھ X-Headers eӹLoAiHϥΥWhF.',
        'Do you really want to delete this Object?' => 'zO_T{RӹH?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'zO_Ʀnsw˳oǳn] (Ҧu]mN|)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'nѰOW[@ӥΤթM!',
        'Don\'t forget to add a new user to groups!' => 'nѰOW[sΤ!',
        'Download Settings' => 'U]m',
        'Download all system config changes.' => 'UҦtΰtmܤ.',
        'Drop Database' => 'Rƾڮw',
        'Dynamic-Object' => 'ʺAH',
        'Edit Article' => 'sH',
        'Edit default services.' => 'sq{A',
        'Email based' => 'ql',
        'Escalation' => 'վ',
        'Escalation - First Response Time' => 'Ƚդ - ^_ɶ',
        'Escalation - Solution Time' => 'Ƚդ - ѨMɶ',
        'Escalation - Update Time' => 'Ƚդ - sɶ',
        'Escalation Times' => 'ɯŮɶ',
        'Escalation time' => 'ɵ_ɶ',
        'Event is required!' => 'ݭnƥ',
        'Expand View' => 'i}',
        'Explanation' => '',
        'Export Config' => 'ɥXtm',
        'FileManager' => '޲z',
        'Filelist' => 'M',
        'Filtername' => 'LoW',
        'Follow up' => 'i',
        'Follow up notification' => 'ܳq',
        'For very complex stats it is possible to include a hardcoded file.' => 'D`_έpi]A@ӵwsX',
        'Frontend' => 'eݬɭ',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => '峹j (Ҧp: "Mar*in" Ϊ "Baue*")',
        'General Catalog' => '`ؿ',
        'Go' => '',
        'Group Ro' => 'Ūv',
        'Group based' => 'ժ',
        'Group selection' => 'ܲ',
        'Hash' => 'Hash',
        'Have a lot of fun!' => 'Have a lot of fun!',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwq@tCȡCAiܤ@өΨӦ]CMZziHܤݩʡCCݩʱNܬ@ȡCpGzܥݩ, zͦ@ӲέpɭԩҦݩʱNQϥΡCåB@ӷsݩʳQsWtm',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwqxbCziHܪ@Ӧ]qLsCpGASܡAҦݩʱNQϥηzͦ@ӲέpɭԡCåB@ӷsݩʳQsWtm',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'bo̡AziHwqxbCziHܪ@Ӧ]qLsCMZAAܸӤөΨӥHWݩʡCpGzܥݩ, zͦ@ӲέpɭԩҦݩʱNQϥΡCåB@ӷsݩʳQsWtm',
        'Here you can insert a description of the stat.' => 'ziHJέpyz',
        'Here you can select the dynamic object you want to use.' => 'ziHܱzݭnϥΪʺAH',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'pGҰʼҦSQҰʡAгqLtγ]mҰʥ]zOTRS{ǤwgB',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'pG@ӷswsXsbAiݩʱNܡAziHܨ䤤@',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'pG Ticket wgBAAӫȤNoeF@Ӹi TicketAo Ticket N|Q[AөҦ̳QwqөҦ',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'ӶCܳWwɶSQBz Ticket',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'pG޳NHwF Ticket,Ob@wɶS^_A Ticket N|Q۰ʸAӹҦ޳NHi.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'pGܡAhӲըSv (ӲյLkBz Ticket)',
        'If you need the sum of every column select yes.' => 'pݭnCC`Mܡyes',
        'If you need the sum of every row select yes' => 'pݭnC檺`M yes',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'pGzRegExpAz]ϥΤǰtin () as [***] in \'Set\'',
        'Image' => 'Ϥ',
        'Important' => 'n',
        'In this form you can select the basic specifications.' => 'HoاΦAziHܰ򥻳WS',
        'Information about the Stat' => 'έpH',
        'Insert of the common specifications' => 'J@PWS',
        'Is Job Valid' => 'u@',
        'Is Job Valid?' => 'u@O_?',
        'It\'s useful for ASP solutions.' => 'oO@ӦĪΪAȴѰ(ASP)ѨM.',
        'It\'s useful for a lot of users and groups.' => 'jqΤMժɭԡAD`AX.',
        'Job-List' => 'u@C',
        'Keyword' => 'r',
        'Keywords' => 'r',
        'Last update' => '̦Zs',
        'Link to Parent' => 'XèW@',
        'Linked as' => 'ws',
        'Load' => '[',
        'Load Settings' => '[]m',
        'Logfile' => 'Ӥ',
        'Logfile too large, you need to reset it!' => 'ӤLj, Aݭnm',
        'Login failed! Your username or password was entered incorrectly.' => 'nѡAzΤWαKXT.',
        'Mail Management' => 'l]m',
        'Mailbox' => 'lc',
        'Match' => 'ǰt',
        'Message for new Owner' => 'Ҧ̪',
        'Message sent to' => 'oe',
        'Misc' => 'X',
        'Modified' => 'ק',
        'Move notification' => 'ʳq',
        'Multiple selection of the output format.' => 'X榡hؿ',
        'My Queue' => 'ڪC',
        'MyTickets' => 'ڪ Tickets',
        'Name is required!' => 'ݭnW!',
        'New Agent' => 's޳NH',
        'New Customer' => 'sȤ',
        'New Group' => 's',
        'New Group Ro' => 'sŪv',
        'New Priority' => 'su',
        'New SLA' => 'sAȯŧOĳ(SLA)',
        'New Service' => 'sAȯŧO',
        'New State' => 'sA',
        'New Ticket Lock' => 's Ticket ',
        'New Title' => 'sD',
        'New Type' => 's',
        'New account created. Sent Login-Account to %s.' => 'sbwЫ, ñHeq %s.',
        'New messages' => 's',
        'New password again' => '_sKX',
        'Next Week' => 'UP',
        'No * possible!' => 'iϥγqt "*" !',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'bu귽Sn]ݭnج[ALج[һݳn]',
        'No Packages or no new Packages in selected Online Repository!' => 'bҿ諸bu귽AS{sηsn]',
        'No Permission' => 'Lv',
        'No change time settings.' => 'ܮɶ]m',
        'No means, send agent and customer notifications on changes.' => 'ܮɤoeq޳NHΫȤ.',
        'No time settings.' => 'Lɶ.',
        'Note' => '`',
        'Note Text' => '`',
        'Notification (Event)' => 'q]ƥ^',
        'Notifications' => 'tγq',
        'OTRS DB Name' => 'ƾڮwW',
        'OTRS DB Password' => 'OTRS ΤKX',
        'OTRS DB User' => 'OTRS ƾڮwΤW',
        'OTRS DB connect host' => 'OTRS ƾڮwD',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'pG Ticket QʡAtαN|oe@ӳql󵹫Ȥ',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'pG Ticket Ҧ̧ܡAtαN|oeql󵹫Ȥ.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'pG Ticket AܡAtαN|oeql󵹫Ȥ',
        'Object already linked as %s.' => 'Hws %s.',
        'Of couse this feature will take some system performance it self!' => 'M, ӥ\|Τ@wtθ귽, [tΪt!',
        'Open Tickets' => '} Tickets',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'eȤΤH (Ҧp: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'eȤHiﶵ (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'ʧ@ШD̫H (Ҧp: <OTRS_CURRENT_UserFirstname>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'iΪ Ticket H (Ҧp: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Order' => '',
        'Other Options' => 'Lﶵ',
        'Out Of Office' => 'b줽',
        'POP3 Account Management' => 'POP3 b޲z',
        'Package' => 'n]',
        'Param 1' => 'Ѽ 1',
        'Param 2' => 'Ѽ 2',
        'Param 3' => 'Ѽ 3',
        'Param 4' => 'Ѽ 4',
        'Param 5' => 'Ѽ 5',
        'Param 6' => 'Ѽ 6',
        'Parent-Object' => 'H',
        'Password is already in use! Please use an other password!' => 'ӱKXQϥΡAШϥΨLKX!',
        'Password is already used! Please use an other password!' => 'ӱKXQϥΡAШϥΨLKX!',
        'Passwords doesn\'t match! Please try it again!' => 'KXšAЭ!',
        'Pending Times' => 'ݩwɶ',
        'Pending messages' => 'JݪA',
        'Pending type' => 'ݳBz',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'v]mCziHܤ@өΦhӹAP޳NNiݨӰtmέp',
        'Permissions to change the ticket owner in this group/queue.' => 'bӲ/Cק Tickets Ҧ̪v.',
        'PhoneView' => 'qܵ',
        'Please contact your admin' => 'pttκ޲z',
        'PostMaster Filter' => 'l󤺮eLo',
        'PostMaster Mail Account' => 'lb޲z',
        'Prio' => 'u',
        'Problem' => 'D',
        'Queue <-> Auto Responses Management' => 'C <-> ۰ʦ^_޲z',
        'Queue ID' => 'Cs',
        'Queue Management' => 'C޲z',
        'QueueView' => 'C',
        'QuickSearch' => 'ֳtj',
        'Realname' => 'umW',
        'Rebuild' => 'sc',
        'Recipients' => 'H',
        'Refresh' => 's',
        'Reminder' => '',
        'Reminder messages' => '',
        'Required Field' => 'rq',
        'Response Management' => '^_e޲z',
        'Responses <-> Attachments Management' => '^_ <-> ޲z',
        'Responses <-> Queue' => '^_ <-> C',
        'Responses <-> Queue Management' => '^_ <-> C޲z',
        'Return to the compose screen' => '^켶g',
        'Role' => '',
        'Roles <-> Groups Management' => ' <-> պ޲z',
        'Roles <-> Users' => ' <-> Τ',
        'Roles <-> Users Management' => ' <-> Τ޲z',
        'Save Job as?' => 'Osu@?',
        'Save Search-Profile as Template?' => 'NjOsҪO',
        'Schedule' => 'w',
        'Search Result' => 'jG',
        'Search for' => 'j',
        'Secure Mode need to be enabled!' => 'wҦݭnҰ',
        'Select Box' => 'ܤ',
        'Select Box Result' => 'dߵG',
        'Select Source (for add)' => 'ܼƾڷ(W[\ϥ)',
        'Select the element, which will be used at the X-axis' => 'ܱNΦbxb',
        'Select the restrictions to characterise the stat' => 'ܭѼơAϲέpS',
        'Select the role:user relations.' => ' :Τ p.',
        'Select the user:group permissions.' => ' Τ: v.',
        'Select your QueueView refresh time.' => 'CϨsɶ.',
        'Select your default spelling dictionary.' => 'ʬ٫gˬdr.',
        'Select your frontend Charset.' => 'ɭrŶ.',
        'Select your frontend QueueView.' => 'C.',
        'Select your frontend language.' => 'ɭy',
        'Select your out of office time.' => 'ܧAb줽Ǫɶ',
        'Select your screen after creating a new ticket.' => 'ܱzЫطs Ticket ZAܪ.',
        'Selection needed' => 'ܻݭn',
        'Send Notification' => 'oeq',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'ک`ticketAticket֦H@ˡAڤ]o@q',
        'Send no notifications' => 'oeq',
        'Sent new password to: %s' => 'oesKX: %s',
        'Sent password token to: %s' => 'oeKX: %s',
        'Sessions' => '|',
        'Set customer user and customer id of a ticket' => ']m Ticket ݫȤΤ',
        'Show' => '',
        'Site' => 'I',
        'Solution' => 'ѨM',
        'Sort by' => 'Ƨ',
        'Source' => 'ƾڷ',
        'Spell Check' => 'gˬd',
        'Split' => '',
        'State Type' => 'A',
        'Static-File' => 'RA',
        'Stats-Area' => 'έp',
        'Sub-Queue of' => 'lC',
        'Sub-Service of' => 'lAݩ',
        'Subscribe' => 'q',
        'Symptom' => 'g',
        'System History' => 'tξv',
        'System State Management' => 'tΪA޲z',
        'Systemaddress' => 'tζla}',
        'The message being composed has been closed.  Exiting.' => 'igfwgQ,hX.',
        'This account exists.' => 'oӱbwsb',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'oOD`ΪApGAQHoέpGβέpGä',
        'This values are read only.' => 'ӼƾڰŪ.',
        'This values are required.' => 'ӱإg.',
        'This window must be called from compose window' => 'ӵfѼgfե',
        'Ticket Escalation View' => 'վd Ticket',
        'Ticket Lock' => 'Ticket ꪬA',
        'Ticket Number Generator' => 'Ticket sͦ',
        'Ticket Search' => 'Ticket j',
        'Ticket Status View' => 'Ticket A',
        'Ticket Type is required!' => 'Ticket O!',
        'Ticket escalation!' => 'Ticket ɳBz!',
        'Ticket locked!' => 'Ticket Qw!',
        'Ticket owner options (e. g. <OTRS_OWNER_USERFIRSTNAME>)' => 'iΪ Ticket kݤHH (Ҧp: <OTRS_OWNER_USERFIRSTNAME>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Ticket Ҧ̿ﶵ (Ҧp: <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Ticket֦̪iﶵ e. g. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Ticketdﶵ (e. g. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Q襤iqާ@ Tickets',
        'Ticket unlock!' => ' Ticket!',
        'Ticket-Area' => 'Ticket',
        'TicketFreeText' => 'Ticket B~H',
        'TicketZoom' => 'Ticket i}',
        'Tickets available' => 'i Ticket',
        'Tickets shown' => ' Ticket',
        'Tickets which need to be answered!' => 'ݭn^ Ticket',
        'Timeover' => '',
        'Times' => 'ɶ',
        'Title of the stat.' => 'έpD',
        'Today' => '',
        'Tomorrow' => '',
        'Top of Page' => '',
        'Total hits' => 'I',
        'U' => 'ɧ',
        'Unable to parse Online Repository index document!' => 'Cbu귽ޤ',
        'Uniq' => '@',
        'Unlock Tickets' => ' Tickets',
        'Unsubscribe' => 'hq',
        'Use utf-8 it your database supports it!' => 'pGzƾڮwAϥUTF-8rŽsX!',
        'Useable options' => 'iΧܶq',
        'User Management' => 'H޲z',
        'User will be needed to handle tickets.' => 'ݭnΤӳBz Tickets.',
        'Users' => 'Τ',
        'Users <-> Groups' => 'Τ <-> ',
        'Users <-> Groups Management' => 'Τ <-> պ޲z',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'ĵi!  Ticket N|qƾڮwRALk_!',
        'Watch notification' => '`q',
        'Web-Installer' => 'WEB w˦V',
        'WebMail' => 'WebMail',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'εLĪέpiͦέp',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'qLJMܦrqAziHzݨDӰtmέpCziHקs診ǲέpnѱzέpƺ޲zӳ]mC',
        'Yes means, send no agent and customer notifications on changes.' => 'ܮɤoeq޳NHΫȤ.',
        'Yes, save it with name' => 'O, OsW',
        'You got new message!' => 'zs!',
        'You have to select two or more attributes from the select field!' => 'AqҿrqܨөΨӥHWݩ',
        'You need a email address (e. g. customer@example.com) in To:!' => 'HHOla}(ҦpGcustomer@example.com)',
        'You need min. one selected Ticket!' => 'zܤֻݭnܤ@ Ticket!',
        'You need to account time!' => 'zݭnOɶ',
        'You need to activate %s first to use it!' => '%s bϥΤeХE!',
        'Your email address is new' => 'zla}Os',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'zl s: "<OTRS_TICKET>" ^h "<OTRS_BOUNCE_TO>" . ptHUa}ԲӫH.',
        'Your own Ticket' => 'zۤv Ticket',
        'customer realname' => 'ȤumW',
        'down' => 'U',
        'false' => '',
        'for agent firstname' => '޳NH W',
        'for agent lastname' => '޳NH W',
        'for agent login' => '޳NH nW',
        'for agent user id' => '޳NH ΤW',
        'kill all sessions' => 'Ҧ|',
        'kill session' => 'פ|',
        'maximal period form' => '̤jP',
        'modified' => 'ק',
        'new ticket' => 's Ticket',
        'next step' => 'U@B',
        'not rated' => '',
        'send' => 'oe',
        'sort downward' => 'fǱƧ',
        'sort upward' => 'ǱƧ',
        'to get the first 20 character of the subject' => 'lDe20Ӧr',
        'to get the first 5 lines of the email' => 'l󥿤e5',
        'to get the from line of the email' => 'lӦ',
        'to get the realname of the sender (if given)' => 'loeHumW (pGsb)',
        'up' => 'W',
        'utf8' => 'UTF-8',

    };
    # $$STOP$$
    return;
}

1;
