# --
# Kernel/Language/sr_Latn.pm - provides Serbian language Latin translation
# Copyright (C) 2001-2010 OTRS AG, http://otrs.org/
# Copyright (C) 2010 Milorad Jovanovi <j.milorad at gmail.com>
# --
# $Id: sr_Latn.pm,v 1.4 2010/11/12 14:56:16 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --
package Kernel::Language::sr_Latn;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2010-11-12 14:48:53

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Da',
        'No' => 'Ne',
        'yes' => 'da',
        'no' => 'ne',
        'Off' => 'Iskljueno',
        'off' => 'iskljueno',
        'On' => 'Ukljueno',
        'on' => 'ukljueno',
        'top' => 'vrh',
        'end' => 'kraj',
        'Done' => 'Gotovo',
        'Cancel' => 'Odustani',
        'Reset' => 'Poniti',
        'last' => 'poslednje',
        'before' => 'pre',
        'day' => 'dan',
        'days' => 'dani',
        'day(s)' => 'dan(i)',
        'hour' => 'sat',
        'hours' => 'sati',
        'hour(s)' => 'sat(i)',
        'Hours' => '',
        'minute' => 'minut',
        'minutes' => 'minuti',
        'minute(s)' => 'minut(i)',
        'Minutes' => '',
        'month' => 'mesec',
        'months' => 'meseci',
        'month(s)' => 'mesec(i)',
        'week' => 'sedmica',
        'week(s)' => 'sedmic(e)',
        'year' => 'godina',
        'years' => 'godine',
        'year(s)' => 'godin(e)',
        'second(s)' => 'sekund(e)',
        'seconds' => 'sekunde',
        'second' => 'sekunda',
        'wrote' => 'napisao',
        'Message' => 'Poruka',
        'Error' => 'Greka',
        'Bug Report' => 'Prijava greke',
        'Attention' => 'Panja',
        'Warning' => 'Upozorenje',
        'Module' => 'Modul',
        'Modulefile' => 'Datoteka modula',
        'Subfunction' => 'Podfunkcija',
        'Line' => 'Linija',
        'Setting' => 'Podeavanje',
        'Settings' => 'Podeavanja',
        'Example' => 'Primer',
        'Examples' => 'Primeri',
        'valid' => 'vaei',
        'invalid' => 'nevaei',
        '* invalid' => '* nevaei',
        'invalid-temporarily' => 'nevaei-privremeno',
        ' 2 minutes' => ' 2 minuta',
        ' 5 minutes' => ' 5 minuta',
        ' 7 minutes' => ' 7 minuta',
        '10 minutes' => '10 minuta',
        '15 minutes' => '15 minuta',
        'Mr.' => 'Gospodin',
        'Mrs.' => 'Gospoa',
        'Next' => 'Sledee',
        'Back' => 'Nazad',
        'Next...' => 'Sledee...',
        '...Back' => '...Nazad',
        '-none-' => '-nijedan-',
        'none' => 'nijedan',
        'none!' => 'nema unosa!',
        'none - answered' => 'nema - odgovoreno',
        'please do not edit!' => 'Molimo, ne menjajte!',
        'Need Action' => 'Potrebna akcija',
        'AddLink' => 'Dodaj vezu',
        'Link' => 'Povei',
        'Unlink' => 'Prekini vezu',
        'Linked' => 'Povezano',
        'Link (Normal)' => 'Veza (Normalno)',
        'Link (Parent)' => 'Veza (Roditelj)',
        'Link (Child)' => 'Veza (Dete)',
        'Normal' => 'Normalno',
        'Parent' => 'Roditelj',
        'Child' => 'Dete',
        'Hit' => 'Pogodak',
        'Hits' => 'Pogotci',
        'Text' => 'Tekst',
        'Standard' => 'Normalan',
        'Lite' => 'Jednostavan',
        'User' => 'Korisnik',
        'Username' => 'Korisniko ime',
        'Language' => 'Jezik',
        'Languages' => 'Jezici',
        'Password' => 'Lozinka',
        'Preferences' => 'Podeavanja',
        'Salutation' => 'Pozdrav',
        'Salutations' => 'Pozdravi',
        'Signature' => 'Potpis',
        'Signatures' => 'Potpisi',
        'Customer' => 'Korisnik',
        'CustomerID' => 'ID korisnika',
        'CustomerIDs' => 'ID korisnika',
        'customer' => 'korisnik',
        'agent' => 'Zaposleni',
        'system' => 'Sistem',
        'Customer Info' => 'Korisniki info',
        'Customer Information' => 'Informacije o korisniku',
        'Customer Company' => 'Korisnikova firma',
        'Customer Companies' => 'Korisnikove firme',
        'Company' => 'Firma',
        'go!' => 'Start!',
        'go' => 'Start',
        'All' => 'Sve',
        'all' => 'sve',
        'Sorry' => 'Izvinite',
        'update!' => 'auriranje!',
        'update' => 'auriranje',
        'Update' => 'Auriranje',
        'Updated!' => 'Aurirano!',
        'submit!' => 'poalji!',
        'submit' => 'poalji',
        'Submit' => 'Poalji',
        'change!' => 'promena!',
        'Change' => 'Promena',
        'change' => 'promena',
        'click here' => 'kliknite ovde',
        'Comment' => 'Komentar',
        'Valid' => 'Vaei',
        'Invalid Option!' => 'Nevaea opcija!',
        'Invalid time!' => 'Nevaee vreme!',
        'Invalid date!' => 'Nevaei datum!',
        'Name' => 'Ime',
        'Group' => 'Grupa',
        'Description' => 'Opis',
        'description' => 'opis',
        'Theme' => 'ema',
        'Created' => 'Kreirano',
        'Created by' => 'kreirao',
        'Changed' => 'Izmenjeno',
        'Changed by' => 'Menjao',
        'Search' => 'Trai',
        'and' => 'i',
        'between' => 'izmeu',
        'Fulltext Search' => 'Tekst za pretragu',
        'Data' => 'Podaci',
        'Options' => 'Opcije',
        'Title' => 'Naslov',
        'Item' => 'Stavka',
        'Delete' => 'Izbrisati',
        'Edit' => 'Menjati',
        'View' => 'Pregled',
        'Number' => 'Broj',
        'System' => 'Sistem',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakti',
        'Export' => 'Izvoz',
        'Up' => 'Gore',
        'Down' => 'Dole',
        'Add' => 'Dodati',
        'Added!' => 'Dodano!',
        'Category' => 'Kategorija',
        'Viewer' => 'Prikaziva',
        'Expand' => 'Proiri',
        'Small' => 'Sitno',
        'Medium' => 'Srednje',
        'Large' => 'Krupno',
        'Date picker' => 'Izbor datuma',
        'New message' => 'Nova poruka',
        'New message!' => 'Nova poruka!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Molimo vas da odgovorite na ovaj tiket da bi ste se vratili na normalan pregled reda!',
        'You have %s new message(s)!' => 'Imate %s novih poruka!',
        'You have %s reminder ticket(s)!' => 'Imate %s Tiketa podsetnika!',
        'The recommended charset for your language is %s!' => 'Preporueni karakterset za va jezik je %s!',
        'Change your password.' => 'Promenite lozinku.',
        'Please activate %s first!' => 'Molimo, prvo aktivirajte %s.',
        'No suggestions' => 'Nema sugestija',
        'Word' => 're',
        'Ignore' => 'Zanemari',
        'replace with' => 'zameni sa',
        'There is no account with that login name.' => 'Ne postoji nalog sa tim korisnikim imenom.',
        'Login failed! Your user name or password was entered incorrectly.' => 'Neuspena prijava! Netano je uneto vae korisniko ime ili lozinka.',
        'There is no acount with that user name.' => 'Nema naloga sa tim korisnikim imenom',
        'Please contact your administrator' => 'Molimo kontaktirajte vaeg administratora',
        'Logout' => 'Odjava',
        'Logout successful. Thank you for using OTRS!' => 'Uspeno ste se odjavili! Hvala to ste koristili OTRS!',
        'Invalid SessionID!' => 'Neispravan ID sesije!',
        'Feature not active!' => 'Funkcija nije aktivna!',
        'Agent updated!' => '',
        'Create Database' => 'Kreiraj bazu',
        'System Settings' => 'Sistemska podeavanja',
        'Mail Configuration' => '',
        'Finished' => 'Zareno',
        'Login is needed!' => 'Potrebna je prijava!',
        'Password is needed!' => 'Potrebna je lozinka!',
        'License' => 'Licenca',
        'Take this Customer' => 'Uzmi ovog korisnika',
        'Take this User' => 'Uzmi ovog korisnika sistema',
        'possible' => 'mogue',
        'reject' => 'odbaci',
        'reverse' => 'obrnuto',
        'Facility' => 'Instalacija',
        'Time Zone' => 'Vremenska zona',
        'Pending till' => 'eka do',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Molimo da ne koristite "UserID 1" (Sistemski nalog) za rad! Napravite nove naloge!',
        'Dispatching by email To: field.' => 'Otprema E-mejlom za: Polje.',
        'Dispatching by selected Queue.' => 'Otprema kroz izabrani red.',
        'No entry found!' => 'Unos nije pronaen!',
        'Session has timed out. Please log in again.' => 'Vreme sesije je isteklo. Molimo prijavite se ponovo.',
        'No Permission!' => 'Nemate dozvolu!',
        'To: (%s) replaced with database email!' => 'Za: (%s) zamenjeno E-mejl adresom iz baze!',
        'Cc: (%s) added database email!' => 'Kk: (%s) dodana E-mejl adresa iz baze!',
        '(Click here to add)' => '(Klikni ovde za dodavanje)',
        'Preview' => 'Pregled',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paket nije korektno instaliran! Trebalo bi ga da ponovo instalirate!',
        '%s is not writable!' => 'Ne moe se upisivati na %s!',
        'Cannot create %s!' => 'Ne moe se kreirati %s!',
        'Customer %s added' => 'Dodan korisnik %s.',
        'Role added!' => 'Dodana uloga!',
        'Role updated!' => '',
        'Attachment added!' => '',
        'Attachment updated!' => '',
        'Response added!' => '',
        'Response updated!' => '',
        'Group updated!' => '',
        'Queue added!' => '',
        'Queue updated!' => '',
        'State added!' => '',
        'State updated!' => '',
        'Type added!' => '',
        'Type updated!' => '',
        'Customer updated!' => '',
        'Contract' => 'Ugovor',
        'Online Customer: %s' => 'Korisnik na vezi: %s',
        'Online Agent: %s' => 'Zaposleni na vezi: %s',
        'Calendar' => 'Kalendar',
        'File' => 'Datoteka',
        'Filename' => 'Naziv datoteke',
        'Type' => 'Tip',
        'Size' => 'Veliina',
        'Upload' => 'Otpremanje',
        'Directory' => 'Imenik',
        'Signed' => 'Potpisano',
        'Sign' => 'Potpis',
        'Crypted' => 'ifrovano',
        'Crypt' => 'ifra',
        'PGP' => '"PGP"',
        'PGP Key' => '"PGP" Klju',
        'PGP Keys' => '"PGP" kljuevi',
        'S/MIME' => '"S/MIME" klju',
        'S/MIME Certificate' => '"S/MIME" Sertifikat',
        'S/MIME Certificates' => '"S/MIME" Sertifikati',
        'Office' => 'Kancelarija',
        'Phone' => 'Telefon',
        'Fax' => 'Faks',
        'Mobile' => 'Mobilni',
        'Zip' => 'PB',
        'City' => 'Mesto',
        'Street' => 'Ulica',
        'Country' => 'Drava',
        'Location' => 'Lokacija',
        'installed' => 'instalirano',
        'uninstalled' => 'deinstalirano',
        'Security Note: You should activate %s because application is already running!' => 'Bezbednosna preporuka: Trebalo bi da omoguite %s, jer je aplikacija ve pokrenuta!',
        'Unable to parse repository index document.' => 'Nije mogue ralaniti indeks spremita!',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => 'Nema paketa za verziju vaeg sistema, u spremitu su samo paketi za druge verzije.',
        'No packages, or no new packages, found in selected repository.' => 'U izabranom spremitu nema paketa ili nema novih paketa',
        'Edit the system configuration settings.' => '',
        'printed at' => 'tampano u',
        'Loading...' => 'Uitavanje...',
        'Dear Mr. %s,' => 'Potovani gospodine %s,',
        'Dear Mrs. %s,' => 'Potovana gospoo %s,',
        'Dear %s,' => 'Dragi %s,',
        'Hello %s,' => 'Zdravo %s,',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => 'Kreiran novi nalog. Podaci za prijavu poslati %s. Molimo proverite va e-mejl',
        'Please press Back and try again.' => 'Molimo pritisnite Nazad i pokuajte ponovo.',
        'Sent password reset instructions to %s. Please check your email.' => 'Uputstvo za reset lozinke poslato za %s. Molimo proverite va e-mejl.',
        'Sent new password to %s. Please check your email.' => '',
        'Upcoming Events' => 'Predstojei dogaaji',
        'Event' => 'Dogaaj',
        'Events' => 'Dogaaji',
        'Invalid Token!' => 'Neispravna oznaka!',
        'more' => 'jo',
        'For more info see:' => 'Za dodatne informacije pogledaj:',
        'Package verification failed!' => 'Neuspela verifikacija paketa!',
        'Collapse' => 'Smanji',
        'Shown' => 'Prikazan',
        'News' => 'Novosti',
        'Product News' => 'Novosti o proizvodu',
        'OTRS News' => '"OTRS" Novosti',
        '7 Day Stats' => 'Sedmodnevna statistika',
        'Bold' => 'Podebljano',
        'Italic' => 'Kurziv',
        'Underline' => 'Podvueno',
        'Font Color' => 'Boja slova',
        'Background Color' => 'Boja pozadine',
        'Remove Formatting' => 'Ukloni formatiranje',
        'Show/Hide Hidden Elements' => 'Pokai/Sakri skrivene elemente',
        'Align Left' => 'Poravnaj nalevo',
        'Align Center' => 'Centriraj',
        'Align Right' => 'Poravnaj nadesno',
        'Justify' => 'Poravnaj u blok',
        'Header' => 'Naslov',
        'Indent' => 'Uvlaenje',
        'Outdent' => 'Izvlaenje',
        'Create an Unordered List' => 'Napravi nesreenu listu',
        'Create an Ordered List' => 'Napravi sreenu listu',
        'HTML Link' => '"HTML" Veza',
        'Insert Image' => 'Ubaci sliku',
        'CTRL' => '"CTRL"',
        'SHIFT' => '"SHIFT"',
        'Undo' => 'Poniti',
        'Redo' => 'Ponovi',

        # Template: AAAMonth
        'Jan' => 'jan',
        'Feb' => 'feb',
        'Mar' => 'mar',
        'Apr' => 'apr',
        'May' => 'maj',
        'Jun' => 'jun',
        'Jul' => 'jul',
        'Aug' => 'avg',
        'Sep' => 'sep',
        'Oct' => 'okt',
        'Nov' => 'nov',
        'Dec' => 'dec',
        'January' => 'januar',
        'February' => 'februar',
        'March' => 'mart',
        'April' => 'april',
        'May_long' => 'maj',
        'June' => 'juni',
        'July' => 'juli',
        'August' => 'avgust',
        'September' => 'septembar',
        'October' => 'oktobar',
        'November' => 'novembar',
        'December' => 'decembar',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Podeavanja su uspeno aurirana!',
        'User Profile' => 'Korisniki profil',
        'Email Settings' => 'E-mejl podeavanja',
        'Other Settings' => 'Druga podeavanja',
        'Change Password' => 'Promena lozinke',
        'Current Password' => 'Sadanja lozinka',
        'New password' => 'Nova lozinka',
        'Verify password' => 'Potvrdi lozinku',
        'Spelling Dictionary' => 'Pravopisni renik',
        'Default spelling dictionary' => 'Podrazumevani pravopisni renik',
        'Max. shown Tickets a page in Overview.' => 'Maksimalni broj tiketa po srani u pregledu.',
        'The current password is not correct. Please try again!' => 'Uneta lozinka je netana. Molimo pokuajte ponovo!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Lozinka ne moe biti aurirana, novi unosi su razliiti. Molimo pokuajte ponovo!',
        'Can\'t update password, it contains invalid characters!' => 'Lozinka ne moe biti aurirana, sadri nedozvoljene znakove.',
        'Can\'t update password, it must be at least %s characters long!' => 'Lozinka ne moe biti aurirana. Minimalna duina lozinke je %s znakova.',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Lozinka ne moe biti aurirana. Mora da sadri bar 2 velika i 2 mala slova.',
        'Can\'t update password, it must contain at least 1 digit!' => 'Lozinka ne moe biti aurirana. Mora da sadri bar jednu brojku.',
        'Can\'t update password, it must contain at least 2 characters!' => 'Lozinka ne moe biti aurirana. Mora da sadri najmanje 2 znaka.',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Lozinka ne moe biti aurirana. Uneta lozinka je ve u upotrebi. Molimo izaberite neku drugu.',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => 'Izaberite rastavni znak koji e se koristi u "CSV" datotekama (statistika i pretrage). Ako ne izaberete rastavni znak ovde, koristie se podrazumevani rastavni znak za va jezik',
        'CSV Separator' => '"CSV" rastavni znak',

        # Template: AAAStats
        'Stat' => 'Statistika',
        'Please fill out the required fields!' => 'Molimo Bas, popunite obavezna polja!',
        'Please select a file!' => 'Molimo Vas da odaberete datoteku!',
        'Please select an object!' => 'Molimo Vas da odaberete objekat!',
        'Please select a graph size!' => 'Molimo Vas da odaberete veliinu grafikona!',
        'Please select one element for the X-axis!' => 'Molimo da izaberete jedan element za X-osu!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Izaberite samo jedan element ili opozovite izbor na oznaci polja \'Fixed\'!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Ako koristite oznake selekcije, morate da izaberete neke atribute selektovanog polja!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => '',
        'The selected end time is before the start time!' => 'Izabrano vreme kraja je pre vremena poetka!',
        'You have to select one or more attributes from the select field!' => '',
        'The selected Date isn\'t valid!' => 'Datum koji ste izabrali nije vaei!',
        'Please select only one or two elements via the checkbox!' => '',
        'If you use a time scale element you can only select one element!' => 'Ukoliko koristite element vremenske skale, moete izabrati samo jedan element!',
        'You have an error in your time selection!' => 'Imate greku u vaem izboru vremena!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Va interval izvetaja je prekratak, molimo upotrebite vei vremenski razmak!',
        'The selected start time is before the allowed start time!' => 'Izabrano vreme poetka je pre dozvoljenog poetnog vremena!',
        'The selected end time is after the allowed end time!' => 'Izabrano vreme kraja je posle dozvoljenog vremena kraja!',
        'The selected time period is larger than the allowed time period!' => 'Izabrani vremenski period je dui od dozvoljenog!',
        'Common Specification' => 'Opte informacije',
        'Xaxis' => 'X-Osa',
        'Value Series' => 'Opsezi',
        'Restrictions' => 'Ogranienja',
        'graph-lines' => 'Linijski grafikon',
        'graph-bars' => 'Stubiati grafikon',
        'graph-hbars' => 'Stubiati grafikon (horizontalno)',
        'graph-points' => 'Takasti grafikon',
        'graph-lines-points' => 'Linijsko-takasti grafikon',
        'graph-area' => 'Oblast grafikona',
        'graph-pie' => 'Grafikon pita',
        'extended' => 'proiren',
        'Agent/Owner' => 'Zaposleni/Vlasnik',
        'Created by Agent/Owner' => 'Otvorio Zaposleni/Vlasnik',
        'Created Priority' => 'Otvoreno sa prioritetom',
        'Created State' => 'Otvoreno sa statusom',
        'Create Time' => 'Vreme otvaranja',
        'CustomerUserLogin' => 'Prijava korisnika',
        'Close Time' => 'Vreme zatvaranja',
        'TicketAccumulation' => 'Ticket-Aufkommen',
        'Attributes to be printed' => 'Atributi za tampu',
        'Sort sequence' => 'Redosled sortiranja',
        'Order by' => 'Sortiraj po',
        'Limit' => 'Ogranienje',
        'Ticketlist' => 'Lista tiketa',
        'ascending' => 'rastui',
        'descending' => 'opadajui',
        'First Lock' => 'Prvo zakljuavanje',
        'Evaluation by' => 'Procenio',
        'Total Time' => 'Ukupno vreme',
        'Ticket Average' => 'Proseno vreme po tiketu',
        'Ticket Min Time' => 'Minimalno vreme tiketa',
        'Ticket Max Time' => 'Maksimalno vreme tiketa',
        'Number of Tickets' => 'Broj tiketa',
        'Article Average' => 'Proseno vreme po lanku',
        'Article Min Time' => 'Minimalno vreme lanka',
        'Article Max Time' => 'Maksimalno vreme lanka',
        'Number of Articles' => 'Broj lanaka',
        'Accounted time by Agent' => 'Obraunato vreme po zaposlenom',
        'Ticket/Article Accounted Time' => 'Obraunato vreme',
        'TicketAccountedTime' => 'Obraunato vreme obrade tiketa',
        'Ticket Create Time' => 'Vreme otvaranja tiketa',
        'Ticket Close Time' => 'Vreme zatvaranja tiketa',

        # Template: AAATicket
        'Status View' => 'Pregled statusa',
        'Bulk' => 'Masovno',
        'Lock' => 'Zakljuaj',
        'Unlock' => 'Otkljuaj',
        'History' => 'Istorijat',
        'Zoom' => 'Sadaj',
        'Age' => 'Starost',
        'Bounce' => 'Preusmeri',
        'Forward' => 'Prosledi',
        'From' => 'Od',
        'To' => 'Za',
        'Cc' => 'Kk',
        'Bcc' => 'Skk',
        'Subject' => 'Predmet',
        'Move' => 'Premesti',
        'Queue' => 'Red',
        'Queues' => 'Redovi',
        'Priority' => 'Prioritet',
        'Priorities' => 'Prioriteti',
        'Priority Update' => 'Auriranje prioriteta',
        'SLA' => '"SLA"',
        'Service Level Agreement' => 'Dogovor o nivou usluge',
        'Service Level Agreements' => 'Dogovori o nivou usluge',
        'Service' => 'Usluga',
        'Services' => 'Usluge',
        'State' => 'Stanje',
        'States' => 'Stanja',
        'Status' => 'Status',
        'Statuses' => 'Statusi',
        'Ticket Type' => 'Tip Tiketa',
        'Ticket Types' => 'Tipovi Tiketa',
        'Compose' => 'Napii',
        'Pending' => 'Na ekanju',
        'Owner' => 'Vlasnik',
        'Owner Update' => 'Auriranje vlasnika',
        'Responsible' => 'Odgovoran',
        'Responsible Update' => 'Auriranje odgovornog',
        'Sender' => 'Poiljaoc',
        'Article' => 'lanak',
        'Ticket' => 'Tiket',
        'Createtime' => 'Vreme kreiranja',
        'plain' => 'neformatirano',
        'Email' => 'E-mejl',
        'email' => 'e-mejl',
        'Close' => 'Zatvori',
        'Action' => 'Akcija',
        'Attachment' => 'Prilog',
        'Attachments' => 'Prilozi',
        'This message was written in a character set other than your own.' => 'Ova poruka je napisana skupom znakova razliitim od onog koji Vi koristite.',
        'If it is not displayed correctly,' => 'Ako nije ispravno prikazano,',
        'This is a' => 'Ovo je',
        'to open it in a new window.' => 'za otvaranje u novom prozoru.',
        'This is a HTML email. Click here to show it.' => 'Ovo je "HTML" e-mejl. Klikni ovde za prikaz.',
        'Free Fields' => 'Slobodna polja',
        'Merge' => 'Spoji',
        'merged' => 'spojeno',
        'closed successful' => 'uspeno zatvaranje',
        'closed unsuccessful' => 'neuspeno zatvaranje',
        'Locked Tickets Total' => '',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'new' => 'novo',
        'open' => 'otvori',
        'Open' => 'Otvori',
        'closed' => 'zatvoreno',
        'Closed' => 'zatvoreno',
        'removed' => 'uklonjeno',
        'pending reminder' => 'podsetnik ekanja',
        'pending auto' => 'automatsko ekanje',
        'pending auto close+' => '',
        'pending auto close-' => '',
        'email-external' => 'E-mejl eksterni',
        'email-internal' => 'E-mejl interni',
        'note-external' => 'Napomena - eksterna',
        'note-internal' => 'Napomena - interna',
        'note-report' => 'Napomena za izvetaj',
        'phone' => '',
        'sms' => '"SMS"',
        'webrequest' => 'Web zahtev',
        'lock' => 'zatvoren',
        'unlock' => 'otvoren',
        'very low' => 'vrlo nizak',
        'low' => 'nizak',
        'normal' => 'normalan',
        'high' => 'visok',
        'very high' => 'vrlo visok',
        '1 very low' => '1 vrlo nizak',
        '2 low' => '2 nizak',
        '3 normal' => '3 normalan',
        '4 high' => '4 visok',
        '5 very high' => '5 vrlo visok',
        'Ticket "%s" created!' => 'Tiket "%s" kreiran!',
        'Ticket Number' => 'Broj tiketa',
        'Ticket Object' => 'Objekat tiketa',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ne postoji tiket broj "%s"! Ne moe se povezati!',
        'Don\'t show closed Tickets' => 'Ne prikazuj zatvorene tikete',
        'Show closed Tickets' => 'Prikai zatvorene tikete',
        'New Article' => 'Novi lanak',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => 'Ukloni sa liste praenih tiketa',
        'Add to list of watched tickets' => 'Dodaj na listu praenih tiketa',
        'Email-Ticket' => 'E-mejl tiket',
        'Create new Email Ticket' => 'Kreira novi E-mejl tiket',
        'Phone-Ticket' => 'Telefonski tiket',
        'Search Tickets' => 'Traenje tiketa',
        'Edit Customer Users' => 'Uredi korisnike',
        'Edit Customer Company' => 'Uredi korisniku firmu',
        'Bulk Action' => 'Masovna akcija',
        'Bulk Actions on Tickets' => 'Masovne akcije na tiketima',
        'Send Email and create a new Ticket' => 'Poanji e-mejl i kreiraj novi tiket',
        'Create new Email Ticket and send this out (Outbound)' => 'Otvori novi e-mejl tiket i poalji ga (odlazni)',
        'Create new Phone Ticket (Inbound)' => 'Kreiraj novi telefonski tiket (dolazni poziv)',
        'Overview of all open Tickets' => 'Pregled svih otvorenih tiketa',
        'Locked Tickets' => 'Zakljuani tiketi',
        'My Locked Tickets' => 'Moji zakljuani tiketi',
        'My Watched Tickets' => '',
        'My Responsible Tickets' => '',
        'Watched Tickets' => 'Posmatrani tiketi',
        'Watched' => 'Posmatrano',
        'Watch' => 'Posmatraj',
        'Unwatch' => 'Prekini posmatranje',
        'Lock it to work on it!' => 'Zakljuaj radi ekskluzivne obrade!',
        'Unlock to give it back to the queue!' => 'Otkljuaj da bi je vratio u red!',
        'Shows the ticket history!' => 'Prikai istorijat tiketa!',
        'Print this ticket!' => 'tampaj ovaj tiket!',
        'Change the ticket priority!' => 'Promeni prioritet tiketa',
        'Change the ticket free fields!' => 'Promeni slobodna polja tiketa',
        'Link this ticket to an other objects!' => 'Povei ovaj tiket sa drugim objektima!',
        'Change the ticket owner!' => 'Promeni vlasnika tiketa!',
        'Change the ticket customer!' => 'Promeni korisnika za tiket!',
        'Add a note to this ticket!' => 'Dodaj napomenu ovom tiketu!',
        'Merge this ticket!' => 'Spoji ovaj tiket!',
        'Set this ticket to pending!' => 'Stavi ovaj tiket na ekanje!',
        'Close this ticket!' => 'Zatvori ovaj tiket!',
        'Look into a ticket!' => 'Pogledaj sadraj tiketa!',
        'Delete this ticket!' => 'Obrii ovaj tiket!',
        'Mark as Spam!' => 'Oznai kao "Spam"!',
        'My Queues' => 'Moji redovi',
        'Shown Tickets' => 'prikazani tiketi',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Va e-mejl sa brojem tiketa "<OTRS_TICKET>" je spojen sa tiketom "<OTRS_MERGE_TO_TICKET>"!',
        'Ticket %s: first response time is over (%s)!' => 'Tiket %s: vreme reakcije je preko (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Tiket %s: vreme reakcije istie za %s!',
        'Ticket %s: update time is over (%s)!' => 'Tiket %s: vreme auriranja je preko (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Tiket %s: vreme auriranja istie za %s!',
        'Ticket %s: solution time is over (%s)!' => 'Tiket %s: vreme reavanja je preko (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Tiket %s: vreme reavanja istie za %s!',
        'There are more escalated tickets!' => 'Ima jo eskaliralih tiketa!',
        'Plain Format' => 'Prost format',
        'Reply All' => 'Odgovori na sve',
        'Direction' => '',
        'New ticket notification' => 'Obavetenje o novom tiketu',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Poalji mi obavetenje za novi tiket u "Mojim Redovima".',
        'Send new ticket notifications' => 'Poalji obavetenja o novim tiketima',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => '',
        'Send me a notification if a ticket is unlocked by the system.' => 'Poalji mi obavetenje ako sistem otkljua tiket.)',
        'Send ticket lock timeout notifications' => 'Poalji obavetenje o isteku zakljuavanja tiketa',
        'Ticket move notification' => 'Obavetenje o pomeranju tiketa',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Poalji mi obavetenje kad se tiket premesti u "Moje Redove".',
        'Send ticket move notifications' => 'Poalji obavetenje o pomeranju tiketa',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => '',
        'Custom Queue' => 'Prilagoen red',
        'QueueView refresh time' => 'Vreme osveavanja reda',
        'If enabled, the QueueView will automatically refresh after the specified time.' => 'Ako je ukljueno, pregled reda e biti osveen posle zadatog vremena.',
        'Refresh QueueView after' => 'Osvei pregled reda posle',
        'Screen after new ticket' => 'Ekran posle otvaranja novog tiketa',
        'Show this screen after I created a new ticket' => 'Prikai ovaj ekran pole otvaranja novog tiketa',
        'Closed Tickets' => 'Zatvoreni tiketi',
        'Show closed tickets.' => 'Prikai zatvorene tikete.',
        'Max. shown Tickets a page in QueueView.' => 'Maksimalni broj prikazanih tiketa u pregledu reda.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => '',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => 'Van radnog vremena',
        'New Ticket' => 'Novi tiket',
        'Create new Ticket' => 'Napravi novi tiket',
        'Customer called' => 'Pozvani korisnik',
        'phone call' => 'telefonski poziv',
        'Phone Call Outbound' => 'Odlazni telefonski poziv',
        'Reminder Reached' => 'Erinnerung erreicht',
        'Reminder Tickets' => 'Erinnerungs Tickets',
        'Escalated Tickets' => 'Eskalirani tiketi',
        'New Tickets' => 'Novi tiketi',
        'Open Tickets / Need to be answered' => 'Otvoreni tiketi / Potrebno odgovoriti',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'History::Move' => 'Tiket premeten u red "%s" (%s) iz reda "%s" (%s).',
        'History::TypeUpdate' => 'Auriran tip "%s" (ID=%s).',
        'History::ServiceUpdate' => 'Auriran servis "%s" (ID=%s).',
        'History::SLAUpdate' => 'Auriran "SLA" "%s" (ID=%s).',
        'History::NewTicket' => 'Novi tiket [%s] otvoren (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Nastavak za [%s]. %s',
        'History::SendAutoReject' => '',
        'History::SendAutoReply' => '',
        'History::SendAutoFollowUp' => '',
        'History::Forward' => 'Prosleeno "%s".',
        'History::Bounce' => 'Odbijeno "%s".',
        'History::SendAnswer' => 'E-mejl poslat "%s".',
        'History::SendAgentNotification' => '',
        'History::SendCustomerNotification' => '',
        'History::EmailAgent' => '',
        'History::EmailCustomer' => '',
        'History::PhoneCallAgent' => '',
        'History::PhoneCallCustomer' => '',
        'History::AddNote' => 'Dodata napomena (%s)',
        'History::Lock' => 'Tiket zakljuan.',
        'History::Unlock' => 'Tiket otkljuan.',
        'History::TimeAccounting' => '%s vremenskih jedinica prebrojano. Ukupno %s vremenskih jedinica.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Aurirano: %s',
        'History::PriorityUpdate' => 'Auriran prioritet sa "%s" (%s) na "%s" (%s).',
        'History::OwnerUpdate' => 'Novi vlasnik je "%s" (ID=%s).',
        'History::LoopProtection' => 'Zatita od petlje! Automatski odgovor nije poslat na "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Aurirano: %s',
        'History::StateUpdate' => 'Alt: "%s" Neu: "%s"',
        'History::TicketFreeTextUpdate' => 'Aurirano: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => '',
        'History::TicketLinkAdd' => '',
        'History::TicketLinkDelete' => '',
        'History::Subscribe' => '',
        'History::Unsubscribe' => '',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => 'Novi odgovorni je "%s" (ID=%s).',

        # Template: AAAWeekDay
        'Sun' => 'ned',
        'Mon' => 'pon',
        'Tue' => 'uto',
        'Wed' => 'sre',
        'Thu' => 'et',
        'Fri' => 'pet',
        'Sat' => 'sub',

        # Template: AdminAttachment
        'Attachment Management' => 'Upravljanje prilozima',
        'Actions' => 'Akcije',
        'Go to overview' => 'Idi na pregled',
        'Add attachment' => 'Dodaj prilog',
        'List' => 'Lista',
        'No data found.' => 'Nita nije pronaeno.',
        'Download file' => 'Preuzmi datoteku',
        'Delete this attachment' => 'Obrii ovaj prilog',
        'Add Attachment' => 'Dodaj prilog',
        'Edit Attachment' => 'Uredi prilog',
        'This field is required.' => 'Ovo polje je obavezno.',
        'or' => 'ili',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Upravljanje automatskim odgovorima',
        'Add auto response' => 'Dodaj automatski odgovor',
        'Add Auto Response' => 'Dodaj automatski odgovor',
        'Edit Auto Response' => 'Uredi automatski odgovor',
        'Response' => 'Odgovor',
        'Auto response from' => 'Automatski odgovor od',
        'Reference' => 'Reference',
        'You can use the following tags' => 'Moete koristiti sledee oznake',
        'To get the first 20 character of the subject.' => 'Da vidite prvih 20 slova predmeta',
        'To get the first 5 lines of the email.' => 'Da vidite prvih 5 linija poruke',
        'To get the realname of the sender (if given).' => 'Da vidite ime poiljaoca (ako je dostupno)',
        'To get the article attribute' => 'Da vidite atribute lanka',
        ' e. g.' => 'npr.',
        'Options of the current customer user data' => '',
        'Ticket owner options' => '',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => '',
        'Options of the ticket data' => '',
        'Config options' => 'Konfiguracione opcije',
        'Example response' => 'Primer odgovora',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Ureivanje korisnikih firmi',
        'Wildcards are allowed.' => 'Doker znakovi su dozvoljeni.',
        'Add customer company' => 'Dodaj korisniku firmu',
        'Please enter a search term to look for customer companies.' => 'Molimo unesite frazu za pronalaenje korisnikih firmi.',
        'Add Customer Company' => 'Dodaj korisniku firmu',

        # Template: AdminCustomerUser
        'Customer Management' => 'Upravljanje korisnicima',
        'Add customer' => 'Dodaj korisnika',
        'Select' => 'Izbor',
        'Hint' => 'Savet',
        'Customer will be needed to have a customer history and to login via customer panel.' => 'Korisnici su potrebni da bi mogli da imate istorijat za korisnika i da bi mogli da se prijave na klijentski portal.',
        'Please enter a search term to look for customers.' => 'Molimo unesite frazu za pronalaenje korisnika.',
        'Last Login' => 'Poslednja prijava',
        'Add Customer' => 'Dodaj korisnika',
        'Edit Customer' => 'Uredi korisnika',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Upravljanje relacijama Korisnik-Grupa',
        'Notice' => 'Napomena',
        'This feature is disabled!' => 'Ova funkcija je iskljuena!',
        'Just use this feature if you want to define group permissions for customers.' => 'Upotrebite ovu funkciju ako elite da definiete grupne dozvole za korisnike.',
        'Enable it here!' => 'Aktivirajte je ovde!',
        'Search for customers (wildcards are allowed).' => 'Nai korisnika (Platzhalter sind erlaubt).',
        'Edit Customer Default Groups' => '',
        'These groups are automatically assigned to all customers.' => '',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => '',
        'Select the customer:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => '',
        'Search Result:' => 'Rezultat pretrage:',
        'Customers' => 'Korisnici',
        'Groups' => 'Grupe',
        'No matches found.' => 'Nita nije pronaeno.',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => '',
        'Toggle %s permission for %s' => '',
        'Customer Default Groups:' => 'Podrazumevane grupe za korisnika:',
        'No changes can be made to these groups.' => 'Na ovim grupama promene nisu mogue.',
        'ro' => 'ro',
        'Read only access to the ticket in this group/queue.' => 'Pristup ogranien samo na itanje za tikete u ovim Grupama/Redovima.',
        'rw' => 'rw',
        'Full read and write access to the tickets in this group/queue.' => 'Pristup bez ogranienja za tikete u ovim Grupama/Redovima.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => '',
        'Edit default services' => 'Uredi podrazumevane servise',
        'Filter for Services' => 'Filter za servise',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => '',
        'Active' => 'Aktivno',
        'Toggle active state for %s' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Administrativna obavetenja',
        'Send Administrative Message to Agents' => 'Poalji administrativnu poruku zaposlenima.',
        'Your message was sent to' => 'Vaa poruka je poslata',
        'Send message to users' => 'Poalji poruku korisnicima',
        'Send message to group members' => 'Poalji poruku lanovima grupe',
        'Group members need to have permission' => 'lanovi grupe treba da imaju dolvolu',
        'Send message to role members' => 'Poalji poruku za ulogu',
        'Also send to customers in groups' => 'Takoe poalji korisnicima u grupi',
        'Please enter subject.' => 'Molimo unesite predmet poruke.',
        'Body' => 'Tekst',
        'Send' => 'alji',

        # Template: AdminGenericAgent
        'Generic Agent' => '',
        'Add job' => '',
        'Last run' => 'Poslednje pokretanje',
        'Run Now!' => 'Pokreni sad!',
        'Delete this task' => '',
        'Run this task' => '',
        'Job Settings' => '',
        'Job name' => '',
        'Please provide a name.' => '',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Currently this generic agent job will not run automatically.' => 'Trenutno ovaj generiki agentski zadatak nee raditi automatski.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Da biste omoguili automatsko izvravanje izaberite bar jednu vrednost od minuta sati i dana!',
        'Toggle this widget' => '',
        'Ticket Filter' => '',
        '(e. g. 10*5155 or 105658*)' => 'npr. 10*5144 ili 105658*',
        '(e. g. 234321)' => 'npr. 234321',
        'Customer login' => '',
        '(e. g. U5150)' => 'npr. U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => '',
        'Agent' => 'Zaposleni',
        'Ticket lock' => '',
        'TicketFreeFields' => 'Slobodna polja u tiketu',
        'Create times' => '',
        'No create time settings.' => 'Nema podeavanja vremena otvaranja.',
        'Ticket created' => 'Tiket otvoren',
        'Ticket created between' => 'Tiket otvoren izmeu',
        'Close times' => '',
        'No close time settings.' => 'Nije podeeno vreme zatvaranja.',
        'Ticket closed' => 'Tiket zatvoren',
        'Ticket closed between' => 'Tiket zatvoren izmeu',
        'Pending times' => '',
        'No pending time settings.' => 'Nema podeavanja vremena ekanja',
        'Ticket pending time reached' => 'Dostignuto vreme ekanja tiketa',
        'Ticket pending time reached between' => 'Vreme ekanja tiketa dostignuto izmeu',
        'Escalation times' => '',
        'No escalation time settings.' => 'Nema podeavanja vremena eskalacije',
        'Ticket escalation time reached' => 'Dostignuto vreme eskalacije tiketa',
        'Ticket escalation time reached between' => 'Vreme eskalacije tiketa dostignuto izmeu',
        'Escalation - first response time' => '',
        'Ticket first response time reached' => 'Dostignuto vreme reakcije na tiket',
        'Ticket first response time reached between' => 'Vreme reakcije na tiket dostignuto izmeu',
        'Escalation - update time' => '',
        'Ticket update time reached' => 'Dostignuto vreme auriranja tiketa',
        'Ticket update time reached between' => 'Vreme auriranja tiketa dostignuto izmeu',
        'Escalation - solution time' => '',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'Archive search option' => '',
        'Ticket Action' => '',
        'Set new service' => '',
        'Set new Service Level Agreement' => '',
        'Set new priority' => '',
        'Set new queue' => '',
        'Set new state' => '',
        'Set new agent' => '',
        'new owner' => '',
        'Set new ticket lock' => '',
        'New customer' => '',
        'New customer ID' => '',
        'New title' => '',
        'New type' => '',
        'New TicketFreeFields' => 'Slobodna polja novog tiketa',
        'Add Note' => '',
        'Time units' => 'Vremenske jedinice',
        ' (work units)' => ' (elementi posla)',
        'Archive selected tickets' => 'Arhiviraj izabrane tikete',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => '',
        'CMD' => '"CMD"',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
        'Delete tickets' => '',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '',
        'Execute Custom Module' => '',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Sauvaj',
        'Results' => 'Rezultati',
        '%s Tickets affected! What do you want to do?' => '',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '',
        'Edit job' => '',
        'Run job' => '',
        'Affected Tickets' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'UPOZORENJE: Ako promenite ime grupe \'admin\' pre adekvatnog podeavanja u sistemskoj konfiguraciji, izgubiete pristup administrativnom panelu! Ukoliko se to desi, vratite ime grupi u "admin" pomou "SQL" komande.',
        'Group Management' => 'Upravljanje grupama',
        'Add group' => 'Dodaj grupu',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => '',
        'It\'s useful for ASP solutions. ' => '',
        'Add Group' => 'Dodaj grupu',
        'Edit Group' => 'Uredi grupu',

        # Template: AdminLog
        'System Log' => 'Sistemski dnevnik',
        'Here you will find log information about your system.' => 'Ovde ete nai zabeleene informacije o dogaajima u sistemu.',
        'Time' => 'Vreme',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Upravljanje E-mejl nalozima',
        'Add mail account' => 'Dodaj E-mejl nalog',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Sve dolazne poruke sa jednog naloga e biti usmerene u izabrani red!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Wird dem Konto vertraut, werden die X-OTRS Header benutzt! PostMaster Filter werden trotzdem benutzt.',
        'Host' => 'Domain',
        'Delete account' => 'Obrii E-mejl nalog',
        'Fetch mail' => 'Preuzmi potu',
        'Add Mail Account' => 'Dodaj E-mejl nalog',
        'Example: mail.example.com' => '',
        'Trusted' => 'Od poverenja',
        'Dispatching' => 'Otprema',
        'Edit Mail Account' => 'Uredi E-mejl naloga',

        # Template: AdminNavigationBar
        'Admin' => 'Admin',
        'Agent Management' => 'Upravljanje zaposlenima',
        'Queue Settings' => 'Podeavanje redova',
        'Ticket Settings' => 'Podeavanje tiketa',
        'System Administration' => 'Administracija sistema',

        # Template: AdminNotification
        'Notification Management' => 'Upravljanje obavetenjima',
        'Filter for Language' => '',
        'Filter for Notification' => '',
        'Notifications are sent to an agent or a customer.' => 'Obavetenje poslato zaposlenom ili korisniku.',
        'Notification' => 'Obavetenje',
        'Edit Notification' => '',
        'e. g.' => 'npr.',
        'Options of the current customer data' => '',

        # Template: AdminNotificationEvent
        'Add notification' => 'Dodaj obavetenje',
        'Delete this notification' => '',
        'Add Notification' => 'Dodaj Obavetenje',
        'Recipient groups' => '',
        'Recipient agents' => '',
        'Recipient roles' => '',
        'Recipient email addresses' => '',
        'Article type' => 'Tip lanka',
        'Only for ArticleCreate event' => '',
        'Subject match' => 'Poklapanje predmeta',
        'Body match' => 'Poklapanje sadraja',
        'Include attachments to notification' => '',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Da vidite prvih 20 slova predmeta (poslednjeg lanka zaposlenog).',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Da vidite prvih 20 slova predmeta (poslednjeg lanka zaposlenog)',
        'To get the first 5 lines of the body (of the latest customer article).' => '',

        # Template: AdminPGP
        'PGP Management' => 'Upravljanje "PGP" kljuevima',
        'Add PGP key' => 'Dodaj "PGP"-klju',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Na ovaj nain moete direktno ureivati komplet knjueva podeen u sistemskim opcijama.',
        'Introduction to PGP' => '',
        'Result' => 'Rezultat',
        'Identifier' => 'Identifikator',
        'Bit' => 'Bit',
        'Key' => 'Klju',
        'Fingerprint' => 'Otisak',
        'Expires' => 'Istie',
        'Delete this key' => 'Obrii ovaj klju',
        'Add PGP Key' => 'Dodaj "PGP"-klju',

        # Template: AdminPackageManager
        'Package Manager' => 'Upravljanje paketima',
        'Uninstall package' => 'Deinstaliraj paket',
        'Version' => 'Verzija',
        'Do you really want to uninstall this package?' => '',
        'Reinstall package' => 'Instaliraj paket ponovo',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => '',
        'Continue' => 'Nastavi',
        'Install' => 'Instaliraj',
        'Install Package' => 'Instaliraj paket',
        'Update repository information' => '',
        'Online Repository' => 'Mreno spremite',
        'Vendor' => 'Prodavac',
        'Module documentation' => 'Dokumentacija kodula',
        'Upgrade' => 'Auriranje',
        'Local Repository' => 'Lokalno spremite',
        'Uninstall' => 'Deinstaliraj',
        'Package not correctly deployed! You should reinstall the package again!' => '',
        'Reinstall' => 'Instaliraj ponovo',
        'Download package' => 'Preuzmi paket',
        'Rebuild package' => 'Obnovi paket(rebuild)',
        'Metadata' => 'Meta-podaci',
        'Change Log' => 'Promeni dnevnik',
        'Date' => 'Datum',
        'List of Files' => 'Spisak datoteka',
        'Permission' => 'Dozvola',
        'Download' => 'Preuzimanje',
        'Download file from package!' => 'Preuzmi datoteku iz paketa!',
        'Required' => 'Obavezno',
        'PrimaryKey' => 'Primarni klju',
        'AutoIncrement' => 'AutoUveanje',
        'SQL' => '"SQL"',
        'File differences for file %s' => 'Razlike za datoteku %s',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Dnevnik preformansi',
        'This feature is enabled!' => 'Ova funkcija je aktivna!',
        'Just use this feature if you want to log each request.' => '',
        'Activating this feature might affect your system performance!' => '',
        'Disable it here!' => 'Iskljuite je ovde!',
        'Logfile too large!' => 'Dnevnik je prevelik!',
        'The logfile is too large, you need to reset it' => 'Datoteka dnevnika je prevelika, treba da je resetujete',
        'Overview' => 'Pregled',
        'Range' => 'Opseg',
        'Interface' => 'Interfejs',
        'Requests' => 'Zahtevi',
        'Min Response' => 'Min vreme reakcije',
        'Max Response' => 'Maks vreme reakcije',
        'Average Response' => 'Proseno vreme reakcije',
        'Period' => 'Period',
        'Min' => 'Min',
        'Max' => 'Maks',
        'Average' => 'Prosek',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Upravljanje "PostMaster" Filterima',
        'Add filter' => '',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Ukoliko elite poklapanje samo sa e-mejl adresom, koristite EMAILADDRESS:info@example.com u "Od", "Za" ili "Kk".',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => '',
        'Add PostMaster Filter' => '',
        'Edit PostMaster Filter' => '',
        'Filter name' => 'Naziv filtera',
        'Stop after match' => 'Zaustavi posle poklapanja',
        'Filter Condition' => 'Stanje filtera',
        'Value' => 'Vrednost',
        'Set Email Headers' => 'Podesi zaglavlja e-mejla',

        # Template: AdminPriority
        'Priority Management' => 'Upravljanje prioritetima',
        'Add priority' => 'Dodaj prioritet',
        'Add Priority' => 'Dodaj prioritet',
        'Edit Priority' => 'Uredi prioritet',

        # Template: AdminQueue
        'Manage Queues' => 'Upravljanje redovima',
        'Add queue' => '',
        'Add Queue' => '',
        'Edit Queue' => '',
        'Sub-queue of' => '',
        'Unlock timeout' => 'Vreme do otkljuavanja',
        '0 = no unlock' => '0 = nema otkljuavanja',
        'Only business hours are counted.' => 'Meri se samo radno vreme.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Obaveten od',
        '0 = no escalation' => '0 = nema eskalacije',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => '',
        'Follow up Option' => 'Opcije nastavka',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => '',
        'Ticket lock after a follow up' => 'Zakljuavanje tiketa posle nastavka',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => '',
        'System address' => '',
        'Will be the sender address of this queue for email answers.' => '',
        'Default sign key' => '',
        'The salutation for email answers.' => '',
        'The signature for email answers.' => '',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => '',
        'Filter for Queues' => '',
        'Filter for Auto Responses' => '',
        'Auto Responses' => 'Automatski odgovori',
        'Change Auto Response Relations for Queue' => '',
        'settings' => 'Podeavanja',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => '',
        'Filter' => 'Filter',
        'Filter for Responses' => '',
        'Responses' => 'Odgovori',
        'Change Queue Relations for Response' => '',
        'Change Response Relations for Queue' => '',

        # Template: AdminResponse
        'Manage Responses' => '',
        'Add response' => '',
        'A response is default text to write faster answer (with default text) to customers.' => '',
        'Don\'t forget to add a new response a queue!' => 'Ne zaboravite da novi odgovor dodate u red!',
        'Delete this entry' => '',
        'Add Response' => '',
        'Edit Response' => '',
        'The current ticket state is' => 'Trenutni staus tiketa je',
        'Your email address is' => '',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => '',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => '',
        'Link %s to selected %s' => '',

        # Template: AdminRole
        'Role Management' => 'Upravljanje ulogama',
        'Add role' => 'Dodaj ulogu',
        'Create a role and put groups in it. Then add the role to the users.' => 'Napravi ulogu i dodaj grupe u nju. Onda dodaj ulogu zaposlenima.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => '',
        'Add Role' => 'Dodaj ulogu',
        'Edit Role' => 'Uredi ulogu',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => '',
        'Filter for Roles' => '',
        'Roles' => 'Uloge',
        'Select the role:group permissions.' => '',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => '',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => '',
        'move_into' => 'premesti u',
        'Permissions to move tickets into this group/queue.' => '',
        'create' => 'kreiranje',
        'Permissions to create tickets in this group/queue.' => '',
        'priority' => 'prioritet',
        'Permissions to change the ticket priority in this group/queue.' => '',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => '',
        'Filter for Agents' => '',
        'Agents' => 'Zaposleni',
        'Manage Role-Agent Relations' => '',
        'Change Role Relations for Agent' => '',
        'Change Agent Relations for Role' => '',

        # Template: AdminSLA
        'SLA Management' => 'Upravljanje "SLA"',
        'Add SLA' => 'Dodaj "SLA"',
        'Edit SLA' => 'Uredi "SLA"',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => '"S/MIME" upravljanje',
        'Add private key' => '',
        'Add certificate' => '',
        'In this way you can directly edit the certification and private keys in file system.' => '',
        'See also' => 'Pogledaj jo',
        'Hash/Fingerprint' => '',
        'Create/Expires' => '',
        'Delete this certificate' => '',
        'Add Certificate' => 'Dodaj sertifikat',
        'Add Private Key' => 'Dodaj privatni klju',
        'Secret' => 'Tajna',

        # Template: AdminSalutation
        'Salutation Management' => 'Upravljanje pozdravima',
        'Add salutation' => 'Dodaj pozdrav',
        'Add Salutation' => 'Dodaj pozdrav',
        'Edit Salutation' => 'Uredi pozdrav',
        'Example salutation' => 'Primer pozdrava',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => '',
        'Secure mode will (normally) be set after the initial installation is completed.' => '',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => '"SQL" Box',
        'Here you can enter SQL to send it directly to the application database.' => '',
        'Result format' => '',
        'Run Query' => '',

        # Template: AdminService
        'Service Management' => 'Upravljanje servisima',
        'Add service' => '',
        'Add Service' => 'Dodaj servis',
        'Edit Service' => '',
        'Sub-service of' => '',

        # Template: AdminSession
        'Session Management' => 'Upravljanje sesijama',
        'All sessions' => 'Sve sesije',
        'Agent sessions' => 'Sesije zaposlenih',
        'Customer sessions' => 'Sesije korisnika',
        'Unique agents' => 'Jedinsveni zapoleni',
        'Unique customers' => 'Jedinstveni korisnici',
        'Kill all sessions' => 'Ugasi sve sesije',
        'Session' => 'Sesija',
        'Kill' => '',
        'Kill this session' => '',
        'Detail View for SessionID' => '',

        # Template: AdminSignature
        'Signature Management' => 'Upravljanje potpisima',
        'Add signature' => '',
        'Add Signature' => 'Dodaj potpis',
        'Edit Signature' => '',
        'Example signature' => 'Primer potpisa',

        # Template: AdminState
        'State Management' => 'Upravljanje statusima',
        'Add state' => '',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => '',
        'Add State' => 'Dodaj status',
        'Edit State' => '',
        'State type' => '',

        # Template: AdminSysConfig
        'SysConfig' => 'Sistemska konfiguracija',
        'Navigate by searching in %s settings' => '',
        'Select Group' => '',
        'Navigate by selecting config groups' => '',
        'Select group' => '',
        'Download all system config changes' => '',
        'Export settings' => '',
        'Load SysConfig settings from file' => '',
        'Import settings' => '',
        'Import Settings' => '',
        'Import' => 'Uvoz',
        'Please enter a search term to look for settings.' => '',
        'Subgroup' => 'Podgrupa',
        'Elements' => 'Elementi',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => '',
        'This config item is only available in a higher config level!' => '',
        'Reset this setting' => '',
        'Default value' => '',
        'Error: this file could not be found.' => '',
        'Error: this directory could not be found.' => '',
        'Error: an invalid value was entered.' => '',
        'Content' => 'Sadraj',
        'Remove this entry' => '',
        'Add entry' => '',
        'Remove entry' => '',
        'Add new entry' => '',
        'Create new entry' => '',
        'New group' => '',
        'Group ro' => '',
        'Readonly group' => '',
        'New group ro' => '',
        'Loader' => '',
        'File to load for this frontend module' => '',
        'New Loader File' => '',
        'NavBarName' => 'NavBarName',
        'NavBar' => 'NavBar',
        'LinkOption' => '',
        'Block' => 'Blok',
        'AccessKey' => 'Klju za pristup',
        'Add NavBar entry' => '',
        'Year' => 'godina',
        'Month' => 'mesec',
        'Day' => 'dan',
        'Invalid year' => '',
        'Invalid month' => '',
        'Invalid day' => '',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Upravljanje sistemskim e-mejlom',
        'Add system address' => '',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => '',
        'Email address' => '',
        'Display name' => '',
        'Add System Email Address' => '',
        'Edit System Email Address' => '',
        'The display name and email address will be shown on mail you send.' => '',

        # Template: AdminType
        'Type Management' => 'Upravljanje tipovima',
        'Add ticket type' => '',
        'Add Type' => 'Dodaj tip',
        'Edit Type' => 'Uredi tip',

        # Template: AdminUser
        'Add agent' => '',
        'Agents will be needed to handle tickets.' => '',
        'Don\'t forget to add a new agent to groups and/or roles!' => '',
        'Please enter a search term to look for agents.' => '',
        'Last login' => '',
        'Login as' => 'Prijavi se kao',
        'Switch to agent' => '',
        'Add Agent' => '',
        'Edit Agent' => '',
        'Firstname' => 'Ime',
        'Lastname' => 'Prezime',
        'Start' => 'Start',
        'End' => 'Kraj',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => '',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => '',
        'Permissions to add notes to tickets in this group/queue.' => '',
        'owner' => 'Vlasnik',
        'Permissions to change the owner of tickets in this group/queue.' => '',

        # Template: AgentBook
        'Address Book' => 'Adresar',
        'Search for a customer' => 'Trai korisnika',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => 'Primeni',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Trai korisnika',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Komandna tabla',
        'Show or hide the content' => 'Prikai ili sakri sadraj',

        # Template: AgentDashboardCalendarOverview
        'in' => 'u',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s je dostupno!',
        'Please update now.' => 'Molimo aurirajte sada.',
        'Release Note' => 'Obavetenje o verziji',
        'Level' => 'Nivo',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Poslano pre %s.',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket was locked' => 'Tiket je zakljuan.',
        'Undo & close window' => 'Otkai i zatvori prozor',

        # Template: AgentInfo
        'Info' => 'Info',
        'To accept some news, a license or some changes.' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Povei objekt: %s',
        'Close window' => 'Zatvori prozor',
        'go to link delete screen' => 'idi na ekran za brisanje veze',
        'Select Target Object' => 'Izaberi ciljni objekat',
        'Link Object' => 'Povei objekat',
        'with' => 'sa',
        'Unlink Object: %s' => 'Prekini vezu sa objektom: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => 'Uredi line postavke',

        # Template: AgentSpelling
        'Spell Checker' => 'Provera pravopisa',
        'spelling error(s)' => 'Pravopisne greke',
        'Apply these changes' => 'Primeni ove izmene',

        # Template: AgentStatsDelete
        'Delete stat' => 'Obrii statistiku',
        'Stat#' => 'Statistika Br.',
        'Do you really want to delete this stat?' => '',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => '',
        'Select the element that will be used at the X-axis' => '',
        'Select the elements for the value series' => 'Izaberite elemente za opsege vrednosti',
        'Select the restrictions to characterize the stat' => '',
        'Here you can make restrictions to your stat.' => '',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => '',
        'Fixed' => 'Fiksno',
        'Please select only one element or turn off the button \'Fixed\'.' => '',
        'Absolute Period' => '',
        'Between' => 'Izmeu',
        'Relative Period' => 'Relativni period',
        'The last' => 'Poslednji',
        'Finish' => 'Zavri',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Dozvole',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => '',
        'Sum rows' => 'Zbir redova',
        'Sum columns' => 'Zbir kolona',
        'Use cache' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        'If set to invalid end users can not generate the stat.' => '',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Skala',
        'minimal' => 'minimum',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Molimo zapamtite, da skala za opsege vrednosti moda da bude vea od skale za X-Osu (npr X-Osa => mesec; Vrednost opsega => godina).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maksimalni period',
        'minimal scale' => 'minimalna skala',

        # Template: AgentStatsImport
        'Import Stat' => 'Uvezi statistiku',
        'File is not a Stats config' => 'Ova datoteka nije konfiguracija statistike',
        'No File selected' => 'Nije izabrana nijedna datoteka',

        # Template: AgentStatsOverview
        'Stats' => 'Statistika',
        'Object' => 'Objekat',

        # Template: AgentStatsPrint
        'Print' => 'tampaj',
        'No Element selected.' => 'Nema izabranih elemenata.',

        # Template: AgentStatsView
        'Export config' => '',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => '',
        'Format' => 'Format',
        'Graphsize' => 'Veliina grafikona',
        'Cache' => 'Ke',
        'Exchange Axis' => 'Zameni ose',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => 'maksimalni period od',
        'to' => 'do',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => 'Promeni "slobodan" tekst tiketa',
        'Change Owner of Ticket' => 'Promeni vlasnika tiketa',
        'Close Ticket' => 'Zatvori tiket',
        'Add Note to Ticket' => 'Dodaj napomenu uz tiket',
        'Set Pending' => 'Stavi na ekanje',
        'Change Priority of Ticket' => 'Promeni prioritet tiketa',
        'Change Responsible of Ticket' => 'Promeni odgovornog za tiket',
        'Cancel & close window' => 'Poniti i zatvori prozor',
        'Service invalid.' => 'Neispravan servis',
        'New Owner' => 'Novi vlasnik',
        'Please set a new owner!' => 'Molimo odredite novog vlasnika',
        'Previous Owner' => 'Prethodni vlasnik',
        'Inform Agent' => 'Obavesi zaposlenog',
        'Optional' => 'Opcioni',
        'Inform involved Agents' => 'Obavesti relevantne zaposlene',
        'Spell check' => 'Provera pravopisa',
        'Note type' => 'Tip komentara',
        'Next state' => 'Sledei status',
        'Pending date' => 'ekanje do',
        'Date invalid!' => 'Neispravan datum',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => '',
        'Bounce to' => 'Preusmeri na',
        'You need a email address.' => '',
        'Need a valid email address or don\'t use a local email address.' => '',
        'Next ticket state' => 'Naredni status tiketa',
        'Inform sender' => 'Obavesti poiljaoca',
        'Send mail!' => 'Poalji e-mejl!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Masovne akcije na tiketima',
        'Merge to' => 'Objedini sa',
        'Invalid ticket identifier!' => '',
        'Merge to oldest' => 'Objedini sa najstarijom',
        'Link together' => 'Povei zajedno',
        'Link to parent' => '',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => '',
        'Need a valid email address.' => '',
        'Address book' => 'Adresar',
        'Pending Date' => 'Datum ekanja',
        'for pending* states' => 'za stanja ekanja',
        'Date Invalid!' => 'Neispravan datum!',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Promena korisnika za tiket',
        'Customer Data' => 'Podaci o korisniku',
        'Customer user' => 'Kontakt',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => 'Otvori novi e-mejl tiket',
        'From queue' => 'iz Reda',
        'Get all' => 'Uzmi sve',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => 'Prosledi tiket',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Istorijat od',
        'History Content' => 'Sadraj istorijata',
        'Zoom view' => 'Detaljni pogled',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Spajanje tiketa',
        'The Ticket was locked' => 'Tiket je zakljuan',
        'You need to use a ticket number!' => 'Molimo vas da koristite broj tiketa!',
        'A valid ticket number is required.' => '',

        # Template: AgentTicketMove
        'Move Ticket' => 'Premesti tiket',
        'New Queue' => 'Novi Red',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => 'Izaberi sve',
        'No ticket data found.' => '',
        'First Response Time' => 'Vreme prvog odgovora',
        'Service Time' => 'Servisno vreme',
        'Update Time' => 'Vreme auriranja',
        'Solution Time' => 'Vreme reenja',
        'Move ticket to a different queue' => 'Premesti tiket u drugi red',
        'Change queue' => 'Promeni red',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Promeni opcije pretrage',
        'Max. shown Tickets a page' => 'Maks broj tiketa po strani',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalacija u',
        'Locked' => 'Zakljuano',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'Otvori novi telefonski tiket',
        'From customer' => 'Od Korisnika',
        'To queue' => 'U Red',
        'Create' => 'Otvori',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefonski poziv',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'Pregled neformatirane poruke',
        'Plain' => 'Neformatirano',
        'Download this email' => 'Preuzmi ovu poruku',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Info o tiketu',
        'Accounted time' => 'Obraunato vreme',
        'Linked-Object' => 'Povezani objekt',
        'by' => 'od',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'ablon pretrage',
        'Create New' => 'Napravi nov',
        'Create Template' => 'Napravi ablon',
        'Save changes in template' => '',
        'Add another attribute' => 'Dodaj jo jedan atribut',
        'Output' => 'Pregled rezultata',
        'Fulltext' => 'Tekst',
        'Remove' => 'Ukloni',
        'Customer User Login' => 'Prijava korisnika',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Otvoreno u redu',
        'Lock state' => 'Staus zakljiavanja',
        'Watcher' => 'Praenje',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => '',
        'Run Search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => 'Filter za lanke',
        'Save filter settings as default' => 'Sauvaj poeavanja filtera kao podrazumevana',
        'Ticket Information' => '',
        'Linked Objects' => 'Povezani objekti',
        'Article(s)' => 'lanak/lanci',
        'Change Queue' => 'Promeni Red',
        'Article Filter' => '',
        'Add Filter' => 'Dodaj Filter',
        'Set' => 'Podesi',
        'Reset Filter' => 'Resetuj Filter',
        'Show one article' => 'Prikai jedan lanak',
        'Show all articles' => 'Prikai sve lanke',
        'Unread articles' => 'Neproitani lanci',
        'No.' => 'Br.',
        'Unread Article!' => 'Neproitani lanci!',
        'Incoming message' => 'Dolazna poruka',
        'Outgoing message' => 'Odlazna poruka',
        'Internal message' => 'Interna poruka',
        'Resize' => 'Promena veliine',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => '',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Traceback',

        # Template: CustomerFooter
        'Powered by' => 'Pokree',
        'One or more errors occurred!' => '',
        'Close this dialog' => 'Zatvori ovaj dijalog',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Prijavljivanje',
        'User name' => 'Korisniko ime',
        'Your user name' => 'Vae korisniko ime',
        'Your password' => 'Vaa lozinka',
        'Forgot password?' => '',
        'Log In' => 'Prijavljivanje',
        'Not yet registered?' => '',
        'Sign up now' => 'Regisrujte se sada',
        'Request new password' => 'Zahtev za novu lozinku',
        'Your User Name' => 'Vae korisniko ime',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Kreirajte nalog',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => '',
        'Please supply a first name' => '',
        'Your Last Name' => '',
        'Please supply a last name' => '',
        'The User Name you wish to have' => '',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => '',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'You have not created a ticket yet.' => '',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you.' => '',
        'We stop eating if you wish us to do.' => '',
        'Your way to communicate with us is this thing called \'ticket\'.' => '',
        'Please command us.' => '',
        'Create your first Ticket' => '',

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => '',
        'Customer ID' => 'ID korisnika',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => '',
        'Recipient' => 'Primalac',
        'Carbon Copy' => 'Kopija',
        'Time restrictions' => '',
        'Only tickets created' => '',
        'Only tickets created between' => '',
        'Search-Profile as Template?' => '',
        'Save as Template?' => '',
        'Template Name' => 'Naziv ablona',
        'Output to' => 'Izlaz na',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'od',
        'Page' => 'Strana',
        'Search Results for' => '',

        # Template: CustomerTicketZoom
        'Loading' => 'Uitavam...',
        'Reply' => 'Odgovori',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => 'Neispravan datum (poteban budui datum)!',
        'Previous' => 'Nazad',
        'Sunday' => 'nedelja',
        'Monday' => 'ponedeljak',
        'Tuesday' => 'utorak',
        'Wednesday' => 'sreda',
        'Thursday' => 'etvrtak',
        'Friday' => 'petak',
        'Saturday' => 'subota',
        'Su' => 'ne',
        'Mo' => 'po',
        'Tu' => 'ut',
        'We' => 'sr',
        'Th' => 'e',
        'Fr' => 'pe',
        'Sa' => 'su',
        'Open date selection' => 'Otvori izbor datuma',

        # Template: Error
        'Oops! An Error occurred.' => 'Ups. Dogodila se greka.',
        'Error Message' => 'Poruka o greci',
        'You can' => 'Vi moete',
        'Send a bugreport' => 'Poalji izvetaj o greci',
        'go back to the previous page' => 'idi na prethodnu stranu',
        'Error Details' => 'Detalji greke',

        # Template: Footer
        'Top of page' => 'Na vrh strane',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => 'Ako napustite ovu stranicu, svi otvoreni prozori e biti zatvoreni!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'Prijavljeni ste kao',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'Java skript nije dostupan.',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'Kako bi ste koristili "OTRS" neophodno je da aktivirate Java skript u vaem Web itau.',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Dobrodoli na %s',
        'Web site' => '',
        'Database check successful.' => 'Uspena provera baze podataka.',
        'Mail check successful.' => 'Uspena provera e-mejl podeavanja.',
        'Error in the mail settings. Please correct and try again.' => 'Greka u podeavanju e-mejla. Molimo ispravite i pokuajte ponovo.',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => 'Podeavanje odlazne pote',
        'Outbound mail type' => '',
        'Select outbound mail type.' => '',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => '"SMTP"-domain',
        'SMTP host.' => '',
        'SMTP authentication' => '',
        'Does your SMTP host need authentication?' => '',
        'SMTP auth user' => '',
        'Username for SMTP auth.' => '',
        'SMTP auth password' => '',
        'Password for SMTP auth.' => '',
        'Configure Inbound Mail' => 'Podeavanje dolazne pote',
        'Inbound mail type' => '',
        'Select inbound mail type.' => '',
        'Inbound mail host' => '',
        'Inbound mail host.' => '',
        'Inbound mail user' => '',
        'User for inbound mail.' => '',
        'Inbound mail password' => '',
        'Password for inbound mail.' => '',
        'Result of mail configuration check' => 'Rezultat provere podeavanja pote',
        'Check mail configuration' => '',
        'Skip this step' => 'Preskoi ovaj korak',

        # Template: InstallerDBResult
        'False' => '',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Ako ste podesili "root" lozinku za vau bazu podataka, ona mora biti uneta ovde. Ako nema lozinke ostavite polje prazno. Iz bezbednosnih razloga preporuujemo da je podesite. Za vie informacija konsultujte dokumentaciju o bazi podataka.',
        'Currently only MySQL is supported in the web installer.' => 'Trenutno je samo "MySQL" podran u Web Instalaciji.',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Korisnik baze podataka',
        'New' => 'Nov',
        'A new database user with limited rights will be created for this OTRS system.' => '',
        'default \'hot\'' => 'podrazumevano \'hot\'',
        'DB--- host' => 'Naziv ili adresa DB-Servera',
        'Database' => 'Baza podataka',
        'Check database settings' => 'Proverite podeavanja baze',
        'Result of database check' => 'Rezultat provere baze podataka',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Da bi ste koristili "OTRS" morate uneti sledee u komandnu liniju (Terminal/Shell) kao "root".',
        'Restart your webserver' => 'Ponovo pokrenite va WEB Server.',
        'After doing so your OTRS is up and running.' => 'Posle ovoga va "OTRS" je ukljuen i radi.',
        'Start page' => 'Poetna strana',
        'Your OTRS Team' => 'Va "OTRS" Tim',

        # Template: InstallerLicense
        'Accept license' => 'Prihvati licencu',
        'Don\'t accept license' => 'Ne prihvataj licencu',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'Sistemski ID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => 'Sistemski identifikator. Svaki broj tiketa i svaki ID "HTTP" sesije sadri ovaj broj.',
        'System FQDN' => 'Sistemski "FQDN"',
        'Fully qualified domain name of your system.' => '"FQDN" - ime servera ukljuujui puno ime domena npr "otrs-server.example.org"',
        'AdminEmail' => 'E-mejl administratora',
        'Email address of the system administrator.' => 'E-mejl adresa sistemskog administratora.',
        'Organization' => 'Organizacija',
        'Log' => 'Dnevnik',
        'LogModule' => 'Modul dnevnika',
        'Log backend to use.' => 'Sistem koji se koristi za dnevnik.',
        'LogFile' => 'Datoteka dnevnika',
        'Log file location is only needed for File-LogModule!' => 'Lokacija datoteke dnevnika je jedno neophodno Modulu dnevnika!',
        'Webfrontend' => 'Mreni interfejs',
        'Default language' => 'Podrazumevani jezik',
        'Default language.' => 'Podrazumevani jezik',
        'CheckMXRecord' => 'Proveri "MX"-podatke',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => 'Runo uneta e-mejl adresa se proverava pomou "MX" podatka pronaenog u "DNS".Nemojte koristiti ovu opciju ako je va "DNS" spor ili ne moe da razrei javne adrese',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => 'Dodaj veze',
        'Delete links' => 'Obrii veze',

        # Template: Login
        'JavaScript Not Available' => 'Java Skript nije dostupan.',
        'Browser Warning' => 'Upozorenje Web itaa',
        'The browser you are using is too old.' => 'Web ita koji koristite je previe star.',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => '"OTRS" funcionie na velikom broju Web itaa, molimo da instalirate i koristite jedan od ovih.',
        'Please see the documentation or ask your admin for further information.' => 'Molimo da pregledate dokumentaciju ili pitate vaeg administratora za dodatne informacije.',
        'Lost your password?' => '',
        'Request New Password' => 'Zahtev za novu lozinku',
        'Back to login' => 'Nazad na prijavljivanje',

        # Template: Motd
        'Message of the Day' => 'Dananja poruka',

        # Template: NoPermission
        'Insufficient Rights' => 'Nedovoljna ovlatenja',
        'Back to the previous page' => 'Vratite se na prethodnu stranu',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PrintFooter
        'URL' => '"URL"',

        # Template: PrintHeader
        'printed by' => 'tampao',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => '"OTRS" test strana',
        'Welcome %s' => 'Dobrodoli %s',
        'Counter' => 'Broja',

        # Template: Warning
        'Go back to the previous page' => 'Vratite se na prethodnu stranu',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => '',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => '',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attribrutes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Anlagen <-> Antworten',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => '',
        'Create and manage agents.' => '',
        'Create and manage attachments.' => '',
        'Create and manage companies.' => '',
        'Create and manage customers.' => '',
        'Create and manage event based notifications.' => '',
        'Create and manage groups.' => '',
        'Create and manage notifications that are sent to agents.' => '',
        'Create and manage queues.' => '',
        'Create and manage response templates.' => '',
        'Create and manage responses that are automatically sent.' => '',
        'Create and manage roles.' => '',
        'Create and manage salutations.' => '',
        'Create and manage services.' => '',
        'Create and manage signatures.' => '',
        'Create and manage ticket priorities.' => '',
        'Create and manage ticket states.' => '',
        'Create and manage ticket types.' => '',
        'Create new email ticket and send this out (outbound)' => '',
        'Create new phone ticket (inbound)' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => '',
        'Customers <-> Services' => '',
        'Data used to export the search result in CSV format.' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repositoriy, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'E-Mail Adressen',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => 'Eskalationsansicht',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'GenericAgent',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove tailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Max. displayed tickets' => 'Max. Anzahl der angezeigten Tickets',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to genetare accounted time ticket statistics.' => '',
        'Module to genetare ticket solution and response time statistics.' => '',
        'Module to genetare ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => '',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Antworten <-> Queues',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Search Ticket' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => '',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of lines that are displayed in the preview of messages (e.g. for tickets in the QueueView).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => 'Statistiken',
        'Status view' => 'Statusansicht',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => '',
        'Tickets' => '',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => '',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => '',
        'View system log messages.' => '',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => '',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this joba' => '%s tiketa zahvaeno! Da li stvarno elite da pokrenete ovaj posaoa',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Proverite "MX" zapise upotrebljenih e-mejl adresa  kreiranjem odgovora. Nemojte koristiti ovu funkciju ako je va "OTRS" server na "dial-up" liniji!)',
        '(Email of the system admin)' => '(E-mejl sistem administratora)',
        '(Full qualified domain name of your system)' => '(Puno kvalifikovano ime domena vaeg sistema)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Napomena: Od vae instalacije zavisi broj dinamikih objekata koje moete koristiti)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifikacija tiketa. npr. \'Ticket#\', \'Call#\' ili \'MyTicket#\')',
        '(Used default language)' => '(Podrazumevani jezik korisnika)',
        '(Used log backend)' => '(Benutztes Log Backend)',
        '(Used ticket number format)' => '(Upotrebljeni format za broj tiketa)',
        'A article should have a title!' => 'lanak treba da ima naslov!',
        'A message must be spell checked!' => 'Potrebna provera pravopisa za poruku!',
        'A message should have a To: recipient!' => 'Poruka treba da ima popunjeno Za: primaoc!',
        'A message should have a body!' => 'Poruka treba da sadri neki tekst!',
        'A message should have a customer!' => 'Poruka mora da ima korisnika!',
        'A message should have a subject!' => 'Poruka mora da ima predmet!',
        'A required field is:' => 'Obavezno polje je:',
        'A ticket should be associated with a queue!' => 'Tiket bi trebalo da bude u nekom redu.',
        'A ticket should have a type!' => 'Tiket mora da bude dodeljen tip!',
        'About OTRS' => 'O "OTRS"',
        'Absolut Period' => 'Apsolutni period',
        'Add Customer User' => 'Doadaj korisnika',
        'Add System Address' => 'Dodaj sistemsku adresu',
        'Add User' => 'Dodaj korisnika',
        'Add a new Agent.' => 'Dodaj novog zaposlenog.',
        'Add a new Customer Company.' => 'Dodaj novu korisniku firmu.',
        'Add a new Group.' => 'Dodaj novu grupu.',
        'Add a new Notification.' => 'Dodaj novo obavetenje.',
        'Add a new Priority.' => 'Dodaj novi prioritet.',
        'Add a new Role.' => 'Dodaj novu ulogu.',
        'Add a new SLA.' => 'Dodaj novi "SLA".',
        'Add a new Salutation.' => 'Dodaj nov pozdrav.',
        'Add a new Service.' => 'Dodaj novi servis.',
        'Add a new Signature.' => 'Dodaj novi potpis.',
        'Add a new State.' => 'Dodaj novi status.',
        'Add a new System Address.' => 'Dodaj novu sistemsku adresu.',
        'Add a new Type.' => 'Dodaj novi tip.',
        'Add a new salutation' => 'Dodaj novi pozdrav',
        'Add new attachment' => 'Dodaj novi prilog',
        'Add note to ticket' => 'Dodaj tiketu napomenu',
        'Add to list of subscribed tickets' => 'Dodaj na listu pretplate',
        'Added User "%s"' => 'Dodan korisnik "%s".',
        'Admin-Area' => 'Admin prostor',
        'Admin-Password' => 'Administratorska lozinka',
        'Admin-User' => 'Administrator',
        'Admin-password' => 'Administratorska lozinka',
        'Agent Mailbox' => 'Potansko sandue zaposlenih',
        'Agent Preferences' => 'Podeavanja zaposlenog',
        'Agent based' => 'Na osnovu zaposlenog',
        'Agent-Area' => 'Prostor zaposlenih',
        'All Agent variables.' => 'Sve varijable zaposlenih',
        'All Agents' => 'Svi zaposleni',
        'All Customer variables like defined in config option CustomerUser.' => 'Sve korisnike varijable kao to su definisane u konfiguracionim opcijama za korisnika.',
        'All customer tickets.' => 'Svi tiketi za korisnika.',
        'All email addresses get excluded on replaying on composing an email.' => 'Sve e-mejl adrese e biti iskljuene pri kreiranju odgovora.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Sve e-mejl poruke sa ovim primaocem (Za:) bie otpremljene u izabrani red!',
        'All messages' => 'Sve poruke',
        'All new tickets!' => 'Svi novi tiketi!',
        'All tickets' => 'Svi tiketi',
        'All tickets where the reminder date has reached!' => 'Svi tiketi kod kojih je dostignut datum podsetnika!',
        'All tickets which are escalated!' => 'Svi eskalirani tiketi!',
        'Allocate CustomerUser to service' => 'Rasporedi korisnika na servis',
        'Allocate services to CustomerUser' => 'Dodeli servise korisniku ',
        'Answer' => 'Odgovor',
        'Article Create Times' => 'Vremena kreiranja lanka',
        'Article Type' => 'Tip lanka',
        'Article created' => 'Kreiran lanak',
        'Article created between' => 'lanak kreiran izmeu',
        'Article filter settings' => 'Podeavanje filtera za lanke',
        'Attach' => 'Prikai',
        'Attribute' => 'Atribut',
        'Auto Response From' => 'Automatski odgovor od',
        'Bounce ticket' => 'Preusmeri tiket',
        'CSV' => '"CSV"',
        'Can not create link with %s!' => 'Ne moe se napraviti veza sa %s!',
        'Can not delete link with %s!' => 'Veza sa %s se ne moe obrisati!',
        'Can\'t update password, must be at least %s characters!' => 'Lozinka se ne moe aurirati, mora biti duga najmanje %s znakova.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Lozinka se ne moe aurirati. Mora da sadri najmanje dva mala i dva velika slova.',
        'Can\'t update password, needs at least 1 digit!' => 'Lozinka se ne moe aurirati, neophodno je da sadri bar jednu cifru!',
        'Can\'t update password, needs at least 2 characters!' => 'Lozinka se ne moe aurirati. Nedostaju najmanje dva znaka!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Lozinka se ne moe aurirati, nova lozinka se ne podudara! Molimo pokuajte ponovo!',
        'Category Tree' => 'Stablo kategorija',
        'Change %s settings' => 'Promeni %s podeavanja',
        'Change Time' => 'Promeni vreme',
        'Change Times' => 'Promeni vremena',
        'Change free text of ticket' => 'Promeni slobodan tekst za tiket',
        'Change owner of ticket' => 'Promeni vlasnika tiketa',
        'Change priority of ticket' => 'Promeni prioritet tiketa',
        'Change responsible of ticket' => 'Promeni odgovornog za tiket',
        'Change user <-> group settings' => 'Promena korisnika <-> Podeavanje grupe',
        'ChangeLog' => 'Dnevnik promena',
        'Check Mail Configuration' => 'Proveri konfiguraciju e-mejla',
        'Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behind a dial-up line!' => 'Proverite "MX" zapise upotrebljenih e-mejl adresa  kreiranjem odgovora. Nemojte koristiti ovu funkciju ako je va "OTRS" server na "dial-up" liniji.',
        'Child-Object' => 'Deca objekti',
        'City{CustomerUser}' => 'Mesto (korisnik)',
        'Classification' => 'Klasifikacija',
        'Clear From' => 'Od: obrii',
        'Clear To' => 'Obrii Za:',
        'Click here to report a bug!' => 'Kliknite ovde za prijavu greke!',
        'Close Times' => 'Vremena zatvaranja',
        'Close ticket' => 'Zatvori tiket',
        'Close type' => 'Tip zatvaranja',
        'Close!' => 'Zatvori!',
        'Collapse View' => 'Zugeklappte Ansicht',
        'Comment (internal)' => 'Komentar (interno)',
        'CompanyTickets' => 'Tiketi firme',
        'Compose Answer' => 'Napii odgovor',
        'Compose Email' => 'Napii e-mejl',
        'Compose Follow up' => 'Napravi nastavak',
        'Config Options' => 'Konfiguracione opcije',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Konfiguracione opcije (npr. <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Konfiguracione opcije (npr. <OTRS_CONFIG_HttpType).',
        'Contact customer' => 'Kotaktirajte korisnika',
        'Country{CustomerUser}' => 'Drava (korisnik)',
        'Create New Template' => 'Napravi novi ablon',
        'Create Times' => 'Vremena otvaranja',
        'Create new Phone Ticket' => 'Otvori novi telefonski tiket',
        'Create new database' => 'Kreirajte novu bazu podataka',
        'CreateTicket' => 'Otvaranje tiketa',
        'Current Impact Rating' => 'Ocena trenutnog uticaja',
        'Customer Move Notify' => 'Obavetenje o premetanju korisnika',
        'Customer User' => 'Korisnik',
        'Customer User Management' => 'Upravljanje korisnicima',
        'Customer Users' => 'Korisnici',
        'Customer Users <-> Groups' => 'Korisnici <-> Grupe',
        'Customer Users <-> Groups Management' => 'Korisnici <-> Upravljanje grupama',
        'Customer Users <-> Services' => 'Korisnici <-> Servisi',
        'Customer Users <-> Services Management' => 'Korisnici <-> Upravljanje servisima',
        'Customer history' => 'Istorijat korisnika',
        'Customer history search' => 'Pretraivanje istorijata za korisnika',
        'Customer history search (e. g. "ID342425").' => 'Pretraga istorijata korisnika (npr. "ID342425").',
        'CustomerID{CustomerUser}' => 'ID korisnika.',
        'CustomerUser' => 'Korisnik',
        'D' => 'D',
        'DB Admin Password' => 'Lozinka administratora BP',
        'DB Admin User' => 'DB Adminstrator',
        'DB connect host' => 'Ime ili adresa DB servera',
        'Default' => 'Podrazumevano',
        'Default Charset' => 'Podrazumevani karakterset',
        'Default Language' => 'Podrazumevani jezik',
        'Delete old database' => 'Obrii staru bazu podataka',
        'Detail' => 'Detalji',
        'Diff' => 'Razlike',
        'Discard all changes and return to the compose screen' => 'Odustanite od svih promena i vratite se na prozor za pisanje.',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Otpemi il filtriraj dolazne porukena osnovu "X-Headers"! "RegExp" je takoe mogu.',
        'Do you really want to delete this Objecta' => 'Da li stvarno elite da obriete ovaj objekta',
        'Do you really want to reinstall this package (all manual changes get lost)a' => 'Da li stvarno elite da reinstalirate ovaj paket (sve rune promene e biti izgubljene)a',
        'Do you really want to uninstall this packagea' => 'Da li stvarno elite da deinstalirate ovaj paketa',
        'Does your SMTP host need authenticationa' => 'Da li va "SMTP"-domain zahteva autentikacijua',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ne zaboravite da dodate novog korisnika u grupe i uloge!',
        'Don\'t forget to add a new user to groups!' => 'Ne zaboravite da dodate novog korisnika nekoj grupi!',
        'Download Settings' => 'Preuzmite podeavanja',
        'Drop Database' => 'Obrii bazu podataka',
        'Dynamic-Object' => 'Dinamiki objekat',
        'Edit Customers' => 'Uredi korisnike',
        'Edit default services.' => 'Uredi podrazumevane servise.',
        'Email based' => 'Na osnovu e-mejla',
        'Email of the system admin.' => 'E-mejl adresa administratora sistema.',
        'Email{CustomerUser}' => 'E-mejl (korisnik)',
        'Escalation' => 'Eskalacija',
        'Escalation - First Response Time' => 'Eskalacija - Vreme reakcije',
        'Escalation - Solution Time' => 'Eskalacija - Vreme reavanja',
        'Escalation - Update Time' => 'Eskalacija - Vreme auriranja',
        'Escalation Times' => 'Vremena eskalacije',
        'Escalation time' => 'Vreme eskalacije',
        'Event is required!' => 'Dogaaj je obavezan!',
        'Expand View' => 'Ausgeklappte Ansicht',
        'Explanation' => 'Objanjenje',
        'Export Config' => 'Izvoz konfiguracije',
        'FAQ Search Result' => 'Rezultat pretrage "FAQ"',
        'FAQ System History' => 'Istorijat "FAQ" sistema',
        'Fax{CustomerUser}' => 'Faks (korisnik)',
        'File-Name' => 'Naziv datoteke',
        'File-Path' => 'Putanja do datoteke',
        'Filelist' => 'Lista datoteka',
        'Filtername' => 'Naziv filtera',
        'Firstname{CustomerUser}' => 'Ime (korisnik)',
        'Follow up' => 'Nastavak',
        'For very complex stats it is possible to include a hardcoded file.' => 'Za veoma sloene statistike mogue je pridruiti namenski programiranu datoteku.',
        'Forgot passworda' => 'Zaboravili ste lozinkua',
        'Foward ticket: ' => 'Prosledi tiket',
        'Frontend' => 'Interfejs',
        'Full qualified domain name of your system.' => 'Puno kvalifikovano ime domena vaeg sistema npr "otrs-server.example.org"',
        'Go' => 'Idi',
        'Group Ro' => 'Grupa "ro"',
        'Group based' => 'Na osnovu grupe',
        'Group selection' => 'Izbor grupe',
        'Hash' => 'Hash',
        'Have a lot of fun!' => 'Uivajte!',
        'Have you lost your passworda' => 'Da li ste izgubili vau lozinkua',
        'Help' => 'Pomo',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ovde moete podesiti X osu. Moete izabrati jedan element od ponuenih opcija. Ukoliko nita ne izaberete, svi elementi e biti upotrtebljeni ako pravite statistiku. Takoe, novi atribut je dodan nakon poslednje konfiguracije.',
        'Here you can insert a description of the stat.' => 'Ovde moete uneti opis statistike.',
        'Here you can select the dynamic object you want to use.' => 'Ovde moete izabrati dinamike objekte koje elite da koristite.',
        'Home' => 'Poetna',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Ako je nova programirana datoteka dostupna, ovaj atribut e biti prikazan i moi ete da izaberete jedan.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ako je tiket zatvoren, a korisnik poalje nastavak, tiket e biti zakljuan za starog vlasnika.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ako nee biti odgovoreno na tiket u ovom vremenu, onda e samo ovaj tiket biti prikazan.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ako zaposleni zakljua tiket i ne odgovori za ovo vreme, tiket e automatski biti otkljuan. Ovaj tiket je onda vidljiv svim drugim zaposlenim.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Ako nita nije izabrano, onda nema ni dozvola u ovoj grupi (tiketi nee biti dostupni za korisnika).',
        'If you need the sum of every column select yes.' => 'Ukoliko vam je potrebna suma svake kolone, izaberite "Da".',
        'If you need the sum of every row select yes' => 'Ako vam je potrebna suma svakog reda, izaberite "Da".',
        'If you use a graph as output format you have to select at least one graph size.' => 'Ako koristite grafikon kao izlazni format morate izabrati najmanje jednu veliinu grafikona.',
        'Image' => 'Slika',
        'Important' => 'Vano',
        'Imported' => 'Uvezeno',
        'Imported by' => 'Uvezao',
        'In order to experience OTRS, you\'ll need to enable Javascript in your browser.' => 'Kako bi ste maksimalno iskoristili sve mogunosti "OTRS" sistema, potrebno je da aktivrate Java skript u vaem Web itau.',
        'In this form you can select the basic specifications.' => 'Ovo je mesto za izbor optih podataka.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Na ovaj nain moete neposredno urediti kljueve podeene u datoteci "Kernel/Config.pm".',
        'Inbound Mail Password' => 'Lozinka dolazne pote',
        'Inbound Mail Type' => 'Tip dolazne pote',
        'Inbound Mail User' => 'Primalac pote',
        'Inbound Mail host' => 'raunar domain dolazne pote',
        'Information about the Stat' => 'Informacije o statistici',
        'Insert of the common specifications' => 'Unos optih podataka',
        'Instance' => 'Instanca',
        'Is Job Valid' => 'Da li je posao vaei',
        'Is Job Valida' => 'Da li je posao vaeia',
        'It\'s useful for ASP solutions.' => 'Korisno za "ASP" reenja.',
        'Job-List' => 'Lista poslova',
        'Keyword' => 'Kljuna re',
        'Keywords' => 'Kljune rei',
        'Kill session' => 'Prekini sesiju',
        'Last update' => 'Poslednje auriranje',
        'Lastname{CustomerUser}' => 'Prezime (korisnik)',
        'Link Table' => 'Tabela veza',
        'Link to Parent' => 'Povei sa roditeljem',
        'LinkType' => 'Tip veze',
        'Linked as' => 'Povezano kao',
        'Load' => 'Uitaj',
        'Load Settings' => 'Uitaj podeavanja',
        'Logfile' => 'Dnevnik',
        'Logfile just needed for File-LogModule!' => 'Datoteka dnevnika je neophodna za Modul dnevnika.',
        'Logfile too large, you need to reset it!' => 'Datoteka dnevnika je prevelika, treba da je resetujete!',
        'Login failed! Your username or password was entered incorrectly.' => 'Neuspena prijava! Vae korisniko ime ili lozinka su netano uneti.',
        'Lookup' => 'Pronalaenje',
        'Lost your passworda' => 'Izgubili ste lozinkua',
        'Mail Management' => 'Upravljanje potom',
        'Mailbox' => 'Potansko sandue',
        'Match' => 'Poklapanje',
        'Message for new Owner' => 'Poruka za novog vlasnika',
        'Message sent to' => 'Poruka poslata za',
        'Misc' => 'Ostalo',
        'Mobile{CustomerUser}' => 'Mobilni (korisnik)',
        'Modified' => 'Promenjeno',
        'Modules' => 'Moduli',
        'Move notification' => 'Premetanje obavetenja',
        'Multiple selection of the output format.' => 'Viestruki izbor izlaznog formata.',
        'My Queue' => 'Moj red',
        'MyTickets' => 'Moji tiketi',
        'Name is required!' => 'Ime je obavezno!',
        'Need a valid email address or don\'t use a local address!' => 'Neophodna je ispravna e-mejl adresa ili nemojte koristiti lokalnu adresu!',
        'New Agent' => 'Novi zaposleni',
        'New Customer' => 'Novi korisnik',
        'New Group' => 'Nova grupa',
        'New Group Ro' => 'Nova grupa "Ro"',
        'New Password' => 'Nova lozinka',
        'New Priority' => 'Nov prioritet',
        'New SLA' => 'Novi "SLA"',
        'New Service' => 'Novi servis',
        'New State' => 'Novi status',
        'New Ticket Lock' => 'Zakljuavanje novih tiketa',
        'New Title' => 'Novi naslov',
        'New Type' => 'Novi tip',
        'New account created. Sent Login-Account to %s.' => 'Napravljen novi nalog. Podaci za prijavu poslati %s.',
        'New messages' => 'Nove poruke',
        'New password again' => 'Nova lozinka (ponovo)',
        'Next Week' => 'Sledea sedmica',
        'No * possible!' => 'Nije "*" mogue!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'U mrenom spremitu nema paketa za traeni sistem, tu su samo paketi za druge verzije.',
        'No Permission' => 'Nema dozvole',
        'No change time settings.' => 'Nema promene vremena',
        'No matches found' => 'Nita nije pronaeno',
        'No time settings.' => 'Nema podeavanja vremena.',
        'Node-Name' => 'Naziv vora',
        'Not yet registereda' => 'Niste registrovania',
        'Note' => 'Napomena',
        'Note Text' => 'Tekst napomene',
        'Notification (Customer)' => 'Obavetenje (korisnik)',
        'Notifications' => 'Obavetenja',
        'OTRS DB Password' => '"OTRS" BP Lozinka',
        'OTRS sends an notification email to the customer if the ticket is moved.' => '"OTRS" alje obavetenje korisniku ako je tiket premeten.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => '"OTRS" alje obavetenje korisniku ako je promenjen vlasnik tiketa.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => '"OTRS" alje e-mejl sa obavetenjem korisniku ukoliko se promeni status tiketa.',
        'Object already linked as %s.' => 'Objekat je ve povezan kao %s.',
        'Of couse this feature will take some system performance it self!' => 'Kada je ova funkcija aktivna, zauzee deo sistemskih performansi.',
        'One or more errors occured!' => 'Dogodila se jadna ili vie greaka!',
        'Only for ArticleCreate Event.' => 'Samo za dogaaj kreiranja lanka.',
        'Open Tickets' => 'Otvoreni tiketi',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcije za podatke aktuelnog korisnika (npr. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opcije podataka za aktuelnog korisnika (npr. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Podeavanja za korisnika koji je zahtevao ovu akciju (npr. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Informacije o aktuelnom korisniku koji je traio ovu akciju (npr. <OTRS_CURRENT_UserFirstname>)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opcije pdataka o tiketu (npr. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcije podataka o tiketu (npr. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcije podataka o tiketu (npr. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Order' => 'Sortiranje',
        'Other Options' => 'Druge opcije',
        'Out Of Office' => 'Van kancelarije',
        'Outbound Mail Type' => 'Tip odlazne pote',
        'POP3 Account Management' => 'Upravljanje "POP3" nalozima',
        'Package' => 'Paket',
        'Param 1' => 'Param 1',
        'Param 2' => 'Param 2',
        'Param 3' => 'Param 3',
        'Param 4' => 'Param 4',
        'Param 5' => 'Param 5',
        'Param 6' => 'Param 6',
        'Parent-Object' => 'Objekat roditelj',
        'Password for Inbound Mail' => 'Lozinka za dolaznu potu',
        'Password for SMTP Auth' => 'Lozinka za "SMTP" autentikaciju',
        'Password is already in use! Please use an other password!' => 'Dieses Password wird bereits benutzt, es kann nicht verwendet werden!',
        'Password is already used! Please use an other password!' => 'Ova lozinka je ve u upotrebi, molimo odaberite neku drugu!!',
        'Passwords doesn\'t match! Please try it again!' => 'Lozinke se ne poklapaju! Molimo pokuajte ponovo!',
        'Pending Times' => 'Vremena ekanja',
        'Pending messages' => 'Poruke na ekanju',
        'Pending type' => 'Tip ekanja',
        'Permissions to change the ticket owner in this group/queue.' => 'Pravo na promenu vlasnika tiketa u ovoj Grupi/Redu.',
        'PhoneView' => 'Pregled telefona',
        'Phone{CustomerUser}' => 'Telefon (korisnik)',
        'Please contact your admin' => 'Molimo kontaktirajte vaeg administratora',
        'Prio' => 'Prioritet',
        'Process-Path' => 'Prozess-Path',
        'Product' => 'Proizvod',
        'Queue <-> Auto Responses Management' => 'Red <-> Upravljanje automatskim odgovorima',
        'Queue Management' => 'Upravljanje redovima',
        'Queue is required.' => 'Red je obavezan.',
        'QueueView' => 'Pregled reda',
        'Queues <-> Auto Responses' => 'Queues <-> Auto Antworten',
        'Realname' => 'Pravo ime',
        'Rebuild' => 'Napravi ponovo',
        'Recipients' => 'Primaoci',
        'Refresh' => 'Osveavanje',
        'Reminder' => 'Podsetnik',
        'Reminder messages' => 'Poruke podsetnika',
        'Remove from list of subscribed tickets' => 'Ukloni sa liste pretplate',
        'Reporter' => 'Melder',
        'Required Field' => 'Obavezno polje',
        'Required!' => 'Obavezno!',
        'Response Management' => 'Upravljanje odgovorima',
        'Responses <-> Attachments Management' => 'Odgovori <-> Upravljanje prilozima',
        'Responses <-> Queue Management' => 'Odgovori <-> Upravljanje redovima',
        'Role' => 'Uloga',
        'Roles <-> Groups Management' => 'Uloge <-> Upravljanje grupama',
        'Roles <-> Users' => 'Uloge <-> Korisnici',
        'Roles <-> Users Management' => 'Uloge <-> Upravljanje korisnicima',
        'SMTP Auth Password' => '"SMTP" Lozinka',
        'SMTP Auth User' => 'SMTP Auth Benutzer',
        'SMTP Authentication' => 'SMTP-Authentifizierung',
        'Save Job asa' => 'Sauvaj posao kaoa',
        'Save Search-Profile as Templatea' => 'Sauvaj profil pretrage kao ablona',
        'Save as Templatea' => 'Sauvati kao ablona',
        'Schedule' => 'Raspored',
        'Search Result' => 'Rezultat pretrage',
        'Search for' => 'Potraga za',
        'Secure Mode need to be enabled!' => 'Potrebno je aktivirati siguran mod!',
        'Select Box' => 'Okvir za izbor',
        'Select Source (for add)' => 'Izaberi izvor (za dodavanje)',
        'Select inbound mail type' => 'Izaberi tip dolazne pote',
        'Select outbound mail type' => 'Izaberi tip odlazne pote',
        'Select the customeruser:service relations.' => 'Izaberite Korisnik:servis veze.',
        'Select the element, which will be used at the X-axis' => 'Izaberi element koji e biti upotrebljen na X-osi.',
        'Select the restrictions to characterise the stat' => 'Izaberite ogranienja koja karakteriu statistiku',
        'Select the role:user relations.' => 'Izaberite ulogu:korisnike veze.',
        'Select the user:group permissions.' => 'Izaberite korisnika:grupne dozvole.',
        'Select your QueueView refresh time.' => 'Odaberite vreme osveavanja pregleda reda.',
        'Select your default spelling dictionary.' => 'Odaberite podrazumevani renik za proveru pravopisa.',
        'Select your frontend Charset.' => 'Izaberite karakterset vaeg interfejsa.',
        'Select your frontend QueueView.' => 'Izaberite pregled reda.',
        'Select your frontend language.' => 'Izaberite jezik interfejsa.',
        'Select your out of office time.' => 'Odaberite vae vanradno vreme.',
        'Select your screen after creating a new ticket.' => 'Izaberite prozor koji se prikazuje nakon otvaranja novog tiketa.',
        'Selection needed' => 'Neophodan izbor',
        'Send Notification' => 'Poalji obavetenje',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Obavesti me ukoliko korisnik poalje nastavak, a ja sam vlasnik ovog tiketa.',
        'Sent new password to: ' => 'Poalji novu lozinku za: ',
        'Sent new password to: %s' => 'Poslata nova lozinka za %s.',
        'Sent password token to: %s' => 'Poslana lozinka za: %s.',
        'Service-Name' => 'Naziv servisa',
        'Sessions' => 'Sesije',
        'Set customer user and customer id of a ticket' => 'Podesi korisnika i korisniki ID za tiket',
        'Show' => 'Prikai',
        'Site' => 'Strana',
        'Solution' => 'Reenje',
        'Sort by' => 'Sortirano po',
        'Source' => 'Izvor',
        'Spell Check' => 'Provera pravopisa',
        'Split' => 'Podeli',
        'State Type' => 'Tip stanja',
        'Static-File' => 'Statina datoteka',
        'Stats-Area' => 'Prostor statistike',
        'Step %s of %s' => 'Korak %s od %s',
        'Street{CustomerUser}' => 'Ulica (korisnik)',
        'Sub-Queue of' => 'Sub-red od',
        'Sub-Service of' => 'Subservis od',
        'Subscribe' => 'Pretplati se',
        'System State Management' => 'Upravljanje statusom sistema',
        'System Status' => 'Status sistema',
        'Systemaddress' => 'Sistemska adresa',
        'Text is required!' => 'Tekst je obavezan',
        'The customer id is required!' => 'ID korisnika je obavezan!',
        'The customer is required!' => 'Korisnik je obavezan!',
        'The customer is required.' => 'Korisnik je obavezan.',
        'The field is required.' => 'Polje je obavezno.',
        'The identify of the system. Each ticket number and each http session id starts with this number.' => 'Identitet sistema. Svaki broj tiketa i svaki ID "HTTP" sesije poinje sa ovim brojem.',
        'The message being composed has been closed.  Exiting.' => 'Poruka koja se pie je zatvorena.',
        'The subject is required!' => 'Predmet je obavezan!',
        'The subject is required.' => 'Predmet je obavezan.',
        'The text is required!' => 'Tekst je obavezan!',
        'The text is required.' => 'Tekst je obavezan.',
        'These values are read-only.' => 'Ove vrednosti su samo za itanje.',
        'These values are required.' => 'Ove vrednosti su obavezne.',
        'This account exists.' => 'Ovaj nalog postoji.',
        'This email address already exists. Please log in or reset your password..' => 'Ova e-mejl adresa ve postoji. Molimo, prijavite se ili resetujte vau lozinku',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ovo je korisno ukoliko ne elite da iko vidi rezultate statistike ili konfiguracija statistike nije zavrena.',
        'Ticket Escalation View' => 'Eskalacioni pregled tiketa',
        'Ticket Lock' => 'Zakljuan tiket',
        'Ticket Number Generator' => 'Generator broja tiketa',
        'Ticket Search' => 'Pretraga tiketa',
        'Ticket Status View' => 'Pregled statusa tiketa',
        'Ticket Type is required!' => 'Tip tiketa je obavezan!',
        'Ticket changed' => 'Promenjen tiket',
        'Ticket changed between' => 'Tiket promenjen izmeu',
        'Ticket escalation!' => 'Eskalacija tiketa!',
        'Ticket locked!' => 'Zakljuan tiket!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcije vlasnika tiketa (npr. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Detalji o opcijama vlasnika (z. B. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opcije o odgovornosti za tiket (z. B.<OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'Tiket izabran za masovnu akciju',
        'Ticket type is required.' => 'Tip tiketa je obavezan.',
        'Ticket unlock!' => 'Otkljuavanje tiketa!',
        'Ticket#' => 'Tiket Br.',
        'Ticket-Area' => 'Prostor tiketa',
        'TicketFreeText' => 'TicketFreeText',
        'TicketZoom' => 'Sadraj tiketa',
        'Tickets available' => 'Dostupne kartice',
        'Tickets shown' => 'Prikazani tiketi',
        'Tickets which need to be answered!' => 'Tiketi na koje treba odgovoriti!',
        'Time units is a required field!' => 'Vremenske jedinice su obavezno polje.',
        'Time units is a required field.' => 'Vremenske jedinice su obavezno polje.',
        'Time units is required field.' => 'Vremenske jedinice su obavezno polje.',
        'Timeover' => 'Zeit abgelaufen',
        'Times' => 'Vremena',
        'Title is required.' => 'Naslov je obavezan.',
        'Title of the stat.' => 'Naslov statistike.',
        'Title{CustomerUser}' => 'Titula (korisnik)',
        'Title{user}' => 'Titula',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Da bi videli atribute lanka (npr. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> und <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Die Artikel Attribute (z. B. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'To get the first 5 lines of the body (poslednjeg lanka zaposlenog).' => 'Da vidite prvih 5 linija poruke (poslednjeg lanka zaposlenog).',
        'Today' => 'danas',
        'Tomorrow' => 'Sutra',
        'Top of Page' => 'Vrh strane',
        'Total hits' => 'Ukupno pogodaka',
        'U' => 'U',
        'Unable to parse Online Repository index document!' => 'Nije mogue ralaniti indeks mrenog skladita!',
        'Unlock Tickets' => 'Otkljuaj tikete',
        'Unsubscribe' => 'Otkai pretplatu',
        'Use utf-8 it your database supports it!' => 'Koristite "utf-8" samo ako ga vaa baza podataka podrava!',
        'Useable options' => 'Upotrebljive opcije',
        'Used default language.' => 'Upotrebljeni podrazumevani jezik.',
        'Used log backend.' => 'Upotrebljena metoda beleenja dnevnika.',
        'User Management' => 'Upravljanje korisnicima',
        'User for Inbound Mail' => 'Korisnik za prijem pote',
        'User will be needed to handle tickets.' => 'Neophodan je zaposleni za obradu tiketa.',
        'User-Name' => 'Korisniko ime',
        'User-Number' => 'Korisnik broj',
        'Username for SMTP Auth' => 'Korisniko ime za "SMTP" autentikaciju',
        'Username{CustomerUser}' => 'Korisniko ime (korisnik)',
        'Users' => 'Korisnici',
        'Users <-> Groups' => 'Korisnici <-> Grupe',
        'Users <-> Groups Management' => 'Korisnici <-> Upravljanje grupama',
        'Verify New Password' => 'Potvrdi novu lozinku',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Panja! Ovi tiketi e biti uklonjeni iz baze i trajno izgubljeni!',
        'Watch notification' => 'Praenje obavetenja',
        'Web-Installer' => 'Web-Instalacija',
        'Welcome to OTRS' => 'Dobrodoli u "OTRS"',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Unosom i izborom polja moete konfigurisati statistiku prema vaim potreama. Koje elemente statistike moete menjati zavisi od administratora koji je konfigurisao statistiku.',
        'Workflow Groups' => '"Workflow" Grupe',
        'X-axis' => 'X-Osa',
        'Yes, save it with name' => 'Da, sauvaj sa imenom',
        'You got new message!' => 'Primili ste novu poruku!',
        'You need a to: recipient!.' => 'Primalac, polje "Za:" je obavezno!',
        'You need to account time!' => 'Potrebno je da se obrauna vreme!',
        'You need to activate %s first to use it!' => 'Morate aktivirati %s pre upotrebe!',
        'Your Password' => 'Vaa lozinka',
        'Your email address is new' => 'Vaa e-mejl adresa je nova',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Va e-mejl sa tiketom broj "<OTRS_TICKET>" je preusmeren za "<OTRS_BOUNCE_TO>". Kontaktirajte na tu adresu za dodatne informacije.',
        'Your own Ticket' => 'Va tiket',
        'Zip{CustomerUser}' => 'PB (korisnik)',
        'customer realname' => 'pravo ime korisnika',
        'delete' => 'obrii',
        'delete links' => 'Obrii veze',
        'down' => 'dole',
        'false' => 'false',
        'for agent firstname' => 'za ime zaposlenog',
        'for agent lastname' => 'za prezime zaposlenog',
        'for agent login' => 'za prijavu zaposlenih',
        'for agent user id' => 'za korisniki ID zaposlenog',
        'go back' => 'nazad',
        'kill all sessions' => 'Zatvori sve sesije',
        'modified' => 'promenjeno',
        'new ticket' => 'Novi tiket',
        'next step' => 'naredni korak',
        'not rated' => 'nije ocenjeno',
        'not verified' => 'nije provereno',
        'read' => 'itaj',
        'send' => 'Poalji',
        'sort downward' => 'sortiraj opadajue',
        'sort upward' => 'sortiraj rastue',
        'tmp_lock' => 'zaknjuavalje (privremeno)',
        'to get the first 20 character of the subject' => 'Da vidite prvih 20 slova predmeta',
        'to get the first 5 lines of the email' => 'da vidite prvih 5 linija poruke',
        'to get the realname of the sender (if given)' => 'da vidite pravo ime poiljaoca (ako je mogue)',
        'unknown' => 'nepoznato',
        'unread' => 'neproitano',
        'up' => 'ukljueno',
        'utf8' => '"utf8"',
        'verified' => 'provereno',
        'x' => 'x',
    };
    # $$STOP$$
    return;
}

1;
