# --
# Kernel/Language/hr.pm - provides Croatian language Latin translation
# Copyright (C) 2001-2012 OTRS AG, http://otrs.org/
# Copyright (C) 2011 Damir Dzeko <damir punkt dzeko masterspace inet.hr>
# --
# $Id: hr.pm,v 1.1.2.4 2012/03/09 07:37:05 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

# to be edited in ISO-8859-2 codepage, with UNIX-style line endings (LF)
# based on Serbian translation (Croatian translation is still incomplete)

package Kernel::Language::hr;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.1.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2012-03-09 08:31:54

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%T - %D.%M.%Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Da',
        'No' => 'Ne',
        'yes' => 'da',
        'no' => 'ne',
        'Off' => 'Isklj.',
        'off' => 'isklj.',
        'On' => 'Uklj.',
        'on' => 'uklj.',
        'top' => 'vrh',
        'end' => 'kraj',
        'Done' => 'Gotovo',
        'Cancel' => 'Odustani',
        'Reset' => 'Reset',
        'last' => 'zadnje',
        'before' => 'prije',
        'Today' => 'danas',
        'Tomorrow' => 'Sutra',
        'Next Week' => 'Sledea sedmica',
        'day' => 'dan',
        'days' => 'dani',
        'day(s)' => 'dan(i)',
        'd' => '',
        'hour' => 'sat',
        'hours' => 'sati',
        'hour(s)' => 'sat(i)',
        'Hours' => 'Sati',
        'h' => '',
        'minute' => 'minuta',
        'minutes' => 'minute',
        'minute(s)' => 'minuta/e',
        'Minutes' => 'Minute',
        'm' => '',
        'month' => 'mjesec',
        'months' => 'mjeseci',
        'month(s)' => 'mjesec(i)',
        'week' => 'tjedan',
        'week(s)' => 'sedmica/e',
        'year' => 'godina',
        'years' => 'godine',
        'year(s)' => 'godin(e)',
        'second(s)' => 'sekunda/e',
        'seconds' => 'sekundi',
        'second' => 'sekunda',
        's' => '',
        'wrote' => 'napisao',
        'Message' => 'Poruka',
        'Error' => 'Pogreka',
        'Bug Report' => 'Prijava pogreke',
        'Attention' => 'Pozor',
        'Warning' => 'Upozorenje',
        'Module' => 'Modul',
        'Modulefile' => 'Datoteka modula',
        'Subfunction' => 'Podfunkcija',
        'Line' => 'Redak',
        'Setting' => 'Postavka',
        'Settings' => 'Postavka',
        'Example' => 'Primjer',
        'Examples' => 'Primjeri',
        'valid' => 'ispravno',
        'invalid' => 'neispravno',
        '* invalid' => '* neispravno',
        'invalid-temporarily' => 'neispravno-privremeno',
        ' 2 minutes' => ' 2 minute',
        ' 5 minutes' => ' 5 minuta',
        ' 7 minutes' => ' 7 minuta',
        '10 minutes' => '10 minuta',
        '15 minutes' => '15 minuta',
        'Mr.' => 'G.',
        'Mrs.' => 'G.',
        'Next' => 'Sljedee',
        'Back' => 'Prethodno',
        'Next...' => 'Dalje...',
        '...Back' => '...Natrag',
        '-none-' => '-niti-jedan-',
        'none' => 'nema',
        'none!' => 'nema unosa!',
        'none - answered' => 'nema - odgovoreno',
        'please do not edit!' => 'Molimo ne mijenjajte!',
        'Need Action' => 'Potrebna akcija',
        'AddLink' => 'Dodaj vezu',
        'Link' => 'Stvori vezu',
        'Unlink' => 'Raskini vezu',
        'Linked' => 'Povezano',
        'Link (Normal)' => 'Veza (Normalno)',
        'Link (Parent)' => 'Veza (Nadreeno)',
        'Link (Child)' => 'Veza (Podreeno)',
        'Normal' => 'Normalno',
        'Parent' => 'Nadreeno',
        'Child' => 'Podreeno',
        'Hit' => 'Pogodak',
        'Hits' => 'Pogotci',
        'Text' => 'Tekst',
        'Standard' => 'Normalan',
        'Lite' => 'Jednostavan',
        'User' => 'Korisnik',
        'Username' => 'Korisniko ime',
        'Language' => 'Jezik',
        'Languages' => 'Jezici',
        'Password' => 'Lozinka',
        'Preferences' => 'Postavke',
        'Salutation' => 'Zaglavlje/pozdrav',
        'Salutations' => 'Zaglavlja/pozdravi',
        'Signature' => 'Podnoje/potpis',
        'Signatures' => 'Podnoja/potpisi',
        'Customer' => 'Korisnik',
        'CustomerID' => 'ID korisnika',
        'CustomerIDs' => 'ID korisnika',
        'customer' => 'korisnik',
        'agent' => 'Zaposlenik',
        'system' => 'Sustav',
        'Customer Info' => 'Korisniki info',
        'Customer Information' => 'Informacije o korisniku',
        'Customer Company' => 'Korisnikova tvrtka',
        'Customer Companies' => 'Korisnikove tvrtke',
        'Company' => 'Tvrtka',
        'go!' => 'Start!',
        'go' => 'Start',
        'All' => 'Sve',
        'all' => 'sve',
        'Sorry' => 'Oprostite',
        'update!' => 'auriranje!',
        'update' => 'auriranje',
        'Update' => 'Auriranje',
        'Updated!' => 'Aurirano!',
        'submit!' => 'poalji!',
        'submit' => 'poalji',
        'Submit' => 'Poalji',
        'change!' => 'promjena!',
        'Change' => 'Promjena',
        'change' => 'promjena',
        'click here' => 'kliknite ovdje',
        'Comment' => 'Komentar',
        'Valid' => 'Ispravno',
        'Invalid Option!' => 'Neispravna opcija!',
        'Invalid time!' => 'Neispravno vrijeme!',
        'Invalid date!' => 'Neispravan datum!',
        'Name' => 'Ime',
        'Group' => 'Grupa',
        'Description' => 'Opis',
        'description' => 'opis',
        'Theme' => 'Tema',
        'Created' => 'Kreirano',
        'Created by' => 'kreirao',
        'Changed' => 'Mijenjeno',
        'Changed by' => 'mijenjao',
        'Search' => 'Trai',
        'and' => 'i',
        'between' => 'izmeu',
        'Fulltext Search' => 'Tekst za pretragu',
        'Data' => 'Podaci',
        'Options' => 'Opcije',
        'Title' => 'Naslov',
        'Item' => 'Stavka',
        'Delete' => 'Izbrisati',
        'Edit' => 'Mijenjati',
        'View' => 'Pregled',
        'Number' => 'Broj',
        'System' => 'Sistem',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakti',
        'Export' => 'Izvoz',
        'Up' => 'Gore',
        'Down' => 'Dole',
        'Add' => 'Dodati',
        'Added!' => 'Dodano!',
        'Category' => 'Kategorija',
        'Viewer' => 'Prikaziva',
        'Expand' => 'Proiri',
        'Small' => 'Sitno',
        'Medium' => 'Srednje',
        'Large' => 'Krupno',
        'Date picker' => 'Izbor datuma',
        'New message' => 'Nova poruka',
        'New message!' => 'Nova poruka!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Molimo, odgovorite na ovu karticu da bi ste se vratili na normalan pregled repa!',
        'You have %s new message(s)!' => 'Imate %s novih poruka!',
        'You have %s reminder ticket(s)!' => 'Imate %s kartica podsjetnika!',
        'The recommended charset for your language is %s!' => 'Preporuena kodna stranica za va jezik je %s!',
        'Change your password.' => 'Promjenite lozinku.',
        'Please activate %s first!' => 'Molimo, prvo aktivirajte %s.',
        'No suggestions' => 'Nema sugestija',
        'Word' => 'rije',
        'Ignore' => 'Zanemari',
        'replace with' => 'zamijeni sa',
        'There is no account with that login name.' => 'Ne postoji raun s tim korisnikim imenom.',
        'Login failed! Your user name or password was entered incorrectly.' => 'Neuspjena prijava! Korisniko ime i/ili lozinka nisu valjani.',
        'There is no acount with that user name.' => 'Raun s tim korisnikim imenom',
        'Please contact your administrator' => 'Upuujemo Vas na vaeg administratora',
        'Logout' => 'Odjava',
        'Logout successful. Thank you for using OTRS!' => 'Uspjeno ste se odjavili! Hvala to ste koristili OTRS!',
        'Invalid SessionID!' => 'Neispravan ID sesije!',
        'Feature not active!' => 'Funkcija nije aktivna!',
        'Agent updated!' => 'Auriran zaposlenik',
        'Create Database' => 'Kreiraj bazu podataka',
        'System Settings' => 'Postavke sustava',
        'Mail Configuration' => 'Podeavanje E-pote',
        'Finished' => 'Zareno',
        'Login is needed!' => 'Potrebna je prijava!',
        'Password is needed!' => 'Potrebna je lozinka!',
        'License' => 'Licenca',
        'Take this Customer' => 'Uzmi ovog korisnika',
        'Take this User' => 'Uzmi ovog korisnika sistema',
        'possible' => 'mogue',
        'reject' => 'odbaci',
        'reverse' => 'obrnuto',
        'Facility' => 'Instalacija',
        'Time Zone' => 'Vremenska zona',
        'Pending till' => 'eka do',
        'Don\'t use the Superuser account to work with OTRS! Create new Agents and work with these accounts instead.' => '',
        'Dispatching by email To: field.' => 'Otprema E-pote za: Polje.',
        'Dispatching by selected Queue.' => 'Otprema kroz izabrani rep.',
        'No entry found!' => 'Unos nije pronaen!',
        'Session has timed out. Please log in again.' => 'Vrijeme sesije je isteklo. Molimo prijavite se ponovno.',
        'No Permission!' => 'Nemate dozvolu!',
        'To: (%s) replaced with database email!' => 'Za: (%s) zamijenjena adresa E-pote onom iz baze!',
        'Cc: (%s) added database email!' => 'Kk: (%s) dodana adresa E-pote iz baze!',
        '(Click here to add)' => '(Klikni ovde za dodavanje)',
        'Preview' => 'Pregled',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paket nije korektno instaliran! Trebalo bi ga ponovno instalirati!',
        '%s is not writable!' => 'Ne moe se upisivati na %s!',
        'Cannot create %s!' => 'Ne moe se kreirati %s!',
        'Check to activate this date' => '',
        'Customer %s added' => 'Dodan korisnik %s.',
        'Role added!' => 'Dodana uloga!',
        'Role updated!' => 'Aurirana uloga',
        'Attachment added!' => 'Dodan prilog',
        'Attachment updated!' => 'Auriran prilog',
        'Response added!' => 'Dodan odgovor',
        'Response updated!' => 'Aurirana odgovor',
        'Group updated!' => 'Aurirana grupa',
        'Queue added!' => 'Dodan rep',
        'Queue updated!' => 'Auriran rep',
        'State added!' => 'Dodan status',
        'State updated!' => 'Auriran status',
        'Type added!' => 'Dodan tip',
        'Type updated!' => 'Auriran tip',
        'Customer updated!' => 'Auriran korisnik',
        'Contract' => 'Ugovor',
        'Online Customer: %s' => 'Korisnik na vezi: %s',
        'Online Agent: %s' => 'Zaposlenik na vezi: %s',
        'Calendar' => 'Kalendar',
        'File' => 'Datoteka',
        'Filename' => 'Naziv datoteke',
        'Type' => 'Tip',
        'Size' => 'Veliina',
        'Upload' => 'Otpremanje',
        'Directory' => 'Imenik',
        'Signed' => 'Potpisano',
        'Sign' => 'Potpis',
        'Crypted' => 'ifrirano',
        'Crypt' => 'ifra',
        'PGP' => 'PGP',
        'PGP Key' => 'PGP Klju',
        'PGP Keys' => 'PGP kljuevi',
        'S/MIME' => '"S/MIME" klju',
        'S/MIME Certificate' => 'S/MIME vjerodajnica',
        'S/MIME Certificates' => 'S/MIME vjerodajnice',
        'Office' => 'Ured',
        'Phone' => 'Telefon',
        'Fax' => 'Faks',
        'Mobile' => 'Mobilni',
        'Zip' => 'Broj pote',
        'City' => 'Mjesto',
        'Street' => 'Ulica',
        'Country' => 'Drava',
        'Location' => 'Lokacija',
        'installed' => 'instalirano',
        'uninstalled' => 'deinstalirano',
        'Security Note: You should activate %s because application is already running!' => 'Sigurnosna napomena: Trebalo bi omoguiti %s, jer je aplikacija ve pokrenuta!',
        'Unable to parse repository index document.' => 'Nije mogue ralaniti indeks spremita!',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => 'Nema paketa za verziju vaeg sustava, u spremitu su samo paketi za druge verzije.',
        'No packages, or no new packages, found in selected repository.' => 'U izabranom spremitu nema paketa ili nema novih paketa',
        'Edit the system configuration settings.' => 'Uredi konfiguracijske postavke sustava.',
        'printed at' => 'otisnuto u',
        'Loading...' => 'Uitavanje...',
        'Dear Mr. %s,' => 'Potovani gospodine %s,',
        'Dear Mrs. %s,' => 'Potovana gospoo %s,',
        'Dear %s,' => 'Dragi %s,',
        'Hello %s,' => 'Zdravo %s,',
        'This email address already exists. Please log in or reset your password.' => '',
        'New account created. Sent login information to %s. Please check your email.' => 'Kreiran novi raun. Podaci za prijavu poslani %s. Molimo provjerite vau E-potu.',
        'Please press Back and try again.' => 'Molimo pritisnite Natrag i pokuajte ponovo.',
        'Sent password reset instructions. Please check your email.' => 'Upute za resetiranje lozinke su poslane. Molimo provjerite vau E-potu.',
        'Sent new password to %s. Please check your email.' => 'Poslana je nova lozinka za %s. Provejrite vau E-potu.',
        'Upcoming Events' => 'Predstojei dogaaji',
        'Event' => 'Dogaaj',
        'Events' => 'Dogaaji',
        'Invalid Token!' => 'Neispravna oznaka!',
        'more' => 'jo',
        'For more info see:' => 'Za dodatne informacije pogledaj:',
        'Package verification failed!' => 'Neuspjela provjera paketa!',
        'Collapse' => 'Smanji',
        'Shown' => 'Prikazan',
        'News' => 'Novosti',
        'Product News' => 'Novosti o proizvodu',
        'OTRS News' => 'OTRS Novosti',
        '7 Day Stats' => 'Sedmodnevna statistika',
        'Bold' => 'Podebljano',
        'Italic' => 'Kurziv',
        'Underline' => 'Podvueno',
        'Font Color' => 'Boja slova',
        'Background Color' => 'Boja pozadine',
        'Remove Formatting' => 'Ukloni formatiranje',
        'Show/Hide Hidden Elements' => 'Pokai/Sakrij skrivene elemente',
        'Align Left' => 'Poravnaj nalijevo',
        'Align Center' => 'Centriraj',
        'Align Right' => 'Poravnaj nadesno',
        'Justify' => 'Poravnaj u blok',
        'Header' => 'Naslov',
        'Indent' => 'Uvlaenje',
        'Outdent' => 'Izvlaenje',
        'Create an Unordered List' => 'Napravi nesreenu listu',
        'Create an Ordered List' => 'Napravi sreenu listu',
        'HTML Link' => 'HTML veza',
        'Insert Image' => 'Ubaci sliku',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'Odustani',
        'Redo' => 'Ponovi',

        # Template: AAAMonth
        'Jan' => 'Sje',
        'Feb' => 'Velj',
        'Mar' => 'Ou',
        'Apr' => 'Tra',
        'May' => 'Svi',
        'Jun' => 'Lip',
        'Jul' => 'Srp',
        'Aug' => 'Kol',
        'Sep' => 'Ruj',
        'Oct' => 'Lis',
        'Nov' => 'Stu',
        'Dec' => 'Pro',
        'January' => 'sijeanj',
        'February' => 'veljaa',
        'March' => 'oujak',
        'April' => 'travanj',
        'May_long' => 'svibanj',
        'June' => 'lipanj',
        'July' => 'srpanj',
        'August' => 'kolovoz',
        'September' => 'rujan',
        'October' => 'listopad',
        'November' => 'studeni',
        'December' => 'prosinac',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Postavke su uspjeno aurirane!',
        'User Profile' => 'Korisniki profil',
        'Email Settings' => 'Postavke E-pote',
        'Other Settings' => 'Druge postavke',
        'Change Password' => 'Promjena lozinke',
        'Current Password' => 'Sadanja lozinka',
        'New password' => 'Nova lozinka',
        'Verify password' => 'Potvrdi lozinku',
        'Spelling Dictionary' => 'Pravopisni rjenik',
        'Default spelling dictionary' => 'Zadani pravopisni rjenik',
        'Max. shown Tickets a page in Overview.' => 'Maksimalni broj kartice po stranici pregleda.',
        'The current password is not correct. Please try again!' => 'Unijeli ste pogrenu lozinku. Molimo pokuajte ponovno!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Lozinka ne moe biti aurirana, novi unosi su razliiti. Molimo pokuajte ponovno!',
        'Can\'t update password, it contains invalid characters!' => 'Lozinka ne moe biti aurirana, sadri nedozvoljene znakove.',
        'Can\'t update password, it must be at least %s characters long!' => 'Lozinka ne moe biti aurirana. Minimalna duina lozinke je %s znakova.',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Lozinka ne moe biti aurirana. Mora sadravati bar 2 velika i 2 mala slova.',
        'Can\'t update password, it must contain at least 1 digit!' => 'Lozinka ne moe biti aurirana. Mora sadravati bar jednu znamenku.',
        'Can\'t update password, it must contain at least 2 characters!' => 'Lozinka ne moe biti aurirana. Mora sadravati najmanje 2 znaka.',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Lozinka ne moe biti aurirana. Unijeta lozinka je ve u uporabi. Molimo izaberite neku drugu.',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => 'Izaberite rastavni znak koji e se koristi u "CSV" datotekama (statistika i pretrage). Ako ne izaberete rastavni znak ovdje, koristit e se zadani rastavni znak za va jezik',
        'CSV Separator' => 'CSV rastavni znak',

        # Template: AAAStats
        'Stat' => 'Statistika',
        'Sum' => 'Suma',
        'Please fill out the required fields!' => 'Molimo Vas, popunite obavezna polja!',
        'Please select a file!' => 'Molimo Vas, izaberite datoteku!',
        'Please select an object!' => 'Molimo Vas, izaberite objekt!',
        'Please select a graph size!' => 'Molimo Vas, izaberite veliinu grafa!',
        'Please select one element for the X-axis!' => 'Molimo Vas, izaberite jedan element za X-os!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Izaberite samo jedan element ili opozovite izbor na oznaci polja "fiksirano"!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Ako koristite oznake odabira, morate izabrati neke atribute odabranog polja!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Molimo Vas, unesite vrijednost u izabrano polje ili iskljuite oznaku "fiksirano"!',
        'The selected end time is before the start time!' => 'Izabrano vrijeme kraja je prije vremena poetka!',
        'You have to select one or more attributes from the select field!' => 'Morate da izaberati jedan ili vie atributa iz odabranog polja!',
        'The selected Date isn\'t valid!' => 'Datum koji ste izabrali nije vaei!',
        'Please select only one or two elements via the checkbox!' => 'Molimo da izaberete samo jedan ili dva elementa!',
        'If you use a time scale element you can only select one element!' => 'Ukoliko koristite element vremenske skale, moete izabrati samo jedan element!',
        'You have an error in your time selection!' => 'Va izbor vremena sadri pogreku!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Va interval izvjetaja je prekratak, molimo zadajte vei vremenski razmak!',
        'The selected start time is before the allowed start time!' => 'Izabrano vrijeme poetka je prije dozvoljenog poetnog vremena!',
        'The selected end time is after the allowed end time!' => 'Izabrano vrijeme kraja je poslije dozvoljenog vremena kraja!',
        'The selected time period is larger than the allowed time period!' => 'Izabrani vremenski period je dui od dozvoljenog!',
        'Common Specification' => 'Ope informacije',
        'X-axis' => 'X-os',
        'Value Series' => 'Opsezi',
        'Restrictions' => 'Ogranienja',
        'graph-lines' => 'Linijski graf',
        'graph-bars' => 'Stupasti graf',
        'graph-hbars' => 'Trakasti graf',
        'graph-points' => 'Tokasti graf',
        'graph-lines-points' => 'Linijsko-tokasti graf',
        'graph-area' => 'Ploni graf',
        'graph-pie' => 'Tortni graf',
        'extended' => 'proiren',
        'Agent/Owner' => 'Zaposlenik/Vlasnik',
        'Created by Agent/Owner' => 'Otvorio zaposlenik/Vlasnik',
        'Created Priority' => 'Otvoreno s prioritetom',
        'Created State' => 'Otvoreno sa statusom',
        'Create Time' => 'Vrijeme otvaranja',
        'CustomerUserLogin' => 'Prijava korisnika',
        'Close Time' => 'Vrijeme zatvaranja',
        'TicketAccumulation' => 'Akumulacija kartice',
        'Attributes to be printed' => 'Atributi za tiskanje',
        'Sort sequence' => 'Redosled sortiranja',
        'Order by' => 'Poredaj po',
        'Limit' => 'Ogranienje',
        'Ticketlist' => 'Lista kartice',
        'ascending' => 'uzlazno',
        'descending' => 'silazno',
        'First Lock' => 'Prvo zakljuavanje',
        'Evaluation by' => 'Procijenio',
        'Total Time' => 'Ukupno vrijeme',
        'Ticket Average' => 'Prosjeno vreme po kartici',
        'Ticket Min Time' => 'Minimalno vreme kartice',
        'Ticket Max Time' => 'Maksimalno vreme kartice',
        'Number of Tickets' => 'Broj kartice',
        'Article Average' => 'Prosjeno vrijeme po lanku',
        'Article Min Time' => 'Minimalno vrijeme lanka',
        'Article Max Time' => 'Maksimalno vrijeme lanka',
        'Number of Articles' => 'Broj lanaka',
        'Accounted time by Agent' => 'Obraunato vrijeme po zaposleniku',
        'Ticket/Article Accounted Time' => 'Obraunato vrijeme',
        'TicketAccountedTime' => 'Obraunato vrijeme obrade kartice',
        'Ticket Create Time' => 'Vrijeme otvaranja kartice',
        'Ticket Close Time' => 'Vrijeme zatvaranja kartice',

        # Template: AAATicket
        'Status View' => 'Pregled statusa',
        'Bulk' => 'Masovno',
        'Lock' => 'Zakljuaj',
        'Unlock' => 'Otkljuaj',
        'History' => 'Dnevnik',
        'Zoom' => 'Sadaj',
        'Age' => 'Starost',
        'Bounce' => 'Preusmjeri',
        'Forward' => 'Proslijedi',
        'From' => 'Od',
        'To' => 'Za',
        'Cc' => 'Cc',
        'Bcc' => 'Bcc',
        'Subject' => 'Predmet',
        'Move' => 'Premjesti',
        'Queue' => 'Rep',
        'Queues' => 'Repovi',
        'Priority' => 'Prioritet',
        'Priorities' => 'Prioriteti',
        'Priority Update' => 'Auriranje prioriteta',
        'SLA' => 'SLA',
        'Service Level Agreement' => 'Sporazum o razini usluge',
        'Service Level Agreements' => 'Sporazumi o razini usluge',
        'Service' => 'Usluga',
        'Services' => 'Usluge',
        'State' => 'Stanje',
        'States' => 'Stanja',
        'Status' => 'Status',
        'Statuses' => 'Statusi',
        'Ticket Type' => 'Tip kartice',
        'Ticket Types' => 'Tipovi kartice',
        'Compose' => 'Napii',
        'Pending' => 'Na ekanju',
        'Owner' => 'Vlasnik',
        'Owner Update' => 'Auriranje vlasnika',
        'Responsible' => 'Odgovoran',
        'Responsible Update' => 'Auriranje odgovornog',
        'Sender' => 'Poiljaoc',
        'Article' => 'lanak',
        'Ticket' => 'karticu',
        'Createtime' => 'Vrijme kreiranja',
        'plain' => 'neformatirano',
        'Email' => 'E-pota',
        'email' => 'E-pota',
        'Close' => 'Zatvori',
        'Action' => 'Akcija',
        'Attachment' => 'Privitak',
        'Attachments' => 'Privitci',
        'This message was written in a character set other than your own.' => 'Ova poruka je napisana skupom znakova razliitim od onog koji Vi koristite.',
        'If it is not displayed correctly,' => 'Ako nije ispravno prikazano,',
        'This is a' => 'Ovo je',
        'to open it in a new window.' => 'za otvaranje u novom prozoru.',
        'This is a HTML email. Click here to show it.' => 'Ovo je HTML E-pota. Klikni ovdje za prikaz.',
        'Free Fields' => 'Slobodna polja',
        'Merge' => 'Objedini',
        'merged' => 'objedinjeno',
        'closed successful' => 'zatvoreno kao rijeeno (uspjeno)',
        'closed unsuccessful' => 'zatvoreno kao neuspjeno (nerijeeno)',
        'Locked Tickets Total' => 'Ukupno blokiranih/zakljunih kartica',
        'Locked Tickets Reminder Reached' => 'Dostignut podsjetnik zakljuanih kartica',
        'Locked Tickets New' => 'Nove zakljuane kartice',
        'Responsible Tickets Total' => 'Ukupno kartica "..."',
        'Responsible Tickets New' => 'Nove kartice "..."',
        'Responsible Tickets Reminder Reached' => 'Dostignut podsjetnik kartice ".."',
        'Watched Tickets Total' => 'Ukupno praenih kartica',
        'Watched Tickets New' => 'Nove praene kartice',
        'Watched Tickets Reminder Reached' => 'Dostignut podsjetnik kartica na ekanju',
        'All tickets' => 'Sve kartice',
        'Tickets available' => 'Dostupne kartice',
        'Escalation' => 'Eskalacija',
        'last-search' => '',
        'QueueView' => 'Pregled repa',
        'Ticket Escalation View' => 'Eskalacioni pregled kartice',
        'Message from' => '',
        'End message' => '',
        'Forwarded message from' => '',
        'End forwarded message' => '',
        'new' => 'novo',
        'open' => 'otvoreni',
        'Open' => 'Otvoreni',
        'closed' => 'zatvoreni',
        'Closed' => 'Zatvoreni',
        'removed' => 'uklonjeni',
        'pending reminder' => 'podsjetnik ekanja',
        'pending auto' => 'automatsko ekanje',
        'pending auto close+' => 'ekanje na automatsko zatvaranje+',
        'pending auto close-' => 'ekanje na automatsko zatvaranje-',
        'email-external' => 'E-pota-eksterna',
        'email-internal' => 'E-pota-interna',
        'note-external' => 'Napomena-eksterna',
        'note-internal' => 'Napomena-interna',
        'note-report' => 'Napomena-izvjetaj',
        'phone' => 'Telefon',
        'sms' => 'SMS',
        'webrequest' => 'Web zahtjev',
        'lock' => 'zaklj.',
        'unlock' => 'otklj.',
        'very low' => 'vrlo nizak',
        'low' => 'nizak',
        'normal' => 'normalan',
        'high' => 'visok',
        'very high' => 'vrlo visok',
        '1 very low' => '1 vrlo nizak',
        '2 low' => '2 nizak',
        '3 normal' => '3 normalan',
        '4 high' => '4 visok',
        '5 very high' => '5 vrlo visok',
        'Ticket "%s" created!' => 'kartica "%s" kreirana!',
        'Ticket Number' => 'Broj kartice',
        'Ticket Object' => 'objekt kartice',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ne postoji kartica s brojem "%s"! Ne moe se povezati!',
        'Don\'t show closed Tickets' => 'Ne prikazuj zatvorene kartice',
        'Show closed Tickets' => 'Prikai zatvorene kartice',
        'New Article' => 'Novi lanak',
        'Unread article(s) available' => 'raspoloivi neproitani lanci',
        'Remove from list of watched tickets' => 'Ukloni sa liste praenih kartica',
        'Add to list of watched tickets' => 'Dodaj na listu praenih kartica',
        'Email-Ticket' => 'Kartica E-pote',
        'Create new Email Ticket' => 'Kreiraj novu karticu E-pote',
        'Phone-Ticket' => 'Telefonska kartica',
        'Search Tickets' => 'Traenje kartice',
        'Edit Customer Users' => 'Uredi korisnike',
        'Edit Customer Company' => 'Uredi korisniku tvrtku',
        'Bulk Action' => 'Masovna akcija',
        'Bulk Actions on Tickets' => 'Masovne akcije na karticama',
        'Send Email and create a new Ticket' => 'Poalji E-potu i kreiraj novu karticu',
        'Create new Email Ticket and send this out (Outbound)' => 'Otvori novu karticu E-pote i poalji ovo (odlazni)',
        'Create new Phone Ticket (Inbound)' => 'Kreiraj novu telefonsku karticu (dolazni poziv)',
        'Overview of all open Tickets' => 'Pregled svih otvorenih kartica',
        'Locked Tickets' => 'Zakljuane/blokirane kartice',
        'My Locked Tickets' => 'Moje zakljuane kartice',
        'My Watched Tickets' => 'Moje promatrane kartice',
        'My Responsible Tickets' => 'Kartice za koje sam odgovoran',
        'Watched Tickets' => 'Promatrane kartice',
        'Watched' => 'Promatrano',
        'Watch' => 'Promatraj',
        'Unwatch' => 'Prekini promatranje',
        'Lock it to work on it!' => 'Zakljuaj radi ekskluzivne obrade!',
        'Unlock to give it back to the queue!' => 'Otkljuaj da bi je vratio u rep!',
        'Shows the ticket history!' => 'Prikai dnevnik kartice!',
        'Print this ticket!' => 'Tiskaj ovau karticu!',
        'Change the ticket priority!' => 'Promijeni prioritet kartice',
        'Change the ticket free fields!' => 'Promijeni slobodna polja kartice',
        'Link this ticket to an other objects!' => 'Povei ovu karticu sa drugim objektima!',
        'Change the ticket owner!' => 'Promijeni vlasnika kartice!',
        'Change the ticket customer!' => 'Promijeni korisnika za karticu!',
        'Add a note to this ticket!' => 'Dodaj napomenu ovoj kartici!',
        'Merge this ticket!' => 'Spoji ovu karticu!',
        'Set this ticket to pending!' => 'Stavi ovu karticu na ekanje!',
        'Close this ticket!' => 'Zatvori ovu karticu!',
        'Look into a ticket!' => 'Pogledaj sadraj kartice!',
        'Delete this ticket!' => 'Obrii ovu karticu!',
        'Mark as Spam!' => 'Oznai kao SPAM!',
        'My Queues' => 'Moji repovi',
        'Shown Tickets' => 'prikazane kartice',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Vaa poruka E-pote sa brojem kartice "<OTRS_TICKET>" je objedinjena sa karticom "<OTRS_MERGE_TO_TICKET>"!',
        'Ticket %s: first response time is over (%s)!' => 'kartica %s: vrijeme reakcije je preko (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'kartica %s: vrijeme reakcije istie za %s!',
        'Ticket %s: update time is over (%s)!' => 'kartica %s: vrijeme auriranja je isteklo (%s)!',
        'Ticket %s: update time will be over in %s!' => 'kartica %s: vrijeme auriranja istie za %s!',
        'Ticket %s: solution time is over (%s)!' => 'karticu %s: vrijeme rjeavanja je isteklo (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'karticu %s: vrijeme rjeavanja istie za %s!',
        'There are more escalated tickets!' => 'Ima jo eskaliralih kartica!',
        'Plain Format' => 'Jednostavan format',
        'Reply All' => 'Odgovori na sve',
        'Direction' => 'Smjer',
        'Agent (All with write permissions)' => 'Zaposlenik (svi sa dozvolom promjene)',
        'Agent (Owner)' => 'Zaposlenik (Vlasnik)',
        'Agent (Responsible)' => 'Zaposlenik (Odgovoran)',
        'Ticket is locked by another agent.' => '',
        'New ticket notification' => 'Obavijest o novoj kartici',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Poalji mi obavijest za novu karticu u "Mojim repovima".',
        'Send new ticket notifications' => 'Poalji obavijesti o novim karticama',
        'Ticket follow up notification' => 'Obavijest o nastavku kartice',
        'Ticket lock timeout notification' => 'Obavijest o isticanju zakljuavanja kartice',
        'Send me a notification if a ticket is unlocked by the system.' => 'Poalji mi obavijest ako sustav otkljua karticu.)',
        'Send ticket lock timeout notifications' => 'Poalji obavijest o isteku zakljuavanja kartice',
        'Ticket move notification' => 'Obavijest o premjetaju kartice',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Poalji mi obavijest o premjetaju kartice u "Moje repove".',
        'Send ticket move notifications' => 'Poalji obavijest o premjetaju kartice',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Izabrani favorizirani repovi. Ako je aktivirana, dobit ete i obavijest o ovim repovima.',
        'Custom Queue' => 'Prilagoeni rep',
        'QueueView refresh time' => 'Vrijeme osvjeavanja pregleda repa',
        'If enabled, the QueueView will automatically refresh after the specified time.' => 'Ako je ukljueno, pregled repa bit e osvjeen poslije zadanog vremena.',
        'Refresh QueueView after' => 'Osvjei pregled repa poslije',
        'Screen after new ticket' => 'Ekran poslije otvaranja nove kartice',
        'Show this screen after I created a new ticket' => 'Prikai ovaj ekran poslije otvaranja nove kartice',
        'Closed Tickets' => 'Zatvorene kartice',
        'Show closed tickets.' => 'Prikai zatvorene kartice.',
        'Max. shown Tickets a page in QueueView.' => 'Maksimalni broj prikazanih kartica u pregledu repa.',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => 'Limit kartica po stranici pregleda',
        'Ticket watch notification' => 'Obavijest o promatranju kartice',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => 'Polji mi istu obavijest za moje promatrane kartice koju e dobiti i vlasnik.',
        'Send ticket watch notifications' => 'Poalji obavijesti za promatranje kartice',
        'Out Of Office Time' => 'Izvan uredovnog vremena',
        'New Ticket' => 'Nova kartica',
        'Create new Ticket' => 'Napravi novu karticu',
        'Customer called' => 'Kartica na korisnikov poziv',
        'phone call' => 'telefonski poziv',
        'Phone Call Outbound' => 'Odlazni telefonski poziv',
        'Reminder Reached' => 'Dostignut podsjetnik',
        'Reminder Tickets' => 'Kartice na podsjetniku',
        'Escalated Tickets' => 'Eskalirane kartice',
        'New Tickets' => 'Nove kartice',
        'Open Tickets / Need to be answered' => 'Otvorene kartice / Potrebno odgovoriti',
        'All open tickets, these tickets have already been worked on, but need a response' => 'Sve otvorene kartice, na kojima je ve raeno, ali zahtijevaju odgovor',
        'All new tickets, these tickets have not been worked on yet' => 'Sve nove kartice, na njima jo nije nita raeno',
        'All escalated tickets' => 'Sve eskalirani kartice',
        'All tickets with a reminder set where the reminder date has been reached' => 'Sve kartice sa postavljenim podsjetnikom, a datum podsjetnika je dostignut',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'premjetaj kartice u rep "%s" (%s) iz repa "%s" (%s).',
        'History::TypeUpdate' => 'Auriran tip "%s" (ID=%s).',
        'History::ServiceUpdate' => 'Auriran servis "%s" (ID=%s).',
        'History::SLAUpdate' => 'Auriran SLA "%s" (ID=%s).',
        'History::NewTicket' => 'Nova kartica [%s] otvorena (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Nastavak kartice [%s]. %s',
        'History::SendAutoReject' => 'Automatski odbaeno "%s".',
        'History::SendAutoReply' => 'Poslat automatski odgovor za "%s".',
        'History::SendAutoFollowUp' => 'Automatski nastavak za "%s".',
        'History::Forward' => 'Proslijeena poruka "%s".',
        'History::Bounce' => 'Odbijena poruka "%s".',
        'History::SendAnswer' => 'Poruka E-pote poslana "%s".',
        'History::SendAgentNotification' => '"%s" - obavijest poslana k "%s".',
        'History::SendCustomerNotification' => 'Obavijest poslana k "%s".',
        'History::EmailAgent' => '"E-pota poslana zaposleniku."',
        'History::EmailCustomer' => '"E-pota poslana korisniku. %s"',
        'History::PhoneCallAgent' => '"Zaposlenikov telefonski poziv."',
        'History::PhoneCallCustomer' => 'Korisniki telefonski poziv.',
        'History::AddNote' => 'Dodata napomena (%s)',
        'History::Lock' => 'kartica zakljuana.',
        'History::Unlock' => 'kartica otkljuana.',
        'History::TimeAccounting' => '%s vremenskih jedinica prebrojano. Ukupno %s vremenskih jedinica.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Aurirano: %s',
        'History::PriorityUpdate' => 'Auriran prioritet sa "%s" (%s) na "%s" (%s).',
        'History::OwnerUpdate' => 'Novi vlasnik je "%s" (ID=%s).',
        'History::LoopProtection' => 'Zatita od mrtve petlje! Automatski odgovor nije poslan na "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Aurirano: %s',
        'History::StateUpdate' => 'Staro: "%s" Novo: "%s"',
        'History::TicketFreeTextUpdate' => 'Aurirano: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Korisniki Web zahtjev.',
        'History::TicketLinkAdd' => 'Veza na "%s" postavljena.',
        'History::TicketLinkDelete' => 'Veza na "%s" uklonjena.',
        'History::Subscribe' => 'Pretplata za korisnika "%s" ukljuena.',
        'History::Unsubscribe' => 'Pretplata za korisnika "%s" iskljuena.',
        'History::SystemRequest' => 'Zahtjev sustava',
        'History::ResponsibleUpdate' => 'Novi odgovorni je "%s" (ID=%s).',
        'History::ArchiveFlagUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'ned',
        'Mon' => 'pon',
        'Tue' => 'uto',
        'Wed' => 'sre',
        'Thu' => 'et',
        'Fri' => 'pet',
        'Sat' => 'sub',

        # Template: AdminAttachment
        'Attachment Management' => 'Upravljanje prilozima',
        'Actions' => 'Akcije',
        'Go to overview' => 'Idi na pregled',
        'Add attachment' => 'Dodaj prilog',
        'List' => 'Lista',
        'No data found.' => 'Nita nije pronaeno.',
        'Download file' => 'Preuzmi datoteku',
        'Delete this attachment' => 'Obrii ovaj prilog',
        'Add Attachment' => 'Dodaj prilog',
        'Edit Attachment' => 'Uredi prilog',
        'This field is required.' => 'Ovo polje je obavezno.',
        'or' => 'ili',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Upravljanje automatskim odgovorima',
        'Add auto response' => 'Dodaj automatski odgovor',
        'Add Auto Response' => 'Dodaj automatski odgovor',
        'Edit Auto Response' => 'Uredi automatski odgovor',
        'Response' => 'Odgovor',
        'Auto response from' => 'Automatski odgovor od',
        'Reference' => 'Reference',
        'You can use the following tags' => 'Moete koristiti sljedee oznake',
        'To get the first 20 character of the subject.' => 'Da vidite prvih 20 slova predmeta',
        'To get the first 5 lines of the email.' => 'Da vidite prvih 5 redaka poruke',
        'To get the realname of the sender (if given).' => 'Da vidite ime poiljaoca (ako je dostupno)',
        'To get the article attribute' => 'Da vidite atribute lanka',
        ' e. g.' => 'npr.',
        'Options of the current customer user data' => 'Opcije podataka o trenutnom korisniku',
        'Ticket owner options' => 'Opcije vlasnika kartice',
        'Ticket responsible options' => 'Opcije odgovornog za karticu',
        'Options of the current user who requested this action' => 'Opcije trenutnog korisnika koji je traio ovu akciju',
        'Options of the ticket data' => 'Opcije podataka o kartici',
        'Config options' => 'Konfiguracijske opcije',
        'Example response' => 'Primjer odgovora',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Ureivanje korisnikih tvrtki',
        'Wildcards like \'*\' are allowed.' => '',
        'Add customer company' => 'Dodaj korisniku tvrtku',
        'Please enter a search term to look for customer companies.' => 'Molimo unesite upit za pronalaenje korisnikih tvrtki.',
        'Add Customer Company' => 'Dodaj korisniku tvrtku',

        # Template: AdminCustomerUser
        'Customer Management' => 'Upravljanje korisnicima',
        'Add customer' => 'Dodaj korisnika',
        'Select' => 'Izaberi',
        'Hint' => 'Savjet',
        'Customer will be needed to have a customer history and to login via customer panel.' => 'Potreban je korisnik da bi imali pristup dnevniku prijava na korisniki panel.',
        'Please enter a search term to look for customers.' => 'Molimo zadajte upit za pronalaenje korisnika.',
        'Last Login' => 'Zadnja prijava',
        'Add Customer' => 'Dodaj korisnika',
        'Edit Customer' => 'Uredi korisnika',
        'This field is required and needs to be a valid email address.' => 'Ovo je obavezno polje i adresa E-pote mora biti ispravna.',
        'This email address is not allowed due to the system configuration.' => 'Postavke sustava ne doputaju ovu adresu E-pote.',
        'This email address failed MX check.' => 'Ova adresa E-pote ne prolazi DNS/MX provjeru.',
        'DNS problem, please check your configuration and the error log.' => '',
        'The syntax of this email address is incorrect.' => 'Sintaksa ove adrese E-pota je neispravna.',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Upravljanje lanstvom korisnika u grupi',
        'Notice' => 'Napomena',
        'This feature is disabled!' => 'Ova funkcija je iskljuena!',
        'Just use this feature if you want to define group permissions for customers.' => 'Ovu funkciju koristite ako elite definirati grupne dozvole za korisnike.',
        'Enable it here!' => 'Aktivirajte je ovdje!',
        'Search for customers.' => '',
        'Edit Customer Default Groups' => 'Urediti zadane grupe za korisnika',
        'These groups are automatically assigned to all customers.' => 'Ove grupe su automatski dodijeljene svim korisnicima',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => 'Moete upravljati ovim grupama preko konfiguracijskih postavki "..."',
        'Filter for Groups' => 'Filtar za grupe',
        'Select the customer:group permissions.' => 'Izaberi dozvole za korisnik:grupa',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => 'Ako nita nije izabrano, onda nema dozvola u ovoj grupi (kartice nee biti dostupne korisniku).',
        'Search Result:' => 'Rezultat pretrage:',
        'Customers' => 'Korisnici',
        'Groups' => 'Grupe',
        'No matches found.' => 'Nita nije pronaeno.',
        'Change Group Relations for Customer' => 'Promijeni veze sa grupama za korisnika',
        'Change Customer Relations for Group' => 'promijeni veze sa korisnicima za grupu',
        'Toggle %s Permission for all' => 'Promijeni %s dozvole za sve',
        'Toggle %s permission for %s' => 'Promijeni %s dozvole za %s',
        'Customer Default Groups:' => 'Zadane grupe za korisnika:',
        'No changes can be made to these groups.' => 'Na ovim grupama promjene nisu mogue.',
        'ro' => '"ro"',
        'Read only access to the ticket in this group/queue.' => 'Pristup ogranien samo na itanje za kartice u ovim grupama/repovima.',
        'rw' => '"rw"',
        'Full read and write access to the tickets in this group/queue.' => 'Pristup bez ogranienja za kartice u ovim grupama/repovima.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => 'Upravljanje vezama korisnik-usluge',
        'Edit default services' => 'Uredi zadane usluge',
        'Filter for Services' => 'Filter za usluge',
        'Allocate Services to Customer' => 'Pridrui usluge korisniku',
        'Allocate Customers to Service' => 'Pridrui korisnike usluzi',
        'Toggle active state for all' => 'Promijeni aktivno stanje za sve',
        'Active' => 'Aktivno',
        'Toggle active state for %s' => 'Promijeni aktivno stanje za %s',

        # Template: AdminEmail
        'Admin Notification' => 'Administrativne obavijesti',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => 'Vaa poruka je poslana',
        'Send message to users' => 'Poalji poruku korisnicima',
        'Send message to group members' => 'Poalji poruku lanovima grupe',
        'Group members need to have permission' => 'lanovi grupe trebaju imati dozvolu',
        'Send message to role members' => 'Poalji poruku za ulogu',
        'Also send to customers in groups' => 'Takoer poalji korisnicima u grupi',
        'Body' => 'Tekst',
        'Send' => 'alji',

        # Template: AdminGenericAgent
        'Generic Agent' => '"Generiki" zaposlenik',
        'Add job' => 'Dodaj posao',
        'Last run' => 'Posljednje pokretanje',
        'Run Now!' => 'Pokreni sad!',
        'Delete this task' => 'Obrii ovaj zadatak',
        'Run this task' => 'Pokreni ovaj zadatak',
        'Job Settings' => 'Podeavanje posla',
        'Job name' => 'Naziv posla',
        'Currently this generic agent job will not run automatically.' => 'Trenutno ovaj generiki agentski zadatak nee raditi automatski.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Da bi ste omoguili automatsko izvravanje izaberite bar jednu vrijednost od minuta, sati i dana!',
        'Schedule minutes' => 'Planirano minuta',
        'Schedule hours' => 'Planirano sati',
        'Schedule days' => 'Planirano dana',
        'Toggle this widget' => 'Preklopi ovaj "widget"',
        'Ticket Filter' => 'Filtar kartice',
        '(e. g. 10*5155 or 105658*)' => 'npr. 10*5144 ili 105658*',
        '(e. g. 234321)' => 'npr. 234321',
        'Customer login' => 'Prijava korisnika',
        '(e. g. U5150)' => 'npr. U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => 'Potpuna tekstualna pretraga u lanku (npr. "Mar*n" ili "Hor*i")',
        'Agent' => 'Zaposlenik',
        'Ticket lock' => 'kartica zakljuana',
        'TicketFreeFields' => 'Slobodna polja u kartici',
        'Create times' => 'Vremena otvaranja',
        'No create time settings.' => 'Nema postavki vremena otvaranja.',
        'Ticket created' => 'karticu otvoren',
        'Ticket created between' => 'karticu otvoren izmeu',
        'Close times' => 'Vremena zatvaranja',
        'No close time settings.' => 'Nije postavljeno vrijeme zatvaranja.',
        'Ticket closed' => 'kartica zatvorena',
        'Ticket closed between' => 'kartica zatvorena izmeu',
        'Pending times' => 'Vremena ekanja',
        'No pending time settings.' => 'Nema podeavanja vremena ekanja',
        'Ticket pending time reached' => 'Dostignuto vrijeme ekanja kartice',
        'Ticket pending time reached between' => 'Vrijeme ekanja kartice dostignuto izmeu',
        'Escalation times' => 'Vremena eskalacije',
        'No escalation time settings.' => 'Nema postavki vremena eskalacije',
        'Ticket escalation time reached' => 'Dostignuto vrijeme eskalacije kartice',
        'Ticket escalation time reached between' => 'Vrijeme eskalacije kartice dostignuto izmeu',
        'Escalation - first response time' => 'Eskalacija - vrijeme prve reakcije',
        'Ticket first response time reached' => 'Dostignuto vrijeme prve reakcije na karticu',
        'Ticket first response time reached between' => 'Vrijeme prve reakcije na karticu dostignuto izmeu',
        'Escalation - update time' => 'Eskalacija - vrijeme auriranja',
        'Ticket update time reached' => 'Dostignuto vrijeme auriranja kartice',
        'Ticket update time reached between' => 'Vrijeme auriranja kartice dostignuto izmeu',
        'Escalation - solution time' => 'Eskalacija - vrijeme rjeavanja',
        'Ticket solution time reached' => 'Dostignuto vrijeme rjeavanja kartice',
        'Ticket solution time reached between' => 'Vreme rjeavanja kartice dostignuto izmeu',
        'Archive search option' => 'Opcije pretrage arhive',
        'Ticket Action' => 'Akcija na kartici',
        'Set new service' => 'Postavi novi servis',
        'Set new Service Level Agreement' => 'Postavi novi SLA',
        'Set new priority' => 'Postavi novi prioritet',
        'Set new queue' => 'Postavi novi rep',
        'Set new state' => 'Postavi novi status',
        'Set new agent' => 'Postavi novog zaposlenika',
        'new owner' => 'novi vlasnik',
        'Set new ticket lock' => 'Postavi novo zakljuavanje kartice',
        'New customer' => 'Novi korisnik',
        'New customer ID' => 'Novi ID korisnika',
        'New title' => 'Novi naslov',
        'New type' => 'Novi tip',
        'New TicketFreeFields' => 'Slobodna polja novog kartice',
        'Archive selected tickets' => 'Arhiviraj izabrane karticue',
        'Add Note' => 'Dodaj napomenu',
        'Time units' => 'Vremenske jedinice',
        ' (work units)' => ' (elementi posla)',
        'Ticket Commands' => 'Komande za karticu',
        'Send agent/customer notifications on changes' => 'Poalji obavijesti zaposleniku/korisniku pri promjenama',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Ova naredba e biti izvrena. ARG[0] je broj kartice, a ARG[1] ID kartice.',
        'Delete tickets' => 'Obrii kartice',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => 'UPOZORENJE: Sve obuhvaene kartice e biti nepovratno uklonjene iz baze!',
        'Execute Custom Module' => 'Pokreni izvravanje posebnog modula',
        'Param %s key' => 'Klju parametra %s',
        'Param %s value' => 'Vrijednost parametra %s',
        'Save Changes' => 'Sauvaj promjene',
        'Save' => 'Sauvaj',
        'Results' => 'Rezultati',
        '%s Tickets affected! What do you want to do?' => '%s zahvaenih kartica. ta elite da uradite?',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => 'UPOZORENJE: Upotrijebili ste opciju za brisanje. Svi obrisane kartice e biti izgubljene!',
        'Edit job' => 'Uredi posao',
        'Run job' => 'Pokreni posao',
        'Affected Tickets' => 'Obuhvaene kartice',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'UPOZORENJE: Ako promijenite ime grupe \'admin\' prije adekvatnog podeavanja u sistemskoj konfiguraciji, izgubit ete pristup administrativnom prostoru! Ukoliko se to dogodi, vratite ime grupi u "admin" pomou SQL naredbe.',
        'Group Management' => 'Upravljanje grupama',
        'Add group' => 'Dodaj grupu',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '"admin" grupa slui za pristup administrativnom prostoru a "stats" grupa prostoru statistike.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => 'Kreirajte nove grupe da bi ste lake upravljali dozvolama za razliite zaposlenike (npr. prema odjelima)',
        'It\'s useful for ASP solutions. ' => 'Korisno za ASP rjeenja.',
        'Add Group' => 'Dodaj grupu',
        'Edit Group' => 'Uredi grupu',

        # Template: AdminLog
        'System Log' => 'Dnevnik/zapisnik sustava',
        'Here you will find log information about your system.' => 'Ovdje se nalaze informacije o zabiljeenim dogaajima u sustavu.',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'Vrijeme',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Upravljanje raunima E-pote',
        'Add mail account' => 'Dodaj E-pota nalog',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Sve dolazne poruke sa jednog naloga e biti usmerene u izabrani rep!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Ako je va nalog od poverenja, koristie se postojea "X-OTRS" zaglavlja! "PostMaster" filteri se koriste uvek.',
        'Host' => 'Udomitelj (host)',
        'Delete account' => 'Obrii raun E-pote',
        'Fetch mail' => 'Preuzmi E-potu',
        'Add Mail Account' => 'Dodaj raun E-pote',
        'Example: mail.example.com' => 'Primjer: mail.example.com',
        'Trusted' => 'Povjerljivo',
        'Dispatching' => 'Otprema',
        'Edit Mail Account' => 'Uredi raun E-pote',

        # Template: AdminNavigationBar
        'Admin' => 'Admininstracija',
        'Agent Management' => 'Upravljanje zaposlenicima',
        'Queue Settings' => 'Postavke repova',
        'Ticket Settings' => 'Postavke kartica',
        'System Administration' => 'Administracija sustava',

        # Template: AdminNotification
        'Notification Management' => 'Upravljanje obavijestima',
        'Select a different language' => '',
        'Filter for Notification' => 'Filtar za obavijest',
        'Notifications are sent to an agent or a customer.' => 'Obavijest poslana zaposleniku ili korisniku.',
        'Notification' => 'Obavijest',
        'Edit Notification' => 'Uredi Obavijest',
        'e. g.' => 'npr.',
        'Options of the current customer data' => 'Opcije podataka o trenutnom korisniku',

        # Template: AdminNotificationEvent
        'Add notification' => 'Dodaj obavijest',
        'Delete this notification' => 'Obrii ovu obavijest',
        'Add Notification' => 'Dodaj obavijest',
        'Recipient groups' => 'Grupe primatelja',
        'Recipient agents' => 'Zaposlenici primatelji',
        'Recipient roles' => 'Uloge primatelja',
        'Recipient email addresses' => 'Adrese E-pote primatelja',
        'Article type' => 'Tip lanka',
        'Only for ArticleCreate event' => 'Samo za dogaaj kreiranja lanka',
        'Subject match' => 'Poklapanje predmeta',
        'Body match' => 'Poklapanje sadraja',
        'Include attachments to notification' => 'Prikljui privitke uz obavijest',
        'Notification article type' => 'Tip lanka obavijesti',
        'Only for notifications to specified email addresses' => 'Samo za obavijesti za precizirane adrese E-pote',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Vidjeti prvih 20 slova predmeta (posljednjeg lanka zaposlenika).',
        'To get the first 5 lines of the body (of the latest agent article).' => '',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Vidjeti prvih 20 slova predmeta (posljednjeg lanka zaposlenika)',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Vidjeti prvih 5 redaka poruke (posljednjeg lanka zaposlenika).',

        # Template: AdminPGP
        'PGP Management' => 'Upravljanje PGP kljuevima',
        'Use this feature if you want to work with PGP keys.' => 'Upotrijebi ovu mogunost za rad sa PGP-kljuevima.',
        'Add PGP key' => 'Dodaj PGP-klju',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Na ovaj nain moete direktno ureivati komplet kljueva podeen u sistemskim opcijama.',
        'Introduction to PGP' => 'Upoznavanje sa PGP',
        'Result' => 'Rezultat',
        'Identifier' => 'Identifikator',
        'Bit' => 'Bit',
        'Key' => 'Klju',
        'Fingerprint' => 'Saetak',
        'Expires' => 'Istie',
        'Delete this key' => 'Obrii ovaj klju',
        'Add PGP Key' => 'Dodaj PGP-klju',
        'PGP key' => 'PGP-klju',

        # Template: AdminPackageManager
        'Package Manager' => 'Upravljanje paketima',
        'Uninstall package' => 'Deinstaliraj paket',
        'Version' => 'Verzija',
        'Do you really want to uninstall this package?' => 'Da li uistinu elite deinstalirati ovaj paket?',
        'Reinstall package' => 'Instaliraj paket ponovo',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => 'Da li uistinu elite ponovno instalirati ovaj paket? Sve eventualne rune promjene bit e izgubljene.',
        'Continue' => 'Nastavi',
        'Install' => 'Instaliraj',
        'Install Package' => 'Instaliraj paket',
        'Update repository information' => 'Auriraj informacije o spremitu',
        'Did not find a required feature? OTRS Group provides their subscription customers with exclusive Add-Ons:' => '',
        'Online Repository' => 'Mreno spremite',
        'Vendor' => 'Snabdjeva',
        'Module documentation' => 'Dokumentacija kodula',
        'Upgrade' => 'Auriranje',
        'Local Repository' => 'Lokalno spremite',
        'Uninstall' => 'Deinstaliraj',
        'Package not correctly deployed! You should reinstall the package again!' => 'Paket nije ispravno instaliran. Trebalo bi ga instalirati ponovno!',
        'Reinstall' => 'Instaliraj ponovo',
        'Download package' => 'Preuzmi paket',
        'Rebuild package' => 'Obnovi paket (rebuild)',
        'Metadata' => 'Meta-podaci',
        'Change Log' => 'Promijeni dnevnik',
        'Date' => 'Datum',
        'List of Files' => 'Spisak datoteka',
        'Permission' => 'Dozvola',
        'Download' => 'Preuzimanje',
        'Download file from package!' => 'Preuzmi datoteku iz paketa!',
        'Required' => 'Obavezno',
        'PrimaryKey' => 'Primarni klju',
        'AutoIncrement' => 'samoprirast',
        'SQL' => 'SQL',
        'File differences for file %s' => 'Razlike za datoteku %s',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Dnevnik preformansi',
        'This feature is enabled!' => 'Ova funkcija je aktivna!',
        'Just use this feature if you want to log each request.' => 'Koristite ovu mogunost ako elite zabiljeiti svaki zahtjev.',
        'Activating this feature might affect your system performance!' => 'Aktiviranje ove mogunosti moe naruiti performanse sustava!',
        'Disable it here!' => 'Iskljuite je ovde!',
        'Logfile too large!' => 'Dnevnik je prevelik!',
        'The logfile is too large, you need to reset it' => 'Datoteka dnevnika je prevelika, treba ju oistiti (reset)',
        'Overview' => 'Pregled',
        'Range' => 'Opseg',
        'Interface' => 'Suelje',
        'Requests' => 'Zahtjevi',
        'Min Response' => 'Min. vrijeme reakcije',
        'Max Response' => 'Maks. vrijeme reakcije',
        'Average Response' => 'Prosjeno vrijeme reakcije',
        'Period' => 'Period',
        'Min' => 'Min',
        'Max' => 'Maks',
        'Average' => 'Prosjek',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Upravljanje "PostMaster" filtrima',
        'Add filter' => 'Dodaj filtar',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => 'Radi otpreme ili filtriranja dolaznih poruka na osnovu zaglavlja. Uporaba regularnih izraza je takoer mogua.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Ukoliko elite poklapanje samo sa adresama E-pote, koristite EMAILADDRESS:info@example.com u "Od", "Za" ili "Cc".',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => 'Ukoliko koristite regularne izraze, moete takoer koristiti niz zahvaen s () kao [***] u \'Set\' akciji.',
        'Delete this filter' => 'Obrii ovaj filtar',
        'Add PostMaster Filter' => 'Dodaj "PostMaster" filtar',
        'Edit PostMaster Filter' => 'Uredi "PostMaster" filtar',
        'Filter name' => 'Naziv filtra',
        'The name is required.' => '',
        'Stop after match' => 'Zaustavi poslije pogotka',
        'Filter Condition' => 'Uvjet filtriranja',
        'Value' => 'Vrijednost',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => 'Postavi zaglavlja E-pote',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Upravljanje prioritetima',
        'Add priority' => 'Dodaj prioritet',
        'Add Priority' => 'Dodaj prioritet',
        'Edit Priority' => 'Uredi prioritet',

        # Template: AdminQueue
        'Manage Queues' => 'Upravljanje repovima',
        'Add queue' => 'Dodaj rep',
        'Add Queue' => 'Dodaj rep',
        'Edit Queue' => 'Uredi rep',
        'Sub-queue of' => 'Pod-rep od',
        'Unlock timeout' => 'Vrijeme do otkljuavanja',
        '0 = no unlock' => '0 = nema otkljuavanja',
        'Only business hours are counted.' => 'Mjeri se samo radno vrijeme.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => '',
        'Notify by' => 'Poiljalac obavjesti',
        '0 = no escalation' => '0 = nema eskalacije',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => '',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => 'Ako se karticu ne zatvori prije ovdje definiranog vremena, karticu eskalira.',
        'Follow up Option' => 'Opcije nastavka',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => 'Nastavak na zatvorenu karticu ponovno otvara karticu ili otvara novi.',
        'Ticket lock after a follow up' => 'Zakljuavanje kartice poslije nastavka',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => 'Ako je kartica zatvorena, a korisnik poalje nastavak, kartica e biti zakljuana na starog vlasnika.',
        'System address' => 'Adresa sustava',
        'Will be the sender address of this queue for email answers.' => 'Adresa poiljaoca E-pote za odgovore iz ovog repa.',
        'Default sign key' => 'Zadani klju potpisa',
        'The salutation for email answers.' => 'Zaglavlje/pozdrav za odgovore E-pote.',
        'The signature for email answers.' => 'Podnoje/potpis za odgovore E-pote.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => 'Upravljanje vezama rep <-> automatski odgovor',
        'Filter for Queues' => 'Filtar za repove',
        'Filter for Auto Responses' => 'Filtar za automatske odgovore',
        'Auto Responses' => 'Automatski odgovori',
        'Change Auto Response Relations for Queue' => 'Promijeni veze sa automatskim odgovorima za rep',
        'settings' => 'postavke',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => 'Upravljanje vezama odgovor <-> rep',
        'Filter' => 'Filtar',
        'Filter for Responses' => 'Filtar za odgovore',
        'Responses' => 'Odgovori',
        'Change Queue Relations for Response' => 'Promijeni veze repova s odgovorom',
        'Change Response Relations for Queue' => 'Promijeni veze odgovora s repom',

        # Template: AdminResponse
        'Manage Responses' => 'Upravljanje odgovorima',
        'Add response' => 'Dodaj odgovor',
        'A response is default text to write faster answer (with default text) to customers.' => 'Odgovor je zadani tekst za bre pisanje (predloak teksta) odgovora korisnicima.',
        'Don\'t forget to add a new response a queue!' => 'Ne zaboravite da novi odgovor dodate u rep!',
        'Delete this entry' => 'Obrii ovaj unos',
        'Add Response' => 'Dodaj odgovor',
        'Edit Response' => 'Uredi odgovor',
        'The current ticket state is' => 'Trenutni status kartice je',
        'Your email address is' => 'Vaa adresa E-pote je',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => 'Upravljanje vezama odgovori <-> privitci',
        'Filter for Attachments' => 'Filtar za privitke',
        'Change Response Relations for Attachment' => 'Promijeni veze sa odgovorima za privitke',
        'Change Attachment Relations for Response' => 'Promijeni veze sa prilozima za odgovor',
        'Toggle active for all' => 'Promijeni stanje aktivnosti za sve',
        'Link %s to selected %s' => 'Povei %s sa izabranim %s',

        # Template: AdminRole
        'Role Management' => 'Upravljanje ulogama',
        'Add role' => 'Dodaj ulogu',
        'Create a role and put groups in it. Then add the role to the users.' => 'Stvori ulogu i dodaj grupe u nju. Zatim dodaj ulogu zaposlenicima.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => 'Nema definiranih uloga. Koristite tipku za dodavanje nove uloge.',
        'Add Role' => 'Dodaj ulogu',
        'Edit Role' => 'Uredi ulogu',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => 'Upravljanje vezama uloga <-> grupa',
        'Filter for Roles' => 'Filtar uloga',
        'Roles' => 'Uloge',
        'Select the role:group permissions.' => 'Izaberi dozvole za ulogu:grupu',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => 'Ukoliko nita nije izabrano, onda nema dozvola u ovoj grupi (kartice nee biti dostupne za ovu ulogu).',
        'Change Role Relations for Group' => 'Promijeni veze sa ulogama za grupu',
        'Change Group Relations for Role' => 'Promijeni veze sa grupama za ulogu',
        'Toggle %s permission for all' => 'Promijeni %s dozvole za sve',
        'move_into' => 'premjesti u',
        'Permissions to move tickets into this group/queue.' => 'Pravo da se karticu premjesti u ovu grupu/rep.',
        'create' => 'kreiranje',
        'Permissions to create tickets in this group/queue.' => 'Pravo da se karticu kreira u ovoj grupi/repu.',
        'priority' => 'prioritet',
        'Permissions to change the ticket priority in this group/queue.' => 'Pravo da se mijenja prioritet kartice u ovoj grupi/repu.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => 'Upravljanje vezama zaposlenik <-> uloga',
        'Filter for Agents' => 'Filtar zaposlenika',
        'Agents' => 'Zaposlenici',
        'Manage Role-Agent Relations' => 'Upravljanje vezama zaposlenik <-> uloga',
        'Change Role Relations for Agent' => 'Promijeni veze sa ulogama za zaposlenika',
        'Change Agent Relations for Role' => 'Promijeni veze sa zaposlenicima za ulogu',

        # Template: AdminSLA
        'SLA Management' => 'Upravljanje SLA',
        'Add SLA' => 'Dodaj SLA',
        'Edit SLA' => 'Uredi SLA',
        'Please write only numbers!' => 'Molimo piite samo brojeve!',

        # Template: AdminSMIME
        'S/MIME Management' => '"S/MIME" upravljanje',
        'Add certificate' => 'Dodaj vjerodajnicu',
        'Add private key' => 'Dodaj privatni klju',
        'Filter for certificates' => '',
        'Filter for SMIME certs' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Na ovaj nain moete izravno urediti vjerodajnice i privatne kljueve u sustavu datoteka.',
        'See also' => 'Pogledaj jo',
        'Hash' => 'Hash',
        'Create' => 'Otvori',
        'Delete this certificate' => 'Obrii ovu vjerodajnicu',
        'Add Certificate' => 'Dodaj vjerodajnicu',
        'Add Private Key' => 'Dodaj privatni klju',
        'Secret' => 'Tajna',

        # Template: AdminSalutation
        'Salutation Management' => 'Upravljanje zaglavljima/pozdravima',
        'Add salutation' => 'Dodaj zaglavlje/pozdrav',
        'Add Salutation' => 'Dodaj zaglavlje/pozdrav',
        'Edit Salutation' => 'Uredi zaglavlje/pozdrav',
        'Example salutation' => 'Primjer zaglavlja/pozdrava',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => 'Potrebno je da "siguran nain" bude ukljuen!',
        'Secure mode will (normally) be set after the initial installation is completed.' => '"Siguran nain" e (uobuajeno) biti postavljen nakon inicijalne instalacije.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => '"Siguran nain" mora biti iskljuen radi reinstalacije putem weba.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => 'Ukoliko "siguran nain" nije aktiviran, pokrenite ga kroz konfiguraciju sustava jer je vaa aplikacija ve pokrenuta.',

        # Template: AdminSelectBox
        'SQL Box' => 'SQL Box',
        'Here you can enter SQL to send it directly to the application database.' => 'Ovde moete unijeti SQL naredbe i poslati ih izravno aplikacijskoj bazi podataka.',
        'The syntax of your SQL query has a mistake. Please check it.' => 'Postoji pogreka u sintaksi vaeg SQL upita. Molimo provjerite.',
        'There is at least one parameter missing for the binding. Please check it.' => 'Najmanje jedan parametar nedostaje za povezivanje. Molimo provjerite.',
        'Result format' => 'Format rezultata',
        'Run Query' => 'Pokreni upit',

        # Template: AdminService
        'Service Management' => 'Upravljanje uslugama',
        'Add service' => 'Dodaj uslugu',
        'Add Service' => 'Dodaj uslugu',
        'Edit Service' => 'Uredi uslugu',
        'Sub-service of' => 'Pod-usluga od',

        # Template: AdminSession
        'Session Management' => 'Upravljanje sesijama',
        'All sessions' => 'Sve sesije',
        'Agent sessions' => 'Sesije zaposlenika',
        'Customer sessions' => 'Sesije korisnika',
        'Unique agents' => 'Jedinsveni zapolenici',
        'Unique customers' => 'Jedinstveni korisnici',
        'Kill all sessions' => 'Ugasi sve sesije',
        'Kill this session' => 'Ugasi ovu sesiju',
        'Session' => 'Sesija',
        'Kill' => 'Ugasi',
        'Detail View for SessionID' => 'Detaljni pregled za ID sesije',

        # Template: AdminSignature
        'Signature Management' => 'Upravljanje podnojima/potpisima',
        'Add signature' => 'Dodaj podnoje/potpis',
        'Add Signature' => 'Dodaj podnoje/potpis',
        'Edit Signature' => 'Uredi podnoje/potpis',
        'Example signature' => 'Primjer podnoja/potpisa',

        # Template: AdminState
        'State Management' => 'Upravljanje statusima',
        'Add state' => 'Dodaj status',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Nemojte zaboraviti aurirati i zadane statuse u "Kernel/Config.pm" datoteci!',
        'Add State' => 'Dodaj status',
        'Edit State' => 'Uredi status',
        'State type' => 'Tip statusa',

        # Template: AdminSysConfig
        'SysConfig' => 'Postavke sustava',
        'Navigate by searching in %s settings' => 'Pretraivanje kroz %s postavki',
        'Navigate by selecting config groups' => '',
        'Download all system config changes' => 'Preuzmi sve promjene postavki sustava',
        'Export settings' => 'Izvoz postavki',
        'Load SysConfig settings from file' => 'Uitaj postavke sustava iz datoteke',
        'Import settings' => 'Uvoz postavki',
        'Import Settings' => 'Uvezi postavke sustava iz datoteke',
        'Import' => 'Uvoz',
        'Please enter a search term to look for settings.' => 'Molimo unesite upit za traenje postavki.',
        'Subgroup' => 'Podgrupa',
        'Elements' => 'Elementi',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => 'Uredi konfiguracijske postavke',
        'This config item is only available in a higher config level!' => 'Ova konfiguracijska stavka je dostupna samo na vioj razini konfiguriranja!',
        'Reset this setting' => 'Reset postavke',
        'Default value' => 'Zadana vrijednost',
        'Error: this file could not be found.' => 'Greka: datoteka nije pronaena.',
        'Error: this directory could not be found.' => 'Greka: mapa nije pronaena.',
        'Error: an invalid value was entered.' => 'Greka: unijeta je pogrena vrijednost.',
        'Content' => 'Sadraj',
        'Remove this entry' => 'Ukloni ovaj unos',
        'Add entry' => 'Dodaj unos',
        'Remove entry' => 'Ukloni unos',
        'Add new entry' => 'Dodaj novi unos',
        'Create new entry' => 'Napravi novi unos',
        'New group' => 'Nova grupa',
        'Group ro' => 'Grupa "RO"',
        'Readonly group' => 'Grupa samo za itanje',
        'New group ro' => 'Nova "RO" grupa',
        'Loader' => '"Loader"',
        'File to load for this frontend module' => 'Datoteka koju treba uitati za ovaj modul',
        'New Loader File' => 'Nova "Loader" datoteka',
        'NavBarName' => 'Naziv navigacijske trake',
        'NavBar' => 'Navigacijska traka',
        'LinkOption' => 'Opcije veze',
        'Block' => 'Blok',
        'AccessKey' => 'Klju za pristup',
        'Add NavBar entry' => 'Dodaj stavku u navigacijsku traku',
        'Year' => 'godina',
        'Month' => 'mjesec',
        'Day' => 'dan',
        'Invalid year' => 'Pogrena godina',
        'Invalid month' => 'Pogrean mjesec',
        'Invalid day' => 'Pogrean dan',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Upravljanje E-potom sustava',
        'Add system address' => 'Dodaj sistemsku adresu',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => 'Sve dolazne poruke sa ovom adresom u polju "Za" ili "Cc" bit e otpremljene u odabrani rep.',
        'Email address' => 'Adresa E-pote',
        'Display name' => 'Prikai ime',
        'Add System Email Address' => 'Dodaj adresu E-pote sustava',
        'Edit System Email Address' => 'Uredi adresu E-pote sustava',
        'The display name and email address will be shown on mail you send.' => 'Ime i adresa E-pote bit e prikazani na poruci koju ste poslali.',

        # Template: AdminType
        'Type Management' => 'Upravljanje tipovima',
        'Add ticket type' => 'Dodaj tip kartice',
        'Add Type' => 'Dodaj tip',
        'Edit Type' => 'Uredi tip',

        # Template: AdminUser
        'Add agent' => 'Dodaj zaposlenika',
        'Agents will be needed to handle tickets.' => 'Za obradu kartice potrebni su zaposlenici.',
        'Don\'t forget to add a new agent to groups and/or roles!' => 'Ne zaboravite dodati novog zaposlenika u grupe i/ili uloge!',
        'Please enter a search term to look for agents.' => 'Molimo unesite upit za pretragu radi nalaenja zaposlenika.',
        'Last login' => 'Prethodna prijava',
        'Login as' => 'Prijavi se kao',
        'Switch to agent' => 'Prei na zaposlenika',
        'Add Agent' => 'Dodaj zaposlenika',
        'Edit Agent' => 'Uredi zaposlenika',
        'Firstname' => 'Ime',
        'Lastname' => 'Prezime',
        'Password is required.' => '',
        'Start' => 'Start',
        'End' => 'Kraj',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => 'Upravljanje vezama zaposlenik <-> grupa',
        'Change Group Relations for Agent' => 'Promijeni veze s grupama za zaposlenika',
        'Change Agent Relations for Group' => 'Promijeni veze s zaposlnicima za grupu',
        'note' => 'napomena',
        'Permissions to add notes to tickets in this group/queue.' => 'Dozvola za dodavanje napomena na kartice u ovoj grupi/repu.',
        'owner' => 'Vlasnik',
        'Permissions to change the owner of tickets in this group/queue.' => 'Dozvole za promjenu vlasnika kartice u ovoj grupi/repu.',

        # Template: AgentBook
        'Address Book' => 'Adresar',
        'Search for a customer' => 'Trai korisnika',
        'Add email address %s to the To field' => 'Dodaj adresu E-pote %s u polje "Za:"',
        'Add email address %s to the Cc field' => 'Dodaj adresu E-pote %s u polje "Cc:"',
        'Add email address %s to the Bcc field' => 'Dodaj adresu E-pote %s u polje "Bcc:"',
        'Apply' => 'Primjeni',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Trai korisnika',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Nadzorna ploa',
        'Show or hide the content' => 'Prikai ili sakrij sadraj',

        # Template: AgentDashboardCalendarOverview
        'in' => 'u',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s je dostupno!',
        'Please update now.' => 'Molimo aurirajte sada.',
        'Release Note' => 'Obavijest o verziji',
        'Level' => 'Razina',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Poslano prije %s.',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => 'kartica je zakljuana.',
        'Undo & close window' => 'Odustani & zatvori prozor',

        # Template: AgentInfo
        'Info' => 'Info',
        'To accept some news, a license or some changes.' => 'Da bi prihvatili neke vijesti, licencu ili promjenu.',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Povei objekt: %s',
        'Close window' => 'Zatvori prozor',
        'go to link delete screen' => 'idi na ekran za brisanje veze',
        'Select Target Object' => 'Izaberi ciljni objekt',
        'Link Object' => 'Povei objekt',
        'with' => 'sa',
        'Unlink Object: %s' => 'Prekini vezu sa objektom: %s',
        'go to link add screen' => 'idi na prozor za dodavanje veze',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => 'Uredi osobne postavke',

        # Template: AgentSpelling
        'Spell Checker' => 'Provjera pravopisa',
        'spelling error(s)' => 'Pravopisne pogreke',
        'Apply these changes' => 'Primjeni ove izmjene',

        # Template: AgentStatsDelete
        'Delete stat' => 'Obrii statistiku',
        'Stat#' => 'Statistika br.',
        'Do you really want to delete this stat?' => 'Da li uistinu elite obrisati ovu statistiku?',

        # Template: AgentStatsEditRestrictions
        'Step %s' => 'Korak %s',
        'General Specifications' => 'Ope specifikacije',
        'Select the element that will be used at the X-axis' => 'Izaberite element koji e biti upotrebljen na X-osi',
        'Select the elements for the value series' => 'Izaberite elemente za opsege vrijednosti',
        'Select the restrictions to characterize the stat' => 'Izaberite ogranienja znaajna za statistiku',
        'Here you can make restrictions to your stat.' => 'Ovdje moete postaviti ogranienja na vaoj statistici.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Ako uklonite oznaku sa elementa "Fiksirano", zaposlenik koji radi statistiku e moi izmijeniti atribute tog elementa.',
        'Fixed' => 'Fiksirano',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Molimo izaberite samo jedan element ili iskljuite tipku "fiksirano"!',
        'Absolute Period' => 'Apsolutni period',
        'Between' => 'Izmeu',
        'Relative Period' => 'Relativni period',
        'The last' => 'Posljednji',
        'Finish' => 'Zavri',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Dozvole',
        'You can select one or more groups to define access for different agents.' => 'Radi odreivanja prava pristupa za zaposlenika, moete izabrati jednu ili vie grupa.',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => 'Molimo, kontaktirajte vaeg administratora.',
        'Graph size' => 'Veliina grafa',
        'If you use a graph as output format you have to select at least one graph size.' => 'Ako koristite graf kao izlazni format morate odabrati najmanje jednu veliinu grafa.',
        'Sum rows' => 'Zbroj redova',
        'Sum columns' => 'Zbroj kolona',
        'Use cache' => 'Koristi predmemoriju',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Veina stat. podataka se moe keirati. Ovo e ubrzati prikaz statistike.',
        'If set to invalid end users can not generate the stat.' => 'Ako je pogreno, krajnji korisnici ne mogu generisati statistiku.',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => 'Ovde moete definisati opsege vrednosti.',
        'You have the possibility to select one or two elements.' => 'Imate mogunost da izaberete jedan ili dva elementa.',
        'Then you can select the attributes of elements.' => 'Onda moete izabrati atribute za elemente.',
        'Each attribute will be shown as single value series.' => 'Svaki atribut e biti prikazan kao pojedinani opseg vrednosti.',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => 'Ako ne izaberete ni jedan atribut, prilikom generisanja statistike bie upotrebljeni svi atributi elementa kao i atributi dodani nakon poslednje konfiguracije.',
        'Scale' => 'Skaliranje',
        'minimal' => 'minimum',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Molimo zapamtite, da skala za opsege vrednosti moda da bude vea od skale za X-os (npr X-os => mjesec; Vrijednost opsega => godina).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'maksimalni period',
        'minimal scale' => 'minimalna skala',

        # Template: AgentStatsImport
        'Import Stat' => 'Uvezi statistiku',
        'File is not a Stats config' => 'Ova datoteka nije konfiguracija statistike',
        'No File selected' => 'Nije izabrana nijedna datoteka',

        # Template: AgentStatsOverview
        'Stats' => 'Statistika',
        'Object' => 'Objekt',

        # Template: AgentStatsPrint
        'Print' => 'Otisni',
        'No Element selected.' => 'Niste odabrali niti jedan od elemenata.',

        # Template: AgentStatsView
        'Export config' => 'Izvezi konfiguraciju',
        'With the input and select fields you can influence the format and contents of the statistic.' => 'Preko polja za unos i izbor moete utjecati na oblik i sadraj statistike.',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => 'Na koja polja i formate moete utjecati definirano je od strane administratora statistike.',
        'Stat Details' => 'Detalji staistke',
        'Format' => 'Format',
        'Graphsize' => 'Veliina grafa',
        'Cache' => 'Predmemorija',
        'Exchange Axis' => 'Zamijeni ose',
        'Configurable params of static stat' => 'Postavi parametri statike statistike',
        'No element selected.' => 'Nije izabran ni jedan element.',
        'maximal period from' => 'maksimalni period od',
        'to' => 'do',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => 'Promijeni "slobodan" tekst kartice',
        'Change Owner of Ticket' => 'Promijeni vlasnika kartice',
        'Close Ticket' => 'Zatvori karticu',
        'Add Note to Ticket' => 'Dodaj napomenu uz karticu',
        'Set Pending' => 'Stavi na ekanje',
        'Change Priority of Ticket' => 'Promijeni prioritet kartice',
        'Change Responsible of Ticket' => 'Promijeni odgovornog za karticu',
        'Cancel & close window' => 'Poniti & zatvori prozor',
        'Service invalid.' => 'Neispravan servis',
        'New Owner' => 'Novi vlasnik',
        'Please set a new owner!' => 'Molimo odredite novog vlasnika',
        'Previous Owner' => 'Prethodni vlasnik',
        'Inform Agent' => 'Obavijesti zaposlenika',
        'Optional' => 'Proizvoljno',
        'Inform involved Agents' => 'Obavijesti ukljuene zaposlenike',
        'Spell check' => 'Provjera pravopisa',
        'Note type' => 'Tip napomene',
        'Next state' => 'Sljedei status',
        'Pending date' => 'ekanje do',
        'Date invalid!' => 'Neispravan datum',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => 'Preusmjeri karticu',
        'Bounce to' => 'Preusmjeri na',
        'You need a email address.' => 'Potrebna vam je adresa E-pote.',
        'Need a valid email address or don\'t use a local email address.' => 'Ispravna adresa E-pote je neophodna, ali ne koristite lokalnu adresu!',
        'Next ticket state' => 'Naredni status kartice',
        'Inform sender' => 'Obavijesti poiljaoca',
        'Send mail!' => 'Poalji E-potu!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Grupne akcije na karticama',
        'Merge to' => 'Objedini sa',
        'Invalid ticket identifier!' => 'Neispravan identifikator kartice!',
        'Merge to oldest' => 'Objedini sa najstarijom',
        'Link together' => 'Povei zajedno',
        'Link to parent' => 'Povei s nadreenim',
        'Unlock tickets' => 'Otkljuaj karticu',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Napii odgovor na karticu',
        'Need a valid email address.' => 'Potrebna ispravna adresa E-pote.',
        'Address book' => 'Adresar',
        'Pending Date' => 'Datum ekanja',
        'for pending* states' => 'za stanja ekanja',
        'Date Invalid!' => 'Neispravan datum!',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Promjena korisnika za karticu',
        'Customer Data' => 'Podaci o korisniku',
        'Customer user' => 'Korisnik',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => 'Otvori novu karticu E-pote',
        'From queue' => 'Iz repa',
        'Get all' => 'Dohvati sve',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => 'Proslijedi karticu',
        'Need a valid email address or don\'t use a local email address' => '',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Dnevnik za',
        'History Content' => 'Sadraj dnevnika',
        'Zoom view' => 'Detaljni pregled',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Spajanje kartice',
        'You need to use a ticket number!' => 'Molimo vas da koristite broj kartice!',
        'A valid ticket number is required.' => 'Neophodan je ispravan broj kartice.',

        # Template: AgentTicketMove
        'Move Ticket' => 'Premjesti karticu',
        'New Queue' => 'Novi rep',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => 'Izaberi sve',
        'No ticket data found.' => 'Nisu naeni podaci o kartici',
        'First Response Time' => 'Vrijeme prvog odgovora',
        'Service Time' => 'Vrijeme usuivanja',
        'Update Time' => 'Vrijeme auriranja',
        'Solution Time' => 'Vrijeme rjeenja',
        'Move ticket to a different queue' => 'Premjesti karticu u drugi rep',
        'Change queue' => 'Promjeni rep',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Promjeni opcije pretrage',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalacija u',
        'Locked' => 'Zakljuano',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'Otvori novi telefonski karticu',
        'From customer' => 'Od Korisnika',
        'To queue' => 'U rep',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Telefonski poziv',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'Pregled neformatirane poruke',
        'Plain' => 'Neformatirano',
        'Download this email' => 'Preuzmi ovu poruku',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Info o kartici',
        'Accounted time' => 'Obraunato vrijeme',
        'Linked-Object' => 'Povezani objekt',
        'by' => 'od',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Predloak pretrage',
        'Create Template' => 'Napravi predloak',
        'Create New' => 'Napravi novi',
        'Profile link' => '',
        'Save changes in template' => 'Sauvaj promjene u predloku',
        'Add another attribute' => 'Dodaj jo jedan atribut',
        'Output' => 'Pregled rezultata',
        'Fulltext' => 'Tekst',
        'Remove' => 'Ukloni',
        'Customer User Login' => 'Prijava korisnika',
        'Time1' => 'Vrijeme1',
        'Time2' => 'Vrijeme2',
        'Time3' => 'Vrijeme3',
        'Time4' => 'Vrijeme4',
        'Time5' => 'Vrijeme5',
        'Time6' => 'Vrijeme6',
        'Created in Queue' => 'Otvoreno u repu',
        'Lock state' => 'Status zakljuavanja',
        'Watcher' => 'Praenje',
        'Article Create Time (before/after)' => 'Vrijeme kreiranja lanka (prije/poslije)',
        'Article Create Time (between)' => 'Vrijeme kreiranja lanka (izmeu)',
        'Ticket Create Time (before/after)' => 'Vrijeme otvaranja kartice (prije/poslije)',
        'Ticket Create Time (between)' => 'Vrijeme otvaranja kartice (izmeu)',
        'Ticket Change Time (before/after)' => 'Vrijeme promjene kartice (prije/poslije)',
        'Ticket Change Time (between)' => 'Vrijeme promjene kartice (izmeu)',
        'Ticket Close Time (before/after)' => 'Vrijeme zatvaranja kartice (prije/poslije)',
        'Ticket Close Time (between)' => 'Vrijeme zatvaranja kartice (izmeu)',
        'Archive Search' => 'Pretraga arhive',
        'Run Search' => 'Pokreni pretragu',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => 'Filtar za lanke',
        'Article Type' => 'Tip lanka',
        'Sender Type' => '',
        'Save filter settings as default' => 'Sauvaj postavke filtra kao zadane',
        'Ticket Information' => 'Informacije o kartici',
        'Linked Objects' => 'Povezani objekti',
        'Article(s)' => 'lanak/ci',
        'Change Queue' => 'Promijeni rep',
        'Article Filter' => 'Filtar lanka',
        'Add Filter' => 'Dodaj filtar',
        'Set' => 'Postavi',
        'Reset Filter' => 'Reset filtra',
        'Show one article' => 'Prikai jedan lanak',
        'Show all articles' => 'Prikai sve lanke',
        'Unread articles' => 'Neproitani lanci',
        'No.' => 'Br.',
        'Unread Article!' => 'Neproitani lanci!',
        'Incoming message' => 'Dolazna poruka',
        'Outgoing message' => 'Odlazna poruka',
        'Internal message' => 'Interna poruka',
        'Resize' => 'Promjena veliine',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => 'Zbog zatite vae privatnosti, aktivni ili/i udaljeni sadraj je blokiran.',
        'Load blocked content.' => 'Uitaj blokirani sadraj.',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Slijeevina',

        # Template: CustomerFooter
        'Powered by' => 'Pokree',
        'One or more errors occurred!' => 'Dogodila se jedna ili vie greaka!',
        'Close this dialog' => 'Zatvori ovaj dijalog',
        'Could not open popup window. Please disable any popup blockers for this application.' => 'Nije mogue otvoriti iskaui prozor. Molimo da iskljuite blokadu iskauih prozora za ovu aplikaciju.',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Prijava za rad',
        'User name' => 'Korisniko ime',
        'Your user name' => 'Vae korisniko ime',
        'Your password' => 'Vaa lozinka',
        'Forgot password?' => 'Zaboravili ste lozinku?',
        'Log In' => 'Prijavi se',
        'Not yet registered?' => 'Niste registrirani?',
        'Sign up now' => 'Registrirajte se sada',
        'Request new password' => 'Zahtjev za novu lozinku',
        'Your User Name' => 'Vae korisniko ime',
        'A new password will be sent to your email address.' => 'Nova lozinka e Vam biti poslana na Vau adresu E-pote.',
        'Create Account' => 'Kreirajte nalog',
        'Please fill out this form to recieve login credentials.' => 'Molimo, popunite ovaj obrazac kako bi ste dobili podatke za prijavu.',
        'How we should address you' => 'Kako da Vas oslovljavamo',
        'Your First Name' => 'Vae ime',
        'Please supply a first name' => 'Molimo, unesite ime',
        'Your Last Name' => 'Vae prezime',
        'Please supply a last name' => 'Molimo, unesite prezime',
        'The User Name you wish to have' => 'Korisniko ime koje bi ste eljeli',
        'Please supply a' => 'Molimo, unesite',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => 'Uredite osobne postavke',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => 'Sporazum o razini usluge',

        # Template: CustomerTicketOverView
        'Welcome!' => 'Dobrodoli!',
        'Please click the button below to create your first ticket.' => 'Molimo kliknite tipku ispod kako bi ste zapoeli svoju prvu karticu prijave problema.',
        'Create your first ticket' => 'Zaponi prvu karticu',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => 'npr 10*5155 ili 105658*',
        'Customer ID' => 'ID korisnika',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => 'Tekstualno pretraivanje u karticama (npr "Mar*a" or "Hor*i")',
        'Recipient' => 'Primalac',
        'Carbon Copy' => 'Kopija',
        'Time restrictions' => 'Vremenska ogranienja',
        'Only tickets created' => 'Samo tek otvorene kartice',
        'Only tickets created between' => 'Samo kartice otvoreni izmeu',
        'Search-Profile as Template?' => 'Profil pretraivanja kao predloak?',
        'Save as Template?' => 'Sauvati kao predloak?',
        'Save as Template' => '',
        'Template Name' => 'Naziv predloka',
        'Pick a profile name' => '',
        'Output to' => 'Izlaz na',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'od',
        'Page' => 'Strana',
        'Search Results for' => 'Rezultati pretraivanja za',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => 'Odgovori',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => 'Neispravan datum (poteban budui datum)!',
        'Previous' => 'Natrag',
        'Sunday' => 'nedjelja',
        'Monday' => 'ponedjeljak',
        'Tuesday' => 'utorak',
        'Wednesday' => 'srijeda',
        'Thursday' => 'etvrtak',
        'Friday' => 'petak',
        'Saturday' => 'subota',
        'Su' => 'ne',
        'Mo' => 'po',
        'Tu' => 'ut',
        'We' => 'sr',
        'Th' => 'e',
        'Fr' => 'pe',
        'Sa' => 'su',
        'Open date selection' => 'Otvori izbor datuma',

        # Template: Error
        'Oops! An Error occurred.' => 'Ups. Dogodila se pogreka.',
        'Error Message' => 'Poruka o pogreci',
        'You can' => 'Vi moete',
        'Send a bugreport' => 'Poalji izvjetaj o pogreci',
        'go back to the previous page' => 'idi na prethodnu stranu',
        'Error Details' => 'Detalji pogreke',

        # Template: Footer
        'Top of page' => 'Na vrh strane',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => 'Ako napustite ovu stranicu, svi otvoreni prozori bit e zatvoreni!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => 'Prikaz ovog ekrana je ve otvoren. elite li zatvoriti i uitati ovaj umjesto njega?',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'Prijavljeni ste kao',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'JavaScript nije dostupan.',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'Kako bi ste koristili OTRS potrebno je aktivirati JavaScript u vaem web pregledniku.',
        'Database Settings' => 'Postavke baze podataka',
        'General Specifications and Mail Settings' => 'Ope specifikacije i postavke E-pote',
        'Welcome to %s' => 'Dobrodoli na %s',
        'Web site' => 'Web stranica',
        'Database check successful.' => 'Uspjena provjera baze podataka.',
        'Mail check successful.' => 'Uspjena provjera postavki E-pote.',
        'Error in the mail settings. Please correct and try again.' => 'Greka u postavkama E-pote. Molimo ispravite i pokuajte ponovo.',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => 'Podeavanje odlazne E-pote',
        'Outbound mail type' => 'Tip odlazne E-pote',
        'Select outbound mail type.' => 'Izaberite tip odlazne E-pote',
        'Outbound mail port' => 'Port za odlaznu E-potu',
        'Select outbound mail port.' => 'Izaberite port za odlaznu E-potu',
        'SMTP host' => 'SMTP host',
        'SMTP host.' => 'SMTP host.',
        'SMTP authentication' => 'SMTP autentikacija',
        'Does your SMTP host need authentication?' => 'Zahtijeva li va SMTP host autentikaciju?',
        'SMTP auth user' => 'SMTP korisnik',
        'Username for SMTP auth.' => 'korisniko ime za SMTP autentikaciju',
        'SMTP auth password' => 'SMTP lozinka',
        'Password for SMTP auth.' => 'Lozinka za SMTP autentikaciju',
        'Configure Inbound Mail' => 'Podestavljanje dolazne E-pote',
        'Inbound mail type' => 'Tip dolazne E-pote',
        'Select inbound mail type.' => 'Izaberi tip dolazne E-pote',
        'Inbound mail host' => 'Server dolazne E-pote',
        'Inbound mail host.' => 'Server dolazne E-pote.',
        'Inbound mail user' => 'Korisnik dolazne E-pote',
        'User for inbound mail.' => 'Korisnik dolazne E-pote',
        'Inbound mail password' => 'Lozinka dolazne E-pote',
        'Password for inbound mail.' => 'Lozinka dolazne E-pote',
        'Result of mail configuration check' => 'Rezultat provjere postavki E-pote',
        'Check mail configuration' => 'Provjeri konfiguracijske postavke E-pote',
        'Skip this step' => 'Preskoi ovaj korak',

        # Template: InstallerDBResult
        'False' => '"False"',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Ako ste podesili "root" lozinku za vau bazu podataka, ona mora biti unesena ovdje. Ako nema lozinke, ostavite polje prazno. Iz sigurnosnih razloga preporuujemo da je podesite. Za vie informacija prouite dokumentaciju o bazi podataka.',
        'Currently only MySQL is supported in the web installer.' => 'Trenutno je samo MySQL podran u Web Instalaciji.',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => 'Ako elite instalirati OTRS na neki drugi sustav baze podataka, prouite informacije u datoteci README.database.',
        'Database-User' => 'Korisnik baze podataka',
        'New' => 'Nov',
        'A new database user with limited rights will be created for this OTRS system.' => 'Novi korisnik baze sa ogranienim pravima bit e  kreiran za ovaj OTRS sustav',
        'default \'hot\'' => 'podrazumijevano \'hot\'',
        'DB--- host' => 'Naziv ili adresa DB servera',
        'Database' => 'Baza podataka (DB)',
        'Check database settings' => 'Provjerite postavke baze podataka',
        'Result of database check' => 'Rezultat provjere baze podataka',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Da biste mogli koristiti OTRS morate unijeti slijedeu liniju u Vau komandnu liniju (Terminal/Shell) kao "root".',
        'Restart your webserver' => 'Ponovo pokrenite Va WEB Server.',
        'After doing so your OTRS is up and running.' => 'Nakon ovoga Va OTRS je ukljuen i radi.',
        'Start page' => 'Poetna strana',
        'Your OTRS Team' => 'Va OTRS Tim',

        # Template: InstallerLicense
        'Accept license' => 'Prihvati licencu',
        'Don\'t accept license' => 'Ne prihvaaj licencu',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'Sustavski ID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => 'Sustavski identifikator. Svaki broj kartice i svaki ID HTTP sesije sadri ovaj broj.',
        'System FQDN' => 'Sustavski FQDN',
        'Fully qualified domain name of your system.' => 'FQDN - ime servera ukljuujui puno ime domena, npr. "otrs-server.example.org"',
        'AdminEmail' => 'E-mail administrator',
        'Email address of the system administrator.' => 'E-mail adresa administratora sustava.',
        'Organization' => 'Organizacija',
        'Log' => 'Dnevnik',
        'LogModule' => 'Modul dnevnika',
        'Log backend to use.' => 'Sustav koji se koristi za dnevnik.',
        'LogFile' => 'Datoteka dnevnika',
        'Log file location is only needed for File-LogModule!' => 'Lokacija datoteke dnevnika je jedino neophodna za Modul dnevnika!',
        'Webfrontend' => 'Mreno suelje',
        'Default language' => 'Zadani jezik',
        'Default language.' => 'Zadani jezik.',
        'CheckMXRecord' => 'Provjeri DNS/MX podatke',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => 'Runo unesena e-mail adresa se provjerava pomou MX podatka pronaenog u DNS-u. Nemojte koristiti ovu opciju ako je va DNS spor ili ne moe razrijeiti javne adrese.',

        # Template: LinkObject
        'Object#' => 'Objekt#',
        'Add links' => 'Dodaj veze',
        'Delete links' => 'Obrii veze',

        # Template: Login
        'JavaScript Not Available' => 'JavaScript nije dostupan.',
        'Browser Warning' => 'Upozorenje preglednika',
        'The browser you are using is too old.' => 'Preglednik koji koristite je previe star.',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => 'OTRS funcionira na velikom broju preglednika, molimo da instalirate i koristite jedan od ovih.',
        'Please see the documentation or ask your admin for further information.' => 'Molimo da pregledate dokumentaciju ili pitate vaeg administratora za dodatne informacije.',
        'Lost your password?' => 'Izgubili ste lozinku?',
        'Request New Password' => 'Zahtjev za novu lozinku',
        'Back to login' => 'Natrag na prijavu',

        # Template: Motd
        'Message of the Day' => 'Dananja poruka',

        # Template: NoPermission
        'Insufficient Rights' => 'Nedovoljna ovlatenja',
        'Back to the previous page' => 'Vratite se na prethodnu stranicu',

        # Template: Notify

        # Template: Pagination
        'Show first page' => 'Pokai prvu stranicu',
        'Show previous pages' => 'Pokai prethodne stranice',
        'Show page %s' => 'Pokai stranicu %s',
        'Show next pages' => 'Pokai slijedee stranice',
        'Show last page' => 'Pokai posljednju stranicu',

        # Template: PictureUpload
        'Need FormID!' => 'Potreban ID formulara!',
        'No file found!' => 'Datoteka nije pronaena!',
        'The file is not an image that can be shown inline!' => 'Datoteka nije slika koja se moe neposredno prikazati!',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'otisnuo',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS test stranica',
        'Welcome %s' => 'Dobrodoli %s',
        'Counter' => 'Broja',

        # Template: Warning
        'Go back to the previous page' => 'Vratite se na prethodnu stranicu',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '"ACL" modul koji dozvoljava da nadreene kartice budu zatvorene samo ako su ve zatvorene sve podreene kartice ("Status" pokazuje koji statusi nisu dostupni za karticu roditelj dok se ne zatvore sve kartice djeca).',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => 'Aktivira "tipkanje unaprijed" za funkciju autokompletiranja, koja omoguava korisnicima da ukucavaju teks bilo kojom brzinom, bez gubljenja informacija. Najee to znai da na ekranu nee svaki pritisak na tipku biti odmah prikazan.',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => 'Aktivira mehanizam treptanja retka koji sadri najstariju karticu.',
        'Activates lost password feature for agents, in the agent interface.' => 'Aktivira opciju izgubljene lozinke za zaposlene, na suelju za njih.',
        'Activates lost password feature for customers.' => 'Aktivira opciju izgubljene lozinke za korisnike.',
        'Activates support for customer groups.' => 'Aktivira podrku za korisnike grupe.',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => 'Aktivira filter za lanke u proirenom pregledu radi definiranja koji lanci trebaju biti prikazani.',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => 'Aktivira raspoloive teme - ablone u sustavu. Vrijednost 1 znai aktivno, 0 znai neaktivno.',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => 'Aktivira arhivski sustav radi ubrzanja rada, uklanjanjem nekih kartica iz dnevnog praenja. Za pronalazak kartica, oznaena arhiva mora biti omoguena za pretragu kartica.',
        'Activates time accounting.' => 'Aktivira mjerenje vremena.',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => 'Dodaje korisnike e-mail adrese primaocima u prozoru za otvaranje kartice na suelju zaposlenog.',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 1. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 2. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 3. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 4. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 5. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 6. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 7. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 8. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane za kalendar broj 9. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Jednokratno dodaje neradne dane. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 1. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 2. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 3. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 4. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 5. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 6. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 7. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 8. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane za kalendar broj 9. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Trajno dodaje neradne dane. Molimo Vas da koristite jednoznamenkasti broj od 1 do 9 (umjesto 01 - 09).',
        'Agent Notifications' => 'Obavijesti zaposlenima',
        'Agent interface article notification module to check PGP.' => 'Modul suelja zaposlenih za obavjetavanja o lanku, provjera PGP.',
        'Agent interface article notification module to check S/MIME.' => 'Modul suelja zaposlenih za obavjetavanja o lanku, provjera S/MIME',
        'Agent interface module to access fulltext search via nav bar.' => 'Modul suelja zaposlenih za pristup tekstualnom pretraivanju preko navigacijske trake.',
        'Agent interface module to access search profiles via nav bar.' => 'Modul suelja zaposlenih za pristup profilima pretraivanja preko navigacijske trake.',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => 'Modul suelja zaposlenih za provjeru dolaznih poruka u uveanom pregledu kartice ako "S/MIME"-klju postoji i dostupan je.',
        'Agent interface notification module to check the used charset.' => 'Modul suelja zaposlenih za provjeru upotrijebljenog skupa znakova.',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => 'Modul suelja zaposlenih za obvjetavanje, pregled broja kartice za koje je agent odgovoran.',
        'Agent interface notification module to see the number of watched tickets.' => 'Modul suelja zaposlenih za obvjetavanje, pregled broja praenih kartica.',
        'Agents <-> Groups' => 'Zaposlenici <-> Grupe',
        'Agents <-> Roles' => 'Zaposlenici <-> Uloge',
        'Allows adding notes in the close ticket screen of the agent interface.' => 'Dozvoljava dodavanje napomena u zatvoreni prozor kartice suelja zaposlenog.',
        'Allows adding notes in the ticket free text screen of the agent interface.' => 'Dozvoljava dodavanje napomena u prozor slobodnog teksta suelja zaposlenog.',
        'Allows adding notes in the ticket note screen of the agent interface.' => 'Dozvoljava dodavanje napomena u prozor napomene suelja zaposlenog.',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => 'Dozvoljava dodavanje napomena u prozor vlasnika kartice na uveanom prikazu u suelju zaposlenog.',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => 'Dozvoljava dodavanje napomena u prozor na ekanju uveanog prikaza u suelju zaposlenog.',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => 'Dozvoljava dodavanje napomena u prozor prioriteta na uveanom prikazu u suelju zaposlenog.',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => 'Dozvoljava dodavanje napomena u prozor odgovornog za karticu suelja zaposlenog.',
        'Allows agents to exchange the axis of a stat if they generate one.' => 'Dozvoljava zaposlenima da zamjene osi na statistici ako je generiraju.',
        'Allows agents to generate individual-related stats.' => 'Dozvoljava zaposlenima da generiraju individualnu statistiku.',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => 'Dozvoljava izbor izmeu prikaza priloga u pregledniku ili samo omoguava njihovo preuzimanje.',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => 'Dozvoljava izbor slijedeeg stanja za korisniku karticu u korisnikom suelju.',
        'Allows customers to change the ticket priority in the customer interface.' => 'Dozvoljava korisnicima da promjene prioritet kartice u korisnikom suelju.',
        'Allows customers to set the ticket SLA in the customer interface.' => 'Dozvoljava korisnicima da postave SLA za karticu u korisnikom suelju.',
        'Allows customers to set the ticket priority in the customer interface.' => 'Dozvoljava korisnicima da postave prioritet kartice u korisnikom suelju.',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => 'Dozvoljava korisnicima da postave red kartice u korisnikom suelju. Ako je postavljeno na "Ne", onda treba postaviti "QueueDefault".',
        'Allows customers to set the ticket service in the customer interface.' => 'Dozvoljava korisnicima da postave servis za karticu u korisnikom suelju.',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => 'Dozvoljava definiranje novog tipa kartice (ako je opcije tipa kartice aktivirana).',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na zatvorenom ekranu kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na e-mail ekranu kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu telefonske kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu za pisanje kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu slobodnog teksta kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu napomene kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu vlasnika kartice na suelju zaposlenog pri uveanom prikazu. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu ekanja kartice na suelju zaposlenog pri uveanom prikazu. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu odlazne telefonske kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu prioriteta kartice na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => 'Opcije slobodnog teksta lanka prikazane na ekranu odgovornog za karticu na suelju zaposlenog. Mogue postavke: 0 = iskljueno, 1 = ukljueno, 2 = ukljueno i obavezno.',
        'Attachments <-> Responses' => 'Prilozi <-> Odgovori',
        'Auto Responses <-> Queues' => 'Automatski odgovori <-> Repovi',
        'Automated line break in text messages after x number of chars.' => 'Automatski kraj retka u tekstualnim porukama nakon simbola "x".',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => 'Automatsko zakljuavanje i postavljanje vlasnika na aktualnog zaposlenog nakon izbora masovne akcije.',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => 'Balansirani bijeli izgled, Felix Niklas.',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => 'Generira indeks lanaka odmah po kreiranju lanka.',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => 'Promjena lozinke',
        'Change queue!' => 'Promjena repa!',
        'Change the ticket responsible!' => 'Promjena odgovornog za karticu!',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Christmas Eve' => '',
        'Comment for new history entries in the customer interface.' => 'Komentar za nove povijesne unose u korisnikom suelju.',
        'Companies' => 'Tvrtke',
        'Company Tickets' => 'Kartice tvrtke',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => 'Kontrolira da li korisnici imaju mogunost sortiranja svojih kartica.',
        'Converts HTML mails into text messages.' => 'Pretvara HTML poruke u tekstualne poruke.',
        'Create and manage Service Level Agreements (SLAs).' => 'Kreira i upravlja sa SLA.',
        'Create and manage agents.' => 'Kreiranje i upravljanje zaposlenima.',
        'Create and manage attachments.' => 'Kreiranje i upravljanje prilozima.',
        'Create and manage companies.' => 'Kreiranje i upravljanje tvrtkama.',
        'Create and manage customers.' => 'Kreiranje i upravljanje korisnicima.',
        'Create and manage event based notifications.' => 'Kreiranje i upravljanje dogaajem na bazi obavijesti.',
        'Create and manage groups.' => 'Kreiranje i upravljanje grupama.',
        'Create and manage notifications that are sent to agents.' => 'Kreiranje i upravljanje obavijestima za zaposlene.',
        'Create and manage queues.' => 'Kreiranje i upravljanje repovima.',
        'Create and manage response templates.' => 'Kreiranje i upravljanje predlocima odgovora.',
        'Create and manage responses that are automatically sent.' => 'Kreiranje i upravljanje automatskim odgovorima.',
        'Create and manage roles.' => 'Kreiranje i upravljanje ulogama.',
        'Create and manage salutations.' => 'Kreiranje i upravljanje pozdravima.',
        'Create and manage services.' => 'Kreiranje i upravljanje uslugama.',
        'Create and manage signatures.' => 'Kreiranje i upravljanje potpisima.',
        'Create and manage ticket priorities.' => 'Kreiranje i upravljanje prioritetima kartice.',
        'Create and manage ticket states.' => 'Kreiranje i upravljanje statusima kartice.',
        'Create and manage ticket types.' => 'Kreiranje i upravljanje tipovima kartice.',
        'Create new email ticket and send this out (outbound)' => 'Otvori novu e-mail karticu i poalji ovo (odlazni)',
        'Create new phone ticket (inbound)' => 'Kreiraj novu telefonsku karticu (dolazni poziv)',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => 'Korisnika stavka (ikona) koja pokazuje otvorene kartice ovog korisnika kao info blok.',
        'Customers <-> Groups' => 'Korisici <-> Grupe',
        'Customers <-> Services' => 'Korisnici <-> Usluge',
        'Data used to export the search result in CSV format.' => 'Podaci upotrebljeni za izvoz rezultata pretraivanja u "CSV" formatu.',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => 'Zadani ACL vrijednosti za akcije kartice.',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => 'Zadani modul zatite od petlje',
        'Default queue ID used by the system in the agent interface.' => 'Zadani ID repa koji koristi sustav u suelju zaposlenika.',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => 'Zadani izgled suelja.',
        'Default ticket ID used by the system in the agent interface.' => 'Zadani ID kartice koji koristi sustav u suelju zaposlenih.',
        'Default ticket ID used by the system in the customer interface.' => 'Zadani ID kartice koji koristi sustav u korisnikom suelju.',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => 'Definira prvi dan u nedelji za izbor datuma.',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => 'Definira korisnikovu stavku, koja generira ikonu LinkedIn na kraju korisnikovog info bloka.',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => 'Definira korisnikovu stavku, koja generira ikonu XING na kraju korisnikovog info bloka.',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => 'Definira korisnikovu stavku, koja generira ikonu google na kraju korisnikovog info bloka.',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => 'Definira korisnikovu stavku, koja generira ikonu google karti na kraju korisnikovog info bloka.',
        'Defines a default list of words, that are ignored by the spell checker.' => 'Definira zadani popis rijei, koje su zanemarene provjerom pravopisa.',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => 'Odreuje sva X-zaglavlja koja treba skenirati.',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => 'Odreuje sve parametre za ovu stavku u korisnikim podeavanjima.',
        'Defines all the possible stats output formats.' => 'Odreuje sve mogue izlazne formate statistike.',
        'Defines an alternate URL, where the login link refers to.' => 'Odreuje alternativni URL, na koji veza za prijavu pokazuje.',
        'Defines an alternate URL, where the logout link refers to.' => 'Odreuje alternativni URL, na koji veza za odjavu pokazuje.',
        'Defines an alternate login URL for the customer panel..' => 'Odreuje alternativni URL prijave za korisniki panel.',
        'Defines an alternate logout URL for the customer panel.' => 'Odreuje alternativni URL odjave za korisniki panel.',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => 'Odreuje da li porukama napisanim u interfejsu zaposlenih treba uraditi proveru pravopisa.',
        'Defines if time accounting is mandatory in the agent interface.' => 'Odreuje da li je obraun vremena obavezan u interfejsu zaposlenih.',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => 'Odreuje "URL CSS" putanju.',
        'Defines the URL base path of icons, CSS and Java Script.' => 'Odreuje URL osnovnu stazu za statini web sadraj (ikone, CSS, JS).',
        'Defines the URL image path of icons for navigation.' => 'Odreuje URL putanju do slika za navigacione ikone.',
        'Defines the URL java script path.' => 'Odreuje URL putanju java skriptova.',
        'Defines the URL rich text editor path.' => 'Odreuje URL putanju do aplikacije za ureivanje "RTF" datoteka',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => 'Odreuje telo teksta za odbaene poruke.',
        'Defines the boldness of the line drawed by the graph.' => 'Odreuje debljinu linija za grfikone.',
        'Defines the colors for the graphs.' => 'Odreuje boje za grafikone.',
        'Defines the column to store the keys for the preferences table.' => 'Odreuje kolonu za uvanje kljueva tabele podeavanja.',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => 'Odreuje konekcije za "http/ftp" preko posrednika.',
        'Defines the date input format used in forms (option or input fields).' => 'Odreuje format unosa datuma u formulare (opcija za polja za unos).',
        'Defines the default CSS used in rich text editors.' => 'Odreuje zadani CSS upotrebljen u "RTF" ureivanju.',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => 'Odreuje zadani prioritet za nove korisnike karticue u korisnikom interfejsu.',
        'Defines the default priority of new tickets.' => 'Odreuje zadani prioritet za nove karticue.',
        'Defines the default queue for new customer tickets in the customer interface.' => 'Odreuje zadani red za nove korisnike karticue u korisnikom interfejsu.',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 1 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 1 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 10 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 11 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 12 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 13 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 14 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 15 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 16 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 2 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 2 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 3 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 3 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 4 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 5 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 6 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 7 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 8 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog kljua polja broj 9 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 1 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 1 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 10 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 11 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 12 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 13 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 14 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 15 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 16 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 2 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 2 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 3 za lanke (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 3 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 4 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 5 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 6 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 7 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 8 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => 'Odreuje zadani izbor slobodnog tekst polja broj 9 za karticue (ako ima vie od jedne mogunosti).',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => 'Odreuje zadani renik za proveru pravopisa.',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => 'Odreuje zadani status novih kartice.',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => 'Odreuje slobodno polje kljua broj 1 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => 'Odreuje slobodno tekst polje broj 1 za lanke radi dodavanja novog atributa lanka.',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 1 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 10 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 11 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 12 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 13 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 14 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 15 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 16 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 2 for articles to add a new article attribute.' => 'Odreuje slobodno tekst polje broj 2 za lanke radi dodavanja novog atributa lanka.',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 2 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 3 for articles to add a new article attribute.' => 'Odreuje slobodno tekst polje broj 3 za lanke radi dodavanja novog atributa lanka.',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 3 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 4 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 5 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 6 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 7 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 8 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => 'Odreuje slobodno tekst polje broj 9 za karticue radi dodavanja novog atributa kartice.',
        'Defines the free time key field number 1 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 1 za karticue.',
        'Defines the free time key field number 2 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 2 za karticue.',
        'Defines the free time key field number 3 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 3 za karticue.',
        'Defines the free time key field number 4 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 4 za karticue.',
        'Defines the free time key field number 5 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 5 za karticue.',
        'Defines the free time key field number 6 for tickets.' => 'Odreuje slobodno polje kljua vremena broj 6 za karticue.',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => 'Odreuje visinu legende.',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 1, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 2, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 3, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 4, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 5, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 6, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 7, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 8, radi kalkulacija radnog vremena.',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => 'Odreuje sate i dane u sedmici za kalendar broj 9, radi kalkulacija radnog vremena.',
        'Defines the hours and week days to count the working time.' => 'Odreuje sate i dane u sedmici radi kalkulacija radnog vremena.',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 1 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 10 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 11 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 12 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 13 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 14 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 15 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 16 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 2 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 3 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 4 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 5 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 6 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 7 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 8 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => 'Odreuje "http" vezu za polje slobodnog teksta broj 9 za karticue (bie koriteno u svakom pregledu kartice).',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => 'Odreuje maksimalnu veliinu datoteka (u bajtima) za slanje.',
        'Defines the maximal valid time (in seconds) for a session id.' => 'Odreuje maksimalno vreme vaenja (u sekundama) za ID sesije.',
        'Defines the maximum number of pages per PDF file.' => 'Odreuje maksimalni broj strana po "PDF" datoteci.',
        'Defines the maximum size (in MB) of the log file.' => 'Odreuje maksimalnu veliinu datoteke dnevnika (u megabajtima).',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => 'Odreuje modul za autentikaciju korisnika.',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => 'Odreuje naziv kalendara broj 1.',
        'Defines the name of the calendar number 2.' => 'Odreuje naziv kalendara broj 2.',
        'Defines the name of the calendar number 3.' => 'Odreuje naziv kalendara broj 3.',
        'Defines the name of the calendar number 4.' => 'Odreuje naziv kalendara broj 4.',
        'Defines the name of the calendar number 5.' => 'Odreuje naziv kalendara broj 5.',
        'Defines the name of the calendar number 6.' => 'Odreuje naziv kalendara broj 6.',
        'Defines the name of the calendar number 7.' => 'Odreuje naziv kalendara broj 7.',
        'Defines the name of the calendar number 8.' => 'Odreuje naziv kalendara broj 8.',
        'Defines the name of the calendar number 9.' => 'Odreuje naziv kalendara broj 9.',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => 'Odreuje naziv kljua za korisnike secije.',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the sender for rejected emails.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => 'Odreuje razmake u legendi.',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => 'Odreuje standardnu veliinu "PDF" stranica.',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => 'Odreuje temu za odbaene poruke.',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => 'Odreuje identifikator korisnika za korisniki panel.',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => 'Odreuje vaee tipove statusa za karticu.',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => 'Odreuje irinu legende.',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 1 opciono ili ne.',
        'Defines whether the free time field number 2 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 2 opciono ili ne.',
        'Defines whether the free time field number 3 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 3 opciono ili ne.',
        'Defines whether the free time field number 4 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 4 opciono ili ne.',
        'Defines whether the free time field number 5 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 5 opciono ili ne.',
        'Defines whether the free time field number 6 is optional or not.' => 'Odreuje da li je slobodno polje vremena broj 6 opciono ili ne.',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries in milliseconds.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Adrese E-pote',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => 'Omoguava "S/MIME" podrku.',
        'Enables customers to create their own accounts.' => 'Omoguava korisnicima da kreiraju sopstvene naloge.',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => 'Omoguava podrku za proveru pravopisa.',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => 'Pregled eskalacija',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => 'Primer slobodnog teksta',
        'Execute SQL statements.' => 'Izvri SQL naredbe.',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => 'Filtriranje dolaznih poruka.',
        'First Christmas Day' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => '',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => 'Jezik suelja',
        'International Workers\' Day' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => 'Povei zaposlene sa gupama.',
        'Link agents to roles.' => 'Povei zaposlene sa ulogama.',
        'Link attachments to responses templates.' => 'Povei priloge sa ablonima odgovora.',
        'Link customers to groups.' => 'Povei korisnike sa grupama.',
        'Link customers to services.' => 'Povei korisnike s uslugama.',
        'Link queues to auto responses.' => 'Povei repove s automatskim odgovorima.',
        'Link responses to queues.' => 'Povei odgovore s repovima.',
        'Link roles to groups.' => 'Povei uloge sa grupama.',
        'Link this ticket to other objects!' => 'Povei ovu karticu sa drugim objektima!',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => 'Datoteka dnevnika za broja kartice.',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => 'Odreuje prozirnost slike.',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => 'Upravljanje postojeim sesijama.',
        'Manage periodic tasks.' => 'Upravljanje povremenim zadacima.',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => 'Modul za proveru korisnikih dozvola.',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => 'Moji kartice',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New Year\'s Day' => '',
        'New Year\'s Eve' => '',
        'New email ticket' => 'Nova kartica E-pote',
        'New phone ticket' => 'Novi telefonski karticu',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => 'Obavijesti (dogaaji)',
        'Number of displayed tickets' => 'Broj prikazanih kartica',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => 'Pregled eskaliralih kartice',
        'Overview of all open Tickets.' => 'pregled svih otvorenih kartice.',
        'PGP Key Upload' => 'Slanje "PGP" kljua',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => 'Dozvoljena irina prozora za pisanje poruke.',
        'Permitted width for compose note windows.' => 'Dozvoljena irina prozora za pisanje napomene.',
        'PostMaster Filters' => 'PostMaster filtri',
        'PostMaster Mail Accounts' => 'PostMaster rauni E-pote',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => 'Pregled repa',
        'QueueView Refresh Time' => 'vrijeme osvjeavanja pregleda repa',
        'Refresh interval' => 'Interval osvjeavanja',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => 'Zamjenjuje originalnog poiljaoca adresom E-pote trenutnog korisnika pri kreiranju odgovora u prozoru za pisanje odgovora suelja zaposlenika.',
        'Required permissions to change the customer of a ticket in the agent interface.' => 'Potrebne dozvole za promenu korisnika kartice u interfejsu zaposlenog.',
        'Required permissions to use the close ticket screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za zatvaranje kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket bounce screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za odbijanje kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket compose screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za otvaranje kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket forward screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za prosleivanje kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket free text screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora slobodnog teksta kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za spajanje pri uveanom prikazu kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket note screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora za napomene kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => 'Potrebne dozvole za upotrebu prozora vlasnika tuketa pri uveanom prikazu kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => 'Potrebne dozvole za upotrebu prozora ekanja pri uveanom prikazu kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora telefonskog odlaznog kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => 'Potrebne dozvole za upotrebu prozora prioriteta pri uveanom prikazu kartice u interfejsu zaposlenog.',
        'Required permissions to use the ticket responsible screen in the agent interface.' => 'Potrebne dozvole za upotrebu prozora odgovornog za karticu u interfejsu zaposlenog.',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => 'Resetuje i otkljuava vlasnika kartice ako je premeten u drugi red.',
        'Responses <-> Queues' => 'Odgovori <-> Repovi',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => 'Restaurira karticu iz arhive (samo ako je dogaaj promena statusa od zatvorenog na bilo koji dostupan otvoreni status).',
        'Roles <-> Groups' => 'Uloge <-> Grupe',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => 'Slanje "S/MIME" sertifikata',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Second Christmas Day' => '',
        'Select your frontend Theme.' => '',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => 'Poalji obavijesti korisnicima.',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => 'Sistemska adresa poiljaoca.',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => 'Podeava veliinu grafikona statistike.',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => 'Statistike',
        'Status view' => 'Pregled statusa',
        'Stores cookies after the browser has been closed.' => 'uva kolaie nakon zatvaranja pretraivaa.',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => 'Pregled kartice',
        'Tickets' => 'kartice',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => 'Tipovi',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => 'Auriraj o?naku vienih kartice ako su svi pregledani ili je kreiran novi lanak.',
        'Update and extend your system with software packages.' => 'Auriraj i nadogradi sistem softverskim paketima.',
        'Updates the ticket escalation index after a ticket attribute got updated.' => 'Auriraj indeks eskalacije kartice posle auriranja atributa kartice.',
        'Updates the ticket index accelerator.' => 'Auriraj akcelerator indeksa kartice.',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => 'Pregled rezultata provere performansi.',
        'View system log messages.' => 'Pregled poruka sistemskog dnevnika.',
        'Wear this frontend skin' => 'Primeni ovaj isgled interfejsa',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => 'Kada su kartice spojeni, kartici koji nije aktivan e automatski biti dodana beleka. U prostoru za tekst moete da definiete ovaj tekst (Zaposlenici ne mogu mijenjati ovaj tekst).',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => 'Kada su kartice spojeni, korisnik moe biti informiran E-potom postavljanjem polje za potvrdu "Obavijesti poiljaoca". U prostoru za tekst, moete definirati unaprijed formatirani tekst koji kasnije biti modificiran od strane zaposlenika.',
        'Your language' => 'Va jezik',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        '%s Tickets affected! Do you really want to use this job?' => '%s kartice zahvaeno! Da li stvarno elite da pokrenete ovaj posao?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Proverite "MX" zapise upotrebljenih adresa E-pote kreiranjem odgovora. Nemojte koristiti ovu funkciju ako je va OTRS server na "dial-up" liniji!)',
        '(Email of the system admin)' => '(E-pota administratora sustava)',
        '(Full qualified domain name of your system)' => '(Puno kvalifikovano ime domena vaeg sistema)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Napomena: Od vae instalacije zavisi broj dinamikih objekata koje moete koristiti)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifikacija kartice. npr. \'Ticket#\', \'Call#\' ili \'MyTicket#\')',
        '(Used default language)' => '(Zadani jezik korisnika)',
        '(Used ticket number format)' => '(Upotrebljeni format za broj kartice)',
        'A article should have a title!' => 'lanak treba da ima naslov!',
        'A message must be spell checked!' => 'Potrebna provera pravopisa za poruku!',
        'A message should have a To: recipient!' => 'Poruka treba da ima popunjeno Za: primaoc!',
        'A message should have a body!' => 'Poruka treba da sadri neki tekst!',
        'A message should have a customer!' => 'Poruka mora da ima korisnika!',
        'A message should have a subject!' => 'Poruka mora da ima predmet!',
        'A required field is:' => 'Obavezno polje je:',
        'A ticket should be associated with a queue!' => 'Kartica mora biti u nekom repu!',
        'A ticket should have a type!' => 'Kartici mora biti dodeljen tip!',
        'About OTRS' => 'O OTRS-u',
        'Absolut Period' => 'Apsolutni period',
        'Add Customer User' => 'Doadaj korisnika',
        'Add System Address' => 'Dodaj sistemsku adresu',
        'Add User' => 'Dodaj korisnika',
        'Add a new Agent.' => 'Dodaj novog zaposlenog.',
        'Add a new Customer Company.' => 'Dodaj novu korisniku tvrtku.',
        'Add a new Group.' => 'Dodaj novu grupu.',
        'Add a new Notification.' => 'Dodaj novu obavijest.',
        'Add a new Priority.' => 'Dodaj novi prioritet.',
        'Add a new Role.' => 'Dodaj novu ulogu.',
        'Add a new SLA.' => 'Dodaj novi SLA.',
        'Add a new Salutation.' => 'Dodaj nov pozdrav.',
        'Add a new Service.' => 'Dodaj novi servis.',
        'Add a new Signature.' => 'Dodaj novi potpis.',
        'Add a new State.' => 'Dodaj novi status.',
        'Add a new System Address.' => 'Dodaj novu sistemsku adresu.',
        'Add a new Type.' => 'Dodaj novi tip.',
        'Add a new salutation' => 'Dodaj novi pozdrav',
        'Add new attachment' => 'Dodaj novi prilog',
        'Add note to ticket' => 'Dodaj kartici napomenu',
        'Add to list of subscribed tickets' => 'Dodaj na listu pretplate',
        'Added User "%s"' => 'Dodan korisnik "%s".',
        'Adds a suffix with the actual year and month to the otrs log file. A logfile for every month will be created.' => 'Dodaje sufiks s aktualnom godinom i mjesecom u OTRS datoteku dnevnika. Bit e kreiran dnevnik za svaki mjesec.',
        'Admin-Area' => 'Admin prostor',
        'Admin-Password' => 'Administratorska lozinka',
        'Admin-User' => 'Administrator',
        'Admin-password' => 'Administratorska lozinka',
        'Agent Mailbox' => 'Potansko sandue zaposlenih',
        'Agent Preferences' => 'Podeavanja zaposlenog',
        'Agent based' => 'Na osnovu zaposlenog',
        'Agent-Area' => 'Prostor zaposlenih',
        'All Agent variables.' => 'Sve varijable zaposlenih',
        'All Agents' => 'Svi zaposlenici',
        'All Customer variables like defined in config option CustomerUser.' => 'Sve korisnike varijable kao to su definirane u konfiguracijskim opcijama za korisnika.',
        'All customer tickets.' => 'Svi kartice za korisnika.',
        'All email addresses get excluded on replaying on composing an email.' => 'Sve adrese E-pote e biti iskljuene pri kreiranju odgovora.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Sve poruke E-pote s ovim primateljem (Za:) bit e otpremljene u izabrani rep!',
        'All messages' => 'Sve poruke',
        'All new tickets!' => 'Sve novi kartice!',
        'All tickets where the reminder date has reached!' => 'Sve kartice kod kojih je dostignut datum podsjetnika!',
        'All tickets which are escalated!' => 'Sve eskalirane kartice!',
        'Allocate CustomerUser to service' => 'Rasporedi korisnika na uslugu',
        'Allocate services to CustomerUser' => 'Dodijeli usluge korisniku',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attribrutes for SLAs (if ticket service/SLA feature is enabled).' => 'Dozvoljava definiranje servisa i SLA za kartice (npr E-pota, radna povrina, mrea, ...), i eskalacijske atribute za SLA (ako je aktivirana usluga/SLA za karticu).',
        'Answer' => 'Odgovor',
        'Article Create Times' => 'Vremena kreiranja lanka',
        'Article created' => 'Kreiran lanak',
        'Article created between' => 'lanak kreiran izmeu',
        'Article filter settings' => 'Postavke filtra za lanke',
        'Attach' => 'Dodaj privitak',
        'Attribute' => 'Atribut',
        'Auto Response From' => 'Automatski odgovor od',
        'Bounce ticket' => 'Preusmjeri karticu',
        'CSV' => 'CSV',
        'Can not create link with %s!' => 'Ne moe se napraviti veza sa %s!',
        'Can not delete link with %s!' => 'Veza sa %s se ne moe obrisati!',
        'Can\'t update password, must be at least %s characters!' => 'Lozinka se ne moe aurirati, mora biti duga najmanje %s znakova.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Lozinka se ne moe aurirati. Mora da sadri najmanje dva mala i dva velika slova.',
        'Can\'t update password, needs at least 1 digit!' => 'Lozinka se ne moe aurirati, neophodno je da sadri bar jednu cifru!',
        'Can\'t update password, needs at least 2 characters!' => 'Lozinka se ne moe aurirati. Nedostaju najmanje dva znaka!',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Lozinka se ne moe aurirati, nova lozinka se ne podudara! Molimo pokuajte ponovo!',
        'Category Tree' => 'Stablo kategorija',
        'Change %s settings' => 'Promeni %s podeavanja',
        'Change Time' => 'Promeni vreme',
        'Change Times' => 'Promeni vremena',
        'Change free text of ticket' => 'Promeni slobodan tekst za karticu',
        'Change owner of ticket' => 'Promeni vlasnika kartice',
        'Change priority of ticket' => 'Promeni prioritet kartice',
        'Change responsible of ticket' => 'Promeni odgovornog za karticu',
        'Change user <-> group settings' => 'Promena korisnika <-> Podeavanje grupe',
        'ChangeLog' => 'Dnevnik promena',
        'Check Mail Configuration' => 'Provjeri konfiguraciju E-pote',
        'Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behind a dial-up line!' => 'Proverite "MX" zapise upotrebljenih adresa E-pote kreiranjem odgovora. Nemojte koristiti ovu funkciju ako je va OTRS server na "dial-up" liniji.',
        'Child-Object' => 'Deca objekti',
        'City{CustomerUser}' => 'Mesto (korisnik)',
        'Classification' => 'Klasifikacija',
        'Clear From' => 'Od: obrii',
        'Clear To' => 'Obrii Za:',
        'Click here to report a bug!' => 'Kliknite ovde za prijavu greke!',
        'Close Times' => 'Vremena zatvaranja',
        'Close ticket' => 'Zatvori karticu',
        'Close type' => 'Tip zatvaranja',
        'Close!' => 'Zatvori!',
        'Comment (internal)' => 'Komentar (interno)',
        'Comment{CustomerUser}' => 'Komentar',
        'CompanyTickets' => 'kartice tvrtke',
        'Compose Answer' => 'Napii odgovor',
        'Compose Email' => 'Napii poruku E-pote',
        'Compose Follow up' => 'Napravi nastavak',
        'Config Options' => 'Konfiguracione opcije',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Konfiguracione opcije (npr. <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Konfiguracione opcije (npr. <OTRS_CONFIG_HttpType).',
        'Contact customer' => 'Kotaktirajte korisnika',
        'Country{CustomerUser}' => 'Drava (korisnik)',
        'Create New Template' => 'Napravi novi ablon',
        'Create Times' => 'Vremena otvaranja',
        'Create new Phone Ticket' => 'Otvori novi telefonski karticu',
        'Create new database' => 'Kreirajte novu bazu podataka',
        'Create your first Ticket' => 'Otvorite svoju prvu karticu',
        'Create/Expires' => 'Kreiran/Istie',
        'CreateTicket' => 'Otvaranje kartice',
        'Current Impact Rating' => 'Ocjena trenutnog utjecaja',
        'Customer Move Notify' => 'Obavijesti o premjetaju korisnika',
        'Customer User' => 'Korisnik',
        'Customer User Management' => 'Upravljanje korisnicima',
        'Customer Users' => 'Korisnici',
        'Customer Users <-> Groups' => 'Korisnici <-> Grupe',
        'Customer Users <-> Groups Management' => 'Korisnici <-> Upravljanje grupama',
        'Customer Users <-> Services' => 'Korisnici <-> Usluge',
        'Customer Users <-> Services Management' => 'Korisnici <-> Upravljanje servisima',
        'Customer history' => 'Istorijat korisnika',
        'Customer history search' => 'Pretraivanje istorijata za korisnika',
        'Customer history search (e. g. "ID342425").' => 'Pretraga istorijata korisnika (npr. "ID342425").',
        'CustomerID{CustomerUser}' => 'ID korisnika.',
        'CustomerUser' => 'Korisnik',
        'D' => 'D',
        'DB Admin Password' => 'Lozinka DB administratora',
        'DB Admin User' => 'DB adminstrator',
        'DB connect host' => 'Ime ili adresa DB servera',
        'Default' => 'Zadano',
        'Default Charset' => 'Zadana kodna stranica',
        'Default Language' => 'Zadani jezik',
        'Default skin for otrs 3.0 interface.' => 'Zadani izgled OTRS 3.0 suelja.',
        'Delay time between autocomplete queries.' => 'Vreme zadravanja izmeu samokompletirajuih upita.',
        'Delete old database' => 'Obrii staru bazu podataka',
        'Detail' => 'Detalji',
        'Diff' => 'Razlike',
        'Discard all changes and return to the compose screen' => 'Odustanite od svih promena i vratite se na prozor za pisanje.',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Otpemi il filtriraj dolazne porukena osnovu "X-Headers"! "RegExp" je takoe mogu.',
        'Do you really want to delete this Object?' => 'Da li stvarno elite da obriete ovaj objekt?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Da li stvarno elite da reinstalirate ovaj paket (sve rune promene e biti izgubljene)?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ne zaboravite da dodate novog korisnika u grupe i uloge!',
        'Don\'t forget to add a new user to groups!' => 'Ne zaboravite da dodate novog korisnika nekoj grupi!',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Molimo da ne koristite "UserID 1" (raun sustava) za rad! Kreirajte korisnike raune!',
        'Download Settings' => 'Preuzmite podeavanja',
        'Drop Database' => 'Obrii bazu podataka',
        'Dynamic-Object' => 'Dinamiki objekat',
        'Edit Customers' => 'Uredi korisnike',
        'Edit default services.' => 'Uredi podrazumevane servise.',
        'Email based' => 'Na osnovi E-pote',
        'Email of the system admin.' => 'Adresa E-pote administratora sistema.',
        'Email{CustomerUser}' => 'Korisnik (E-pota)',
        'Escalation - First Response Time' => 'Eskalacija - Vreme reakcije',
        'Escalation - Solution Time' => 'Eskalacija - Vrijeme reavanja',
        'Escalation - Update Time' => 'Eskalacija - Vrijeme auriranja',
        'Escalation Times' => 'Vremena eskalacije',
        'Escalation time' => 'Vrijeme eskalacije',
        'Event is required!' => 'Dogaaj je obavezan!',
        'Explanation' => 'Objanjenje',
        'Export Config' => 'Izvoz konfiguracije',
        'FAQ Search Result' => 'Rezultat pretrage PP',
        'FAQ System History' => 'Dnevnik PP sustava',
        'Fax{CustomerUser}' => 'Korisnik (Faks)',
        'File-Name' => 'Naziv datoteke',
        'File-Path' => 'Staza datoteke',
        'Filelist' => 'Lista datoteka',
        'Filter for Language' => 'Filtar za jezik',
        'Filtername' => 'Naziv filtra',
        'Firstname{CustomerUser}' => 'Ime (korisnik)',
        'Follow up' => 'Nastavak',
        'For very complex stats it is possible to include a hardcoded file.' => 'Za veoma sloene statistike mogue je pridruiti namenski programiranu datoteku.',
        'Foward ticket: ' => 'Proslijedi karticu',
        'Frontend' => 'Suelje',
        'Full qualified domain name of your system.' => 'Puno kvalificirani domenski naziv vaeg sustava npr "otrs-server.example.org"',
        'Go' => 'Idi',
        'Go to group %s' => 'Idi na grupu %s',
        'Group %s' => 'Grupa %s',
        'Group Ro' => 'Grupa "ro"',
        'Group based' => 'Na osnovu grupe',
        'Group selection' => 'Izbor grupe',
        'Hash/Fingerprint' => '"Hash"/Saetak',
        'Have a lot of fun!' => 'Uivajte!',
        'Have you lost your password?' => 'Da li ste izgubili vau lozinku?',
        'Help' => 'Pomo',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ovde moete podesiti X osu. Moete izabrati jedan element od ponuenih opcija. Ukoliko nita ne izaberete, svi elementi e biti upotrtebljeni ako pravite statistiku. Takoe, novi atribut je dodan nakon poslednje konfiguracije.',
        'Here you can insert a description of the stat.' => 'Ovde moete uneti opis statistike.',
        'Here you can select the dynamic object you want to use.' => 'Ovde moete izabrati dinamike objekte koje elite da koristite.',
        'Home' => 'Poetna',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Ako je nova programirana datoteka dostupna, ovaj atribut e biti prikazan i moi ete da izaberete jedan.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ako je karticu zatvoren, a korisnik poalje nastavak, karticu e biti zakljuan za starog vlasnika.',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ako nee biti odgovoreno na karticu u ovom vremenu, onda e samo ovaj karticu biti prikazan.',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ako zaposlenik zakljua karticu i ne odgovori za ovo vrijeme, kartica e automatski biti otkljuana. Ta kartica je onda vidljiva svim drugim zaposlenicima.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Ako nita nije izabrano, onda nema ni dozvola u ovoj grupi (kartice nee biti dostupni za korisnika).',
        'If you need the sum of every column select yes.' => 'Ukoliko vam je potrebna suma svake kolone, izaberite "Da".',
        'If you need the sum of every row select yes' => 'Ako vam je potrebna suma svakog reda, izaberite "Da".',
        'Image' => 'Slika',
        'Important' => 'Vano',
        'Imported' => 'Uvezeno',
        'Imported by' => 'Uvezao',
        'In order to experience OTRS, you\'ll need to enable Javascript in your browser.' => 'Kako bi ste maksimalno iskoristili sve mogunosti OTRS sistema, potrebno je da aktivrate Java skript u vaem Web itau.',
        'In this form you can select the basic specifications.' => 'Ovo je mesto za izbor optih podataka.',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Na ovaj nain moete neposredno urediti kljueve podeene u datoteci "Kernel/Config.pm".',
        'Inbound Mail Password' => 'Lozinka dolazne pote',
        'Inbound Mail Type' => 'Tip dolazne pote',
        'Inbound Mail User' => 'Primalac pote',
        'Inbound Mail host' => 'raunar domain dolazne pote',
        'Information about the Stat' => 'Informacije o statistici',
        'Insert of the common specifications' => 'Unos optih podataka',
        'Instance' => 'Instanca',
        'Is Job Valid' => 'Da li je posao vaei',
        'Is Job Valid?' => 'Da li je posao vaei?',
        'It\'s useful for ASP solutions.' => 'Korisno za "ASP" reenja.',
        'Job-List' => 'Lista poslova',
        'Keyword' => 'Kljuna re',
        'Keywords' => 'Kljune rei',
        'Kill session' => 'Prekini sesiju',
        'Last update' => 'Poslednje auriranje',
        'Lastname{CustomerUser}' => 'Prezime (korisnik)',
        'Link Table' => 'Tabela veza',
        'Link to Parent' => 'Povei sa roditeljem',
        'LinkType' => 'Tip veze',
        'Linked as' => 'Povezano kao',
        'Load' => 'Uitaj',
        'Load Settings' => 'Uitaj podeavanja',
        'Loading' => 'Uitavam...',
        'Logfile' => 'Dnevnik',
        'Logfile just needed for File-LogModule!' => 'Datoteka dnevnika je neophodna za Modul dnevnika.',
        'Logfile too large, you need to reset it!' => 'Datoteka dnevnika je prevelika, treba da je resetujete!',
        'Login failed! Your username or password was entered incorrectly.' => 'Neuspjena prijava! Vae korisniko ime i/ili lozinka su netono unijeti.',
        'Lookup' => 'Pronalaenje',
        'Mail Management' => 'Upravljanje potom',
        'Mailbox' => 'Potansko sandue',
        'Match' => 'Poklapanje',
        'Max. displayed tickets' => 'Maksimalni broj prikazanih kartica',
        'Max. shown Tickets a page' => 'Maksimalni broj kartice po strani',
        'Message for new Owner' => 'Poruka za novog vlasnika',
        'Message sent to' => 'Poruka poslata za',
        'Misc' => 'Ostalo',
        'Mobile{CustomerUser}' => 'Mobilni (korisnik)',
        'Modified' => 'Mijenjano',
        'Modules' => 'Moduli',
        'Move notification' => 'Premetanje obavetenja',
        'Multiple selection of the output format.' => 'Viestruki izbor izlaznog formata.',
        'My Queue' => 'Moj red',
        'MyTickets' => 'Moji kartice',
        'Name is required!' => 'Ime je obavezno!',
        'Need a valid email address or don\'t use a local address!' => 'Neophodna je ispravna adresa E-pote ili nemojte koristiti lokalnu adresu!',
        'New Agent' => 'Novi zaposlenik',
        'New Customer' => 'Novi korisnik',
        'New Group' => 'Nova grupa',
        'New Group Ro' => 'Nova grupa "Ro"',
        'New Password' => 'Nova lozinka',
        'New Priority' => 'Nov prioritet',
        'New SLA' => 'Novi "SLA"',
        'New Service' => 'Novi servis',
        'New State' => 'Novi status',
        'New Ticket Lock' => 'Zakljuavanje novih kartice',
        'New Title' => 'Novi naslov',
        'New Type' => 'Novi tip',
        'New account created. Sent Login-Account to %s.' => 'Napravljen novi nalog. Podaci za prijavu poslati %s.',
        'New messages' => 'Nove poruke',
        'New password again' => 'Nova lozinka (ponovo)',
        'No * possible!' => 'Nije "*" mogue!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'U mrenom spremitu nema paketa za traeni sistem, tu su samo paketi za druge verzije.',
        'No Permission' => 'Nema dozvole',
        'No change time settings.' => 'Nema promene vremena',
        'No matches found' => 'Nita nije pronaeno',
        'No time settings.' => 'Nema podeavanja vremena.',
        'Node-Name' => 'Naziv vora',
        'Note' => 'Napomena',
        'Note Text' => 'Tekst napomene',
        'Notification (Customer)' => 'Obavetenje (korisnik)',
        'Notifications' => 'Obavetenja',
        'OTRS DB Password' => 'OTRS BP Lozinka',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS alje obavetenje korisniku ako je karticu premeten.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS alje obavijest korisniku ako je promijenjen vlasnik kartice.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS alje E-potu sa obavetenjem korisniku ukoliko se promijeni status kartice.',
        'Object already linked as %s.' => 'Objekt je ve povezan kao %s.',
        'Of couse this feature will take some system performance it self!' => 'Kada je ova funkcija aktivna, zauzee deo sistemskih performansi.',
        'One or more errors occured!' => 'Dogodila se jedna ili vie pogreaka!',
        'Only for ArticleCreate Event.' => 'Samo za dogaaj kreiranja lanka.',
        'Open Tickets' => 'Otvoreni kartice',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcije za podatke aktuelnog korisnika (npr. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Opcije podataka za aktuelnog korisnika (npr. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Podeavanja za korisnika koji je zahtevao ovu akciju (npr. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Informacije o aktuelnom korisniku koji je traio ovu akciju (npr. <OTRS_CURRENT_UserFirstname>)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Opcije pdataka o kartici (npr. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcije podataka o kartici (npr. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Opcije podataka o kartici (npr. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Order' => 'Sortiranje',
        'Other Options' => 'Druge opcije',
        'Out Of Office' => 'Van kancelarije',
        'Outbound Mail Type' => 'Tip odlazne pote',
        'POP3 Account Management' => 'Upravljanje "POP3" nalozima',
        'Package' => 'Paket',
        'Param 1' => 'Param 1',
        'Param 2' => 'Param 2',
        'Param 3' => 'Param 3',
        'Param 4' => 'Param 4',
        'Param 5' => 'Param 5',
        'Param 6' => 'Param 6',
        'Parent-Object' => 'Objekat roditelj',
        'Password for Inbound Mail' => 'Lozinka za dolaznu potu',
        'Password for SMTP Auth' => 'Lozinka za "SMTP" autentikaciju',
        'Password is already used! Please use an other password!' => 'Ova lozinka je ve u upotrebi, molimo odaberite neku drugu!!',
        'Passwords doesn\'t match! Please try it again!' => 'Lozinke se ne poklapaju! Molimo pokuajte ponovo!',
        'Pending Times' => 'Vremena ekanja',
        'Pending messages' => 'Poruke na ekanju',
        'Pending type' => 'Tip ekanja',
        'Permissions to change the ticket owner in this group/queue.' => 'Pravo na promenu vlasnika kartice u ovoj grupi/repu.',
        'PhoneView' => 'Pregled telefona',
        'Phone{CustomerUser}' => 'Telefon (korisnik)',
        'Please command us.' => 'Molimo zadajte nam zadatak.',
        'Please contact your admin' => 'Molimo kontaktirajte vaeg administratora',
        'Please enter subject.' => 'Molimo unesite predmet poruke.',
        'Prio' => 'Prioritet',
        'Process-Path' => 'Proces-staza',
        'Product' => 'Proizvod',
        'Queue <-> Auto Responses Management' => 'Rep <-> Upravljanje automatskim odgovorima',
        'Queue Management' => 'Upravljanje repovima',
        'Queue is required.' => 'Rep je obavezan.',
        'Queues <-> Auto Responses' => 'Repovi <-> Automatski odgovori',
        'Realname' => 'Pravo ime',
        'Rebuild' => 'Ponovno izgradi',
        'Recipients' => 'Primaoci',
        'Refresh' => 'Osvjei',
        'Reminder' => 'Podsjetnik',
        'Reminder messages' => 'Poruke podsjetnika',
        'Remove from list of subscribed tickets' => 'Ukloni sa liste pretplate',
        'Reporter' => 'Izvjestitelj',
        'Required Field' => 'Obavezno polje',
        'Required!' => 'Obavezno!',
        'Response Management' => 'Upravljanje odgovorima',
        'Responses <-> Attachments Management' => 'Odgovori <-> Upravljanje prilozima',
        'Responses <-> Queue Management' => 'Odgovori <-> Upravljanje repovima',
        'Role' => 'Uloga',
        'Roles <-> Agents' => 'Rollen <-> Agenten',
        'Roles <-> Groups Management' => 'Uloge <-> Upravljanje grupama',
        'Roles <-> Users' => 'Uloge <-> Korisnici',
        'Roles <-> Users Management' => 'Uloge <-> Upravljanje korisnicima',
        'SMTP Auth Password' => '"SMTP" Lozinka',
        'Save Job as?' => 'Sauvaj posao kao?',
        'Save Search-Profile as Template?' => 'Sauvaj profil pretrage kao ablon?',
        'Schedule' => 'Raspored',
        'Search Result' => 'Rezultat pretrage',
        'Search Ticket' => 'Pretraivanje kartice',
        'Search for' => 'Potraga za',
        'Search for customers (wildcards are allowed).' => 'Nai korisnika (doker znaci su dozvoljeni).',
        'Secure Mode need to be enabled!' => 'Potrebno je aktivirati siguran mod!',
        'Select Box' => 'Okvir za izbor',
        'Select Box Result' => 'Select Box Ergebnis',
        'Select Source (for add)' => 'Izaberi izvor (za dodavanje)',
        'Select inbound mail type' => 'Izaberi tip dolazne pote',
        'Select outbound mail type' => 'Izaberi tip odlazne pote',
        'Select the customeruser:service relations.' => 'Izaberite Korisnik:servis veze.',
        'Select the element, which will be used at the X-axis' => 'Izaberi element koji e biti upotrebljen na X-osi.',
        'Select the restrictions to characterise the stat' => 'Izaberite ogranienja koja karakteriu statistiku',
        'Select the role:user relations.' => 'Izaberite ulogu:korisnike veze.',
        'Select the user:group permissions.' => 'Izaberite korisnika:grupne dozvole.',
        'Select your QueueView refresh time.' => 'Odaberite vrijeme osvjeavanja pregleda repa.',
        'Select your default spelling dictionary.' => 'Odaberite zadani renik za proveru pravopisa.',
        'Select your frontend Charset.' => 'Izaberite karakterset vaeg interfejsa.',
        'Select your frontend QueueView.' => 'Izaberite pregled repa.',
        'Select your frontend language.' => 'Izaberite jezik suelja.',
        'Select your out of office time.' => 'Odaberite vae vanuredovno vrijeme.',
        'Select your screen after creating a new ticket.' => 'Izaberite prozor koji se prikazuje nakon otvaranja nove kartice.',
        'Selection needed' => 'Neophodan izbor',
        'Send Administrative Message to Agents' => 'Poalji administrativnu poruku zaposlenicima.',
        'Send Notification' => 'Poalji obavetenje',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Obavijesti me ukoliko korisnik poalje nastavak, a ja sam vlasnik ove kartice.',
        'Sent new password to: ' => 'Poalji novu lozinku za: ',
        'Sent new password to: %s' => 'Poslata nova lozinka za %s.',
        'Sent password reset instructions to %s. Please check your email.' => 'Uputa za reset lozinke poslana za %s. Molimo provjerite vau E-potu.',
        'Sent password token to: %s' => 'Poslana lozinka za: %s.',
        'Service-Name' => 'Naziv servisa',
        'Sessions' => 'Sesije',
        'Set customer user and customer id of a ticket' => 'Podesi korisnika i korisniki ID za karticu',
        'Show' => 'Prikai',
        'Site' => 'Stranica',
        'Solution' => 'Rjeenje',
        'Some result formats are disabled because at least one needed package is not installed. Please contact your administrator.' => 'Neki su formati rezultata onemogueni jer neki od paketa nije instaliran. Molimo kontaktirajte vaeg administratora.',
        'Sort by' => 'Sortirano po',
        'Source' => 'Izvor',
        'Spell Check' => 'Provjera pravopisa',
        'Split' => 'Razdijeli',
        'State Type' => 'Tip stanja',
        'Static-File' => 'Statina datoteka',
        'Stats-Area' => 'Prostor statistike',
        'Step %s of %s' => 'Korak %s od %s',
        'Street{CustomerUser}' => 'Ulica (korisnik)',
        'Sub-Queue of' => 'Sub-red od',
        'Sub-Service of' => 'Subservis od',
        'Subscribe' => 'Pretplati se',
        'System State Management' => 'Upravljanje statusom sistema',
        'System Status' => 'Status sistema',
        'Systemaddress' => 'Sistemska adresa',
        'Text is required!' => 'Tekst je obavezan',
        'The Ticket was locked' => 'Kartica je zakljuana',
        'The customer id is required!' => 'ID korisnika je obavezan!',
        'The customer is required!' => 'Korisnik je obavezan!',
        'The customer is required.' => 'Korisnik je obavezan.',
        'The field is required.' => 'Polje je obavezno.',
        'The identify of the system. Each ticket number and each http session id starts with this number.' => 'Identitet sistema. Svaki broj kartice i svaki ID "HTTP" sesije poinje sa ovim brojem.',
        'The message being composed has been closed.  Exiting.' => 'Poruka koja se pie je zatvorena.',
        'The subject is required!' => 'Predmet je obavezan!',
        'The subject is required.' => 'Predmet je obavezan.',
        'The text is required!' => 'Tekst je obavezan!',
        'The text is required.' => 'Tekst je obavezan.',
        'These values are read-only.' => 'Ove vrednosti su samo za itanje.',
        'These values are required.' => 'Ove vrednosti su obavezne.',
        'This account exists.' => 'Ovaj nalog postoji.',
        'This email address already exists. Please log in or reset your password..' => 'Ova adresa E-pote ve postoji. Molimo, prijavite se ili resetujte vau lozinku',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ovo je korisno ukoliko ne elite da iko vidi rezultate statistike ili konfiguracija statistike nije zavrena.',
        'Ticket Lock' => 'Zakljuan karticu',
        'Ticket Number Generator' => 'Generator broja kartice',
        'Ticket Search' => 'Pretraga kartice',
        'Ticket Status View' => 'Pregled statusa kartice',
        'Ticket Type is required!' => 'Tip kartice je obavezan!',
        'Ticket changed' => 'Kartica mijenjana',
        'Ticket changed between' => 'Kartica mijenjana izmeu',
        'Ticket escalation!' => 'Eskalacija kartice!',
        'Ticket locked!' => 'Zakljuan karticu!',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opcije vlasnika kartice (npr. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Detalji o opcijama vlasnika (z. B. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Opcije o odgovornosti za karticu (z. B.<OTRS_RESPONSIBLE_UserFirstname>).',
        'Ticket selected for bulk action!' => 'karticu izabran za masovnu akciju',
        'Ticket type is required.' => 'Tip kartice je obavezan.',
        'Ticket unlock!' => 'Otkljuavanje kartice!',
        'Ticket#' => 'karticu Br.',
        'Ticket-Area' => 'Prostor kartice',
        'TicketFreeText' => 'TicketFreeText',
        'TicketZoom' => 'Sadraj kartice',
        'Tickets shown' => 'Prikazani kartice',
        'Tickets which need to be answered!' => 'kartice na koje treba odgovoriti!',
        'Time units is a required field!' => 'Vremenske jedinice su obavezno polje.',
        'Time units is a required field.' => 'Vremenske jedinice su obavezno polje.',
        'Time units is required field.' => 'Vremenske jedinice su obavezno polje.',
        'Times' => 'Vremena',
        'Title is required.' => 'Naslov je obavezan.',
        'Title of the stat.' => 'Naslov statistike.',
        'Title{CustomerUser}' => 'Titula (korisnik)',
        'Title{user}' => 'Titula',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Da bi videli atribute lanka (npr. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> und <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Die Artikel Attribute (z. B. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).',
        'To get the first 5 lines of the body (poslednjeg lanka zaposlenog).' => 'Da vidite prvih 5 linija poruke (poslednjeg lanka zaposlenog).',
        'Top of Page' => 'Vrh strane',
        'Total hits' => 'Ukupno pogodaka',
        'U' => 'U',
        'Unable to parse Online Repository index document!' => 'Nije mogue ralaniti indeks mrenog skladita!',
        'Unlock Tickets' => 'Otkljuaj karticu',
        'Unsubscribe' => 'Otkai pretplatu',
        'Use utf-8 it your database supports it!' => 'Koristite "utf-8" samo ako ga vaa baza podataka podrava!',
        'Useable options' => 'Upotrebljive opcije',
        'Used default language.' => 'Upotrebljeni zadani jezik.',
        'Used log backend.' => 'Upotrebljena metoda beleenja dnevnika.',
        'User Management' => 'Upravljanje korisnicima',
        'User for Inbound Mail' => 'Korisnik za prijem pote',
        'User will be needed to handle tickets.' => 'Neophodan je zaposlenik za obradu kartice.',
        'User-Name' => 'Korisniko ime',
        'User-Number' => 'Korisnik broj',
        'Username for SMTP Auth' => 'Korisniko ime za "SMTP" autentikaciju',
        'Username{CustomerUser}' => 'Korisniko ime (korisnik)',
        'Users' => 'Korisnici',
        'Users <-> Groups' => 'Korisnici <-> Grupe',
        'Users <-> Groups Management' => 'Korisnici <-> Upravljanje grupama',
        'Verify New Password' => 'Potvrdi novu lozinku',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Panja! Ovi kartice e biti uklonjeni iz baze i trajno izgubljeni!',
        'Watch notification' => 'Praenje obavetenja',
        'We stop eating if you wish us to do.' => 'Prestajemo i s naim objedom ukoliko to elite.',
        'Web-Installer' => 'Web-Instalacija',
        'Welcome to OTRS' => 'Dobrodoli u OTRS',
        'Wildcards are allowed.' => 'Doker znakovi su dozvoljeni.',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Unosom i izborom polja moete konfigurirati statistiku prema vaim potrebama. Koje elemente statistike moete mijenjati ovisi o konfiguraciji statistike.',
        'Workflow Groups' => 'Grupe pravilnika rada',
        'Yes, save it with name' => 'Da, sauvaj sa imenom',
        'You as the customer have the ability to let us support staff people jump around as you wish because it\'s all about you. We stop eating if you wish us to do. Your way to communicate with us is this thing called \'ticket\'. Please command us.' => 'Bi kao korisnik imate privilegiju da budete u centru panje osoblja tehnike podrke. Uiniemo sve kako bi Vi bili zadovoljni. Nain da efikasno komunicirate s nama je ova stvar koja se zove "kartica". Molimo vas, prenesite nam Va problem.',
        'You got new message!' => 'Primili ste novu poruku!',
        'You have not created a ticket yet.' => 'Jo uvijek niste otvorili karticu.',
        'You need a to: recipient!.' => 'Primtelj, polje "Za:" je obavezno!',
        'You need to account time!' => 'Potrebno je da obraunti vrijeme!',
        'You need to activate %s first to use it!' => 'Morate aktivirati %s prije upotrebe!',
        'Your Password' => 'Vaa lozinka',
        'Your email address is new' => 'Vaa adresa E-pote je nova',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Vaa E-pota sa karticom broj "<OTRS_TICKET>" je preusmjerena za "<OTRS_BOUNCE_TO>". Tamo ete pronai dodatne informacije.',
        'Your own Ticket' => 'Va karticu',
        'Your way to communicate with us is this thing called \'ticket\'.' => 'Va nain komuniciranja s nama je ova stvar zvana "kartica".',
        'Zip{CustomerUser}' => 'PB (korisnik)',
        'customer realname' => 'pravo ime korisnika',
        'delete' => 'obrii',
        'delete links' => 'Obrii veze',
        'down' => 'dole',
        'false' => 'false',
        'for agent firstname' => 'za ime zaposlenog',
        'for agent lastname' => 'za prezime zaposlenog',
        'for agent login' => 'za prijavu zaposlenih',
        'for agent user id' => 'za korisniki ID zaposlenog',
        'go back' => 'nazad',
        'kill all sessions' => 'Zatvori sve sesije',
        'modified' => 'mijenjano',
        'new ticket' => 'Novi karticu',
        'next step' => 'naredni korak',
        'not rated' => 'nije ocijenjeno',
        'not verified' => 'nije provjereno',
        'read' => 'itaj',
        'send' => 'Poalji',
        'sort downward' => 'sortiraj padajue',
        'sort upward' => 'sortiraj rastue',
        'tmp_lock' => 'zakljuavanje (privremeno)',
        'to get the first 20 character of the subject' => 'vidjeti prvih 20 slova predmeta',
        'to get the first 5 lines of the email' => 'vidjeti prvih 5 linija poruke',
        'to get the realname of the sender (if given)' => 'vidjeti pravo ime poiljaoca (ako je mogue)',
        'unknown' => 'nepoznato',
        'unread' => 'neproitano',
        'up' => 'ukljueno',
        'utf8' => '"utf8"',
        'verified' => 'provjereno',
        'x' => 'x',

    };
    # $$STOP$$
    return;
}

1;
