# --
# Kernel/Language/fr.pm - provides French language translation
# Copyright (C) 2002 Bernard Choppy <choppy at imaginet.fr>
# Copyright (C) 2002 Nicolas Goralski <ngoralski at oceanet-technology.com>
# Copyright (C) 2004 Igor Genibel <igor.genibel at eds-opensource.com>
# Copyright (C) 2007 Remi Seguy <remi.seguy at laposte.net>
# Copyright (C) 2007 Massimiliano Franco <max-lists at ycom.ch>
# Copyright (C) 2004-2008 Yann Richard <ze at nbox.org>
# Copyright (C) 2009-2010 Olivier Sallou <olivier.sallou at irisa.fr>
# --
# $Id: fr.pm,v 1.142.2.5 2012/03/09 07:37:05 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::fr;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.142.2.5 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2012-03-09 08:31:52

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D.%M.%Y %T';
    $Self->{DateFormatLong}      = '%A %D %B %T %Y';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Oui',
        'No' => 'Non',
        'yes' => 'oui',
        'no' => 'non',
        'Off' => 'Dsactiv',
        'off' => 'dsactiv',
        'On' => 'Activ',
        'on' => 'activ',
        'top' => 'haut',
        'end' => 'fin',
        'Done' => 'Fait',
        'Cancel' => 'Annuler',
        'Reset' => 'Remise  zro',
        'last' => 'dernier',
        'before' => 'avant',
        'Today' => 'Aujourd\'hui',
        'Tomorrow' => 'Demain',
        'Next Week' => 'La semaine prochaine',
        'day' => 'jour',
        'days' => 'jours',
        'day(s)' => 'jour(s)',
        'd' => 'j',
        'hour' => 'heure',
        'hours' => 'heures',
        'hour(s)' => 'heure(s)',
        'Hours' => 'Heures',
        'h' => '',
        'minute' => 'minute',
        'minutes' => 'minutes',
        'minute(s)' => 'minute(s)',
        'Minutes' => '',
        'm' => '',
        'month' => 'mois',
        'months' => 'mois',
        'month(s)' => 'mois',
        'week' => 'semaine',
        'week(s)' => 'semaine(s)',
        'year' => 'anne',
        'years' => 'annes',
        'year(s)' => 'anne(s)',
        'second(s)' => 'seconde(s)',
        'seconds' => 'secondes',
        'second' => 'seconde',
        's' => '',
        'wrote' => 'a crit',
        'Message' => 'Message',
        'Error' => 'Erreur',
        'Bug Report' => 'Rapport d\'anomalie',
        'Attention' => 'Attention',
        'Warning' => 'Attention',
        'Module' => 'Module',
        'Modulefile' => 'Fichier de module',
        'Subfunction' => 'sous-fonction',
        'Line' => 'Ligne',
        'Setting' => 'Paramtre',
        'Settings' => 'Paramtres',
        'Example' => 'Exemple',
        'Examples' => 'Exemples',
        'valid' => 'valide',
        'invalid' => 'invalide',
        '* invalid' => '* invalide',
        'invalid-temporarily' => 'temporairement invalide',
        ' 2 minutes' => ' 2 minutes',
        ' 5 minutes' => ' 5 minutes',
        ' 7 minutes' => ' 7 minutes',
        '10 minutes' => '10 minutes',
        '15 minutes' => '15 minutes',
        'Mr.' => 'M.',
        'Mrs.' => 'Mme',
        'Next' => 'Suivant',
        'Back' => 'Retour',
        'Next...' => 'Suivant...',
        '...Back' => '...Retour',
        '-none-' => '-aucun-',
        'none' => 'aucun',
        'none!' => 'aucun !',
        'none - answered' => 'aucun - rponse faite',
        'please do not edit!' => 'Ne pas modifier !',
        'Need Action' => 'Requiert une action',
        'AddLink' => 'Ajouter un lien',
        'Link' => 'Lier',
        'Unlink' => 'Dlier',
        'Linked' => 'Li',
        'Link (Normal)' => 'Lien (Normal)',
        'Link (Parent)' => 'Lien (Parent)',
        'Link (Child)' => 'Lien (Enfant)',
        'Normal' => 'Normal',
        'Parent' => 'Parent',
        'Child' => 'Enfant',
        'Hit' => 'Occurence',
        'Hits' => 'Occurences',
        'Text' => 'Texte',
        'Standard' => 'Standard',
        'Lite' => 'Allge',
        'User' => 'Utilisateur',
        'Username' => 'Nom d\'utilisateur',
        'Language' => 'Langue',
        'Languages' => 'Langues',
        'Password' => 'Mot de Passe',
        'Preferences' => 'Prfrences',
        'Salutation' => 'En-tte',
        'Salutations' => 'En-ttes',
        'Signature' => 'Signature',
        'Signatures' => 'Signatures',
        'Customer' => 'Client',
        'CustomerID' => 'Numro de client',
        'CustomerIDs' => 'Numro de client (Groupe)',
        'customer' => 'client',
        'agent' => 'oprateur',
        'system' => 'systme',
        'Customer Info' => 'Information client',
        'Customer Information' => 'Information client',
        'Customer Company' => 'Entreprise du client',
        'Customer Companies' => 'Entreprises clientes',
        'Company' => 'Entreprise',
        'go!' => 'c\'est parti !',
        'go' => 'aller',
        'All' => 'Tout',
        'all' => 'tout',
        'Sorry' => 'Dsol',
        'update!' => 'mettre  jour !',
        'update' => 'mettre  jour',
        'Update' => 'Mettre  jour',
        'Updated!' => 'Mis(e)  jour !',
        'submit!' => 'soumettre !',
        'submit' => 'soumettre',
        'Submit' => 'Soumettre',
        'change!' => 'modifier !',
        'Change' => 'Modifier',
        'change' => 'modifier',
        'click here' => 'Cliquer ici',
        'Comment' => 'Commentaire',
        'Valid' => 'Valide',
        'Invalid Option!' => 'Option invalide !',
        'Invalid time!' => 'Heure/Dure invalide !',
        'Invalid date!' => 'Date invalide !',
        'Name' => 'Nom',
        'Group' => 'Groupe',
        'Description' => 'Description',
        'description' => 'description',
        'Theme' => 'Thme',
        'Created' => 'Cr',
        'Created by' => 'Cr par',
        'Changed' => 'Chang',
        'Changed by' => 'Chang par',
        'Search' => 'Chercher',
        'and' => 'et le',
        'between' => 'entre',
        'Fulltext Search' => 'Recherche sur tout le texte',
        'Data' => 'Donnes',
        'Options' => 'Options',
        'Title' => 'Titre',
        'Item' => 'lment',
        'Delete' => 'Effacer',
        'Edit' => 'diter',
        'View' => 'Vue',
        'Number' => 'Nombre',
        'System' => 'Systme',
        'Contact' => 'Contact',
        'Contacts' => 'Contacts',
        'Export' => 'Exporter',
        'Up' => 'Haut',
        'Down' => 'Bas',
        'Add' => 'Ajouter',
        'Added!' => 'Ajout !',
        'Category' => 'Catgorie',
        'Viewer' => 'Visionneuse',
        'Expand' => 'Etendre',
        'Small' => 'Petit',
        'Medium' => 'Moyen',
        'Large' => 'Grand',
        'Date picker' => 'Selection de date',
        'New message' => 'Nouveau message',
        'New message!' => 'Nouveau message !',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Veuillez rpondre  ce(s) ticket(s) pour revenir  une vue normale de la file !',
        'You have %s new message(s)!' => 'Vous avez %s nouveau(x) message(s) !',
        'You have %s reminder ticket(s)!' => 'Vous avez %s rappel(s) de ticket(s) !',
        'The recommended charset for your language is %s!' => 'Le jeu de caractre correspondant  votre langue est %s !',
        'Change your password.' => 'Modifier votre mot de passe',
        'Please activate %s first!' => 'Merci d\'activer %s en premier lieu',
        'No suggestions' => 'Pas de suggestions',
        'Word' => 'Mot',
        'Ignore' => 'Ignorer',
        'replace with' => 'remplacer par',
        'There is no account with that login name.' => 'Il n\'y a aucun compte avec ce nom de connexion',
        'Login failed! Your user name or password was entered incorrectly.' => 'Mauvaise authentification! Votre nom de compte ou mot de passe taient errons',
        'There is no acount with that user name.' => 'Il n\'y a aucun compte avec ce nom d\'utilisateur',
        'Please contact your administrator' => 'SVP contactez votre administrateur',
        'Logout' => 'Dconnexion',
        'Logout successful. Thank you for using OTRS!' => 'Dconnexion russie. Merci d\'avoir utilis OTRS !',
        'Invalid SessionID!' => 'ID de session invalide !',
        'Feature not active!' => 'Cette fonctionnalit n\'est pas active !',
        'Agent updated!' => 'Information de l\'oprateur mises  jour',
        'Create Database' => 'Crer la base de donnes',
        'System Settings' => 'Paramtres Systme',
        'Mail Configuration' => 'Configuration de la messagerie',
        'Finished' => 'Fini',
        'Login is needed!' => 'Authentification requise !',
        'Password is needed!' => 'Le mot de passe est requis !',
        'License' => 'Licence',
        'Take this Customer' => 'Choisir ce client',
        'Take this User' => 'Choisir cet utilisateur',
        'possible' => 'possible',
        'reject' => 'rejet',
        'reverse' => 'inverse',
        'Facility' => 'Service',
        'Time Zone' => 'Fuseau horaire',
        'Pending till' => 'En attendant jusqu\'',
        'Don\'t use the Superuser account to work with OTRS! Create new Agents and work with these accounts instead.' => '',
        'Dispatching by email To: field.' => 'Rpartition par le champ \':\' du courriel',
        'Dispatching by selected Queue.' => 'Rpartition selon la file slectionne',
        'No entry found!' => 'Aucun rsultat n\'a t trouv !',
        'Session has timed out. Please log in again.' => 'Le dlai de votre session est dpass, veuillez vous r-authentifier.',
        'No Permission!' => 'Pas de permission !',
        'To: (%s) replaced with database email!' => 'Le champ \':\' (%s) a t remplac avec la valeur de la base de donnes des adresses lectroniques !',
        'Cc: (%s) added database email!' => 'Cc: (%s) a t ajout  la base de donne d\'adresses lectroniques !',
        '(Click here to add)' => '(Cliquez ii pour ajouter)',
        'Preview' => 'Aperu',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Le paquet n\'a pas t correctement dploy ! Vous devez l\'installer  nouveau !',
        '%s is not writable!' => '% n\'est pas accessible en criture',
        'Cannot create %s!' => 'Impossible de crer %s',
        'Check to activate this date' => '',
        'Customer %s added' => 'Client %s ajout',
        'Role added!' => 'Rle ajout!',
        'Role updated!' => 'Rle mis  jour!',
        'Attachment added!' => 'Pice jointe ajoute!',
        'Attachment updated!' => 'Pice jointe mise  jour!',
        'Response added!' => 'Rponse ajoute!',
        'Response updated!' => 'Rponse mise  jour!',
        'Group updated!' => 'Groupe ajout!',
        'Queue added!' => 'File ajoute!',
        'Queue updated!' => 'File mise  jour!',
        'State added!' => 'tat ajout!',
        'State updated!' => 'tat mis  jour!',
        'Type added!' => 'Type ajout!',
        'Type updated!' => 'Type mis  jour!',
        'Customer updated!' => 'Client mis  jour!',
        'Contract' => 'Contrat',
        'Online Customer: %s' => 'Clients en ligne: %s',
        'Online Agent: %s' => 'Oprateurs en ligne: %s',
        'Calendar' => 'Calendrier',
        'File' => 'Fichier',
        'Filename' => 'Nom de fichier',
        'Type' => 'Type',
        'Size' => 'Taille',
        'Upload' => 'Uploader',
        'Directory' => 'Rpertoire',
        'Signed' => 'Sign',
        'Sign' => 'Signer',
        'Crypted' => 'Crypt',
        'Crypt' => 'Crypter',
        'PGP' => 'PGP',
        'PGP Key' => 'Cl PGP',
        'PGP Keys' => 'Cls PGP',
        'S/MIME' => 'S/MIME',
        'S/MIME Certificate' => 'Certificat S/MIME',
        'S/MIME Certificates' => 'Certificats S/MIME',
        'Office' => 'Bureau',
        'Phone' => 'Tlphone',
        'Fax' => 'Fax',
        'Mobile' => 'Tlphone portable',
        'Zip' => 'Code postal',
        'City' => 'Ville',
        'Street' => 'Rue',
        'Country' => 'Pays',
        'Location' => 'Plan',
        'installed' => 'install',
        'uninstalled' => 'dsinstall',
        'Security Note: You should activate %s because application is already running!' => 'Note de Scurit: Vous devriez activer %s parce que l\'application est dj lance !',
        'Unable to parse repository index document.' => '',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '',
        'No packages, or no new packages, found in selected repository.' => '',
        'Edit the system configuration settings.' => 'Modifier la configuration du systme.',
        'printed at' => 'imprim ',
        'Loading...' => 'Chargement...',
        'Dear Mr. %s,' => 'Cher M. %s',
        'Dear Mrs. %s,' => 'Cher Mme %s',
        'Dear %s,' => 'Cher %s',
        'Hello %s,' => 'Bonjour %s',
        'This email address already exists. Please log in or reset your password.' => 'Cette adresse de messagerie existe dj. Veuillez vous authentifier ou re-initialiser votre mot de passe',
        'New account created. Sent login information to %s. Please check your email.' => 'Nouveau compte cr. Informations de connexion envoyes  %s. SVP veuillez vrifier votre messagerie.',
        'Please press Back and try again.' => 'SVP, reculez d\'une page et rssayez.',
        'Sent password reset instructions. Please check your email.' => 'Instructions d\initialisation du mot de passe envoyes. SVP veuillez vrifier votre messagerie.',
        'Sent new password to %s. Please check your email.' => 'Nouveau mot de passe envoy  %s. SVP veuillez vrifier votre messagerie.',
        'Upcoming Events' => 'vnements  venir',
        'Event' => 'vnement',
        'Events' => 'vnements',
        'Invalid Token!' => 'Jeton invalide !',
        'more' => 'plus',
        'For more info see:' => 'Pour plus d\'informations, allez ',
        'Package verification failed!' => 'Vrification du paquet choue !',
        'Collapse' => 'Rduire',
        'Shown' => 'Affich(s)',
        'News' => 'Nouvelles',
        'Product News' => 'Nouvelles du produit',
        'OTRS News' => 'Nouvelles d\'OTRS',
        '7 Day Stats' => 'Stats sur 7 jours',
        'Bold' => 'Gras',
        'Italic' => 'Italique',
        'Underline' => 'Soulign',
        'Font Color' => 'Couleur de police',
        'Background Color' => 'Couleur de fond',
        'Remove Formatting' => 'Supprimer le formattage',
        'Show/Hide Hidden Elements' => 'Montrer/Cacher les lments cachs',
        'Align Left' => 'Aligner  Gauche',
        'Align Center' => 'Aligner au Centre',
        'Align Right' => 'Aligner  Droite',
        'Justify' => 'Justifier',
        'Header' => 'En-tte',
        'Indent' => 'Ajouter indentation',
        'Outdent' => 'Supprimer indentation',
        'Create an Unordered List' => 'Crer une liste non ordonne',
        'Create an Ordered List' => 'Crer une liste ordonne',
        'HTML Link' => 'Lien HTML',
        'Insert Image' => 'Insrer image',
        'CTRL' => 'Contrle',
        'SHIFT' => 'Shift',
        'Undo' => 'Annuler',
        'Redo' => 'Refaire',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Fv',
        'Mar' => 'Mar',
        'Apr' => 'Avr',
        'May' => 'Mai',
        'Jun' => 'Juin',
        'Jul' => 'Juil',
        'Aug' => 'Ao',
        'Sep' => 'Sep',
        'Oct' => 'Oct',
        'Nov' => 'Nov',
        'Dec' => 'Dc',
        'January' => 'Janvier',
        'February' => 'Fvrier',
        'March' => 'Mars',
        'April' => 'Avril',
        'May_long' => 'Mai',
        'June' => 'Juin',
        'July' => 'Juillet',
        'August' => 'Aot',
        'September' => 'Septembre',
        'October' => 'Octobre',
        'November' => 'Novembre',
        'December' => 'Dcembre',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Les prfrences ont bien t mises  jour !',
        'User Profile' => 'Profil utilisateur',
        'Email Settings' => 'Paramtrage email',
        'Other Settings' => 'Autres paramtrages',
        'Change Password' => 'Changer de mot de passe',
        'Current Password' => 'Mot de passe actuel',
        'New password' => 'Nouveau mot de passe',
        'Verify password' => '',
        'Spelling Dictionary' => 'Correcteur orthographique',
        'Default spelling dictionary' => 'Dictionnaire d\'orthographe par dfaut.',
        'Max. shown Tickets a page in Overview.' => 'Nombre maximum de tickets affichs sur la page d\'aperu des tickets',
        'The current password is not correct. Please try again!' => 'Le mot de passe actuel n\'est pas correct. Merci d\'essayer  nouveau!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Impossible de mettre  jour le mot de passe, votre nouveau mot de passe ne correspond pas. Merci d\'essayer  nouveau!',
        'Can\'t update password, it contains invalid characters!' => 'Impossible de mettre  jour le mot de passe, il contienti des caractres invalides!',
        'Can\'t update password, it must be at least %s characters long!' => 'Impossible de mettre  jour le mot de passe,, il doit contenir au moins %s caractres!',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Impossible de mettre  jour le mot de passe, il doit contenir au moins 2 lettres en minuscule et 2 en majuscule!',
        'Can\'t update password, it must contain at least 1 digit!' => 'Impossible de mettre  jour le mot de passe, il doit contenir au moins 1 chiffre!',
        'Can\'t update password, it must contain at least 2 characters!' => 'Impossible de mettre  jour le mot de passe, il doit contenir au moins 2 caractres!',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Impossible de mettre  jour le mot de passe, ce mot de passe a dj t utilis. Merci d\'en choisir un autre!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => 'Slectionner le caractre sparateur pour les fichiers CSV (stats et recherches). Si rien n\'est indiqu ici, le sparateur par dfaut pour votre langage est utilis.',
        'CSV Separator' => 'Sparateur CSV',

        # Template: AAAStats
        'Stat' => 'Stat',
        'Sum' => 'Somme',
        'Please fill out the required fields!' => 'Remplissez les champs obligatoires svp !',
        'Please select a file!' => 'Slectionnez un fichier svp !',
        'Please select an object!' => 'Slectionnez un objet svp !',
        'Please select a graph size!' => 'Slectionnez une taille pour le graphique svp !',
        'Please select one element for the X-axis!' => 'Slectionnez un lment pour l\'axe X svp !',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Merci de slectionner un seul lment ou de dsactiver le bouton \'Fixe\' o le bouton de slection est marqu',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Si vous cochez une case, vous devez indiquer des attributs du champ slectionn !',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Veuillez donner une valeur pour le champ slectionn ou dcochez la case \'Fixed\' !',
        'The selected end time is before the start time!' => 'La date de fin est antrieure  la date de dbut !',
        'You have to select one or more attributes from the select field!' => 'Vous devez slectionner un ou plusieurs attributs du champ slectionn !',
        'The selected Date isn\'t valid!' => 'La date slectionne n\'est pas valide !',
        'Please select only one or two elements via the checkbox!' => 'Slectionnez uniquement un ou deux lments via les cases  cocher !',
        'If you use a time scale element you can only select one element!' => 'Si vous employez un lment d\'chelle de temps vous ne pouvez choisir qu\'un seul lment',
        'You have an error in your time selection!' => 'Vous avez une erreur dans le choix de la date !',
        'Your reporting time interval is too small, please use a larger time scale!' => 'La priode choisie pour le rapport est trop courte, veuillez indiquer une plage plus grande !',
        'The selected start time is before the allowed start time!' => 'La date de dbut choisie est antrieure  la date de dbut autorise !',
        'The selected end time is after the allowed end time!' => 'La date de fin choisie est posterieure  la date de fin autorise !',
        'The selected time period is larger than the allowed time period!' => 'La plage de temps choisie est suprieure  la priode de temps autorise !',
        'Common Specification' => 'Caractristiques Communes',
        'X-axis' => 'Axe X',
        'Value Series' => 'Sries de valeurs',
        'Restrictions' => 'Restrictions',
        'graph-lines' => 'Graphique-Lignes',
        'graph-bars' => 'Graphique-Barres',
        'graph-hbars' => 'Graphique-Barres horizontales',
        'graph-points' => 'Graphique-Points',
        'graph-lines-points' => 'Graphique-Lignes-Points',
        'graph-area' => 'Graphique-Surface',
        'graph-pie' => 'Graphique-Camembert',
        'extended' => 'tendu',
        'Agent/Owner' => 'Oprateur/Propritaire',
        'Created by Agent/Owner' => 'Cr par le Oprateur/Propritaire',
        'Created Priority' => 'Priorit cre',
        'Created State' => 'tat cr',
        'Create Time' => 'Date de cration',
        'CustomerUserLogin' => 'Identifiant Client',
        'Close Time' => 'Date de clture',
        'TicketAccumulation' => 'Cumul de ticket',
        'Attributes to be printed' => 'Attributs  imprimer',
        'Sort sequence' => 'Ordre de tri',
        'Order by' => 'Trier par',
        'Limit' => 'Limite',
        'Ticketlist' => 'Liste des tickets',
        'ascending' => 'ascendant',
        'descending' => 'descendant',
        'First Lock' => 'Premier verrou',
        'Evaluation by' => 'Evaluation par',
        'Total Time' => 'Temps Total',
        'Ticket Average' => 'Moyenne des tickets',
        'Ticket Min Time' => 'Temps minimum du ticket',
        'Ticket Max Time' => 'Temps maximum du ticket',
        'Number of Tickets' => 'Nombre de tickets',
        'Article Average' => 'Moyenne des articles',
        'Article Min Time' => 'Temps minimum des articles',
        'Article Max Time' => 'Temps maximum des articles',
        'Number of Articles' => 'Nombre d\'articles',
        'Accounted time by Agent' => 'Temps pass par oprateur',
        'Ticket/Article Accounted Time' => 'Temps pass par Ticket/Article',
        'TicketAccountedTime' => 'Temps pass sur le ticket',
        'Ticket Create Time' => 'Heure de cration du ticket',
        'Ticket Close Time' => 'Heure de fermeture du ticket',

        # Template: AAATicket
        'Status View' => 'Vue des statuts',
        'Bulk' => 'Combin',
        'Lock' => 'Verrouiller',
        'Unlock' => 'Dverrouiller',
        'History' => 'Historique',
        'Zoom' => 'Dtails',
        'Age' => 'ge',
        'Bounce' => 'Renvoyer',
        'Forward' => 'Transmettre',
        'From' => 'De',
        'To' => '',
        'Cc' => 'Copie ',
        'Bcc' => 'Copie Invisible',
        'Subject' => 'Sujet',
        'Move' => 'Dplacer',
        'Queue' => 'File',
        'Queues' => 'Files',
        'Priority' => 'Priorit',
        'Priorities' => 'Priorits',
        'Priority Update' => 'Mise  jour de la priorit',
        'SLA' => 'SLA',
        'Service Level Agreement' => 'Contrat de niveau de support',
        'Service Level Agreements' => 'Contrats de niveau de support',
        'Service' => 'Service',
        'Services' => 'Services',
        'State' => 'tat',
        'States' => 'tats',
        'Status' => 'Statut',
        'Statuses' => 'Status',
        'Ticket Type' => 'Type de ticket',
        'Ticket Types' => 'Types de tickets',
        'Compose' => 'Composer',
        'Pending' => 'En attente',
        'Owner' => 'Propritaire',
        'Owner Update' => 'Mise  jour du propritaire',
        'Responsible' => 'Responsable',
        'Responsible Update' => 'Mise  jour du responsable',
        'Sender' => 'metteur',
        'Article' => 'Article',
        'Ticket' => 'Ticket',
        'Createtime' => 'Cration du',
        'plain' => 'tel quel',
        'Email' => 'Courriel',
        'email' => 'courriel',
        'Close' => 'Fermer',
        'Action' => 'Action',
        'Attachment' => 'Pice jointe',
        'Attachments' => 'Pices jointes',
        'This message was written in a character set other than your own.' => 'Ce courriel a t crit dans un jeu de caractres diffrent du vtre.',
        'If it is not displayed correctly,' => 'S\'il n\'est pas affich correctement',
        'This is a' => 'Ceci est un',
        'to open it in a new window.' => 'L\'ouvrir dans une nouvelle fentre',
        'This is a HTML email. Click here to show it.' => 'Ceci est un courriel au format HTML ; cliquer ici pour l\'afficher.',
        'Free Fields' => 'Champs libres',
        'Merge' => 'Fusionner',
        'merged' => 'Fusionn',
        'closed successful' => 'clture (rsolue)',
        'closed unsuccessful' => 'clture (non rsolue)',
        'Locked Tickets Total' => 'Total des tickets verrouills',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => '',
        'Responsible Tickets Total' => '',
        'Responsible Tickets New' => '',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => '',
        'Watched Tickets New' => '',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'tous les tickets',
        'Tickets available' => 'Tickets disponibles',
        'Escalation' => 'Remonte',
        'last-search' => 'dernire-recherche',
        'QueueView' => 'Vue file',
        'Ticket Escalation View' => 'Vue des remontes du ticket',
        'Message from' => '',
        'End message' => '',
        'Forwarded message from' => '',
        'End forwarded message' => '',
        'new' => 'nouveau',
        'open' => 'ouvrir',
        'Open' => 'Ouvert',
        'closed' => 'ferm',
        'Closed' => 'Ferm',
        'removed' => 'supprim',
        'pending reminder' => 'Attente du rappel',
        'pending auto' => 'En attente auto',
        'pending auto close+' => 'En attente de la fermeture automatique(+)',
        'pending auto close-' => 'En attente de la fermeture automatique(-)',
        'email-external' => 'courriel externe',
        'email-internal' => 'courriel interne',
        'note-external' => 'Note externe',
        'note-internal' => 'Note interne',
        'note-report' => 'Note rapport',
        'phone' => 'tlphone',
        'sms' => 'SMS',
        'webrequest' => 'Requte par le web',
        'lock' => 'verrouiller',
        'unlock' => 'dverrouiller',
        'very low' => 'trs basse',
        'low' => 'confort de fonctionnement',
        'normal' => 'normal',
        'high' => 'important',
        'very high' => 'trs haut',
        '1 very low' => '1 trs bas',
        '2 low' => '2 bas',
        '3 normal' => '3 normal',
        '4 high' => '4 important',
        '5 very high' => '5 trs important',
        'Ticket "%s" created!' => 'Le ticket %s a t cr !',
        'Ticket Number' => 'Numro de ticket',
        'Ticket Object' => 'Objet ticket',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Pas de ticket numro "%s" ! Impossible de le lier !',
        'Don\'t show closed Tickets' => 'Ne pas montrer les tickets cloturs',
        'Show closed Tickets' => 'Voir les tickets cloturs',
        'New Article' => 'Nouvel Article',
        'Unread article(s) available' => '',
        'Remove from list of watched tickets' => '',
        'Add to list of watched tickets' => '',
        'Email-Ticket' => 'crire un courriel',
        'Create new Email Ticket' => 'Crer un nouveau ticket en envoyant un courriel',
        'Phone-Ticket' => 'Vue tlphone',
        'Search Tickets' => 'Recherche de tickets',
        'Edit Customer Users' => 'Editer clients',
        'Edit Customer Company' => 'diter l\'entreprise cliente',
        'Bulk Action' => 'Action groupe',
        'Bulk Actions on Tickets' => 'Action groupes sur les tickets',
        'Send Email and create a new Ticket' => 'Envoyer un courriel et crer un nouveau Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'Crer un ticket Courriel et l\'envoyer (Sortant)',
        'Create new Phone Ticket (Inbound)' => 'Crer un ticket Tlphone (Entrant)',
        'Overview of all open Tickets' => 'Vue de tous les Tickets',
        'Locked Tickets' => 'Tickets verrouills',
        'My Locked Tickets' => 'Mes tickets vrrouills',
        'My Watched Tickets' => 'Mes tickets surveills',
        'My Responsible Tickets' => 'Mes tickets en responsabilit',
        'Watched Tickets' => 'Tickets surveills',
        'Watched' => 'Surveill',
        'Watch' => 'Surveiller',
        'Unwatch' => 'Arrter le suivi',
        'Lock it to work on it!' => 'Verrouillez-le pour travailler dessus !',
        'Unlock to give it back to the queue!' => 'Dverrouillez-le pour qu\'il retourne dans sa file !',
        'Shows the ticket history!' => 'Voir l\'historique du ticket !',
        'Print this ticket!' => 'Imprimer ce ticket !',
        'Change the ticket priority!' => 'Changer la priorit du ticket !',
        'Change the ticket free fields!' => 'Changer les champs libres du ticket !',
        'Link this ticket to an other objects!' => 'Lier ce ticket  un autre objet !',
        'Change the ticket owner!' => 'Changer le propritaire du ticket !',
        'Change the ticket customer!' => 'Changer le client du ticket !',
        'Add a note to this ticket!' => 'Ajouter une note au ticket !',
        'Merge this ticket!' => 'Fusionner ce ticket !',
        'Set this ticket to pending!' => 'Mettre le ticket en attente !',
        'Close this ticket!' => 'Fermer ce ticket !',
        'Look into a ticket!' => 'Voir le dtail du ticket !',
        'Delete this ticket!' => 'Effacer ce ticket !',
        'Mark as Spam!' => 'Marquer comme Spam !',
        'My Queues' => 'Mes files',
        'Shown Tickets' => 'Tickets affichs',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Votre courriel avec le numro de ticket "<OTRS_TICKET>" a t fusionn avec le ticket numro "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: le temps imparti pour la premire rponse est dpass (%s) !',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: le temps imparti pour la premire rponse sera dpass dans %s !',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: le temps imparti pour la rvision est dpass (%s) !',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: le temps imparti pour la rvision sera dpass dans %s !',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: le temps imparti pour fournir une solution est dpass (%s) !',
        'Ticket %s: solution time will be over in %s!' => 'Ticket %s: le temps imparti pour fournir une solution sera dpass dans %s !',
        'There are more escalated tickets!' => 'Il y a d\'autres tickets en escalade !',
        'Plain Format' => 'Format texte',
        'Reply All' => 'Rpondre  tous',
        'Direction' => '',
        'Agent (All with write permissions)' => '',
        'Agent (Owner)' => '',
        'Agent (Responsible)' => '',
        'Ticket is locked by another agent.' => '',
        'New ticket notification' => 'Notification de nouveau ticket',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Me prvenir si il y a un nouveau ticket dans une de "Mes files".',
        'Send new ticket notifications' => '',
        'Ticket follow up notification' => '',
        'Ticket lock timeout notification' => 'Prvenir du dpassement du dlai d\'un verrou',
        'Send me a notification if a ticket is unlocked by the system.' => 'Me prvenir si un ticket est dverrouill par le systme',
        'Send ticket lock timeout notifications' => '',
        'Ticket move notification' => 'Notification de dplacement de Ticket',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Me prvenir si un ticket est dplac dans une de "Mes files".',
        'Send ticket move notifications' => '',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Votre slection des files prfres. Vous recevrez une information par courriel si disponible',
        'Custom Queue' => 'File d\'attente personnalise',
        'QueueView refresh time' => 'Temps de rafrachissement de la vue des files',
        'If enabled, the QueueView will automatically refresh after the specified time.' => '',
        'Refresh QueueView after' => 'Rafraichir la vue des files aprs',
        'Screen after new ticket' => 'cran aprs un nouveau ticket',
        'Show this screen after I created a new ticket' => '',
        'Closed Tickets' => 'Tickets ferms',
        'Show closed tickets.' => 'Voir les tickets ferms',
        'Max. shown Tickets a page in QueueView.' => 'Nombre maximum de tickets affichs sur la page de la vue d\'une file',
        'Ticket Overview "Small" Limit' => '',
        'Ticket limit per page for Ticket Overview "Small"' => '',
        'Ticket Overview "Medium" Limit' => '',
        'Ticket limit per page for Ticket Overview "Medium"' => '',
        'Ticket Overview "Preview" Limit' => '',
        'Ticket limit per page for Ticket Overview "Preview"' => '',
        'Ticket watch notification' => 'Notification de surveillance de Ticket',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => '',
        'Send ticket watch notifications' => '',
        'Out Of Office Time' => '',
        'New Ticket' => 'Nouveau ticket',
        'Create new Ticket' => 'Cration d\'un nouveau ticket',
        'Customer called' => 'Client appell',
        'phone call' => 'Appel tlphonique',
        'Phone Call Outbound' => '',
        'Reminder Reached' => 'Rappel atteint',
        'Reminder Tickets' => 'Tickets de rappel',
        'Escalated Tickets' => 'Tickets escalads',
        'New Tickets' => 'Nouveaux tickets',
        'Open Tickets / Need to be answered' => 'Tickets ouverts en attente de rponse',
        'All open tickets, these tickets have already been worked on, but need a response' => '',
        'All new tickets, these tickets have not been worked on yet' => '',
        'All escalated tickets' => '',
        'All tickets with a reminder set where the reminder date has been reached' => '',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Le ticket a t dplac dans la file "%s" (%s) - Ancienne file: "%s" (%s).',
        'History::TypeUpdate' => 'Type positionn  %s (ID=%s).',
        'History::ServiceUpdate' => 'Service positionn  %s (ID=%s).',
        'History::SLAUpdate' => 'SLA positionn  %s (ID=%s).',
        'History::NewTicket' => 'Un nouveau ticket a t cre: [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'Un suivi du ticket [%s]. %s',
        'History::SendAutoReject' => 'Rejet automatique envoy  "%s".',
        'History::SendAutoReply' => 'Rponse automatique envoye  "%s".',
        'History::SendAutoFollowUp' => 'Suivi automatique envoy  "%s".',
        'History::Forward' => 'Transfr vers "%s".',
        'History::Bounce' => 'Redirig vers "%s".',
        'History::SendAnswer' => 'Courriel envoy  "%s".',
        'History::SendAgentNotification' => '"%s"-notification envoy  "%s".',
        'History::SendCustomerNotification' => 'Notification envoy  "%s".',
        'History::EmailAgent' => 'Courriel envoy au client.',
        'History::EmailCustomer' => 'Ajout d\'une adresse ml. %s',
        'History::PhoneCallAgent' => 'L\'oprateur a appell le client.',
        'History::PhoneCallCustomer' => 'Le client nous a appell.',
        'History::AddNote' => 'Ajout d\'une note (%s)',
        'History::Lock' => 'Ticket verrouill.',
        'History::Unlock' => 'Ticket dverrouill.',
        'History::TimeAccounting' => 'Temps pass sur l\'action: %s . Total du temps pass pour ce ticket: %s unit(s).',
        'History::Remove' => 'Supprimer %s',
        'History::CustomerUpdate' => 'Mise  jour: %s',
        'History::PriorityUpdate' => 'Changement de priorit de "%s" (%s) pour "%s" (%s).',
        'History::OwnerUpdate' => 'Le nouveau propritaire est "%s" (ID=%s).',
        'History::LoopProtection' => 'Protection anti-boucle ! Pas d\'auto rponse envoy  "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Mise  jour: %s',
        'History::StateUpdate' => 'tat Avant: "%s" Aprs: "%s"',
        'History::TicketFreeTextUpdate' => 'Mise  jour: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Requte du client via le web.',
        'History::TicketLinkAdd' => 'Ajout d\'un lien vers le ticket "%s".',
        'History::TicketLinkDelete' => 'Suppression du lien vers le ticket "%s".',
        'History::Subscribe' => 'Abonnement pour l\'utilisateur "%s".',
        'History::Unsubscribe' => 'Dsabonnement pour l\'utilisateur "%s".',
        'History::SystemRequest' => 'Requte systme',
        'History::ResponsibleUpdate' => 'Mise  jour du responsable',
        'History::ArchiveFlagUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'Dim',
        'Mon' => 'Lun',
        'Tue' => 'Mar',
        'Wed' => 'Mer',
        'Thu' => 'Jeu',
        'Fri' => 'Ven',
        'Sat' => 'Sam',

        # Template: AdminAttachment
        'Attachment Management' => 'Gestion des pices jointes',
        'Actions' => 'Actions',
        'Go to overview' => 'Aller au rsum',
        'Add attachment' => '',
        'List' => 'Lister',
        'No data found.' => 'Aucune donne trouve',
        'Download file' => 'Tlcharger fichier',
        'Delete this attachment' => 'Supprimer cet attachement',
        'Add Attachment' => 'Ajouter attachement',
        'Edit Attachment' => 'Editer attachement',
        'This field is required.' => 'Ce champ est requis',
        'or' => 'ou',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Gestion des rponses automatiques',
        'Add auto response' => 'Ajouter rponse automatique',
        'Add Auto Response' => 'Ajouter Rponse Automatique',
        'Edit Auto Response' => 'Editer Rponse Automatique',
        'Response' => 'Rponse',
        'Auto response from' => 'Rponse automatique de',
        'Reference' => 'Rfrence',
        'You can use the following tags' => 'Vous pouvez utiliser les tags suivants',
        'To get the first 20 character of the subject.' => 'Pour avoir les 20 premiers caractres du sujet',
        'To get the first 5 lines of the email.' => 'Pour avoir les 5 premires lignes du courriel',
        'To get the realname of the sender (if given).' => 'Pour avoir le nom de l\'expditeur s\'il est fourni.',
        'To get the article attribute' => 'Pour avoir l\'attribut de l\'article',
        ' e. g.' => 'i.e.',
        'Options of the current customer user data' => 'Options des donnes du client actuel',
        'Ticket owner options' => 'Options du propritaire du ticket',
        'Ticket responsible options' => 'Options du responsable du ticket',
        'Options of the current user who requested this action' => 'Options de l\'utilisateur actuel qui a demand cette action',
        'Options of the ticket data' => 'Options des donnes du ticket',
        'Config options' => 'Options de confguration',
        'Example response' => 'Exemple de rponse',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Gestion des services clients',
        'Wildcards like \'*\' are allowed.' => '',
        'Add customer company' => 'Ajouter une entreprise cliente',
        'Please enter a search term to look for customer companies.' => 'Merci d\'entrer un motif de recherche pour chercher les entreprises clients',
        'Add Customer Company' => 'Ajouter un client au service',

        # Template: AdminCustomerUser
        'Customer Management' => 'Gestion des clients',
        'Add customer' => 'Ajouter client',
        'Select' => 'Slectionner',
        'Hint' => '',
        'Customer will be needed to have a customer history and to login via customer panel.' => 'Le client devra avoir un historique et se connecter via le panneau utilisateur',
        'Please enter a search term to look for customers.' => 'Merci d\'entrer un motif pour rechercher des clients',
        'Last Login' => 'Dernire connexion',
        'Add Customer' => 'Ajouter client',
        'Edit Customer' => 'Editer client',
        'This field is required and needs to be a valid email address.' => '',
        'This email address is not allowed due to the system configuration.' => '',
        'This email address failed MX check.' => '',
        'DNS problem, please check your configuration and the error log.' => '',
        'The syntax of this email address is incorrect.' => '',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Grer les relations Client-Group',
        'Notice' => 'Note',
        'This feature is disabled!' => 'Cette fonctionnalit est dsactive !',
        'Just use this feature if you want to define group permissions for customers.' => 'Utiliser cette fonction uniquement si vous shouhaitez dfinir des permissions de groupe pour les clients',
        'Enable it here!' => 'Activez la ici !',
        'Search for customers.' => '',
        'Edit Customer Default Groups' => 'Editer les groupes par dfault client',
        'These groups are automatically assigned to all customers.' => 'Ces groupes sont automatiquement assigns  tous les clients',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '',
        'Filter for Groups' => 'Filtre pour les Groupes',
        'Select the customer:group permissions.' => 'Selectionner les permissions client::groupe',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => 'Si rien n\'est slectionn, alors il n\'y aura aucune permission dans ce groupe (les tickets ne seront pas accessibles au client).',
        'Search Result:' => 'Rsultat de recherche:',
        'Customers' => 'Clients',
        'Groups' => 'Groupes',
        'No matches found.' => 'Aucun rsultat.',
        'Change Group Relations for Customer' => '',
        'Change Customer Relations for Group' => '',
        'Toggle %s Permission for all' => 'Slectionner la Permission %s pour tous',
        'Toggle %s permission for %s' => 'Slectionner la permission %s pour %s',
        'Customer Default Groups:' => 'Groupes par dfaut du client',
        'No changes can be made to these groups.' => 'Aucun changement possible pour ces groupes',
        'ro' => 'lecture seule',
        'Read only access to the ticket in this group/queue.' => 'Accs en lecture seulement aux tickets de cette file/groupe.',
        'rw' => 'lecture/criture',
        'Full read and write access to the tickets in this group/queue.' => 'Accs complet en lecture et criture aux tickets dans cette file/groupe.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => 'Grer les Relations Client-Services',
        'Edit default services' => 'Editer les services par dfaut',
        'Filter for Services' => 'Filtre pour les Services',
        'Allocate Services to Customer' => '',
        'Allocate Customers to Service' => '',
        'Toggle active state for all' => 'Slectionner l\'tat actif pour tous',
        'Active' => 'Actif',
        'Toggle active state for %s' => 'Slectionner l\'tat actif pour %s',

        # Template: AdminEmail
        'Admin Notification' => 'Notification des administrateurs',
        'With this module, administrators can send messages to agents, group or role members.' => '',
        'Create Administrative Message' => '',
        'Your message was sent to' => 'Votre message a t envoy ',
        'Send message to users' => 'Envoyer message aux utilisateurs',
        'Send message to group members' => 'Envoyer message aux membre du gorupe',
        'Group members need to have permission' => 'Les membres du groupe ont besoin de la permission',
        'Send message to role members' => 'Envoyer message aux membres du rle',
        'Also send to customers in groups' => 'Envoyer aussi aux clients dans les groupes',
        'Body' => 'Corps',
        'Send' => 'Envoyer',

        # Template: AdminGenericAgent
        'Generic Agent' => 'Agent gnrique',
        'Add job' => 'Ajouter tche',
        'Last run' => 'Dernier lancement',
        'Run Now!' => 'Lancer maintenant !',
        'Delete this task' => 'Supprimer cette tche',
        'Run this task' => 'Excuter cette tche',
        'Job Settings' => 'Configuration de la tche',
        'Job name' => 'Nom de la tche',
        'Currently this generic agent job will not run automatically.' => 'Actuellement, cet agent gnrique ne s\'excutera pas automatiquement',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Pour permettre l\'excution automatique, slectionnez au moins une valeur dans minutes, heures et jours !',
        'Schedule minutes' => 'Planification Minutes',
        'Schedule hours' => 'Planification Heures',
        'Schedule days' => 'Planification Jours',
        'Toggle this widget' => '',
        'Ticket Filter' => 'Filtre ticket',
        '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 or 105658*)',
        '(e. g. 234321)' => '(ex: 234321)',
        'Customer login' => 'Login Client',
        '(e. g. U5150)' => '(ex: U5150)',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => 'Recherche plein texte dans article (i.e. "Mar*in" ou "Baue*").',
        'Agent' => 'Oprateur',
        'Ticket lock' => 'Verrouillage ticket',
        'TicketFreeFields' => 'Champs libres du ticket',
        'Create times' => 'Dates de cration',
        'No create time settings.' => 'Pas de critre de date de cration',
        'Ticket created' => 'Ticket cr',
        'Ticket created between' => 'Ticket cr entre le',
        'Close times' => 'Dates de clotre',
        'No close time settings.' => 'Pas de paramtre de temps de fermeture',
        'Ticket closed' => 'Ticket ferm',
        'Ticket closed between' => 'Ticket ferm entre',
        'Pending times' => 'Dates de mise en attente',
        'No pending time settings.' => 'pas de critre de date d\'chance',
        'Ticket pending time reached' => 'Date d\'chance atteinte le',
        'Ticket pending time reached between' => 'Date d\'chance atteinte entre le',
        'Escalation times' => 'Dates d\'escalade',
        'No escalation time settings.' => 'Pas de paramtres de temps d\'escalade',
        'Ticket escalation time reached' => 'Temps d\'escalade du ticket atteinte',
        'Ticket escalation time reached between' => 'Temps d\'escalade du ticket atteinte entre',
        'Escalation - first response time' => 'Escalade - Date de premire rponse',
        'Ticket first response time reached' => 'Premier temps de rponse du ticket atteint',
        'Ticket first response time reached between' => 'Premier temps de rponse du ticket atteint entre',
        'Escalation - update time' => 'Escalade - Date de mise  jour',
        'Ticket update time reached' => 'Temps de mise  jour du ticket atteint',
        'Ticket update time reached between' => 'Temps de mise  jour du ticket atteint entre',
        'Escalation - solution time' => 'Escalade - Date de solution',
        'Ticket solution time reached' => 'Temps de rsolution du ticket atteint',
        'Ticket solution time reached between' => 'Temps de rsolution du ticket atteint entre',
        'Archive search option' => 'Option de recherche Archive',
        'Ticket Action' => 'Action sur Ticket',
        'Set new service' => 'Dfinir un nouveau service',
        'Set new Service Level Agreement' => 'Dfinir un nouveau contrat de niveau de support ',
        'Set new priority' => 'Dfinir une nouvelle priorit',
        'Set new queue' => 'Dfinir une nouvelle file',
        'Set new state' => 'Dfinir un nouvel tat',
        'Set new agent' => 'Dfinir un nouve l\'oprateur',
        'new owner' => 'Nouveau propritaire',
        'Set new ticket lock' => 'Placer un nouveau verrou sur le ticket',
        'New customer' => 'Nouveau client',
        'New customer ID' => 'Nouvel ID client',
        'New title' => 'Nouveau titre',
        'New type' => 'Nouveau type',
        'New TicketFreeFields' => 'Nouveau champs libres',
        'Archive selected tickets' => 'Archiver tickets slectionns',
        'Add Note' => 'Ajouter une note',
        'Time units' => 'Unit de temps',
        ' (work units)' => ' Unit de travail',
        'Ticket Commands' => '',
        'Send agent/customer notifications on changes' => 'Envoyer des notifications  l\'oprateur/au client sur changement',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Cette commande sera excut. ARG[0] sera le numro du ticket et ARG[1] son identifiant.',
        'Delete tickets' => 'Effacer les tickets',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => 'Attention: Tous les tickets impacts seront supprims de la base de donne et ne pourront tre restaurs!',
        'Execute Custom Module' => 'Excuter le Module Client',
        'Param %s key' => '',
        'Param %s value' => '',
        'Save Changes' => '',
        'Save' => 'Sauver',
        'Results' => 'Rsultat',
        '%s Tickets affected! What do you want to do?' => '% Tickets impacts! Que voulez vous faire?',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => 'Attention: Vous devriez utiliser l\'option DELETE. Tous les tickets effacs seront perdus!',
        'Edit job' => 'Editer tche',
        'Run job' => 'Excuter tche',
        'Affected Tickets' => 'Tickets impacts',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'ATTENTION: Lorsque vous modifier le nom du group \'admin\', avant de faire les changements appropris dans SysConfig, vous serez dconnect du panneau d\'administration. Si cela arrive, veuillez renommer  nouveau le groupe admin par une requte SQL.',
        'Group Management' => 'Administration des groupes',
        'Add group' => 'Ajouter groupe',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Le groupe admin permet d\'accder  la zone d\'administration et le groupe stats  la zone de statistiques.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => 'Crer de nouveux groupes pour grer des permissions d\'accs pour les diffrents groupes de oprateurs (i.e. achats, support, ventes,...). ',
        'It\'s useful for ASP solutions. ' => 'C\'est utilie pour les solutions ASP',
        'Add Group' => 'Ajouter un groupe',
        'Edit Group' => 'Editer Groupe',

        # Template: AdminLog
        'System Log' => 'Journaux du Systme',
        'Here you will find log information about your system.' => 'Vous trouverez ici les informations de log sur votre systme',
        'Hide this message' => '',
        'Recent Log Entries' => '',
        'Time' => 'Date et heure',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Gestion du compte de messagerie',
        'Add mail account' => 'Ajouter compte mail',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Tous les courriels entrants avec un compte associ seront rpartis dans la file slectionne !',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Si votre compte est vrifi, les ent&ecirc;tes X-OTRS (pour les priorits,...) seront utiliss !',
        'Host' => 'Hte',
        'Delete account' => 'Supprimer compte',
        'Fetch mail' => 'Parcourir mail',
        'Add Mail Account' => 'Aouter compte mail',
        'Example: mail.example.com' => '',
        'Trusted' => 'Vrifi',
        'Dispatching' => 'Rpartition',
        'Edit Mail Account' => 'Editer compte mail',

        # Template: AdminNavigationBar
        'Admin' => 'Administrateur',
        'Agent Management' => 'Gestion Oprateur',
        'Queue Settings' => 'Configuration File',
        'Ticket Settings' => 'Configuration Ticket',
        'System Administration' => 'Administration Systme',

        # Template: AdminNotification
        'Notification Management' => 'Gestion des notifications',
        'Select a different language' => '',
        'Filter for Notification' => 'Filtre pour Notification',
        'Notifications are sent to an agent or a customer.' => 'Des notifications sont envoyes  un oprateur ou  un client.',
        'Notification' => 'Notification',
        'Edit Notification' => 'Editer Notification',
        'e. g.' => 'i.e.',
        'Options of the current customer data' => 'Options des donnes du cient actuel',

        # Template: AdminNotificationEvent
        'Add notification' => 'Ajouter notification',
        'Delete this notification' => 'Supprimer cette notification',
        'Add Notification' => 'Ajouter Notification',
        'Recipient groups' => 'Groupes destinataires',
        'Recipient agents' => 'Oprateurs destinataires',
        'Recipient roles' => 'Rles destinaires',
        'Recipient email addresses' => 'Adresses email destinataires',
        'Article type' => 'Type d\'article',
        'Only for ArticleCreate event' => 'Seulement pour l\'venement CrationArticle',
        'Subject match' => 'Correspondance du sujet',
        'Body match' => 'Correspondance du corps du courriel',
        'Include attachments to notification' => 'Inclure les attachements  la notification',
        'Notification article type' => '',
        'Only for notifications to specified email addresses' => '',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Pour avoir les 20 premiers caractres du sujet (du dernier article de l\'oprateur).',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Pour avoir les 5 premires ligne du corps (du dernier article de l\'oprateur).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Pour avoir les 20 premiers caractres du sujet (du dernier article du client).',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Pour avoir les 5 premires lignes du sujet (du dernier article du client).',

        # Template: AdminPGP
        'PGP Management' => 'Gestion de PGP',
        'Use this feature if you want to work with PGP keys.' => '',
        'Add PGP key' => 'Ajouter cl PGP',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'Dans ce cas vous pouvez directement diter le trousseau configur dans SysConfig.',
        'Introduction to PGP' => '',
        'Result' => 'Rsultat',
        'Identifier' => 'Identifiant',
        'Bit' => 'Bit',
        'Key' => 'Cl',
        'Fingerprint' => 'Empreinte',
        'Expires' => 'Expiration',
        'Delete this key' => 'Supprimer cette cl',
        'Add PGP Key' => 'Ajouter Cl PGP',
        'PGP key' => '',

        # Template: AdminPackageManager
        'Package Manager' => 'Gestionnaire de paquet',
        'Uninstall package' => 'Dsinstaller package',
        'Version' => 'Version',
        'Do you really want to uninstall this package?' => 'Voulez-vous vraiment dinstaller ce paquet ?',
        'Reinstall package' => 'Rinstaller package',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => 'Voulez-vous vraiment rinstaller ce package? Un quelconque changement manuel sera perdu. ',
        'Continue' => 'Continuer',
        'Install' => 'Installation',
        'Install Package' => 'Installer Package',
        'Update repository information' => 'Mettre  jour les informations du dpot',
        'Did not find a required feature? OTRS Group provides their subscription customers with exclusive Add-Ons:' => '',
        'Online Repository' => 'Dpot en ligne',
        'Vendor' => 'Vendeur',
        'Module documentation' => 'Documentation du module',
        'Upgrade' => 'Mise  jour',
        'Local Repository' => 'Dpt local',
        'Uninstall' => 'Dinstallation',
        'Package not correctly deployed! You should reinstall the package again!' => 'Package incorrectement dploy! Vous devriez rinstaller le package!',
        'Reinstall' => 'R-installation',
        'Download package' => 'Tlcharger package',
        'Rebuild package' => 'Reconsruire package',
        'Metadata' => 'Metadata',
        'Change Log' => 'Log de modification',
        'Date' => 'Date',
        'List of Files' => 'iListe de fichiers',
        'Permission' => 'Droits',
        'Download' => 'Tlchargement',
        'Download file from package!' => 'Tlcharger le fichier depuis le paquet !',
        'Required' => 'Obligatoire',
        'PrimaryKey' => 'Cl primaire',
        'AutoIncrement' => 'Auto incrmentation',
        'SQL' => 'SQL',
        'File differences for file %s' => 'Diffrences de fichier pour le fichier %s',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Enregistrement des indicateurs de performance',
        'This feature is enabled!' => 'Cette fonctionnalit est active',
        'Just use this feature if you want to log each request.' => 'N\'employer cette fonction que si vous voulez enregitrer chaque requte',
        'Activating this feature might affect your system performance!' => 'Activer cette fonctionnalit peut avoir un impact sur les performances de votre systme !',
        'Disable it here!' => 'Dsactivez l ici !',
        'Logfile too large!' => 'Fichier de log trop grand !',
        'The logfile is too large, you need to reset it' => 'Le fichier de log est trop grand, vous devez le rinitialiser',
        'Overview' => 'Aperu',
        'Range' => 'Plage',
        'Interface' => 'Interface',
        'Requests' => 'Requtes',
        'Min Response' => 'Temps de rponse minimum',
        'Max Response' => 'Temps de rponse maximun',
        'Average Response' => 'Temps de rponse moyen',
        'Period' => 'Priode',
        'Min' => 'Min',
        'Max' => 'Max',
        'Average' => 'Moyenne',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Gestion des filtres PostMaster',
        'Add filter' => 'Ajouter filtre',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => '',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Si vous voulez tester uniquement l\'adresse lectronique, utiliser EMAILADDRESS:info@example.com dans De,  ou Copie.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => 'Supprimer ce filtre',
        'Add PostMaster Filter' => 'Ajouter un filtre PostMaster',
        'Edit PostMaster Filter' => 'EditerFiltre PostMaster',
        'Filter name' => '',
        'The name is required.' => '',
        'Stop after match' => 'Stopper aprs correspondance',
        'Filter Condition' => 'Condition de filtre',
        'Value' => 'Valeur',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => 'Mettre les enttes email',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Gestion de la priorit',
        'Add priority' => 'Ajouter priorit',
        'Add Priority' => 'Ajouter la priorit',
        'Edit Priority' => 'Editer priorit',

        # Template: AdminQueue
        'Manage Queues' => 'Grer les Files',
        'Add queue' => 'Ajouter une file',
        'Add Queue' => 'Ajouter une File',
        'Edit Queue' => 'Editer une File',
        'Sub-queue of' => 'Sous-file de',
        'Unlock timeout' => 'Dlai du dverrouillage',
        '0 = no unlock' => '0 = pas de verrouillage',
        'Only business hours are counted.' => 'Seules les plages horaires de bureau sont prises en compte.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => 'Si un oprateur vrouille un ticket et ne le ferme pas avant le dlai de dvrouillage, le ticket sera dvrouill et sera disponible pour un autre oprateur.',
        'Notify by' => 'Notification par',
        '0 = no escalation' => '0 = pas de remonte du ticket',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => 'Si un contact client n\'est pas ajout  un nouveau ticket, soit par email externe ou tlphone, avant que le temps dfini ici expire, le ticket sera escalad.',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => '',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => 'Si le ticket n\'est pas cltur avant que le dlai dfini ici n\'expire, le ticket est escalad.',
        'Follow up Option' => 'Option des suivis',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => 'Dfini si le suivi des tickets clturs doit rouvrir le ticket, tre rejet ou crer un nouveau ticket.',
        'Ticket lock after a follow up' => 'Ticket verrouill aprs un suivi',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => 'Si le tiket est clos and que le client envoie un suivi, le ticket sera vrouill sur l\'ancien propritaire.',
        'System address' => 'Adresse Systme',
        'Will be the sender address of this queue for email answers.' => 'Sera l\'adresse d\'expdition pour les rponses par courriel pour cette file.',
        'Default sign key' => 'Cl de signature par dfaut',
        'The salutation for email answers.' => 'La formule de politesse pour les rponses par courriel',
        'The signature for email answers.' => 'La signature pour les rponses par courriel',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => 'Grer les relations entre les files et les rponses automatiques',
        'Filter for Queues' => 'Filtre pour les files',
        'Filter for Auto Responses' => 'Filtre pour les rponses automatiques',
        'Auto Responses' => 'Rponses automatiques',
        'Change Auto Response Relations for Queue' => 'Modifier les rponses automatiques pour la file',
        'settings' => 'Paramtres',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => 'Grer les relations entre les files et les rponses',
        'Filter' => 'Filtre',
        'Filter for Responses' => 'Filtre pour rponses',
        'Responses' => 'Rponses',
        'Change Queue Relations for Response' => 'Modifier les files pour la rponse',
        'Change Response Relations for Queue' => 'Modifier les rponses pour la file',

        # Template: AdminResponse
        'Manage Responses' => 'Grer les Rponses',
        'Add response' => 'Ajouter rponse',
        'A response is default text to write faster answer (with default text) to customers.' => 'Une rponse est un texte par dfaut destin  rdiger plus rapidement des rponses standards aux clients.',
        'Don\'t forget to add a new response a queue!' => 'Ne pas oublier d\'affecter une file  une nouvelle rponse !',
        'Delete this entry' => 'Supprimer cette entre',
        'Add Response' => 'Ajouter Rponse',
        'Edit Response' => 'Editer Rponse',
        'The current ticket state is' => 'L\'tat actuel du ticket est',
        'Your email address is' => 'Votre adresse email est',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => 'Grer Rponses <-> Relations attachement',
        'Filter for Attachments' => '',
        'Change Response Relations for Attachment' => '',
        'Change Attachment Relations for Response' => '',
        'Toggle active for all' => 'Slectionner actif pour tous',
        'Link %s to selected %s' => 'Lien %s vers slection %s',

        # Template: AdminRole
        'Role Management' => 'Gestion des Rles',
        'Add role' => 'Ajouter Rle',
        'Create a role and put groups in it. Then add the role to the users.' => 'Cre un rle et y ajoute des groupes. Ajoute alors le rle aux utilisateurs.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => 'Il n\'y a pas de rle dfini. Utilisez le bouton \'Ajouter\' pour crer un nouveau rle.',
        'Add Role' => 'Ajouter un rle',
        'Edit Role' => 'Editer rle',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => 'Grer Relations Rle-Groupe',
        'Filter for Roles' => 'Filtre pour Rles',
        'Roles' => 'Rles',
        'Select the role:group permissions.' => 'Slectionner les permissions rle:groupe',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => 'Si rien n\'est slectionn, alors il n\'y a aucune permission pour ce groupe (les tickets ne seront pas disponibles pour ce rle).',
        'Change Role Relations for Group' => '',
        'Change Group Relations for Role' => '',
        'Toggle %s permission for all' => 'Slectionner permission %s pour tous',
        'move_into' => 'dplacer dans',
        'Permissions to move tickets into this group/queue.' => 'Permission de dplacer un ticket dans cette file/ce groupe.',
        'create' => 'crer',
        'Permissions to create tickets in this group/queue.' => 'Permission de crer un ticket dans cette file/ce groupe.',
        'priority' => 'priorit',
        'Permissions to change the ticket priority in this group/queue.' => 'Permission de changer la priorit d\'un ticket dans cette file/ce groupe.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => 'Grer les relations Oprateur-Rle',
        'Filter for Agents' => 'Filtre pour oprateurs',
        'Agents' => 'Agents',
        'Manage Role-Agent Relations' => 'Grer Relations Rle-Oprateur',
        'Change Role Relations for Agent' => 'Changer les rles pour un oprateur',
        'Change Agent Relations for Role' => 'Changer les oprateurs pour un rle ',

        # Template: AdminSLA
        'SLA Management' => 'Gestion des Accords sur la qualit de service (Service Level Agreement)',
        'Add SLA' => 'Ajouter un SLA',
        'Edit SLA' => 'Editer SLA',
        'Please write only numbers!' => '',

        # Template: AdminSMIME
        'S/MIME Management' => 'Gestion S/MIME',
        'Add certificate' => 'Ajouter certificat',
        'Add private key' => 'Ajouter cl priv',
        'Filter for certificates' => '',
        'Filter for SMIME certs' => '',
        'In this way you can directly edit the certification and private keys in file system.' => 'Dans ce cas vous pouvez directement diter le certificat et la cl prive dans le systme de fichier',
        'See also' => 'Voir aussi',
        'Hash' => 'Hashage',
        'Create' => 'Cration',
        'Delete this certificate' => 'Supprimer ce certificat',
        'Add Certificate' => 'Ajouter un certificat',
        'Add Private Key' => 'Ajouter une cl prive',
        'Secret' => 'Secret',

        # Template: AdminSalutation
        'Salutation Management' => 'Prfixes des courriels',
        'Add salutation' => '',
        'Add Salutation' => 'Ajouter un en-tte',
        'Edit Salutation' => 'Editer en-tte',
        'Example salutation' => 'Exemple d\'en-tte',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => 'Le mode scuris doit tre activ',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Le mode scuris sera (normallement) activ lorsque l\'installation initiale sera termine.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Le mode scuris doit tre dsactiv dans le but de rinstaller en utilisant le web-installer (installateur web)',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => 'Si le mode scuris n\'est pas activ, activez le via SysConfig car votre application est en train de tourner',

        # Template: AdminSelectBox
        'SQL Box' => 'Reqtes SQL',
        'Here you can enter SQL to send it directly to the application database.' => 'Ici vous pouvez entrez du SQL pour l\'envoyer directement  la base de donne',
        'The syntax of your SQL query has a mistake. Please check it.' => '',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => 'Format du rsultat',
        'Run Query' => 'Excuter requte',

        # Template: AdminService
        'Service Management' => 'Gestion des Services',
        'Add service' => 'Ajouter service',
        'Add Service' => 'Ajouter un Service',
        'Edit Service' => 'Editer service',
        'Sub-service of' => 'Sous-service de',

        # Template: AdminSession
        'Session Management' => 'Gestion des sessions',
        'All sessions' => 'Toutes les sessions',
        'Agent sessions' => 'Sessions Oprateurs',
        'Customer sessions' => 'Session Clients',
        'Unique agents' => 'Oprateurs uniques',
        'Unique customers' => 'Clients uniques',
        'Kill all sessions' => 'Supprimer toutes les sessions',
        'Kill this session' => 'tuer cette session',
        'Session' => 'Session',
        'Kill' => 'Tuer',
        'Detail View for SessionID' => 'Vue dtaille pour SessionID',

        # Template: AdminSignature
        'Signature Management' => 'Gestion des signatures',
        'Add signature' => 'Ajouter une signature',
        'Add Signature' => 'Ajouter une signature',
        'Edit Signature' => 'Editer signature',
        'Example signature' => 'Exemple de signature',

        # Template: AdminState
        'State Management' => 'Gestion des tats',
        'Add state' => 'Ajouter un tat',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Prenez garde de bien mettre  jour les tats par dfaut dans votre Kernel/Config.pm !',
        'Add State' => 'Ajouter un tat',
        'Edit State' => 'Editer tat',
        'State type' => 'Type d\'tat',

        # Template: AdminSysConfig
        'SysConfig' => 'Configuration Systme',
        'Navigate by searching in %s settings' => 'Naviguer en cherchant dans la configuration %s',
        'Navigate by selecting config groups' => 'Naviguer en slectionnant les groupes de configuration',
        'Download all system config changes' => 'Tlcharger toutes les modifications de configuration systme',
        'Export settings' => 'Configuration d\'export',
        'Load SysConfig settings from file' => 'Charger la configuration SysConfig  partir du fichier',
        'Import settings' => 'configuration d\'import',
        'Import Settings' => 'Configuration d\'Import',
        'Import' => 'Importer',
        'Please enter a search term to look for settings.' => 'Merci d\'entrer un motif de recherche pour chercher dans la configuration',
        'Subgroup' => 'Sous-groupe',
        'Elements' => 'lments',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => 'Editer les lments de configuration',
        'This config item is only available in a higher config level!' => 'Cet lment de configuration n\'est disponible que dans un niveau suprieur de configuration',
        'Reset this setting' => 'Rinitialiser cet lment',
        'Default value' => 'Valeur par dfaut',
        'Error: this file could not be found.' => 'Erreur: ce fichier ne peut pas tre trouv',
        'Error: this directory could not be found.' => 'Erreur: ce rpertoire ne peut pas tre trouv',
        'Error: an invalid value was entered.' => 'Erreur: valeur incorrecte',
        'Content' => 'Contenu',
        'Remove this entry' => 'Supprimer cette entre',
        'Add entry' => 'Ajouter une entre',
        'Remove entry' => 'Supprimer l\'entre',
        'Add new entry' => 'Ajouter une nouvelle entre',
        'Create new entry' => 'Crer une nouvelle entre',
        'New group' => 'Nouveau groupe',
        'Group ro' => 'Groupe ro',
        'Readonly group' => 'Group en lecture seule',
        'New group ro' => 'Nouveau groupe ro',
        'Loader' => 'Chargeur',
        'File to load for this frontend module' => 'Fichier  charger pour ce module "frontend"',
        'New Loader File' => 'Nouveau Fichier de Chargeur',
        'NavBarName' => 'Nom de la barre de navigation',
        'NavBar' => 'Barre de navigation',
        'LinkOption' => '',
        'Block' => 'Bloc',
        'AccessKey' => 'Accs clavier',
        'Add NavBar entry' => 'Ajouter entre de barre de navigation',
        'Year' => 'Anne',
        'Month' => 'Mois',
        'Day' => 'Jour',
        'Invalid year' => 'Anne incorrecte',
        'Invalid month' => 'Mois incorrect',
        'Invalid day' => 'Jour incorrect',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Gestion des adresses lectroniques du systme',
        'Add system address' => 'Ajouter adresse systme',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => 'Tous les messages entrants avec cette adresse en To(A) ou Cc(copie) seront ventils dans la file slectionne',
        'Email address' => 'Adresse de messagerie',
        'Display name' => 'Nom  afficher',
        'Add System Email Address' => 'Ajouter adresse de messagerie du systme',
        'Edit System Email Address' => 'Editer adresse de messagerie du systme',
        'The display name and email address will be shown on mail you send.' => 'Le nom  afficher et l\'adresse demessagerie seront affichs dans les messages que vous envoyez.',

        # Template: AdminType
        'Type Management' => 'Gestion des Types',
        'Add ticket type' => 'Ajouter type de ticket',
        'Add Type' => 'Ajouter un Type',
        'Edit Type' => 'Editer Type',

        # Template: AdminUser
        'Add agent' => 'Ajouter oprateur',
        'Agents will be needed to handle tickets.' => 'Des oprateurs seront requis pour grer les tickets',
        'Don\'t forget to add a new agent to groups and/or roles!' => 'N\'oubliez pas d\'ajouter un nouvel oprateur aux groupes et/ou rles',
        'Please enter a search term to look for agents.' => 'Merci d\'entrer un motid de recherche pour chercher des oprateurs',
        'Last login' => 'Dernire connexion',
        'Login as' => 'Connect en tant que',
        'Switch to agent' => 'Changer d\'oprateur vers',
        'Add Agent' => 'Ajouter un oprateur',
        'Edit Agent' => 'Modifier l\'oprateur ',
        'Firstname' => 'Prnom',
        'Lastname' => 'Nom',
        'Password is required.' => '',
        'Start' => 'Dmarrer',
        'End' => 'Fin',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => 'Grer Relations oprateur-Groupe',
        'Change Group Relations for Agent' => '',
        'Change Agent Relations for Group' => '',
        'note' => 'note',
        'Permissions to add notes to tickets in this group/queue.' => 'Permissions d\'ajouter des notes aux tickets dans ce groupe/cette file',
        'owner' => 'propritaire',
        'Permissions to change the owner of tickets in this group/queue.' => 'Permissions de changer le propritaire des tickets dans ce gorupe/cette file.',

        # Template: AgentBook
        'Address Book' => 'Carnet d\'adresses',
        'Search for a customer' => 'Chercher un client',
        'Add email address %s to the To field' => '',
        'Add email address %s to the Cc field' => '',
        'Add email address %s to the Bcc field' => '',
        'Apply' => 'Appliquer',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Recherche de client',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Tableau de bord',
        'Show or hide the content' => 'Montrer ou cacher le contenu',

        # Template: AgentDashboardCalendarOverview
        'in' => 'in',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s est disponible !',
        'Please update now.' => 'Merci de mettre  jour maintenant',
        'Release Note' => 'Note de version',
        'Level' => 'Niveau',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Envoy il y a %s',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => 'Le ticket a t verrouill',
        'Undo & close window' => 'Annuler et fermer la fentre',

        # Template: AgentInfo
        'Info' => 'Information',
        'To accept some news, a license or some changes.' => 'Pour accepter des nouvelles, une licence ou des modifications.',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Lier l\'Objet: %s',
        'Close window' => 'Fermer fentre',
        'go to link delete screen' => '',
        'Select Target Object' => 'Slectionner l\'Objet cible',
        'Link Object' => 'Lier l\'objet',
        'with' => 'avec',
        'Unlink Object: %s' => 'Dlier l\'objet: %s',
        'go to link add screen' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => 'Editer vos prfrences',

        # Template: AgentSpelling
        'Spell Checker' => 'Vrificateur orthographique',
        'spelling error(s)' => 'erreurs d\'orthographe',
        'Apply these changes' => 'Appliquer ces changements',

        # Template: AgentStatsDelete
        'Delete stat' => 'Supprimer stat',
        'Stat#' => 'Stat#',
        'Do you really want to delete this stat?' => 'Voulez-vous vraiment supprimer cette statistique?',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '',
        'General Specifications' => 'Spcifications Gnrales',
        'Select the element that will be used at the X-axis' => 'Slectionner l\'lement qui sera utilis pour l\'axe X',
        'Select the elements for the value series' => 'Slectionnez les lments de la srie de donnes',
        'Select the restrictions to characterize the stat' => 'Slectionner les restrictions pour caractriser cette statistique',
        'Here you can make restrictions to your stat.' => 'Vous pouvez ici appliquer des restrictions  vos statistiques.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Si vous enlevez la coche dans la case, l\'oprateur generant les statistiques peut changer les attributs de l\lement correspondant',
        'Fixed' => 'Fix',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Slectionnez un seul lment ou dsactivez le bouton \'Fix\'',
        'Absolute Period' => 'Priode Absolue',
        'Between' => 'Entre',
        'Relative Period' => 'Priode relative',
        'The last' => 'Le dernier',
        'Finish' => 'Terminer',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Permissions',
        'You can select one or more groups to define access for different agents.' => '',
        'Some result formats are disabled because at least one needed package is not installed.' => '',
        'Please contact your administrator.' => '',
        'Graph size' => 'Taille du graphique',
        'If you use a graph as output format you have to select at least one graph size.' => 'Si vous choisissez Graphe comme format de sortie, vous devez choisir la taille',
        'Sum rows' => 'Ligne de somme',
        'Sum columns' => 'Colonnes de somme',
        'Use cache' => 'Utiliser le cache',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'La plus grande part des stats peuvent tre mise en cache. Cela acclere leur prsentation',
        'If set to invalid end users can not generate the stat.' => 'Si mis  invalide, les utilisateurs finaux ne pourront pas gnrer la statistique.',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '',
        'You have the possibility to select one or two elements.' => '',
        'Then you can select the attributes of elements.' => '',
        'Each attribute will be shown as single value series.' => '',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'chelle',
        'minimal' => 'minimale',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'SVP, rappelez vous que la plage pour la srie de donnes doit tre plus grande que l\'echelle de l\'axe des X (ex. axe des X => Mois, Srie => Anne',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '',
        'maximal period' => 'priode minimale',
        'minimal scale' => 'chelle minimale',

        # Template: AgentStatsImport
        'Import Stat' => 'Importer Statistique',
        'File is not a Stats config' => 'Ce n\'est pas un fichier de configuration de statistiques',
        'No File selected' => 'Aucun fichier slectionn',

        # Template: AgentStatsOverview
        'Stats' => 'Statistiques',
        'Object' => 'Objet',

        # Template: AgentStatsPrint
        'Print' => 'Imprimer',
        'No Element selected.' => 'Aucun lment slectionn.',

        # Template: AgentStatsView
        'Export config' => 'Exporter la configuration',
        'With the input and select fields you can influence the format and contents of the statistic.' => '',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => '',
        'Stat Details' => 'Details de la statistique',
        'Format' => 'Format',
        'Graphsize' => 'Taille du graphique',
        'Cache' => 'Cache',
        'Exchange Axis' => 'changez les axes',
        'Configurable params of static stat' => 'Paramtres modifiables des statistiques',
        'No element selected.' => 'Aucun lment slectionn.',
        'maximal period from' => 'Priode maximale de',
        'to' => 'vers',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => 'Changer le Texte Libre du Ticket',
        'Change Owner of Ticket' => 'Changer le propritaire du Ticket',
        'Close Ticket' => 'Fermer le Ticket',
        'Add Note to Ticket' => 'Ajouter une Note au Ticket',
        'Set Pending' => 'Dfinir la mise en attente',
        'Change Priority of Ticket' => 'Changer la priorit du Ticket',
        'Change Responsible of Ticket' => 'Changer le responsable du Ticket',
        'Cancel & close window' => 'Annuler et fermer la fentre',
        'Service invalid.' => 'Service invalide',
        'New Owner' => 'Nouveau Propritaire',
        'Please set a new owner!' => 'Merci de renseigner un propritaire',
        'Previous Owner' => 'Propritaire Prcdent',
        'Inform Agent' => 'Informer l\'oprateur',
        'Optional' => 'Optionnel',
        'Inform involved Agents' => 'Informer les oprateurs impliqus',
        'Spell check' => 'Vrifier orthographe',
        'Note type' => 'Type de note',
        'Next state' => 'tat suivant',
        'Pending date' => 'Dlais d\'attente',
        'Date invalid!' => 'Date invalide',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket: ' => 'Renvoyer Ticket',
        'Bounce to' => 'Renvoyer ',
        'You need a email address.' => 'Vous devez avoir une adresse email',
        'Need a valid email address or don\'t use a local email address.' => 'Une adresse email valide est ncessaire ou n\'utilisez pas d\'adresse email locale.',
        'Next ticket state' => 'Prochain tat du ticket',
        'Inform sender' => 'Informer l\'emetteur',
        'Send mail!' => 'Envoyer le courriel!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Ticket en action groupe',
        'Merge to' => 'Fusionner avec',
        'Invalid ticket identifier!' => 'Identifiant de ticket invalide',
        'Merge to oldest' => 'Fusionner avec le plus ancien',
        'Link together' => 'Lier ensemble',
        'Link to parent' => 'Lier au parent',
        'Unlock tickets' => '',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Rdiger une rponse pour le ticket',
        'Need a valid email address.' => 'Une adresse email valide est ncessaire',
        'Address book' => 'Carnet d\'adresse',
        'Pending Date' => 'En attendant la date',
        'for pending* states' => 'pour tous les tats de mise en attente',
        'Date Invalid!' => 'Date invalide',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Changer le client du ticket',
        'Customer Data' => 'Donnes client',
        'Customer user' => 'Client Utilisateur',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => 'Crer un nouveau Ticket Email',
        'From queue' => 'De la file',
        'Get all' => 'Tout prendre',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: ' => '',
        'Need a valid email address or don\'t use a local email address' => 'Une adresse email valide est ncessaire ou n\'utilisez pas d\'adresse email locale',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Historique de',
        'History Content' => 'Contenu de l\'historique',
        'Zoom view' => 'Zoomer sur la vue',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Fusion de Ticket',
        'You need to use a ticket number!' => 'Vous devez utiliser un numro de ticket !',
        'A valid ticket number is required.' => 'Un numro de ticket valide est requis',

        # Template: AgentTicketMove
        'Move Ticket' => 'Changer la file du ticket',
        'New Queue' => 'Nouvelle File',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => 'Tout slectionner',
        'No ticket data found.' => '',
        'First Response Time' => 'Temps pour fournir la premire rponse (prise en compte)',
        'Service Time' => 'Temps pour le service',
        'Update Time' => 'Temps pour fournir un point d\'avancement',
        'Solution Time' => 'Temps pour fournir la rponse',
        'Move ticket to a different queue' => 'Dplacer ticket vers une autre file',
        'Change queue' => 'Changer de file',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Changer les options de recherche',
        'Tickets per page' => '',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Remonte dans',
        'Locked' => 'Verrouill',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'Crer un nouveau Ticket tlphonique',
        'From customer' => 'Du client',
        'To queue' => 'Vers la file',

        # Template: AgentTicketPhoneOutbound
        'Phone call' => 'Appel tlphonique',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'Vue complte du texte de l\'email',
        'Plain' => 'Tel quel',
        'Download this email' => 'Tlcharg cet email',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Information du Ticket',
        'Accounted time' => 'Temp pass',
        'Linked-Object' => 'Objet li',
        'by' => 'par',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Profil de recherche',
        'Create Template' => 'Crer Template',
        'Create New' => 'Crer nouveau',
        'Profile link' => '',
        'Save changes in template' => '',
        'Add another attribute' => 'Ajouter un autre attribut',
        'Output' => 'Format du rsultat',
        'Fulltext' => 'Texte Complet',
        'Remove' => 'Supprimer',
        'Customer User Login' => 'Nom de connexion du client',
        'Time1' => '',
        'Time2' => '',
        'Time3' => '',
        'Time4' => '',
        'Time5' => '',
        'Time6' => '',
        'Created in Queue' => 'Cr dans la file',
        'Lock state' => 'tat verrouill',
        'Watcher' => 'Surveillance',
        'Article Create Time (before/after)' => '',
        'Article Create Time (between)' => '',
        'Ticket Create Time (before/after)' => '',
        'Ticket Create Time (between)' => '',
        'Ticket Change Time (before/after)' => '',
        'Ticket Change Time (between)' => '',
        'Ticket Close Time (before/after)' => '',
        'Ticket Close Time (between)' => '',
        'Archive Search' => 'Recherche Archive',
        'Run Search' => 'Excuter recherche',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => 'Filtre Archive',
        'Article Type' => 'Type d\'Article',
        'Sender Type' => '',
        'Save filter settings as default' => 'Sauvegarder les paramtres de filtrage comme paramtres par dfaut',
        'Ticket Information' => '',
        'Linked Objects' => 'Objets lis',
        'Article(s)' => 'Article(s)',
        'Change Queue' => 'Modifier file',
        'Article Filter' => '',
        'Add Filter' => 'Ajouter filtre',
        'Set' => 'Assigner',
        'Reset Filter' => 'Rinitialiser filtre',
        'Show one article' => 'Montrer un article',
        'Show all articles' => 'Montrer tous les articles',
        'Unread articles' => 'Articles non lus',
        'No.' => 'Non.',
        'Unread Article!' => 'Article non lu!',
        'Incoming message' => '',
        'Outgoing message' => '',
        'Internal message' => '',
        'Resize' => '',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => 'Pour protger votre vie prive, les contenus actifs ou distants ont t bloqus.',
        'Load blocked content.' => 'Charger contenu bloqu',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => 'Trace du retour d\'erreur',

        # Template: CustomerFooter
        'Powered by' => 'Fonction assure par',
        'One or more errors occurred!' => '',
        'Close this dialog' => 'Fermer cette fentre de dialogue',
        'Could not open popup window. Please disable any popup blockers for this application.' => '',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'S\'authentifier',
        'User name' => '',
        'Your user name' => '',
        'Your password' => '',
        'Forgot password?' => 'Mot de passe oubli?',
        'Log In' => '',
        'Not yet registered?' => 'Pas encore enregistr?',
        'Sign up now' => 'Enregistrez-vous maintenant',
        'Request new password' => 'Demande de nouveau mot de passe',
        'Your User Name' => 'Votre nom',
        'A new password will be sent to your email address.' => '',
        'Create Account' => 'Crer un compte',
        'Please fill out this form to recieve login credentials.' => '',
        'How we should address you' => '',
        'Your First Name' => 'Votre prnom',
        'Please supply a first name' => '',
        'Your Last Name' => 'Votre nom de famille',
        'Please supply a last name' => '',
        'The User Name you wish to have' => 'Le nom d\'utilisateur que vous souhaitez avoir',
        'Please supply a' => '',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => 'Editer les prfrences',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => '',

        # Template: CustomerTicketOverView
        'Welcome!' => '',
        'Please click the button below to create your first ticket.' => '',
        'Create your first ticket' => '',

        # Template: CustomerTicketPrint
        'Ticket Print' => '',

        # Template: CustomerTicketSearch
        'Profile' => 'Profil',
        'e. g. 10*5155 or 105658*' => 'i.e. 10*5155 or 105658*',
        'Customer ID' => 'ID Client',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => 'Recherche plein texte dans les tickets (i.e. "John*n" or "Will*")',
        'Recipient' => 'Destinataire',
        'Carbon Copy' => 'Copie Carbone',
        'Time restrictions' => 'Restrictions de temps',
        'Only tickets created' => 'Seulement les tickets crs',
        'Only tickets created between' => 'Seulement les tickets crs entre',
        'Search-Profile as Template?' => 'Profile de recherche comme Template?',
        'Save as Template?' => 'Sauver comme Template',
        'Save as Template' => '',
        'Template Name' => 'Nom du Template',
        'Pick a profile name' => '',
        'Output to' => 'Sortie vers',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'de',
        'Page' => 'Page',
        'Search Results for' => 'Rsultats de recherche pour',

        # Template: CustomerTicketZoom
        'Expand article' => '',
        'Reply' => 'Rpondre',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => '',
        'Previous' => 'Prcdent',
        'Sunday' => 'Dimanche',
        'Monday' => 'Lundi',
        'Tuesday' => 'Mardi',
        'Wednesday' => 'Mercredi',
        'Thursday' => 'Jeudi',
        'Friday' => 'Vendredi',
        'Saturday' => 'Samedi',
        'Su' => 'Di',
        'Mo' => 'Lu',
        'Tu' => 'Ma',
        'We' => 'Me',
        'Th' => 'Je',
        'Fr' => 'Ve',
        'Sa' => 'Sa',
        'Open date selection' => 'Selection date d\'ouverture',

        # Template: Error
        'Oops! An Error occurred.' => 'Oups! Une erreur est survenue.',
        'Error Message' => 'Message d\'Erreur',
        'You can' => 'Vous pouvez',
        'Send a bugreport' => 'Envoyer un rapport de bug',
        'go back to the previous page' => 'iRevenir  la page prcdente',
        'Error Details' => 'Dtails de l\'erreur',

        # Template: Footer
        'Top of page' => 'Haut de la page',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => 'Si vous quittez cette page maintenant, toutes les fentres popup seront closes galement!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'Vous tes connect en',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'JavaScript non disponible',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'Pour utiliser OTRS, vous devez activer le JavaScript dans votre navigateur.',
        'Database Settings' => '',
        'General Specifications and Mail Settings' => '',
        'Welcome to %s' => 'Bienvenue dans %s',
        'Web site' => '',
        'Database check successful.' => 'Contrle de base de donne effectu avec succs.',
        'Mail check successful.' => 'Contrle de mail effectu avec succs.',
        'Error in the mail settings. Please correct and try again.' => 'Erreur dans la configuration email. Merci de corriger et de ressayer.',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => 'Configurer le mail sortant',
        'Outbound mail type' => 'Type de mail sortant',
        'Select outbound mail type.' => 'Slectionner le type de mail sortant',
        'Outbound mail port' => '',
        'Select outbound mail port.' => '',
        'SMTP host' => 'Hte SMTP',
        'SMTP host.' => 'Hte SMTP.',
        'SMTP authentication' => 'Authentification SMTP',
        'Does your SMTP host need authentication?' => 'Est-ce-que votre hte SMTP supporte l\'authentification?',
        'SMTP auth user' => 'Utilisateur auth SMTP',
        'Username for SMTP auth.' => 'Nom utilisateur pour auth SMTP.',
        'SMTP auth password' => 'Mot de passe auth SMTP',
        'Password for SMTP auth.' => 'Mot de passe pour autgh SMTP.',
        'Configure Inbound Mail' => 'Configurer mail entrant',
        'Inbound mail type' => 'Type de mail entrant',
        'Select inbound mail type.' => 'Slectionner le type de mail entrant',
        'Inbound mail host' => 'Hte mail entrant',
        'Inbound mail host.' => 'Hte mail entrant.',
        'Inbound mail user' => 'Utilisateur mail entrant',
        'User for inbound mail.' => 'Utilisateuyr pour mail entrant.',
        'Inbound mail password' => 'Mot de passe mail entrant',
        'Password for inbound mail.' => 'Mot de passe pour mail entrant.',
        'Result of mail configuration check' => 'Rsultat du contrle de configuration mail',
        'Check mail configuration' => 'Vrifier la configuration mail',
        'Skip this step' => 'Passer cette tape',

        # Template: InstallerDBResult
        'False' => 'Faux',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Si vous avez un mot de passe pour le compte root de votre base de donnes, il doit tre saisi ici. Sinon, laissez ce champ vide. Pour des raisons de scurit, nous vous recommandons de mettre un mot de passe pour le compte root. Pour plus d\'information, referez vous svp  la documentation de votre gestionnaire de base de donnes.',
        'Currently only MySQL is supported in the web installer.' => 'Pour le moment, seul MySQL est support pour cet installateur web.',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => '',
        'Database-User' => 'Nom de l\'utilisateur de la base de donne',
        'New' => 'Nouveau',
        'A new database user with limited rights will be created for this OTRS system.' => 'Un nouvel utilisateur de la base de donnes sera cr avec des droits limits pour ce systme OTRS.',
        'default \'hot\'' => '\'hot\' par dfaut',
        'DB--- host' => '',
        'Database' => 'Base de donne',
        'Check database settings' => 'Vrifier la configuration base de donnes',
        'Result of database check' => 'Rsultat du contrle de la base de donnes',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Pour pouvoir utiliser OTRS, vous devez entrer les commandes suivantes dans votre terminal en tant que root.',
        'Restart your webserver' => 'Redmarrer votre serveur web',
        'After doing so your OTRS is up and running.' => 'Aprs avoir fait ceci votre OTRS est en service',
        'Start page' => 'Page de dmarrage',
        'Your OTRS Team' => 'Votre quipe OTRS',

        # Template: InstallerLicense
        'Accept license' => 'Accepter la licence',
        'Don\'t accept license' => 'Ne pas accepter la licence',

        # Template: InstallerLicenseText

        # Template: InstallerSystem
        'SystemID' => 'ID Systme',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => '',
        'System FQDN' => 'Nom de Domaine complet du systme',
        'Fully qualified domain name of your system.' => '',
        'AdminEmail' => 'Adresse lectronique de l\'administrateur.',
        'Email address of the system administrator.' => '',
        'Organization' => 'Socit',
        'Log' => 'Log',
        'LogModule' => 'Module de log',
        'Log backend to use.' => '',
        'LogFile' => 'Fichier de log',
        'Log file location is only needed for File-LogModule!' => '',
        'Webfrontend' => 'Frontal web',
        'Default language' => 'Langue par dfaut',
        'Default language.' => '',
        'CheckMXRecord' => 'Vrifier les enregistrements MX',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => '',

        # Template: LinkObject
        'Object#' => '',
        'Add links' => '',
        'Delete links' => 'Supprimer les liens',

        # Template: Login
        'JavaScript Not Available' => 'JavaScript non disponible',
        'Browser Warning' => 'Avertissement du novagateur',
        'The browser you are using is too old.' => 'Votre navigateur est trop ancien.',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => 'OTRS tourne sur un grand nombre de navigateurs, merci de mettre  jour votre navigateur vers l\'un de ceux-ci.',
        'Please see the documentation or ask your admin for further information.' => 'Merci de se rfrer  la documentation ou demander  votre administrateur systme pour de plus amples informations.',
        'Lost your password?' => 'Mot de passe oubli ?',
        'Request New Password' => 'Demander un nouveau mot de passe',
        'Back to login' => 'Retour  la page de connexion',

        # Template: Motd
        'Message of the Day' => 'Message du jour',

        # Template: NoPermission
        'Insufficient Rights' => 'Droits insuffisants',
        'Back to the previous page' => 'Revenir  la page prcdente',

        # Template: Notify

        # Template: Pagination
        'Show first page' => '',
        'Show previous pages' => '',
        'Show page %s' => '',
        'Show next pages' => '',
        'Show last page' => '',

        # Template: PictureUpload
        'Need FormID!' => '',
        'No file found!' => '',
        'The file is not an image that can be shown inline!' => '',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'Imprim par :',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'Page de test d\'OTRS',
        'Welcome %s' => 'Bienvenue %s',
        'Counter' => 'Compteur',

        # Template: Warning
        'Go back to the previous page' => 'Revenir  la page prcdente',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => 'Module ACL qui autorise la fermture du ticket parent uniquement si tout ses enfants sont dj clos("Etat" montre quels tats ne sont pas disponibles pour le ticket parent tant que ses enfants ne sont pas clos).',
        'Activates TypeAhead for the autocomplete feature, that enables users to type in whatever speed they desire, without losing any information. Often this means that keystrokes entered will not be displayed on the screen immediately.' => 'Active la fonction TypeAhead pour l\'autocompltion. Ceci permet  l\'utilisateur de taper  la vitesse dsire sans perte d\'information. Souvent cela signifie que les caractres frapps ne seront pas affichs  l\'cran immdiatement.',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => 'Active un mchanisme de clignotement du nom de la file qui contient le plus vieux ticket.',
        'Activates lost password feature for agents, in the agent interface.' => 'Active la fonction de mot de passe perdu pour les oprateurs, dans l\'interface des oprateurs.',
        'Activates lost password feature for customers.' => 'Active la fonction fr mot de passe perdu pour les clients.',
        'Activates support for customer groups.' => 'Active le support pour les groupes de client.',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => 'Active le filtre d\'article dans la vue de zoom pour spcifier quels articles doivent tre montrs.',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => 'Active les thmes disponibles sur le systme. La valeur 1 le rend actif, 0 le dsactive.',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => 'Active le systme d\'archive de ticket pour acclrer le systme en dplaant des tickets qui ne sont pas du jour. Pour chercher dans ces tickets, le flag archive doit tre activ dans la recherche de ticket.',
        'Activates time accounting.' => 'Active la comptabilisation du temps',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => 'Ajoute l\'adresse email des clients en destinataire dans l\'cran de cration de l\'interface oprateur.',
        'Adds the one time vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 1. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 2. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 3. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 4. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 5. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 6. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 7. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 8. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances pour le calendrier 9. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 1. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 1. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 2. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 2. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 3. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 3. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 4. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 4. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 5. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 5. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 6. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 6. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 7. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 7. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 8. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 8. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days for the calendar number 9. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes pour le calendrier 9. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => 'Ajoute les jour de vacances permanentes. Merci d\'utiliser un seul chiffre pour les nombres de 1  9 (au lieu de 01 - 09).',
        'Agent Notifications' => 'Notifications pour les oprateurs',
        'Agent interface article notification module to check PGP.' => 'Module de notification d\'article dans l\'interface oprateur pour vrifier le PGP',
        'Agent interface article notification module to check S/MIME.' => 'Module de notification d\'article dans l\'interface oprateur pour vrifier le S/MIME',
        'Agent interface module to access fulltext search via nav bar.' => 'Module de l\'interface oprateur pour accder  la recherche plein texte dans la barre de navigation.',
        'Agent interface module to access search profiles via nav bar.' => 'Module de l\'interface oprateur pour accder  la recherche des profiles dans la barre de navigation.',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => 'Oprateurs <-> Groupes',
        'Agents <-> Roles' => '',
        'Allows adding notes in the close ticket screen of the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de fermeture du ticket dans l\'interface oprateur.',
        'Allows adding notes in the ticket free text screen of the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de champ libre du ticket dans l\'interface oprateur.',
        'Allows adding notes in the ticket note screen of the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de note du ticket dans l\'interface oprateur.',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de propritaire d\'un ticket zoom dans l\'interface oprateur.',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de mise en attente d\'un ticket zoom dans l\'interface oprateur.',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de priorit d\'un ticket zoom dans l\'interface oprateur.',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => 'Autorise l\'ajout de notes dans l\'cran de responsable d\'un ticket dans l\'interface oprateur.',
        'Allows agents to exchange the axis of a stat if they generate one.' => 'Autorise les oprateurs  changer les axes d\'une statistique si ils en gnrent une.',
        'Allows agents to generate individual-related stats.' => 'Autorise les oprateurs  gnrer des statistiques relatives  un individu.',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Article free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Article free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Article free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Attachments <-> Responses' => 'Pices jointes <-> Rponses',
        'Auto Responses <-> Queues' => '',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the ticket responsible!' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Christmas Eve' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => '',
        'Company Tickets' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event.' => '',
        'Configures a default TicketFreeField setting. "Counter" defines the free text field which should be used, "Key" is the TicketFreeKey, "Value" is the TicketFreeText and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => 'Crer et grer les contrats de niveau de support (SLAs).',
        'Create and manage agents.' => 'Crer et grer les oprateurs.',
        'Create and manage attachments.' => 'Crer et grer les attachements.',
        'Create and manage companies.' => 'Crer et grer les entreprises.',
        'Create and manage customers.' => 'Crer et grer les clients.',
        'Create and manage event based notifications.' => 'Crer et grer les notifications venementielles.',
        'Create and manage groups.' => 'Crer et grer les groupes.',
        'Create and manage notifications that are sent to agents.' => 'Crer et grer les notifications envoyes aux oprateurs.',
        'Create and manage queues.' => 'Crer et grer les files.',
        'Create and manage response templates.' => 'Crer et grer les templates de rponse.',
        'Create and manage responses that are automatically sent.' => 'Crer et grer  les rponses envoyes automatiquement.',
        'Create and manage roles.' => 'Crer et grer les rles.',
        'Create and manage salutations.' => 'Crer et grer les en-ttes.',
        'Create and manage services.' => 'Crer et grer les services.',
        'Create and manage signatures.' => 'Crer et grer les signatures.',
        'Create and manage ticket priorities.' => 'Crer et grer les priorits de ticket.',
        'Create and manage ticket states.' => 'Crer et grer les tats de ticket.',
        'Create and manage ticket types.' => 'Crer et grer les types de ticket.',
        'Create new email ticket and send this out (outbound)' => 'Crer un nouvel ticket par email et l\'envoyer (sortant)',
        'Create new phone ticket (inbound)' => 'Crer un nouveau ticket par tlphone (entrant)',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => 'Icon de l\'entreprise  montrer dnas le ticket pour ce client dnas le bloc d\'information.',
        'Customers <-> Groups' => 'Clients <-> Groupes',
        'Customers <-> Services' => 'Clients <-> Services',
        'Data used to export the search result in CSV format.' => 'Donnes utilises pour exporter les rsultats de recherche dans le format CSV.',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => 'ACL par dfaut pour les actions du ticket.',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => 'ID de file par dfaut utilise par le systme dans l\'interface oprateur.',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => 'Habillage par dfaut pour l\'interface.',
        'Default ticket ID used by the system in the agent interface.' => 'ID de ticket par dfaut utilis par le systme dans l\'interface oprateur.',
        'Default ticket ID used by the system in the customer interface.' => 'ID de ticket par dfaut utilis par le systme dans l\'interface client.',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => 'Dfini un lment client qui gnre un icone LinkedIn  la fin du bloc d\'information client.',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => 'Dfini un lment client qui gnre un icone XING  la fin du bloc d\'information client.',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => 'Dfini un lment client qui gnre un icone Google  la fin du bloc d\'information client.',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => 'Dfini un lment client qui gnre un icone Google Maps  la fin du bloc d\'information client.',
        'Defines a default list of words, that are ignored by the spell checker.' => 'Dfini une liste de mots ignors par le correcteur orthographique.',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => 'Dfini tous les X-headers qui doivent tre analyss',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default selection of the free key field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free key field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 1 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 10 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 11 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 12 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 13 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 14 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 15 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 16 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 2 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for articles (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 3 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 4 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 5 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 6 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 7 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 8 for tickets (if more than one option is provided).' => '',
        'Defines the default selection of the free text field number 9 for tickets (if more than one option is provided).' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the difference from now (in seconds) of the free time field number 1\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 2\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 3\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 4\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 5\'s default value.' => '',
        'Defines the difference from now (in seconds) of the free time field number 6\'s default value.' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the free key field number 1 for articles to add a new article attribute.' => '',
        'Defines the free key field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 2 for articles to add a new article attribute.' => '',
        'Defines the free key field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 3 for articles to add a new article attribute.' => '',
        'Defines the free key field number 3 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free key field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 1 for articles to add a new article attribute.' => '',
        'Defines the free text field number 1 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 10 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 11 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 12 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 13 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 14 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 15 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 16 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 2 for articles to add a new article attribute.' => '',
        'Defines the free text field number 2 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 3 for articles to add a new article attribute.' => '',
        'Defines the free text field number 3 for ticket to add a new ticket attribute.' => '',
        'Defines the free text field number 4 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 5 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 6 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 7 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 8 for tickets to add a new ticket attribute.' => '',
        'Defines the free text field number 9 for tickets to add a new ticket attribute.' => '',
        'Defines the free time key field number 1 for tickets.' => '',
        'Defines the free time key field number 2 for tickets.' => '',
        'Defines the free time key field number 3 for tickets.' => '',
        'Defines the free time key field number 4 for tickets.' => '',
        'Defines the free time key field number 5 for tickets.' => '',
        'Defines the free time key field number 6 for tickets.' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the calendar number 1, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 2, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 3, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 4, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 5, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 6, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 7, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 8, to count the working time.' => '',
        'Defines the hours and week days of the calendar number 9, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the http link for the free text field number 1 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 10 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 11 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 12 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 13 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 14 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 15 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 16 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 2 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 3 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 4 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 5 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 6 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 7 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 8 for tickets (it will be used in every ticket view).' => '',
        'Defines the http link for the free text field number 9 for tickets (it will be used in every ticket view).' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the calendar number 1.' => '',
        'Defines the name of the calendar number 2.' => '',
        'Defines the name of the calendar number 3.' => '',
        'Defines the name of the calendar number 4.' => '',
        'Defines the name of the calendar number 5.' => '',
        'Defines the name of the calendar number 6.' => '',
        'Defines the name of the calendar number 7.' => '',
        'Defines the name of the calendar number 8.' => '',
        'Defines the name of the calendar number 9.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the sender for rejected emails.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time zone of the calendar number 1, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 2, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 3, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 4, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 5, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 6, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 7, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 8, which can be assigned later to a specific queue.' => '',
        'Defines the time zone of the calendar number 9, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 1.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 2.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 3.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 4.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 5.' => '',
        'Defines the years (in future and in past) which can get selected in free time field number 6.' => '',
        'Defines whether the free time field number 1 is optional or not.' => '',
        'Defines whether the free time field number 2 is optional or not.' => '',
        'Defines whether the free time field number 3 is optional or not.' => '',
        'Defines whether the free time field number 4 is optional or not.' => '',
        'Defines whether the free time field number 5 is optional or not.' => '',
        'Defines whether the free time field number 6 is optional or not.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Delay time between autocomplete queries in milliseconds.' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statatistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Email Addresses' => 'Adresses lectroniques',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => '',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all TicketFreeField elements need the same event.' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => '',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => '',
        'First Christmas Day' => '',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => '',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => '',
        'GenericAgent' => 'Automate gnrique',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If configured, all emails sent by the application will contain an X-Header with this organization or company name.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => '',
        'International Workers\' Day' => '',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => '',
        'Link agents to roles.' => '',
        'Link attachments to responses templates.' => '',
        'Link customers to groups.' => '',
        'Link customers to services.' => '',
        'Link queues to auto responses.' => '',
        'Link responses to queues.' => '',
        'Link roles to groups.' => '',
        'Link this ticket to other objects!' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'Log file for the ticket counter.' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => '',
        'Manage POP3 or IMAP accounts to fetch email from.' => '',
        'Manage S/MIME certificates for email encryption.' => '',
        'Manage existing sessions.' => '',
        'Manage periodic tasks.' => '',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to inform agents, via the agent interface, about the used charset. A notification is displayed, if the default charset is not used, e.g. in tickets.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'My Tickets' => '',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New Year\'s Day' => '',
        'New Year\'s Eve' => '',
        'New email ticket' => '',
        'New phone ticket' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => 'Notification (Evenement)',
        'Number of displayed tickets' => '',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => '',
        'Overview of all open Tickets.' => '',
        'PGP Key Upload' => '',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'PostMaster Filters' => '',
        'PostMaster Mail Accounts' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => '',
        'QueueView Refresh Time' => '',
        'Refresh interval' => '',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Rponses <-> Files',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Rles <-> Groupes',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Second Christmas Day' => '',
        'Select your frontend Theme.' => 'Choix du thme de l\'interface',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => '',
        'Send notifications to users.' => '',
        'Send ticket follow up notifications' => '',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => '',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default charset for the web interface to use (should represent the charset used to create the database or, in some cases, the database management system being used). "utf-8" is a good choice for environments expecting many charsets. You can specify another charset here (i.e. "iso-8859-1"). Please be sure that you will not be receiving foreign emails, or text, otherwise this could lead to problems.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => '',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Statistics' => '',
        'Status view' => '',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown in the header of the customer interface. The URL to the image must be a relative URL to the skin image directory.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'Ticket free text options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free text options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free text options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket free time options shown in the close ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the email ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the move ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the phone ticket screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Ticket free time options shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket owner screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket pending screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket priority screen of a zoomed ticket in the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Ticket free time options shown in the ticket search of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Ticket free time options shown in the ticket search screen in the customer interface. Possible settings: 0 = Disabled and 1 = Enabled.' => '',
        'Ticket overview' => 'Rsum du Ticket',
        'Tickets' => 'Ticket',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => 'Temps en secondes  ajouter  l\'heure actuelle dans le cas dans tat en attente (dfaut: 86400 = 1 jour)',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => 'Types',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => '',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => 'Voir les rsultats du benchmark de performance.',
        'View system log messages.' => 'Voir les messages de log systme',
        'Wear this frontend skin' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => 'Votre langue',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        ' Param 1 value' => 'Valeur Paramtre 1',
        ' Param 2 value' => 'Valeur Paramtre 2',
        ' Param 3 value' => 'Valeur Paramtre 3',
        ' Param 4 value' => 'Valeur Paramtre 4',
        ' Param 5 value' => 'Valeur Paramtre 5',
        ' Param 6 value' => 'Valeur Paramtre 6',
        '"}' => '"}',
        '%s Tickets affected! Do you really want to use this job?' => '%s tickets affects ! Voulez vous vraiment utiliser cette commande ?',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Verifie les enregistrements MX des adresses lectroniques utilises lors de la rdaction d\'une rponse. N\'utilisez pas la "Vrification des enregistrements MX" si votre serveur OTRS est derrire une ligne modem $!',
        '(Email of the system admin)' => '(Adresse lectronique de l\'administrateur systme)',
        '(Full qualified domain name of your system)' => '(Nom de domaine complet de votre machine)',
        '(Logfile just needed for File-LogModule!)' => '(fichier de log ncessaire pour le Module File-Log !)',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'Note: Le nombre d\'objets dynamiques que vous pouvez utiliser dpend de votre configuration technique',
        '(Note: Useful for big databases and low performance server)' => 'Note: utile pour les bases de donnes volumineuses et les serveurs peu performants',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(L\'identit du systme. Chaque numro de ticket et chaque id de session http commence avec ce nombre)',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identifiant des tickets. Certaines personnes veulent le configurer avec par ex: \'Ticket#\', \'Appel#\' ou \'MonTicket#\')',
        '(Used default language)' => '(Langage par dfaut utilis)',
        '(Used log backend)' => '(Backend de log utilis)',
        '(Used ticket number format)' => '(Format numrique utilis pour les tickets)',
        'A article should have a title!' => 'Un article doit avoir un titre !',
        'A message must be spell checked!' => 'L\'orthographe d\'un courriel doit tre vrifie !',
        'A message should have a To: recipient!' => 'Un courriel doit avoir un destinataire (:) !',
        'A message should have a body!' => 'Un courriel doit avoir un corps !',
        'A message should have a customer!' => 'Un message doit avoir un client',
        'A message should have a subject!' => 'Un courriel doit avoir un sujet !',
        'A message should have a subject! .' => 'Un message doit avoir un sujet',
        'A new password will be sent to your e-mail adress.' => 'Un nouveau mot de passe sera envoy  votre adresse email.',
        'A required field is:' => 'Un champ requis est:',
        'A ticket should be associated with a queue!' => 'Un ticket doit tre associ  une file',
        'A ticket should have a type!' => 'Un ticket devrait avoir un type',
        'A web calendar' => 'Un calendrier Web',
        'A web file manager' => 'Un gestionnaire de fichier via le web',
        'A web mail client' => 'Un client de messagerie via le web',
        'About OTRS' => 'Au sujet \'OTRS',
        'Absolut Period' => 'Priode absolue',
        'Account Type' => 'Type de compte',
        'Add Customer User' => 'Ajouter un client',
        'Add System Address' => 'Ajouter une adresse systme',
        'Add User' => 'Ajouter un utilisateur',
        'Add a new Agent.' => 'Ajoute un nouvel oprateur.',
        'Add a new Customer Company.' => 'Ajouter un nouveau service',
        'Add a new Group.' => 'Ajouter un nouveau groupe',
        'Add a new Notification.' => 'Ajouter une nouvelle notification',
        'Add a new Priority.' => 'Ajouter une nouvelle priorit',
        'Add a new Role.' => 'Ajoute un nouveau rle.',
        'Add a new SLA.' => 'Ajouter un nouveau SLA',
        'Add a new Salutation.' => 'Ajoute un nouvel en-tte.',
        'Add a new Service.' => 'Ajoute un nouveau Service.',
        'Add a new Signature.' => 'Ajouter une nouvelle signature.',
        'Add a new State.' => 'Ajoute un nouvel tat.',
        'Add a new System Address.' => 'Ajoute une nouvelle adresse systme',
        'Add a new Type.' => 'Ajoute un nouveau Type.',
        'Add a new salutation' => 'Ajouter un nouvel en-tte',
        'Add mail adress %s to the Bcc field' => 'Ajouter adresse email %s a     u champ Bcc',
        'Add mail adress %s to the Cc field' => 'Ajouter adresse email %s a     u champ Cc',
        'Add mail adress %s to the To field' => 'Ajouter adresse email %s au champ To',
        'Add new attachment' => 'Ajouter un nouvel attachement',
        'Add note to ticket' => 'Ajouter une note au ticket',
        'Add to list of subscribed tickets' => 'iAjouter  la liste des tickets abonns',
        'Added User "%s"' => 'Ajout de l\'utilisateur "%s"',
        'Adds a suffix with the actual year and month to the otrs log file. A logfile for every month will be created.' => 'Ajoute un suffix avec l\'anne et le mois actuel au fichier de log otrs. Un fichier sera cr pour chaque mois.',
        'Admin-Area' => 'Zone d\'administration',
        'Admin-Email' => 'Adresse lectronique de l\'administrateur',
        'Admin-Password' => 'Mot de passe de l\'administrateur',
        'Admin-User' => 'Administrateur',
        'Admin-password' => 'Mot de passe Administrateur',
        'Advisory' => 'Avertissement',
        'Agent Mailbox' => 'Bote aux lettres de l\'oprateur',
        'Agent Preferences' => 'Prfrences de l\'oprateur',
        'Agent based' => 'Bas sur l\'oprateur',
        'Agent-Area' => 'Interface de l\'oprateur',
        'All Agents' => 'Tous les oprateurs',
        'All Customer variables like defined in config option CustomerUser.' => 'Toutes les variables client tels que dfinies dans les options "Client utilisateur"',
        'All customer tickets.' => 'Tous les tickets du client',
        'All email addresses get excluded on replaying on composing an email.' => 'Toutes les adresses lectroniques sont enleves lors du rejeu de la rdaction d\'un courriel',
        'All email addresses get excluded on replaying on composing and email.' => 'Toutes les adresses lectroniques sont enleves lors du rejeu de la rdaction d\'un courriel',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Tous les courriels avec cette adresse lectronique en destinataire (:) seront rpartis dans la file slectionne !',
        'All messages' => 'Tous les messages',
        'All new tickets!' => 'Tous les nouveaux tickets !',
        'All tickets where the reminder date has reached!' => 'Tous les tickets dont la date de rappel est atteinte',
        'All tickets which are escalated!' => 'Tous les tickets en escalade !',
        'Allocate %s to' => 'Allouer %s ',
        'Allocate CustomerUser to service' => 'Allouer le client utilisateur au service',
        'Allocate services to CustomerUser' => 'Allouer les services au client utilisateur',
        'An' => 'Un',
        'Answer' => 'Rponse',
        'Article Create Times' => 'Heures de cration d\'article',
        'Article created' => 'Article cr',
        'Article created between' => 'Article cr entre',
        'Article filter settings' => 'Paramtres de filtrage d\'article',
        'ArticleID' => 'Identifiant de l\'Article',
        'Attach' => 'Attacher',
        'Attribute' => 'Attributs',
        'Auto Response From' => 'Rponse automatique de ',
        'Bounce ticket' => 'Renvoyer le ticket',
        'CSV' => 'CSV',
        'Can not create link with %s!' => 'Impossible de crer un lien avec %s !',
        'Can not delete link with %s!' => 'Impossible d\'effacer le lien avec %s !',
        'Can\'t update password, invalid characters!' => 'Mise  jour du mot de passe impossible, caractres invalides !',
        'Can\'t update password, must be at least %s characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit avoir au moins %s caractres !',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 majuscules et 2 minuscules !',
        'Can\'t update password, needs at least 1 digit!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter un chiffre minimum !',
        'Can\'t update password, needs at least 2 characters!' => 'Mise  jour du mot de passe impossible, Le mot de passe doit comporter 2 caractres minimum !',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Mise  jour du mot de passe impossible, les mots de passe sont diffrents ! Essayez  nouveau svp !',
        'Category Tree' => 'Liste des catgories',
        'Change %s Relations for' => 'Modifier les Relations %s pour',
        'Change %s Relations for %s' => 'Modifier Relations %s pour %s',
        'Change %s settings' => 'Changer les param&ecirc;tres de %s',
        'Change Times' => 'Heures de modification',
        'Change free text of ticket' => 'Changer le texte libre du ticket',
        'Change owner of ticket' => 'Changer le propritaire du ticket',
        'Change priority of ticket' => 'Modification de la priorit du ticket',
        'Change responsible of ticket' => 'Changer le responsable du ticket',
        'Change roles <-> groups settings' => 'Changer les rles <-> paramtres des groupes',
        'Change user <-> group settings' => 'Modifier les paramtres utilisateurs <-> groupes',
        'Change users <-> roles settings' => 'Changement d\'utilisateur <-> paramtres des rles',
        'ChangeLog' => 'Enregistrement des changements',
        'Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behind a dial-up line!' => 'Vrifier les enregistrements MX des adresses email utilises en crant une rponse. N\'utilisez pas CheckMXRecord si votre machine OTRS se trouve derrire une ligne tlphonique.',
        'Child-Object' => 'Objet Enfant',
        'City{CustomerUser}' => 'Ville{CustomerUser}',
        'Clear From' => 'Vider le formulaire',
        'Clear To' => 'Effacer la zone de saisie "De:"',
        'Click here to report a bug!' => 'Cliquer ici pour signaler une anomalie !',
        'Close Times' => 'Temps de fermeture',
        'Close ticket' => 'Ticket clos',
        'Close type' => 'Type de clture',
        'Close!' => 'Clture!',
        'Collapse View' => 'Rduire',
        'Comment (internal)' => 'Commentaire interne',
        'Comment{CustomerUser}' => 'Commentaire{CustomerUser}',
        'CompanyTickets' => 'Tickets de l\'entreprise cliente',
        'Compose Answer' => 'Rdiger une rponse',
        'Compose Email' => 'crire un courriel',
        'Compose Follow up' => 'Rdiger une note de suivi',
        'Config Options' => 'Options de configuration',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Options de configuration (ex: &lt;OTRS_CONFIG_HttpType&gt;)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Options de configuration (ex: <OTRS_CONFIG_HttpType>)',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Proprits de la configuration',
        'Contact customer' => 'Contacter le client',
        'Country{CustomerUser}' => 'Pays{CustomerUser}',
        'Create New Template' => 'Crer nouveau Template',
        'Create Times' => 'Dates de cration',
        'Create new Phone Ticket' => 'Saisie d\'une demande tlphonique',
        'Create new database' => 'Crer une nouvelle base de donnes',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crer de nouveaux groupes permettra de grer les droits d\'accs pour les diffrents groupes de l\'oprateur (exemple: achats, comptabilit, support, ventes...).',
        'Create your first Ticket' => 'Crer votre premier Ticket',
        'Create/Expires' => 'Crer/Expirer',
        'CreateTicket' => 'Crer Ticket',
        'Customer Move Notify' => 'Notification lors d\'un changement de file',
        'Customer Owner Notify' => 'Notification lors d\'un changement de propritaire',
        'Customer State Notify' => 'Notification lors d\'un changement d\'tat',
        'Customer User' => 'Client Utilisateur',
        'Customer User Management' => 'Gestion des clients',
        'Customer Users' => 'Clients',
        'Customer Users <-> Groups' => 'Clients <-> Groupes',
        'Customer Users <-> Groups Management' => 'Clients <-> Gestion des groupes',
        'Customer Users <-> Services Management' => 'Client utilisateur <-> Gestion des Services',
        'Customer history' => 'Historique du client',
        'Customer history search' => 'Recherche dans l\'historique client',
        'Customer history search (e. g. "ID342425").' => 'Recherche dans l\'historique client (ex: "ID342425")',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Les clients seront invits  se connecter sur la page client.',
        'CustomerID{CustomerUser}' => 'ID client{CustomerUser}',
        'CustomerUser' => 'Client utilisateur',
        'D' => 'Z-A',
        'DB Admin Password' => 'Mot de passe administrateur base de donnes',
        'DB Admin User' => 'nom de connexion de l\'administrateur base de donne',
        'DB Host' => 'Nom d\'hte de la base',
        'DB Type' => 'Type de SGBD',
        'DB connect host' => 'Nom d\'hte de la base de donne',
        'Days' => 'Jours',
        'Default' => 'Dfaut',
        'Default Charset' => 'Charset par dfaut',
        'Default Language' => 'Langage par dfaut ',
        'Defines the default selection of the free field number 1 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 1 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 10 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 10 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 11 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 11 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 12 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 12 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 13 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 13 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 14 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 14 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 15 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 15 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 16 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 16 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 2 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 2 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 3 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 3 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 4 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 4 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 5 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 5 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 6 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 6 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 7 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 7 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 8 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 8 (si plus d\'une option est fournie).',
        'Defines the default selection of the free field number 9 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ libre numro 9 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 1 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 1 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 10 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 10 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 11 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 11 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 12 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 12 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 13 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 13 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 14 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 14 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 15 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 15 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 16 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 16 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 2 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 2 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 3 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 3 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 4 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 4 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 5 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 5 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 6 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 6 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 7 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 7 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 8 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 8 (si plus d\'une option est fournie).',
        'Defines the default selection of the free text field number 9 (if more than one option is provided).' => 'Dfini la slection par dfaut pour le champ texte libre numro 9 (si plus d\'une option est fournie).',
        'Delete old database' => 'Effacer l\'ancienne base de donnes',
        'Detail' => 'Dtail',
        'Diff' => 'Diff',
        'Discard all changes and return to the compose screen' => 'Annuler tous les changements et retourner  l\'cran de saisie',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Rpartir ou filtrer les courriels entrants en se basant sur les en-ttes (X-*) ! L\'utilisation d\'expressions rgulires est aussi possible.',
        'Do you really want to delete this Object?' => 'Voulez vous vraiment effacer cet objet ?',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Voulez-vous vraiment rinstaller ce paquet (Tous les changements manuels seront perdus) ?',
        'Don\'t forget to add a new user to groups and/or roles!' => 'N\'oubliez pas d\'ajouter un nouvel utilisateur  des groupes et/ou des rles !',
        'Don\'t forget to add a new user to groups!' => 'Ne pas oublier d\'ajouter un nouvel utilisateur aux groupes !',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Cela ne fonctionne pas avec l\'identifiant utilisateur 1 (Compte Systme) ! Veuillez crer un nouvel utilisateur !',
        'Download Settings' => 'Paramtres de tlchargement',
        'Download all system config changes.' => 'Tlcharger tous les changements de la configuration systme.',
        'Drop Database' => 'Effacer la base de donnes',
        'Dynamic-Object' => 'Objet dynamique',
        'Edit Article' => 'diter l\'article',
        'Edit default services.' => 'diter le Service par dfaut',
        'Email based' => 'Bas sur le courriel',
        'Email of the system admin.' => 'Email de l\'administrateur systme.',
        'Email{CustomerUser}' => 'Email{CustomerUser}',
        'Escaladed Tickets' => 'Tickets escalads',
        'Escalation - First Response Time' => 'Rmonte du ticket - Premier temps de rponse',
        'Escalation - Solution Time' => 'Escalade - chance pour la solution',
        'Escalation - Update Time' => 'Escalade - chance pour le suivi',
        'Escalation Times' => 'Temps d\'escalade',
        'Escalation time' => 'Dlai avant remonte du ticket',
        'Event is required!' => 'Un evenement est requis',
        'Expand View' => 'Afficher plus',
        'Explanation' => 'Explication',
        'Export Config' => 'Exporter la configuration',
        'FAQ Category' => 'Catgorie dans la FAQ',
        'FAQ History' => 'Historique de la FAQ',
        'FAQ Language' => 'Langue dans la FAQ',
        'FAQ Overview' => 'Vue d\'ensemble de la FAQ',
        'FAQ Search' => 'Chercher dans la FAQ',
        'FAQ Search Result' => 'Rsultat de la recherche dans la FAQ',
        'FAQ System History' => 'Historique systme de la FAQ',
        'FAQ-Area' => 'Foire Aux Questions',
        'FAQ-Article' => '(FAQ) Article',
        'FAQ-Search' => '(FAQ) Rechercher',
        'FAQ-State' => 'tat FAQ',
        'Fax{CustomerUser}' => 'Fax{CustomerUser}',
        'FileManager' => 'Gestionnaire de fichiers',
        'Filelist' => 'Liste des fichiers',
        'Filter for Language' => 'Filtre pour Langue',
        'Filtername' => 'Nom du filtre',
        'Firstname{CustomerUser}' => 'Prnom{CustomerUser}',
        'Follow up' => 'Note de suivi',
        'Follow up notification' => 'Notification de suivi',
        'For very complex stats it is possible to include a hardcoded file.' => 'Pour des statistiques trs complexes, il est possible d\'inclure un fichier dj encod',
        'Form' => 'Formulaire',
        'Foward ticket: ' => 'Faire suivre le ticket:',
        'Frontend' => 'Interface',
        'Full qualified domain name of your system.' => 'FQDN nom de domaine complet du systme.',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Recherche sur le texte d\'un article (ex: "Mar*in" or "Baue*")',
        'Go' => 'Valider',
        'Group Ro' => 'Groupe lecture seule',
        'Group based' => 'Bas sur le Groupe',
        'Group selection' => 'Slection du groupe',
        'HTML' => 'HTML',
        'Hash/Fingerprint' => 'Hash/Empreinte',
        'Have a lot of fun!' => 'Amusez vous bien !',
        'Have you lost your password?' => 'Perdu votre mot de passe?',
        'Help' => 'Aide',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => 'Ici vous pouvez dfinir les valeurs de sries. Vous pouvez slectionner un ou deux lments. Puis vous pouvez slectionner les attributs de ces lments. Chaque attribut sera affich comme une srie de valeur unique. Si vous ne slectionner aucun attribut, tous les attributs de l\'lment seront utiliss pour gnrer la statistique inasi que les nouveaux attributs ajouts depuis la dernire configuration.',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ici vous pouvez dfinir les sries de valeurs. Vous avez la possibilit de slectionner un ou deux lments. Ensuite vous pouvez slectionner les attributs des lments. Chaque attribut sera affich comme une srie  une valeur. Si vous ne slectionnez aucun attribut, tous les attributs de l\'lment seront utiliss si vous gnrez une statistique. De la mme faon si un nouvel attribut est ajout depuis la dernire configuration.',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => 'Ici vous pouvez dfinir l\'axe x. Vous pouvez slectionner un lement via les boutons radio. Si aucune slection n\'est faite, tous les attributs seront utiliss si vous gnrer une statistique ainsi que les nouveaux attributs ajouts depuis la dernire configuration.',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ici vous pouvez dfinir l\'axe x. Vous pouvez slectionner un lment par le bouton radio. Si aucune slection n\'est faite, tous les attributs de l\'lment seront utiliss si vous gnrez une statistique. De la mme faon si un nouvel attribut est ajout depuis la dernire configuration.',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Ici vous pouvez dfinir l\'axe des abcisses. Vous pouvez slectionner un lement via le bouton radio. Ensuite vous devez slectionner 2 attributs ou plus de cet lement',
        'Here you can insert a description of the stat.' => 'Vous pouvez insrer ici une description des statistiques.',
        'Here you can select the dynamic object you want to use.' => 'Ici vous pouvez slectionner l\'objet dynamique que vous voulez utiliser',
        'Home' => 'Accueil',
        'How we should adress you' => 'Comment doit-on vous contacter',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Si le mode scuris n\'est pas activ, activer le via le SysConfig car votre application est dj en train de tourner.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Si un nouveau fichier encod est disponible, cet attribut sera visible et vous pourrez le slectionner',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Si un ticket est cltur et que le client envoie une suite, le ticket sera verrouill pour l\'ancien propritaire',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Si une rponse n\'est pas apporte au ticket dans le temps imparti, seul ce ticket sera affich',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Si un oprateur verrouille un ticket et qu\'il/elle n\'envoie pas une rponse dans le temps imparti, le ticket sera dverrouill automatiquement. Le ticket sera alors visible par tous les autres oprateurs',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Si rien n\'est slectionn, il n\'y aura pas de droits dans ce groupe (Les tickets ne seront plus disponible pour l\'utilisateur).',
        'If there is an article added, such as a follow-up via e-mail or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => 'Si un article est ajout, tel un suivi par email ou via le portail client, le dlai d\'escalade est remis  zro. Si un contact client n\'est pas ajout  un ticket, soit par email externe ou tlphone, avant que le temps dfini ici expire, le ticket sera escalad.',
        'If you need the sum of every column select yes.' => 'Si vous avez besoin de la somme pour chaque colonne, choisissez Oui',
        'If you need the sum of every row select yes' => 'Si vous avez besoin de la somme pour chaque ligne, choisissez Oui',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Si vous utilisez RegExp, vous pouvez aussi tester la valeur entre () comme [***] dans \'Set\'.',
        'If you want to account time, please provide Subject and Text!' => 'Si vous voulez comptabiliser le temps, merci de fournir un sujet et un texte',
        'If you want to install OTRS on other database systems, please refer to the file README.database.' => 'Si vous souhaitez installer OTRS sur une autre base de donnes, merci de se rfrer au fichier README.database.',
        'Image' => 'Image',
        'Important' => 'Important',
        'In order to experience OTRS, you\'ll need to enable Javascript in your browser.' => 'Pour utiliser OTRS, vous devez activer le JavaScript dans votre navigateur.',
        'In this form you can select the basic specifications.' => 'Dans ce formulaire, vous pouvez choisir les caractristiques de base',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'Dans ce cas vous pouvez directement diter le trousseau de cl dans Kernel/Config.pm',
        'Information about the Stat' => 'Informations  propos de la statistique',
        'Insert of the common specifications' => 'Insertion des caractristiques communes',
        'Is Job Valid' => 'Cette tche est-elle valide',
        'Is Job Valid?' => 'Cette tche est-elle valide?',
        'It\'s useful for ASP solutions.' => 'C\'est utile pour les fournisseurs d\'applications.',
        'It\'s useful for a lot of users and groups.' => 'Pratique lorsqu\'on a beaucoup d\'utilisateurs et de groupes',
        'Job-List' => 'Liste de tches',
        'Keyword' => 'Mot cl',
        'Keywords' => 'Mots cls',
        'Last update' => 'Dernire mise  jour',
        'Lastname{CustomerUser}' => 'Nom{CustomerUser}',
        'Link Table' => 'Talbe des liens',
        'Link to Parent' => 'Lier au Parent',
        'LinkType' => 'Type de lien',
        'Linked as' => 'Lie en tant que',
        'Load Settings' => 'Charger les paramtres',
        'Loading' => 'En cours de chargement',
        'Logfile' => 'fichier de log',
        'Logfile just needed for File-LogModule!' => 'Fichier de log ncessaire pour le File-LogModule',
        'Logfile too large, you need to reset it!' => 'Fichier de log trop grand, une remise  zro est ncessaire !',
        'Login failed! Your username or password was entered incorrectly.' => 'La connexion a chou ! Votre nom d\'utilisateur ou votre mot de passe sont errons.',
        'Lookup' => 'Consulter',
        'Mail Management' => 'Gestion des courriels',
        'Mailbox' => 'Bote aux lettres',
        'Match' => 'Correspond',
        'Max. shown Tickets a page' => 'Nombre maximum de Tickets per page',
        'Message for new Owner' => 'Courriel pour le nouveau propritaire',
        'Message sent to' => 'Courriel envoy ',
        'Misc' => 'Divers',
        'Mobile{CustomerUser}' => 'Mobile{CustomerUser}',
        'Modified' => 'Modifi',
        'Modules' => 'Modules',
        'Move notification' => 'Notification de mouvement',
        'Multiple selection of the output format.' => 'Selection multiple du format de sortie',
        'MyTickets' => 'Mes tickets',
        'Name is required!' => 'Un nom est requis!',
        'Need a valid email address or don\'t use a local address!' => 'Une adresse email valide est ncessaire ou n\'utilisez pas d\'adresse email locale!',
        'Need a valid mail address or don\'t use a local email address' => 'Une adresse mail valide est ncessaire ou n\'utilisez pas d\'adresse email locale',
        'Need a valid mail address or don\'t use a local email address.' => 'Une adresse email valide est ncessaire ou n\'utilisez pas d\'adresse email locale.',
        'Need valid email address or don\'t use local address' => 'Une adresse memail valide est requise ou bien n\'utilisez pas d\'adresse locale',
        'New Agent' => 'Nouveau Oprateur',
        'New Customer' => 'Nouveau Client',
        'New FAQ Article' => '(FAQ) Nouvel article',
        'New Group' => 'Nouveau groupe',
        'New Group Ro' => 'Nouveau groupe (lecture seule)',
        'New Password' => 'Nouveau mot de passe',
        'New Priority' => 'Nouvelle Priorit',
        'New SLA' => 'Nouveau SLA',
        'New Service' => 'Nouveau Service',
        'New State' => 'Nouvel tat',
        'New Ticket Lock' => 'Nouveau Verrou',
        'New Title' => 'Nouveau Titre',
        'New Type' => 'Nouveau Type',
        'New account created. Sent Login-Account to %s.' => 'Nouveau compte cre. Identifiant envoy  %s',
        'New messages' => 'Nouveaux messages',
        'New password again' => 'Nouveau mot de passe (encore)',
        'No * possible!' => 'Pas de * possible!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Aucun paquet pour le Framework slectionn dans ce dpt en ligne, mais des paquets pour d\'autres Frameworks !',
        'No Packages or no new Packages in selected Online Repository!' => 'Pas de paquets ou de nouveaux paquets dans le dpot en ligne slectionn !',
        'No Permission' => 'Pas d\'autorisation',
        'No Ticket has been written yet.' => 'Aucun Ticket cr pour le moment',
        'No change time settings.' => 'Paramtrage de non modification d\'heure',
        'No matches found' => 'Aucun rsultat',
        'No means, send agent and customer notifications on changes.' => 'Non signifie : Envoyer un courriel  l\'oprateur et au client sur changement.',
        'No time settings.' => 'Pas de paramtre de temps',
        'Note' => 'Note',
        'Note Text' => 'Note',
        'Notification (Customer)' => 'Notification (Client)',
        'Notifications' => 'Notifications',
        'OTRS DB Name' => 'Nom de la base OTRS',
        'OTRS DB Password' => 'Mot de passe de la base OTRS',
        'OTRS DB User' => 'Utilisateur de la base OTRS',
        'OTRS DB connect host' => 'Hte de la base OTRS',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envoi un courriel au client lorsque le ticket change de file.',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envoi un courriel au client lorsque le ticket change de propritaire.',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envoi un courriel au client lorsque le ticket change d\'tat.',
        'Object already linked as %s.' => 'Objet dj li en tant que %s',
        'Of couse this feature will take some system performance it self!' => 'Bien videmment, cette fonction consomme des ressources systme !',
        'One or more errors occured!' => 'Une ou plusieurs erreurs sont survenues',
        'Only for ArticleCreate Event.' => 'Seulement pour l\'vnement Cration d\'article',
        'Open Tickets' => 'Tickets ouverts',
        'Options ' => 'Options',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Options des donnes du client actuel (ex:  &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Options concernant les donnes du client actuel (ex: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Proprits des donnes personnelles du client',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Options concernant l\'utilisateur actuel ayant effectu cet action (ex: &lt;OTRS_CURRENT_UserFirstname&gt;)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Options concernant l\'utilisateur actuel ayant effectu cet action (ex: <OTRS_CURRENT_UserFirstname>)',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Proprits du client qui a demand cette action (e. g. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Options des donnes du ticket (ex: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Options des donnes du ticket (ex:  <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Proprits du ticket',
        'Order' => 'Ordre',
        'Other Options' => 'Autres options',
        'Out Of Office' => 'Absent du bureau',
        'POP3 Account Management' => 'Gestion du compte POP3',
        'Package' => 'Paquet',
        'Param 1' => 'Paramtre 1',
        'Param 1 key' => 'Cl Paramtre 1',
        'Param 2' => 'Paramtre 2',
        'Param 2 key' => 'Cl Paramtre 2',
        'Param 3' => 'Paramtre 3',
        'Param 3 key' => 'Cl Paramtre 3',
        'Param 4' => 'Paramtre 4',
        'Param 4 key' => 'Cl Paramtre 4',
        'Param 5' => 'Paramtre 5',
        'Param 5 key' => 'Cl Paramtre 5',
        'Param 6' => 'Paramtre 6',
        'Param 6 key' => 'Cl Paramtre 6',
        'Parent-Object' => 'Objet Parent',
        'Password is already in use! Please use an other password!' => 'Mot de passe dj utilis ! Essayez en un autre svp !',
        'Password is already used! Please use an other password!' => 'Ce mot de passe a dj t utilis ! Essayez en un autre svp !',
        'Passwords doesn\'t match! Please try it again!' => 'Les mots de passes diffrent! Essayez de nouveau svp !',
        'Pending Times' => 'Dates d\'chance',
        'Pending messages' => 'Message en attente',
        'Pending type' => 'Type d\'attente',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Permissions. Vous pouvez slectionner un ou plusieurs groupes pour autoriser la consultation des statistiques pour diffrents oprateurs.',
        'Permissions to change the ticket owner in this group/queue.' => 'Permission de changer le propritaire d\'un ticket dans cette file/ce groupe.',
        'PhoneView' => 'Vue tlphone',
        'Phone{CustomerUser}' => 'Tlphone{CustomerUser}',
        'Please contact your admin' => 'Veuillez contacter votre admnistrateur',
        'Please enter subject.' => 'Merci d\'entrer le sujet',
        'Please provide a name.' => 'Merci de fournir un nom',
        'Please select a value' => 'Merci de choisir une valeur',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked !' => 'Veuillez slectionner un seul lment ou dsactiver le bouton \'Fixe\' l o le champ slectionn est en surbrillance ! ',
        'Prio' => 'Priorit',
        'Problem' => 'Problme',
        'Queue <-> Auto Responses Management' => 'Files <-> Gestion des rponses automatiques',
        'Queue ID' => 'Identifiant de la File',
        'Queue Management' => 'Gestion des files',
        'Queue is required.' => 'Une file est requise',
        'Queues <-> Auto Responses' => 'Files <-> Rponses automatiques',
        'Realname' => 'Vritable Nom',
        'Rebuild' => 'Re-construction',
        'Recipients' => 'Destinataires',
        'Refresh' => 'Rafrachir',
        'Reminder' => 'Rappel',
        'Reminder messages' => 'Message de rappel',
        'Remove from list of subscribed tickets' => 'Retirer de la liste des tickets abonns',
        'Remove this Search Term.' => 'Supprimer ce terme de recherche.',
        'Required Field' => 'Champ requis',
        'Required!' => 'Requis',
        'Response Management' => 'Gestion des rponses',
        'Responses <-> Attachments Management' => 'Rponses <-> Gestion des pices jointes',
        'Responses <-> Queue Management' => 'Rponses <-> Gestion des files',
        'Return to the compose screen' => 'Retourner  l\'cran de saisie',
        'Role' => 'Rles',
        'Roles <-> Groups Management' => 'Rles <-> Gestion des groupes',
        'Roles <-> Users' => 'Rles <-> oprateurs',
        'Roles <-> Users Management' => 'Rles <-> Gestion des utilisateurs',
        'Save Job as?' => 'Sauver la tche en tant que?',
        'Save Search-Profile as Template?' => 'Sauver le profil de recherche ?',
        'Schedule' => 'Planifier',
        'Search Result' => 'Rsultat de la recherche',
        'Search for' => 'Chercher ',
        'Search for customers (wildcards are allowed).' => 'Chercher des clients (les toiles sont autorises)',
        'Secure Mode need to be enabled!' => 'Le mode scuris doit tre activ !',
        'Select Box' => 'Requte SQL libre.',
        'Select Box Result' => 'Choisissez le rsultat',
        'Select Group' => 'Slectionner Groupe',
        'Select Source (for add)' => 'Slectionnez une source (pour ajout)',
        'Select group' => 'Slectionner le groupe',
        'Select the customeruser:service relations.' => 'Slectionnez les relations client:service.',
        'Select the element, which will be used at the X-axis' => 'Slectionnez l\'lment qui sera utilis pour l\'axe X',
        'Select the restrictions to characterise the stat' => 'Slectionnez les restrictions pour affiner les statistiques',
        'Select the role:user relations.' => 'Slection des relations role/utilisateur',
        'Select the user:group permissions.' => 'Slectionnez les permissions pour l\'utilisateur:groupe.',
        'Select your QueueView refresh time.' => 'Choix du dlai de rafrachissement de la vue des files',
        'Select your default spelling dictionary.' => 'Slectionnez votre correcteur orthographique par dfaut',
        'Select your frontend Charset.' => 'Choix du jeu de caractres de l\'interface',
        'Select your frontend QueueView.' => 'Choisissez votre interface de vue des files',
        'Select your frontend language.' => 'Choix de la langue de l\'interface',
        'Select your out of office time.' => 'Slectionnez vos heures d\'absence du bureau',
        'Select your screen after creating a new ticket.' => 'Slectionnez l\'cran qui sera affich aprs avoir cr un nouveau ticket.',
        'Selection needed' => 'Slection requise',
        'Send Administrative Message to Agents' => 'Envoyer un Message Administratif aux oprateurs',
        'Send Notification' => 'Envoyer une notification',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Me prvenir si un client envoie un suivi (follow-up) sur un ticket dont je suis propritaire.',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Envoyer une notification sur un ticked surveill comme pour un propritaire d\'un ticket',
        'Send no notifications' => 'Ne pas envoyer de notifications',
        'Sent new password to: %s' => 'Envoit du nouveau mot de passe : %s',
        'Sent password token to: %s' => 'Envoit du jeton : %s',
        'Sessions' => 'Sessions',
        'Set customer user and customer id of a ticket' => 'Assigner un utilisateur client et un identifiant client pour le ticket.',
        'Set new SLA' => 'Mettre nouvel SLA',
        'Show' => 'Voir',
        'Site' => 'Site',
        'Solution' => 'Solution',
        'Sort by' => 'Trier par',
        'Source' => 'Source',
        'Spell Check' => 'Vrification orthographique',
        'Split' => 'Scinder',
        'State Type' => 'Type d\'tat',
        'Static-File' => 'Fichier statique',
        'Stats-Area' => 'Statistiques',
        'Step %s of %s' => 'Etape %s de %s',
        'Street{CustomerUser}' => 'Rue{CustomerUser}',
        'Sub-Queue of' => 'Sous-file',
        'Sub-Service of' => 'Sous-service de',
        'Subscribe' => 'S\'abonner',
        'Symptom' => 'Symptme',
        'System History' => 'Historique du systme',
        'System State Management' => 'Gestion des tats du systme',
        'System Status' => 'tat du systme',
        'Systemaddress' => 'Adresse du Systme',
        'Termin1' => 'Termin1',
        'Text is required!' => 'Texte requis',
        'The Ticket was locked' => 'Le Ticket a t verrouill',
        'The customer id is required!' => 'L\'identifiant client est requis!',
        'The customer is required!' => 'Le client est requis!',
        'The customer is required.' => 'Le client est requis.',
        'The field is required.' => 'Le champ est obligatoire',
        'The identify of the system. Each ticket number and each http session id starts with this number.' => 'L\'idntit de ce systme. Chaque numro de ticket et chaque id de session http commence avec ce numro',
        'The message being composed has been closed.  Exiting.' => 'Le courriel en cours de rdaction a t cltur. Sortie.',
        'The subject is required!' => 'Sujet requis',
        'The subject is required.' => 'Le sujet est requis',
        'The text is required!' => 'Texte requis',
        'The text is required.' => 'Le texte est requis',
        'These values are read-only.' => 'Ces valeurs sont en lecture seule.',
        'These values are required.' => 'Ces valeurs sont obligatoires.',
        'They can be administrered through the configuration setting "CustomerGroupAlwaysGroups".' => 'Ils peuvent tre grer via l\'option de configuration "CustomerGroupAlwaysGroups".',
        'This account exists.' => 'Ce compte existe dj.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ceci est utilie si vous voulez que personne n\'obtienne les statistiques ou si elles ne sont pas encore configures',
        'This value is required' => 'Cette valeur est requise',
        'This window must be called from compose window' => 'Cette fentre doit tre appele depuis la fentre de rdaction',
        'Ticket Change Times (between)' => 'Date de modification du ticket (entre)',
        'Ticket Change Times (from moment)' => 'Date de modification du ticket ( partir de)',
        'Ticket Close Times (between)' => 'Date de fermeture du ticket (entre)',
        'Ticket Close Times (from moment)' => 'Date de fermeture du ticket ( partir de)',
        'Ticket Comands' => 'Commandes Ticket',
        'Ticket Create Times (between)' => 'Date de cration du ticket (entre)',
        'Ticket Create Times (from moment)' => 'Date de cration du ticket ( partir de)',
        'Ticket Lock' => 'Ticket verrouill',
        'Ticket Number Generator' => 'Gnrateur de numro pour les tickets',
        'Ticket Search' => 'Recherche de ticket',
        'Ticket Status View' => 'Vue de l\'tat du ticket',
        'Ticket Type is required!' => 'Le Type du Ticket est requis !',
        'Ticket add note' => 'Ajouter note au Ticket',
        'Ticket changed' => 'Ticket modifi',
        'Ticket changed between' => 'Ticket modifi entre',
        'Ticket escalation!' => 'Remonte du ticket !',
        'Ticket locked!' => 'Ticket verrouill !',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Options du propritaire du ticket (ex: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Options du propritaire d\'un ticket (ex: <OTRS_OWNER_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'Proprits du propritaire du ticket',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Proprits du responsable du ticket',
        'Ticket selected for bulk action!' => 'Ticket slectionn pour une action groupe !',
        'Ticket type is required.' => 'Le type du Ticket est requis',
        'Ticket unlock!' => 'Dverrouiller le ticket !',
        'Ticket#' => 'Ticket#',
        'Ticket-Area' => 'Tickets',
        'TicketFreeText' => 'Texte Libre du Ticket',
        'TicketID' => 'Identifiant du Ticket',
        'TicketZoom' => 'Vue en dtails',
        'Tickets shown' => 'Tickets affichs',
        'Tickets which need to be answered!' => 'Tickets en attente de rponse !',
        'Time units is a required field!' => 'L\'unit de temps est un champ obligatoire!',
        'Time units is a required field.' => 'L\'unit de temps est un champ obligatoire.',
        'Time units is required field.' => 'L\'unit de temps est un champ obligatoire',
        'Timeover' => 'Temp coul',
        'Times' => 'Fois',
        'Title is required.' => 'Un titre est requis',
        'Title of the stat.' => 'Titre des statistiques',
        'Title{CustomerUser}' => 'Titre{CustomerUser}',
        'Title{user}' => 'Titre{user}',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Pour avoir l\'attribut d\'article (i.e. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'pour avoir les attributs de l\'article (par ex. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> et <OTRS_CUSTOMER_Body>)',
        'Top of Page' => 'Haut de page',
        'Total hits' => 'Nombre de rsultats trouvs',
        'Type:' => 'Type:',
        'U' => 'A-Z',
        'Unable to parse Online Repository index document!' => 'Impossible d\'analyser l\'index du dpt en ligne !',
        'Uniq' => 'Unique',
        'Unlock Tickets' => 'Dverrouiller les Tickets',
        'Unsubscribe' => 'Se dsabonner',
        'Use utf-8 it your database supports it!' => 'Utilisez UTF-8 si votre base de donne le supporte !',
        'Useable options' => 'Options accessibles',
        'Used default language.' => 'Langue par dfaut utilise.',
        'Used log backend.' => 'Backend de log utilis.',
        'User Management' => 'Administration des utilisateurs',
        'User will be needed to handle tickets.' => 'Un utilisateur sera ncessaire pour grer les tickets.',
        'Username{CustomerUser}' => 'Nom utilisateur{CustomerUser}',
        'Users' => 'Utilisateurs',
        'Users <-> Groups' => 'Utilisateurs <-> Groupes',
        'Users <-> Groups Management' => 'Utilisateurs <-> Gestion des groupes',
        'Verify New Password' => 'Vrifier le nouveau mot de passe',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Attention, ces tickets seront ffacs de la base de donne ! Ils seront dfinitivement perdus !',
        'Watch notification' => 'Notification de suivi',
        'Web-Installer' => 'Installeur Web',
        'WebMail' => 'Webmail',
        'WebWatcher' => 'WebWatcher',
        'Welcome to OTRS' => 'Bienvenue dans OTRS',
        'Wildcards are allowed.' => 'Les toiles sont autorises',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'Il est impossible de produire des statistiques avec des donnes invalides.',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'Avec les champs de saisies et de slection vous pouvez configurer les statistiques selon vos besoins. Le fait de pouvoir diter ou non un lement d\'une requte de statistique dpend de l\'administrateur qui a configur cette requte.',
        'Yes means, send no agent and customer notifications on changes.' => 'Oui signifie : ne rien envoyer sur changement  l\'oprateur et au client.',
        'Yes, save it with name' => 'Oui, le sauver avec le nom',
        'You got new message!' => 'Vous avez un nouveau message !',
        'You have to select two or more attributes from the select field!' => 'Vous devez slectionner deux attributs ou plus !',
        'You need a To: recipient!' => 'Un destinaire To: est ncessaire!',
        'You need a To: recipient!.' => 'Un destinaire To: est ncessaire!.',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Il faut une adresse &ecute;lectronique dans le champ &Agrave;: (ex&nbsp;: client@exemple.fr)&nbsp;!',
        'You need a to: recipient!.' => 'Un destinataire to: est ncessaire',
        'You need min. one selected Ticket!' => 'Vous devez nommer au moins un Ticket !',
        'You need to account time!' => 'Vous devez comptabiliser le temps !',
        'You need to activate %s first to use it!' => 'Vous devez d\'abord activer %s pour l\'utiliser !',
        'Your Password' => 'Votre mot de passe',
        'Your email address is new' => 'Votre adresse lectronique est nouvelle',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Votre courriel concernant le ticket numro "<OTRS_TICKET> est rmis  "<OTRS_BOUNCE_TO>". Contactez cette adresse pour de plus amples renseignements',
        'Your own Ticket' => 'Votre propre ticket',
        'Zip{CustomerUser}' => 'Code postal{CustomerUser}',
        'accept license' => 'Accepter la licence',
        'customer realname' => 'nom rel du client',
        'delete' => 'supprimer',
        'delete links' => 'supprimer liens',
        'don\'t accept license' => 'Ne pas accepter la licence',
        'down' => 'vers le bas',
        'false' => 'faux',
        'for agent firstname' => 'pour le prnom de l\'oprateur',
        'for agent lastname' => 'pour le nom de l\'oprateur',
        'for agent login' => 'pour le nom de connexion (login) de l\'oprateur',
        'for agent user id' => 'pour l\'identifiant de l\'oprateur',
        'go back' => 'Retour arrire',
        'kill all sessions' => 'Terminer toutes les sessions',
        'kill session' => 'Supprimer la session',
        'maximal period form' => 'Formulaire de dure maximum',
        'modified' => 'modifi',
        'new ticket' => 'nouveau ticket',
        'next step' => 'tape suivante',
        'send' => 'envoyer',
        'sort downward' => 'Tri dcroissant',
        'sort upward' => 'Tri croissant',
        'to get the first 20 character of the subject' => 'pour avoir les 20 premiers caractres du sujet ',
        'to get the first 5 lines of the email' => 'pour avoir les 5 premires lignes du courriel',
        'to get the from line of the email' => 'pour avoir les lignes \'De\' du courriel',
        'to get the realname of the sender (if given)' => 'pour avoir le nom rel de l\'utilisateur (s\il est donn)',
        'up' => 'vers le haut',
        'utf8' => 'UTF-8',
        'x' => 'x',

    };
    # $$STOP$$
    return;
}

1;
