# --
# Kernel/Language/zh_CN.pm -  provides Chinese Simple language translation
# Copyright (C) 2005 zuowei <j2ee at hirain-sh.com>
# Copyright (C) 2008-2009 Never Min <never at qnofae.org>
# Copyright (C) 2009 Bin Du <bindu2008 at gmail.com>,
# Copyright (C) 2009 Yiye Huang <yiyehuang at gmail.com>
# Copyright (C) 2009 Qingjiu Jia <jiaqj at yahoo.com>
# --
# $Id: zh_CN.pm,v 1.69.2.1 2009/09/22 13:04:55 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::zh_CN;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.69.2.1 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sun Jul 19 12:24:20 2009

    # possible charsets
    $Self->{Charset} = ['GBK', 'GB2312', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = ' %A %Y/%M/%D %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => '',
        'No' => '',
        'yes' => '',
        'no' => 'δ',
        'Off' => '',
        'off' => '',
        'On' => '',
        'on' => '',
        'top' => '',
        'end' => 'ײ',
        'Done' => 'ȷ',
        'Cancel' => 'ȡ',
        'Reset' => '',
        'last' => '',
        'before' => '',
        'day' => '',
        'days' => '',
        'day(s)' => '',
        'hour' => 'Сʱ',
        'hours' => 'Сʱ',
        'hour(s)' => 'Сʱ',
        'minute' => '',
        'minutes' => '',
        'minute(s)' => '',
        'month' => '',
        'months' => '',
        'month(s)' => '',
        'week' => '',
        'week(s)' => '',
        'year' => '',
        'years' => '',
        'year(s)' => '',
        'second(s)' => '',
        'seconds' => '',
        'second' => '',
        'wrote' => 'д',
        'Message' => 'Ϣ',
        'Error' => '',
        'Bug Report' => 'Bug ',
        'Attention' => 'ע',
        'Warning' => '',
        'Module' => 'ģ',
        'Modulefile' => 'ģļ',
        'Subfunction' => 'ӹ',
        'Line' => '',
        'Setting' => '',
        'Settings' => '',
        'Example' => 'ʾ',
        'Examples' => 'ʾ',
        'valid' => 'Ч',
        'invalid' => 'Ч',
        '* invalid' => '* Ч',
        'invalid-temporarily' => 'ʱЧ',
        ' 2 minutes' => ' 2 ',
        ' 5 minutes' => ' 5 ',
        ' 7 minutes' => ' 7 ',
        '10 minutes' => '10 ',
        '15 minutes' => '15 ',
        'Mr.' => '',
        'Mrs.' => '',
        'Next' => 'һ',
        'Back' => '',
        'Next...' => 'һ...',
        '...Back' => '...',
        '-none-' => '--',
        'none' => '',
        'none!' => '!',
        'none - answered' => ' - Ѵ𸴵',
        'please do not edit!' => 'Ҫ༭!',
        'AddLink' => '',
        'Link' => '',
        'Unlink' => 'δ',
        'Linked' => '',
        'Link (Normal)' => ' ()',
        'Link (Parent)' => ' ()',
        'Link (Child)' => ' ()',
        'Normal' => '',
        'Parent' => '',
        'Child' => '',
        'Hit' => '',
        'Hits' => '',
        'Text' => '',
        'Standard' => '׼',
        'Lite' => '',
        'User' => 'û',
        'Username' => 'û',
        'Language' => '',
        'Languages' => '',
        'Password' => '',
        'Salutation' => 'ν',
        'Signature' => 'ǩ',
        'Customer' => 'ͻ',
        'CustomerID' => 'ͻ',
        'CustomerIDs' => 'ͻ',
        'customer' => 'ͻ',
        'agent' => '֧Ա',
        'system' => 'ϵͳ',
        'Customer Info' => 'ͻϢ',
        'Customer Company' => 'ͻλ',
        'Company' => 'λ',
        'go!' => 'ʼ!',
        'go' => 'ʼ',
        'All' => 'ȫ',
        'all' => 'ȫ',
        'Sorry' => 'Բ',
        'update!' => '!',
        'update' => '',
        'Update' => '',
        'Updated!' => 'Ѹ',
        'submit!' => 'ύ!',
        'submit' => 'ύ',
        'Submit' => 'ύ',
        'change!' => '޸!',
        'Change' => '޸',
        'change' => '޸',
        'click here' => '',
        'Comment' => 'ע',
        'Valid' => 'Ч',
        'Invalid Option!' => 'Чѡ!',
        'Invalid time!' => 'Чʱ!',
        'Invalid date!' => 'Ч!',
        'Name' => '',
        'Group' => '',
        'Description' => '',
        'description' => '',
        'Theme' => '',
        'Created' => '',
        'Created by' => '',
        'Changed' => '޸',
        'Changed by' => '޸',
        'Search' => '',
        'and' => '',
        'between' => '',
        'Fulltext Search' => 'ȫ',
        'Data' => '',
        'Options' => 'ѡ',
        'Title' => '',
        'Item' => 'Ŀ',
        'Delete' => 'ɾ',
        'Edit' => '༭',
        'View' => '鿴',
        'Number' => '',
        'System' => 'ϵͳ',
        'Contact' => 'ϵ',
        'Contacts' => 'ϵ',
        'Export' => '',
        'Up' => '',
        'Down' => '',
        'Add' => '',
        'Added!' => '!',
        'Category' => 'Ŀ¼',
        'Viewer' => '鿴',
        'Expand' => 'չ',
        'New message' => 'Ϣ',
        'New message!' => 'Ϣ!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Ȼظ TicketȻصͼ!',
        'You got new message!' => 'Ϣ!',
        'You have %s new message(s)!' => ' %s Ϣ!',
        'You have %s reminder ticket(s)!' => ' %s !',
        'The recommended charset for your language is %s!' => 'Եַ %s!',
        'Passwords doesn\'t match! Please try it again!' => '벻!',
        'Password is already in use! Please use an other password!' => '뱻ʹãʹ!',
        'Password is already used! Please use an other password!' => '뱻ʹãʹ!',
        'You need to activate %s first to use it!' => '%s ʹ֮ǰȼ!',
        'No suggestions' => '޽',
        'Word' => '',
        'Ignore' => '',
        'replace with' => '滻',
        'There is no account with that login name.' => 'ûûʻϢ.',
        'Login failed! Your username or password was entered incorrectly.' => '¼ʧܣû벻ȷ.',
        'Please contact your admin' => 'ϵϵͳԱ',
        'Logout successful. Thank you for using OTRS!' => 'ɹעллʹ!',
        'Invalid SessionID!' => 'ЧĻỰʶ!',
        'Feature not active!' => 'δ!',
        'Notification (Event)' => '֪ͨ¼',
        'Login is needed!' => 'Ҫȵ¼!',
        'Password is needed!' => 'Ҫ!',
        'License' => '֤',
        'Take this Customer' => 'ȡͻ',
        'Take this User' => 'ȡû',
        'possible' => '',
        'reject' => 'ܾ',
        'reverse' => '',
        'Facility' => '',
        'Timeover' => '',
        'Pending till' => 'ȴ',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ҫʹ UserID 1 (ϵͳ˺)! 봴һµû!',
        'Dispatching by email To: field.' => 'ʼ: .',
        'Dispatching by selected Queue.' => 'ʼѡ.',
        'No entry found!' => '!',
        'Session has timed out. Please log in again.' => 'Ựʱµ¼.',
        'No Permission!' => 'Ȩ!',
        'To: (%s) replaced with database email!' => 'To: (%s) ݿʼַ',
        'Cc: (%s) added database email!' => 'Cc: (%s) ݿʼַ!',
        '(Click here to add)' => '(˴)',
        'Preview' => 'Ԥ',
        'Package not correctly deployed! You should reinstall the Package again!' => 'չ! Ҫһ°װ',
        'Added User "%s"' => 'û "%s".',
        'Contract' => 'ͬ',
        'Online Customer: %s' => '߿ͻ: %s',
        'Online Agent: %s' => '߼֧Ա%s',
        'Calendar' => '',
        'File' => 'ļ',
        'Filename' => 'ļ',
        'Type' => '',
        'Size' => 'С',
        'Upload' => 'ϴ',
        'Directory' => 'Ŀ¼',
        'Signed' => 'ǩ',
        'Sign' => 'ǩ',
        'Crypted' => 'Ѽ',
        'Crypt' => '',
        'Office' => '칫',
        'Phone' => '绰',
        'Fax' => '',
        'Mobile' => 'ֻ',
        'Zip' => 'ʱ',
        'City' => '',
        'Street' => 'ֵ',
        'Country' => '',
        'Location' => '',
        'installed' => 'Ѱװ',
        'uninstalled' => 'δװ',
        'Security Note: You should activate %s because application is already running!' => 'ȫʾ: ܼ %s, ΪӦѾ!',
        'Unable to parse Online Repository index document!' => 'ܷԴĵ',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'ԴûӦҪĿܣĿ',
        'No Packages or no new Packages in selected Online Repository!' => 'ѡԴУûִµ',
        'printed at' => 'ӡ',
        'Loading...' => '',
        'Dear Mr. %s,' => '𾴵 %s :',
        'Dear Mrs. %s,' => '𾴵 %s Ůʿ:',
        'Dear %s,' => '𾴵 %s:',
        'Hello %s,' => ', %s:',
        'This account exists.' => 'ʻѴ',
        'New account created. Sent Login-Account to %s.' => 'µʺѴ, ֪ͨ %s.',
        'Please press Back and try again.' => '뷵һ.',
        'Sent password token to: %s' => '뵽: %s',
        'Sent new password to: %s' => 'µ뵽: %s',
        'Upcoming Events' => '¼',
        'Event' => '¼',
        'Events' => '¼',
        'Invalid Token!' => 'Ƿı',
        'more' => '',
        'For more info see:' => 'Ϣ뿴',
        'Package verification failed!' => '֤ʧ',
        'Collapse' => '',
        'Shown' => 'ʾ',
        'News' => '',
        'Product News' => 'Ʒ',
        'OTRS News' => 'OTRS ',
        '7 Day Stats' => ' 7 ͳ',
        'Bold' => '',
        'Italic' => 'б',
        'Underline' => '',
        'Font Color' => 'ɫ',
        'Background Color' => 'ɫ',
        'Remove Formatting' => 'ɾʽ',
        'Show/Hide Hidden Elements' => 'ʾ/ Ҫ',
        'Align Left' => '',
        'Align Center' => 'ж',
        'Align Right' => 'Ҷ',
        'Justify' => '',
        'Header' => 'Ϣͷ',
        'Indent' => '',
        'Outdent' => 'ͻ',
        'Create an Unordered List' => 'һб',
        'Create an Ordered List' => 'һб',
        'HTML Link' => 'HTML',
        'Insert Image' => 'ͼ',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'ԭ',
        'Redo' => '',

        # Template: AAAMonth
        'Jan' => 'һ',
        'Feb' => '',
        'Mar' => '',
        'Apr' => '',
        'May' => '',
        'Jun' => '',
        'Jul' => '',
        'Aug' => '',
        'Sep' => '',
        'Oct' => 'ʮ',
        'Nov' => 'ʮһ',
        'Dec' => 'ʮ',
        'January' => 'һ',
        'February' => '',
        'March' => '',
        'April' => '',
        'May_long' => '',
        'June' => '',
        'July' => '',
        'August' => '',
        'September' => '',
        'October' => 'ʮ',
        'November' => 'ʮһ',
        'December' => 'ʮ',

        # Template: AAANavBar
        'Admin-Area' => '',
        'Agent-Area' => '֧Ա',
        'Ticket-Area' => 'Ticket',
        'Logout' => 'ע',
        'Agent Preferences' => '',
        'Preferences' => '',
        'Agent Mailbox' => '֧Ա',
        'Stats' => 'ͳ',
        'Stats-Area' => 'ͳ',
        'Admin' => '',
        'Customer Users' => 'ͻû',
        'Customer Users <-> Groups' => 'ͻû <-> ',
        'Users <-> Groups' => 'û <-> ',
        'Roles' => 'ɫ',
        'Roles <-> Users' => 'ɫ <-> û',
        'Roles <-> Groups' => 'ɫ <-> ',
        'Salutations' => 'ν',
        'Signatures' => 'ǩ',
        'Email Addresses' => 'Email ַ',
        'Notifications' => 'ϵͳ֪ͨ',
        'Category Tree' => 'Ŀ¼',
        'Admin Notification' => 'Ա֪ͨ',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'ø³ɹ!',
        'Mail Management' => 'ʼ',
        'Frontend' => 'ǰ˽',
        'Other Options' => 'ѡ',
        'Change Password' => '޸',
        'New password' => '',
        'New password again' => 'ظ',
        'Select your QueueView refresh time.' => 'ͼˢʱ.',
        'Select your frontend language.' => '',
        'Select your frontend Charset.' => 'ַ.',
        'Select your frontend Theme.' => '.',
        'Select your frontend QueueView.' => 'ͼ.',
        'Spelling Dictionary' => 'ƴдֵ',
        'Select your default spelling dictionary.' => 'ȱʡƴдֵ.',
        'Max. shown Tickets a page in Overview.' => 'ÿһҳʾ Tickets Ŀ.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'β޷£',
        'Can\'t update password, invalid characters!' => '޷룬Чַ.',
        'Can\'t update password, must be at least %s characters!' => '޷룬볤%sλ.',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => '޷룬ٰ2дַ2Сдַ.',
        'Can\'t update password, needs at least 1 digit!' => '޷룬ٰ1λ',
        'Can\'t update password, needs at least 2 characters!' => '޷룬ٰ2ĸ!',

        # Template: AAAStats
        'Stat' => 'ͳ',
        'Please fill out the required fields!' => 'дֶ',
        'Please select a file!' => 'ѡһļ!',
        'Please select an object!' => 'ѡһ!',
        'Please select a graph size!' => 'ѡͼƬߴ!',
        'Please select one element for the X-axis!' => 'ѡһԪصX-',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'ֻѡһԪػرձѡ\'Fixed\'ť',
        'If you use a checkbox you have to select some attributes of the select field!' => 'ʹøѡѡѡһЩ!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'ѡһֵر\'Fixed\'ѡ',
        'The selected end time is before the start time!' => 'ѡĽʱڿʼʱ䣡',
        'You have to select one or more attributes from the select field!' => 'ӱѡѡһԣ',
        'The selected Date isn\'t valid!' => 'ѡڲЧ',
        'Please select only one or two elements via the checkbox!' => 'ͨѡֻѡһҪأ',
        'If you use a time scale element you can only select one element!' => 'ʹõʱ߶Ҫֻѡһɲ',
        'You have an error in your time selection!' => 'һʱѡ',
        'Your reporting time interval is too small, please use a larger time scale!' => 'ıʱ̫Сʹøļ',
        'The selected start time is before the allowed start time!' => 'ѡĿʼʱĿʼʱ',
        'The selected end time is after the allowed end time!' => 'ѡĽʱĽʱ',
        'The selected time period is larger than the allowed time period!' => 'ѡʱδʱ',
        'Common Specification' => 'ͬ淶',
        'Xaxis' => 'X',
        'Value Series' => 'ֵϵ',
        'Restrictions' => '',
        'graph-lines' => 'ͼ',
        'graph-bars' => '״ͼ',
        'graph-hbars' => 'H״ͼ',
        'graph-points' => 'ͼ',
        'graph-lines-points' => 'ͼߵ',
        'graph-area' => 'ͼ',
        'graph-pie' => 'ͼ',
        'extended' => 'չ',
        'Agent/Owner' => '',
        'Created by Agent/Owner' => '֧Ա',
        'Created Priority' => 'ȼ',
        'Created State' => '״̬',
        'Create Time' => 'ʱ',
        'CustomerUserLogin' => 'ͻ½',
        'Close Time' => 'رʱ',
        'TicketAccumulation' => 'Ticket',
        'Attributes to be printed' => 'Ҫӡ',
        'Sort sequence' => '',
        'Order by' => '˳',
        'Limit' => '',
        'Ticketlist' => 'Ticket嵥',
        'ascending' => '',
        'descending' => '',
        'First Lock' => '',
        'Evaluation by' => '۵',
        'Total Time' => 'ʱ',
        'Ticket Average' => 'Ticketƽʱ',
        'Ticket Min Time' => 'TicketСʱ',
        'Ticket Max Time' => 'Ticketʱ',
        'Number of Tickets' => 'TicketĿ',
        'Article Average' => 'Articleƽʱ',
        'Article Min Time' => 'ArticleСʱ',
        'Article Max Time' => 'Articleʱ',
        'Number of Articles' => 'Article',
        'Accounted time by Agent' => '֧ԱTicketõʱ',
        'Ticket/Article Accounted Time' => 'Ticket/Articleռõʱ',
        'TicketAccountedTime' => 'Ticketռõʱ',
        'Ticket Create Time' => 'Ticketʱ',
        'Ticket Close Time' => 'Ticketرʱ',

        # Template: AAATicket
        'Lock' => '',
        'Unlock' => '',
        'History' => 'ʷ',
        'Zoom' => 'ʼչ',
        'Age' => 'ʱ',
        'Bounce' => '',
        'Forward' => 'ת',
        'From' => '',
        'To' => 'ռ',
        'Cc' => '',
        'Bcc' => '',
        'Subject' => '',
        'Move' => 'ƶ',
        'Queue' => '',
        'Priority' => 'ȼ',
        'Priority Update' => 'ȼ',
        'State' => '״̬',
        'Compose' => '׫д',
        'Pending' => 'ȴ',
        'Owner' => '',
        'Owner Update' => '',
        'Responsible' => '',
        'Responsible Update' => '¸',
        'Sender' => '',
        'Article' => 'ż',
        'Ticket' => 'Ticket',
        'Createtime' => 'ʱ',
        'plain' => 'ı',
        'Email' => 'ʼַ',
        'email' => 'E-Mail',
        'Close' => 'ر',
        'Action' => '',
        'Attachment' => '',
        'Attachments' => '',
        'This message was written in a character set other than your own.' => 'ʼַ뱾ϵͳַ',
        'If it is not displayed correctly,' => 'ʾȷ,',
        'This is a' => 'һ',
        'to open it in a new window.' => '´д',
        'This is a HTML email. Click here to show it.' => 'һHTMLʽʼʾ.',
        'Free Fields' => 'Ϣ',
        'Merge' => 'ϲ',
        'merged' => 'Ѻϲ',
        'closed successful' => 'ɹر',
        'closed unsuccessful' => 'رʧ',
        'new' => '½',
        'open' => '',
        'Open' => '',
        'closed' => 'ر',
        'Closed' => 'ر',
        'removed' => 'ɾ',
        'pending reminder' => 'ȴ',
        'pending auto' => 'Զȴ',
        'pending auto close+' => 'ȴԶر+',
        'pending auto close-' => 'ȴԶر-',
        'email-external' => 'ⲿ E-Mail ',
        'email-internal' => 'ڲ E-Mail ',
        'note-external' => 'ⲿע',
        'note-internal' => 'ڲע',
        'note-report' => 'עⱨ',
        'phone' => '绰',
        'sms' => '',
        'webrequest' => 'Web',
        'lock' => '',
        'unlock' => 'δ',
        'very low' => 'ǳ',
        'low' => '',
        'normal' => '',
        'high' => '',
        'very high' => 'ǳ',
        '1 very low' => '1 ǳ',
        '2 low' => '2 ',
        '3 normal' => '3 ',
        '4 high' => '4 ',
        '5 very high' => '5 ǳ',
        'Ticket "%s" created!' => 'Ticket "%s" Ѵ!',
        'Ticket Number' => 'Ticket ',
        'Ticket Object' => 'Ticket ',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Ticket "%s" ڣܴ!',
        'Don\'t show closed Tickets' => 'ʾѹرյ Tickets',
        'Show closed Tickets' => 'ʾѹرյ Tickets',
        'New Article' => '',
        'Email-Ticket' => 'ʼ Ticket',
        'Create new Email Ticket' => 'µʼ Ticket',
        'Phone-Ticket' => '绰 Ticket',
        'Search Tickets' => ' Tickets',
        'Edit Customer Users' => '༭ͻʻ',
        'Edit Customer Company' => '༭ͻλ',
        'Bulk Action' => '',
        'Bulk Actions on Tickets' => ' Tickets',
        'Send Email and create a new Ticket' => ' Email һµ Ticket',
        'Create new Email Ticket and send this out (Outbound)' => 'µ Ticketͳȥ',
        'Create new Phone Ticket (Inbound)' => 'µĵ绰TicketTicket',
        'Overview of all open Tickets' => 'п Tickets ſ',
        'Locked Tickets' => ' Ticket',
        'Watched Tickets' => ' Tickets',
        'Watched' => '',
        'Subscribe' => '',
        'Unsubscribe' => '˶',
        'Lock it to work on it!' => 'ʼ !',
        'Unlock to give it back to the queue!' => 'ͻض!',
        'Shows the ticket history!' => 'ʾ Ticket ʷ״!',
        'Print this ticket!' => 'ӡ Ticket !',
        'Change the ticket priority!' => '޸ Ticket ȼ',
        'Change the ticket free fields!' => '޸ Ticket Ϣ',
        'Link this ticket to an other objects!' => 'Ӹ Ticket !',
        'Change the ticket owner!' => '޸ Ticket !',
        'Change the ticket customer!' => '޸ Ticket ͻ!',
        'Add a note to this ticket!' => ' Ticket ע!',
        'Merge this ticket!' => 'ϲ Ticket!',
        'Set this ticket to pending!' => ' Ticket תȴ״̬',
        'Close this ticket!' => 'رո Ticket!',
        'Look into a ticket!' => '鿴 Ticket ',
        'Delete this ticket!' => 'ɾ Ticket!',
        'Mark as Spam!' => 'Ϊ!',
        'My Queues' => 'ҵĶ',
        'Shown Tickets' => 'ʾ Tickets',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'ʼ "<OTRS_TICKET>" ϲ "<OTRS_MERGE_TO_TICKET>" !',
        'Ticket %s: first response time is over (%s)!' => 'Ticket %s: һӦʱѺʱ(%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Ticket %s: һӦʱ佫ʱ(%s)!',
        'Ticket %s: update time is over (%s)!' => 'Ticket %s: ʱѺʱ(%s)!',
        'Ticket %s: update time will be over in %s!' => 'Ticket %s: ʱ佫ʱ(%s)!',
        'Ticket %s: solution time is over (%s)!' => 'Ticket %s: Ѻʱ(%s)!',
        'Ticket %s: solution time will be over in %s!' => 'ʱ(%s)!',
        'There are more escalated tickets!' => 'иtickets',
        'New ticket notification' => ' Ticket ֪ͨ',
        'Send me a notification if there is a new ticket in "My Queues".' => 'ҵĶµ Ticket֪ͨ.',
        'Follow up notification' => '֪ͨ',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'ͻ Ticket ظǸ Ticket .',
        'Ticket lock timeout notification' => 'Ticket ʱ֪ͨ ',
        'Send me a notification if a ticket is unlocked by the system.' => ' Ticket ϵͳ֪ͨ.',
        'Move notification' => 'ƶ֪ͨ',
        'Send me a notification if a ticket is moved into one of "My Queues".' => ' Ticket תҵĶУ֪ͨ.',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'öУʼüõöе״̬֪ͨ.',
        'Custom Queue' => 'ͻ',
        'QueueView refresh time' => 'ͼˢʱ',
        'Screen after new ticket' => ' Ticket ͼ',
        'Select your screen after creating a new ticket.' => 'ѡ Ticket ʾͼ.',
        'Closed Tickets' => 'ر Tickets',
        'Show closed tickets.' => 'ʾѹر Tickets.',
        'Max. shown Tickets a page in QueueView.' => 'ͼÿҳʾ Ticket .',
        'Watch notification' => 'ע֪ͨ',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'עticketticketӵһҲһ֪ͨ',
        'Out Of Office' => 'ڰ칫',
        'Select your out of office time.' => 'ѡ㲻ڰ칫ҵʱ',
        'CompanyTickets' => '˾Tickets',
        'MyTickets' => 'ҵ Tickets',
        'New Ticket' => 'µ Ticket',
        'Create new Ticket' => 'µ Ticket',
        'Customer called' => 'ͻµ',
        'phone call' => '绰',
        'Reminder Reached' => 'Ѵ',
        'Reminder Tickets' => 'ѵ Ticket',
        'Escalated Tickets' => 'Ticket',
        'New Tickets' => 'µTicket',
        'Open Tickets / Need to be answered' => '򿪵Tickets/Ҫش',
        'Tickets which need to be answered!' => 'Ҫش Ticket',
        'All new tickets!' => 'µtickets',
        'All tickets which are escalated!' => 'tickets',
        'All tickets where the reminder date has reached!' => 'ѵڵTicket',
        'Responses' => 'ظ',
        'Responses <-> Queue' => 'ظ <-> ',
        'Auto Responses' => 'Զظ',
        'Auto Responses <-> Queue' => 'Զظ <-> ',
        'Attachments <-> Responses' => ' <-> ظ',
        'History::Move' => 'Ticket Ƶ "%s" (%s) Ӷ "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => '·񼶱Э to %s (ID=%s).',
        'History::NewTicket' => 'New ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'Զܾ͸ "%s".',
        'History::SendAutoReply' => 'Զظ͸ "%s".',
        'History::SendAutoFollowUp' => 'Զٷ͸ "%s".',
        'History::Forward' => 'ת "%s".',
        'History::Bounce' => '˵ "%s".',
        'History::SendAnswer' => 'ż͸ "%s".',
        'History::SendAgentNotification' => '"%s"-Benachrichtigung versand an "%s".',
        'History::SendCustomerNotification' => '֪ͨ͸ "%s".',
        'History::EmailAgent' => 'ʼͻ.',
        'History::EmailCustomer' => 'Add mail. %s',
        'History::PhoneCallAgent' => 'Called customer',
        'History::PhoneCallCustomer' => 'ͻѴ绰',
        'History::AddNote' => 'ע (%s)',
        'History::Lock' => 'Ticket .',
        'History::Unlock' => 'Ticket .',
        'History::TimeAccounting' => '%s time unit(d) counted. Totaly %s time unit(s) counted.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Refreshed: %s',
        'History::PriorityUpdate' => 'ȼ£  "%s" (%s)  "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop protection! sent no auto answer to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Refreshed: %s',
        'History::StateUpdate' => 'Before "%s" : "%s"',
        'History::TicketFreeTextUpdate' => 'Refreshed: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'ͻ.',
        'History::TicketLinkAdd' => 'Link to "%s" established.',
        'History::TicketLinkDelete' => 'Link to "%s" removed.',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => '',
        'Mon' => 'һ',
        'Tue' => 'ڶ',
        'Wed' => '',
        'Thu' => '',
        'Fri' => '',
        'Sat' => '',

        # Template: AdminAttachmentForm
        'Attachment Management' => '',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Զظ',
        'Response' => 'ظ',
        'Auto Response From' => 'Զظ',
        'Note' => 'ע',
        'Useable options' => 'ú',
        'To get the first 20 character of the subject.' => 'ʾǰ20ֽ',
        'To get the first 5 lines of the email.' => 'ʾʵǰ',
        'To get the realname of the sender (if given).' => 'ʾ˵ʵ',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => '',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'ǰͻϢĿѡ (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'TicketӵߵĿѡ e. g. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'Ticketѡ (e. g. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => '',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'ѡ ticket  (: <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',

        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => '',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => '˵λ',
        'Search for' => '',
        'Add Customer Company' => 'ӿ˵λ',
        'Add a new Customer Company.' => 'ӿ˵λ',
        'List' => 'б',
        'This values are required.' => 'Ŀд.',
        'This values are read only.' => 'ֻ.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Ϣ׫дĴѾر,˳.',
        'This window must be called from compose window' => 'ôڱ׫дڵ',
        'Customer User Management' => 'ͻû',
        'Add Customer User' => 'ӿ',
        'Source' => 'Դ',
        'Create' => '',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'ͻûһ˺Ŵӿͻ¼ҳ¼ϵͳ.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'ͻû <->  ',
        'Change %s settings' => '޸ %s ',
        'Select the user:group permissions.' => 'ѡ û: Ȩ.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'ѡûȨ (޷ Ticket)',
        'Permission' => 'Ȩ',
        'ro' => 'ֻ',
        'Read only access to the ticket in this group/queue.' => 'е Ticket ֻ.',
        'rw' => 'д',
        'Full read and write access to the tickets in this group/queue.' => 'е Ticket /д.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'ͻʺ <-> ',
        'CustomerUser' => 'ͻû',
        'Service' => '',
        'Edit default services.' => '༭ĬϷ',
        'Search Result' => '',
        'Allocate services to CustomerUser' => 'ͻ',
        'Active' => '',
        'Allocate CustomerUser to service' => 'ָɿͻ',

        # Template: AdminEmail
        'Message sent to' => 'Ϣ͸',
        'A message should have a subject!' => 'ʼб!',
        'Recipients' => 'ռ',
        'Body' => '',
        'Send' => '',

        # Template: AdminGenericAgent
        'GenericAgent' => 'ƻ',
        'Job-List' => 'б',
        'Last run' => '',
        'Run Now!' => '!',
        'x' => 'x',
        'Save Job as?' => '湤Ϊ?',
        'Is Job Valid?' => 'ǷЧ?',
        'Is Job Valid' => 'Ч',
        'Schedule' => '',
        'Currently this generic agent job will not run automatically.' => 'ĿǰһͨAgentҵԶ',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Զִѡһֵӣʱ',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'ȫ (: "Mar*in"  "Baue*")',
        '(e. g. 10*5155 or 105658*)' => '  : 10*5144  105658*',
        '(e. g. 234321)' => ': 234321',
        'Customer User Login' => 'ͻû¼Ϣ',
        '(e. g. U5150)' => ': U5150',
        'SLA' => '񼶱Э(SLA)',
        'Agent' => '֧Ա',
        'Ticket Lock' => 'Ticket ״̬',
        'TicketFreeFields' => 'Ticket ',
        'Create Times' => 'ʱ',
        'No create time settings.' => 'ûдʱ',
        'Ticket created' => 'ʱ',
        'Ticket created between' => ' ʱ',
        'Close Times' => 'رʱ',
        'No close time settings.' => 'û趨رʱ.',
        'Ticket closed' => 'رյ Ticket',
        'Ticket closed between' => 'Ticket رʱ',
        'Pending Times' => 'ʱ',
        'No pending time settings.' => 'ûôʱ',
        'Ticket pending time reached' => 'ʱѵTicket',
        'Ticket pending time reached between' => 'ڴʱڵTicket ',
        'Escalation Times' => 'ʱ',
        'No escalation time settings.' => 'ûʱ',
        'Ticket escalation time reached' => 'ѵʱTicket',
        'Ticket escalation time reached between' => 'ʱڵTicket',
        'Escalation - First Response Time' => ' - ״λظʱ',
        'Ticket first response time reached' => '״λظʱѵTicket',
        'Ticket first response time reached between' => '״λظʱڵTicket',
        'Escalation - Update Time' => ' - µʱ',
        'Ticket update time reached' => 'ʱѵTicket',
        'Ticket update time reached between' => 'ڸʱڵTicket',
        'Escalation - Solution Time' => ' - ʱ',
        'Ticket solution time reached' => 'ʱѵTicket',
        'Ticket solution time reached between' => 'ڷʱѵTicket',
        'New Service' => 'µķ񼶱',
        'New SLA' => 'µķ񼶱Э(SLA)',
        'New Priority' => 'ȼ',
        'New Queue' => '¶',
        'New State' => '״̬',
        'New Agent' => '¼֧Ա',
        'New Owner' => '',
        'New Customer' => '¿ͻ',
        'New Ticket Lock' => ' Ticket ',
        'New Type' => 'µ',
        'New Title' => 'µı',
        'New TicketFreeFields' => 'µ Ticket ',
        'Add Note' => 'ע',
        'Time units' => 'ʱ䵥Ԫ',
        'CMD' => '',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'ִ, һ Ticket ţڶ Ticket ıʶ.',
        'Delete tickets' => 'ɾ Tickets',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => '!  Ticket ݿɾ޷ָ!',
        'Send Notification' => '֪ͨ',
        'Param 1' => ' 1',
        'Param 2' => ' 2',
        'Param 3' => ' 3',
        'Param 4' => ' 4',
        'Param 5' => ' 5',
        'Param 6' => ' 6',
        'Send agent/customer notifications on changes' => 'ʹ/ͻ֪ͨ',
        'Save' => '',
        '%s Tickets affected! Do you really want to use this job?' => '%s Tickets ܵӰ! ȷҪʹƻ?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '棺\'\'ʱSysConfigӦı仯֮ǰ㽫סSQLĻص\'admin\'',
        'Group Management' => '',
        'Add Group' => 'µ',
        'Add a new Group.' => 'һ',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Admin Խϵͳ, Stats Խͳƹ',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'µƲͬĴȡȨ',
        'It\'s useful for ASP solutions.' => 'һЧӦ÷ṩ(ASP).',

        # Template: AdminLog
        'System Log' => 'ϵͳ־',
        'Time' => 'ʱ',

        # Template: AdminMailAccount
        'Mail Account Management' => 'ʼʺŹ',
        'Host' => '',
        'Trusted' => 'Ƿ',
        'Dispatching' => '',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'һʼ˺ŵʼᱻַѡ!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'ʻֵģеX-OTRS⵽ʱ䣨ȣ ... ʹãʹ',

        # Template: AdminNavigationBar
        'Users' => 'û',
        'Groups' => '',
        'Misc' => 'ۺ',

        # Template: AdminNotificationEventForm
        'Notification Management' => '֪ͨ',
        'Add Notification' => '֪ͨ',
        'Add a new Notification.' => 'һ֪ͨ.',
        'Name is required!' => 'Ҫ!',
        'Event is required!' => 'Ҫ¼',
        'A message should have a body!' => 'ʼ!',
        'Recipient' => 'ռ',
        'Group based' => '',
        'Agent based' => 'ڼִ֧',
        'Email based' => 'ڵʵ',
        'Article Type' => 'Article ',
        'Only for ArticleCreate Event.' => ' ArticleCreate ¼',
        'Subject match' => 'ƥ',
        'Body match' => 'ƥ',
        'Notifications are sent to an agent or a customer.' => '֪ͨ͵֧Ա߿ͻ.',
        'To get the first 20 character of the subject (of the latest agent article).' => 'ȡԱʼǰ 20 ַ.',
        'To get the first 5 lines of the body (of the latest agent article).' => 'ȡԱʼǰ 5 .',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'ȡż (: <OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'ȡͻʼǰ 20 ַ.',
        'To get the first 5 lines of the body (of the latest customer article).' => 'ȡʼǰ 5 .',

        # Template: AdminNotificationForm
        'Notification' => 'ϵͳ֪ͨ',

        # Template: AdminPackageManager
        'Package Manager' => '',
        'Uninstall' => 'ж',
        'Version' => '汾',
        'Do you really want to uninstall this package?' => 'Ƿȷжظ?',
        'Reinstall' => '°װ',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Ƿ׼°װЩ (ֹý᲻)?',
        'Continue' => '',
        'Install' => 'װ',
        'Package' => '',
        'Online Repository' => '֪ʶ',
        'Vendor' => 'ṩ',
        'Module documentation' => 'ģĵ',
        'Upgrade' => '',
        'Local Repository' => '֪ʶ',
        'Status' => '״̬',
        'Overview' => 'ſ',
        'Download' => '',
        'Rebuild' => '¹',
        'ChangeLog' => 'ı¼',
        'Date' => '',
        'Filelist' => 'ļ嵥',
        'Download file from package!' => 'ļ',
        'Required' => '',
        'PrimaryKey' => 'ؼKey',
        'AutoIncrement' => 'Զ',
        'SQL' => 'SQL',
        'Diff' => 'Ƚ',

        # Template: AdminPerformanceLog
        'Performance Log' => 'ϵͳ',
        'This feature is enabled!' => 'ù',
        'Just use this feature if you want to log each request.' => 'ϸ¼ÿ, ʹøù.',
        'Activating this feature might affect your system performance!' => 'ùܿӰϵͳ',
        'Disable it here!' => 'رոù',
        'This feature is disabled!' => 'ùѹر',
        'Enable it here!' => '򿪸ù',
        'Logfile too large!' => '־ļ',
        'Logfile too large, you need to reset it!' => '־ļ, Ҫ',
        'Range' => 'Χ',
        'Interface' => '',
        'Requests' => '',
        'Min Response' => 'СӦ',
        'Max Response' => 'Ӧ',
        'Average Response' => 'ƽӦ',
        'Period' => '',
        'Min' => 'С',
        'Max' => '',
        'Average' => 'ƽ',

        # Template: AdminPGPForm
        'PGP Management' => 'PGP ',
        'Result' => '',
        'Identifier' => 'ʶ',
        'Bit' => 'λ',
        'Key' => 'ܳ',
        'Fingerprint' => 'ָӡ',
        'Expires' => '',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'ַʽֱӱ༭SysConfigõļ',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'ʼ˹',
        'Filtername' => '',
        'Stop after match' => '',
        'Match' => 'ƥ',
        'Value' => 'ֵ',
        'Set' => '',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => ' X-Headers ˣʹʽ.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'ƥemail ַ ʹEMAILADDRESS:info@example.com in From, To or Cc.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'RegExpҲʹƥֵin () as [***] in \'Set\'',

        # Template: AdminPriority
        'Priority Management' => 'Ȩ',
        'Add Priority' => 'Ȩ',
        'Add a new Priority.' => 'һµȨ',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => ' <-> Զظ',
        'settings' => '',

        # Template: AdminQueueForm
        'Queue Management' => 'й',
        'Sub-Queue of' => 'Ӷ',
        'Unlock timeout' => 'Զʱ',
        '0 = no unlock' => '0 = Զ  ',
        'Only business hours are counted.' => 'ϰʱ',
        '0 = no escalation' => '0 = ʱ  ',
        'Notify by' => '֪ͨ',
        'Follow up Option' => 'ѡ',
        'Ticket lock after a follow up' => 'ȷԺTicket Զ',
        'Systemaddress' => 'ϵͳʼַ',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => '֧Ա Ticket,һʱûлظ Ticket ᱻԶеļ֧Ա.',
        'Escalation time' => 'ʱʱ',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'öֻʾ涨ʱûб Ticket',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => ' Ticket Ѿڹر״̬ͻͷһ Ticketô Ticket ᱻֱӼ߱Ϊԭ',
        'Will be the sender address of this queue for email answers.' => 'ظʼõķߵַ',
        'The salutation for email answers.' => 'ظʼóν.',
        'The signature for email answers.' => 'ظʼǩ.',
        'Customer Move Notify' => 'Ticket ƶͻ֪ͨ',
        'OTRS sends an notification email to the customer if the ticket is moved.' => ' Ticket ƶϵͳᷢһ֪ͨʼͻ',
        'Customer State Notify' => 'Ticket ״̬ͻ֪ͨ',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => ' Ticket ״̬ı䣬ϵͳ֪ᷢͨʼͻ',
        'Customer Owner Notify' => 'ͻͨ',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => ' Ticket ߸ı䣬ϵͳ֪ᷢͨʼͻ.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'ظ <-> й',

        # Template: AdminQueueResponsesForm
        'Answer' => 'ظ',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'ظ <-> ',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'ظݹ',
        'A response is default text to write faster answer (with default text) to customers.' => 'Ϊ˿ٻظظݶÿظظ.',
        'Don\'t forget to add a new response a queue!' => 'ҪһµĻظݵ!',
        'The current ticket state is' => 'ǰ Ticket ״̬',
        'Your email address is new' => 'ʼַµ',

        # Template: AdminRoleForm
        'Role Management' => 'ɫ',
        'Add Role' => 'ӽɫ',
        'Add a new Role.' => 'һɫ',
        'Create a role and put groups in it. Then add the role to the users.' => 'һɫɫ,Ȼ󽫽ɫû.',
        'It\'s useful for a lot of users and groups.' => 'дûʱ򣬽ɫǳʺ.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'ɫ <-> ',
        'move_into' => 'ƶ',
        'Permissions to move tickets into this group/queue.' => 'ƶ Tickets /.',
        'create' => '',
        'Permissions to create tickets in this group/queue.' => 'ڸ/д Tickets Ȩ.',
        'owner' => '',
        'Permissions to change the ticket owner in this group/queue.' => 'ڸ/޸ Tickets ߵȨ.',
        'priority' => 'ȼ',
        'Permissions to change the ticket priority in this group/queue.' => 'ڸ/޸ Tickets ȼȨ.',

        # Template: AdminRoleGroupForm
        'Role' => 'ɫ',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'ɫ <-> û',
        'Select the role:user relations.' => 'ѡ ɫ:û .',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'ƺ',
        'Add Salutation' => 'ӳƺ',
        'Add a new Salutation.' => 'һµĳƺ',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'ȫģʽҪ',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'ڳʼװ󣬰ȫģʽͨ',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'ΪWeb 氲װȫģʽdisabled',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'ģʽûбͨϵͳΪOTRSѾ',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'SQLѯ',
        'CSV' => '',
        'HTML' => '',
        'Select Box Result' => 'ѯ',

        # Template: AdminService
        'Service Management' => '',
        'Add Service' => 'ӷ',
        'Add a new Service.' => 'һ',
        'Sub-Service of' => 'ӷ',

        # Template: AdminSession
        'Session Management' => 'Ự',
        'Sessions' => 'Ự',
        'Uniq' => 'һ',
        'Kill all sessions' => 'ֹлỰ',
        'Session' => 'Ự',
        'Content' => '',
        'kill session' => 'ֹỰ',

        # Template: AdminSignatureForm
        'Signature Management' => 'ǩ',
        'Add Signature' => 'ǩ',
        'Add a new Signature.' => 'һǩ',

        # Template: AdminSLA
        'SLA Management' => '񼶱Э(SLA)',
        'Add SLA' => 'ӷ񼶱Э(SLA)',
        'Add a new SLA.' => 'һ񼶱Э(SLA).',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'S/MIME ',
        'Add Certificate' => '֤',
        'Add Private Key' => '˽',
        'Secret' => '',
        'Hash' => 'Hash',
        'In this way you can directly edit the certification and private keys in file system.' => 'ַʽֱӱ༭֤˽',

        # Template: AdminStateForm
        'State Management' => '״̬',
        'Add State' => '״̬',
        'Add a new State.' => 'һµ״̬',
        'State Type' => '״̬',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'ͬʱ Kernel/Config.pm еȱʡ״̬!',
        'See also' => 'μ',

        # Template: AdminSysConfig
        'SysConfig' => 'ϵͳ',
        'Group selection' => 'ѡ',
        'Show' => 'ʾ',
        'Download Settings' => '',
        'Download all system config changes.' => 'еϵͳñ仯.',
        'Load Settings' => '',
        'Subgroup' => '',
        'Elements' => 'Ԫ',

        # Template: AdminSysConfigEdit
        'Config Options' => 'ѡ',
        'Default' => 'ȱʡ',
        'New' => '',
        'New Group' => '',
        'Group Ro' => 'ֻȨ޵',
        'New Group Ro' => 'µֻȨ޵',
        'NavBarName' => '',
        'NavBar' => '',
        'Image' => 'ͼƬ',
        'Prio' => 'ȼ',
        'Block' => '',
        'AccessKey' => 'Կ',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'ϵͳʼַ',
        'Add System Address' => 'ϵͳʼַ',
        'Add a new System Address.' => 'һµϵͳʼַ.',
        'Realname' => 'ʵ',
        'All email addresses get excluded on replaying on composing an email.' => '',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'з͵ռ˵ϢתѡĶ',

        # Template: AdminTypeForm
        'Type Management' => '͹',
        'Add Type' => '',
        'Add a new Type.' => 'һµ',

        # Template: AdminUserForm
        'User Management' => 'Ա',
        'Add User' => 'Ա',
        'Add a new Agent.' => 'һµԱ',
        'Login as' => '¼',
        'Firstname' => '',
        'Lastname' => '',
        'Start' => 'ʼ',
        'End' => '',
        'User will be needed to handle tickets.' => 'Ҫû Tickets.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ҫһûͽɫ!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'û <-> ',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'ַ',
        'Return to the compose screen' => 'ص׫дҳ',
        'Discard all changes and return to the compose screen' => '޸,ص׫дҳ',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => '',

        # Template: AgentDashboardCalendarOverview
        'in' => '',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '',
        'Please update now.' => '',
        'Release Note' => '汾ע',
        'Level' => '',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => '',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentInfo
        'Info' => '',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Ӷ: %s',
        'Object' => '',
        'Link Object' => 'Ӷ',
        'with' => '',
        'Select' => 'ѡ',
        'Unlink Object: %s' => 'δӶ %s',

        # Template: AgentLookup
        'Lookup' => '',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'ƴд',
        'spelling error(s)' => 'ƴд',
        'or' => '',
        'Apply these changes' => 'ӦЩı',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Ƿȷɾö?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'ѡƲʹͳ',
        'Fixed' => '',
        'Please select only one element or turn off the button \'Fixed\'.' => 'ֻѡһԪػرձѡ\'Fixed\'ť',
        'Absolut Period' => '',
        'Between' => '',
        'Relative Period' => '',
        'The last' => '',
        'Finish' => '',
        'Here you can make restrictions to your stat.' => 'ΪͳƶƲ',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'ɾڡ̶ѡɸͳƵļִ֧ԸıӦҪص',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '빲ͬ淶',
        'Permissions' => '',
        'Format' => 'ʽ',
        'Graphsize' => 'ͼλ',
        'Sum rows' => 'ܺ',
        'Sum columns' => 'ܺ',
        'Cache' => '',
        'Required Field' => 'ֶ',
        'Selection needed' => 'ѡҪ',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => 'ʽѡ淶',
        'Attribute' => '',
        'Title of the stat.' => 'ͳƵı',
        'Here you can insert a description of the stat.' => 'ԲͳƵ',
        'Dynamic-Object' => '̬',
        'Here you can select the dynamic object you want to use.' => 'ѡҪʹõĶ̬',
        '(Note: It depends on your installation how many dynamic objects you can use)' => 'עȡİװٶ̬ʹ',
        'Static-File' => '̬ļ',
        'For very complex stats it is possible to include a hardcoded file.' => 'ڷǳӵͳпܰһӲļ',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'һµӲļڣɴԽʾѡһ',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Ȩáѡһ壬ͬļִ֧ɿõͳ',
        'Multiple selection of the output format.' => 'ʽĶѡ',
        'If you use a graph as output format you have to select at least one graph size.' => 'ʹõͼεʽѡһͼεĴС',
        'If you need the sum of every row select yes' => 'Ҫÿеܺѡ yes',
        'If you need the sum of every column select yes.' => 'Ҫÿеܺѡyes',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'ͳϿԻ,⽫ӿһͳƵչʾ.',
        '(Note: Useful for big databases and low performance server)' => 'עڴݿ͵ܵķ',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'ЧͳƲͳ',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ƿǳõģ㲻˵õͳƵĽͳƽ',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'ѡֵϵеҪ',
        'Scale' => '߶',
        'minimal' => 'С',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'סȶļֵϵҪXĳ߶ȣX -=>£ ValueSeries =>꣩ ',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶһϵеֵпѡһԪءȻѡԪصԡÿԽʾΪһֵѡκ, ôһͳƵʱԪصԽʹáһµԱµϴ',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'ѡxԪ',
        'maximal period' => '',
        'minimal scale' => 'С߶',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶxᡣѡһͨѡťûѡԪصԽʹõһͳƵʱ򡣲һµԱµϴ',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => 'ļһͳ',
        'No File selected' => 'ûļѡ',

        # Template: AgentStatsOverview
        'Results' => '',
        'Total hits' => '',
        'Page' => 'ҳ',

        # Template: AgentStatsPrint
        'Print' => 'ӡ',
        'No Element selected.' => 'ûԪرѡ',

        # Template: AgentStatsView
        'Export Config' => '',
        'Information about the Stat' => 'ͳƵϢ',
        'Exchange Axis' => 'ת',
        'Configurable params of static stat' => '̬ͳƵò',
        'No element selected.' => 'ûбѡ',
        'maximal period from' => 'ڱ',
        'to' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'ͨѡֶΣ԰ͳơ޸ı༭ЩͳҪͳϹԱá',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'ʼռ!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'ռϢʼַ(磺customer@example.com)',
        'Bounce ticket' => ' Ticket ',
        'Ticket locked!' => 'Ticket !',
        'Ticket unlock!' => ' Ticket!',
        'Bounce to' => '˵ ',
        'Next ticket state' => 'Tickets ״̬',
        'Inform sender' => '֪ͨ',
        'Send mail!' => '!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Ҫ¼ʱ',
        'Ticket Bulk Action' => 'Ticket ',
        'Spell Check' => 'ƴд',
        'Note type' => 'ע',
        'Next state' => 'Ticket ״̬',
        'Pending date' => '',
        'Merge to' => 'ϲ',
        'Merge to oldest' => 'ϲϵ',
        'Link together' => 'ϲһ',
        'Link to Parent' => 'ϲһ',
        'Unlock Tickets' => ' Tickets',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Ticket Ǳ!',
        'A required field is:' => 'ֶ',
        'Close ticket' => 'ر Ticket',
        'Previous Owner' => 'ǰһ',
        'Inform Agent' => '֪֧ͨԱ',
        'Optional' => 'ѡ',
        'Inform involved Agents' => '֪ͨؼ֧Ա',
        'Attach' => '',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Ϣ뾭ƴд!',
        'Compose answer for ticket' => '׫д,Ticket ',
        'Pending Date' => 'ȴ״̬',
        'for pending* states' => 'Եȴ״̬',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => '޸ Tickets ͻ',
        'Set customer user and customer id of a ticket' => ' Ticket ͻû',
        'Customer User' => 'ͻû',
        'Search Customer' => 'ͻ',
        'Customer Data' => 'ͻ',
        'Customer history' => 'ͻʷ',
        'All customer tickets.' => 'ÿͻ Tickets ¼.',

        # Template: AgentTicketEmail
        'Compose Email' => '׫д Email',
        'new ticket' => '½ Ticket',
        'Refresh' => 'ˢ',
        'Clear To' => '',
        'All Agents' => 'м֧Ա',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => '',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => '޸ Ticket Ϣ',

        # Template: AgentTicketHistory
        'History of' => 'ʷ',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Ҫʹһ Ticket !',
        'Ticket Merge' => 'Ticket ϲ',

        # Template: AgentTicketMove
        'Move Ticket' => 'ƶ Ticket',

        # Template: AgentTicketNote
        'Add note to ticket' => 'ע⵽ Ticket',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => '״αʱ',
        'Service Time' => 'ʱ',
        'Update Time' => 'ʱ',
        'Solution Time' => 'ʱ',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Ҫѡһ Ticket!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => '',
        'Change search options' => '޸ѡ',
        'Tickets' => '',
        'of' => '',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => '׫д',
        'Contact customer' => 'ϵͻ',
        'Change queue' => 'ı',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => '',
        'up' => '',
        'sort downward' => '',
        'down' => '',
        'Escalation in' => 'ʱ',
        'Locked' => '״̬',

        # Template: AgentTicketOwner
        'Change owner of ticket' => '޸ Ticket ',

        # Template: AgentTicketPending
        'Set Pending' => 'ô״̬',

        # Template: AgentTicketPhone
        'Phone call' => '绰',
        'Clear From' => '',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'ı',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'TicketϢ',
        'Accounted time' => 'ʱ',
        'Linked-Object' => 'Ӷ',
        'by' => '',

        # Template: AgentTicketPriority
        'Change priority of ticket' => ' Ticket ȼ',

        # Template: AgentTicketQueue
        'Tickets shown' => 'ʾ Ticket',
        'Tickets available' => ' Ticket',
        'All tickets' => 'Ticket',
        'Queues' => '',
        'Ticket escalation!' => 'Ticket ʱ!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => ' Ticket ĸ',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Ticket ',
        'Profile' => 'Լ',
        'Search-Template' => 'ģ',
        'TicketFreeText' => 'Ticket Ϣ',
        'Created in Queue' => 'ڶｨ',
        'Article Create Times' => '',
        'Article created' => '',
        'Article created between' => '',
        'Change Times' => 'ıʱ',
        'No change time settings.' => 'ıʱ',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Result Form' => 'ʾΪ',
        'Save Search-Profile as Template?' => 'Ϊģ',
        'Yes, save it with name' => ', Ϊ',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'ȫ',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'չ',
        'Collapse View' => '۵',
        'Split' => 'ֽ',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Article ',
        'Save filter settings as default' => 'Ϊȱʡֵ',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => '׷',

        # Template: CustomerFooter
        'Powered by' => '',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => '¼',
        'Lost your password?' => '?',
        'Request new password' => '',
        'Create Account' => 'ʻ',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'ӭ %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'ʱ',
        'No time settings.' => 'ʱԼ.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'ﱨһ Bug!',

        # Template: Footer
        'Top of Page' => 'ҳ涥',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'ҳ',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'WEB װ',
        'Welcome to %s' => 'ӭʹ %s',
        'Accept license' => 'ͬ',
        'Don\'t accept license' => 'ͬ',
        'Admin-User' => 'Ա',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'ݿ root , , , 뱣հ. ڰȫ, ǽΪ root һ, Ϣοݿĵ.',
        'Admin-Password' => 'Ա',
        'Database-User' => 'ݿû',
        'default \'hot\'' => 'Ĭ \'hot\'',
        'DB connect host' => '',
        'Database' => 'ݿ',
        'Default Charset' => 'ȱʡַ',
        'utf8' => 'UTF-8',
        'false' => '',
        'SystemID' => 'ϵͳID',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(ϵͳʶ. Ticket ź http Ựʶͷ)',
        'System FQDN' => 'ϵͳ',
        '(Full qualified domain name of your system)' => '(ϵͳ)',
        'AdminEmail' => 'Աַ',
        '(Email of the system admin)' => '(ϵͳԱʼַ)',
        'Organization' => '֯',
        'Log' => '־',
        'LogModule' => '־ģ',
        '(Used log backend)' => 'ʹ־',
        'Logfile' => '־ļ',
        '(Logfile just needed for File-LogModule!)' => '(ֻм File-LogModule ʱҪ Logfile!)',
        'Webfrontend' => 'Web ǰ',
        'Use utf-8 it your database supports it!' => 'ݿ֧֣ʹUTF-8ַ!',
        'Default Language' => 'ȱʡ',
        '(Used default language)' => '(ʹȱʡ)',
        'CheckMXRecord' => ' MX ¼',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => 'ͨ׫дùĵʼַMX¼OTRSڲŽĵ벻ҪʹCheckMXRecord!',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'ΪܹʹOTRS, root(Terminal/Shell).',
        'Restart your webserver' => ' webserver.',
        'After doing so your OTRS is up and running.' => 'ɺ OTRS ϵͳ.',
        'Start page' => 'ʼҳ',
        'Your OTRS Team' => ' OTRS С.',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Ȩ',

        # Template: Notify
        'Important' => 'Ҫ',

        # Template: PrintFooter
        'URL' => 'ַ',

        # Template: PrintHeader
        'printed by' => 'ӡ',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: Test
        'OTRS Test Page' => 'OTRS ҳ',
        'Counter' => '',

        # Template: Warning

        # Misc
        'Edit Article' => '༭ż',
        'Create Database' => 'ݿ',
        'DB Host' => 'ݿ',
        'Ticket Number Generator' => 'Ticket ',
        'Create new Phone Ticket' => 'µĵ绰 Ticket',
        'Symptom' => '֢״',
        'U' => '',
        'Site' => 'վ',
        'Customer history search (e. g. "ID342425").' => 'ͻʷ (磺 "ID342425").',
        'Can not delete link with %s!' => 'ɾ %s ',
        'for agent firstname' => '֧Ա ',
        'Close!' => 'ر!',
        'No means, send agent and customer notifications on changes.' => 'иıʱ֪ͨԱͻ.',
        'A web calendar' => 'Web ',
        'to get the realname of the sender (if given)' => 'ʼ˵ʵ ()',
        'OTRS DB Name' => 'ݿ',
        'Notification (Customer)' => '֪ͨ(ͻ)',
        'Select Source (for add)' => 'ѡԴ(ӹʹ)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'ѡ ticket  (: &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Ӷ',
        'Days' => '',
        'Queue ID' => 'б',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'ѡ (:<OTRS_CONFIG_HttpType>)',
        'System History' => 'ϵͳʷ',
        'customer realname' => 'ͻʵ',
        'Pending messages' => 'Ϣתȴ״̬',
        'for agent login' => '֧Ա ¼',
        'Keyword' => 'ؼ',
        'Close type' => 'ر',
        'DB Admin User' => 'ݿԱû',
        'for agent user id' => '֧Ա û',
        'Change user <-> group settings' => '޸ û <->  ',
        'Problem' => '',
        'Escalation' => '',
        '"}' => '',
        'Order' => '',
        'next step' => 'һ',
        'Follow up' => '',
        'Customer history search' => 'ͻʷ',
        'PostMaster Mail Account' => 'ʼʺŹ',
        'Stat#' => 'ͳƺ',
        'Create new database' => 'µݿ',
        'Go' => 'ִ',
        'Keywords' => 'ؼ',
        'Ticket Escalation View' => '鿴 Ticket',
        'Today' => '',
        'No * possible!' => 'ʹͨ "*" !',
        'Load' => '',
        'PostMaster Filter' => 'ʼݹ',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'ѡǰû˭Ҫ (: &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Message for new Owner' => 'ߵϢ',
        'to get the first 5 lines of the email' => 'ʼǰ5',
        'Sort by' => '',
        'OTRS DB Password' => 'OTRS û',
        'Last update' => '',
        'Tomorrow' => '',
        'not rated' => '',
        'to get the first 20 character of the subject' => 'ʼǰ20ַ',
        'Select the customeruser:service relations.' => 'ѡͻͷϵ.',
        'DB Admin Password' => 'ϵͳԱ',
        'Drop Database' => 'ɾݿ',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'ԶxᡣѡһͨѡťȻѡԪϵԡѡκ, ôһͳƵʱԪصԽʹáһµԱµϴ',
        'FileManager' => 'ļ',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'ǰͻûϢ (: <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => '',
        'Comment (internal)' => 'ע (ڲ)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'õ Ticket Ϣ (: &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'õй Ticket Ϣ (: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(ʹ Ticket Ÿʽ)',
        'Reminder' => '',
        'OTRS DB connect host' => 'OTRS ݿ',
        'All Agent variables.' => 'еļԱ',
        ' (work units)' => 'Ԫ',
        'Next Week' => '',
        'All Customer variables like defined in config option CustomerUser.' => 'пͻѡCustomerUserж',
        'for agent lastname' => '֧Ա ',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Ϣ (: <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Ϣ',
        'Parent-Object' => '',
        'Of couse this feature will take some system performance it self!' => 'Ȼ, ùܻռһϵͳԴ, ϵͳĸ!',
        'Your own Ticket' => 'Լ Ticket',
        'Detail' => 'ϸ',
        'TicketZoom' => 'Ticket չ',
        'Open Tickets' => ' Tickets',
        'Don\'t forget to add a new user to groups!' => 'Ҫµû!',
        'General Catalog' => 'Ŀ¼',
        'CreateTicket' => ' Ticket',
        'You have to select two or more attributes from the select field!' => 'ѡֶѡϵ',
        'System Settings' => 'ݿ ',
        'Finished' => '',
        'D' => '',
        'All messages' => 'Ϣ',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'ѡ ticket  (: <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Object already linked as %s.' => 'ӵ %s.',
        'A article should have a title!' => '±б!',
        'Customer Users <-> Services' => 'ͻʺ <-> ',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'ѡ (: &lt;OTRS_CONFIG_HttpType&gt;)',
        'All email addresses get excluded on replaying on composing and email.' => 'бȡ׫дʼܵʼַ',
        'A web mail client' => 'WebMail ͻ',
        'Compose Follow up' => '׫дٴ',
        'WebMail' => 'WebMail',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Ticket ѡ (: <OTRS_OWNER_UserFirstname>)',
        'DB Type' => 'ݿ',
        'kill all sessions' => 'ֹлỰ',
        'to get the from line of the email' => 'ʼ',
        'Solution' => '',
        'QueueView' => 'ͼ',
        'My Queue' => 'ҵĶ',
        'Select Box' => 'ѡ񷽿',
        'New messages' => 'Ϣ',
        'Can not create link with %s!' => 'Ϊ %s ',
        'Linked as' => 'Ϊ',
        'modified' => '޸',
        'Delete old database' => 'ɾݿ',
        'A web file manager' => 'Web ļ',
        'Have a lot of fun!' => 'Have a lot of fun!',
        'send' => '',
        'QuickSearch' => '',
        'Send no notifications' => '֪ͨ',
        'Note Text' => 'ע',
        'POP3 Account Management' => 'POP3 ʻ',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'System State Management' => 'ϵͳ״̬',
        'OTRS DB User' => 'OTRS ݿû',
        'Mailbox' => '',
        'PhoneView' => '绰ͼ',
        'maximal period form' => 'ڱ',
        'Escaladed Tickets' => '',
        'Yes means, send no agent and customer notifications on changes.' => 'иıʱ֪ͨԱͻ.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'ʼ : "<OTRS_TICKET>" ˵ "<OTRS_BOUNCE_TO>" . ϵµַȡϸϢ.',
        'Ticket Status View' => 'Ticket ״̬ͼ',
        'Modified' => '޸',
        'Ticket selected for bulk action!' => 'ѡн Tickets',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
    };
    # $$STOP$$
    return;
}

1;
