# --
# Kernel/Language/hu.pm - provides hu language translation
# Copyright (C) 2006 Gabor Gancs /gg@magicnet.hu/
# Copyright (C) 2006 Krisztian Gancs /krisz@gancs.hu/
# Copyright (C) 2006 Flora Szabo /szaboflora@magicnet.hu/
# Copyright (C) 2007 Aron Ujvari <ujvari@hungary.com>
# Copyright (C) 2009 Arnold Matyasi <arn@webma.hu>
# --
# $Id: hu.pm,v 1.72 2009/08/25 12:19:24 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::hu;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.72 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sat Jun 27 13:55:18 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-2', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%Y.%M.%D %T';
    $Self->{DateFormatLong}      = '%Y %B %D %A %T';
    $Self->{DateFormatShort}     = '%Y.%M.%D';
    $Self->{DateInputFormat}     = '%Y.%M.%D';
    $Self->{DateInputFormatLong} = '%Y.%M.%D - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Igen',
        'No' => 'Nem',
        'yes' => 'igen',
        'no' => 'nem',
        'Off' => 'Ki',
        'off' => 'ki',
        'On' => 'Be',
        'on' => 'be',
        'top' => 'Teteje',
        'end' => 'vge',
        'Done' => 'Ksz',
        'Cancel' => 'Mgsem',
        'Reset' => 'Alaplls',
        'last' => 'legfeljebb ennyi ideje',
        'before' => 'legalbb ennyi ideje',
        'day' => 'nap',
        'days' => 'nap',
        'day(s)' => 'nap',
        'hour' => 'ra',
        'hours' => 'ra',
        'hour(s)' => 'ra',
        'minute' => 'Perc',
        'minutes' => 'perc',
        'minute(s)' => 'perc',
        'month' => 'hnap',
        'months' => 'hnap',
        'month(s)' => 'hnap',
        'week' => 'ht',
        'week(s)' => 'ht',
        'year' => 'v',
        'years' => 'v',
        'year(s)' => 'v',
        'second(s)' => 'mp',
        'seconds' => 'mp',
        'second' => 'mp',
        'wrote' => 'rta',
        'Message' => 'zenet',
        'Error' => 'Hiba',
        'Bug Report' => 'Hibajelents',
        'Attention' => 'Figyelem',
        'Warning' => 'Figyelem',
        'Module' => 'Modul',
        'Modulefile' => 'Modulfile',
        'Subfunction' => 'Alfunkci',
        'Line' => 'Vonal',
        'Setting' => 'Bellts',
        'Settings' => 'Belltsok',
        'Example' => 'Plda',
        'Examples' => 'Plda',
        'valid' => 'rvnyes',
        'invalid' => 'rvnytelen',
        '* invalid' => '* rvnytelen',
        'invalid-temporarily' => 'ideiglenesen rvnytelen',
        ' 2 minutes' => ' 2 Perc',
        ' 5 minutes' => ' 5 Perc',
        ' 7 minutes' => ' 7 Perc',
        '10 minutes' => '10 Perc',
        '15 minutes' => '15 Perc',
        'Mr.' => 'Mr.',
        'Mrs.' => 'Mrs.',
        'Next' => 'Kvetkez',
        'Back' => 'Vissza',
        'Next...' => 'Kvetkez...',
        '...Back' => '...Vissza',
        '-none-' => '-nincs-',
        'none' => 'semmi',
        'none!' => 'semmi!',
        'none - answered' => 'semmi - megvlaszolt',
        'please do not edit!' => 'krjk ne javtsa!',
        'AddLink' => 'Kapcsolat hozzadsa',
        'Link' => 'Kapcsolat',
        'Unlink' => 'Kapcsolat feloldsa',
        'Linked' => 'Kapcsolat',
        'Link (Normal)' => 'Link (Norml)',
        'Link (Parent)' => 'Link (Szl)',
        'Link (Child)' => 'Link (Gyerek)',
        'Normal' => 'Norml',
        'Parent' => 'Szl',
        'Child' => 'Gyerek',
        'Hit' => 'Tallat',
        'Hits' => 'Tallatok',
        'Text' => 'Szveg',
        'Lite' => 'Egyszer',
        'User' => 'Felhasznl',
        'Username' => 'Felhasznlnv',
        'Language' => 'Nyelv',
        'Languages' => 'Nyelv',
        'Password' => 'Jelsz',
        'Salutation' => 'Megszlts',
        'Signature' => 'Alrs',
        'Customer' => 'gyfl',
        'CustomerID' => 'gyflazonost',
        'CustomerIDs' => 'gyflazonostk',
        'customer' => 'gyfl',
        'agent' => 'gyintz',
        'system' => 'rendszer',
        'Customer Info' => 'gyfl Info',
        'Customer Company' => 'gyfl cg',
        'Company' => 'Cg',
        'go!' => 'Indts!',
        'go' => 'indts',
        'All' => 'sszes',
        'all' => 'sszes',
        'Sorry' => 'Sajnlom',
        'update!' => 'Mdosts!',
        'update' => 'mdosts',
        'Update' => 'Mdosts',
        'Updated!' => 'Frisstve!',
        'submit!' => 'Elklds!',
        'submit' => 'elklds',
        'Submit' => 'Elklds',
        'change!' => 'Vltoztats!',
        'Change' => 'Vltoztats',
        'change' => 'vltoztats',
        'click here' => 'kattints ide',
        'Comment' => 'Megjegyzs',
        'Valid' => 'rvnyessg',
        'Invalid Option!' => 'rvnytelen bellts',
        'Invalid time!' => 'Hibs idpont!',
        'Invalid date!' => 'Hibs dtum!',
        'Name' => 'Nv',
        'Group' => 'Csoport',
        'Description' => 'Lers',
        'description' => 'lers',
        'Theme' => 'Tma',
        'Created' => 'Ltrehozs ideje',
        'Created by' => 'Ltrehozta',
        'Changed' => 'Mdosts ideje',
        'Changed by' => 'Mdostotta',
        'Search' => 'Keress',
        'and' => 's',
        'between' => 'kztt',
        'Fulltext Search' => 'Szabadszavas Keress',
        'Data' => 'Adat',
        'Options' => 'Belltsok',
        'Title' => 'Cm',
        'Item' => 'Ttel',
        'Delete' => 'Trls',
        'Edit' => 'Szerkeszts',
        'View' => 'Nzet',
        'Number' => 'Szm',
        'System' => 'Rendszer',
        'Contact' => 'Kapcsolat',
        'Contacts' => 'Kapcsolatok',
        'Export' => 'Exportl',
        'Up' => 'Fel',
        'Down' => 'Le',
        'Add' => 'Hozzads',
        'Added!' => 'Hozzadva!',
        'Category' => 'Kategria',
        'Viewer' => 'Nz',
        'Expand' => 'Bvt',
        'New message' => 'j zenet',
        'New message!' => 'j zenet!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Krjk vlaszoljon erre(ezekre) a jegy(ek)re hogy visszatrhessen a norml vrlista nzethez!',
        'You got new message!' => 'j zenete rkezett!',
        'You have %s new message(s)!' => '%s j zenete van!',
        'You have %s reminder ticket(s)!' => '%s emlkeztet jegye van!',
        'The recommended charset for your language is %s!' => 'Az ajnlott karakterkszlet az n nyelvnl %s!',
        'Passwords doesn\'t match! Please try it again!' => 'A jelszavak nem egyeznek! Prblja meg jra!',
        'Password is already in use! Please use an other password!' => 'A jelsz mr hasznlatban van! Krem vlasszon msikat!',
        'Password is already used! Please use an other password!' => 'A jelsz mr hasznlatban van! Krem vlasszon msikat!',
        'You need to activate %s first to use it!' => '%s aktivlsra van szksg mieltt hasznln!',
        'No suggestions' => 'Nincsenek javaslatok',
        'Word' => 'Sz',
        'Ignore' => 'Figyelmen kvl hagy',
        'replace with' => 'csere ezzel',
        'There is no account with that login name.' => 'Azzal a nvvel nincs azonost.',
        'Login failed! Your username or password was entered incorrectly.' => 'Belps sikertelen! Hibsan adta meg a felhasznli nevt vagy jelszavt.',
        'Please contact your admin' => 'Krjk vegye fel a kapcsolatot a rendszergazdjval',
        'Logout successful. Thank you for using OTRS!' => 'Kilps megtrtnt! Ksznjk, hogy az OTRS-t hasznlja!',
        'Invalid SessionID!' => 'Hibs folyamat azonost!',
        'Feature not active!' => 'Kpessg nem aktv!',
        'Notification (Event)' => 'rtests (Event)',
        'Login is needed!' => 'Belps szksges!',
        'Password is needed!' => 'Jelsz szksges!',
        'License' => 'Licensz',
        'Take this Customer' => 'tveszi ez az gyfl',
        'Take this User' => 'tveszi ez a felhasznl',
        'possible' => 'lehetsges',
        'reject' => 'elutasts',
        'reverse' => 'fordtott',
        'Facility' => 'Kpessg',
        'Timeover' => 'Kss',
        'Pending till' => 'Vrakozs eddig',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Ne dolgozzon az 1-es felhasznlval (Rendszer jogosultsg)! Hozzon ltre j felhasznlt!',
        'Dispatching by email To: field.' => 'Sztvlogats az e-mail cmzett mezje szerint.',
        'Dispatching by selected Queue.' => 'Sztvlogats a kivlasztott vrlista szerint.',
        'No entry found!' => 'Nem tallhat ttel!',
        'Session has timed out. Please log in again.' => 'Az folyamat idtllps miatt befejezdtt. Krjk lpjen be jra.',
        'No Permission!' => 'Nincs jogosultsg!',
        'To: (%s) replaced with database email!' => 'Cmzett: (%s) fellrva az adatbzis cmmel!',
        'Cc: (%s) added database email!' => 'Msolat: (%s) e-mail cme hozzadva az adatbzishoz!',
        '(Click here to add)' => '(Kattinston ide a hozzadshoz)',
        'Preview' => 'Elnzet',
        'Package not correctly deployed! You should reinstall the Package again!' => 'A csomag nincsen megfelelen teleptve! Teleptse jra a csomagot!',
        'Added User "%s"' => 'A "%s" felhasznl hozzadva',
        'Contract' => 'Kapcsolat',
        'Online Customer: %s' => 'Bejelentkezett gyfl: %s',
        'Online Agent: %s' => 'Bejelentkezett gyintz: %s',
        'Calendar' => 'Naptr',
        'File' => 'Fjl',
        'Filename' => 'Fjlnv',
        'Type' => 'Tpus',
        'Size' => 'Mret',
        'Upload' => 'Feltlts',
        'Directory' => 'Knyvtr',
        'Signed' => 'Alrt',
        'Sign' => 'Alrs',
        'Crypted' => 'Kdolt',
        'Crypt' => 'Kdols',
        'Office' => 'Iroda',
        'Phone' => 'Telefonszm',
        'Fax' => 'Fax szm',
        'Mobile' => 'Mobil szm',
        'Zip' => 'Irnytszm',
        'City' => 'Vros',
        'Street' => 'Utca',
        'Country' => 'Orszg',
        'Location' => 'Hely',
        'installed' => 'teleptett',
        'uninstalled' => 'nem teleptett',
        'Security Note: You should activate %s because application is already running!' => 'Biztonsgi megjegyzs: Aktivlnia kellene a %s modult, mert az alakalmazs mr fut!',
        'Unable to parse Online Repository index document!' => 'Nem sikerlt rtelmezni az on-line csomagtrol index dokumentumt!',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Nincsenek csomagok a krt Keretrendszerhez ebben az on-line csomagtrolban, viszont vannak ms Keretrendszerekhez!',
        'No Packages or no new Packages in selected Online Repository!' => 'Nincsenek csomagok vagy nincsenek j csomagok a kivlasztott on-line csomagtrolban!',
        'printed at' => 'nyomtatva',
        'Dear Mr. %s,' => 'Kedves %s r!',
        'Dear Mrs. %s,' => 'Kedves %s Hlgy',
        'Dear %s,' => 'Kedves %s!',
        'Hello %s,' => 'Hello %s!',
        'This account exists.' => 'Ez a felhasznl mr ltezik.',
        'New account created. Sent Login-Account to %s.' => 'j felhasznl ltrehozva. Belpsi informci %s rszre elkldve.',
        'Please press Back and try again.' => 'Krem nyomja meg a Vissza gombot s prblja jra!',
        'Sent password token to: %s' => 'Jelsz token %s rszre elkldve.',
        'Sent new password to: %s' => 'j jelsz %s rszre elkldve.',
        'Upcoming Events' => 'Kvetkez esemnyek',
        'Event' => 'Esemny',
        'Events' => 'Esemny',
        'Invalid Token!' => 'rvnytelen token!',
        'more' => 'tovbb',
        'For more info see:' => 'Tovbbi informcirt:',
        'Package verification failed!' => 'Csomag ellenrzs nem sikerlt!',
        'Collapse' => 'sszecsuk',
        'News' => 'Hrek',
        'Product News' => 'Termk hrek',
        'Bold' => 'Kvr',
        'Italic' => 'Dlt',
        'Underline' => 'Alhzott',
        'Font Color' => 'Bet szn',
        'Background Color' => 'Httr szn',
        'Remove Formatting' => 'Formzs eltvoltsa',
        'Show/Hide Hidden Elements' => 'Mutatja/Elrejti a rejtett elemeket ',
        'Align Left' => 'Balra rendez',
        'Align Center' => 'Kzpre rendez',
        'Align Right' => 'Jobbra rendez',
        'Justify' => 'Sorkizr',
        'Header' => 'Fejlc',
        'Indent' => 'Bekezds befele',
        'Outdent' => 'Bekezds kifele',
        'Create an Unordered List' => 'Sorszmozatlan lista ltrehozsa',
        'Create an Ordered List' => 'Sorszmozott lista ltrehozsa',
        'HTML Link' => 'HTML Link',
        'Insert Image' => 'Kp beszrsa',
        'CTRL' => 'CRTL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'Visszavon',
        'Redo' => 'jravon',

        # Template: AAAMonth
        'Jan' => 'Jan',
        'Feb' => 'Feb',
        'Mar' => 'Mr',
        'Apr' => 'pr',
        'May' => 'Mj',
        'Jun' => 'Jn',
        'Jul' => 'Jl',
        'Aug' => 'Aug',
        'Sep' => 'Sze',
        'Oct' => 'Okt',
        'Nov' => 'Nov',
        'Dec' => 'Dec',
        'January' => 'Janur',
        'February' => 'Februr',
        'March' => 'Mrcius',
        'April' => 'prilis',
        'May_long' => 'Mjus',
        'June' => 'Jnius',
        'July' => 'Jlius',
        'August' => 'Augusztus',
        'September' => 'Szeptember',
        'October' => 'Oktber',
        'November' => 'November',
        'December' => 'December',

        # Template: AAANavBar
        'Admin-Area' => 'Adminisztrcis-terlet',
        'Agent-Area' => 'gyintz-terlet',
        'Ticket-Area' => 'Jegy-terlet',
        'Logout' => 'Kilps',
        'Agent Preferences' => 'gyintz belltsai',
        'Preferences' => 'Belltsok',
        'Agent Mailbox' => 'gyintz postafikja',
        'Stats' => 'Statisztika',
        'Stats-Area' => 'Statisztika-terlet',
        'Admin' => 'Adminisztrci',
        'Customer Users' => 'gyfl felhasznlk',
        'Customer Users <-> Groups' => 'gyfl felhasznlk <-> Csoportok',
        'Users <-> Groups' => 'Felhasznlk <-> Csoportok',
        'Roles' => 'Szerepek',
        'Roles <-> Users' => 'Szerepek <-> Felhasznlk',
        'Roles <-> Groups' => 'Szerepek <-> Csoportok',
        'Salutations' => 'Megszltsok',
        'Signatures' => 'Alrsok',
        'Email Addresses' => 'E-mail cmek',
        'Notifications' => 'rtestsek',
        'Category Tree' => 'Kategria Fa',
        'Admin Notification' => 'Adminsztrtori rtestsek',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Belltsok sikeresen frisstve!',
        'Mail Management' => 'E-mail kezels',
        'Frontend' => 'Felhasznli fellet',
        'Other Options' => 'Egyb belltsok',
        'Change Password' => 'Jelsz megvltoztatsa',
        'New password' => 'j jelsz',
        'New password again' => 'j jelsz megismtlse',
        'Select your QueueView refresh time.' => 'Vlassza ki a Vrlista nzet frisstsi idejt.',
        'Select your frontend language.' => 'Vlassza ki a felhasznli fellet nyelvt.',
        'Select your frontend Charset.' => 'Vlassza ki a felhasznli fellet karakterkszlett.',
        'Select your frontend Theme.' => 'Vlassza ki a felhasznli fellet stlust.',
        'Select your frontend QueueView.' => 'Vlassza ki a felhasznli fellet Vrlista nzett.',
        'Spelling Dictionary' => 'Helyesrs-ellenrz sztr',
        'Select your default spelling dictionary.' => 'Vlassza ki az alaprtelmezett helyesrsellenrz sztrat.',
        'Max. shown Tickets a page in Overview.' => 'Max. megjelentett jegy az ttekintsnl.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Nem sikerlt modostani a jelszt, a jelszavak nem egyeznek! Krem prblja jra!',
        'Can\'t update password, invalid characters!' => 'Nem sikerlt modostani a jelszt, rvnytelen karakterek!',
        'Can\'t update password, must be at least %s characters!' => 'Nem sikerlt modostani a jelszt, legalbb %s karakter megadsa szksges!',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Nem sikerlt modostani a jelszt, legalbb 2 kisbetnek s 2 nagybetnek kell benne szerepelnie!',
        'Can\'t update password, needs at least 1 digit!' => 'Nem sikerlt modostani a jelszt, legalbb egy szmjegynek kell benne szerepelnie!',
        'Can\'t update password, needs at least 2 characters!' => 'Nem sikerlt modostani a jelszt, legalbb 2 karakter megadsa szksges!',

        # Template: AAAStats
        'Stat' => 'Statisztika',
        'Please fill out the required fields!' => 'Krem tltse ki a ktelez mezket!',
        'Please select a file!' => 'Krem vlasszon egy fjlt!',
        'Please select an object!' => 'Krem vlasszok egy objektumot!',
        'Please select a graph size!' => 'Krem vlasszon egy grafikon mretet!',
        'Please select one element for the X-axis!' => 'Krem vlasszon egy tulajdonsgot az X tengelynek',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Krem vlasszon egy rtket vagy kapcsolja ki a \'Rgztett\' kapcsolt a megjellt meznl.',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Ha egy jellngyzetet hasznl, akkor nhny rtket is ki kell vlasztania a tulajdonsghoz!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Adjon meg egy rtket a bemeneti mezben vagy kapcsolja ki a \'Rgztett\' kapcsolt!',
        'The selected end time is before the start time!' => 'A befejezsi idnek a kezdeti id utn kell lennie!',
        'You have to select one or more attributes from the select field!' => 'Vlasszon ki egy vagy tbb rtket a mezbl!',
        'The selected Date isn\'t valid!' => 'A kivlasztott dtum rvnytelen!',
        'Please select only one or two elements via the checkbox!' => 'Krem vlasszon egy vagy kt elemet a jellngyetekbl!',
        'If you use a time scale element you can only select one element!' => 'Amennyiben egy idskla elemet is vlasztott, akkro csak egy elemet vlaszthat kzlk!',
        'You have an error in your time selection!' => 'Hibs a kivlasztott id!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'A kivlasztott id intervallum tl kicsi, krem vlasszon nagyobb sklt.',
        'The selected start time is before the allowed start time!' => 'A kivlasztott kezdsi id a megengedett kezdsi id eltt van!',
        'The selected end time is after the allowed end time!' => 'A kivlasztott befejezsi id a megengedett befejezsi id utn van!',
        'The selected time period is larger than the allowed time period!' => 'A kivlasztott ismtlds a megengedett ismtldsnl nagyobb!',
        'Common Specification' => 'ltalnos belltsok',
        'Xaxis' => 'X tengely',
        'Value Series' => 'Megjelentett rtkek',
        'Restrictions' => 'Megktsek',
        'graph-lines' => 'Grafikon - vonalak',
        'graph-bars' => 'Grafikon - oszlopok',
        'graph-hbars' => 'Grafikon - vzszintes oszlopok',
        'graph-points' => 'Grafikon - pontok',
        'graph-lines-points' => 'Grafikon - vonalak-pontok',
        'graph-area' => 'Grafikon - terlet',
        'graph-pie' => 'Grafikon - torta',
        'extended' => 'Kiterjesztett',
        'Agent/Owner' => 'gyintz/Tulajdonos',
        'Created by Agent/Owner' => 'Letrehoz gyintz/tulajdonos',
        'Created Priority' => 'Ltrehozskori priorits',
        'Created State' => 'Ltrehozskori llapot',
        'Create Time' => 'Ltrehozs ideje',
        'CustomerUserLogin' => 'gyfl felhasznlneve',
        'Close Time' => 'Lezrs ideje',
        'TicketAccumulation' => 'Jegytrols',
        'Attributes to be printed' => 'Nyomtatand jellemzk',
        'Sort sequence' => 'Sorrendbe rendez',
        'Order by' => 'Sorrend',
        'Limit' => 'Sorok szma legfeljebb',
        'Ticketlist' => 'Jegylista',
        'ascending' => 'nvekv',
        'descending' => 'cskken',
        'First Lock' => 'Els zrols',
        'Evaluation by' => 'rtkels',
        'Total Time' => 'Teljes Id',
        'Ticket Average' => 'Jegy tlag',
        'Ticket Min Time' => 'Jegy min. id',
        'Ticket Max Time' => 'Jegy max. id',
        'Number of Tickets' => 'Jegyek szma',
        'Article Average' => 'Cikk ltag',
        'Article Min Time' => 'Cikk min. id',
        'Article Max Time' => 'Cikk max. id',
        'Number of Articles' => 'Cikkek szma',
        'Accounted time by Agent' => 'gyintz lal elszmolt id',
        'Ticket/Article Accounted Time' => 'Jegy/Cikk elszmolt id',
        'TicketAccountedTime' => 'JegyElszmoltId',
        'Ticket Create Time' => 'Jegy ltrehozsnak ideje',
        'Ticket Close Time' => 'Jegy lezrsnak ideje',

        # Template: AAATicket
        'Lock' => 'Zrols',
        'Unlock' => 'Felolds',
        'History' => 'Elzmnyek',
        'Zoom' => 'Rszletek',
        'Age' => 'Kor',
        'Bounce' => 'Visszaklds',
        'Forward' => 'Tovbbts',
        'From' => 'Felad',
        'To' => 'Cmzett',
        'Cc' => 'Msolat',
        'Bcc' => 'Rejtett msolat',
        'Subject' => 'Trgy',
        'Move' => 'thelyezs',
        'Queue' => 'Vrlista',
        'Priority' => 'Priorits',
        'Priority Update' => 'Priorits mdostsa',
        'State' => 'llapot',
        'Compose' => 'Kszt',
        'Pending' => 'Vrakozik',
        'Owner' => 'Tulajdonos',
        'Owner Update' => 'Tulajdonos mdostsa',
        'Responsible' => 'Felels',
        'Responsible Update' => 'Felels mdostsa',
        'Sender' => 'Kld',
        'Article' => 'Bejegyzs',
        'Ticket' => 'Jegy',
        'Createtime' => 'Ltrehozs ideje',
        'plain' => 'sima',
        'Email' => 'E-mail',
        'email' => 'e-mail',
        'Close' => 'Lezrs',
        'Action' => 'Mvelet',
        'Attachment' => 'Levlmellklet',
        'Attachments' => 'Levlmellkletek',
        'This message was written in a character set other than your own.' => 'Ezt az zenetet ms karakterkszlettel rtk mint amit n hasznl.',
        'If it is not displayed correctly,' => 'Ha nem helyesen jelent meg,',
        'This is a' => 'Ez egy',
        'to open it in a new window.' => 'hogy megnyissa j ablakban.',
        'This is a HTML email. Click here to show it.' => 'Ez egy HTML e-mail. Kattintson ide a megtekintshez.',
        'Free Fields' => 'Szabad mezk',
        'Merge' => 'Egyests',
        'merged' => 'egyestett',
        'closed successful' => 'sikeresen lezrva',
        'closed unsuccessful' => 'sikertelenl lezrva',
        'new' => 'j',
        'open' => 'nyitott',
        'Open' => 'Nyitott',
        'closed' => 'lezrt',
        'Closed' => 'Lezrt',
        'removed' => 'trlt',
        'pending reminder' => 'emlkeztetre vrakozik',
        'pending auto' => 'automatikusra vrakozik',
        'pending auto close+' => 'automatikus zrsra vrakozik+',
        'pending auto close-' => 'automatikus zrsra vrakozik-',
        'email-external' => 'kls e-mail',
        'email-internal' => 'bels e-mail',
        'note-external' => 'kls jegyzet',
        'note-internal' => 'bels jegyzet',
        'note-report' => 'jegyzet jelents',
        'phone' => 'telefon',
        'sms' => 'sms',
        'webrequest' => 'webkrs',
        'lock' => 'zrolt',
        'unlock' => 'feloldott',
        'very low' => 'nagyon alacsony',
        'low' => 'alacsony',
        'normal' => 'norml',
        'high' => 'magas',
        'very high' => 'nagyon magas',
        '1 very low' => '1 nagyon alacsony',
        '2 low' => '2 alacsony',
        '3 normal' => '3 norml',
        '4 high' => '4 magas',
        '5 very high' => '5 nagyon magas',
        'Ticket "%s" created!' => 'A "%s" jegy ltrehozva!',
        'Ticket Number' => 'Jegy szma',
        'Ticket Object' => 'Jegy objektum',
        'No such Ticket Number "%s"! Can\'t link it!' => 'Nincs "%s" szm jegy! Nem tudom csatolni!',
        'Don\'t show closed Tickets' => 'Ne jelentse meg a lezrt jegyeket.',
        'Show closed Tickets' => 'Mutasd a lezrt jegyeket',
        'New Article' => 'j bejegyzs',
        'Email-Ticket' => 'E-mail jegy',
        'Create new Email Ticket' => 'j E-mail Jegy ltrehozsa',
        'Phone-Ticket' => 'Telefon-jegy',
        'Search Tickets' => 'Jegyek keresse',
        'Edit Customer Users' => 'gyfl felhasznl szerkesztse',
        'Edit Customer Company' => 'gyfl cg szerkesztse',
        'Bulk Action' => 'Csoportos mvelet',
        'Bulk Actions on Tickets' => 'Csoportos mvelet jegyeken',
        'Send Email and create a new Ticket' => 'E-mail kldse s j Jegy ltrehozsa',
        'Create new Email Ticket and send this out (Outbound)' => 'j E-mail jegy ltrehozsa s kikldse (Kimen)',
        'Create new Phone Ticket (Inbound)' => 'j Telefon-jegy ltrehozsa (Bejv)',
        'Overview of all open Tickets' => 'sszes nyitott jegy ttekintse',
        'Locked Tickets' => 'Zrolt jegyek',
        'Watched Tickets' => 'Kvetett jegyek',
        'Watched' => 'Kvetett',
        'Subscribe' => 'Feliratkozs',
        'Unsubscribe' => 'Leiratkozs',
        'Lock it to work on it!' => 'Jegy zrolsa, hogy dolgozzon rajta!',
        'Unlock to give it back to the queue!' => 'Oldja fl, hogy visszakerljn a vrlistba!',
        'Shows the ticket history!' => 'Jegy elzmnyeinek megjelentse!',
        'Print this ticket!' => 'Jegy nyomtatsa!',
        'Change the ticket priority!' => 'Jegy prioritsnak mdostsa!',
        'Change the ticket free fields!' => 'Jegy szabad mezinek mdostsa!',
        'Link this ticket to an other objects!' => 'sszekapcsolja a jegyet egy msik objektummal!',
        'Change the ticket owner!' => 'Jegy tulajdonosnak mdostsa!',
        'Change the ticket customer!' => 'Jegyhez tartoz gyfl mdostsa!',
        'Add a note to this ticket!' => 'Megjegyzs rsa a jegyhez!',
        'Merge this ticket!' => 'Egyesti a jegyet egy msikkal!',
        'Set this ticket to pending!' => 'Jegy vrakoz llapotba helyezse!',
        'Close this ticket!' => 'Jegy lezrsa!',
        'Look into a ticket!' => 'Jegy rszletesebb megtekintse!',
        'Delete this ticket!' => 'Jegy trlse!',
        'Mark as Spam!' => 'Jegy spamnek jellse!',
        'My Queues' => 'Sajt vrlistim',
        'Shown Tickets' => 'Megjelentett jegyek',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Az n "<OTRS_TICKET>" jegy szmmal rendelkez e-mailje egyestsre kerlt a "<OTRS_MERGE_TO_TICKET>" jeggyel.',
        'Ticket %s: first response time is over (%s)!' => 'Jegy %s: els vlasz ideje letelt (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Jegy %s: els vlasz ideje le fog telni %s idn bell!',
        'Ticket %s: update time is over (%s)!' => 'Jegy %s: frissts ideje letelt (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Jegy %s: frissts ideje le fog telni %s idn bell!',
        'Ticket %s: solution time is over (%s)!' => 'Jegy %s: megolds ideje letelt (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Jegy %s: megolds ideje le fog telni %s idn bell!',
        'There are more escalated tickets!' => 'Tbb kiemelt jegy van!',
        'New ticket notification' => 'j jegy rtests',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Kldjn nekem rtestst, ha j jegy van a "Sajt vrlistim"-ban.',
        'Follow up notification' => 'Vlaszlevl rtests',
        'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Kldjn rtestst ha az gyfl vlaszol s n vagyok a tulajdonosa a jegynek.',
        'Ticket lock timeout notification' => 'Jegyzrols-lejrat rtests',
        'Send me a notification if a ticket is unlocked by the system.' => 'Kldjn rtestst ha egy jegy zrolst a renszer feloldotta.',
        'Move notification' => 'thelyezs rtests',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Kldjn nekem rtestst, ha egy jegyet a "Sajt vrlistim" egyikbe mozgattk.',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Sajt vrlistknak tekintett vrlistk kivlasztsa. E-mail rtesttsek fog kapni ezekrl a vrlistkrl, amennyiben ez engedlyezett.',
        'Custom Queue' => 'Egyedi vrlistk',
        'QueueView refresh time' => 'Vrlista nzet frisstsi ideje',
        'Screen after new ticket' => 'j jegy utni kperny',
        'Select your screen after creating a new ticket.' => 'Vlassza ki a kpernyt j jegy ltrehozsa utn.',
        'Closed Tickets' => 'Lezrt jegyek',
        'Show closed tickets.' => 'Mutasd a lezrt jegyeket.',
        'Max. shown Tickets a page in QueueView.' => 'A megjelentett jegyek szmnak maximuma a Vrlista nzetnl.',
        'Watch notification' => 'Figyels rtest',
        'Send me a notification of an watched ticket like an owner of an ticket.' => 'Kldjn rtestst a figyelt jegyrl gy minta a jegy tulajdonosa lenne.',
        'Out Of Office' => 'Hzon kvl',
        'Select your out of office time.' => 'Vlassza ki a hzon kvl tltend idt.',
        'CompanyTickets' => 'Cg jegyek',
        'MyTickets' => 'Sajt jegyek',
        'New Ticket' => 'j jegy',
        'Create new Ticket' => 'j jegy ltrehozsa',
        'Customer called' => 'gyfl telefonlt',
        'phone call' => 'telefonhvs',
        'Reminder Reached' => 'Emlkeztet lejrt',
        'Reminder Tickets' => 'Emlkeztet Jegyek',
        'Escalated Tickets' => 'Eszkallt Jegyek',
        'New Tickets' => 'j Jegyek',
        'Open Tickets / Need to be answered' => 'Nyitott Jegyek / Vlaszra vrnak',
        'Tickets which need to be answered!' => 'Vlaszra vr Jegyek!',
        'All new tickets!' => 'sszes j jegy!',
        'All tickets which are escalated!' => 'sszes eszkallt jegy!',
        'All tickets where the reminder date has reached!' => 'sszes jegy ahol az emlkeztet ideje lejrt!',
        'Responses' => 'Vlaszok',
        'Responses <-> Queue' => 'Vlaszok <-> Vrlista',
        'Auto Responses' => 'Automatikus vlaszok',
        'Auto Responses <-> Queue' => 'Automatikus vlaszok <-> Vrlista',
        'Attachments <-> Responses' => 'Levlmellkletek <-> Vlaszok',
        'History::Move' => 'Trtnet::Mozgat',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'Trtnet::jJegy',
        'History::FollowUp' => 'Trtnet::Vlasz',
        'History::SendAutoReject' => 'Trtnet::AutomatikusElutastsKlds',
        'History::SendAutoReply' => 'Trtnet::AutomatikusVlaszKlds',
        'History::SendAutoFollowUp' => 'Trtnet::AutomatikusReakciKlds',
        'History::Forward' => 'Trtnet::Tovbbt',
        'History::Bounce' => 'Trtnet::Visszakld',
        'History::SendAnswer' => 'Trtnet::VlaszKlds',
        'History::SendAgentNotification' => 'Trtnet::gyintzrtestsKlds',
        'History::SendCustomerNotification' => 'Trtnet::gyflrtestsKlds',
        'History::EmailAgent' => 'Trtnet::Emailgyintz',
        'History::EmailCustomer' => 'Trtnet::Emailgyfl',
        'History::PhoneCallAgent' => 'Trtnet::gyintzTelefonHvs',
        'History::PhoneCallCustomer' => 'Trtnet::gyflTelefonHvs',
        'History::AddNote' => 'Trtnet::MegjegyzsHozzads',
        'History::Lock' => 'Trtnet::Zrol',
        'History::Unlock' => 'Trtnet::Felolds',
        'History::TimeAccounting' => 'Trtnet::IdElszmols',
        'History::Remove' => 'Trtnet::Eltvolts',
        'History::CustomerUpdate' => 'Trtnet::gyflMdosts',
        'History::PriorityUpdate' => 'Trtnet::PrioritsMdosts',
        'History::OwnerUpdate' => 'Trtnet::TulajdonosVlts',
        'History::LoopProtection' => 'Trtnet::VisszacsatolsVdelem',
        'History::Misc' => 'Trtnet::Vegyes',
        'History::SetPendingTime' => 'Trtnet::VrakozsiIdBellts',
        'History::StateUpdate' => 'Trtnet::llapotMdosts',
        'History::TicketFreeTextUpdate' => 'Trtnet::JegySzabadSzvegMdosts',
        'History::WebRequestCustomer' => 'Trtnet::gyflWebKrs',
        'History::TicketLinkAdd' => 'Trtnet::JegyCsatolsHozzads',
        'History::TicketLinkDelete' => 'Trtnet::JegyCsatolsTrls',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'Vas',
        'Mon' => 'Ht',
        'Tue' => 'Ked',
        'Wed' => 'Sze',
        'Thu' => 'Cs',
        'Fri' => 'Pn',
        'Sat' => 'Szo',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Levlmellkletek kezelse',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Automatikus vlasz kezelnek',
        'Response' => 'Vlasz',
        'Auto Response From' => 'Automatikus vlasz feladnak',
        'Note' => 'Megjegyzs',
        'Useable options' => 'Hasznlhat opcik',
        'To get the first 20 character of the subject.' => 'Az els 20 karakter hasznlata a trgybl',
        'To get the first 5 lines of the email.' => 'Az els 5 sor hasznlata az e-mailbl.',
        'To get the realname of the sender (if given).' => 'A kld valdi nevnek hasznlata (ha van ilyen)',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'A bejegyzs attributmnak hasznlata (pl. <OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> s <OTRS_CUSTOMER_Body>).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Az aktulis gyfl adatai (pl.  <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'A jegy tulajdonosnak adatai (pl.  <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'A jegy felelsnek adatai (pl. <OTRS_RESPONSIBLE_UserFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'A mveletet vgz felhasznlnak adatai (pl. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'A jegy adatai (pl. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Konfigurcis rtkek (pl.  <OTRS_CONFIG_HttpType>).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'gyfl cgek kezelse',
        'Search for' => 'Keresend',
        'Add Customer Company' => 'gyfl cg hozzadsa',
        'Add a new Customer Company.' => 'j gyfl cg hozzadsa',
        'List' => 'Lista',
        'This values are required.' => 'Ezen rtkek megadsa ktelez.',
        'This values are read only.' => 'Ezek az rtkek csak olvashatk.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Az ppen elkszlt levl lezrsra kerlt. Kilps.',
        'This window must be called from compose window' => 'Ezt az ablakot a szerkeszt ablakbl kell hvni',
        'Customer User Management' => 'gyfl felhasznlk kezelse',
        'Add Customer User' => 'gyfl felhasznl hozzadsa',
        'Source' => 'Forrs',
        'Create' => 'Ltrehozs',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'gyfl felhasznl ltrehozsa szksges, hogy legyenek gyflhez tartoz elzmnyek s be lehessen lpni az gyfl oldalon.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'gyfl felhasznlk <-> Csoportok kezelse',
        'Change %s settings' => '%s belltsainak mdostsa',
        'Select the user:group permissions.' => 'A felhasznl:csoport jogok kivlasztsa.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Ha nincs semmi kivlasztva, akkor nincsenek jogosultsgok ebben a csoportban (a jegyek nem lesznek elrhetk a felhasznlnak).',
        'Permission' => 'Jogosultsg',
        'ro' => 'Csak olvass',
        'Read only access to the ticket in this group/queue.' => 'Csak olvassi jogosultsg a jegyekhez ebben a csoportban/vrlistban.',
        'rw' => 'rs/Olvass',
        'Full read and write access to the tickets in this group/queue.' => 'Teljes rs s olvassi jog a jegyekhez ebben a csoportban/vrlistban.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'gyfl felhasznlk <-> Szolgltatsok kezelse',
        'CustomerUser' => 'gyfl felhasznl',
        'Service' => 'Szolgltats',
        'Edit default services.' => 'Alap szolgltatsok szerkesztse.',
        'Search Result' => 'Keressi eredmny',
        'Allocate services to CustomerUser' => 'Szolgltatsok hozzrendelse gyflFelhasznlhoz!',
        'Active' => 'Aktv',
        'Allocate CustomerUser to service' => 'gyflFelhasznlk hozzrendelse szolgltatsokhoz',

        # Template: AdminEmail
        'Message sent to' => 'zenet elkldve',
        'A message should have a subject!' => 'Egy zenetnek kell legyen trgya!',
        'Recipients' => 'Cmzettek',
        'Body' => 'Trzs',
        'Send' => 'Klds',

        # Template: AdminGenericAgent
        'GenericAgent' => 'Automata gyintz',
        'Job-List' => 'Teendk listja',
        'Last run' => 'Utols vgrehajts',
        'Run Now!' => 'Vgrehajts most!',
        'x' => 'x',
        'Save Job as?' => 'Teendk mentse mskpp?',
        'Is Job Valid?' => 'Teend rvnyes?',
        'Is Job Valid' => 'Teend rvnyes',
        'Schedule' => 'Idzts',
        'Currently this generic agent job will not run automatically.' => 'Jelenleg ez az ltalnos gyintz munka nem fut le automatikusan.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Az automata vgrehajts belltshoz vlasszon legalbb egy rtket a perc, ra s nap kzl!',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Szveg keresse a bejegyzsekben (pl. "Mar*in" or "Baue*")',
        '(e. g. 10*5155 or 105658*)' => 'pl. 10*5144 vagy 105658*',
        '(e. g. 234321)' => 'pl. 234321',
        'Customer User Login' => 'gyfl felhasznl belps',
        '(e. g. U5150)' => 'pl. U5150',
        'SLA' => 'SLA',
        'Agent' => 'gyintz',
        'Ticket Lock' => 'Jegy zrols',
        'TicketFreeFields' => 'Jegy szabad mezi',
        'Create Times' => 'Ltrehozsi idk',
        'No create time settings.' => 'Nincsenek ltrehozsi id belltsok.',
        'Ticket created' => 'Jegy ltrehozva',
        'Ticket created between' => 'Jegy ltrehozva idpontok kztt:',
        'Close Times' => 'Lezrs ideje',
        'No close time settings.' => 'Nincs lezrs ideje bellts.',
        'Ticket closed' => 'Jegy lezrva',
        'Ticket closed between' => 'Jegy lezrva kztt:',
        'Pending Times' => 'Vrakozsi idk',
        'No pending time settings.' => 'Nincsenek vrakozsi id belltsok.',
        'Ticket pending time reached' => 'Vrakozsi id letelt',
        'Ticket pending time reached between' => 'Vrakozsi id letelt idpontok kztt:',
        'Escalation Times' => 'Eszkalcis id',
        'No escalation time settings.' => 'Nincs eszkalcis id belltva.',
        'Ticket escalation time reached' => 'Jegy eszkalcis ideje lejrt',
        'Ticket escalation time reached between' => 'Jegy eszkalcis ideje lejrt idpontok kztt:',
        'Escalation - First Response Time' => 'Eszkalci - Els vlasz ideje',
        'Ticket first response time reached' => 'Jegy els vlasz ideje lejrt',
        'Ticket first response time reached between' => 'Jegy els vlasz ideje lejrt idpontok kztt:',
        'Escalation - Update Time' => 'Eszkalci - Frissts ideje',
        'Ticket update time reached' => 'Jegy frissts ideje lejrt',
        'Ticket update time reached between' => 'Jegy frissts ideje lejrt idpontok kztt:',
        'Escalation - Solution Time' => 'Eszkalci - Megolds ideje',
        'Ticket solution time reached' => 'Jegy megolds ideje lejrt',
        'Ticket solution time reached between' => 'Jegy megolds ideje lejrt idpontok kztt:',
        'New Service' => 'j Szolgltats',
        'New SLA' => 'j SLA',
        'New Priority' => 'j priorits',
        'New Queue' => 'j vrlista',
        'New State' => 'j llapot',
        'New Agent' => 'j gyintz',
        'New Owner' => 'j tulajdonos',
        'New Customer' => 'j gyfl',
        'New Ticket Lock' => 'Jegy j zrolsi llapota',
        'New Type' => 'j Tipus',
        'New Title' => 'j cm',
        'New TicketFreeFields' => 'j jegy szabad mezk',
        'Add Note' => 'Megjegyzs hozzadsa',
        'Time units' => 'Id egysgek',
        'CMD' => 'PARANCS',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Ez a parancs lesz vgrehajtva. Az ARG[0] lesz a jegy szma. Az ARG[1] lesz a jegy azonostja.',
        'Delete tickets' => 'Jegyek trlse',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Figyelmeztets! Ezek a jegyek el lesznek tvoltva az adatbzisbl! Ezek a jegyek elvesznek!',
        'Send Notification' => 'rtests kldse',
        'Param 1' => '1. paramter',
        'Param 2' => '2. paramter',
        'Param 3' => '3. paramter',
        'Param 4' => '4. paramter',
        'Param 5' => '5. paramter',
        'Param 6' => '6. paramter',
        'Send agent/customer notifications on changes' => 'Kldjn vltozatsokrl rtestst az gyintznek/gyflnek',
        'Save' => 'Ments',
        '%s Tickets affected! Do you really want to use this job?' => '%s jegy rintett! Valban el akarja vgezni ezt a teendt a jegyeken?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => 'Figyelem: Ha az admin csoport nevt megvltoztatja a megfelel SysConfig belltsok eltt, gy ki lesz zrva az adminisztrcis felletrl. Ha ez megtrtnt, akkor nevezze vissza a csoportot admin nvre egy megfelel SQL parancs kiadsval.',
        'Group Management' => 'Csoportok kezelse',
        'Add Group' => 'Csoport hozzadsa',
        'Add a new Group.' => 'j csoport hozzadsa',
        'The admin group is to get in the admin area and the stats group to get stats area.' => 'Az admin csoport megkapja az admin terletet s a sttusz csoport megkapja a sttusz terletet.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Hozzon ltre j csoportot a klnbz gyintz csoportok (pl. beszerz osztly, tmogat osztly, elad osztly, ...) hozzfrsi jogainak kezelshez.',
        'It\'s useful for ASP solutions.' => 'Ez hasznos ASP megoldsokhoz.',

        # Template: AdminLog
        'System Log' => 'Rendszernapl',
        'Time' => 'Id',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Levelezs belltsai',
        'Host' => 'Kiszolgl',
        'Trusted' => 'Megbzhat',
        'Dispatching' => 'Sztvlogats',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Az sszes fikkal rendelkez bejv e-mail egy kivlasztott vrlisthoz lesz rendelve!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'Ha az n fikja megbzhat, a mr ltez X-OTRS fejlcet hasznljuk berkezskor (prioritshoz, ...)! Egyb esetben a levelezsi szrk lesznek alkalmazva.',

        # Template: AdminNavigationBar
        'Users' => 'Felhasznlk',
        'Groups' => 'Csoportok',
        'Misc' => 'Egyb',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'rtestskezels',
        'Add Notification' => 'rtests hozzadsa',
        'Add a new Notification.' => 'j rtests hozzadsa.',
        'Name is required!' => 'A nevet meg kell adni!',
        'Event is required!' => 'Esemny megadsa szksges!',
        'A message should have a body!' => 'Egy zenetnek kell legyen trzse!',
        'Recipient' => 'Cmzett',
        'Group based' => 'Csoport alap',
        'Agent based' => 'gyk alap',
        'Email based' => 'E-mail alap',
        'Article Type' => 'Cikk tipusa',
        'Only for ArticleCreate Event.' => 'Csak CikkLtrehoz esemnyhez.',
        'Subject match' => 'Trgy egyezs',
        'Body match' => 'Levltrzs egyezs',
        'Notifications are sent to an agent or a customer.' => 'Az rtestsek gyintznek vagy gyflnek kerlnek elkldsre.',
        'To get the first 20 character of the subject (of the latest agent article).' => '(Legutols gyintz cikk) trgynak els 20 karaktere.',
        'To get the first 5 lines of the body (of the latest agent article).' => '(Legutols gyintz cikk) trzsnek els 5 sora.',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Cikk jellemzi pl. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).',
        'To get the first 20 character of the subject (of the latest customer article).' => '(Legutols gyfl cikk) trgynak els 20 karaktere.',
        'To get the first 5 lines of the body (of the latest customer article).' => '(Legutols gyfl cikk) trzsnek els 5 sora.',

        # Template: AdminNotificationForm
        'Notification' => 'rtests',

        # Template: AdminPackageManager
        'Package Manager' => 'Csomagkezel',
        'Uninstall' => 'Eltvolts',
        'Version' => 'Verzi',
        'Do you really want to uninstall this package?' => 'Valban el akarja tvoltani ezt a csomagot?',
        'Reinstall' => 'jratelepts',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Valban jra kvnja telepteni ezt a csomagot (minden megvltoztatott bellts elvsz)?',
        'Continue' => 'Folytats',
        'Install' => 'Telepts',
        'Package' => 'Csomag',
        'Online Repository' => 'On-line csomagtrol',
        'Vendor' => 'Terjeszt',
        'Module documentation' => 'Modul dokumentci',
        'Upgrade' => 'Frissts',
        'Local Repository' => 'Helyi csomagtrol',
        'Status' => 'llapot',
        'Overview' => 'ttekints',
        'Download' => 'Letlts',
        'Rebuild' => 'jrapts',
        'ChangeLog' => 'Vltoztatsok',
        'Date' => 'Dtum',
        'Filelist' => 'Fjl lista',
        'Download file from package!' => 'Fjl letltse a csomagbl!',
        'Required' => 'Kvetlemnyek',
        'PrimaryKey' => 'ElsdelegesKulcs',
        'AutoIncrement' => 'AutoNvekv',
        'SQL' => 'SQL',
        'Diff' => 'Klnbsg',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Teljestmny napl',
        'This feature is enabled!' => 'Ez a kpessg aktv!',
        'Just use this feature if you want to log each request.' => 'Hasznlja ezt a kpessget amennyiben naplzni szeretne minden egyes krst.',
        'Activating this feature might affect your system performance!' => 'Ha bekapcsolja ezt a funkcit a rendszer teljestmnyt jelentsen befolysolhatja!',
        'Disable it here!' => 'Inaktivlja itt!',
        'This feature is disabled!' => 'Ez a kpessg inaktv!',
        'Enable it here!' => 'Aktivlja itt!',
        'Logfile too large!' => 'A naplfjl tl nagy!',
        'Logfile too large, you need to reset it!' => 'A naplfjl tl nagy, kitrlse szksges!',
        'Range' => 'Tartomny',
        'Interface' => 'Fellet',
        'Requests' => 'Krsek',
        'Min Response' => 'Min. Vlasz',
        'Max Response' => 'Max. Vlasz',
        'Average Response' => 'tlagos Vlasz',
        'Period' => 'Idszak',
        'Min' => 'Min.',
        'Max' => 'Max.',
        'Average' => 'tlag',

        # Template: AdminPGPForm
        'PGP Management' => 'PGP kulcs kezelse',
        'Result' => 'Eredmnyek',
        'Identifier' => 'Azonost',
        'Bit' => 'Bitek szma',
        'Key' => 'Kulcs',
        'Fingerprint' => 'Ujjlenyomat',
        'Expires' => 'Lejrati id',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'gy kzvetlenl szerkesztheti a kulcstartt amit a rendszer belltsainl belltott.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'Levelezsi szrk kezelse',
        'Filtername' => 'Szr neve',
        'Stop after match' => 'Megll egyezs utn',
        'Match' => 'Egyezs',
        'Value' => 'rtk',
        'Set' => 'Bellts',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'A berkez e-mailek az X-Fejlcek alapjn legyen hozzrendelve! Szablyos kifejezsek alkalmazhatk.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Amennyiben n csak az e-mail cm egyezst kvnja vizsglni, akkor hasznlja a EMAILADDRESS:info@example.com formult a Felad (From), Cmzett (To) vagy Msolat (Cc) mezkben.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Ha szablyos kifejzseket hasznl, hasznlhatja a ()-ben lev egyez rtket mint [***] a \'Bellts\'-nl.',

        # Template: AdminPriority
        'Priority Management' => 'Priorits kezels',
        'Add Priority' => 'Priorits hozzadsa',
        'Add a new Priority.' => 'j priorits hozzadsa',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'Vrlista <-> Automatikus vlaszok kezelse',
        'settings' => 'belltsok',

        # Template: AdminQueueForm
        'Queue Management' => 'Vrlistk kezelse',
        'Sub-Queue of' => 'Vrlista al tartozik',
        'Unlock timeout' => 'Feloldsi idtllps',
        '0 = no unlock' => '0 = nincs felolds',
        'Only business hours are counted.' => 'Csak a munkark kerlek szmtsba.',
        '0 = no escalation' => '0 = nincs kiemels',
        'Notify by' => 'rtests',
        'Follow up Option' => 'Vlasz kezelse',
        'Ticket lock after a follow up' => 'Jegy zrolsa vlasz rkezse utn.',
        'Systemaddress' => 'Rendszercm',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ha az gyintz zrolja a jegyet s nem kld vlaszt ezen idn bell, a jegy zrolsa megsznik. gy a jegy lthat lesz minden gyintznek.',
        'Escalation time' => 'Eszkalci ideje',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ha a jegy nem kerl megvlaszolsra a megadott idn bell, csak ez a jegy lesz megjelentve.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ha a jegy le van zrva s az gyfl vlaszol a jegyre, akkor az zrolsra kerl a rgi tulajdonos rszre.',
        'Will be the sender address of this queue for email answers.' => 'Ennl a vrlistnl ez lesz a felad e-mail vlaszokhoz.',
        'The salutation for email answers.' => 'A megszlts az e-mail vlaszokhoz.',
        'The signature for email answers.' => 'Az alrs a vlasz e-mailekhez.',
        'Customer Move Notify' => 'gyfl rtestse mozgatskor',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy thelyezsre kerlt.',
        'Customer State Notify' => 'gyfl rtestse llapotvltozskor',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy llapota megvltozott.',
        'Customer Owner Notify' => 'gyfl rtestse tulajdonosvltskor',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'Az OTRS rtest levelet kld az gyflnek ha a jegy tulajdonosa megvltozott.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Vlaszok <-> Vrlistk kezelse',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Vlasz',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Vlaszok <-> Levlmellkletek kezelse',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Reakci kezels',
        'A response is default text to write faster answer (with default text) to customers.' => 'Egy reakci az alaprtelmezett szveg gyors vlaszokhoz (az alaprtelmezett szveggel) az gyfeleknek.',
        'Don\'t forget to add a new response a queue!' => 'Ne felejtsen el j reakcit hozzadni a vrlisthoz!',
        'The current ticket state is' => 'A jegy aktulis llapota',
        'Your email address is new' => 'Az n e-mail cme j',

        # Template: AdminRoleForm
        'Role Management' => 'Szerepek kezelse',
        'Add Role' => 'Szerep hozzadsa',
        'Add a new Role.' => 'j szerep hozzadsa',
        'Create a role and put groups in it. Then add the role to the users.' => 'Hozzon ltre egy szerepet s tegyen bele csoportokat. Azutn adja a szerepet a felhasznlkhoz.',
        'It\'s useful for a lot of users and groups.' => 'Ez hasznos egy csom felhasznlnak s csoportnak',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Szerepek <-> Csoportok kezelse',
        'move_into' => 'mozgat',
        'Permissions to move tickets into this group/queue.' => 'Jogosultsgok jegyek thelyezshez ebbe a csoportba/vrlistba.',
        'create' => 'kszt',
        'Permissions to create tickets in this group/queue.' => 'Jogosultsgok j jegyek ltrehozshoz ebben a csoportban/vrlistban.',
        'owner' => 'tulajdonos',
        'Permissions to change the ticket owner in this group/queue.' => 'Jogosultsgok a jegy tulajdonosnak megvltoztatshoz ebben a csoportban/vrlistban.',
        'priority' => 'priorits',
        'Permissions to change the ticket priority in this group/queue.' => 'Jogosultgok a jegy prioritsnak megvltoztatshoz ebben a csoportban/vrlistban.',

        # Template: AdminRoleGroupForm
        'Role' => 'Szerep',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Szerepek <-> Felhasznlk kezelse',
        'Select the role:user relations.' => 'Vlassza ki a szerep:felhasznl kapcsolatokat.',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Megszltsok kezelse',
        'Add Salutation' => 'Megszlts hozzadsa',
        'Add a new Salutation.' => 'j megszlts hozzadsa',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'Biztonsgos zemmdot engedlyezni kell!',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Biztonsgos zemmd a teleptst kveten fog teljesen mkdni.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Biztonsgos zemmdot le kell tltani ahhoz, hogy a webes teleptvel jra lehessen dolgozni.',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Ha a biztonsgos zemmd nincs aktivlva, akkor a SysConfig-ben aktivlja, mivel az alkalmazs mr fut.',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'SQL parancsok',
        'Go' => 'Indts',
        'Select Box Result' => 'SQL parancs eredmnye',

        # Template: AdminService
        'Service Management' => 'Szolgltatsok kezelse',
        'Add Service' => 'Szolgltats hozzadsa',
        'Add a new Service.' => 'j szolgltats hozzadsa',
        'Sub-Service of' => 'Szolgtatsa al tartozik',

        # Template: AdminSession
        'Session Management' => 'Folyamatkezels',
        'Sessions' => 'Folyamat',
        'Uniq' => 'Egyedi',
        'Kill all sessions' => 'sszes folyamat trlse',
        'Session' => 'Folyamat',
        'Content' => 'Tartalom',
        'kill session' => 'folyamat trlse',

        # Template: AdminSignatureForm
        'Signature Management' => 'Alrsok kezelse',
        'Add Signature' => 'Alrs hozzadsa',
        'Add a new Signature.' => 'j alrs hozzadsa',

        # Template: AdminSLA
        'SLA Management' => 'SLA kezelse',
        'Add SLA' => 'SLA hozzadsa',
        'Add a new SLA.' => 'j SLA hozzadsa',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'S/MIME kezels',
        'Add Certificate' => 'Tanustvny Hozzadsa',
        'Add Private Key' => 'Titkos Kulcs Hozadsa',
        'Secret' => 'Titok',
        'Hash' => 'Kivonat',
        'In this way you can directly edit the certification and private keys in file system.' => 'ly mdon kzvetlenl szerkesztheti a fjlrendszeren trolt tanustvnyokat s titkos kulcsokat.',

        # Template: AdminStateForm
        'State Management' => 'llapotok kezelse',
        'Add State' => 'llapot hozzadsa',
        'Add a new State.' => 'j llapot hozzadsa',
        'State Type' => 'llapot tpusa',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Figyeljen oda, hogy az Kernel/Config.pm fjlban is frisstse az alaprtelmezett llapotokat!',
        'See also' => 'Lsd mg',

        # Template: AdminSysConfig
        'SysConfig' => 'Rendszerbelltsok',
        'Group selection' => 'Csoport kivlasztsa',
        'Show' => 'Megjelents',
        'Download Settings' => 'Belltsok letltse',
        'Download all system config changes.' => 'Minden rendszerbellts modosts letltse.',
        'Load Settings' => 'Belltsok betltse',
        'Subgroup' => 'Alcsoport',
        'Elements' => 'Elemek szma',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Belltsi lehetsgek',
        'Default' => 'Alaprtelmezett',
        'New' => 'j',
        'New Group' => 'j csoport',
        'Group Ro' => 'Csoport Ro',
        'New Group Ro' => 'j Csoport Ro',
        'NavBarName' => 'NavMenNv',
        'NavBar' => 'NavMen',
        'Image' => 'Kp',
        'Prio' => 'Prio',
        'Block' => 'Blokk',
        'AccessKey' => 'HozzfrsiKulcs',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'Rendszer e-mail cmek kezelse',
        'Add System Address' => 'Rendszer cm hozzadsa',
        'Add a new System Address.' => 'j rendszer cm hozzadsa',
        'Realname' => 'Valdi nv',
        'All email addresses get excluded on replaying on composing an email.' => 'sszes E-mail cm ki lesz hagyva ismtelt levlrs esetn.',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Az sszes bejv e-mail ezzel az cmzettel a kivlasztott vrlisthoz lesz rendelve!',

        # Template: AdminTypeForm
        'Type Management' => 'Tpusok kezelse',
        'Add Type' => 'Tpus hozzadsa',
        'Add a new Type.' => 'j tpus hozzadsa',

        # Template: AdminUserForm
        'User Management' => 'Felhasznlk kezelse',
        'Add User' => 'Felhasznl hozzadsa',
        'Add a new Agent.' => 'j felhasznl hozzadsa',
        'Login as' => 'Belp mint',
        'Firstname' => 'Keresztnv',
        'Lastname' => 'Vezetknv',
        'Start' => 'Eleje',
        'End' => 'Vge',
        'User will be needed to handle tickets.' => 'Felhasznl szksges a jegyek kezelshez.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Ne felejtse el az j felhasznlt hozzadni csoportokhoz s/vagy szerepekhez!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Felhasznlk <-> Csoportok kezelse',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Cmjegyzk',
        'Return to the compose screen' => 'Visszatrs a szerkesztkpernyre',
        'Discard all changes and return to the compose screen' => 'Minden vltoztats megsemmistse s visszatrs a szerkesztkpernyre',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Vezrlpult',

        # Template: AgentDashboardCalendarOverview
        'in' => 'ebben',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s elrhet!',
        'Please update now.' => 'Krem most frisstsen.',
        'Release Note' => 'Kiadsi megjegyzs',
        'Level' => 'Szint',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Bekldve %s ezeltt.',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Info',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Kapcsold Objektum: %s',
        'Object' => 'Objektum',
        'Link Object' => 'Objektumok sszekapcsolsa',
        'with' => 'Ezzel',
        'Select' => 'Kivlaszts',
        'Unlink Object: %s' => 'Levlaszott Objektum: %s',

        # Template: AgentLookup
        'Lookup' => 'Keres',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Helyesrsellenrz',
        'spelling error(s)' => 'helyesrsi hiba(k)',
        'or' => 'vagy',
        'Apply these changes' => 'Mdostsok rvnyestse',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Valban trlni szertn ezt az objektumot?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Vlassza ki a megktseket a statsztika testre szabshoz',
        'Fixed' => 'Rgztett',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Krem vlasszon egy rtket vagy kapcsolja ki a \'Rgztett\' kapcsolt.',
        'Absolut Period' => 'Abszolt idszak',
        'Between' => 'Idszak:',
        'Relative Period' => 'Relatv idszak',
        'The last' => 'A legutbbi',
        'Finish' => 'Befejezs',
        'Here you can make restrictions to your stat.' => 'Itt megktseket adhat a statsztikhoz.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Ha eltvoltja a "Rgztett" jellngyzetet, akkor a statisztikt elllt gyintz megvltoztathatja az rtkeit a megfelel tulajdonsgnak.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => 'Az ltalnos belltsok megadsa',
        'Permissions' => 'Jogosultsgok',
        'Format' => 'Formtum',
        'Graphsize' => 'Grafikon mrete',
        'Sum rows' => 'Sorok sszegzse',
        'Sum columns' => 'Oszlopok sszegzse',
        'Cache' => 'Gyorsttr',
        'Required Field' => 'Ktelez mezk',
        'Selection needed' => 'Vlasztk szksges',
        'Explanation' => 'Magyarzat',
        'In this form you can select the basic specifications.' => 'Ezen a felleten elvgezheti az alapvet belltsokat.',
        'Attribute' => 'Tulajdonsg',
        'Title of the stat.' => 'A statisztika cme.',
        'Here you can insert a description of the stat.' => 'Itt tudja megadni a statisztika lerst.',
        'Dynamic-Object' => 'Dinamikus objektum',
        'Here you can select the dynamic object you want to use.' => 'Itt tudja kivlasztani azt a dinamikus objektumot, amelyet hasznni kvn.',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '(Megjegyzs: A teleptstl fgg mennyi dinamikus objektumot hasznlhat.)',
        'Static-File' => 'Statikus fjl',
        'For very complex stats it is possible to include a hardcoded file.' => 'Nagyon sszetett statisztikknl lehetsg elre elksztett fjlok hasznlata.',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => 'Ha rendelkezsre ll egy jabb elre elksztett fjl akkor az itt megjelenik s vlaszthat kzlk egyet.',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => 'Jogosultsg belltsok. Kivlaszthat egy vagy tbb csoportot, hogy a belltott statisztikt megtekinthetv tegye a klnbz gyintzk szmra.',
        'Multiple selection of the output format.' => 'Tbb kimeneti formtum kivlasztsa.',
        'If you use a graph as output format you have to select at least one graph size.' => 'Amennyiben grafikont is kivlasztott, mint kimeneti formtum, gy ki kell vlasztania legalbb egy grafikon mretet.',
        'If you need the sum of every row select yes' => 'Amennyiben a sorok sszegzsre van szksge, akkor vlassza az igent.',
        'If you need the sum of every column select yes.' => 'Amennyiben az oszlopok sszegzsre van szksge, akkor vlassza az igent.',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'A statisztikk tbbsge hasznlhat gyorsttrat. Ez gyorstja az elksztst a statisztiknak.',
        '(Note: Useful for big databases and low performance server)' => '(Megyjegyzs: Ez hasznos nagy mret adatbzisoknl s ki teljestmny kiszolgl hasznlata esetn.)',
        'With an invalid stat it isn\'t feasible to generate a stat.' => 'rvnytelen statisztika esetn nem lehetsges a statiszika ellltsa.',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => 'Ez akkor hasznos, ha nem akarja, hogy valaki elrje a statisztika eredmnyt vagy a statsztika nincsen mg teljesen belltva.',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => 'Vlassza ki a tulajdonsgokat a grafikonon megjelen rtkekhez',
        'Scale' => 'Skla',
        'minimal' => 'minimlis',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Krem ne felejtse, hogy adatsorok sklzsnak nagyobbnak kell lennie az X tengely sklzsnl (pl. X-Tengely => Hnap, rtkSorozat => v )',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt kivlaszthatja a grafikonon megjelen rtkeket. Egy vagy kt tulajdonsgot jellhet ki. Utn kivlaszthatja a tulajdonsg rtkeit. Minden rtk kln kerl brzolsra a grafikonon. Ha nem vlaszt ki egyetlen rtket sem a tulajdonsghoz, akkor az sszes rtk hasznlva lesz a statisztika ltrehozsakor. Szintn hozzadsra kerlnek a legutbbi bellts ta ltrejtt j rtkek is.',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => 'Vlassza ki a tulajdonsgot, amely az X tengelyen fog megjelenni.',
        'maximal period' => 'maximum peridus',
        'minimal scale' => 'minimlis skla',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt definilhatja az x-tengelyt. A vlasztgomb segtsgvel tud vlasztani. Ha nem vlaszt semmit, akkor minden jellemz felhaszhlsra kerl a statisztika elksztsnl. Ugyangy, ahogy egy j jellemz mr hozzadsra kerlt a legutols konfigurci ta.',

        # Template: AgentStatsImport
        'Import' => 'Importls',
        'File is not a Stats config' => 'A fjl nem egy statisztika bellts fjl',
        'No File selected' => 'Nincsen fjl kivlasztva',

        # Template: AgentStatsOverview
        'Results' => 'Eredmnyek',
        'Total hits' => 'sszes tallat',
        'Page' => 'Oldal',

        # Template: AgentStatsPrint
        'Print' => 'Nyomtats',
        'No Element selected.' => 'Nincsen rtk kivlasztva.',

        # Template: AgentStatsView
        'Export Config' => 'Belltsok exportlsa',
        'Information about the Stat' => 'Informci a statisztikrl',
        'Exchange Axis' => 'Tengelyek flcserlse',
        'Configurable params of static stat' => 'lland statisztika konfigurlhat paramterei',
        'No element selected.' => 'Nincsenek ertkek kivlasztva.',
        'maximal period from' => 'maximlis peridus ezta',
        'to' => 'eddig',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => 'A bemeneti s kivlaszthat mezkkel kivlaszthatja a kvnt statisztikt. Az n ltal szerkeszthet statisztika rtkek a statisztikt bellt adminisztrtortl fggnek.',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Egy zenethez kellene legyen cmzett!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'Kell egy e-mail cm (pl. customer@example.com) cmzettnek!',
        'Bounce ticket' => 'Jegy visszakldse',
        'Ticket locked!' => 'Jegy zrolva!',
        'Ticket unlock!' => 'Jegy feloldsa!',
        'Bounce to' => 'Visszaklds ide:',
        'Next ticket state' => 'A jegy kvetkez llapota',
        'Inform sender' => 'Kld tjkoztatsa',
        'Send mail!' => 'E-mail kldse!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'El kell szmolnia az idvel!',
        'Ticket Bulk Action' => 'Csoportos jegy-mvelet',
        'Spell Check' => 'Helyesrsellenrzs',
        'Note type' => 'Jegyzet tpusa',
        'Next state' => 'Kvetkez llapot',
        'Pending date' => 'Vrakozsi dtum',
        'Merge to' => 'Egyesti',
        'Merge to oldest' => 'Legrgebbihez egyesti',
        'Link together' => 'sszekapcsol',
        'Link to Parent' => 'Szlhz kapcsol',
        'Unlock Tickets' => 'Jegyek feloldsa',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'Jegy tipus szksges!',
        'A required field is:' => 'Szksges mez:',
        'Close ticket' => 'Jegy lezrsa',
        'Previous Owner' => 'Korbbi tulajdonos',
        'Inform Agent' => 'gyintz rtstse',
        'Optional' => 'Nem ktelez',
        'Inform involved Agents' => 'rintett gyintzk rtestse',
        'Attach' => 'Csatols',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Az zenetnek helyesrsellenrzsen kell tmennie!',
        'Compose answer for ticket' => 'Vlaszads a jegyre',
        'Pending Date' => 'Vrakozs dtuma',
        'for pending* states' => 'vrakoz* sttuszhoz',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'A jegyhez tartoz gyfl megvltoztatsa',
        'Set customer user and customer id of a ticket' => 'A jegyhez tartoz gyfl felhasznlnak s gyfl azonostnak belltsa',
        'Customer User' => 'gyfl felhasznl',
        'Search Customer' => 'gyfl keresse',
        'Customer Data' => 'gyfl adatok',
        'Customer history' => 'gyfl trtnet',
        'All customer tickets.' => 'sszes gyfl jegy.',

        # Template: AgentTicketEmail
        'Compose Email' => 'j e-mail rsa',
        'new ticket' => 'j jegy',
        'Refresh' => 'Frissts',
        'Clear To' => 'Mez trlse',
        'All Agents' => 'Minden gyintz',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Bejegyzs tpusa',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'Szabad szveg vltoztatsa a jegyben',

        # Template: AgentTicketHistory
        'History of' => 'Elzmnyek:',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Adja meg egy jegy szmt!',
        'Ticket Merge' => 'Jegy egyestse',

        # Template: AgentTicketMove
        'Move Ticket' => 'Jegy thelyezse',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Megjegyzs hozzadsa a jegyhez',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Els vlaszid',
        'Service Time' => 'Szolgltats ideje',
        'Update Time' => 'Frissts ideje',
        'Solution Time' => 'Megolds ideje',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Legalbb egy jegyet ki kell vlasztani!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Szr',
        'Change search options' => 'Keressi belltsok mdostsa',
        'Tickets' => 'Jegyek',
        'of' => 'kitl',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Vlasz rsa',
        'Contact customer' => 'Kapcsolatbalps az gyfllel',
        'Change queue' => 'Vrlista megvltoztatsa',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'rendezs felfel',
        'up' => 'fel',
        'sort downward' => 'rendezs lefel',
        'down' => 'le',
        'Escalation in' => 'Eszkalci ebben',
        'Locked' => 'Zrols',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'Jegy tulajdonosnak mdostsa',

        # Template: AgentTicketPending
        'Set Pending' => 'Vrakozs bellts',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefonhvs',
        'Clear From' => 'Mez trlse',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Egyszer',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Jegy informci',
        'Accounted time' => 'Elszmolt id',
        'Linked-Object' => 'Kapcsold objektum',
        'by' => 'ltala:',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'Jegy prioritsnak mdostsa',

        # Template: AgentTicketQueue
        'Tickets shown' => 'Mutatott jegyek',
        'Tickets available' => 'Elrhet jegyek',
        'All tickets' => 'sszes jegy',
        'Queues' => 'Vrlistk',
        'Ticket escalation!' => 'Jegy kiemelse!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'Jegy felelsnek megvltoztatsa',

        # Template: AgentTicketSearch
        'Ticket Search' => 'Jegy keress',
        'Profile' => 'Profil',
        'Search-Template' => 'Keres sablon',
        'TicketFreeText' => 'Jegy szabadszveg',
        'Created in Queue' => 'Ltrehozskori vrlista',
        'Article Create Times' => 'Cikk ltrehozsnak ideje',
        'Article created' => 'Cikk ltrehozva',
        'Article created between' => 'Cikk ltrehozva ekztt',
        'Change Times' => 'Vltozs ideje',
        'No change time settings.' => 'Nincs vltozs az idbelltsban.',
        'Ticket changed' => 'Jegy vltozott',
        'Ticket changed between' => 'Jegy vltozott ekztt',
        'Result Form' => 'Eredmny rlap',
        'Save Search-Profile as Template?' => 'Elmenti a keres profilt sablonknt?',
        'Yes, save it with name' => 'Igen, elmentve ezen a nven',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Teljes szveg',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Kibvtett Nzet',
        'Collapse View' => 'Szktett Nzet',
        'Split' => 'Feloszts',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Cikk szr belltsai',
        'Save filter settings as default' => 'Szr belltsok alaprtelmezettknti mentse',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'Visszakvets',

        # Template: CustomerFooter
        'Powered by' => 'Ksztette',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Belps',
        'Lost your password?' => 'Elfelejtette a jelszavt?',
        'Request new password' => 'j jelsz krse',
        'Create Account' => 'Azonost ltrehozsa',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'dvzljk %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Idk',
        'No time settings.' => 'Nincs idbellts.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Kattintson ide j hiba bejelentshez!',

        # Template: Footer
        'Top of Page' => 'Lap teteje',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Otthon',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Web-telept',
        'Welcome to %s' => 'dvzli az %s',
        'Accept license' => 'Lincensz elfogadsa',
        'Don\'t accept license' => 'Licensz elutastsa',
        'Admin-User' => 'Adminisztrtor felhasznl',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => 'Ha be van lltva adatbzis root jelsz, akkor azt itt kell megadni. Ha nem hagyja resen a mezt. Biztonsgi megfontolsokbl javasoljuk hogy hasznljon root jelszt. Tovbbi informcit tall az adatbzis dokumentciban.',
        'Admin-Password' => 'Adminisztrtor jelsz',
        'Database-User' => 'Adatbzis felhasznl',
        'default \'hot\'' => 'alaprtelmezett',
        'DB connect host' => 'Adatbzis kiszolgl',
        'Database' => 'Adatbzis',
        'Default Charset' => 'Alaprtelmezett karakterkszlet',
        'utf8' => 'utf8',
        'false' => 'hamis',
        'SystemID' => 'Rendszer azonost',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Azonosts a rendszerben. Minden jegyhez s minden http eljrs ezzel a sorszmmal indul)',
        'System FQDN' => 'Rendszer FQDN',
        '(Full qualified domain name of your system)' => '(Teljes ellenrztt domain nv a rendszerben)',
        'AdminEmail' => 'AdminEmail',
        '(Email of the system admin)' => '(A rendszergazda e-mailje)',
        'Organization' => 'Szervezet',
        'Log' => 'Napl',
        'LogModule' => 'Log modul',
        '(Used log backend)' => '(Hasznlt httr log)',
        'Logfile' => 'Log file',
        '(Logfile just needed for File-LogModule!)' => '(Logfile szksges a File-LogModul szmra!)',
        'Webfrontend' => 'Webes felhasznli fellet',
        'Use utf-8 it your database supports it!' => 'Hasznld utf-8-at az adatbzis tmogatsoknl!',
        'Default Language' => 'Alaprtelmezett nyelv',
        '(Used default language)' => '(A felhasznl alaprtelmezett nyelve)',
        'CheckMXRecord' => 'MX Rekord ellenrzs',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Ellenrizd le az MX rekordot a hasznlt email cmben a vlasz rsakor!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Ahhoz, hogy az OTRS-t hasznlni tudja, a kvetkez parancsot kell begpelnie parancssorban (terminlban/hjjban) root-knt.',
        'Restart your webserver' => 'Indtsa jra a web-kiszolglt',
        'After doing so your OTRS is up and running.' => 'Ha ez ksz, az OTRS ksz s fut.',
        'Start page' => 'Start oldal',
        'Your OTRS Team' => 'Az n OTRS csapata',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Nincs jogosultsg',

        # Template: Notify
        'Important' => 'Fontos',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'Nyomtatta',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS tesztoldal',
        'Counter' => 'Szmll',

        # Template: Warning

        # Template: YUI

        # Misc
        'auto follow up' => 'automatikus vlasz',
        'Create Database' => 'Adatbzis ltrehozsa',
        'verified' => 'ellenrztt',
        'File-Name' => 'File-nv',
        'Ticket Number Generator' => 'Jegy sorszm genertor',
        '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Jegy azonosts. pl. \'Jegy#\', \'Hv#\' vagy \'Jegyem#\')',
        'Create new Phone Ticket' => 'j telefon jegy ltrehozsa',
        'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => 'ly mdon kzvetlenl szerkesztheti a Kernel/Config.pm-ben belltott kulcskarikt.',
        'U' => 'A',
        'Site' => 'Gp',
        'Reset of unlock time.' => 'Feloldsi id nullzsa.',
        'Customer history search (e. g. "ID342425").' => 'Keress az gyfl trtnetben (pl. "ID342425").',
        'Can not delete link with %s!' => 'Nem tudom trlni %s kapcsoldst!',
        'for agent firstname' => 'gyintz keresztnvhez',
        'Close!' => 'Lezr!',
        'Reporter' => 'Bejelent',
        'Process-Path' => 'Process-tvonal',
        'No means, send agent and customer notifications on changes.' => 'Nem esetn mind az gyintznek, mind az gyflnek kld rtestseket a vltozsokrl.',
        'to get the realname of the sender (if given)' => 'hogy megkapja a felad valdi nevt (ha lehetsges)',
        'FAQ Search Result' => 'GYIK tallati eredmnyek',
        'Notification (Customer)' => 'rtests (gyfl)',
        'Select Source (for add)' => 'Vlassza ki a forrst (hozzadshoz)',
        'Node-Name' => 'Node-nv',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Jegy adatok opcii (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Agent updated!' => 'gyintz mdostva!',
        'Child-Object' => 'Gyerek objektum',
        'Workflow Groups' => 'Workflow csoportok',
        'Current Impact Rating' => 'Jelenlegi befolys besorolsa',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Bellts opcik (pl. <OTRS_CONFIG_HttpType>)',
        'FAQ System History' => 'GYIK rendszer trtnet',
        'customer realname' => 'gyfl valdi nv',
        'Pending messages' => 'Vrakoz zenetek',
        'auto reply/new ticket' => 'automatikus vlasz/j jegy',
        'Modules' => 'Modul',
        'for agent login' => 'gyintz belpshez',
        'Keyword' => 'Kulcssz',
        'Reference' => 'Referencia',
        'Close type' => 'Tpus lezrsa',
        'DB Admin User' => 'DB Admin felhasznl',
        'for agent user id' => 'gynk felhasznl azonostjhoz',
        'Classification' => 'Besorols',
        'Change user <-> group settings' => 'A felhasznl <-> csoport belltsok megvltoztatsa',
        'Escalation' => 'Eszkalci',
        '"}' => '"}',
        'Order' => 'Sorrend',
        'next step' => 'kvetkez lps',
        'Follow up' => 'Vlasz',
        'Customer history search' => 'Keress az gyfl trtnetben',
        'not verified' => 'nem ellenrztt',
        'Stat#' => 'Stat#',
        'Create new database' => 'j adatbzis ltrehozsa',
        'auto reject' => 'automatikus visszautasts',
        'Year' => 'v',
        'X-axis' => 'X tengely',
        'Keywords' => 'Kulcssz',
        'Ticket Escalation View' => 'Jegy Eszkalci Nzet',
        'Today' => 'Ma',
        'No * possible!' => 'A "*" nem lehetsges!',
        'Load' => 'Betlts',
        'Change Time' => 'Id megvltoztatsa',
        'PostMaster Filter' => 'Levelezsi szrk',
        'PostMaster POP3 Account' => 'Levelezsi fikok (POP3)',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opcik a jelenlegi felhasznl szmra, aki krte ezt a mveletet (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
        'Message for new Owner' => 'zenet az j tulajdonosnak',
        'to get the first 5 lines of the email' => 'hogy megkapja az els 5 sort az e-mailbl',
        'Sort by' => 'Rendezs gy',
        'Default Sign Key' => 'Alaprtelmezett alr kulcs',
        'OTRS DB Password' => 'OTRS DB jelsz',
        'Last update' => 'Utols frissts',
        'Tomorrow' => 'Holnap',
        'not rated' => 'nincs besorolva',
        'to get the first 20 character of the subject' => 'hogy megkapja az els 20 karaktert a trgybl',
        'Select the customeruser:service relations.' => 'Vlassza ki az gyfl felhasznl:szolgltats relcit.',
        'DB Admin Password' => 'DB Admin jelsz',
        'Drop Database' => 'Adatbzis trlse',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => 'Itt llthatja be az X tengelyt. Vlasszon egyet a rdi gombok kzl. Utna vlassza ki kt vagy tbb rtkt a tulajdonsgnak. Ha nem vlaszt ki egyetlen rtket sem a tulajdonsghoz, akkor az sszes rtk hasznlva lesz a statisztika ltrehozsakor. Szintn hozzadsra kerlnek a legutbbi bellts ta ltrejtt j rtkek is.',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'Opcik az aktulis gyfl felhasznli adatokhoz (pl. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Vrakozs tpusa',
        'Comment (internal)' => 'Megjegyzs (bels)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Jegy tulajdonosnak adatai (pl. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)',
        'User-Number' => 'Felhasznl-szm',
        'Reset of escalation time.' => 'Eszkalcis id nullzsa.',
        'System Address updated!' => 'Rendszer cm mdostva!',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'Jegy adatok opcii (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Nyitott jegyek sorszmnak formtuma)',
        'Reminder' => 'Emlkeztet',
        'Month' => 'Hnap',
        'SessionID invalid! Need user data!' => 'Hibs folyamat azonost! Felhasznli adatok megadsa szksges!',
        'Node-Address' => 'Node-cm',
        'All Agent variables.' => 'gyintz sszes vltozja',
        ' (work units)' => ' (munkaegysg)',
        'Next Week' => 'Kvetkez Ht',
        'You use the DELETE option! Take care, all deleted Tickets are lost!!!' => 'A TRLS opcit hasznlja! Legyen vatos, az sszes trlt jegy elveszik!!!',
        'All Customer variables like defined in config option CustomerUser.' => 'Az sszes gyfl vltoz ahogyan az gyfl felhasznl opciknl lett belltva.',
        'for agent lastname' => 'gyintz csaldinvhez',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'Opcik a aktulis felhasznlnl aki krte ezt az eljrst. (pl. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Emlkeztet zenetek',
        'Parent-Object' => 'Szl objektum',
        'Of couse this feature will take some system performance it self!' => 'Termszetesen ez a kpessg maga is befolysolja a rendszer teljestmnyt!',
        'Detail' => 'Rszletek',
        'Your own Ticket' => 'Az n sajt jegye',
        'TicketZoom' => 'JegyRszletek',
        'Don\'t forget to add a new user to groups!' => 'Ne felejtsen el j felhasznlt hozzadni a csoportokhoz!',
        'Open Tickets' => 'Jegyek megnyitsa',
        'CreateTicket' => 'JegyLtrehozs',
        'You have to select two or more attributes from the select field!' => 'Legalbb kt rtket vlasszon ki a mezben!',
        'unknown' => 'ismeretlen',
        'System Settings' => 'Rendszerbelltsok',
        'Finished' => 'Befejezve',
        'Imported' => 'Importlva',
        'unread' => 'olvasatlan',
        'D' => 'Z',
        'All messages' => 'Minden zenet',
        'System Status' => 'Rendszer llapota',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => 'A jegy adatai (pl.  <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        'Object already linked as %s.' => 'Objektum %s-knt mr kapcsoldik.',
        'A article should have a title!' => 'Egy bejegyzsnek kell legyen cme!',
        'Customer Users <-> Services' => 'gyfl felhasznlk <-> Szolgltatsok',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Konfigurcis rtkek (pl. &lt;OTRS_CONFIG_HttpType&gt;)',
        'All email addresses get excluded on replaying on composing and email.' => 'sszes E-mail cm ki lesz hagyva ismtelt levlrs esetn.',
        'Compose Follow up' => 'Vlasz rsa',
        'Imported by' => 'Importlta',
        'S/MIME' => 'S/MIME',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'Jegy tulajdonos opcik (pl. <OTRS_OWNER_UserFirstname>)',
        'read' => 'olvasott',
        'Product' => 'Termk',
        'kill all sessions' => 'Minden eljrs kilvse',
        'to get the from line of the email' => 'hogy megkapja a feladt az e-mailbl',
        'Solution' => 'Megolds',
        'auto reply' => 'automatikus vlasz',
        'QueueView' => 'Vrlista nzet',
        'My Queue' => 'Sajt vrlistm',
        'Select Box' => 'SQL lekrdezs',
        'Instance' => 'Instancia',
        'Day' => 'Nap',
        'New messages' => 'j zenetek',
        'auto remove' => 'automatikus trls',
        'Service-Name' => 'Szolgltats neve',
        'Can not create link with %s!' => 'Nem tudom a %s kapcsolatt ltrehozni!',
        'Linked as' => 'Kapcsolva mint',
        'Welcome to OTRS' => 'dvzli az OTRS',
        'tmp_lock' => 'ideiglenesen zrolt',
        'modified' => 'mdostott',
        'Delete old database' => 'Rgi adatbzis trlse',
        'Watcher' => 'Figyel',
        'Have a lot of fun!' => 'Sok sikert!',
        'send' => 'klds',
        'Send no notifications' => 'Ne kldjn rtestseket',
        'Note Text' => 'Jegyzet szveg',
        'POP3 Account Management' => 'Levelezsi POP3 fikok kezelse',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Az aktulis gyfl felhasznl adatai (pl. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
        'System State Management' => 'Rendszerllapot kezels',
        'Mailbox' => 'Postafik',
        'PhoneView' => 'TelefonNzet',
        'User-Name' => 'Felhasznlnv',
        'File-Path' => 'File-tvonal',
        'Escaladed Tickets' => 'Eszkallt Jegyek',
        'Yes means, send no agent and customer notifications on changes.' => 'Igen esetn nem kld rtestsekes sem az gyintznek, sem az gyflnek a vltozsokrl.',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Az n "<OTRS_TICKET>" szm jegyhez rendelt e-mailje visszakldsre kerlt a "<OTRS_BOUNCE_TO>" cmre. Vegye fel ezzel a cmmel a kapcsolatot tovbbi informcikrt.',
        'Ticket Status View' => 'Jegy llapotnak megtekintse',
        'Modified' => 'Mdostva',
        'Ticket selected for bulk action!' => 'Jegy kivlasztva csoportos mvelethez!',
    };
    # $$STOP$$
    return;
}

1;
