# --
# Kernel/Language/lt.pm - provides Lithuanian language translation
# Copyright (C) 2001-2011 OTRS AG, http://otrs.org/
# Copyright (C) 2011 Edgaras Luko�evi�ius <edgaras[eta]kauko.lt or admin[eta]sysadmin.lt>
# --
# $Id: lt.pm,v 1.11 2011/12/02 07:30:49 mg Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --
package Kernel::Language::lt;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.11 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: 2011-12-02 08:27:12

    # possible charsets
    $Self->{Charset} = ['utf-8', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%Y-%M-%D %T';
    $Self->{DateFormatLong}      = '%Y-%M-%D - %T';
    $Self->{DateFormatShort}     = '%Y-%M-%D';
    $Self->{DateInputFormat}     = '%Y-%M-%D';
    $Self->{DateInputFormatLong} = '%Y-%M-%D - %T';

    # csv separator
    $Self->{Separator} = ';';

    $Self->{Translation} = {

        # Template: AAABase
        'Yes' => 'Taip',
        'No' => 'Ne',
        'yes' => 'taip',
        'no' => 'ne',
        'Off' => 'I�jungta',
        'off' => 'i�jungta',
        'On' => '�jungta',
        'on' => '�jungta',
        'top' => 'vir�us',
        'end' => 'pabaiga',
        'Done' => 'Atlikta',
        'Cancel' => 'At�aukti',
        'Reset' => 'Atstatyti',
        'last' => 'paskutinis',
        'before' => 'prie�',
        'Today' => '�iandien',
        'Tomorrow' => 'Rytoj',
        'Next Week' => 'Ateinan�i� savait�',
        'day' => 'diena',
        'days' => 'dienos',
        'day(s)' => 'Diena(-os)',
        'd' => 'd',
        'hour' => 'valanda',
        'hours' => 'valandos',
        'hour(s)' => 'valanda(-os)',
        'Hours' => 'Valandos',
        'h' => 'h',
        'minute' => 'minut�',
        'minutes' => 'minut�s',
        'minute(s)' => 'minut�(-�s)',
        'Minutes' => 'minut�s',
        'm' => 'm',
        'month' => 'm�nesis',
        'months' => 'm�nesiai',
        'month(s)' => 'm�nesis(-iai)',
        'week' => 'savait�',
        'week(s)' => 'savait�(-�s)',
        'year' => 'metai',
        'years' => 'met�',
        'year(s)' => 'metai(-�)',
        'second(s)' => 'sekund�(-�s)',
        'seconds' => 'sekund�s',
        'second' => 'sekund�',
        's' => 's',
        'wrote' => 'ra��',
        'Message' => '�inut�',
        'Error' => 'Klaida',
        'Bug Report' => 'Triktis apie defekt�',
        'Attention' => 'D�mesio',
        'Warning' => 'Persp�jimas',
        'Module' => 'Modulis',
        'Modulefile' => 'Modulio failas',
        'Subfunction' => 'Sub-funkcija',
        'Line' => 'Eilut�',
        'Setting' => 'Nustatymas',
        'Settings' => 'Nustatymai',
        'Example' => 'Pavyzdys',
        'Examples' => 'Pavyzd�iai',
        'valid' => 'galiojantis',
        'Valid' => 'Galiojantis',
        'invalid' => 'negaliojantis',
        'Invalid' => '',
        '* invalid' => '* negaliojantis',
        'invalid-temporarily' => 'laikinai negaliojantis',
        ' 2 minutes' => ' 2 minut�s',
        ' 5 minutes' => ' 5 minut�s',
        ' 7 minutes' => ' 7 minut�s',
        '10 minutes' => '10 minu�i�',
        '15 minutes' => '15 minu�i�',
        'Mr.' => 'Ponas',
        'Mrs.' => 'Ponia',
        'Next' => 'Sekantis',
        'Back' => 'Atgal',
        'Next...' => 'Toliau...',
        '...Back' => '...Atgal',
        '-none-' => '-n�ra-',
        'none' => 'n�ra',
        'none!' => 'n�ra!',
        'none - answered' => 'neatsakyta',
        'please do not edit!' => 'Pra�ome neredaguoti!',
        'Need Action' => 'Reikalingas veiksmas',
        'AddLink' => 'Prid�ti nuorod�',
        'Link' => 'Susieti',
        'Unlink' => 'Atsieti',
        'Linked' => 'Susij�s',
        'Link (Normal)' => 'Nuoroda (Normali)',
        'Link (Parent)' => 'Nuoroda (T�vin�?)',
        'Link (Child)' => 'Nuoroda (Vaikin�?)',
        'Normal' => 'Normaus',
        'Parent' => 'T�vinis?',
        'Child' => 'Vaikinis?',
        'Hit' => '',
        'Hits' => '',
        'Text' => 'Tekstas',
        'Standard' => 'Standartinis',
        'Lite' => 'Paprastas',
        'User' => 'Naudotojas',
        'Username' => 'Naudotojo vardas',
        'Language' => 'Kalba',
        'Languages' => 'Kalbos',
        'Password' => 'Slapta�odis',
        'Preferences' => 'Asmeniniai nustatymai',
        'Salutation' => 'Kreipimosi forma(pasveikinimas)',
        'Salutations' => 'Kreipimosi formos(pasveikinimai)',
        'Signature' => 'Para�as',
        'Signatures' => 'Para�ai',
        'Customer' => 'Klientas',
        'CustomerID' => 'Kliento ID',
        'CustomerIDs' => 'Kliento ID',
        'customer' => 'klientas',
        'agent' => 'agentas',
        'system' => 'sistema',
        'Customer Info' => 'Kliento info',
        'Customer Information' => 'Kliento informacija',
        'Customer Company' => 'Kliento organizacija',
        'Customer Companies' => 'Kliento organizacijos',
        'Company' => 'Organizacija',
        'go!' => 'eiti!',
        'go' => 'eiti',
        'All' => 'Visos',
        'all' => 'visi',
        'Sorry' => 'Atsipra�ome',
        'update!' => 'atnaujinti!',
        'update' => 'atnaujinti',
        'Update' => 'Atnaujinti',
        'Updated!' => 'Atnaujinta!',
        'submit!' => 'Pateikti!',
        'submit' => 'Pateikti',
        'Submit' => 'Pateikti',
        'change!' => 'pakeisti!',
        'Change' => 'Pakeisti',
        'change' => 'pakeisti',
        'click here' => 'spauskite �ia',
        'Comment' => 'Komentaras',
        'Invalid Option!' => 'Neleistina pasirinktis!',
        'Invalid time!' => 'Klaidingas laikas!',
        'Invalid date!' => 'Klaidinga data!',
        'Name' => 'Vardas',
        'Group' => 'Grup�',
        'Description' => 'Apra�ymas',
        'description' => 'apra�ymas',
        'Theme' => 'Tema',
        'Created' => 'Sukurtas',
        'Created by' => 'Suk�r�',
        'Changed' => 'Pakeistas',
        'Changed by' => 'Pakeit�',
        'Search' => 'Ie�koti',
        'and' => 'ir',
        'between' => 'tarp',
        'Fulltext Search' => 'Pilno teksto paie�ka',
        'Data' => 'Data',
        'Options' => 'Parinktys',
        'Title' => 'Antra�t�',
        'Item' => 'Elementas',
        'Delete' => 'I�trinti',
        'Edit' => 'Redaguoti',
        'View' => '�i�r�ti',
        'Number' => 'Numeris',
        'System' => 'Sistema',
        'Contact' => 'Kontaktas',
        'Contacts' => 'Kontaktai',
        'Export' => 'Eksportuoti',
        'Up' => '� vir��',
        'Down' => '� apa�i�',
        'Add' => 'Prid�ti',
        'Added!' => 'Prid�ta!',
        'Category' => 'Kategorija',
        'Viewer' => '�i�rykl�',
        'Expand' => 'I�pl�sti',
        'Small' => 'Ma�as',
        'Medium' => 'Vidutinis',
        'Large' => 'Didelis',
        'Date picker' => 'Datos parinkiklis',
        'New message' => 'Nauja �inut�',
        'New message!' => 'Nauja �inut�!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Pra�ome atsakyti � �� trikt�(-us), kad gr��tum�te prie �prastos eil�s per�i�ros!',
        'You have %s new message(s)!' => 'J�s turite %s nauj�(-�) �inut�(-�i�)!',
        'You have %s reminder ticket(s)!' => 'J�s turite %s priminim�(-�) apie trikt�(-us)!',
        'The recommended charset for your language is %s!' => 'J�s� kalbai rekomenduojamas simboli� rinkinys yra %s!',
        'Change your password.' => 'Pasikeiskite slapta�od�.',
        'Please activate %s first!' => 'Pra�ome i� prad�i� aktyvuoti %s!',
        'No suggestions' => 'Pasi�lym� n�ra',
        'Word' => '�odis',
        'Ignore' => 'Ignoruoti',
        'replace with' => 'sukeisti su',
        'There is no account with that login name.' => 'N�ra paskyros su tokiu prisijungimo vardu.',
        'Login failed! Your user name or password was entered incorrectly.' => 'Prisijungimas nepavyko! Neteisingai �vestas prisijungimo vardas arba slapta�odis.',
        'There is no acount with that user name.' => 'N�ra paskyros su tokiu naudotojo vardu.',
        'Please contact your administrator' => 'Pra�ome susisiekti su savo administratoriumi',
        'Logout' => 'Atsijungti',
        'Logout successful. Thank you for using OTRS!' => 'S�kmingai atsijungta! A�i�, kad naudojat�s OTRS!',
        'Invalid SessionID!' => 'Negaliojantis sesijos ID!',
        'Feature not active!' => 'Funkcija/ypatyb� neaktyvuota!',
        'Agent updated!' => 'Agentas atnaujintas!',
        'Create Database' => 'Sukurti duomen� baz�',
        'System Settings' => 'Sistemos nustatymai',
        'Mail Configuration' => 'Pa�to konfig�racija',
        'Finished' => 'Baigta',
        'Install OTRS' => '',
        'Intro' => '',
        'License' => 'Licenzija',
        'Database' => 'Duomen� baz�',
        'Configure Mail' => '',
        'Database deleted.' => '',
        'Database setup succesful!' => '',
        'Login is needed!' => 'Reikia prisijungimo vardo!',
        'Password is needed!' => 'Reikia slapta�od�io!',
        'Take this Customer' => 'Imti �� klient�',
        'Take this User' => 'Imti �� naudotoj�',
        'possible' => 'galima',
        'reject' => 'atmesti',
        'reverse' => 'at�aukti/panaikinti',
        'Facility' => 'Priemon�/�ranga (Facility)',
        'Time Zone' => 'Laiko zona',
        'Pending till' => 'Laukia sprendimo iki',
        'Don\'t use the Superuser account to work with OTRS! Create new Agents and work with these accounts instead.' => 'Nenaudokite supernaudotojo darbui su OTRS! Vietoje to sukurkite naujus agentus ir dirbkite naudodami juos.',
        'Dispatching by email To: field.' => 'I�siuntin�ti pagal el. pa�to Kam: laukel�.',
        'Dispatching by selected Queue.' => 'I�siuntin�ti pagal pasirinkt� eil�.',
        'No entry found!' => '�ra�as nerastas!',
        'Session has timed out. Please log in again.' => 'Baig�si sesijai skirtas laikas. Prisijunkite i� naujo',
        'No Permission!' => 'N�ra leidimo!',
        'To: (%s) replaced with database email!' => 'Kam: (%s) sukeistas su duomen� baz�s el. pa�to adresu!',
        'Cc: (%s) added database email!' => 'Cc: (%s) prid�tas duomen� baz�s pa�to adresas!',
        '(Click here to add)' => '(Spauskite �ia, kad prid�ti)',
        'Preview' => 'Per�i�ra',
        'Package not correctly deployed! Please reinstall the package.' => '',
        '%s is not writable!' => 'Negalima �ra�yti � %s!',
        'Cannot create %s!' => 'Nepavyksta sukurti %s!',
        'Check to activate this date' => '',
        'You have Out of Office enabled, would you like to disable it?' => '',
        'Customer %s added' => 'Klientas %s prid�tas',
        'Role added!' => 'Rol� prid�ta!',
        'Role updated!' => 'Rol� atnaujinta!',
        'Attachment added!' => 'Priedas prid�tas!',
        'Attachment updated!' => 'Priedas atnaujintas!',
        'Response added!' => 'Atsakymas prid�tas!',
        'Response updated!' => 'Atsakymas atnaujintas!',
        'Group updated!' => 'Grup� atnaujinta',
        'Queue added!' => 'Eil� prid�ta!',
        'Queue updated!' => 'Eil� atnaujinta!',
        'State added!' => 'B�sena prid�ta!',
        'State updated!' => 'B�sena atnaujinta!',
        'Type added!' => 'Tipas prid�tas!',
        'Type updated!' => 'Tipas atnaujintas!',
        'Customer updated!' => 'Klientas atnaujintas!',
        'Customer company added!' => '',
        'Customer company updated!' => '',
        'Mail account added!' => '',
        'Mail account updated!' => '',
        'System e-mail address added!' => '',
        'System e-mail address updated!' => '',
        'Contract' => 'Kontraktas',
        'Online Customer: %s' => 'Prisijung� klientai: %s',
        'Online Agent: %s' => 'Prisijung� agentai: %s',
        'Calendar' => 'Kalendorius',
        'File' => 'Failas',
        'Filename' => 'Failo pavadinimas',
        'Type' => 'Tipas',
        'Size' => 'Dydis',
        'Upload' => '�kelti',
        'Directory' => 'Direktorija',
        'Signed' => 'Pasira�ytas',
        'Sign' => 'Pasira�yti',
        'Crypted' => '�ifruotas',
        'Crypt' => '�ifras',
        'PGP' => 'PGP',
        'PGP Key' => 'PGP raktas',
        'PGP Keys' => 'PGP raktai',
        'S/MIME' => 'S/MIME',
        'S/MIME Certificate' => 'S/MIME sertifikatas',
        'S/MIME Certificates' => 'S/MIME sertifikatai',
        'Office' => 'Biuras',
        'Phone' => 'Telefonas',
        'Fax' => 'Faksas',
        'Mobile' => 'Mobilus telefonas',
        'Zip' => 'Pa�to kodas',
        'City' => 'Miestas',
        'Street' => 'Gatv�',
        'Country' => '�alis',
        'Location' => 'Vietov�',
        'installed' => '�diegtas',
        'uninstalled' => 'ne�diegtas',
        'Security Note: You should activate %s because application is already running!' => 'Saugumo pastaba: tur�tum�te aktyvuoti %s, nes aplikacija jau vykdoma!',
        'Unable to parse repository index document.' => 'Nepavyko i�nagrin�ti saugyklos indeks� dokumento.',
        'No packages for your framework version found in this repository, it only contains packages for other framework versions.' => '�ioje saugykloje n�ra paket� J�s� naudojamai pagrindo (framework) versijai, yra tik kitoms versijoms.',
        'No packages, or no new packages, found in selected repository.' => 'Pasirinktoje saugykloje arba n�ra nauj� paket�, arba i�vis n�ra joki� paket�.',
        'Edit the system configuration settings.' => 'Keisti sistemos konfig�racijos nustatymus',
        'printed at' => 'spausdinta',
        'Loading...' => 'Kraunasi...',
        'Dear Mr. %s,' => 'Gerbiamas pone %s,',
        'Dear Mrs. %s,' => 'Gerbiama ponia %s,',
        'Dear %s,' => 'Gerbiamas %s,',
        'Hello %s,' => 'Sveiki %s,',
        'This email address already exists. Please log in or reset your password.' => '�is el. pa�to adresas jau yra. Pra�ome prisijungti arba atsistatyti slapta�od�.',
        'New account created. Sent login information to %s. Please check your email.' => 'Sukruta nauja paskyra. Prisijungimo informacija i�i�sta � %s. Pra�ome pasitikrinti savo el. pa�t�.',
        'Please press Back and try again.' => 'Pra�ome spausti Atgal ir bandyti dar kart�.',
        'Sent password reset instructions. Please check your email.' => 'Slapta�od�io atstatymo instrukcijos i�si�stos. Pra�ome pasitikrinti savo el. pa�t�.',
        'Sent new password to %s. Please check your email.' => 'Naujas slapta�odis i�si�stas � %s. Pra�ome pasitikrinti savo el. pa�t�.',
        'Upcoming Events' => 'Art�jantys �vykiai',
        'Event' => '�vykis',
        'Events' => '�vykiai',
        'Invalid Token!' => 'Negalimas triktis!',
        'more' => 'daugiau',
        'For more info see:' => 'Daugiau informacijos �i�r�kite:',
        'Package verification failed!' => 'Paketo patikrinimas nepavyko',
        'Collapse' => 'Sutraukti',
        'Shown' => 'Rodomi',
        'News' => 'Naujienos',
        'Product News' => 'Produkto naujienos',
        'OTRS News' => 'OTRS Naujienos',
        '7 Day Stats' => '7 dien� statistika',
        'Bold' => 'Pary�kintas',
        'Italic' => 'Pasvir�s',
        'Underline' => 'Pabrauktas',
        'Font Color' => '�rifto spalva',
        'Background Color' => 'Fono spalva',
        'Remove Formatting' => 'Panaikinti formatavim�',
        'Show/Hide Hidden Elements' => 'Rodyti/Sl�pti pasl�ptus elementus',
        'Align Left' => 'Lygiuoti kair�je',
        'Align Center' => 'Lygiuoti centre',
        'Align Right' => 'Lygiuoti de�in�je',
        'Justify' => 'Lygiuoti pagal abi kra�tines',
        'Header' => 'Antra�t�',
        'Indent' => '�trauka',
        'Outdent' => 'Atitrauka',
        'Create an Unordered List' => 'Sukurti nerikiuot� s�ra��',
        'Create an Ordered List' => 'Sukurti rikiuot� s�ra��',
        'HTML Link' => 'HTML nuoroda',
        'Insert Image' => '�terpti paveiksl�l�',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'At�aukti',
        'Redo' => 'Atstatyti',
        'Scheduler process is registered but might not be running.' => '',
        'Scheduler is not running.' => '',

        # Template: AAACalendar
        'New Year\'s Day' => 'Naujieji metai',
        'International Workers\' Day' => 'Tarptautin� darbuotoj� diena',
        'Christmas Eve' => 'K��ios',
        'First Christmas Day' => 'Pirmoji Kal�d� diena',
        'Second Christmas Day' => 'Antroji Kal�d� diena',
        'New Year\'s Eve' => 'Nauj�j� Met� i�vakar�s',

        # Template: AAAMonth
        'Jan' => 'Sau',
        'Feb' => 'Vas',
        'Mar' => 'Kov',
        'Apr' => 'Bal',
        'May' => 'Geg',
        'Jun' => 'Bir',
        'Jul' => 'Lie',
        'Aug' => 'Rug',
        'Sep' => 'Rugs',
        'Oct' => 'Spa',
        'Nov' => 'Lap',
        'Dec' => 'Gruo',
        'January' => 'Sausis',
        'February' => 'Vasaris',
        'March' => 'Kovas',
        'April' => 'Balandis',
        'May_long' => 'Gegu��',
        'June' => 'Bir�elis',
        'July' => 'Liepa',
        'August' => 'Rugpj�tis',
        'September' => 'Rugs�jis',
        'October' => 'Spalis',
        'November' => 'Lapkritis',
        'December' => 'Gruodis',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Nustatymai s�kmingai atnaujinti!',
        'User Profile' => 'Naudotojo profilis',
        'Email Settings' => 'Elektroninio pa�to nustatymai',
        'Other Settings' => 'Kiti nustatymai',
        'Change Password' => 'Pakeisti slapta�od�',
        'Current password' => 'Dabartinis slapta�odis',
        'New password' => 'Naujas slapta�odis',
        'Verify password' => 'Patikrinti slapta�od�',
        'Spelling Dictionary' => 'Ra�ybos �odynas',
        'Default spelling dictionary' => 'Numatytasis ra�ybos �odynas',
        'Max. shown Tickets a page in Overview.' => 'Daugiausia, ap�valgoje rodom�, trik�i� viename puslapyje.',
        'The current password is not correct. Please try again!' => 'Dabartinis slapta�odis �vestas neteisingai. Bandykite i� naujo!',
        'Can\'t update password, your new passwords do not match. Please try again!' => 'Ne�manoma atnaujinti slapta�od�io, nes nesutampa J�s� �vesti nauji slapta�od�iai!',
        'Can\'t update password, it contains invalid characters!' => 'Ne�manoma atnaujinti slapta�od�io, nes jame yra neleistin� simboli�.',
        'Can\'t update password, it must be at least %s characters long!' => 'Ne�manoma atnaujinti slapta�od�io. Jis turi b�ti ma�iausiai %s simboli� ilgio.',
        'Can\'t update password, it must contain at least 2 lowercase  and 2 uppercase characters!' => 'Ne�manoma atnaujinti slapta�od�io. Slapta�od� turi sudaryti ma�iausiai 2 did�iosios ir 2 ma�osios raid�s.',
        'Can\'t update password, it must contain at least 1 digit!' => 'Ne�manoma atnaujinti slapta�od�io. Slapta�odyje turi b�ti bent 1 skaitmuo.',
        'Can\'t update password, it must contain at least 2 characters!' => 'Ne�manoma atnaujinti slapta�od�io. Slapta�odis turi b�ti ma�iausiai 2 simboli� ilgio.',
        'Can\'t update password, this password has already been used. Please choose a new one!' => 'Ne�manoma atnaujinti slapta�od�io. �is slapta�odis jau buvo naudotas. Pra�ome pasirinkti nauj�!',
        'Select the separator character used in CSV files (stats and searches). If you don\'t select a separator here, the default separator for your language will be used.' => 'Pasirinkite skyrikl�, kur� norite naudoti CSV failuose (statistikoje ir paie�koje) arba bus naudojamas standartinis J�s� kalbos skyriklis.',
        'CSV Separator' => 'CSV skyriklis',

        # Template: AAAStats
        'Stat' => 'Statistika',
        'Sum' => 'Suma',
        'Please fill out the required fields!' => 'Pra�ome u�pildyti b�tinus laukus!',
        'Please select a file!' => 'Pra�ome pasirinkti fail�!',
        'Please select an object!' => 'Pra�ome pasirinkti objekt�!',
        'Please select a graph size!' => 'Pra�ome pasirinkti diagramos dyd�!',
        'Please select one element for the X-axis!' => 'Pra�ome pasirinkti element� X a�iai!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Pra�ome pasirinkti tik vien� element� arba nuimti mygtuko "Fiksuota" varnel�!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Jeigu naudojate �ymeles turite pasirinkti kurias nors reik�mes ir pasirinkimo laukelio!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Pra�ome �veasti reik�m� � pasirinkt� �vedimo laukel� arba at�ym�ti \'Fiksuotas\'!',
        'The selected end time is before the start time!' => 'Pasirinktas pabaigos laikas yra ankstesnis negu prad�ios laikas!',
        'You have to select one or more attributes from the select field!' => 'Privalote pasirinkti bent vien� reik�m� i� pasirinkto lauko!',
        'The selected Date isn\'t valid!' => 'Pasirinkta data yra klaidinga!',
        'Please select only one or two elements via the checkbox!' => 'Pra�ome pasirinkti tik vien� ar du elemntus i� checkbox!',
        'If you use a time scale element you can only select one element!' => 'Jeigu naudojate laiko skal�s element�, tai galite pasirinkti tik vien� element�!',
        'You have an error in your time selection!' => 'J�s� datos pasirinkime yra klaida!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'J�s� pasirinktas ataskaitos intervalas yra per trumpas. Pra�ome pasirinkti didesn� laiko skal�!',
        'The selected start time is before the allowed start time!' => 'Pasirinktas prad�ios laikas yra prie� ankstesnis negu leid�iamas prad�ios laikas!',
        'The selected end time is after the allowed end time!' => 'Pasirinktas pabaigos laikas yra v�lesnis negu leistinas pabaigos laikas!',
        'The selected time period is larger than the allowed time period!' => 'Pasirinktas laikotarpis yra ilgesnis negu leistina!',
        'Common Specification' => 'Bendroji specifikacija',
        'X-axis' => 'X a�is',
        'Value Series' => 'Reik�mi� serija',
        'Restrictions' => 'Apribojimai',
        'graph-lines' => 'Linijin� diagrama',
        'graph-bars' => 'Stulpelin� diagrama',
        'graph-hbars' => 'Juostin� (horizontal�s stulpeliai) diagrama',
        'graph-points' => 'Ta�kin� diagrama',
        'graph-lines-points' => 'Linijin�-ta�kin� diagrama',
        'graph-area' => 'Plok�tumin� diagrama',
        'graph-pie' => 'Skritulin� diagrama',
        'extended' => 'i�pl�sta',
        'Agent/Owner' => 'Agentas/Savininkas',
        'Created by Agent/Owner' => 'Sukurta agento/savininko',
        'Created Priority' => 'Suk�rimo prioritetas',
        'Created State' => 'Suk�rimo b�sena',
        'Create Time' => 'Suk�rimo laikas',
        'CustomerUserLogin' => 'Kliento Naudotojo Prisijungimas',
        'Close Time' => 'U�darymo laikas',
        'TicketAccumulation' => 'Trik�i� sankaupa (accumulation)',
        'Attributes to be printed' => 'Atributai spausdinimui',
        'Sort sequence' => 'R��iavimo seka',
        'Order by' => 'Rikiuoti pagal',
        'Limit' => 'Limitas',
        'Ticketlist' => 'Trik�i� s�ra�as',
        'ascending' => 'did�jan�ia tvarka',
        'descending' => 'ma��jan�ia tvarka',
        'First Lock' => 'Pirmasis u�rakinimas',
        'Evaluation by' => '�vertinimas pagal',
        'Total Time' => 'I� viso laiko',
        'Ticket Average' => 'Trik�i� vidurkis',
        'Ticket Min Time' => 'Trik�i� minimalus laikas',
        'Ticket Max Time' => 'Trik�i� maksimalus laikas',
        'Number of Tickets' => 'Trik�i� kiekis',
        'Article Average' => 'Straipsni� vidurkis',
        'Article Min Time' => 'Straipsni� minimalus laikas',
        'Article Max Time' => 'Straipsni� maksimalus laikas',
        'Number of Articles' => 'Straipsni� kiekis',
        'Accounted time by Agent' => 'Apskai�iuotas laikas pagal agent�',
        'Ticket/Article Accounted Time' => 'Trik�i�/agent� apskai�iuotas laikas',
        'TicketAccountedTime' => 'Trikties apskai�iuotas laikas',
        'Ticket Create Time' => 'Trikties suk�rimo laikas',
        'Ticket Close Time' => 'Trikties u�darymo laikas',

        # Template: AAATicket
        'Status View' => 'B�senos per�i�ra',
        'Bulk' => 'Masi�kai',
        'Lock' => 'U�rakinti',
        'Unlock' => 'Atrakinti',
        'History' => 'Istorija',
        'Zoom' => 'Priartinti',
        'Age' => 'Am�ius',
        'Bounce' => 'Nukreipti (Bounce)',
        'Forward' => 'Persi�sti',
        'From' => 'Nuo',
        'To' => 'Kam',
        'Cc' => 'Kopija',
        'Bcc' => 'Bcc',
        'Subject' => 'Tema',
        'Move' => 'Perkelti',
        'Queue' => 'Eil�',
        'Queues' => 'Eil�s',
        'Priority' => 'Prioritetas',
        'Priorities' => 'Prioritetai',
        'Priority Update' => 'Prioritetu atnaujinimas',
        'Priority added!' => '',
        'Priority updated!' => '',
        'Signature added!' => '',
        'Signature updated!' => '',
        'SLA' => '',
        'Service Level Agreement' => 'Aptarnavimo lygio sutartis',
        'Service Level Agreements' => 'Aptarnavimo lygio sutartys',
        'Service' => 'Paslauga',
        'Services' => 'Paslaugos',
        'State' => 'B�sena',
        'States' => 'B�senos',
        'Status' => 'Statusas',
        'Statuses' => 'Statusai',
        'Ticket Type' => 'Trikties tipas',
        'Ticket Types' => 'Trikties tipai',
        'Compose' => 'Sukurti',
        'Pending' => 'Laukiantis sprendimo',
        'Owner' => 'Savininkas',
        'Owner Update' => 'Savininko pakeitimas',
        'Responsible' => 'Atsakingas',
        'Responsible Update' => 'Atsakingo atnaujinimas',
        'Sender' => 'Siunt�jas',
        'Article' => 'Straipsnis',
        'Ticket' => 'Triktis',
        'Createtime' => 'Suk�rimo laikas',
        'plain' => 'paprastas',
        'Email' => 'El. pa�tas',
        'email' => 'el. pa�tas',
        'Close' => 'U�verti',
        'Action' => 'Veiksmas',
        'Attachment' => 'Priedas',
        'Attachments' => 'Priedai',
        'This message was written in a character set other than your own.' => '�i �inut� para�yta kitokiu simboli� rinkiniu negu J�s� esama.',
        'If it is not displayed correctly,' => 'Jeigu neatvaizduojama teisingai,',
        'This is a' => 'Tai yra',
        'to open it in a new window.' => 'atverti naujame lange',
        'This is a HTML email. Click here to show it.' => '�is el. lai�kas yra HTML formatu. Spauskite �ia jeigu norite j� pamatyti.',
        'Free Fields' => 'Laisvi laukeliai',
        'Merge' => 'Sujungti',
        'merged' => 'sujungti',
        'closed successful' => 'u�darytas s�kmingai',
        'closed unsuccessful' => 'u�darytas nes�kmingai',
        'Locked Tickets Total' => 'I� viso u�rakint� trik�i�',
        'Locked Tickets Reminder Reached' => '',
        'Locked Tickets New' => 'Nauji u�rakintos triktys',
        'Responsible Tickets Total' => 'I� viso atsaking� trik�i�',
        'Responsible Tickets New' => 'Naujos atsakingos triktys',
        'Responsible Tickets Reminder Reached' => '',
        'Watched Tickets Total' => 'I� viso stebim� trik�i�',
        'Watched Tickets New' => 'Naujos stebimos triktys',
        'Watched Tickets Reminder Reached' => '',
        'All tickets' => 'Visos triktys',
        'Tickets available' => 'Prieinamos triktys',
        'Escalation' => 'Eskalavimas',
        'last-search' => 'Paskutin� paie�ka',
        'QueueView' => 'Eili� per�i�ra',
        'Ticket Escalation View' => 'Trik�i� eskalavimo per�i�ra',
        'Message from' => '',
        'End message' => '',
        'Forwarded message from' => '',
        'End forwarded message' => '',
        'new' => 'naujas',
        'open' => 'atidarytas',
        'Open' => 'Atidarytas',
        'closed' => 'u�darytas',
        'Closed' => 'U�darytas',
        'removed' => 'pa�alintas',
        'pending reminder' => 'laukiantis priminimas',
        'pending auto' => 'laukia auto',
        'pending auto close+' => 'laukia automati�ko u�darymo kaip s�kmingas',
        'pending auto close-' => 'laukia automati�ko u�darymo kaip nes�kmingas',
        'email-external' => 'I�orinis el. pa�tas',
        'email-internal' => 'Vidinis el. pa�tas',
        'note-external' => 'I�orin� pastaba',
        'note-internal' => 'Vidin� pastaba',
        'note-report' => 'Pastaba ataskaitai',
        'phone' => 'Telefonas',
        'sms' => 'SMS',
        'webrequest' => 'Web u�klausa',
        'lock' => 'u�rakintas',
        'unlock' => 'atrakintas',
        'very low' => 'labai �emas',
        'low' => '�emas',
        'normal' => 'normalus',
        'high' => 'auk�tas',
        'very high' => 'labai auk�tas',
        '1 very low' => '1 labai �emas',
        '2 low' => '2 �emas',
        '3 normal' => '3 normalus',
        '4 high' => '4 auk�tas',
        '5 very high' => '5 labai auk�tas',
        'auto follow up' => '',
        'auto reject' => '',
        'auto remove' => '',
        'auto reply' => '',
        'auto reply/new ticket' => '',
        'Ticket "%s" created!' => 'Triktis "%s" sukurta!',
        'Ticket Number' => 'Trikties numeris',
        'Ticket Object' => 'Trikties objektas',
        'No such Ticket Number "%s"! Can\'t link it!' => 'N�ra trikties numeriu "%s"! Negalima jo susieti!',
        'You don\'t have write access to this ticket.' => '',
        'Sorry, you need to be the ticket owner to perform this action.' => '',
        'Ticket selected.' => '',
        'Ticket is locked by another agent.' => 'Trikt� u�rakino kitas agentas!',
        'Ticket locked.' => '',
        'Don\'t show closed Tickets' => 'Nerodyti u�daryt� trik�i�',
        'Show closed Tickets' => 'Rodyti u�darytus triktimis',
        'New Article' => 'Naujas straipsnis',
        'Unread article(s) available' => 'Prieinami neperskaityti straipsniai',
        'Remove from list of watched tickets' => 'Pa�alinti i� stebim� trik�i� s�ra�o',
        'Add to list of watched tickets' => 'Prid�ti prie stebim� trik�i� s�ra�o',
        'Email-Ticket' => 'Triktis el. pa�tu',
        'Create new Email Ticket' => 'Sukurti nauj� el. pa�to trikt�',
        'Phone-Ticket' => 'Triktis telefonu',
        'Search Tickets' => 'Ie�koti trik�i�',
        'Edit Customer Users' => 'Redaguoti kliento naudotojus',
        'Edit Customer Company' => 'Redaguoti kliento organizacij�',
        'Bulk Action' => 'Masinis veiksmas',
        'Bulk Actions on Tickets' => 'Masinis veiksmas triktims',
        'Send Email and create a new Ticket' => 'I�si�sti el. lai�k� ir sukurti nauj� trikt�',
        'Create new Email Ticket and send this out (Outbound)' => 'Sukurti nauj� el. pa�to trikt� ir i�si�sti j� (I�orinis)',
        'Create new Phone Ticket (Inbound)' => 'Sukurti nauj� telefonin� trikt� (vidinis)',
        'Overview of all open Tickets' => 'Vis� atvir� trik�i� ap�valga',
        'Locked Tickets' => 'U�rakintos triktys',
        'My Locked Tickets' => 'Mano u�rakintos triktys',
        'My Watched Tickets' => 'Mano stebimos triktys',
        'My Responsible Tickets' => 'Triktys u� kuriuos a� atsakingas',
        'Watched Tickets' => 'Stebimos triktys',
        'Watched' => 'Stebimi',
        'Watch' => 'Steb�ti',
        'Unwatch' => 'Nesteb�ti',
        'Lock it to work on it' => '',
        'Unlock to give it back to the queue' => '',
        'Shows the ticket history!' => 'Parodo trikties istorij�!',
        'Print this ticket!' => 'Spausdinti �� trikt�!',
        'Change the ticket priority!' => 'Pakeisti trikties prioritet�',
        'Change the ticket free fields!' => 'Keisti trikties laisvus laukelius',
        'Link this ticket to an other objects!' => 'Susieti �� trikt� su kitais objektais!',
        'Change the ticket owner!' => 'Pakeisti trikties savinink�!',
        'Change the ticket customer!' => 'Pakeisti trikties klient�!',
        'Add a note to this ticket!' => 'Prid�ti pastab� �iam triktimi!',
        'Merge this ticket!' => 'Sujungti �� trikt�!',
        'Set this ticket to pending!' => 'Nustatyti �� trikt� kaip laukiant� sprendimo!',
        'Close this ticket!' => 'U�daryti �� trikt�!',
        'Look into a ticket!' => 'Pa�i�r�ti trikt�!',
        'Delete this ticket!' => 'I�trinti trikt�!',
        'Mark as Spam!' => 'Pa�ym�ti kaip Spam!',
        'My Queues' => 'Mano eil�s',
        'Shown Tickets' => 'Rodomos triktys',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'J�s� el. lai�kas trikties numeriu "<OTRS_TICKET>" yra sujungtas su "<OTRS_MERGE_TO_TICKET>"!',
        'Ticket %s: first response time is over (%s)!' => 'Triktis %s: baig�si pirmojo atsakymo laikas (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'Triktis %s: pirmojo atsakymo laikas pasibaigs po %s!',
        'Ticket %s: update time is over (%s)!' => 'Triktis %s: baig�si atnaujinimo laikas (%s)!',
        'Ticket %s: update time will be over in %s!' => 'Triktis %s: atnaujinimo laikas pasibaigs po %s!',
        'Ticket %s: solution time is over (%s)!' => 'Triktis %s: baig�si i�sprendimo laikas (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'Triktis %s: i�sprendimo laikas baigsis po %s!',
        'There are more escalated tickets!' => 'Yra ir daugiau eskaluot� trik�i�!',
        'Plain Format' => 'Paprastas formatas',
        'Reply All' => 'Atsakyti visiems',
        'Direction' => 'Kryptis',
        'Agent (All with write permissions)' => 'Agentas (Visi su ra�ymo leidimais)',
        'Agent (Owner)' => 'Agentas (Savininkas)',
        'Agent (Responsible)' => 'Agentas (Atsakingas)',
        'New ticket notification' => 'Persp�jimas apie nauj� trikt�',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Si�sti persp�jim� jeigu yra nauj� trik�i� "mano eil�se".',
        'Send new ticket notifications' => 'Si�sti persp�jimus apie naujus triktimis',
        'Ticket follow up notification' => 'Trikties eigos informacija',
        'Ticket lock timeout notification' => 'Persp�jimas apie trikties u�rakinimo laikotarpio pabaig�',
        'Send me a notification if a ticket is unlocked by the system.' => 'Si�sti man persp�jim� jeigu sistema atrakina trikt�',
        'Send ticket lock timeout notifications' => 'Si�sti persp�jimus apie trikties u�rakinimo laikotarpio pabaig�',
        'Ticket move notification' => '�sp�jimas apie trikties perk�lim�',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Si�sti man �sp�jim� jeigu triktis yra perkeliamas � vien� i� "mano eili�".',
        'Send ticket move notifications' => 'Si�sti �sp�jimus apie trikties perk�lim�',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => '',
        'Custom Queue' => 'Pasirinktin� (nestandartin�) eil�',
        'QueueView refresh time' => 'Eili� per�i�ros lango atnaujinimo intervalas',
        'If enabled, the QueueView will automatically refresh after the specified time.' => 'Eili� per�i�ra automati�kai atsinaujins po nurodyto laiko, jeigu tai �jungsite',
        'Refresh QueueView after' => 'Atnaujinti eili� per�i�r� po',
        'Screen after new ticket' => 'Langas po naujo trikties suk�rimo',
        'Show this screen after I created a new ticket' => 'Rodyti �� lang� po to kai sukursiu nauj� trikt�',
        'Closed Tickets' => 'U�darytos triktys',
        'Show closed tickets.' => 'Rodyti u�darytus triktimis.',
        'Max. shown Tickets a page in QueueView.' => 'Eili� per�i�roje rodom� trik�i� kiekis.',
        'Ticket Overview "Small" Limit' => 'Trik�i� ap�valgos "ma�asis(apatinis)" limitas',
        'Ticket limit per page for Ticket Overview "Small"' => 'Trik�i� limitas puslapyje "ma��jam/apatiniam" ap�valgos(overview) limitui',
        'Ticket Overview "Medium" Limit' => 'Trik�i� ap�valgos "vidutinis" limitas',
        'Ticket limit per page for Ticket Overview "Medium"' => 'Trik�i� limitas puslapyje "vidutinaim" ap�valgos(overview) limitui',
        'Ticket Overview "Preview" Limit' => 'Trik�i� ap�valgos "per�i�ros" limitas',
        'Ticket limit per page for Ticket Overview "Preview"' => 'Trik�i� limitas puslapyje "per�i�ros(preview)" ap�valgos(overview) limitui',
        'Ticket watch notification' => 'Prane�imas apie trikties steb�jim�',
        'Send me the same notifications for my watched tickets that the ticket owners will get.' => 'Mano stebimoms triktims si�sti man tuos pa�ius prane�imus, kuriuos gaus ir patys prane�im� savininkai.',
        'Send ticket watch notifications' => 'Si�sti prane�imus apie trik�i� steb�jim�',
        'Out Of Office Time' => 'Ne darbo laikas',
        'New Ticket' => 'Nauja triktis',
        'Create new Ticket' => 'Sukurti nauj� trikt�',
        'Customer called' => '',
        'phone call' => 'Skambutis telefonu',
        'Phone Call Outbound' => 'I�einantis skambutis telefonu',
        'Phone Call Inbound' => '�einantis skambutis telefonu',
        'Reminder Reached' => 'Pasiektas priminimas',
        'Reminder Tickets' => 'Prane�imai su priminimu',
        'Escalated Tickets' => 'Eskaluotos triktys',
        'New Tickets' => 'Naujos triktys',
        'Open Tickets / Need to be answered' => 'Atviros / Laukian�ios atsakymo triktys',
        'All open tickets, these tickets have already been worked on, but need a response' => 'Visos atviros triktys su kuriomis jau buvo dirbta, bet joms dar reikia atsako',
        'All new tickets, these tickets have not been worked on yet' => 'Visos naujos triktys su kuriomis dar nebuvo dirbta',
        'All escalated tickets' => 'Visos eskaluotos triktys',
        'All tickets with a reminder set where the reminder date has been reached' => 'Visos triktys turin�ios nustatytus priminimus, kuri� priminimo laikai jau at�jo',
        'Archived tickets' => '',
        'Unarchived tickets' => '',
        'History::Move' => 'Triktis perkelta i� eil�s "%s" (%s) � eil� "%s" (%s).',
        'History::TypeUpdate' => 'Tipas pakeistas � "%s" (ID=%s).',
        'History::ServiceUpdate' => 'Servisas pakeistas � "%s" (ID=%s).',
        'History::SLAUpdate' => 'SLA pakeistas � "%s" (ID=%s).',
        'History::NewTicket' => 'Nauja triktis [%s] sukurta (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp [%s]. %s',
        'History::SendAutoReject' => 'I�si�stas "%s" automatinis atmetimas.',
        'History::SendAutoReply' => 'I�si�stas "%s" automatinis atsakymas.',
        'History::SendAutoFollowUp' => 'I�si�stas "%s" automatinis FollowUp.',
        'History::Forward' => 'Persi�stas � "%s".',
        'History::Bounce' => 'Nukreiptas � "%s".',
        'History::SendAnswer' => 'El. laikas nusi�stas � "%s".',
        'History::SendAgentNotification' => '"%s"-prane�imas nusi�stas � "%s".',
        'History::SendCustomerNotification' => 'Prane�imas nusi�stas � "%s".',
        'History::EmailAgent' => 'Klientui nusi�stas el. lai�kas.',
        'History::EmailCustomer' => 'Prid�tas el. pa�tas. %s',
        'History::PhoneCallAgent' => 'Agentas skalbino klientui.',
        'History::PhoneCallCustomer' => 'Klientas skambino mums.',
        'History::AddNote' => 'Prid�ta pastaa (%s)',
        'History::Lock' => 'Triktis u�rakinta.',
        'History::Unlock' => 'Triktis atrakinta.',
        'History::TimeAccounting' => 'Apskai�iuota %s laiko vientet�. Dabar i� viso %s laiko vienet�.',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Atnaujintas: %s',
        'History::PriorityUpdate' => 'Prioritetas pakeistas i� "%s" (%s) � "%s" (%s).',
        'History::OwnerUpdate' => 'Naujas savininkas yra "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! Keine Auto-Antwort versandt an "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Aktualisiert: %s',
        'History::StateUpdate' => 'Alt: "%s" Neu: "%s"',
        'History::TicketDynamicFieldUpdate' => 'Trikties laisv� laukeli� pakeitimas: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Kliento u�klausa internetu.',
        'History::TicketLinkAdd' => 'Prid�ti trikties s�saja "%s".',
        'History::TicketLinkDelete' => 'Pa�alinta trikties s�saja "%s".',
        'History::Subscribe' => '',
        'History::Unsubscribe' => '',
        'History::SystemRequest' => '',
        'History::ResponsibleUpdate' => 'Naujas atsakingas asmuo yra "%s" (ID=%s).',
        'History::ArchiveFlagUpdate' => '',

        # Template: AAAWeekDay
        'Sun' => 'S',
        'Mon' => 'Pr',
        'Tue' => 'A',
        'Wed' => 'T',
        'Thu' => 'K',
        'Fri' => 'P',
        'Sat' => '�',

        # Template: AdminAttachment
        'Attachment Management' => 'Pried� valdymas',
        'Actions' => 'Veiksmai',
        'Go to overview' => 'Eiti � per�i�r�',
        'Add attachment' => 'Prid�ti pried�',
        'List' => 'S�ra�as',
        'Validity' => '',
        'No data found.' => 'Nerasta duomen�.',
        'Download file' => 'Parsisi�sti fail�',
        'Delete this attachment' => 'I�trinti �� pried�',
        'Add Attachment' => 'Prid�ti Pried�',
        'Edit Attachment' => 'Keisti pried�',
        'This field is required.' => '�is laukelis yra b�tinas.',
        'or' => 'arba',

        # Template: AdminAutoResponse
        'Auto Response Management' => 'Automatini� atsakym� valdymas',
        'Add auto response' => 'Prid�ti automatin� atsakym�',
        'Add Auto Response' => 'Prid�ti Automatin� atsakym�',
        'Edit Auto Response' => 'Redaguoti automatin� atsakym�',
        'Response' => 'Atsakymas',
        'Auto response from' => 'Automatinis atsakymas nuo',
        'Reference' => 'Nuoroda (Reference)',
        'You can use the following tags' => 'Galite naudoti �ias �ymeles',
        'To get the first 20 character of the subject.' => '',
        'To get the first 5 lines of the email.' => '',
        'To get the realname of the sender (if given).' => '',
        'To get the article attribute' => '',
        ' e. g.' => 'pvz.',
        'Options of the current customer user data' => '�io kliento naudotojo duomen� parinktys',
        'Ticket owner options' => 'Trikties savininko parinktys',
        'Ticket responsible options' => '',
        'Options of the current user who requested this action' => 'Naudotojo pra�iusio �io veiksmo parinktys',
        'Options of the ticket data' => 'Trikties duomen� parinktys',
        'Config options' => 'Konfig�racijos parinktys',
        'Example response' => 'Atsakymo pavyzdys',

        # Template: AdminCustomerCompany
        'Customer Company Management' => 'Kliento  valdymas',
        'Wildcards like \'*\' are allowed.' => '',
        'Add customer company' => 'Prid�ti organizacij�',
        'Please enter a search term to look for customer companies.' => 'Pra�ome �vesti paie�kos termin� klient� firm� paie�kai.',
        'Add Customer Company' => 'Prid�ti kliento organizacij�',

        # Template: AdminCustomerUser
        'Customer Management' => 'Klient� valdymas',
        'Add customer' => 'Prid�ti klient�',
        'Select' => 'Pasirinkti',
        'Hint' => 'U�uomina',
        'Customer will be needed to have a customer history and to login via customer panel.' => 'Klientas bus reikalingas tur�ti klient� istorijai ir prisijungimui per klient� skydel�.',
        'Please enter a search term to look for customers.' => 'Pra�ome �vesti paie�kos termin� klient� paie�kai.',
        'Last Login' => 'Paskutinis prisijungimas',
        'Add Customer' => 'Prid�ti klient�',
        'Edit Customer' => 'Redaguoti klient�',
        'This field is required and needs to be a valid email address.' => '�is laukelis yra b�tinas ir turi b�ti galiojontis pa�to adresas.',
        'This email address is not allowed due to the system configuration.' => 'D�l sistemos konfig�racijos �is el. pa�to adresas yra neleid�iamas.',
        'This email address failed MX check.' => 'Nepavyko �io el. pa�to adreso MX patikrinimas.',
        'DNS problem, please check your configuration and the error log.' => '',
        'The syntax of this email address is incorrect.' => '�io el. pa�to adreso sintaks� yra neteisinga.',

        # Template: AdminCustomerUserGroup
        'Manage Customer-Group Relations' => 'Valdyti klientas-grup� s�sajas',
        'Notice' => 'Persp�jimas',
        'This feature is disabled!' => '�i ypatyb� yra i�jungta!',
        'Just use this feature if you want to define group permissions for customers.' => '�i� ypatyb� naudokite tik tada jeigu norite klientams apibr��ti grupi� leidimus.',
        'Enable it here!' => '�jungti �ia!',
        'Search for customers.' => '',
        'Edit Customer Default Groups' => 'Redaguoti numatyt�sias klient� grupes',
        'These groups are automatically assigned to all customers.' => '�ios grup�s yra automati�kai priskiriamos visiems klientams.',
        'You can manage these groups via the configuration setting "CustomerGroupAlwaysGroups".' => '�ias grupes galite valdyti per konfig�racijos nustatym� "CustomerGroupAlwaysGroups".',
        'Filter for Groups' => 'Filtruoti grupes',
        'Select the customer:group permissions.' => 'Pasirinkite klientas:grup� leidimus',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the customer).' => 'Jeigu n�ra nieko pasirinkta, tai �ioje grup�je n�ra nustatyt� leidim� (klientui triktys bus nepasiekiamos).',
        'Search Result:' => 'Paie�kos rezultatas:',
        'Customers' => 'Klientai',
        'Groups' => 'Grup�s',
        'No matches found.' => 'Nerasta atitikmen�.',
        'Change Group Relations for Customer' => 'Pakeisti klientui grup�s s�sajas(ry�ius)',
        'Change Customer Relations for Group' => 'Pakeisti grupei kliento s�sajas(ry�ius)',
        'Toggle %s Permission for all' => '�jungti %s leidim� visiems',
        'Toggle %s permission for %s' => '�jungti %s leidim� %s',
        'Customer Default Groups:' => 'Standartin�s klient� grup�s:',
        'No changes can be made to these groups.' => '�ioms grup�ms negalima atlikti joki� pakeitim�.',
        'ro' => 'ro',
        'Read only access to the ticket in this group/queue.' => 'Tik skaitymo teis�s trik�iai �ioje grup�je/eil�je.',
        'rw' => 'rw',
        'Full read and write access to the tickets in this group/queue.' => 'Pilnos skaitymo ir ra�ymo teis�s trik�iai �ioje grup�je/eil�je.',

        # Template: AdminCustomerUserService
        'Manage Customer-Services Relations' => 'Valdyti klientas-servisas s�sajas',
        'Edit default services' => 'Redaguoti standartinius servisus',
        'Filter for Services' => 'Filtruoti paslaugas',
        'Allocate Services to Customer' => 'Priskirti servisus klientams',
        'Allocate Customers to Service' => 'Priskirti klientus servisams',
        'Toggle active state for all' => 'Perjungti visiems aktyvi� b�sen�',
        'Active' => 'Aktyvus',
        'Toggle active state for %s' => 'Perjungti %s aktyvi� b�sen�',

        # Template: AdminDynamicField
        'Dynamic Fields Management' => '',
        'Add new field for object' => '',
        'To add a new field, select the field type form one of the object\'s list, the object defines the boundary of the field and it can\'t be changed after the field creation.' => '',
        'Dynamic Fields List' => '',
        'Dynamic fields per page' => '',
        'Label' => '',
        'Order' => '',
        'Object' => 'Objektas',

        # Template: AdminDynamicFieldCheckbox
        'Dynamic Fields' => '',
        'Field' => '',
        'Go back to overview' => '',
        'General' => '',
        'This field is required, and the value should be alphabetic and numeric characters only.' => '',
        'Must be unique and only accept alphabetic and numeric characters.' => '',
        'Changing this value will require manual changes in the system.' => '',
        'This is the name to be shown on the screens where the field is active.' => '',
        'Field order' => '',
        'This field is required and must be numeric.' => '',
        'This is the order in which this field will be shown on the screens where is active.' => '',
        'Field type' => '',
        'Object type' => '',
        'Field Settings' => '',
        'Default value' => 'Standartin� reik�m�',
        'This is the default value for this field.' => '',
        'Save' => 'I�saugoti',

        # Template: AdminDynamicFieldDateTime
        'Default date difference' => '',
        'This field must be numeric.' => '',
        'The difference from NOW (in seconds) to calculate the field default value (e.g. 3600 or -60).' => '',
        'Define years period' => '',
        'Activate this feature to define a fixed range of years (in the future and in the past) to be displayed on the year part of the field.' => '',
        'Years in the future' => '',
        'Years in the future to display (default: 5 years).' => '',
        'Years in the past' => '',
        'Years in the past to display (default: 5 years).' => '',
        'Show link' => '',
        'Here you can specify an optional HTTP link for the field value in Overviews and Zoom screens.' => '',

        # Template: AdminDynamicFieldDropdown
        'Possible values' => '',
        'Key' => 'Raktas',
        'Value' => 'Reik�m�',
        'Remove value' => '',
        'Add value' => '',
        'Add Value' => '',
        'Allow empty value' => '',
        'Activate this option to create an empty selectable value.' => '',
        'Translatable values' => '',
        'If you activate this option the values will be translated to the user defined language.' => '',
        'Note' => 'Pastaba',
        'You need to add the translations manually into the language translation files.' => '',

        # Template: AdminDynamicFieldMultiselect

        # Template: AdminDynamicFieldText
        'Number of rows' => '',
        'Specify the height (in lines) for this field in the edit mode.' => '',
        'Number of cols' => '',
        'Specify the width (in characters) for this field in the edit mode.' => '',

        # Template: AdminEmail
        'Admin Notification' => 'Admin. prane�imas',
        'With this module, administrators can send messages to agents, group or role members.' => '�io modulio pagalba administratoriai gali si�sti �inutes agentams, grup�ms ar roli� nariams.',
        'Create Administrative Message' => 'Sukurti administracin� �inut�',
        'Your message was sent to' => 'J�s� �inut� buvo i�si�sta',
        'Send message to users' => 'Si�sti �inut� naudotojams',
        'Send message to group members' => 'Si�sti �inut� grup�s nariams',
        'Group members need to have permission' => 'Grup�s nariai turi tur�ti leidim�',
        'Send message to role members' => 'Si�sti �inut� rol�s nariams',
        'Also send to customers in groups' => 'Taip pat si�sti ir klientams grup�se',
        'Body' => 'Tekstas',
        'Send' => 'Si�sti',

        # Template: AdminGenericAgent
        'Generic Agent' => 'Bendrinis agentas (Generic Agent)',
        'Add job' => 'Prid�ti agent�',
        'Last run' => 'Paskutinis paleidimas',
        'Run Now!' => 'Paleisti dabar!',
        'Delete this task' => 'I�trinti �i� u�duot�',
        'Run this task' => 'Vykdyti �i� u�duoti',
        'Job Settings' => 'U�duoties nustatymai',
        'Job name' => 'U�duoties pavadinimas',
        'Currently this generic agent job will not run automatically.' => '�iuo metu �i bendrinio agento (generic agent) u�duotis nebus vykdoma.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Nor�dami �jungti automatin� u�duo�i� paleidim� turite pasirinkti bent vien� reik�m� i� minu�i�, valand� ir dien�!',
        'Schedule minutes' => '',
        'Schedule hours' => '',
        'Schedule days' => '',
        'Toggle this widget' => '�jungti/i�jungti �� valdikl�',
        'Ticket Filter' => 'Trik�i� filtras',
        '(e. g. 10*5155 or 105658*)' => 'pvz. 10*5144 arba 105658*',
        '(e. g. 234321)' => 'pvz. 234321',
        'Customer login' => 'Kliento prisijungimas',
        '(e. g. U5150)' => 'pvz. U5150',
        'Fulltext-search in article (e. g. "Mar*in" or "Baue*").' => 'Pilno teksto paie�ka straipsnyje (pvz. "Mar*in" oder "Baue*").',
        'Agent' => 'Agentas',
        'Ticket lock' => 'Trik�i� u�raktas',
        'Create times' => 'Suk�rimo datos',
        'No create time settings.' => '',
        'Ticket created' => 'Triktis sukurta',
        'Ticket created between' => 'Triktis sukurta tarp',
        'Change times' => '',
        'No change time settings.' => '',
        'Ticket changed' => '',
        'Ticket changed between' => '',
        'Close times' => 'U�darymo datos',
        'No close time settings.' => '',
        'Ticket closed' => 'Triktis u�daryta',
        'Ticket closed between' => 'Triktis u�daryta tarp',
        'Pending times' => '',
        'No pending time settings.' => '',
        'Ticket pending time reached' => '',
        'Ticket pending time reached between' => '',
        'Escalation times' => 'Eskalavimo datos',
        'No escalation time settings.' => '',
        'Ticket escalation time reached' => '',
        'Ticket escalation time reached between' => '',
        'Escalation - first response time' => 'Eskalavimas - pirmo atsakymo laikas',
        'Ticket first response time reached' => '',
        'Ticket first response time reached between' => '',
        'Escalation - update time' => 'Eskalavimas - atnaujinimo laikas',
        'Ticket update time reached' => '',
        'Ticket update time reached between' => '',
        'Escalation - solution time' => 'Eskalavimas - i�sprendimo laikas',
        'Ticket solution time reached' => '',
        'Ticket solution time reached between' => '',
        'Archive search option' => 'Paie�ka archyve',
        'Ticket Action' => 'Trikties veiksmas',
        'Set new service' => 'Nustatyti nauj� paslaug�',
        'Set new Service Level Agreement' => 'Nustatyti nauj� paslaugos lygio sutart� (SLA)',
        'Set new priority' => 'Nustatyti nauj� prioritet�',
        'Set new queue' => 'Nustatyti nauj� eil�',
        'Set new state' => 'Nustatyti nauj� b�sen�',
        'Set new agent' => 'Priskirti nauj� agent�',
        'new owner' => 'naujas savininkas',
        'new responsible' => '',
        'Set new ticket lock' => '',
        'New customer' => 'Naujas klientas',
        'New customer ID' => 'Naujo kliento ID',
        'New title' => 'Naujas pavadinimas',
        'New type' => 'Naujas tipas',
        'New Dynamic Fields' => '',
        'Archive selected tickets' => 'Archyvuoti pasirinktas triktis',
        'Add Note' => 'Prid�ti pastab�',
        'Time units' => 'Laiko vienetai',
        ' (work units)' => '',
        'Ticket Commands' => 'Trik�i� komandos',
        'Send agent/customer notifications on changes' => '�vykus pasikeitimams si�sti persp�jimus agentams/klientams',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '�i komanda bus �vykdyta. ARG[0] bus trikties numeris, ARG[1] - trikties ID',
        'Delete tickets' => 'I�trinti triktis',
        'Warning: All affected tickets will be removed from the database and cannot be restored!' => '�SP�JIMAS: visos paveiktos triktys bus pa�alintos i� duomen� baz�s ir bus nebe atstatomos.',
        'Execute Custom Module' => 'Vykdyti pasirinktin�/nestandartin� (custom) modul�',
        'Param %s key' => 'Parametro %s raktas',
        'Param %s value' => 'Parametro %s reik�m�',
        'Save Changes' => 'I�saugoti pakeitimus',
        'Results' => 'Rezultatai',
        '%s Tickets affected! What do you want to do?' => '%s paveiktos triktys! K� norite daryti?',
        'Warning: You used the DELETE option. All deleted tickets will be lost!' => '�SP�JIMAS: Pasirinkote I�TRINTI. I�trintos triktys bus prarastos visam laikui!',
        'Edit job' => 'Redaguoti darb�',
        'Run job' => 'Vykdyti darb�',
        'Affected Tickets' => 'Paveiktos triktys',
        '","30' => '',

        # Template: AdminGenericInterfaceDebugger
        'GenericInterface Debugger for Web Service %s' => '',
        'Web Services' => '',
        'Debugger' => '',
        'Go back to web service' => '',
        'Clear' => '',
        'Do you really want to clear the debug log of this web service?' => '',
        'Request List' => '',
        'Time' => 'Laikas',
        'Remote IP' => '',
        'Loading' => '',
        'Select a single request to see its details.' => '',
        'Filter by type' => '',
        'Filter from' => '',
        'Filter to' => '',
        'Filter by remote IP' => '',
        'Refresh' => '',
        'Request Details' => '',
        'An error occurred during communication.' => '',
        'Show or hide the content' => 'Sl�pti arba rodyti turin�',
        'Clear debug log' => '',

        # Template: AdminGenericInterfaceInvokerDefault
        'Add new Invoker to Web Service %s' => '',
        'Change Invoker %s of Web Service %s' => '',
        'Add new invoker' => '',
        'Change invoker %s' => '',
        'Do you really want to delete this invoker?' => '',
        'All configuration data will be lost.' => '',
        'Invoker Details' => '',
        'The name is typically used to call up an operation of a remote web service.' => '',
        'Please provide a unique name for this web service invoker.' => '',
        'The name you entered already exists.' => '',
        'Invoker backend' => '',
        'This OTRS invoker backend module will be called to prepare the data to be sent to the remote system, and to process it\'s response data.' => '',
        'Mapping for outgoing request data' => '',
        'Configure' => '',
        'The data from the invoker of OTRS will be processed by this mapping, to transform it to the kind of data the remote system expects.' => '',
        'Mapping for incoming response data' => '',
        'The response data will be processed by this mapping, to transform it to the kind of data the invoker of OTRS expects.' => '',
        'Event Triggers' => '',
        'Asynchronous' => '',
        'Delete this event' => '',
        'This invoker will be triggered by the configured events.' => '',
        'Do you really want to delete this event trigger?' => '',
        'Add Event Trigger' => '',
        'To add a new event select the event object and event name and click on the "+" button' => '',
        'Asynchronous event triggers are handled by the OTRS Scheduler in background (recommended).' => '',
        'Synchronous event triggers would be processed directly during the web request.' => '',
        'Save and continue' => '',
        'Save and finish' => '',
        'Delete this Invoker' => '',
        'Delete this Event Trigger' => '',

        # Template: AdminGenericInterfaceMappingSimple
        'GenericInterface Mapping Simple for Web Service %s' => '',
        'Go back to' => '',
        'Mapping Simple' => '',
        'Default rule for unmapped keys' => '',
        'This rule will apply for all keys with no mapping rule.' => '',
        'Default rule for unmapped values' => '',
        'This rule will apply for all values with no mapping rule.' => '',
        'New key map' => '',
        'Add key mapping' => '',
        'Mapping for Key ' => '',
        'Remove key mapping' => '',
        'Key mapping' => '',
        'Map key' => '',
        'matching the' => '',
        'to new key' => '',
        'Value mapping' => '',
        'Map value' => '',
        'to new value' => '',
        'Remove value mapping' => '',
        'New value map' => '',
        'Add value mapping' => '',
        'Do you really want to delete this key mapping?' => '',
        'Delete this Key Mapping' => '',

        # Template: AdminGenericInterfaceOperationDefault
        'Add new Operation to Web Service %s' => '',
        'Change Operation %s of Web Service %s' => '',
        'Add new operation' => '',
        'Change operation %s' => '',
        'Do you really want to delete this operation?' => '',
        'Operation Details' => '',
        'The name is typically used to call up this web service operation from a remote system.' => '',
        'Please provide a unique name for this web service.' => '',
        'Mapping for incoming request data' => '',
        'The request data will be processed by this mapping, to transform it to the kind of data OTRS expects.' => '',
        'Operation backend' => '',
        'This OTRS operation backend module will be called internally to process the request, generating data for the response.' => '',
        'Mapping for outgoing response data' => '',
        'The response data will be processed by this mapping, to transform it to the kind of data the remote system expects.' => '',
        'Delete this Operation' => '',

        # Template: AdminGenericInterfaceTransportHTTPSOAP
        'GenericInterface Transport HTTP::SOAP for Web Service %s' => '',
        'Network transport' => '',
        'Properties' => '',
        'Endpoint' => '',
        'URI to indicate a specific location for accessing a service.' => '',
        'e.g. http://local.otrs.com:8000/Webservice/Example' => '',
        'Namespace' => '',
        'URI to give SOAP methods a context, reducing ambiguities.' => '',
        'e.g urn:otrs-com:soap:functions or http://www.otrs.com/GenericInterface/actions' => '',
        'Maximum message length' => '',
        'This field should be an integer number.' => '',
        'Here you can specify the maximum size (in bytes) of SOAP messages that OTRS will process.' => '',
        'Encoding' => '',
        'The character encoding for the SOAP message contents.' => '',
        'e.g utf-8, latin1, iso-8859-1, cp1250, Etc.' => '',
        'SOAPAction' => '',
        'Set to "Yes" to send a filled SOAPAction header.' => '',
        'Set to "No" to send an empty SOAPAction header.' => '',
        'SOAPAction separator' => '',
        'Character to use as separator between name space and SOAP method.' => '',
        'Usually .Net web services uses a "/" as separator.' => '',
        'Authentication' => '',
        'The authentication mechanism to access the remote system.' => '',
        'A "-" value means no authentication.' => '',
        'The user name to be used to access the remote system.' => '',
        'The password for the privileged user.' => '',

        # Template: AdminGenericInterfaceWebservice
        'GenericInterface Web Service Management' => '',
        'Add web service' => '',
        'Clone web service' => '',
        'The name must be unique.' => '',
        'Clone' => '',
        'Export web service' => '',
        'Import web service' => '',
        'Configuration File' => '',
        'The file must be a valid web service configuration YAML file.' => '',
        'Import' => 'Importuoti',
        'Configuration history' => '',
        'Delete web service' => '',
        'Do you really want to delete this web service?' => '',
        'After you save the configuration you will be redirected again to the edit screen.' => '',
        'If you want to return to overview please click the "Go to overview" button.' => '',
        'Web Service List' => '',
        'Remote system' => '',
        'Provider transport' => '',
        'Requester transport' => '',
        'Details' => '',
        'Debug threshold' => '',
        'In provider mode, OTRS offers web services which are used by remote systems.' => '',
        'In requester mode, OTRS uses web services of remote systems.' => '',
        'Operations are individual system functions which remote systems can request.' => '',
        'Invokers prepare data for a request on a remote web service, and process it\'s response data.' => '',
        'Controller' => '',
        'Inbound mapping' => '',
        'Outbound mapping' => '',
        'Delete this action' => '',
        'At least one %s has a controller that is either not active or not present, please check the controller registration or delete the %s' => '',
        'Delete webservice' => '',
        'Delete operation' => '',
        'Delete invoker' => '',
        'Clone webservice' => '',
        'Import webservice' => '',

        # Template: AdminGenericInterfaceWebserviceHistory
        'GenericInterface Configuration History for Web Service %s' => '',
        'Go back to Web Service' => '',
        'Here you can view older versions of the current web service\'s configuration, export or even restore them.' => '',
        'Configuration History List' => '',
        'Version' => 'Versija',
        'Create time' => '',
        'Select a single configuration version to see its details.' => '',
        'Export web service configuration' => '',
        'Restore web service configuration' => '',
        'Do you really want to restore this version of the web service configuration?' => '',
        'Your current web service configuration will be overwritten.' => '',
        'Show or hide the content.' => '',
        'Restore' => '',

        # Template: AdminGroup
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' => '�SP�JIMAS: Pervadinant grup� \'admin\' prie� atlikant atitinkamus veiksmus \'SysConfig\' b�site u�rakintas nuo administravimo skydelio! Jei tai atsitikt�, panaudodami SQL u�klaus�, atkeiskite grup�s pavadinim� atgal � \'admin\'',
        'Group Management' => 'Grup�s valdymas',
        'Add group' => 'Prid�ti grup�',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '\'admin\' grup� yra skirta patekti � administratori� zon�, o \'stats\' grup� - � statistikos zon�',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...). ' => 'Sukurkite naujas grupes skirting� agent� grupi� leidimams suvaldyti (pvz. pirkim� skyrius, palaikymo skyrius, pardavim� skyrius, ...).',
        'It\'s useful for ASP solutions. ' => 'Tai yra naudinga ASP sprendimams.',
        'Add Group' => 'Prid�ti grup�',
        'Edit Group' => 'Redaguoti grup�',

        # Template: AdminLog
        'System Log' => 'Sistemos �urnalas',
        'Here you will find log information about your system.' => '�ia rasite �urnal� informacij� apie J�s� sistem�.',
        'Hide this message' => 'Sl�pti �i� �inut�',
        'Recent Log Entries' => 'Naujausi �urnalo �ra�ai',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Pa�to paskyros valdymas',
        'Add mail account' => 'Prid�ti pa�to paskyr�',
        'All incoming emails with one account will be dispatched in the selected queue!' => '',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',
        'Host' => 'Serveris',
        'Delete account' => 'I�trinti paskyr�',
        'Fetch mail' => 'Gauti (parsi�sti) lai�kus',
        'Add Mail Account' => 'Prid�ti el. pa�to paskyr�',
        'Example: mail.example.com' => 'Pavyzd�iui : mail.example.com',
        'IMAP Folder' => '',
        'Only modify this if you need to fetch mail from a different folder than INBOX.' => '',
        'Trusted' => 'Patikimas',
        'Dispatching' => 'I�skirstymas',
        'Edit Mail Account' => 'Redaguoti pa�to paskyr�',

        # Template: AdminNavigationBar
        'Admin' => 'Admin',
        'Agent Management' => 'Agent� valdymas',
        'Queue Settings' => 'Eili� nustatymai',
        'Ticket Settings' => 'Trik�i� nustatymai',
        'System Administration' => 'Sistemos administravimas',

        # Template: AdminNotification
        'Notification Management' => 'Prane�im� valdymas',
        'Select a different language' => 'Pasirinkite kit� kalb�',
        'Filter for Notification' => 'Filtruoti prane�imus',
        'Notifications are sent to an agent or a customer.' => 'Prane�imai yra siun�iami agentui arba klientui.',
        'Notification' => 'Prane�imas',
        'Edit Notification' => 'Redaguoti prane�imus',
        'e. g.' => 'pvz.',
        'Options of the current customer data' => 'Esam� klient� duomen� parinktys',

        # Template: AdminNotificationEvent
        'Add notification' => 'Prid�ti prane�im�',
        'Delete this notification' => 'I�trinti �� prane�im�',
        'Add Notification' => 'Prid�ti prane�im�',
        'Recipient groups' => 'Gaunan�ios grup�s',
        'Recipient agents' => 'Gaunantys agentai',
        'Recipient roles' => 'Gaunan�ios rol�s',
        'Recipient email addresses' => 'Gav�jo el. pa�to adresas',
        'Article type' => 'Straipsnio tipas',
        'Only for ArticleCreate event' => 'Tik straipsnio suk�rimo �vykiui',
        'Subject match' => 'Tema atitinka',
        'Body match' => 'Turinys atitinka',
        'Include attachments to notification' => '�traukti priedus � prane�imus',
        'Notification article type' => 'Prane�imo straipsnio tipas',
        'Only for notifications to specified email addresses' => 'Tik prane�imams � nurodytus el. pa�to adresus',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Gauti pirmus 20 temos simboli� (paskutinio agento straipsnio)',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Gauti pirmas 5 turinio eilutes (paskutinio agento straipsnio)',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Gauti pirmus 20 temos simboli� (paskutinio kliento straipsnio)',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Gauti pirmas 5 turinio eilutes (paskutinio kliento straipsnio)',

        # Template: AdminPGP
        'PGP Management' => 'PGP valdymas',
        'Use this feature if you want to work with PGP keys.' => 'Naudokite �i� ypatyb� jei norite dirbti su PGP raktais.',
        'Add PGP key' => 'Prid�ti PGP rakt�',
        'In this way you can directly edit the keyring configured in SysConfig.' => '�iuo b�du galite tiesiogiai valdyti SysConfig sukonfig�ruot� "rakt� ry�ul�".',
        'Introduction to PGP' => '�vadas � PGP',
        'Result' => 'Rezultatas',
        'Identifier' => 'Identifikatorius',
        'Bit' => 'Bitai',
        'Fingerprint' => 'Pir�to atspaudas',
        'Expires' => 'Galiojimo laikas baigiasi',
        'Delete this key' => 'Trinti �� rakt�',
        'Add PGP Key' => 'Prid�ti PGP Rakt�',
        'PGP key' => 'PGP raktas',

        # Template: AdminPackageManager
        'Package Manager' => 'Paket� valdymas',
        'Uninstall package' => 'Pa�alinti paket�',
        'Do you really want to uninstall this package?' => 'Ar tikrai norite pa�alinti � paket�?',
        'Reinstall package' => 'I� naujo �diegti paket�',
        'Do you really want to reinstall this package? Any manual changes will be lost.' => 'Ar tikrai norite i� naujo �diegti �� paket�? Bet kokie atlikti rankiniai pakeitimai bus prarasti.',
        'Continue' => 'T�sti',
        'Install' => '�diegti',
        'Install Package' => '�diegti paket�',
        'Update repository information' => 'Atnaujinti saugyklos informacij�',
        'Did not find a required feature? OTRS Group provides their subscription customers with exclusive Add-Ons:' => '',
        'Online Repository' => 'Prieinamos (�jungtos) saugyklos',
        'Vendor' => 'Tiek�jas/pardav�jas',
        'Module documentation' => 'Modulio dokumentacija',
        'Upgrade' => 'Atnaujinti versij�',
        'Local Repository' => 'Vietin� saugykla',
        'Uninstall' => 'Pa�alinti',
        'Reinstall' => '�diegti i� naujo',
        'Download package' => 'Parsisi�sti paket�',
        'Rebuild package' => 'I� naujo surinkti paket� (rebuild)',
        'Metadata' => 'Meta-duomenys',
        'Change Log' => 'Pakeitim� �urnalas',
        'Date' => 'Data',
        'List of Files' => 'Fail� s�ra�as',
        'Permission' => 'Leidimas',
        'Download' => 'Parsi�sti',
        'Download file from package!' => 'Parsi�sti fail� i� paketo!',
        'Required' => 'Reikalaujama',
        'PrimaryKey' => '',
        'AutoIncrement' => '',
        'SQL' => 'SQL',
        'File differences for file %s' => 'Skirtumai tarp fail� %s',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Sistemos na�umo �urnalas',
        'This feature is enabled!' => '�i ypatyb� aktyvuota!',
        'Just use this feature if you want to log each request.' => '�junkite �i� ypatyb� tik tuo atveju jeigu norite registruoti visas u�klausas.',
        'Activating this feature might affect your system performance!' => '�ios ypatyb�s aktyvavimas gali paveikti J�s� sistemos na�um�.',
        'Disable it here!' => 'I�jungti �ia!',
        'Logfile too large!' => 'Registravimo �urnalas per didelis!',
        'The logfile is too large, you need to reset it' => 'Registravimo �urnalas per didelis. Tur�tum�te j� anuliuoti.',
        'Overview' => 'Ap�valga',
        'Range' => 'Diapazonas',
        'Interface' => 'S�saja',
        'Requests' => 'U�klausos',
        'Min Response' => 'Ma�iausias atsako laikas',
        'Max Response' => 'Did�iausias atsako laikas',
        'Average Response' => 'Vidutinis atsako laikas',
        'Period' => 'Laiko tarpas',
        'Min' => 'Min',
        'Max' => 'Maks',
        'Average' => 'Vidurkis',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'PostMaster filtr� valdymas',
        'Add filter' => 'Prid�ti filtr�',
        'To dispatch or filter incoming emails based on email headers. Matching using Regular Expressions is also possible.' => 'I�skirstyti ar filtruoti el. lai�kus pagal el. lai�k� antra�tes. Taip pat galima naudoti ir reguliarias i�rai�kas',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Jeigu norite nustatyti atitikmen� tik vienam el. pa�to adresui, tai Nuo, Kam ir Cc laukeliuose naudokite EMAILADDRESS:info@example.com.',
        'If you use Regular Expressions, you also can use the matched value in () as [***] in the \'Set\' action.' => '',
        'Delete this filter' => 'I�trinti �� filtr�',
        'Add PostMaster Filter' => 'Prid�ti PostMaster filtr�',
        'Edit PostMaster Filter' => 'Redaguoti PostMaster filtr�',
        'Filter name' => 'Filtro pavadinimas',
        'The name is required.' => '',
        'Stop after match' => 'Radus atitikmen� sustoti',
        'Filter Condition' => 'Filtro s�lyga',
        'The field needs to be a valid regular expression or a literal word.' => '',
        'Set Email Headers' => 'Nustatyti el. pa�to antra�tes',
        'The field needs to be a literal word.' => '',

        # Template: AdminPriority
        'Priority Management' => 'Prioritet� valdymas',
        'Add priority' => 'Prid�ti prioritet�',
        'Add Priority' => 'Prid�ti prioritet�',
        'Edit Priority' => 'Redaguoti prioritet�',

        # Template: AdminQueue
        'Manage Queues' => 'Valdyti eiles',
        'Add queue' => 'Prid�ti eil�',
        'Add Queue' => 'Prid�to eil�',
        'Edit Queue' => 'Redaguoti eil�',
        'Sub-queue of' => 'Poeilis',
        'Unlock timeout' => '',
        '0 = no unlock' => 'neatrakinti',
        'Only business hours are counted.' => 'Skai�iuojamos tik darbo valandos.',
        'If an agent locks a ticket and does not close it before the unlock timeout has passed, the ticket will unlock and will become available for other agents.' => 'Jeigu agentas u�rakins trikt� ir neu�darys jos iki pasibaigs atrakinimo laikas (unlock timeout), tai ji atsirakins ir taps prieinama kitiems agentams.',
        'Notify by' => 'Prane�ti per',
        '0 = no escalation' => '0 = neeskaluoti',
        'If there is not added a customer contact, either email-external or phone, to a new ticket before the time defined here expires, the ticket is escalated.' => 'Jeigu naujai trik�iai nebus prid�ti kliento kontaktai (i�orinis el. pa�tas ar telefono numeris), iki pasibaigiant �ia nurodytam laikui, tai triktis bus eskaluota.',
        'If there is an article added, such as a follow-up via email or the customer portal, the escalation update time is reset. If there is no customer contact, either email-external or phone, added to a ticket before the time defined here expires, the ticket is escalated.' => 'Jeigu trik�iai bus prid�tas naujas straipsnis, pvz., atsakymas per i�orin� el. pa�t� arba klient� portal�, tai eskalavimo atnaujinimo laikas yra atstatomas atgal. Jeigu trik�iai nebus prid�ti kliento kontaktai (i�orinis el. pa�tas ar telefono numeris), iki pasibaigiant �ia nurodytam laikui, tai triktis bus eskaluota.',
        'If the ticket is not set to closed before the time defined here expires, the ticket is escalated.' => 'Jeigu triktis nebus ir neu�daryta iki pasibaigs �ia nurodytas laikas, tai ji bus eskaluota.',
        'Follow up Option' => '',
        'Specifies if follow up to closed tickets would re-open the ticket, be rejected or lead to a new ticket.' => 'Nurodo ar tolimesni veiksmai su jau u�daryta triktimi: j� i� naujo atidaryt�, atmest� bet kokius tolimesnius veiksmus, sukurt� nauj� trikt�.',
        'Ticket lock after a follow up' => 'U�rakinti trikt� po bet kokio atsakymo ar kontakto',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked to the old owner.' => 'Jeigu triktis yra u�daryta ir klientas v�l k� nors atsiun�ia - triktis bus prirakinta prie senojo savininko.',
        'System address' => 'Sistemos adresas',
        'Will be the sender address of this queue for email answers.' => 'Bus �ios eil�s siun�iam� atsakym� siunt�jo adresas.',
        'Default sign key' => 'Standartinis pasira�ymo raktas',
        'The salutation for email answers.' => 'Kreipimosi forma el. pa�to atsakymuose.',
        'The signature for email answers.' => 'El. pa�to atsakym� para�as.',

        # Template: AdminQueueAutoResponse
        'Manage Queue-Auto Response Relations' => 'Valdyti eili� - automatini� atsakym� ry�ius',
        'Filter for Queues' => 'Filtruoti eiles',
        'Filter for Auto Responses' => 'Filtruoti auto. atsakymus',
        'Auto Responses' => 'Automatiniai atsakymai',
        'Change Auto Response Relations for Queue' => 'Keisti eilei automatini� atsakym� s�sajas',
        'settings' => 'nustatymai',

        # Template: AdminQueueResponses
        'Manage Response-Queue Relations' => 'Valdyti atsakym�-eili� ry�ius',
        'Filter' => 'Filtras',
        'Filter for Responses' => 'Filtruoti atsakymus',
        'Responses' => 'Atsakymai',
        'Change Queue Relations for Response' => 'Keisti eili� ry�ius atsakymui',
        'Change Response Relations for Queue' => 'Keisti atsakym� ry�ius eilei',

        # Template: AdminResponse
        'Manage Responses' => 'Valdyti atsakymus',
        'Add response' => 'Prid�ti atsakym�',
        'A response is default text to write faster answer (with default text) to customers.' => 'Atsakymas yra standartinis tekstas skirtas greitesniems atsakymams klientams ra�yti.',
        'Don\'t forget to add a new response a queue!' => 'Nepamir�kite kiekvienai eilei prid�ti po atsakym�!',
        'Delete this entry' => 'I�trinti �� �ra��',
        'Add Response' => 'Prid�ti atsakym�',
        'Edit Response' => 'Redaguoti atsakym�',
        'The current ticket state is' => 'Dabartin� trikties b�sena yra',
        'Your email address is' => 'J�s� el. pa�to adresas yra',

        # Template: AdminResponseAttachment
        'Manage Responses <-> Attachments Relations' => 'Valdyti Atsakymai <-> Priedai ry�ius',
        'Filter for Attachments' => 'Filtruoti priedus',
        'Change Response Relations for Attachment' => 'Keisti atsakym� ry�ius priedui',
        'Change Attachment Relations for Response' => 'Keisti pried� ry�ius atsakymui',
        'Toggle active for all' => 'Perjungti vis� aktyvavim�',
        'Link %s to selected %s' => 'Prijungti %s prie pasirinkto %s',

        # Template: AdminRole
        'Role Management' => 'Roli� valdymas',
        'Add role' => 'Prid�ti rol�',
        'Create a role and put groups in it. Then add the role to the users.' => 'Sukurkite rol�, o tada �d�kite � j� grupes. Tada priskirkite roles naudotojams.',
        'There are no roles defined. Please use the \'Add\' button to create a new role.' => 'N�ra apibr��t� roli�. Pra�ome paspausti mygtuk� "Prid�ti" naujoms rol�s sukurti.',
        'Add Role' => 'Prid�ti Rol�',
        'Edit Role' => 'Redaguoti rol�',

        # Template: AdminRoleGroup
        'Manage Role-Group Relations' => 'Valdyti Rol�-Grup� ry�ius',
        'Filter for Roles' => 'Filtruoti roles',
        'Roles' => 'Rol�s',
        'Select the role:group permissions.' => 'Pasirinkite rol�:grup� leidimus.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the role).' => 'Jeigu n�ra nieko pasirinkta, tai �ioje grup�je n�ra nustatyt� leidim� (rolei triktys bus neprieinamos).',
        'Change Role Relations for Group' => 'Keisti roli� ry�ius grupei',
        'Change Group Relations for Role' => 'Keisti grupi� ry�ius rolei',
        'Toggle %s permission for all' => 'Perjungti visiems %s leidim�',
        'move_into' => 'Perkelti �',
        'Permissions to move tickets into this group/queue.' => 'Leidimai perkelti triktis � �i� grup�/eil�.',
        'create' => 'sukurti',
        'Permissions to create tickets in this group/queue.' => 'Leidimai kurti triktis �ioje grup�je/eil�je.',
        'priority' => 'prioritetas',
        'Permissions to change the ticket priority in this group/queue.' => 'Leidimai keisti trik�i� prioritetus �ioje grup�je/eil�je.',

        # Template: AdminRoleUser
        'Manage Agent-Role Relations' => 'Valdyti Agentas-Rol� ry�ius',
        'Filter for Agents' => 'Filtruoti agentus',
        'Agents' => 'Agentai',
        'Manage Role-Agent Relations' => 'Valdyti Rol�-Agentas ry�ius',
        'Change Role Relations for Agent' => 'Keisti roli� ry�ius agentui',
        'Change Agent Relations for Role' => 'Keisti agent� ry�ius rolei',

        # Template: AdminSLA
        'SLA Management' => 'SLA valdymas',
        'Add SLA' => 'Prid�ti SLA',
        'Edit SLA' => 'Redaguoti SLA',
        'Please write only numbers!' => 'Pra�ome ra�yti tik numerius!',

        # Template: AdminSMIME
        'S/MIME Management' => 'S/MIME valdymas',
        'Add certificate' => 'Prid�ti sertifikat�',
        'Add private key' => 'Prid�ti privat� rakt�',
        'Filter for certificates' => '',
        'Filter for SMIME certs' => '',
        'Here you can add relations to your private certificate, these will be embedded to the SMIME signature every time you use this certificate to sign an email.' => '',
        'See also' => 'Taip pat �i�r�kite',
        'In this way you can directly edit the certification and private keys in file system.' => '�iuo b�du galite tiesiogiai redaguoti sertifikatus ir priva�ius raktus sistemoje.',
        'Hash' => '',
        'Create' => 'Sukurti',
        'Handle related certificates' => '',
        'Delete this certificate' => 'I�trinti �� sertifikat�',
        'Add Certificate' => 'Prid�ti sertifikat�',
        'Add Private Key' => 'Prid�ti privat� rakt�',
        'Secret' => '',
        'Related Certificates for' => '',
        'Delete this relation' => '',
        'Available Certificates' => '',
        'Relate this certificate' => '',

        # Template: AdminSalutation
        'Salutation Management' => 'Kreipini� valdymas',
        'Add salutation' => 'Prid�ti kreipim�si',
        'Add Salutation' => 'Prid�ti kreipim�si',
        'Edit Salutation' => 'Redaguoti kreipim�si',
        'Example salutation' => 'Kreipimosi pavyzdys',

        # Template: AdminScheduler
        'This option will force Scheduler to start even if the process is still registered in the database' => '',
        'Start scheduler' => '',
        'Scheduler could not be started. Check if scheduler is not running and try it again with Force Start option' => '',

        # Template: AdminSecureMode
        'Secure mode needs to be enabled!' => 'Turi b�ti �jungtas saugus re�imas!',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Saugus re�imas, paprastai, yra nustatomas po pradinio �diegimo.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Norint �diegti i� naujo, naudojant web-diegykl�, saugus re�imas turi b�ti i�jungtas.',
        'If secure mode is not activated, activate it via SysConfig because your application is already running.' => '',

        # Template: AdminSelectBox
        'SQL Box' => 'SQL Box',
        'Here you can enter SQL to send it directly to the application database.' => '�ia galite �vesti ir tiesiogiai programos duomen� bazei nusi�sti SQL u�klausas.',
        'The syntax of your SQL query has a mistake. Please check it.' => 'J�s� SQL u�klausoje yra klaida. Pra�ome j� i�taisyti.',
        'There is at least one parameter missing for the binding. Please check it.' => '',
        'Result format' => 'Rezultato formatas',
        'Run Query' => 'Vykdyti u�duot�',

        # Template: AdminService
        'Service Management' => 'Paslaug� valdymas',
        'Add service' => 'Prid�ti paslaug�',
        'Add Service' => 'Prid�ti paslaug�',
        'Edit Service' => 'Redaguoti paslaug�',
        'Sub-service of' => 'Sub-paslauga',

        # Template: AdminSession
        'Session Management' => 'Sesij� valdymas',
        'All sessions' => 'Visos sesijos',
        'Agent sessions' => 'Agent� sesijos',
        'Customer sessions' => 'Klient� sesijos',
        'Unique agents' => 'Unikal�s agentai',
        'Unique customers' => 'Unikal�s klientai',
        'Kill all sessions' => 'Nutraukti visas sesijas',
        'Kill this session' => 'Nutraukti �i� sesij�',
        'Session' => 'Sesija',
        'Kill' => 'Nutraukti',
        'Detail View for SessionID' => 'Detali Sesijos ID per�i�ra',

        # Template: AdminSignature
        'Signature Management' => 'Para�� valdymas',
        'Add signature' => 'Prid�ti para��',
        'Add Signature' => 'Prid�ti para��',
        'Edit Signature' => 'Redaguoti para��',
        'Example signature' => 'Para�o pavyzdys',

        # Template: AdminState
        'State Management' => 'B�sen� valdymas',
        'Add state' => 'Prid�ti b�sen�',
        'Please also update the states in SysConfig where needed.' => '',
        'Add State' => 'Prid�ti b�sen�',
        'Edit State' => 'Redaguoti b�sen�',
        'State type' => 'B�senos tipas',

        # Template: AdminSysConfig
        'SysConfig' => 'SysConfig',
        'Navigate by searching in %s settings' => 'Nar�yti ie�kant %s nustatymuose',
        'Navigate by selecting config groups' => 'Nar�yti pasirenkant konfig�racijos grupes',
        'Download all system config changes' => 'Parsisi�sti visus sistemos konfig�racijos pakeitimus',
        'Export settings' => 'Eksportuoti nustatymus',
        'Load SysConfig settings from file' => 'U�krauti konfig�racij� i� failo',
        'Import settings' => 'Importuoti nustatymus',
        'Import Settings' => 'Importuoti nustatymus',
        'Please enter a search term to look for settings.' => 'Pra�ome �vesti paie�kos termin� nustatym� paie�kai.',
        'Subgroup' => 'Pogrupis',
        'Elements' => 'Elementai',

        # Template: AdminSysConfigEdit
        'Edit Config Settings' => 'Redaguoti konfig�racijos nustatymus',
        'This config item is only available in a higher config level!' => '�is konfig�racijos punktas yra prieinamas tik auk�tesniame konfig�racijos lygyje!',
        'Reset this setting' => 'Atstatyti �� nustatym�',
        'Error: this file could not be found.' => 'Klaida: �is failas nerastas.',
        'Error: this directory could not be found.' => 'Klaida: �i direktorija nerasta.',
        'Error: an invalid value was entered.' => 'Klaida: buvo �vesta netinkama reik�m�.',
        'Content' => 'Turinys',
        'Remove this entry' => 'Pa�alinti �� �ra��',
        'Add entry' => 'Prid�ti �ra��',
        'Remove entry' => 'Pa�alinti �ra��',
        'Add new entry' => 'Prid�ti nauj� �ra��',
        'Create new entry' => 'Sukurti nauj� �ra��',
        'New group' => 'Nauja grup�',
        'Group ro' => 'Ro grup�',
        'Readonly group' => 'Tik skaitymo grup�',
        'New group ro' => 'Nauja ro grup�',
        'Loader' => '�krov�jas(loader)',
        'File to load for this frontend module' => '�io s�sajos modulio u�krovimo failas',
        'New Loader File' => 'Naujas u�krovos failas',
        'NavBarName' => '',
        'NavBar' => '',
        'LinkOption' => '',
        'Block' => 'Blokuoti',
        'AccessKey' => '',
        'Add NavBar entry' => 'Prid�ti NavBar �ra��',
        'Year' => 'Metai',
        'Month' => 'M�nesis',
        'Day' => 'Diena',
        'Invalid year' => 'Negalimi metai',
        'Invalid month' => 'Negalimas m�nesis',
        'Invalid day' => 'Negalima diena',

        # Template: AdminSystemAddress
        'System Email Addresses Management' => 'Sistemos el. pa�to adres� valdymas',
        'Add system address' => 'Prid�ti sistemos adres�',
        'All incoming email with this address in To or Cc will be dispatched to the selected queue.' => 'Visas �einantis el. pa�tas, su tokiu (nurodytu) el. pa�to adresu Kam ir Kopija laukeliuose, bus nukreiptas � pasirinkt� eil�.',
        'Email address' => 'El. pa�to adresas',
        'Display name' => 'Rodomas vardas',
        'Add System Email Address' => 'Prid�ti sistemos el. pa�to adres�',
        'Edit System Email Address' => 'Redaguoti sistemos el. pa�to adres�',
        'The display name and email address will be shown on mail you send.' => 'Rodomas vardas ir el. pa�to adresas bus rodomas J�s� siun�iamuose lai�kuose.',

        # Template: AdminType
        'Type Management' => 'Tip� valdymas',
        'Add ticket type' => 'Prid�ti trikties tip�',
        'Add Type' => 'Prid�ti tip�',
        'Edit Type' => 'Redaguoti tip�',

        # Template: AdminUser
        'Add agent' => 'Prid�ti agent�',
        'Agents will be needed to handle tickets.' => 'Agentai bus reikalingi darbui su triktimis ir j� valdymu.',
        'Don\'t forget to add a new agent to groups and/or roles!' => 'Nepamir�kite nauj� agent� priskirti prie grupi� ir/ar roli�!',
        'Please enter a search term to look for agents.' => 'Pra�ome �vesti agent� paie�kos termin�.',
        'Last login' => 'Paskutinis prisijungimas',
        'Login as' => 'Prisijungti kaip',
        'Switch to agent' => 'Persijungti � agent�',
        'Add Agent' => 'Prid�ti agent�',
        'Edit Agent' => 'Redaguoti agent�',
        'Firstname' => 'Vardas',
        'Lastname' => 'Pavard�',
        'Password is required.' => '',
        'Start' => 'Prad�ia',
        'End' => 'Pabaiga',

        # Template: AdminUserGroup
        'Manage Agent-Group Relations' => 'Valdyti Agentas-Grup� ry�ius',
        'Change Group Relations for Agent' => 'Keisti grupi� ry�ius agentui',
        'Change Agent Relations for Group' => 'Keisti agent� ry�ius grupei',
        'note' => 'pastaba',
        'Permissions to add notes to tickets in this group/queue.' => 'Leidimai prid�ti pastabas triktims �ioje grup�je/eil�je.',
        'owner' => 'savininkas',
        'Permissions to change the owner of tickets in this group/queue.' => 'Leidimai keisti trik�i� savininkus �ioje grup�je/eil�je.',

        # Template: AgentBook
        'Address Book' => 'Adres� knyga',
        'Search for a customer' => 'Ie�koti kliento',
        'Add email address %s to the To field' => 'Prid�ti %s el. pa�to adres� prie laukelio Kam (To)',
        'Add email address %s to the Cc field' => 'Prid�ti %s el. pa�to adres� prie laukelio Kopija (Cc)',
        'Add email address %s to the Bcc field' => 'Prid�ti %s el. pa�to adres� prie laukelio Slapta kopija (Bcc)',
        'Apply' => 'Pritaikyti',

        # Template: AgentCustomerSearch
        'Search Customer' => 'Ie�koti kliento',

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Skydelis',

        # Template: AgentDashboardCalendarOverview
        'in' => 'in',

        # Template: AgentDashboardIFrame

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s jau prieinamas!',
        'Please update now.' => 'Pra�ome atnaujinti jau dabar.',
        'Release Note' => 'i�leidimo pastaba',
        'Level' => 'Lygis',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Paskelbtas prie� %s.',

        # Template: AgentDashboardTicketGeneric

        # Template: AgentDashboardTicketStats

        # Template: AgentDashboardUserOnline

        # Template: AgentHTMLReferenceForms

        # Template: AgentHTMLReferenceOverview

        # Template: AgentHTMLReferencePageLayout
        'The ticket has been locked' => 'Triktis buvo u�rakinta',
        'Undo & close window' => 'Atstatyti ir u�verti lang�',

        # Template: AgentInfo
        'Info' => 'Info.',
        'To accept some news, a license or some changes.' => 'Kai kuri� naujien� pri�mimui, licenzijai ar kai kuriems pakeitimams.',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Susietas objektas: %s',
        'Close window' => 'U�verti lang�',
        'go to link delete screen' => 'eiti � s�sajos trynimo ekran�',
        'Select Target Object' => 'Pasirinkite paskirties objekt�',
        'Link Object' => 'Susieti objekt�',
        'with' => 'su',
        'Unlink Object: %s' => 'Atsieti objekt�: %s',
        'go to link add screen' => 'eiti � s�sajos suk�rimo ekran�',

        # Template: AgentNavigationBar

        # Template: AgentPreferences
        'Edit your preferences' => 'Redaguoti savo nustatymus',

        # Template: AgentSpelling
        'Spell Checker' => 'Ra�ybos tikrintuvas',
        'spelling error(s)' => 'Ra�ybos klaida(-os)',
        'Apply these changes' => 'Pritaikyti �iuos pakeitimus',

        # Template: AgentStatsDelete
        'Delete stat' => 'I�trinti statistik�',
        'Stat#' => '',
        'Do you really want to delete this stat?' => 'Ar tikrai norite i�trinti �i� statistik�?',

        # Template: AgentStatsEditRestrictions
        'Step %s' => '�ingsnis %s',
        'General Specifications' => 'Bendrosios nuostatos',
        'Select the element that will be used at the X-axis' => 'Pasirinkite X a�iai naudojam� element�',
        'Select the elements for the value series' => 'Pasirinkite reik�m�ms naudojamus elementus',
        'Select the restrictions to characterize the stat' => 'Pasirinkite apribojimus statistikos charakterizavimui (apib�dinimui)',
        'Here you can make restrictions to your stat.' => '�ia galite apriboti savo statistik�.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Jeigu nuimsite varnel� nuo laukelio "Fiksuotas", tai agentas gal�s pakeisti kiekvieno atitinkamo elemento atributus.',
        'Fixed' => 'Fiksuotas',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Pra�ome pasirinkti tik vien� element� arba i�jungti "Fiksuotas"!',
        'Absolute Period' => 'Absoliutus laikotarpis',
        'Between' => 'Tarp',
        'Relative Period' => 'Reliatyvus laikotarpis',
        'The last' => 'Paskutinis',
        'Finish' => 'Baigti',

        # Template: AgentStatsEditSpecification
        'Permissions' => 'Leidimai',
        'You can select one or more groups to define access for different agents.' => 'Skirtingiems agentams apibr��ti galite pasirinkti vien� ar daugiau grupi�.',
        'Some result formats are disabled because at least one needed package is not installed.' => 'Dalis rezultat� format� yra i�jungti, nes ne�diegtas ma�iausiai vienas reikalingas paketas.',
        'Please contact your administrator.' => 'Pra�ome susisiekti su savo administratoriumi.',
        'Graph size' => 'Diagramos dydis',
        'If you use a graph as output format you have to select at least one graph size.' => 'Jei i�vedimo tipui naudosite diagram� - turite pasirinkti bent vien� diagramos dyd�.',
        'Sum rows' => 'Sumuoti eilutes',
        'Sum columns' => 'Sumuoti stulpelius',
        'Use cache' => 'Naudoti ke�� (cache)',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => 'Dauguma statistik� gali b�ti ke�uojama. Tai padidins �ios statistikos pateikim�.',
        'If set to invalid end users can not generate the stat.' => 'Jei nustatyta negaliojan�iu galutiniai naudotojai negal�s generuoti �ios statistikos.',

        # Template: AgentStatsEditValueSeries
        'Here you can define the value series.' => '�ia galite apibr��ti reik�mi� serijas.',
        'You have the possibility to select one or two elements.' => 'Turite galimyb� pasirinkti vien� ar daugiau element�.',
        'Then you can select the attributes of elements.' => 'Tada galite pasirinkti element� atributus.',
        'Each attribute will be shown as single value series.' => 'Kiekvienas atributas bus rodomas kaip atskira reik�mi� serija.',
        'If you don\'t select any attribute all attributes of the element will be used if you generate a stat, as well as new attributes which were added since the last configuration.' => '',
        'Scale' => 'Skal�',
        'minimal' => 'minimalus',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => 'Prisiminkite, kad reik�mi� serijos skal� turi b�ti didesn� u� X a�ies skal� (pvz., X-a�is => M�nesis, Reik�mi� Serija => Metai).',

        # Template: AgentStatsEditXaxis
        'Here you can define the x-axis. You can select one element via the radio button.' => '�ia galite apibr��ti X a��. Galite pasirinkti vien� element� pa�ym�dami "radijo mygtuk�" (radio button)',
        'maximal period' => 'maksimalus laikotarpis',
        'minimal scale' => 'minimali skal�',

        # Template: AgentStatsImport
        'Import Stat' => 'Importuoti statistik�',
        'File is not a Stats config' => 'Failas n�ra statistikos konfig�racija',
        'No File selected' => 'Nepasirinktas failas',

        # Template: AgentStatsOverview
        'Stats' => 'Statistika',

        # Template: AgentStatsPrint
        'Print' => 'Spausdinti',
        'No Element selected.' => 'Nepasirinktas joks elementas.',

        # Template: AgentStatsView
        'Export config' => 'Eksportuoti konfig�racij�',
        'With the input and select fields you can influence the format and contents of the statistic.' => 'Pasirinktais laukeliais ir �vestimi galite �takoti turinio ir statistikos format�.',
        'Exactly what fields and formats you can influence is defined by the statistic administrator.' => 'Kokius konkre�ius laukelius ir formatus galite �takoti yra numat�s statistikos administratorius.',
        'Stat Details' => 'Statistikos smulkmenos',
        'Format' => 'Formatas',
        'Graphsize' => 'Diagramos dydis',
        'Cache' => 'Ke�as',
        'Exchange Axis' => 'Apsikeitimo (exchange) a�is',
        'Configurable params of static stat' => 'Stati�kos statistikos konfig�ruojami parametrai',
        'No element selected.' => 'Nepasirinktas elementas.',
        'maximal period from' => 'maksimalus periodas nuo',
        'to' => 'iki',

        # Template: AgentTicketActionCommon
        'Change Free Text of Ticket' => 'Keisti trikties atvir�j� tekst�',
        'Change Owner of Ticket' => 'Keisti trikties savinink�',
        'Close Ticket' => 'U�daryti trikt�',
        'Add Note to Ticket' => 'Prid�ti pastab� trik�iai',
        'Set Pending' => 'Nustatyti kaip laukian�i�',
        'Change Priority of Ticket' => 'Keisti trikties prioritet�',
        'Change Responsible of Ticket' => 'Keisti atsaking� u� trikt�',
        'Cancel & close window' => 'At�aukti ir u�verti lang�',
        'Service invalid.' => 'Paslauga negalima',
        'New Owner' => 'Naujas savininkas',
        'Please set a new owner!' => 'Pra�ome nustatyti nauj� savinink�',
        'Previous Owner' => 'Buv�s savininkas',
        'Inform Agent' => 'Informuoti agent�',
        'Optional' => 'Neb�tinas',
        'Inform involved Agents' => 'Informuoti susijusius agentus',
        'Spell check' => 'Ra�ybos tikrinimas',
        'Note type' => 'Pastabos tipas',
        'Next state' => 'Sekanti b�sena',
        'Pending date' => '',
        'Date invalid!' => 'Negalima data',

        # Template: AgentTicketActionPopupClose

        # Template: AgentTicketBounce
        'Bounce Ticket' => '',
        'Bounce to' => 'Nukreipti �',
        'You need a email address.' => 'Jums reikia el. pa�to adreso',
        'Need a valid email address or don\'t use a local email address.' => 'Reikalingas galiojantis el. pa�to adresas (arba nenaudokite lokalaus pa�to adreso).',
        'Next ticket state' => 'Sekanti trik�i� b�sena',
        'Inform sender' => 'Informuoti siunt�j�',
        'Send mail!' => 'Si�sti pa�t�!',

        # Template: AgentTicketBulk
        'Ticket Bulk Action' => 'Masinis veiksmas su triktimis',
        'Send Email' => '',
        'Merge to' => 'Sujungti su',
        'Invalid ticket identifier!' => 'Negaliojantis trikties identifikatorius!',
        'Merge to oldest' => 'Prijungti prie seniausio',
        'Link together' => 'Susieti vien� su kitu',
        'Link to parent' => 'Susieti su t�vu (parent)',
        'Unlock tickets' => 'Atrakinti triktis',

        # Template: AgentTicketClose

        # Template: AgentTicketCompose
        'Compose answer for ticket' => 'Sukurti atsakym� trik�iai',
        'Remove Ticket Customer' => '',
        'Please remove this entry and enter a new one with the correct value.' => '',
        'Please include at least one recipient' => '',
        'Remove Cc' => '',
        'Remove Bcc' => '',
        'Address book' => 'Adres� knyga',
        'Pending Date' => '',
        'for pending* states' => '',
        'Date Invalid!' => 'Negalima data!',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'Keisti trikties klient�',
        'Customer Data' => 'Kliento duomenys',
        'Customer user' => 'Kliento naudotojas',

        # Template: AgentTicketEmail
        'Create New Email Ticket' => 'Sukurti nauj� el. pa�to trikt�',
        'From queue' => 'i� eil�s',
        'To customer' => '',
        'Please include at least one customer for the ticket.' => '',
        'Get all' => 'Gauti visus',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Forward ticket: %s - %s' => '',
        'Need a valid email address or don\'t use a local email address' => 'Reikalingas galiojantis el. pa�to adresas (arba nenaudokite lokalaus pa�to adreso).',

        # Template: AgentTicketFreeText

        # Template: AgentTicketHistory
        'History of' => 'Istorija',
        'History Content' => 'Istorijos turinys',
        'Zoom view' => 'Pritraukti ap�valg�',

        # Template: AgentTicketMerge
        'Ticket Merge' => 'Trik�i� suliejimas',
        'You need to use a ticket number!' => 'Turite naudoti trikties numer�!',
        'A valid ticket number is required.' => 'B�tinas galiojantis trikties numeris.',
        'Need a valid email address.' => 'Reikia galiojan�io el. pa�to adreso.',

        # Template: AgentTicketMove
        'Move Ticket' => 'Perkelti trikt�',
        'New Queue' => 'Nauja eil�',

        # Template: AgentTicketNote

        # Template: AgentTicketOverviewMedium
        'Select all' => 'Pa�ym�ti visus',
        'No ticket data found.' => 'Nerasta duomen� apie trikt�',
        'First Response Time' => 'Pirmas atsakymo laikas',
        'Service Time' => 'Aptarnavimo laikas',
        'Update Time' => 'Atnaujinimo laikas',
        '","26' => '',
        'Solution Time' => 'Sprendimo laikas',
        'Move ticket to a different queue' => 'Perkelti trikt� � kit� eil�',
        'Change queue' => 'Pakeisti eil�',

        # Template: AgentTicketOverviewNavBar
        'Change search options' => 'Keisti paie�kos nustatymus',
        'Tickets per page' => 'Trik�i� puslapyje',

        # Template: AgentTicketOverviewPreview

        # Template: AgentTicketOverviewSmall
        'Escalation in' => 'Eskalavimas po',
        'Locked' => 'U�rakintas',

        # Template: AgentTicketOwner

        # Template: AgentTicketPending

        # Template: AgentTicketPhone
        'Create New Phone Ticket' => 'Sukurti nauj� telefonin� trikt�',
        'From customer' => 'Nuo kliento',
        'To queue' => '� eil�',

        # Template: AgentTicketPhoneCommon
        'Phone call' => 'Telefono skambutis',

        # Template: AgentTicketPlain
        'Email Text Plain View' => 'El. lai�ko per�i�ra paprasto teksto re�imu',
        'Plain' => 'Paprastas',
        'Download this email' => 'Atsisi�sti �� el. lai�k�',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'Trikties info.',
        'Accounted time' => 'Apskai�iuotas laikas (Accounted time)',
        'Linked-Object' => 'Susietas objektas',
        'by' => 'pagal',

        # Template: AgentTicketPriority

        # Template: AgentTicketQueue

        # Template: AgentTicketResponsible

        # Template: AgentTicketSearch
        'Search template' => 'Paie�kos �ablonas',
        'Create Template' => 'Sukurti �ablon�',
        'Create New' => 'Sukurti nauj�',
        'Profile link' => '',
        'Save changes in template' => 'I�saugoti pakeitimus �ablone',
        'Add another attribute' => 'Prid�ti dar vien� atribut�',
        'Output' => 'I�vestis',
        'Fulltext' => 'Visas tekstas',
        'Remove' => 'Pa�alinti',
        'Customer User Login' => 'Kliento naudotojo prisijungimas',
        'Created in Queue' => 'Sukurti eil�je',
        'Lock state' => 'U�rakinimo b�sena',
        'Watcher' => 'Steb�tojas',
        'Article Create Time (before/after)' => 'Straipsnio suk�rimo data (prie�/po)',
        'Article Create Time (between)' => 'Straipsnio suk�rimo data (tarp)',
        'Ticket Create Time (before/after)' => 'Trikties suk�rimo data (prie�/po)',
        'Ticket Create Time (between)' => 'Trikties suk�rimo data (tarp)',
        'Ticket Change Time (before/after)' => 'Trikties keitimo data (prie�/po)',
        'Ticket Change Time (between)' => 'Trikties keitimo data (tarp)',
        'Ticket Close Time (before/after)' => 'Trikties u�darymo data (prie�/po)',
        'Ticket Close Time (between)' => 'Trikties u�darymo data (tarp)',
        'Archive Search' => 'Paie�ka archyve',
        'Run search' => '',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Article filter' => 'Straipsni� filtras',
        'Article Type' => 'Straipsnio tipas',
        'Sender Type' => 'Siunt�jo tipas',
        'Save filter settings as default' => 'I�saugoti filtro nustatymus kaip numatytuosius',
        'Ticket Information' => 'Trikties informacija',
        'Linked Objects' => 'Susieti objektai',
        'Article(s)' => 'Straipsnis(-iai)',
        'Change Queue' => 'Pakeisti eil�',
        'Article Filter' => 'Straipsni� Filtras',
        'Add Filter' => 'Prid�ti filtr�',
        'Set' => 'Nustatyti',
        'Reset Filter' => 'Anuliuoti filtr�',
        'Show one article' => 'Rodyti vien� straipsn�',
        'Show all articles' => 'Rodyti visus straipsnius',
        'Unread articles' => 'Neperskaityti straipsniai',
        'No.' => 'Nr.',
        'Unread Article!' => 'Neskaitytas straipsnis!',
        'Incoming message' => '�einanti �inut�',
        'Outgoing message' => 'I�einanti �inut�',
        'Internal message' => 'Vidin� �inut�',
        'Resize' => 'Keisti dyd�',

        # Template: AttachmentBlocker
        'To protect your privacy, active or/and remote content has blocked.' => 'Siekiant apsaugoti J�s� privatum� buvo u�blokuotas aktyvus ir/ar nuotolinis turinys.',
        'Load blocked content.' => '',

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerError
        'Traceback' => '',

        # Template: CustomerFooter
        'Powered by' => 'Powered by',
        'One or more errors occurred!' => 'I�kilo viena ar daugiau problem�!',
        'Close this dialog' => 'U�verti �� dialogo lang�',
        'Could not open popup window. Please disable any popup blockers for this application.' => 'Nepavyko atverti i��okan�io lango. Pra�ome i�jungti visus i��okan�ius langus blokuojan�ias programas.',

        # Template: CustomerHeader

        # Template: CustomerLogin
        'Login' => 'Prisijungti',
        'User name' => 'Naudotojo vardas',
        'Your user name' => 'J�s� naudotojo vardas',
        'Your password' => 'J�s� slapta�odis',
        'Forgot password?' => 'Pamir�ote slapta�od�?',
        'Log In' => 'Prisijungti',
        'Not yet registered?' => 'Neregistruotas?',
        'Sign up now' => 'Prisijunkite',
        'Request new password' => 'Pra�yti naujo slapta�od�io',
        'Your User Name' => 'J�s� Naudotojo Vardas',
        'A new password will be sent to your email address.' => 'Naujas slapta�odis bus nusi�stas � J�s� pa�to d��ut�.',
        'Create Account' => 'Sukurti paskyr�',
        'Please fill out this form to receive login credentials.' => '',
        'How we should address you' => 'Kaip tur�tume � Jus kreiptis?',
        'Your First Name' => 'J�s� vardas',
        'Please supply a first name' => 'Pra�ome pateikti vard�',
        'Your Last Name' => 'J�s� pavard�',
        'Please supply a last name' => 'Pra�ome pateikti pavard�',
        'Your email address (this will become your username)' => '',
        'Please supply a' => 'Pra�ome pateikti:',

        # Template: CustomerNavigationBar
        'Edit personal preferences' => 'Redaguoti asmeninius nustatymus',

        # Template: CustomerPreferences

        # Template: CustomerRichTextEditor

        # Template: CustomerTicketMessage
        'Service level agreement' => 'Aptarnavimo lygio sutartis (SLA)',

        # Template: CustomerTicketOverview
        '","18' => '',
        'Welcome!' => 'Sveiki atvyk�!',
        'Please click the button below to create your first ticket.' => 'Pra�ome paspausti �emiau esant� mytuk�, kad sukurtum�te savo pirm�j� trikties prane�im�.',
        'Create your first ticket' => 'Sukurti pirm�j� trikties prane�im�',

        # Template: CustomerTicketPrint
        'Ticket Print' => 'Spausdinti trikt�',

        # Template: CustomerTicketSearch
        'Profile' => 'Profilis',
        'e. g. 10*5155 or 105658*' => 'pvz. 10*5155 arba 105658*',
        'Customer ID' => 'Kliento ID',
        'Fulltext search in tickets (e. g. "John*n" or "Will*")' => 'Pilno teksto paie�ka triktyse (pvz., "Petr*" arba "Jon*is")',
        'Recipient' => 'Gav�jas',
        'Carbon Copy' => 'Kopija',
        'Time restrictions' => 'Laiko apribojimai',
        'No time settings' => '',
        'Only tickets created' => 'Tik triktys sukurti',
        'Only tickets created between' => 'Tik triktys sukurti tarp',
        'Ticket archive system' => '',
        'Save search as template?' => '',
        'Save as Template?' => 'I�saugoti kaip �ablon�?',
        'Save as Template' => '',
        'Template Name' => '�ablono pavadinimas',
        'Pick a profile name' => '',
        'Output to' => 'Rezultato i�vedimas: ',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort
        'of' => 'i�',
        'Page' => 'Puslapis',
        'Search Results for' => 'Paie�kos rezultatai: ',

        # Template: CustomerTicketZoom
        'Expand article' => 'I�pl�sti straipsn�',
        'Reply' => 'Atsakyti',

        # Template: CustomerWarning

        # Template: Datepicker
        'Invalid date (need a future date)!' => 'Negalima data (turi b�ti ateities data)!',
        'Previous' => 'Buv�s',
        'Sunday' => 'Sekmadienis',
        'Monday' => 'Pirmadienis',
        'Tuesday' => 'Antradienis',
        'Wednesday' => 'Tre�iadienis',
        'Thursday' => 'Ketvirtadienis',
        'Friday' => 'Penktadienis',
        'Saturday' => '�e�tadienis',
        'Su' => 'S',
        'Mo' => 'Pr',
        'Tu' => 'A',
        'We' => 'T',
        'Th' => 'K',
        'Fr' => 'Pn',
        'Sa' => '�',
        'Open date selection' => 'Atverti datos parinkikl�',

        # Template: Error
        'Oops! An Error occurred.' => 'Oi! �vyko klaida.',
        'Error Message' => 'Klaidos prane�imas',
        'You can' => 'J�s galite',
        'Send a bugreport' => 'Si�sti prane�im� apie defekt�',
        'go back to the previous page' => 'Gr��ti prie buvusio puslapio',
        'Error Details' => 'Klaidos smulkmenos',

        # Template: Footer
        'Top of page' => 'Puslapio vir�us',

        # Template: FooterJS
        'If you now leave this page, all open popup windows will be closed, too!' => 'Jeigu dabar u�versite/paliksite �� puslap�, tai visi i��okantys langai taip pat bus u�verti!',
        'A popup of this screen is already open. Do you want to close it and load this one instead?' => '�io ekrano i��okantis langas jau yra atvertas. Ar norite j� u�daryti ir vietoj jo u�krauti ��?',

        # Template: FooterSmall

        # Template: HTMLHead

        # Template: HTMLHeadBlockEvents

        # Template: Header
        'You are logged in as' => 'Prisijung�te kaip',

        # Template: HeaderSmall

        # Template: Installer
        'JavaScript not available' => 'JavaScript ne�jungtas.',
        'In order to experience OTRS, you\'ll need to enable JavaScript in your browser.' => 'Norint geriausios, darbo su OTRS, patirties Jums reikia savo nar�ykl�je �jungti JavaScript.',
        'Database Settings' => 'Duomen� baz�s nustatymai',
        'General Specifications and Mail Settings' => 'Bendrieji reikalavimai ir Pa�to nustatymai',
        'Registration' => '',
        'Welcome to %s' => 'Sveiki atvyk� � %s',
        'Web site' => 'Interneto puslapis',
        'Database check successful.' => 'Duomen� baz�s patikrinimas s�kmingas.',
        'Mail check successful.' => 'El. pa�to patikrinimas s�kmingas.',
        'Error in the mail settings. Please correct and try again.' => 'Klaida pa�to nustatymuose. Pra�ome i�taisyti klaidas ir bandyti i� naujo.',

        # Template: InstallerConfigureMail
        'Configure Outbound Mail' => 'I�einan�io el. pa�to konfig�racija',
        'Outbound mail type' => 'I�einan�io el. pa�to tipas',
        'Select outbound mail type.' => 'Pasirinkite i�einan�io el. pa�to tip�',
        'Outbound mail port' => 'I�einan�io el. pa�to prievadas',
        'Select outbound mail port.' => 'Pasirinkite i�einan�io el. pa�to prievad�',
        'SMTP host' => 'SMTP serveris',
        'SMTP host.' => 'SMTP serveris',
        'SMTP authentication' => 'SMTP autentikacija',
        'Does your SMTP host need authentication?' => 'Ar SMTP serveris reikalauja autentikacijos?',
        'SMTP auth user' => 'SMTP naudotojo autentikacija',
        'Username for SMTP auth.' => 'SMTP naudotojo vardas.',
        'SMTP auth password' => 'SMTP slapta�odis',
        'Password for SMTP auth.' => 'Slapta�odis SMTP autentikacijai.',
        'Configure Inbound Mail' => '�einan�io el. pa�to konfig�racija',
        'Inbound mail type' => '�einan�io el. pa�to tipas',
        'Select inbound mail type.' => 'Pasirinkite �einan�io el. pa�to tip�',
        'Inbound mail host' => 'Gaunamo el. pa�to serveris',
        'Inbound mail host.' => 'Gaunamo el. pa�to serveris.',
        'Inbound mail user' => 'Gaunamo el. pa�to naudotojas',
        'User for inbound mail.' => 'Naudotojas �einan�iam el. pa�tui',
        'Inbound mail password' => '�einan�io el. pa�to naudotojo slapta�odis',
        'Password for inbound mail.' => 'Slapta�odis �einan�iam el. pa�tui.',
        'Result of mail configuration check' => 'El. pa�to konfig�racijos patikrinimo rezultatas',
        'Check mail configuration' => 'Patikrinti el. pa�to konfig�racij�',
        'Skip this step' => 'Praleisti �� �ingsn�',
        'Skipping this step will automatically skip the registration of your OTRS. Are you sure you want to continue?' => '',

        # Template: InstallerDBResult
        'False' => 'Neigiama',

        # Template: InstallerDBStart
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' => '�ia turi b�ti �vestas J�s� duomen� baz�s root naudotojo slapta�odis, jeigu toks yra nustatytas, jeigu ne, tai palikite �� laukel� tu��i�. D�l saugumo, mes, nerekomenduojame naudoti root slapta�od�io. Daugiau informacijos rasite savo duomen� baz�s dokumentacijoje.',
        'Currently only MySQL is supported in the web installer.' => '�iuo metu web-�diegimo s�sajoje palaikomas tik MySQL.',
        'If you want to install OTRS on another database type, please refer to the file README.database.' => 'Jeigu OTRS diegimui norite naudoti kitok� duombaz�s tip� skaitykite fail� README.database',
        'Database-User' => 'Duomen� baz�s naudotojas',
        'New' => 'Naujas',
        'A new database user with limited rights will be created for this OTRS system.' => '�iai OTRS sistemai bus sukurtas naujas, apribotas teises turintis, duomen� baz�s naudotojas.',
        'default \'hot\'' => 'standarti�kai \'hot\'',
        'DB--- host' => 'Duomen� baz�s serveris',
        'Check database settings' => 'Patikrinti duomen� baz�s nustatymus',
        'Result of database check' => 'Duomen� baz�s nustatym� patikrinimo rezultatas',

        # Template: InstallerFinish
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Nor�dami naudoti OTRS turite root naudotojo teis�mis, komandin�je eilut�je (terminale), �vesti �i� komand�.',
        'Restart your webserver' => 'Perkraukite savo web server�.',
        'After doing so your OTRS is up and running.' => 'Atlikus �iuos veiksmus bus paleista OTRS sistema.',
        'Start page' => 'Pradinis puslapis',
        'Your OTRS Team' => 'J�s� OTRS komanda',

        # Template: InstallerLicense
        'Accept license' => 'Sutikti su licenzija',
        'Don\'t accept license' => 'Nesutikti su licenzija',

        # Template: InstallerLicenseText

        # Template: InstallerRegistration
        'Organization' => 'Organizacija',
        'Position' => '',
        'Complete registration and continue' => '',
        'Please fill in all fields marked as mandatory.' => '',

        # Template: InstallerSystem
        'SystemID' => 'SystemID',
        'The identifier of the system. Each ticket number and each HTTP session ID contain this number.' => 'Sistemos identifikacijos numeris. �is numeris bus kiekviename trikties numeryje ir kiekviename HTTP sesijos ID',
        'System FQDN' => 'Sistemos FQDN',
        'Fully qualified domain name of your system.' => 'Pilnas sistemos domeno pavadinimas (Fully qualified domain name).',
        'AdminEmail' => 'Administratoriaus el. pa�to adresas',
        'Email address of the system administrator.' => 'Sistemos administratoriaus el. pa�to adresas.',
        'Log' => '�urnalas (log)',
        'LogModule' => '�urnalo modulis (log module)',
        'Log backend to use.' => '�urnalo posistem�.',
        'LogFile' => '�urnalo failas',
        'Log file location is only needed for File-LogModule!' => '�urnalizavimo failo vieta (log file location) yra reikalinga tik File-LogModule!',
        'Webfrontend' => 'Web s�saja',
        'Default language' => 'Standartin� kalba',
        'Default language.' => 'Standartin� kalba.',
        'CheckMXRecord' => 'Tikrinti MX �ra��',
        'Email addresses that are manually entered are checked against the MX records found in DNS. Don\'t use this option if your DNS is slow or does not resolve public addresses.' => 'Rankiniu b�du �vesti el. pa�to adresai yra patikrinami DNS MX s�ra�uose. Nenaudokite �ios parinkties jeigu J�s� DNS yra l�tas arba neaptarnauja vie�� adres�.',

        # Template: LinkObject
        'Object#' => 'Objekto numeris',
        'Add links' => 'Prid�ti nuorodas',
        'Delete links' => 'I�trinti nuorodas',

        # Template: Login
        'JavaScript Not Available' => 'JavaScript ne�jungtas.',
        'Browser Warning' => 'Nar�ykl�s persp�jimas',
        'The browser you are using is too old.' => 'J�s� naudojama interneto nar�ykl� yra per sena.',
        'OTRS runs with a huge lists of browsers, please upgrade to one of these.' => 'OTRS gali veikti su daugybe nar�ykli�, pra�ome atsinaujinti � vien� i� j�.',
        'Please see the documentation or ask your admin for further information.' => 'Daugiau informacijos ie�kokit dokumentacijoje arba kreipkit�s � administratori�.',
        'Lost your password?' => 'Pamir�ote slapta�od�?',
        'Request New Password' => 'Pra�yti naujo slapta�od�io',
        'Back to login' => 'Gr��ti prie prisijungimo',

        # Template: Motd
        'Message of the Day' => 'Dienos �inut�',

        # Template: NoPermission
        'Insufficient Rights' => 'Nepakankamos teis�s',
        'Back to the previous page' => 'Atgal prie buvusio puslapio',

        # Template: Notify

        # Template: Pagination
        'Show first page' => 'Rodyti pirm� puslap�',
        'Show previous pages' => 'Rodyti ankstesnius puslapius',
        'Show page %s' => 'Rodyti %s puslap�',
        'Show next pages' => 'Rodyti sekan�ius puslapius',
        'Show last page' => 'Rodyti paskutin� puslap�',

        # Template: PictureUpload
        'Need FormID!' => 'Reikia Formos ID!',
        'No file found!' => 'Failas nerastas!',
        'The file is not an image that can be shown inline!' => 'Failas n�ra paveiksl�lis, kur� b�t� galima rodyti tiesiogiai (? inline)',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'atspausdino',

        # Template: PublicDefault

        # Template: Redirect

        # Template: RichTextEditor

        # Template: SpellingInline

        # Template: Test
        'OTRS Test Page' => 'OTRS Bandomasis puslapis',
        'Welcome %s' => 'Sveiki %s',
        'Counter' => 'Skaitliukas',

        # Template: Warning
        'Go back to the previous page' => 'Gr��ti prie buvusio puslapio',

        # SysConfig
        'ACL module that allows closing parent tickets only if all its children are already closed ("State" shows which states are not available for the parent ticket until all child tickets are closed).' => '',
        'Activates a blinking mechanism of the queue that contains the oldest ticket.' => '',
        'Activates lost password feature for agents, in the agent interface.' => '',
        'Activates lost password feature for customers.' => '',
        'Activates support for customer groups.' => '',
        'Activates the article filter in the zoom view to specify which articles should be shown.' => '',
        'Activates the available themes on the system. Value 1 means active, 0 means inactive.' => '',
        'Activates the ticket archive system search in the customer interface.' => '',
        'Activates the ticket archive system to have a faster system by moving some tickets out of the daily scope. To search for these tickets, the archive flag has to be enabled in the ticket search.' => '',
        'Activates time accounting.' => '',
        'Add a note to this ticket' => '',
        'Adds a suffix with the actual year and month to the OTRS log file. A logfile for every month will be created.' => '',
        'Adds customers email addresses to recipients in the ticket compose screen of the agent interface.' => '',
        'Adds the one time vacation days for the indicated calendar. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the one time vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days for the indicated calendar. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Adds the permanent vacation days. Please use single digit pattern for numbers from 1 to 9 (instead of 01 - 09).' => '',
        'Agent Notifications' => 'Prane�imai agentams',
        'Agent interface article notification module to check PGP.' => '',
        'Agent interface article notification module to check S/MIME.' => '',
        'Agent interface module to access fulltext search via nav bar.' => '',
        'Agent interface module to access search profiles via nav bar.' => '',
        'Agent interface module to check incoming emails in the Ticket-Zoom-View if the S/MIME-key is available and true.' => '',
        'Agent interface notification module to check the used charset.' => '',
        'Agent interface notification module to see the number of tickets an agent is responsible for.' => '',
        'Agent interface notification module to see the number of watched tickets.' => '',
        'Agents <-> Groups' => 'Agentai <-> Grup�s',
        'Agents <-> Roles' => 'Agentai <-> Rol�s',
        'Allows adding notes in the close ticket screen of the agent interface.' => '',
        'Allows adding notes in the ticket free text screen of the agent interface.' => '',
        'Allows adding notes in the ticket note screen of the agent interface.' => '',
        'Allows adding notes in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Allows adding notes in the ticket responsible screen of the agent interface.' => '',
        'Allows agents to exchange the axis of a stat if they generate one.' => '',
        'Allows agents to generate individual-related stats.' => '',
        'Allows choosing between showing the attachments of a ticket in the browser (inline) or just make them downloadable (attachment).' => '',
        'Allows choosing the next compose state for customer tickets in the customer interface.' => '',
        'Allows customers to change the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket SLA in the customer interface.' => '',
        'Allows customers to set the ticket priority in the customer interface.' => '',
        'Allows customers to set the ticket queue in the customer interface. If this is set to \'No\', QueueDefault should be configured.' => '',
        'Allows customers to set the ticket service in the customer interface.' => '',
        'Allows defining new types for ticket (if ticket type feature is enabled).' => '',
        'Allows defining services and SLAs for tickets (e. g. email, desktop, network, ...), and escalation attributes for SLAs (if ticket service/SLA feature is enabled).' => '',
        'Allows extended search conditions in ticket search of the agent interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows extended search conditions in ticket search of the customer interface. With this feature you can search w. g. with this kind of conditions like "(key1&&key2)" or "(key1||key2)".' => '',
        'Allows having a medium format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows having a small format ticket overview (CustomerInfo => 1 - shows also the customer information).' => '',
        'Allows the administrators to login as other users, via the users administration panel.' => '',
        'Allows to set a new ticket state in the move ticket screen of the agent interface.' => '',
        'Attachments <-> Responses' => 'Priedai <-> Atsakymai',
        'Auto Responses <-> Queues' => 'Automatiniai atsakymai <-> Eil�s',
        'Automated line break in text messages after x number of chars.' => '',
        'Automatically lock and set owner to current Agent after selecting for an Bulk Action.' => '',
        'Automatically sets the owner of a ticket as the responsible for it (if ticket responsible feature is enabled).' => '',
        'Automatically sets the responsible of a ticket (if it is not set yet) after the first owner update.' => '',
        'Balanced white skin by Felix Niklas.' => '',
        'Blocks all the incoming emails that do not have a valid ticket number in subject with From: @example.com address.' => '',
        'Builds an article index right after the article\'s creation.' => '',
        'CMD example setup. Ignores emails where external CMD returns some output on STDOUT (email will be piped into STDIN of some.bin).' => '',
        'Cache time in seconds for agent authentication in the GenericInterface.' => '',
        'Cache time in seconds for customer authentication in the GenericInterface.' => '',
        'Cache time in seconds for the web service config backend.' => '',
        'Change password' => '',
        'Change queue!' => '',
        'Change the customer for this ticket' => '',
        'Change the free fields for this ticket' => '',
        'Change the owner for this ticket' => '',
        'Change the responsible person for this ticket' => '',
        'Change the ticket priority' => '',
        'Changes the owner of tickets to everyone (useful for ASP). Normally only agent with rw permissions in the queue of the ticket will be shown.' => '',
        'Checkbox' => '',
        'Checks the SystemID in ticket number detection for follow-ups (use "No" if SystemID has been changed after using the system).' => '',
        'Close this ticket' => '',
        'Comment for new history entries in the customer interface.' => '',
        'Companies' => 'Organizacijos',
        'Company Tickets' => 'Organizacijos triktys',
        'Company name for the customer web interface. Will also be included in emails as an X-Header.' => '',
        'Configure your own log text for PGP.' => '',
        'Configures a default TicketDynmicField setting. "Name" defines the dynamic field which should be used, "Value" is the data that will be set, and "Event" defines the trigger event. Please check the developer manual (http://doc.otrs.org/), chapter "Ticket Event Module".' => '',
        'Configures the full-text index. Execute "bin/otrs.RebuildFulltextIndex.pl" in order to generate a new index.' => '',
        'Controls if customers have the ability to sort their tickets.' => '',
        'Converts HTML mails into text messages.' => '',
        'Create and manage Service Level Agreements (SLAs).' => 'Kurti ir valdyti Aptarnavimo Lygio Sutartis (SLA).',
        'Create and manage agents.' => 'Kurti ir valdyti agentus.',
        'Create and manage attachments.' => 'Kurti ir valdyti priedus(attachment).',
        'Create and manage companies.' => 'Kurti ir valdyti organizacijas.',
        'Create and manage customers.' => 'Kurti ir valdyti klientus.',
        'Create and manage dynamic fields.' => '',
        'Create and manage event based notifications.' => 'Kurti ir valdyti nuo �vyki� priklausan�ius prane�imus.',
        'Create and manage groups.' => 'Kurti ir valdyti grupes.',
        'Create and manage notifications that are sent to agents.' => 'Kurti ir valdyti agentams siun�iamus prane�imus.',
        'Create and manage queues.' => 'Kurti ir valdyti eiles.',
        'Create and manage response templates.' => 'Kurti ir valdyti atsakym� �ablonus.',
        'Create and manage responses that are automatically sent.' => 'Kurti ir valdyti automati�kai siun�iamus atsakymus.',
        'Create and manage roles.' => 'Kurti ir valdyti roles.',
        'Create and manage salutations.' => 'Kurti ir valdyti kreipinius � asmenis (salutations).',
        'Create and manage services.' => 'Kurti ir valdyti paslaugas(services).',
        'Create and manage signatures.' => 'Kurti ir valdyti para�us.',
        'Create and manage ticket priorities.' => 'Kurti ir valdyti prioritetus.',
        'Create and manage ticket states.' => 'Kurti ir valdyti trik�i� b�senas.',
        'Create and manage ticket types.' => 'Kurti ir valdyti trik�i� tipus.',
        'Create and manage web services.' => '',
        'Create new email ticket and send this out (outbound)' => 'Sukurti nauj� el. pa�to trikt� ir i�si�sti (i�orinis)',
        'Create new phone ticket (inbound)' => 'Sukurti nauj� telefonu prane�t� trikt� (vidinis)',
        'Custom text for the page shown to customers that have no tickets yet.' => '',
        'Customer item (icon) which shows the open tickets of this customer as info block.' => '',
        'Customers <-> Groups' => 'Klientai <-> Grup�s',
        'Customers <-> Services' => 'Klientai <-> Paslaugos',
        'DEPRECATED! This setting is not used any more and will be removed in a future version of OTRS.' => '',
        'Data used to export the search result in CSV format.' => '',
        'Date / Time' => '',
        'Debugs the translation set. If this is set to "Yes" all strings (text) without translations are written to STDERR. This can be helpful when you are creating a new translation file. Otherwise, this option should remain set to "No".' => '',
        'Default ACL values for ticket actions.' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimePointFormat=year;TicketCreateTimePointStart=Last;TicketCreateTimePoint=2;".' => '',
        'Default data to use on attribute for ticket search screen. Example: "TicketCreateTimeStartYear=2010;TicketCreateTimeStartMonth=10;TicketCreateTimeStartDay=4;TicketCreateTimeStopYear=2010;TicketCreateTimeStopMonth=11;TicketCreateTimeStopDay=3;".' => '',
        'Default loop protection module.' => '',
        'Default queue ID used by the system in the agent interface.' => '',
        'Default skin for OTRS 3.0 interface.' => '',
        'Default skin for interface.' => '',
        'Default ticket ID used by the system in the agent interface.' => '',
        'Default ticket ID used by the system in the customer interface.' => '',
        'Define a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Define the start day of the week for the date picker.' => '',
        'Defines a customer item, which generates a LinkedIn icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a XING icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google icon at the end of a customer info block.' => '',
        'Defines a customer item, which generates a google maps icon at the end of a customer info block.' => '',
        'Defines a default list of words, that are ignored by the spell checker.' => '',
        'Defines a filter for html output to add links behind CVE numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind MSBulletin numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind a defined string. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter for html output to add links behind bugtraq numbers. The element Image allows two input kinds. At once the name of an image (e.g. faq.png). In this case the OTRS image path will be used. The second possiblity is to insert the link to the image.' => '',
        'Defines a filter to process the text in the articles, in order to highlight predefined keywords.' => '',
        'Defines a regular expression that excludes some addresses from the syntax check (if "CheckEmailAddresses" is set to "Yes"). Please enter a regex in this field for email addresses, that aren\'t syntactically valid, but are necessary for the system (i.e. "root@localhost").' => '',
        'Defines a regular expression that filters all email addresses that should not be used in the application.' => '',
        'Defines a useful module to load specific user options or to display news.' => '',
        'Defines all the X-headers that should be scanned.' => '',
        'Defines all the languages that are available to the application. The Key/Content pair links the front-end display name to the appropriate language PM file. The "Key" value should be the base-name of the PM file (i.e. de.pm is the file, then de is the "Key" value). The "Content" value should be the display name for the front-end. Specify any own-defined language here (see the developer documentation http://doc.otrs.org/ for more infomation). Please remember to use the HTML equivalents for non-ASCII characters (i.e. for the German oe = o umlaut, it is necessary to use the &ouml; symbol).' => '',
        'Defines all the parameters for the RefreshTime object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for the ShownTickets object in the customer preferences of the customer interface.' => '',
        'Defines all the parameters for this item in the customer preferences.' => '',
        'Defines all the possible stats output formats.' => '',
        'Defines an alternate URL, where the login link refers to.' => '',
        'Defines an alternate URL, where the logout link refers to.' => '',
        'Defines an alternate login URL for the customer panel..' => '',
        'Defines an alternate logout URL for the customer panel.' => '',
        'Defines an external link to the database of the customer (e.g. \'http://yourhost/customer.php?CID=$Data{"CustomerID"}\' or \'\').' => '',
        'Defines how the From field from the emails (sent from answers and email tickets) should look like.' => '',
        'Defines if a ticket lock is required in the close ticket screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket bounce screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket compose screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket forward screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket free text screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket merge screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket note screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket owner screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket pending screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone inbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket phone outbound screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket priority screen of a zoomed ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required in the ticket responsible screen of the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if a ticket lock is required to change the customer of a ticket in the agent interface (if the ticket isn\'t locked yet, the ticket gets locked and the current agent will be set automatically as its owner).' => '',
        'Defines if composed messages have to be spell checked in the agent interface.' => '',
        'Defines if time accounting is mandatory in the agent interface.' => '',
        'Defines if time accounting must be set to all tickets in bulk action.' => '',
        'Defines scheduler PID update time in seconds (floating point number).' => '',
        'Defines scheduler sleep time in seconds after processing all available tasks (floating point number).' => '',
        'Defines the =hHeight for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the IP regular expression for accessing the local repository. You need to enable this to have access to your local repository and the package::RepositoryList is required on the remote host.' => '',
        'Defines the URL CSS path.' => '',
        'Defines the URL base path of icons, CSS and Java Script.' => '',
        'Defines the URL image path of icons for navigation.' => '',
        'Defines the URL java script path.' => '',
        'Defines the URL rich text editor path.' => '',
        'Defines the address of a dedicated DNS server, if necessary, for the "CheckMXRecord" look-ups.' => '',
        'Defines the body text for notification mails sent to agents, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to agents, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, about new account.' => '',
        'Defines the body text for notification mails sent to customers, about new password (after using this link the new password will be sent).' => '',
        'Defines the body text for notification mails sent to customers, with token about new requested password (after using this link the new password will be sent).' => '',
        'Defines the body text for rejected emails.' => '',
        'Defines the boldness of the line drawed by the graph.' => '',
        'Defines the colors for the graphs.' => '',
        'Defines the column to store the keys for the preferences table.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view.' => '',
        'Defines the config parameters of this item, to be shown in the preferences view. Take care to maintain the dictionaries installed in the system in the data section.' => '',
        'Defines the connections for http/ftp, via a proxy.' => '',
        'Defines the date input format used in forms (option or input fields).' => '',
        'Defines the default CSS used in rich text editors.' => '',
        'Defines the default body of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default front-end (HTML) theme to be used by the agents and customers. The default themes are Standard and Lite. If you like, you can add your own theme. Please refer the administrator manual located at http://doc.otrs.org/.' => '',
        'Defines the default front-end language. All the possible values are determined by the available language files on the system (see the next setting).' => '',
        'Defines the default history type in the customer interface.' => '',
        'Defines the default maximum number of X-axis attributes for the time scale.' => '',
        'Defines the default maximum number of search results shown on the overview page.' => '',
        'Defines the default next state for a ticket after customer follow up in the customer interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the default next state of a ticket after being forwarded, in the ticket forward screen of the agent interface.' => '',
        'Defines the default next state of a ticket if it is composed / answered in the ticket compose screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone inbound screen of the agent interface.' => '',
        'Defines the default note body text for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default priority of follow up customer tickets in the ticket zoom screen in the customer interface.' => '',
        'Defines the default priority of new customer tickets in the customer interface.' => '',
        'Defines the default priority of new tickets.' => '',
        'Defines the default queue for new customer tickets in the customer interface.' => '',
        'Defines the default selection at the drop down menu for dynamic objects (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for permissions (Form: Common Specification).' => '',
        'Defines the default selection at the drop down menu for stats format (Form: Common Specification). Please insert the format key (see Stats::Format).' => '',
        'Defines the default sender type for phone tickets in the ticket phone inbound screen of the agent interface.' => '',
        'Defines the default sender type for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default sender type for tickets in the ticket zoom screen of the customer interface.' => '',
        'Defines the default shown ticket search attribute for ticket search screen.' => '',
        'Defines the default shown ticket search attribute for ticket search screen. Example: a text, 1, DynamicField_Field1StartYear=2002;DynamicField_Field1StartMonth=12;DynamicField_Field1StartDay=12;DynamicField_Field1StartHour=00;DynamicField_Field1StartMinute=00;DynamicField_Field1StartSecond=00;DynamicField_Field1StopYear=2009;DynamicField_Field1StopMonth=02;DynamicField_Field1StopDay=10;DynamicField_Field1StopHour=23;DynamicField_Field1StopMinute=59;DynamicField_Field1StopSecond=59;.' => '',
        'Defines the default sort criteria for all queues displayed in the queue view, after sort by priority is done.' => '',
        'Defines the default sort order for all queues in the queue view, after priority sort.' => '',
        'Defines the default spell checker dictionary.' => '',
        'Defines the default state of new customer tickets in the customer interface.' => '',
        'Defines the default state of new tickets.' => '',
        'Defines the default subject for phone tickets in the ticket phone inbound screen of the agent interface.' => '',
        'Defines the default subject for phone tickets in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default subject of a note in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in a ticket search of the customer interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the escalation view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the locked ticket view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the responsible view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the status view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting in the watch view of the agent interface.' => '',
        'Defines the default ticket attribute for ticket sorting of the ticket search result of the agent interface.' => '',
        'Defines the default ticket bounced notification for customer/sender in the ticket bounce screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone inbound screen of the agent interface.' => '',
        'Defines the default ticket next state after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default ticket order (after priority sort) in the escalation view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order (after priority sort) in the status view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the responsible view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket locked view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the ticket search result of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order in the watch view of the agent interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket order of a search result in the customer interface. Up: oldest on top. Down: latest on top.' => '',
        'Defines the default ticket priority in the close ticket screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket bulk screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket free text screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket note screen of the agent interface.' => '',
        'Defines the default ticket priority in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default ticket priority in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type for article in the customer interface.' => '',
        'Defines the default type of forwarded message in the ticket forward screen of the agent interface.' => '',
        'Defines the default type of the note in the close ticket screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket bulk screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket free text screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket note screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket phone inbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket phone outbound screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the default type of the note in the ticket responsible screen of the agent interface.' => '',
        'Defines the default type of the note in the ticket zoom screen of the customer interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the agent interface.' => '',
        'Defines the default used Frontend-Module if no Action parameter given in the url on the customer interface.' => '',
        'Defines the default value for the action parameter for the public frontend. The action parameter is used in the scripts of the system.' => '',
        'Defines the default viewable sender types of a ticket (default: customer).' => '',
        'Defines the filter that processes the text in the articles, in order to highlight URLs.' => '',
        'Defines the format of responses in the ticket compose screen of the agent interface ($QData{"OrigFrom"} is From 1:1, $QData{"OrigFromName"} is only realname of From).' => '',
        'Defines the fully qualified domain name of the system. This setting is used as a variable, OTRS_CONFIG_FQDN which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the groups every customer user will be in (if CustomerGroupSupport is enabled and you don\'t want to manage every user for these groups).' => '',
        'Defines the height of the legend.' => '',
        'Defines the history comment for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history comment for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone inbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history comment for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the history type for the close ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the email ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the phone ticket screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket free text screen action, which gets used for ticket history.' => '',
        'Defines the history type for the ticket note screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket owner screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket pending screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone inbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket phone outbound screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket priority screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket responsible screen action, which gets used for ticket history in the agent interface.' => '',
        'Defines the history type for the ticket zoom action, which gets used for ticket history in the customer interface.' => '',
        'Defines the hours and week days of the indicated calendar, to count the working time.' => '',
        'Defines the hours and week days to count the working time.' => '',
        'Defines the key to be checked with Kernel::Modules::AgentInfo module. If this user preferences key is true, the message is accepted by the system.' => '',
        'Defines the key to check with CustomerAccept. If this user preferences key is true, then the message is accepted by the system.' => '',
        'Defines the link type \'Normal\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type \'ParentChild\'. If the source name and the target name contain the same value, the resulting link is a non-directional one; otherwise, the result is a directional link.' => '',
        'Defines the link type groups. The link types of the same group cancel one another. Example: If ticket A is linked per a \'Normal\' link with ticket B, then these tickets could not be additionally linked with link of a \'ParentChild\' relationship.' => '',
        'Defines the list of online repositories. Another installations can be used as repository, for example: Key="http://example.com/otrs/public.pl?Action=PublicRepository;File=" and Content="Some Name".' => '',
        'Defines the location to get online repository list for additional packages. The first available result will be used.' => '',
        'Defines the log module for the system. "File" writes all messages in a given logfile, "SysLog" uses the syslog daemon of the system, e.g. syslogd.' => '',
        'Defines the maximal size (in bytes) for file uploads via the browser.' => '',
        'Defines the maximal valid time (in seconds) for a session id.' => '',
        'Defines the maximum number of pages per PDF file.' => '',
        'Defines the maximum size (in MB) of the log file.' => '',
        'Defines the module that shows a generic notify in the agent interface.' => '',
        'Defines the module that shows all the currently loged in customers in the agent interface.' => '',
        'Defines the module that shows all the currently logged in agents in the agent interface.' => '',
        'Defines the module that shows the currently loged in agents in the customer interface.' => '',
        'Defines the module that shows the currently loged in customers in the customer interface.' => '',
        'Defines the module to authenticate customers.' => '',
        'Defines the module to display a notification in the agent interface, (only for agents on the admin group) if the scheduler is not running.' => '',
        'Defines the module to display a notification in the agent interface, if the agent is logged in while having out-of-office active.' => '',
        'Defines the module to display a notification in the agent interface, if the system is used by the admin user (normally you shouldn\'t work as admin).' => '',
        'Defines the module to generate html refresh headers of html sites, in the customer interface.' => '',
        'Defines the module to generate html refresh headers of html sites.' => '',
        'Defines the module to send emails. "Sendmail" directly uses the sendmail binary of your operating system. Any of the "SMTP" mechanisms use a specified (external) mailserver. "DoNotSendEmail" doesn\'t send emails and it is useful for test systems.' => '',
        'Defines the module used to store the session data. With "DB" the frontend server can be splitted from the db server. "FS" is faster.' => '',
        'Defines the name of the application, shown in the web interface, tabs and title bar of the web browser.' => '',
        'Defines the name of the column to store the data in the preferences table.' => '',
        'Defines the name of the column to store the user identifier in the preferences table.' => '',
        'Defines the name of the indicated calendar.' => '',
        'Defines the name of the key for customer sessions.' => '',
        'Defines the name of the session key. E.g. Session, SessionID or OTRS.' => '',
        'Defines the name of the table, where the customer preferences are stored.' => '',
        'Defines the next possible states after composing / answering a ticket in the ticket compose screen of the agent interface.' => '',
        'Defines the next possible states after forwarding a ticket in the ticket forward screen of the agent interface.' => '',
        'Defines the next possible states for customer tickets in the customer interface.' => '',
        'Defines the next state of a ticket after adding a note, in the close ticket screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket bulk screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket free text screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket note screen of the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Defines the next state of a ticket after adding a note, in the ticket responsible screen of the agent interface.' => '',
        'Defines the next state of a ticket after being bounced, in the ticket bounce screen of the agent interface.' => '',
        'Defines the next state of a ticket after being moved to another queue, in the move ticket screen of the agent interface.' => '',
        'Defines the parameters for the customer preferences table.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTL" indicates the cache expiration period in minutes for the plugin.' => '',
        'Defines the parameters for the dashboard backend. "Limit" defines the number of entries displayed by default. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" defines the cache expiration period in minutes for the plugin.' => '',
        'Defines the password to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the path and TTF-File to handle bold italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle bold proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle italic proportional font in PDF documents.' => '',
        'Defines the path and TTF-File to handle monospaced font in PDF documents.' => '',
        'Defines the path and TTF-File to handle proportional font in PDF documents.' => '',
        'Defines the path for scheduler to store its console output (SchedulerOUT.log and SchedulerERR.log).' => '',
        'Defines the path of the shown info file, that is located under Kernel/Output/HTML/Standard/CustomerAccept.dtl.' => '',
        'Defines the path to PGP binary.' => '',
        'Defines the path to open ssl binary. It may need a HOME env ($ENV{HOME} = \'/var/lib/wwwrun\';).' => '',
        'Defines the placement of the legend. This should be a two letter key of the form: \'B[LCR]|R[TCB]\'. The first letter indicates the placement (Bottom or Right), and the second letter the alignment (Left, Right, Center, Top, or Bottom).' => '',
        'Defines the postmaster default queue.' => '',
        'Defines the receipent target of the phone ticket and the sender of the email ticket ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the agent interface.' => '',
        'Defines the receipent target of the tickets ("Queue" shows all queues, "SystemAddress" displays all system addresses) in the customer interface.' => '',
        'Defines the search limit for the stats.' => '',
        'Defines the sender for rejected emails.' => '',
        'Defines the separator between the agents real name and the given queue email address.' => '',
        'Defines the spacing of the legends.' => '',
        'Defines the standard permissions available for customers within the application. If more permissions are needed, you can enter them here. Permissions must be hard coded to be effective. Please ensure, when adding any of the afore mentioned permissions, that the "rw" permission remains the last entry.' => '',
        'Defines the standard size of PDF pages.' => '',
        'Defines the state of a ticket if it gets a follow-up and the ticket was already closed.' => '',
        'Defines the state of a ticket if it gets a follow-up.' => '',
        'Defines the state type of the reminder for pending tickets.' => '',
        'Defines the subject for notification mails sent to agents, about new password.' => '',
        'Defines the subject for notification mails sent to agents, with token about new requested password.' => '',
        'Defines the subject for notification mails sent to customers, about new account.' => '',
        'Defines the subject for notification mails sent to customers, about new password.' => '',
        'Defines the subject for notification mails sent to customers, with token about new requested password.' => '',
        'Defines the subject for rejected emails.' => '',
        'Defines the system administrator\'s email address. It will be displayed in the error screens of the application.' => '',
        'Defines the system identifier. Every ticket number and http session string contain this ID. This ensures that only tickets which belong to your system will be processed as follow-ups (useful when communicating between two instances of OTRS).' => '',
        'Defines the target attribute in the link to external customer database. E.g. \'target="cdb"\'.' => '',
        'Defines the time in days to keep log backup files.' => '',
        'Defines the time in seconds after which the Scheduler performs an automatic self-restart.' => '',
        'Defines the time zone of the indicated calendar, which can be assigned later to a specific queue.' => '',
        'Defines the type of protocol, used by ther web server, to serve the application. If https protocol will be used instead of plain http, it must be specified it here. Since this has no affect on the web server\'s settings or behavior, it will not change the method of access to the application and, if it is wrong, it will not prevent you from logging into the application. This setting is used as a variable, OTRS_CONFIG_HttpType which is found in all forms of messaging used by the application, to build links to the tickets within your system.' => '',
        'Defines the used character for email quotes in the ticket compose screen of the agent interface.' => '',
        'Defines the user identifier for the customer panel.' => '',
        'Defines the username to access the SOAP handle (bin/cgi-bin/rpc.pl).' => '',
        'Defines the valid state types for a ticket.' => '',
        'Defines the valid states for unlocked tickets. To unlock tickets the script "bin/otrs.UnlockTickets.pl" can be used.' => '',
        'Defines the viewable locks of a ticket. Default: unlock, tmp_lock.' => '',
        'Defines the width for the rich text editor component. Enter number (pixels) or percent value (relative).' => '',
        'Defines the width of the legend.' => '',
        'Defines which article sender types should be shown in the preview of a ticket.' => '',
        'Defines which states should be set automatically (Content), after the pending time of state (Key) has been reached.' => '',
        'Defines wich article type should be expanded when entering the overview. If nothing defined, latest article will be expanded.' => '',
        'Delay time between autocomplete queries in milliseconds.' => '',
        'Delete this ticket' => '',
        'Deletes a session if the session id is used with an invalid remote IP address.' => '',
        'Deletes requested sessions if they have timed out.' => '',
        'Determines if the list of possible queues to move to ticket into should be displayed in a dropdown list or in a new window in the agent interface. If "New Window" is set you can add a move note to the ticket.' => '',
        'Determines if the search results container for the autocomplete feature should adjust its width dynamically.' => '',
        'Determines if the statistics module may generate ticket lists.' => '',
        'Determines the next possible ticket states, after the creation of a new email ticket in the agent interface.' => '',
        'Determines the next possible ticket states, after the creation of a new phone ticket in the agent interface.' => '',
        'Determines the next screen after new customer ticket in the customer interface.' => '',
        'Determines the next screen after the follow up screen of a zoomed ticket in the customer interface.' => '',
        'Determines the next screen after the ticket is moved. LastScreenOverview will return to search results, queueview, dashboard or the like, LastScreenView will return to TicketZoom.' => '',
        'Determines the possible states for pending tickets that changed state after reaching time limit.' => '',
        'Determines the strings that will be shown as receipent (To:) of the phone ticket and as sender (From:) of the email ticket in the agent interface. For Queue as NewQueueSelectionType "<Queue>" shows the names of the queues and for SystemAddress "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the strings that will be shown as receipent (To:) of the ticket in the customer interface. For Queue as CustomerPanelSelectionType, "<Queue>" shows the names of the queues, and for SystemAddress, "<Realname> <<Email>>" shows the name and email of the receipent.' => '',
        'Determines the way the linked objects are displayed in each zoom mask.' => '',
        'Determines which options will be valid of the recepient (phone ticket) and the sender (email ticket) in the agent interface.' => '',
        'Determines which queues will be valid for ticket\'s recepients in the customer interface.' => '',
        'Disables sending reminder notifications to the responsible agent of a ticket (Ticket::Responsible needs to be activated).' => '',
        'Disables the web installer (http://yourhost.example.com/otrs/installer.pl), to prevent the system from being hijacked. If set to "No", the system can be reinstalled and the current basic configuration will be used to pre-populate the questions within the installer script. If not active, it also disables the GenericAgent, PackageManager and SQL Box (to avoid the use of destructive queries, such as DROP DATABASE, and also to steal user passwords).' => '',
        'Displays the accounted time for an article in the ticket zoom view.' => '',
        'Dropdown' => '',
        'Dynamic Fields Checkbox Backend GUI' => '',
        'Dynamic Fields Date Time Backend GUI' => '',
        'Dynamic Fields Drop-down Backend GUI' => '',
        'Dynamic Fields GUI' => '',
        'Dynamic Fields Multiselect Backend GUI' => '',
        'Dynamic Fields Overview Limit' => '',
        'Dynamic Fields Text Backend GUI' => '',
        'Dynamic Fields used to export the search result in CSV format.' => '',
        'Dynamic fields limit per page for Dynamic Fields Overview' => '',
        'Dynamic fields options shown in the ticket message screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required. NOTE. If you want to display these fields also in the ticket zoom of the customer interface, you have to enable them in CustomerTicketZoom###AttributesView.' => '',
        'Dynamic fields shown in the ticket close screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket compose screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket email screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket forward screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket free text screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket medium format overview screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket move screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket note screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket owner screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket pending screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket phone inbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket phone outbound screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket phone screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket preview format overview screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket print screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket print screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket priority screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket responsible screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled, 2 = Enabled and required.' => '',
        'Dynamic fields shown in the ticket search overview results screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket search screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket search screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket small format overview screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket zoom screen of the agent interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'Dynamic fields shown in the ticket zoom screen of the customer interface. Possible settings: 0 = Disabled, 1 = Enabled.' => '',
        'DynamicField backend registration.' => '',
        'DynamicField object registration.' => '',
        'Email Addresses' => 'El. pa�to adresai',
        'Enables PDF output. The CPAN module PDF::API2 is required, if not installed, PDF output will be disabled.' => '',
        'Enables PGP support. When PGP support is enabled for signing and securing mail, it is HIGHLY recommended that the web server be run as the OTRS user. Otherwise, there will be problems with the privileges when accessing .gnupg folder.' => '',
        'Enables S/MIME support.' => 'Aktyvuoja S/MIME palaikym�.',
        'Enables customers to create their own accounts.' => '',
        'Enables file upload in the package manager frontend.' => '',
        'Enables or disable the debug mode over frontend interface.' => '',
        'Enables or disables the autocomplete feature for the customer search in the agent interface.' => '',
        'Enables or disables the ticket watcher feature, to keep track of tickets without being the owner nor the responsible.' => '',
        'Enables performance log (to log the page response time). It will affect the system performance. Frontend::Module###AdminPerformanceLog must be enabled.' => '',
        'Enables spell checker support.' => '',
        'Enables ticket bulk action feature for the agent frontend to work on more than one ticket at a time.' => '',
        'Enables ticket bulk action feature only for the listed groups.' => '',
        'Enables ticket responsible feature, to keep track of a specific ticket.' => '',
        'Enables ticket watcher feature only for the listed groups.' => '',
        'Escalation view' => 'Eskalacij� per�i�ra',
        'Event list to be displayed on GUI to trigger generic interface invokers.' => '',
        'Event module registration. For more performance you can define a trigger event (e. g. Event => TicketCreate). This is only possible if all Ticket dynamic fields need the same event.' => '',
        'Example for dynamic dield' => '',
        'Example for dynamic field' => '',
        'Example for free text' => '',
        'Execute SQL statements.' => 'Vykdyti SQL sakinius',
        'Executes follow up checks on In-Reply-To or References headers for mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail attachments checks in  mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up mail body checks in mails that don\'t have a ticket number in the subject.' => '',
        'Executes follow up plain/raw mail checks in mails that don\'t have a ticket number in the subject.' => '',
        'Experimental "Slim" skin which tries to save screen space for power users.' => '',
        'Exports the whole article tree in search result (it can affect the system performance).' => '',
        'Fetches packages via proxy. Overwrites "WebUserAgent::Proxy".' => '',
        'File that is displayed in the Kernel::Modules::AgentInfo module, if located under Kernel/Output/HTML/Standard/AgentInfo.dtl.' => '',
        'Filter incoming emails.' => 'Filtruoti �einan�ius lai�kus.',
        'Forces encoding of outgoing emails (7bit|8bit|quoted-printable|base64).' => '',
        'Forces to choose a different ticket state (from current) after lock action. Define the current state as key, and the next state after lock action as content.' => '',
        'Forces to unlock tickets after being moved to another queue.' => '',
        'Frontend language' => 'S�sajos kalba',
        'Frontend module registration (disable company link if no company feature is used).' => '',
        'Frontend module registration for the agent interface.' => '',
        'Frontend module registration for the customer interface.' => '',
        'Frontend theme' => 'S�sajos tema (I�vaizda)',
        'GenericAgent' => 'Bendrinis agentas (generic agent)',
        'GenericInterface Debugger GUI' => '',
        'GenericInterface Invoker GUI' => '',
        'GenericInterface Operation GUI' => '',
        'GenericInterface TransportHTTPSOAP GUI' => '',
        'GenericInterface Web Service GUI' => '',
        'GenericInterface Webservice History GUI' => '',
        'GenericInterface Webservice Mapping GUI' => '',
        'GenericInterface module registration for the invoker layer.' => '',
        'GenericInterface module registration for the mapping layer.' => '',
        'GenericInterface module registration for the operation layer.' => '',
        'GenericInterface module registration for the transport layer.' => '',
        'Gives end users the possibility to override the separator character for CSV files, defined in the translation files.' => '',
        'Grants access, if the customer ID of the ticket matches the customer user\'s ID and the customer user has group permissions on the queue the ticket is in.' => '',
        'Helps to extend your articles full-text search (From, To, Cc, Subject and Body search). Runtime will do full-text searches on live data (it works fine for up to 50.000 tickets). StaticDB will strip all articles and will build an index after article creation, increasing fulltext searches about 50%. To create an initial index use "bin/otrs.RebuildFulltextIndex.pl".' => '',
        'If "DB" was selected for Customer::AuthModule, a database driver (normally autodetection is used) can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a password to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, a username to connect to the customer table can be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the DSN for the connection to the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the column name for the CustomerPassword in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the crypt type of passwords must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the column for the CustomerKey in the customer table must be specified.' => '',
        'If "DB" was selected for Customer::AuthModule, the name of the table where your customer data should be stored must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the identifiers in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a column for the values in session table must be specified.' => '',
        'If "DB" was selected for SessionModule, a table in database where session data will be stored must be specified.' => '',
        'If "FS" was selected for SessionModule, a directory where the session data will be stored must be specified.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify (by using a RegExp) to strip parts of REMOTE_USER (e. g. for to remove trailing domains). RegExp-Note, $1 will be the new Login.' => '',
        'If "HTTPBasicAuth" was selected for Customer::AuthModule, you can specify to strip leading parts of user names (e. g. for domains like example_domain\user to user).' => '',
        'If "LDAP" was selected for Customer::AuthModule and if you want to add a suffix to every customer login name, specifiy it here, e. g. you just want to write the username user but in your LDAP directory exists user@domain.' => '',
        'If "LDAP" was selected for Customer::AuthModule and special paramaters are needed for the Net::LDAP perl module, you can specify them here. See "perldoc Net::LDAP" for more information about the parameters.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the password for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule and your users have only anonymous access to the LDAP tree, but you want to search through the data, you can do this with a user who has access to the LDAP directory. Specify the username for this special user here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the BaseDN must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the LDAP host can be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, the user identifier must be specified.' => '',
        'If "LDAP" was selected for Customer::AuthModule, user attributes can be specified. For LDAP posixGroups use UID, for non LDAP posixGroups use full user DN.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify access attributes here.' => '',
        'If "LDAP" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "LDAP" was selected for Customer::Authmodule, you can check if the user is allowed to authenticate because he is in a posixGroup, e.g. user needs to be in a group xyz to use OTRS. Specify the group, who may access the system.' => '',
        'If "LDAP" was selected, you can add a filter to each LDAP query, e.g. (mail=*), (objectclass=user) or (!objectclass=computer).' => '',
        'If "Radius" was selected for Customer::AuthModule, the password to authenticate to the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, the radius host must be specified.' => '',
        'If "Radius" was selected for Customer::AuthModule, you can specify if the applications will stop if e. g. a connection to a server can\'t be established due to network problems.' => '',
        'If "Sendmail" was selected as SendmailModule, the location of the sendmail binary and the needed options must be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log facility can be specified.' => '',
        'If "SysLog" was selected for LogModule, a special log sock can be specified (on solaris you may need to use \'stream\').' => '',
        'If "SysLog" was selected for LogModule, the charset that should be used for logging can be specified.' => '',
        'If "file" was selected for LogModule, a logfile must be specified. If the file doesn\'t exist, it will be created by the system.' => '',
        'If a note is added by an agent, sets the state of a ticket in the close ticket screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket bulk screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket free text screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket note screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of a ticket in the ticket responsible screen of the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'If a note is added by an agent, sets the state of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, a password must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, and authentication to the mail server is needed, an username must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the mailhost that sends out the mails must be specified.' => '',
        'If any of the "SMTP" mechanisms was selected as SendmailModule, the port where your mailserver is listening for incoming connections must be specified.' => '',
        'If enabled, OTRS will deliver all CSS files in minified form. WARNING: If you turn this off, there will likely be problems in IE 7, because it cannot load more than 32 CSS files.' => '',
        'If enabled, OTRS will deliver all JavaScript files in minified form.' => '',
        'If enabled, TicketPhone and TicketEmail will be open in new windows.' => '',
        'If enabled, the OTRS version tag will be removed from the HTTP headers.' => '',
        'If enabled, the different overviews (Dashboard, LockedView, QueueView) will automatically refresh after the specified time.' => '',
        'If enabled, the first level of the main menu opens on mouse hover (instead of click only).' => '',
        'If set, this address is used as envelope from header in outgoing notifications. If no address is specified, the envelope from header is empty.' => '',
        'If this regex matches, no message will be send by the autoresponder.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, specify the DSN to this database.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the password to authenticate to this database can be specified.' => '',
        'If you want to use a mirror database for agent ticket fulltext search or to generate stats, the user to authenticate to this database can be specified.' => '',
        'Ignore article with system sender type for new article feature (e. g. auto responses or email notifications).' => '',
        'Includes article create times in the ticket search of the agent interface.' => '',
        'IndexAccelerator: to choose your backend TicketViewAccelerator module. "RuntimeDB" generates each queue view on the fly from ticket table (no performance problems up to approx. 60.000 tickets in total and 6.000 open tickets in the system). "StaticDB" is the most powerful module, it uses an extra ticket-index table that works like a view (recommended if more than 80.000 and 6.000 open tickets are stored in the system). Use the script "bin/otrs.RebuildTicketIndex.pl" for initial index update.' => '',
        'Install ispell or aspell on the system, if you want to use a spell checker. Please specify the path to the aspell or ispell binary on your operating system.' => '',
        'Interface language' => 'S�sajos kalba',
        'It is possible to configure different skins, for example to distinguish between diferent agents, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different skins, for example to distinguish between diferent customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid skin on your system. Please see the example entries for the proper form of the regex.' => '',
        'It is possible to configure different themes, for example to distinguish between agents and customers, to be used on a per-domain basis within the application. Using a regular expression (regex), you can configure a Key/Content pair to match a domain. The value in "Key" should match the domain, and the value in "Content" should be a valid theme on your system. Please see the example entries for the proper form of the regex.' => '',
        'Link agents to groups.' => 'Susieti agentus su grup�mis.',
        'Link agents to roles.' => 'Susieti agentus su rol�mis.',
        'Link attachments to responses templates.' => 'Susieti lai�k� priedus su atsakym� �ablonais.',
        'Link customers to groups.' => 'Susieti klientus su grup�mis.',
        'Link customers to services.' => 'Susieti klientus su paslaugomis(services).',
        'Link queues to auto responses.' => 'Susieti eiles su automatiniais atsakymais.',
        'Link responses to queues.' => 'Susieti atsakymus su eil�mis.',
        'Link roles to groups.' => 'Susieti roles su grup�mis.',
        'Link this ticket to other objects' => '',
        'Links 2 tickets with a "Normal" type link.' => '',
        'Links 2 tickets with a "ParentChild" type link.' => '',
        'List of CSS files to always be loaded for the agent interface.' => '',
        'List of CSS files to always be loaded for the customer interface.' => '',
        'List of IE6-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE7-specific CSS files to always be loaded for the customer interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the agent interface.' => '',
        'List of IE8-specific CSS files to always be loaded for the customer interface.' => '',
        'List of JS files to always be loaded for the agent interface.' => '',
        'List of JS files to always be loaded for the customer interface.' => '',
        'List of default StandardResponses which are assigned automatically to new Queues upon creation.' => '',
        'Log file for the ticket counter.' => '',
        'Mail Accounts' => '',
        'Makes the application check the MX record of email addresses before sending an email or submitting a telephone or email ticket.' => '',
        'Makes the application check the syntax of email addresses.' => '',
        'Makes the picture transparent.' => '',
        'Makes the session management use html cookies. If html cookies are disabled or if the client browser disabled html cookies, then the system will work as usual and append the session id to the links.' => '',
        'Manage PGP keys for email encryption.' => 'Valdyti PGP raktus el. lai�k� �ifravimui.',
        'Manage POP3 or IMAP accounts to fetch email from.' => 'Valdyti POP3 arba IMAP paskyras lai�kams gauti.',
        'Manage S/MIME certificates for email encryption.' => 'Valdyti S/MIME sertifikatus el. lai�k� �ifravimui.',
        'Manage existing sessions.' => 'Valdyti esamas sesijas.',
        'Manage periodic tasks.' => 'Valdyti periodines u�duotis.',
        'Max size (in characters) of the customer information table (phone and email) in the compose screen.' => '',
        'Max size of the subjects in an email reply.' => '',
        'Maximal auto email responses to own email-address a day (Loop-Protection).' => '',
        'Maximal size in KBytes for mails that can be fetched via POP3/POP3S/IMAP/IMAPS (KBytes).' => '',
        'Maximum number of tickets to be displayed in the result of a search in the agent interface.' => '',
        'Maximum number of tickets to be displayed in the result of a search in the customer interface.' => '',
        'Maximum size (in characters) of the customer info table in the queue view.' => '',
        'Maximum size (in characters) of the customer information table in the ticket zoom view.' => '',
        'Merge into a different ticket' => '',
        'Module for To-selection in new ticket screen in the customer interface.' => '',
        'Module to check customer permissions.' => '',
        'Module to check if a user is in a special group. Access is granted, if the user is in the specified group and has ro and rw permissions.' => '',
        'Module to check if arrived emails should be marked as email-internal (because of original forwared internal email it college). ArticleType and SenderType define the values for the arrived email/article.' => '',
        'Module to check the agent responsible of a ticket.' => '',
        'Module to check the group permissions for the access to customer tickets.' => '',
        'Module to check the owner of a ticket.' => '',
        'Module to check the watcher agents of a ticket.' => '',
        'Module to compose signed messages (PGP or S/MIME).' => '',
        'Module to crypt composed messages (PGP or S/MIME).' => '',
        'Module to filter and manipulate incoming messages. Block/ignore all spam email with From: noreply@ address.' => '',
        'Module to filter and manipulate incoming messages. Get a 4 digit number to ticket free text, use regex in Match e. g. From => \'(.+?)@.+?\', and use () as [***] in Set =>.' => '',
        'Module to generate accounted time ticket statistics.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the agent interface.' => '',
        'Module to generate html OpenSearch profile for short ticket search in the customer interface.' => '',
        'Module to generate ticket solution and response time statistics.' => '',
        'Module to generate ticket statistics.' => '',
        'Module to show notifications and escalations (ShownMax: max. shown escalations, EscalationInMinutes: Show ticket which will escalation in, CacheTime: Cache of calculated escalations in seconds).' => '',
        'Module to use database filter storage.' => '',
        'Multiselect' => '',
        'My Tickets' => 'Mano triktys',
        'Name of custom queue. The custom queue is a queue selection of your preferred queues and can be selected in the preferences settings.' => '',
        'New email ticket' => 'Naujas pane�imas el. pa�tu',
        'New phone ticket' => 'Naujas pane�imas telefonu',
        'Next possible ticket states after adding a phone note in the ticket phone inbound screen of the agent interface.' => '',
        'Next possible ticket states after adding a phone note in the ticket phone outbound screen of the agent interface.' => '',
        'Notifications (Event)' => 'Prane�imai (�vyki�)',
        'Number of displayed tickets' => 'Rodom� trik�i� skai�ius',
        'Number of lines (per ticket) that are shown by the search utility in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the agent interface.' => '',
        'Number of tickets to be displayed in each page of a search result in the customer interface.' => '',
        'Overloads (redefines) existing functions in Kernel::System::Ticket. Used to easily add customizations.' => '',
        'Overview Escalated Tickets' => 'Per�i�r�ti eskaluotas triktis',
        'Overview Refresh Time' => '',
        'Overview of all open Tickets.' => 'Per�i�r�ti visas atviras triktis.',
        'PGP Key Management' => '',
        'PGP Key Upload' => '�kelti PGP rakt�',
        'Parameters for the CreateNextMask object in the preference view of the agent interface.' => '',
        'Parameters for the CustomQueue object in the preference view of the agent interface.' => '',
        'Parameters for the FollowUpNotify object in the preference view of the agent interface.' => '',
        'Parameters for the LockTimeoutNotify object in the preference view of the agent interface.' => '',
        'Parameters for the MoveNotify object in the preference view of the agent interface.' => '',
        'Parameters for the NewTicketNotify object in the preferences view of the agent interface.' => '',
        'Parameters for the RefreshTime object in the preference view of the agent interface.' => '',
        'Parameters for the WatcherNotify object in the preference view of the agent interface.' => '',
        'Parameters for the dashboard backend of the new tickets overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket calendar of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket escalation overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface . "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket pending reminder overview of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the dashboard backend of the ticket stats of the agent interface. "Limit" is the number of entries shown by default. "Group" is used to restrict the access to the plugin (e. g. Group: admin;group1;group2;). "Default" determines if the plugin is enabled by default or if the user needs to enable it manually. "CacheTTLLocal" is the cache time in minutes for the plugin.' => '',
        'Parameters for the pages (in which the dynamic fields are shown) of the dynamic fields overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the medium ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the small ticket overview.' => '',
        'Parameters for the pages (in which the tickets are shown) of the ticket preview overview.' => '',
        'Parameters of the example SLA attribute Comment2.' => '',
        'Parameters of the example queue attribute Comment2.' => '',
        'Parameters of the example service attribute Comment2.' => '',
        'Path for the log file (it only applies if "FS" was selected for LoopProtectionModule and it is mandatory).' => '',
        'Path of the file that stores all the settings for the QueueObject object for the agent interface.' => '',
        'Path of the file that stores all the settings for the QueueObject object for the customer interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the agent interface.' => '',
        'Path of the file that stores all the settings for the TicketObject for the customer interface.' => '',
        'Performs the configured action for each event (as an Invoker) for each configured Webservice.' => '',
        'Permitted width for compose email windows.' => '',
        'Permitted width for compose note windows.' => '',
        'Picture-Upload' => '',
        'PostMaster Filters' => 'PostMaster filtrai',
        'PostMaster Mail Accounts' => 'PostMaster el. pa�to paskyros',
        'Print this ticket' => '',
        'Protection against CSRF (Cross Site Request Forgery) exploits (for more info see http://en.wikipedia.org/wiki/Cross-site_request_forgery).' => '',
        'Queue view' => 'Eili� per�i�ra',
        'Refresh Overviews after' => '',
        'Refresh interval' => 'Atnaujinimo intervalas',
        'Replaces the original sender with current customer\'s email address on compose answer in the ticket compose screen of the agent interface.' => '',
        'Required permissions to change the customer of a ticket in the agent interface.' => '',
        'Required permissions to use the close ticket screen in the agent interface.' => '',
        'Required permissions to use the ticket bounce screen in the agent interface.' => '',
        'Required permissions to use the ticket compose screen in the agent interface.' => '',
        'Required permissions to use the ticket forward screen in the agent interface.' => '',
        'Required permissions to use the ticket free text screen in the agent interface.' => '',
        'Required permissions to use the ticket merge screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket note screen in the agent interface.' => '',
        'Required permissions to use the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket phone inbound screen in the agent interface.' => '',
        'Required permissions to use the ticket phone outbound screen in the agent interface.' => '',
        'Required permissions to use the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Required permissions to use the ticket responsible screen in the agent interface.' => '',
        'Resets and unlocks the owner of a ticket if it was moved to another queue.' => '',
        'Responses <-> Queues' => 'Atsakymai <-> Eil�s',
        'Restores a ticket from the archive (only if the event is a state change, from closed to any open available state).' => '',
        'Roles <-> Groups' => 'Rol�s <-> Grup�s',
        'Runs an initial wildcard search of the existing customer users when accessing the AdminCustomerUser module.' => '',
        'Runs the system in "Demo" mode. If set to "Yes", agents can change preferences, such as selection of language and theme via the agent web interface. These changes are only valid for the current session. It will not be possible for agents to change their passwords.' => '',
        'S/MIME Certificate Upload' => '�kelti S/MIME sertifikat�',
        'Saves the attachments of articles. "DB" stores all data in the database (not recommended for storing big attachments). "FS" stores the data on the filesystem; this is faster but the webserver should run under the OTRS user. You can switch between the modules even on a system that is already in production without any loss of data.' => '',
        'Saves the login and password on the session table in the database, if "DB" was selected for SessionModule.' => '',
        'Search backend default router.' => '',
        'Search backend router.' => '',
        'Select your frontend Theme.' => 'Pasirinkite s�sajos tem� (i�vaizd�).',
        'Selects the module to handle uploads via the web interface. "DB" stores all uploads in the database, "FS" uses the file system.' => '',
        'Selects the ticket number generator module. "AutoIncrement" increments the ticket number, the SystemID and the counter are used with SystemID.counter format (e.g. 1010138, 1010139). With "Date" the ticket numbers will be generated by the current date, the SystemID and the counter. The format looks like Year.Month.Day.SystemID.counter (e.g. 200206231010138, 200206231010139). With "DateChecksum"  the counter will be appended as checksum to the string of date and SystemID. The checksum will be rotated on a daily basis. The format looks like Year.Month.Day.SystemID.Counter.CheckSum (e.g. 2002070110101520, 2002070110101535). "Random" generates randomized ticket numbers in the format "SystemID.Random" (e.g. 100057866352, 103745394596).' => '',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Si�sti man prane�im� jeigu klientas atsiun�ia atsak� o a� esu trikties savininkas arba triktis yra atrakinta ir yra vienoje i� mano eili�.',
        'Send notifications to users.' => 'Si�sti prane�imus naudotojams.',
        'Send ticket follow up notifications' => 'Si�sti trik�i� atsakym� (follow-up) prane�imus',
        'Sender type for new tickets from the customer inteface.' => '',
        'Sends agent follow-up notification only to the owner, if a ticket is unlocked (the default is to send the notification to all agents).' => '',
        'Sends all outgoing email via bcc to the specified address. Please use this only for backup reasons.' => '',
        'Sends customer notifications just to the mapped customer. Normally, if no customer is mapped, the latest customer sender gets the notification.' => '',
        'Sends reminder notifications of unlocked ticket after reaching the reminder date (only sent to ticket owner).' => '',
        'Sends the notifications which are configured in the admin interface under "Notfication (Event)".' => '',
        'Set sender email addresses for this system.' => 'Nustatyti �iai sistemai el. pa�to siunt�jo adres�.',
        'Set the default height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set the maximum height (in pixels) of inline HTML articles in AgentTicketZoom.' => '',
        'Set this ticket to pending' => '',
        'Set this to yes if you trust in all your public and private pgp keys, even if they are not certified with a trusted signature.' => '',
        'Sets if ticket owner must be selected by the agent.' => '',
        'Sets the PendingTime of a ticket to 0 if the state is changed to a non-pending state.' => '',
        'Sets the age in minutes (first level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the age in minutes (second level) for highlighting queues that contain untouched tickets.' => '',
        'Sets the configuration level of the administrator. Depending on the config level, some sysconfig options will be not shown. The config levels are in in ascending order: Expert, Advanced, Beginner. The higher the config level is (e.g. Beginner is the highest), the less likely is it that the user can accidentally configure the system in a way that it is not usable any more.' => '',
        'Sets the default article type for new email tickets in the agent interface.' => '',
        'Sets the default article type for new phone tickets in the agent interface.' => '',
        'Sets the default body text for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default body text for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default body text for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default link type of splitted tickets in the agent interface.' => '',
        'Sets the default next state for new phone tickets in the agent interface.' => '',
        'Sets the default next ticket state, after the creation of an email ticket in the agent interface.' => '',
        'Sets the default note text for new telephone tickets. E.g \'New ticket via call\' in the agent interface.' => '',
        'Sets the default priority for new email tickets in the agent interface.' => '',
        'Sets the default priority for new phone tickets in the agent interface.' => '',
        'Sets the default sender type for new email tickets in the agent interface.' => '',
        'Sets the default sender type for new phone ticket in the agent interface.' => '',
        'Sets the default subject for new email tickets (e.g. \'email Outbound\') in the agent interface.' => '',
        'Sets the default subject for new phone tickets (e.g. \'Phone call\') in the agent interface.' => '',
        'Sets the default subject for notes added in the close ticket screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket move screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket note screen of the agent interface.' => '',
        'Sets the default subject for notes added in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the default subject for notes added in the ticket responsible screen of the agent interface.' => '',
        'Sets the default text for new email tickets in the agent interface.' => '',
        'Sets the display order of the different items in the preferences view.' => '',
        'Sets the inactivity time (in seconds) to pass before a session is killed and a user is loged out.' => '',
        'Sets the minimal ticket counter size (if "AutoIncrement" was selected as TicketNumberGenerator). Default is 5, this means the counter starts from 10000.' => '',
        'Sets the minimum number of characters before autocomplete query is sent.' => '',
        'Sets the number of lines that are displayed in text messages (e.g. ticket lines in the QueueZoom).' => '',
        'Sets the number of search results to be displayed for the autocomplete feature.' => '',
        'Sets the options for PGP binary.' => '',
        'Sets the order of the different items in the customer preferences view.' => '',
        'Sets the password for private PGP key.' => '',
        'Sets the prefered time units (e.g. work units, hours, minutes).' => '',
        'Sets the prefix to the scripts folder on the server, as configured on the web server. This setting is used as a variable, OTRS_CONFIG_ScriptAlias which is found in all forms of messaging used by the application, to build links to the tickets within the system.' => '',
        'Sets the responsible agent of the ticket in the close ticket screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket bulk screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket free text screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket note screen of the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the responsible agent of the ticket in the ticket responsible screen of the agent interface.' => '',
        'Sets the service in the close ticket screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket free text screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket note screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the service in the ticket responsible screen of the agent interface (Ticket::Service needs to be activated).' => '',
        'Sets the size of the statistic graph.' => '',
        'Sets the stats hook.' => '',
        'Sets the system time zone (required a system with UTC as system time). Otherwise this is a diff time to the local time.' => '',
        'Sets the ticket owner in the close ticket screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket free text screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket note screen of the agent interface.' => '',
        'Sets the ticket owner in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Sets the ticket owner in the ticket responsible screen of the agent interface.' => '',
        'Sets the ticket type in the close ticket screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket bulk screen of the agent interface.' => '',
        'Sets the ticket type in the ticket free text screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket note screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket owner screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket pending screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket priority screen of a zoomed ticket in the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the ticket type in the ticket responsible screen of the agent interface (Ticket::Type needs to be activated).' => '',
        'Sets the time type which should be shown.' => '',
        'Sets the timeout (in seconds) for http/ftp downloads.' => '',
        'Sets the timeout (in seconds) for package downloads. Overwrites "WebUserAgent::Timeout".' => '',
        'Sets the user time zone per user (required a system with UTC as system time and UTC under TimeZone). Otherwise this is a diff time to the local time.' => '',
        'Sets the user time zone per user based on java script / browser time zone offset feature at login time.' => '',
        'Show a responsible selection in phone and email tickets in the agent interface.' => '',
        'Show article as rich text even if rich text writing is disabled.' => '',
        'Shows a count of icons in the ticket zoom, if the article has attachments.' => '',
        'Shows a link in the menu for subscribing / unsubscribing from a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows linking a ticket with another object in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu that allows merging tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to access the history of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a free text field in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to add a note to a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to close a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to delete a ticket in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to delete a ticket in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to go back in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to lock / unlock a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link in the menu to lock/unlock tickets in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to move a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to print a ticket or an article in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the customer who requested the ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the history of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to see the owner of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the priority of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to see the responsible agent of a ticket in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as pending in the ticket zoom view of the agent interface.' => '',
        'Shows a link in the menu to set a ticket as spam in every ticket overview of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a link in the menu to set the priority of a ticket in every ticket overview of the agent interface.' => '',
        'Shows a link in the menu to zoom a ticket in the ticket overviews of the agent interface.' => '',
        'Shows a link to access article attachments via a html online viewer in the zoom view of the article in the agent interface.' => '',
        'Shows a link to download article attachments in the zoom view of the article in the agent interface.' => '',
        'Shows a link to see a zoomed email ticket in plain text.' => '',
        'Shows a link to set a ticket as spam in the ticket zoom view of the agent interface. Additional access control to show or not show this link can be done by using Key "Group" and Content like "rw:group1;move_into:group2".' => '',
        'Shows a list of all the involved agents on this ticket, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the involved agents on this ticket, in the ticket responsible screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the close ticket screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket free text screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket note screen of the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows a list of all the possible agents (all agents with note permissions on the queue/ticket) to determine who should be informed about this note, in the ticket responsible screen of the agent interface.' => '',
        'Shows a preview of the ticket overview (CustomerInfo => 1 - shows also Customer-Info, CustomerInfoMaxSize max. size in characters of Customer-Info).' => '',
        'Shows all both ro and rw queues in the queue view.' => '',
        'Shows all open tickets (even if they are locked) in the escalation view of the agent interface.' => '',
        'Shows all open tickets (even if they are locked) in the status view of the agent interface.' => '',
        'Shows all the articles of the ticket (expanded) in the zoom view.' => '',
        'Shows all the customer identifiers in a multi-select field (not useful if you have a lot of customer identifiers).' => '',
        'Shows an owner selection in phone and email tickets in the agent interface.' => '',
        'Shows customer history tickets in AgentTicketPhone, AgentTicketEmail and AgentTicketCustomer.' => '',
        'Shows either the last customer article\'s subject or the ticket title in the small format overview.' => '',
        'Shows existing parent/child queue lists in the system in the form of a tree or a list.' => '',
        'Shows the activated ticket attributes in the customer interface (0 = Disabled and 1 = Enabled).' => '',
        'Shows the articles sorted normally or in reverse, under ticket zoom in the agent interface.' => '',
        'Shows the customer user information (phone and email) in the compose screen.' => '',
        'Shows the customer user\'s info in the ticket zoom view.' => '',
        'Shows the message of the day (MOTD) in the agent dashboard. "Group" is used to restrict access to the plugin (e. g. Group: admin;group1;group2;). "Default" indicates if the plugin is enabled by default or if the user needs to enable it manually.' => '',
        'Shows the message of the day on login screen of the agent interface.' => '',
        'Shows the ticket history' => '',
        'Shows the ticket history (reverse ordered) in the agent interface.' => '',
        'Shows the ticket priority options in the close ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the move ticket screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket bulk screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket free text screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket note screen of the agent interface.' => '',
        'Shows the ticket priority options in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the ticket priority options in the ticket responsible screen of the agent interface.' => '',
        'Shows the title fields in the close ticket screen of the agent interface.' => '',
        'Shows the title fields in the ticket free text screen of the agent interface.' => '',
        'Shows the title fields in the ticket note screen of the agent interface.' => '',
        'Shows the title fields in the ticket owner screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket pending screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket priority screen of a zoomed ticket in the agent interface.' => '',
        'Shows the title fields in the ticket responsible screen of the agent interface.' => '',
        'Shows time in long format (days, hours, minutes), if set to "Yes"; or in short format (days, hours), if set to "No".' => '',
        'Shows time use complete description (days, hours, minutes), if set to "Yes"; or just first letter (d, h, m), if set to "No".' => '',
        'Skin' => 'Apvalkalas',
        'Sorts the tickets (ascendingly or descendingly) when a single queue is selected in the queue view and after the tickets are sorted by priority. Values: 0 = ascending (oldest on top, default), 1 = descending (youngest on top). Use the QueueID for the key and 0 or 1 for value.' => '',
        'Spam Assassin example setup. Ignores emails that are marked with SpamAssassin.' => '',
        'Spam Assassin example setup. Moves marked mails to spam queue.' => '',
        'Specifies if an agent should receive email notification of his own actions.' => '',
        'Specifies the background color of the chart.' => '',
        'Specifies the background color of the picture.' => '',
        'Specifies the border color of the chart.' => '',
        'Specifies the border color of the legend.' => '',
        'Specifies the bottom margin of the chart.' => '',
        'Specifies the different article types that will be used in the system.' => '',
        'Specifies the different note types that will be used in the system.' => '',
        'Specifies the directory to store the data in, if "FS" was selected for TicketStorageModule.' => '',
        'Specifies the directory where SSL certificates are stored.' => '',
        'Specifies the directory where private SSL certificates are stored.' => '',
        'Specifies the email address that should be used by the application when sending notifications. The email address is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). You can use the OTRS_CONFIG_FQDN variable as set in your configuation, or choose another email address. Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the left margin of the chart.' => '',
        'Specifies the name that should be used by the application when sending notifications. The sender name is used to build the complete display name for the notification master (i.e. "OTRS Notification Master" otrs@your.example.com). Notifications are messages such as en::Customer::QueueUpdate or en::Agent::Move.' => '',
        'Specifies the path of the file for the logo in the page header (gif|jpg|png, 700 x 100 pixel).' => '',
        'Specifies the path of the file for the performance log.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Excel files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of Microsoft Word files, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of PDF documents, in the web interface.' => '',
        'Specifies the path to the converter that allows the view of XML files, in the web interface.' => '',
        'Specifies the right margin of the chart.' => '',
        'Specifies the text color of the chart (e. g. caption).' => '',
        'Specifies the text color of the legend.' => '',
        'Specifies the text that should appear in the log file to denote a CGI script entry.' => '',
        'Specifies the top margin of the chart.' => '',
        'Specifies user id of the postmaster data base.' => '',
        'Standard available permissions for agents within the application. If more permissions are needed, they can be entered here. Permissions must be defined to be effective. Some other good permissions have also been provided built-in: note, close, pending, customer, freetext, move, compose, responsible, forward, and bounce. Make sure that "rw" is always the last registered permission.' => '',
        'Start number for statistics counting. Every new stat increments this number.' => '',
        'Starts a wildcard search of the active object after the link object mask is started.' => '',
        'Statistics' => 'Statistika',
        'Status view' => 'Status� per�i�ra',
        'Stores cookies after the browser has been closed.' => '',
        'Strips empty lines on the ticket preview in the queue view.' => '',
        'Textarea' => '',
        'The "bin/PostMasterMailAccount.pl" will reconnect to POP3/POP3S/IMAP/IMAPS host after the specified count of messages.' => '',
        'The agent skin\'s InternalName which should be used in the agent interface. Please check the available skins in Frontend::Agent::Skins.' => '',
        'The customer skin\'s InternalName which should be used in the customer interface. Please check the available skins in Frontend::Customer::Skins.' => '',
        'The divider between TicketHook and ticket number. E.g \': \'.' => '',
        'The duration in minutes after emitting an event, in which the new escalation notify and start events are suppressed.' => '',
        'The format of the subject. \'Left\' means \'[TicketHook#:12345] Some Subject\', \'Right\' means \'Some Subject [TicketHook#:12345]\', \'None\' means \'Some Subject\' and no ticket number. In the last case you should enable PostmasterFollowupSearchInRaw or PostmasterFollowUpSearchInReferences to recognize followups based on email headers and/or body.' => '',
        'The headline shown in the customer interface.' => '',
        'The identifier for a ticket, e.g. Ticket#, Call#, MyTicket#. The default is Ticket#.' => '',
        'The logo shown in the header of the agent interface. The URL to the image can be a relative URL to the skin image directory, or a full URL to a remote web server.' => '',
        'The logo shown in the header of the customer interface. The URL to the image can be a relative URL to the skin image directory, or a full URL to a remote web server.' => '',
        'The logo shown on top of the login box of the agent interface. The URL to the image must be relative URL to the skin image directory.' => '',
        'The text at the beginning of the subject in an email reply, e.g. RE, AW, or AS.' => '',
        'The text at the beginning of the subject when an email is forwarded, e.g. FW, Fwd, or WG.' => '',
        'This module and its PreRun() function will be executed, if defined, for every request. This module is useful to check some user options or to display news about new applications.' => '',
        'This setting allows you to override the built-in country list with your own list of countries. This is particularly handy if you just want to use a small select group of countries.' => '',
        'Ticket event module that triggers the escalation stop events.' => '',
        'Ticket overview' => 'Trik�i� per�i�ra',
        'Tickets' => 'Triktys',
        'Time in seconds that gets added to the actual time if setting a pending-state (default: 86400 = 1 day).' => '',
        'Toolbar Item for a shortcut.' => '',
        'Turns on the animations used in the GUI. If you have problems with these animations (e.g. performance issues), you can turn them off here.' => '',
        'Turns on the remote ip address check. It should be set to "No" if the application is used, for example, via a proxy farm or a dialup connection, because the remote ip address is mostly different for the requests.' => '',
        'Types' => 'Tipai',
        'Update Ticket "Seen" flag if every article got seen or a new Article got created.' => '',
        'Update and extend your system with software packages.' => 'Atnaujinkite ir i�pl�skite savo sistem� programin�s �rangos paketais.',
        'Updates the ticket escalation index after a ticket attribute got updated.' => '',
        'Updates the ticket index accelerator.' => '',
        'Uses Cc recipients in reply Cc list on compose an email answer in the ticket compose screen of the agent interface.' => '',
        'Uses richtext for viewing and editing: articles, salutations, signatures, standard responses, auto responses and notifications.' => '',
        'View performance benchmark results.' => 'Per�i�r�ti na�umo rodikli� rezultatus.',
        'View system log messages.' => 'Per�i�r�ti sistemos registravimo �urnalo �inutes.',
        'Wear this frontend skin' => '',
        'Webservice path separator.' => '',
        'When tickets are merged, a note will be added automatically to the ticket which is no longer active. In this text area you can define this text (This text cannot be changed by the agent).' => '',
        'When tickets are merged, the customer can be informed per email by setting the check box "Inform Sender". In this text area, you can define a pre-formatted text which can later be modified by the agents.' => '',
        'Your language' => 'J�s kalbate',
        'Your queue selection of your favorite queues. You also get notified about those queues via email if enabled.' => 'J�s� m�gstamiausi� eili� rinkinys. Taip pat b�site informuoti apie �ias eiles jei �jungsite (�galinsite) toki� funkcij�.',

        #
        # OBSOLETE ENTRIES FOR REFERENCE, DO NOT TRANSLATE!
        #
        'Bounce Ticket: ' => 'Nukreipti trikt�:',
        'Create/Expires' => 'Sukurti/Baigiasi galiojimas',
        'Filter for Language' => 'Filtruoti kalbas',
        'Forward ticket: ' => 'Persi�sti trikt�:',
        'Hash/Fingerprint' => 'He�as (hash)/ Pir�to atspaudas',
        'Link this ticket to other objects!' => 'Susieti �i� trikt� su kitais objektais',
        'Lock it to work on it!' => 'U�rakinkite, kad su juo dirbtum�te!',
        'Max. displayed tickets' => 'Daugiausia rodoma trik�i�',
        'New TicketFreeFields' => 'Nauji laisvi trik�i� laukeliai',
        'Online' => 'Prisijung�',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paketas i�skleistas neteisingai! Tur�tum�te i� naujo �diegti �� paket�!',
        'Package not correctly deployed! You should reinstall the package again!' => 'Netinkamai �diegtas paketas! Tur�tum�te �diegti i� naujo!',
        'Please fill out this form to recieve login credentials.' => 'Pra�ome u�pildyti �i� form�, kad gautum�te prisijungimo duomenis.',
        'QueueView Refresh Time' => 'Eil� per�i�ros atnaujinimo laikas',
        'Run Search' => 'Prad�ti paie�k�',
        'Search Ticket' => 'Ie�koti trik�i�',
        'Search for customers (wildcards are allowed).' => 'Ie�koti klient� (galima naudoti pakaitas (wildcards)).',
        'Search-Profile as Template?' => 'Paie�kos profilis kaip �ablonas?',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Pasir�pinkite standartini� b�sen� Kernel/Config.pm atnaujinimu!',
        'The User Name you wish to have' => 'J�s� pageidaujamas naudotojo vardas',
        'TicketFreeFields' => 'Trik�i� laisvi laukeliai',
        'Unlock to give it back to the queue!' => 'Atrakinkite, kad gra�intum�te j� atgal � eil�!',
        'Wildcards are allowed.' => 'Leid�iamos pakaitos (wildcard).',

    };
    # $$STOP$$
    return;
}

1;
