/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import net.sourceforge.helpgui.HelpGui;
import net.sourceforge.helpgui.gui.HelpView;
import net.sourceforge.helpgui.gui.TestRolloverButton;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.page.PageBookMarks;
import net.sourceforge.helpgui.parser.TocOpen;
import net.sourceforge.helpgui.util.Language;
import net.sourceforge.helpgui.util.Out;

public class MainFrame
extends JFrame
implements ActionListener {
    public String version = "1.11";
    protected JButton jbPrev;
    protected JButton jbNext;
    protected JButton jbHome;
    protected JButton jbPrint;
    protected JButton jbBookmarks;
    JMenu menuBookMarks;
    protected HelpView helpView;
    public static String helpPath = "/docs/help";
    public static String iconsPath = "java";

    public MainFrame() {
        super("Help Gui");
        this.initFrame("/docs/help", iconsPath);
    }

    public MainFrame(String helpPath) {
        super("Help Gui");
        this.initFrame(helpPath, iconsPath);
    }

    public MainFrame(String helpPath, String iconsPath) {
        super("Help Gui");
        this.initFrame(helpPath, iconsPath);
    }

    public void initFrame(String sHelpPath, String sIconsPath) {
        if (helpPath.endsWith("/")) {
            helpPath = helpPath.substring(0, helpPath.length() - 1);
        }
        helpPath = sHelpPath;
        iconsPath = sIconsPath;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainFrame.this.setVisible(false);
            }
        });
        URL[] iconURL = new URL[11];
        int i22 = 0;
        while (i22 < 11) {
            iconURL[i22] = null;
            ++i22;
        }
        try {
            iconURL[0] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/previous.gif");
            iconURL[1] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/previous_gray.gif");
            iconURL[2] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/next.gif");
            iconURL[3] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/next_gray.gif");
            iconURL[4] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/home.gif");
            iconURL[5] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/home_gray.gif");
            iconURL[6] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/print.gif");
            iconURL[7] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/print_gray.gif");
            iconURL[8] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/addbookmarks.gif");
            iconURL[9] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/addbookmarks_gray.gif");
            iconURL[10] = this.getClass().getResource("/net/sourceforge/helpgui/icons/" + iconsPath + "/close.gif");
        }
        catch (Exception i22) {
            // empty catch block
        }
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(Language.getInstance().getText("file"));
        JMenu menuAction = new JMenu(Language.getInstance().getText("action"));
        this.menuBookMarks = new JMenu(Language.getInstance().getText("bookmarks"));
        menuBar.add(menuFile);
        menuBar.add(menuAction);
        menuBar.add(this.menuBookMarks);
        menuFile.add(new JMenuItem(Language.getInstance().getText("print"), iconURL[6] != null ? new ImageIcon(iconURL[6]) : null)).addActionListener(this);
        menuFile.add(new JMenuItem(Language.getInstance().getText("quit"), iconURL[10] != null ? new ImageIcon(iconURL[10]) : null)).addActionListener(this);
        menuAction.add(new JMenuItem(Language.getInstance().getText("previous"), iconURL[0] != null ? new ImageIcon(iconURL[0]) : null)).addActionListener(this);
        menuAction.add(new JMenuItem(Language.getInstance().getText("next"), iconURL[2] != null ? new ImageIcon(iconURL[2]) : null)).addActionListener(this);
        menuAction.add(new JMenuItem(Language.getInstance().getText("home"), iconURL[4] != null ? new ImageIcon(iconURL[4]) : null)).addActionListener(this);
        this.menuBookMarks.add(new JMenuItem(Language.getInstance().getText("addBookmarks"), iconURL[8] != null ? new ImageIcon(iconURL[8]) : null)).addActionListener(this);
        this.menuBookMarks.addSeparator();
        this.jbPrev = new TestRolloverButton(iconURL[0] != null ? new ImageIcon(iconURL[0]) : null, (Icon)(iconURL[1] != null ? new ImageIcon(iconURL[1]) : null));
        this.jbNext = new TestRolloverButton(iconURL[2] != null ? new ImageIcon(iconURL[2]) : null, (Icon)(iconURL[3] != null ? new ImageIcon(iconURL[3]) : null));
        this.jbHome = new TestRolloverButton(iconURL[4] != null ? new ImageIcon(iconURL[4]) : null, (Icon)(iconURL[5] != null ? new ImageIcon(iconURL[5]) : null));
        this.jbPrint = new TestRolloverButton(iconURL[6] != null ? new ImageIcon(iconURL[6]) : null, (Icon)(iconURL[7] != null ? new ImageIcon(iconURL[7]) : null));
        this.jbBookmarks = new TestRolloverButton(iconURL[8] != null ? new ImageIcon(iconURL[8]) : null, (Icon)(iconURL[9] != null ? new ImageIcon(iconURL[9]) : null));
        this.jbPrev.addActionListener(this);
        this.jbNext.addActionListener(this);
        this.jbHome.addActionListener(this);
        this.jbPrint.addActionListener(this);
        this.jbBookmarks.addActionListener(this);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setBorderPainted(true);
        toolBar.add(this.jbPrev);
        toolBar.add(this.jbNext);
        toolBar.add(this.jbHome);
        toolBar.add(this.jbPrint);
        toolBar.add(this.jbBookmarks);
        this.jbPrev.setToolTipText(Language.getInstance().getText("previous"));
        this.jbNext.setToolTipText(Language.getInstance().getText("next"));
        this.jbHome.setToolTipText(Language.getInstance().getText("home"));
        this.jbPrint.setToolTipText(Language.getInstance().getText("print"));
        this.jbBookmarks.setToolTipText(Language.getInstance().getText("addBookmarks"));
        this.helpView = new HelpView();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add((Component)this.helpView, "Center");
        this.pack();
        this.setLocation(100, 100);
        Out.msg("Construction of the GUI", Out.OK);
        try {
            TocOpen opener = new TocOpen(this.helpView);
            opener.load();
            Out.msg("Loading the Table of Content", Out.OK);
        }
        catch (Exception e) {
            Out.msg("Table of Content XML parsing", Out.FAILED);
            System.out.println(e);
        }
        this.helpView.goHome();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getSource().equals(this.jbPrev)) {
                this.helpView.previousPage();
            } else if (e.getSource().equals(this.jbNext)) {
                this.helpView.nextPage();
            } else if (e.getSource().equals(this.jbHome)) {
                this.helpView.goHome();
            } else if (e.getSource().equals(this.jbPrint)) {
                this.helpView.print();
            } else if (e.getSource().equals(this.jbBookmarks)) {
                this.addBookMarks();
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = e.getActionCommand();
            if (arg.equals(Language.getInstance().getText("previous"))) {
                this.helpView.previousPage();
            } else if (arg.equals(Language.getInstance().getText("next"))) {
                this.helpView.nextPage();
            } else if (arg.equals(Language.getInstance().getText("home"))) {
                this.helpView.goHome();
            } else if (arg.equals(Language.getInstance().getText("print"))) {
                this.helpView.print();
            } else if (arg.equals(Language.getInstance().getText("quit"))) {
                this.quit();
            } else if (arg.equals(Language.getInstance().getText("addBookmarks"))) {
                this.addBookMarks();
            } else {
                this.helpView.updatePage(PageBookMarks.getInstance().getBookMark((JMenuItem)e.getSource()), true);
            }
        }
    }

    public void quit() {
        if (HelpGui.debug) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public void addBookMarks() {
        Page page = this.helpView.getCurrentPage();
        if (page == null) {
            return;
        }
        JMenuItem menuItem = new JMenuItem(this.helpView.getCurrentPage().getBookMarkLabel());
        menuItem.addActionListener(this);
        this.menuBookMarks.add(menuItem);
        PageBookMarks.getInstance().addBookMark(menuItem, this.helpView.getCurrentPage());
    }
}

